(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8974,        276]
NotebookOptionsPosition[      5361,        179]
NotebookOutlinePosition[      8398,        255]
CellTagsIndexPosition[      8307,        249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Input" :> Documentation`HelpLookup["paclet:ref/Input"], 
          "InputString" :> 
          Documentation`HelpLookup["paclet:ref/InputString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Input\"\>", 
       2->"\<\"InputString\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Requesting Input", "Title",
 CellTags->{"S2.9.20", "20.1"},
 CellID->18990],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " usually works by taking whatever input you give, and then processing it. \
Sometimes, however, you may want to have a program you write explicitly \
request more input. You can do this using ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->10002],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Input",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Input"], "[", "]"}], Cell[
    "read an expression as input", "TableText"]},
   {
    RowBox[{
     ButtonBox["InputString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputString"], "[", "]"}], Cell[
    "read a string as input", "TableText"]},
   {
    RowBox[{
     ButtonBox["Input",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Input"], "[", "\"\<\!\(\*
StyleBox[\"prompt\", \"TI\"]\)\>\"", "]"}], Cell[
    "issue a prompt, then read an expression", "TableText"]},
   {
    RowBox[{
     ButtonBox["InputString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputString"], "[", "\"\<\!\(\*
StyleBox[\"prompt\", \"TI\"]\)\>\"", "]"}], Cell[
    "issue a prompt then read a string", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->15568],

Cell["Interactive input. ", "Caption",
 CellID->4422],

Cell[TextData[{
 "Exactly how ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " work depends on the computer system and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interface you are using. With a text\[Hyphen]based interface, they \
typically just wait for standard input, terminated with a newline. With a \
notebook interface, however, they typically get the front end to put up a \
\[OpenCurlyDoubleQuote]dialog box\[CloseCurlyDoubleQuote], in which the user \
can enter input. "
}], "Text",
 CellID->16895],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " is intended for reading complete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. ",
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 ", on the other hand, is for reading arbitrary strings. "
}], "Text",
 CellID->6135],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->469634054],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Requesting Input - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GeneratingUnstructuredOutput"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Messages"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 21.6064930}", "context" -> "", 
    "keywords" -> {
     "dialog boxes", "front end", "input", "InputString", 
      "notebook interface", "reading input", "requesting input", 
      "Textbased interface"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica usually works by taking whatever input you give, and then \
processing it. Sometimes, however, you may want to have a program you write \
explicitly request more input. You can do this using Input and InputString. \
Interactive input. Exactly how Input and InputString work depends on the \
computer system and Mathematica interface you are using. With a text-based \
interface, they typically just wait for standard input, terminated with a \
newline. With a notebook interface, however, they typically get the front end \
to put up a 'dialog box', in which the user can enter input. ", "synonyms" -> 
    {"2.9.20"}, "title" -> "Requesting Input", "type" -> "Tutorial", "uri" -> 
    "tutorial/RequestingInput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.20"->{
  Cell[1923, 60, 81, 2, 70, "Title",
   CellTags->{"S2.9.20", "20.1"},
   CellID->18990]},
 "20.1"->{
  Cell[1923, 60, 81, 2, 70, "Title",
   CellTags->{"S2.9.20", "20.1"},
   CellID->18990]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.20", 8091, 238},
 {"20.1", 8193, 242}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1298, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1923, 60, 81, 2, 70, "Title",
 CellTags->{"S2.9.20", "20.1"},
 CellID->18990],
Cell[2007, 64, 543, 17, 70, "Text",
 CellID->10002],
Cell[2553, 83, 1226, 36, 70, "DefinitionBox",
 CellID->15568],
Cell[3782, 121, 53, 1, 70, "Caption",
 CellID->4422],
Cell[3838, 124, 725, 20, 70, "Text",
 CellID->16895],
Cell[4566, 146, 463, 16, 70, "Text",
 CellID->6135],
Cell[CellGroupData[{
Cell[5054, 166, 72, 1, 70, "RelatedTutorialsSection",
 CellID->469634054],
Cell[5129, 169, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[5334, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

