(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9659,        342]
NotebookOptionsPosition[      6142,        235]
NotebookOutlinePosition[      8576,        301]
CellTagsIndexPosition[      8485,        295]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series, Limits and Residues" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Residue" :> Documentation`HelpLookup["paclet:ref/Residue"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Residue\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Residues", "Title",
 CellTags->{"S3.6.10", "10.1"},
 CellID->18008],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["x", "TI"], "->", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["0", "TR"]]}]}], "]"}]], "InlineFormula"],
 " tells you what the value of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is when ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " tends to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"],
 ". When this value is infinite, it is often useful instead to know the ",
 StyleBox["residue",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " when ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " equals ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"],
 ". The residue is given by the coefficient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SubscriptBox["x", "0"]}], ")"}], 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 " in the power series expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " about the point ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->12361],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Residue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Residue"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", "]"}], Cell[TextData[{
     "the residue of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " when ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " equals ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16742],

Cell["Computing residues. ", "Caption",
 CellID->22194],

Cell["The residue here is equal to 1. ", "MathCaption",
 CellID->23699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23188],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->20178]
}, Open  ]],

Cell["The residue here is zero. ", "MathCaption",
 CellID->4042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->31357],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->23941]
}, Open  ]],

Cell["Residues can be computed at the point at infinity.", "MathCaption",
 CellID->448185471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "ComplexInfinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->545554266],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->81353729]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->353281843],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Residues - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FindingLimits"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 21.9033756}", "context" -> "", 
    "keywords" -> {
     "Cauchy's theorem", "Cauchy theorem", "complex functions", "poles", 
      "residue"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Limit[expr,x->x_0] tells you what the value of expr is when x tends to \
x_0. When this value is infinite, it is often useful instead to know the \
residue of expr when x equals x_0. The residue is given by the coefficient of \
(x-x_0)^-1 in the power series expansion of expr about the point x_0. \
Computing residues. The residue here is equal to 1. ", 
    "synonyms" -> {"3.6.10"}, "title" -> "Residues", "type" -> "Tutorial", 
    "uri" -> "tutorial/Residues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.10"->{
  Cell[1829, 59, 73, 2, 70, "Title",
   CellTags->{"S3.6.10", "10.1"},
   CellID->18008]},
 "10.1"->{
  Cell[1829, 59, 73, 2, 70, "Title",
   CellTags->{"S3.6.10", "10.1"},
   CellID->18008]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.10", 8269, 284},
 {"10.1", 8371, 288}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1204, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1829, 59, 73, 2, 70, "Title",
 CellTags->{"S3.6.10", "10.1"},
 CellID->18008],
Cell[1905, 63, 1442, 53, 70, "Text",
 CellID->12361],
Cell[3350, 118, 925, 29, 70, "DefinitionBox",
 CellID->16742],
Cell[4278, 149, 55, 1, 70, "Caption",
 CellID->22194],
Cell[4336, 152, 71, 1, 70, "MathCaption",
 CellID->23699],
Cell[CellGroupData[{
Cell[4432, 157, 196, 7, 28, "Input",
 CellID->23188],
Cell[4631, 166, 155, 5, 36, "Output",
 CellID->20178]
}, Open  ]],
Cell[4801, 174, 64, 1, 70, "MathCaption",
 CellID->4042],
Cell[CellGroupData[{
Cell[4890, 179, 221, 8, 28, "Input",
 CellID->31357],
Cell[5114, 189, 155, 5, 36, "Output",
 CellID->23941]
}, Open  ]],
Cell[5284, 197, 93, 1, 70, "MathCaption",
 CellID->448185471],
Cell[CellGroupData[{
Cell[5402, 202, 214, 7, 70, "Input",
 CellID->545554266],
Cell[5619, 211, 175, 6, 36, "Output",
 CellID->81353729]
}, Open  ]],
Cell[CellGroupData[{
Cell[5831, 222, 72, 1, 70, "RelatedTutorialsSection",
 CellID->353281843],
Cell[5906, 225, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[6115, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

