(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35952,       1300]
NotebookOptionsPosition[     19685,        766]
NotebookOutlinePosition[     29303,       1061]
CellTagsIndexPosition[     29063,       1049]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Restricting and Reserving Licenses", "Title",
 CellTags->"i:1",
 CellID->263699052],

Cell[CellGroupData[{

Cell["Writing a Restriction Script", "Section",
 CellTags->{"i:14", "b:2.2.0", "net: 1"},
 CellID->33819112],

Cell[TextData[{
 "Restriction scripts can be very useful in managing sitewide installations \
of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". They can be used to prevent access to ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "by unauthorized users on the network and to guarantee license availability \
to particular users. Restriction scripts are cross-platform compatible, \
provide unambiguous control, and require no programming experience to write. \
The syntax of the restriction scripts is very similar to that of the ",
 StyleBox[".htaccess", "InlineCode"],
 " files used in web servers for controlling access to HTML files. "
}], "Text",
 CellTags->"b:2.2.0",
 CellID->686025895],

Cell["\<\
The layout of a typical restriction script is as follows. Sample restriction \
scripts follow the definitions.\
\>", "Text",
 CellTags->"b:2.2.0",
 CellID->182301266],

Cell["\<\
AuthName Sample
AuthGroupFile mathlmgroup.txt

# Precedence
order ( allow,deny | deny,allow )

# Machine restriction 
allow from ( all | machines ... )
allow hostgroup machinegroups ... 
deny from ( all | machines ... )
deny hostgroup machinegroups ... 

# User restriction 
allow user ( all | users ... )
allow group usergroups ... 
deny user ( all | users ... )
deny group usergroups ... 

# License reservation 
reserve [count] from machines ... 
reserve [count] hostgroup machinegroups ...
reserve [count] user users ... 
reserve [count] group usergroups ...\
\>", "Program",
 CellTags->"b:2.2.0",
 CellID->238736929],

Cell[CellGroupData[{

Cell["Defining the Terms", "Subsection",
 CellTags->"b:2.2.0",
 CellID->462862741],

Cell[TextData[StyleBox["AuthName Sample", "InlineCode"]], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:2.2.0",
 CellID->463745213],

Cell["Defines the name of the script.", "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->34926882],

Cell[TextData[StyleBox["AuthGroupFile mathlmgroup.txt", "InlineCode"]], \
"ItemizedText",
 CellTags->"b:2.2.0",
 CellID->663310220],

Cell[TextData[{
 "Specifies the file containing definitions for groups of users or machines. \
This line is only required in conjunction with the ",
 StyleBox["group", "InlineCode"],
 " or ",
 StyleBox["hostgroup", "InlineCode"],
 " keywords."
}], "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->168484910],

Cell[TextData[StyleBox["order ( allow,deny | deny,allow )", "InlineCode"]], \
"ItemizedText",
 CellTags->"b:2.2.0",
 CellID->355473865],

Cell[TextData[{
 "Defines the precedence of these two directives. The latter term takes \
precedence over the former. \nAlso sets the default access state as the \
latter term. The default access state is applied to requests that do not \
match an explicit rule. The default value is ",
 StyleBox["order deny,allow", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->629142656],

Cell[TextData[{
 StyleBox["allow from ( all | ", "InlineCode"],
 StyleBox["machines", "TI"],
 StyleBox[" ...", "InlineCode"],
 " ",
 StyleBox[")", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->264649560],

Cell["\<\
Allows license requests from the listed hostnames, domains, IP addresses, and \
ranges of IP addresses.\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->259825139],

Cell[TextData[{
 StyleBox["allow hostgroup ", "InlineCode"],
 StyleBox["machinegroups", "TI"],
 StyleBox[" ... ", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->5717342],

Cell["\<\
Allows license requests from members of the listed machine groups.\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->650782794],

Cell[TextData[{
 StyleBox["deny from ( all | ", "InlineCode"],
 StyleBox["machines", "TI"],
 StyleBox[" ... )", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->872684697],

Cell["\<\
Denies license requests from the listed hostnames, domains, IP addresses, and \
ranges of IP addresses.\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->7776735],

Cell[TextData[{
 StyleBox["deny hostgroup ", "InlineCode"],
 StyleBox["machinegroups", "TI"],
 StyleBox[" ... ", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->358165444],

Cell["\<\
Denies license requests from members of the listed machine groups.\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->26647657],

Cell[TextData[{
 StyleBox["allow user ( all | ", "InlineCode"],
 StyleBox["users", "TI"],
 StyleBox[" ... )", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->756602283],

Cell["Allows license requests from the listed users.", "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->38854313],

Cell[TextData[{
 StyleBox["allow group ", "InlineCode"],
 StyleBox["usergroups", "TI"],
 StyleBox[" ... ", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->53361962],

Cell["\<\
Allows license requests from members of the listed user groups.\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->496991418],

Cell[TextData[{
 StyleBox["deny user (all | ", "InlineCode"],
 StyleBox["users", "TI"],
 StyleBox[" ... )", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->31141070],

Cell["Denies license requests from the listed users.", "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->249487471],

Cell[TextData[{
 StyleBox["deny group ", "InlineCode"],
 StyleBox["usergroups", "TI"],
 StyleBox[" ... ", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->303813183],

Cell["\<\
Denies license requests from members of the listed user groups.\
\>", "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->14618442],

Cell[TextData[{
 StyleBox["reserve [", "InlineCode"],
 StyleBox["count", "TI"],
 StyleBox["] from ", "InlineCode"],
 StyleBox["machines", "TI"],
 StyleBox[" ... ", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->98069141],

Cell[TextData[{
 "Reserves ",
 StyleBox["count", "TI"],
 " front end licenses and ",
 StyleBox["count", "TI"],
 " kernel licenses for each of the listed hostnames, domains, IP addresses, \
and ranges of IP addresses. "
}], "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->659177435],

Cell[TextData[{
 StyleBox["reserve [", "InlineCode"],
 StyleBox["count", "TI"],
 StyleBox["] hostgroup ", "InlineCode"],
 StyleBox["machinegroups", "TI"],
 StyleBox[" ...", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->103107998],

Cell[TextData[{
 "Reserves ",
 StyleBox["count", "TI"],
 " front end licenses and ",
 StyleBox["count", "TI"],
 " kernel licenses for each member of the listed machine groups. "
}], "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->14578784],

Cell[TextData[{
 StyleBox["reserve [", "InlineCode"],
 StyleBox["count", "TI"],
 StyleBox["] user ", "InlineCode"],
 StyleBox["users", "TI"],
 StyleBox[" ... ", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->274966392],

Cell[TextData[{
 "Reserves ",
 StyleBox["count", "TI"],
 " front end licenses and ",
 StyleBox["count", "TI"],
 " kernel licenses for each user in the list."
}], "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->641319382],

Cell[TextData[{
 StyleBox["reserve [", "InlineCode"],
 StyleBox["count", "TI"],
 StyleBox["] group ", "InlineCode"],
 StyleBox["usergroups", "TI"],
 StyleBox[" ...", "InlineCode"]
}], "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->645287138],

Cell[TextData[{
 "Reserves ",
 StyleBox["count", "TI"],
 " front end licenses and ",
 StyleBox["count", "TI"],
 " kernel licenses for each user in the listed user groups. "
}], "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->24705447]
}, Open  ]],

Cell[CellGroupData[{

Cell["License Reservations", "Subsection",
 CellTags->"b:2.2.0",
 CellID->59474337],

Cell[TextData[{
 "The ",
 StyleBox["reserve", "InlineCode"],
 " directives allow you to guarantee license availability to particular users \
or machines. It is important to note that reserved licenses are always \
reserved and are inaccessible to all other users or machines. "
}], "Text",
 CellTags->"b:2.2.0",
 CellID->431099415],

Cell[TextData[{
 "In some situations, it may be necessary to reserve unequal numbers of front \
end and kernel licenses. The ",
 StyleBox["reservefe", "InlineCode"],
 " keyword reserves ",
 StyleBox["count", "TI"],
 " front end licenses only, while the ",
 StyleBox["reservekernel", "InlineCode"],
 " keyword reserves ",
 StyleBox["count", "TI"],
 " kernel licenses only. The syntax for ",
 StyleBox["reservefe", "InlineCode"],
 " and ",
 StyleBox["reservekernel", "InlineCode"],
 " is otherwise identical to the syntax for ",
 StyleBox["reserve", "InlineCode"],
 "."
}], "Text",
 CellTags->"b:2.2.0",
 CellID->330985121]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sample Restriction Scripts", "Section",
 CellTags->{"i:15", "b:2.2.1", "net: 1"},
 CellID->890737464],

Cell["\<\
The following examples illustrate key features of restriction scripts.\
\>", "Text",
 CellTags->"b:2.2.1",
 CellID->1729063],

Cell[CellGroupData[{

Cell["Scripts without Groups", "Subsection",
 CellTags->"b:2.2.1",
 CellID->212207308],

Cell[TextData[{
 "The following script will deny ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " license requests from ",
 StyleBox["user1", "InlineCode"],
 " and ",
 StyleBox["hostname1", "InlineCode"],
 ". License requests from all other users and machines will be allowed."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->69533225],

Cell["\<\
AuthName Sample1

order allow,deny
allow from all
deny from hostname1
allow user all
deny user user1\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->185455875],

Cell[TextData[{
 "The following script will only allow license requests from users ",
 StyleBox["user1", "InlineCode"],
 " through ",
 StyleBox["user5", "InlineCode"],
 " and from machines in the range of IP addresses from ",
 StyleBox["192.168.2.1", "InlineCode"],
 " to ",
 StyleBox["192.168.2.12", "InlineCode"],
 ", as well as ",
 StyleBox["192.168.0.1", "InlineCode"],
 " and ",
 StyleBox["192.168.0.5", "InlineCode"],
 ". License requests from any other users or machines will be denied."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->438226950],

Cell["\<\
AuthName Sample2

order deny,allow
deny from all
allow from [192.168.2.1 192.168.2.12] 192.168.0.1 192.168.0.5 
deny user all
allow user user1 user2 user3 user4 user5\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->101896323]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scripts with Groups", "Subsection",
 CellTags->"b:2.2.1",
 CellID->352313266],

Cell["\<\
The following script imposes the same restrictions as the preceding script, \
but the users and machines are specified via groups and hostgroups. \
\>", "Text",
 CellTags->"b:2.2.1",
 CellID->408623988],

Cell["\<\
AuthName Sample3
AuthGroupFile mathlmgroup1.txt

order deny,allow
deny from all
allow hostgroup group1
deny user all
allow group group2 group3\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->376297685],

Cell[TextData[{
 "This is the file ",
 StyleBox["mathlmgroup1.txt", "InlineCode"],
 ". It defines one machine group and two user groups."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->270000758],

Cell["\<\
group1: 192.168.0.1 192.168.0.5 [192.168.2.1 192.168.2.12]
group2: user1 user2 user3
group3: user4 user5\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->349481014]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scripts Demonstrating Default Access State", "Subsection",
 CellTags->"b:2.2.1",
 CellID->13219885],

Cell[TextData[{
 "The following script will allow license requests from all users and all \
machines except ",
 StyleBox["host1", "InlineCode"],
 ". If ",
 StyleBox["user1", "InlineCode"],
 " requests a license while logged on to ",
 StyleBox["host1", "InlineCode"],
 ", the request will be allowed. This request matches both rules in this \
script, but the value of the ",
 StyleBox["order", "InlineCode"],
 " directive specifies that the ",
 StyleBox["allow", "InlineCode"],
 " directive has precedence. Note that a license request from ",
 StyleBox["user2", "InlineCode"],
 " logged on to ",
 StyleBox["host1", "InlineCode"],
 " would be denied."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->271848570],

Cell["\<\
AuthName Sample4

order deny,allow
deny from host1
allow user user1\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->449341957],

Cell[TextData[{
 "The value of the ",
 StyleBox["order", "InlineCode"],
 " directive is the only difference between the preceding script and the \
following script, but the meaning of the script is reversed. This script only \
allows license requests from ",
 StyleBox["user1", "InlineCode"],
 ". A license request from ",
 StyleBox["user1", "InlineCode"],
 " logged on to ",
 StyleBox["host1", "InlineCode"],
 " will be denied. Such a request matches both rules, but the request is \
denied because the ",
 StyleBox["deny", "InlineCode"],
 " rule has precedence."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->488234074],

Cell["\<\
AuthName Sample5

order allow,deny
deny from host1
allow user user1\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->109352644]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scripts with License Reservations", "Subsection",
 CellTags->"b:2.2.1",
 CellID->212405851],

Cell[TextData[{
 "The following script will allow all license requests. It reserves three \
kernel licenses for ",
 StyleBox["192.168.0.1", "InlineCode"],
 ", and one front end license and one kernel license for ",
 StyleBox["user1", "InlineCode"],
 ". These reserved licenses are inaccessible to all other machines or users."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->381104610],

Cell["\<\
AuthName Sample6

order allow,deny
allow from all
allow user all
reservekernel 3 from 192.168.0.1
reserve user user1\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->377280362],

Cell[TextData[{
 "The following script will only allow license requests from ",
 StyleBox["user1", "InlineCode"],
 ", ",
 StyleBox["user2", "InlineCode"],
 ", ",
 StyleBox["hostname1", "InlineCode"],
 ", ",
 StyleBox["hostname2", "InlineCode"],
 ", ",
 StyleBox["domain1.com", "InlineCode"],
 ", and IP addresses in the range ",
 StyleBox["192.168.1.1", "InlineCode"],
 " through ",
 StyleBox["192.168.2.9", "InlineCode"],
 ". It reserves three kernel licenses and three front end licenses for ",
 StyleBox["hostname2", "InlineCode"],
 ", another three kernel licenses and three front end licenses for the range \
of IP addresses from ",
 StyleBox["192.168.1.1", "InlineCode"],
 " to ",
 StyleBox["192.168.2.9", "InlineCode"],
 ", one kernel license and one front end license for ",
 StyleBox["user1", "InlineCode"],
 ", and one kernel license and one front end license for ",
 StyleBox["user2", "InlineCode"],
 ". In this script, a total of eight front end licenses and eight kernel \
licenses are reserved."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->50499196],

Cell["\<\
AuthName Sample7

order deny,allow
deny from all
allow from hostname1 hostname2 .domain1.com [192.168.1.1 192.168.2.9]
deny user all
allow user user1 user2

reserve 3 from hostname2 [192.168.1.1 192.168.2.9]
reserve user user1 user2\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->36764031]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scripts with License Reservations and Groups", "Subsection",
 CellTags->"b:2.2.1",
 CellID->284726982],

Cell["\<\
The following script imposes the same restrictions and reservations as the \
preceding script, but the users and machines are specified via groups and \
hostgroups. \
\>", "Text",
 CellTags->"b:2.2.1",
 CellID->147962729],

Cell["\<\
AuthName Sample8
AuthGroupFile mathlmgroup2.txt

order deny,allow
deny from all
allow hostgroup group1 group2
deny user all
allow group group3

reservekernel 3 hostgroup group2
reserve group group3\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->59709195],

Cell[TextData[{
 "This is the file ",
 StyleBox["mathlmgroup2.txt", "InlineCode"],
 ". It defines two machine groups and one user group."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->89874476],

Cell["\<\
group1: hostname1 .domain1.com
group2: hostname2 [192.168.1.1 192.168.2.9]
group3: user1 user2\
\>", "Program",
 CellTags->"b:2.2.1",
 CellID->14916802],

Cell[TextData[{
 "Reserved licenses are always reserved. They are inaccessible to all other \
users or machines, regardless of whether they are in use. Even if none of the \
specified users or machines are running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the license pool for all other users and machines is effectively reduced \
by the number of reserved licenses."
}], "Text",
 CellTags->"b:2.2.1",
 CellID->470771648]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using a Restriction Script", "Section",
 CellTags->{"i:16", "b:2.2.2", "net: 1"},
 CellID->180333879],

Cell[TextData[{
 "To use a restriction script, run ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " with the option ",
 StyleBox["-restrict", "InlineCode"],
 " followed by the pathname of the script. You can give the restriction \
script any filename (and extension) that you want. See \"",
 ButtonBox["Launching ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LaunchingMathLM"],
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LaunchingMathLM"],
  FontSlant->"Italic"],
 "\" for details about command-line options."
}], "Text",
 CellTags->"b:2.2.2",
 CellID->643518632],

Cell[TextData[{
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " must be restarted if the restriction script or ",
 StyleBox["AuthGroupFile", "InlineCode"],
 " is changed."
}], "Text",
 CellTags->"b:2.2.2",
 CellID->91256775],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->542533105],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Restricting and Reserving Licenses - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 22.1533820}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Restriction scripts can be very useful in managing sitewide \
installations of Mathematica. They can be used to prevent access to \
Mathematica by unauthorized users on the network and to guarantee license \
availability to particular users. Restriction scripts are cross-platform \
compatible, provide unambiguous control, and require no programming \
experience to write. The syntax of the restriction scripts is very similar to \
that of the .htaccess files used in web servers for controlling access to \
HTML files. The layout of a typical restriction script is as follows. Sample \
restriction scripts follow the definitions. The reserve directives allow you \
to guarantee license availability to particular users or machines. It is \
important to note that reserved licenses are always reserved and are \
inaccessible to all other users or machines. ", "synonyms" -> {}, "title" -> 
    "Restricting and Reserving Licenses", "type" -> "Tutorial", "uri" -> 
    "tutorial/RestrictingAndReservingLicenses"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:1"->{
  Cell[1319, 44, 89, 2, 70, "Title",
   CellTags->"i:1",
   CellID->263699052]},
 "i:14"->{
  Cell[1433, 50, 108, 2, 70, "Section",
   CellTags->{"i:14", "b:2.2.0", "net: 1"},
   CellID->33819112]},
 "b:2.2.0"->{
  Cell[1433, 50, 108, 2, 70, "Section",
   CellTags->{"i:14", "b:2.2.0", "net: 1"},
   CellID->33819112],
  Cell[1544, 54, 708, 16, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->686025895],
  Cell[2255, 72, 176, 5, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->182301266],
  Cell[2434, 79, 631, 26, 70, "Program",
   CellTags->"b:2.2.0",
   CellID->238736929],
  Cell[3090, 109, 82, 2, 70, "Subsection",
   CellTags->"b:2.2.0",
   CellID->462862741],
  Cell[3175, 113, 159, 3, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:2.2.0",
   CellID->463745213],
  Cell[3337, 118, 105, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->34926882],
  Cell[3445, 122, 131, 3, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->663310220],
  Cell[3579, 127, 314, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->168484910],
  Cell[3896, 138, 135, 3, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->355473865],
  Cell[4034, 143, 407, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->629142656],
  Cell[4444, 154, 222, 8, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->264649560],
  Cell[4669, 164, 186, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->259825139],
  Cell[4858, 171, 187, 6, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->5717342],
  Cell[5048, 179, 149, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->650782794],
  Cell[5200, 185, 187, 6, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->872684697],
  Cell[5390, 193, 184, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->7776735],
  Cell[5577, 200, 188, 6, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->358165444],
  Cell[5768, 208, 148, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->26647657],
  Cell[5919, 214, 185, 6, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->756602283],
  Cell[6107, 222, 120, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->38854313],
  Cell[6230, 226, 181, 6, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->53361962],
  Cell[6414, 234, 146, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->496991418],
  Cell[6563, 240, 182, 6, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->31141070],
  Cell[6748, 248, 121, 2, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->249487471],
  Cell[6872, 252, 181, 6, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->303813183],
  Cell[7056, 260, 145, 4, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->14618442],
  Cell[7204, 266, 238, 8, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->98069141],
  Cell[7445, 276, 289, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->659177435],
  Cell[7737, 287, 248, 8, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->103107998],
  Cell[7988, 297, 247, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->14578784],
  Cell[8238, 307, 236, 8, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->274966392],
  Cell[8477, 317, 228, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->641319382],
  Cell[8708, 327, 241, 8, 70, "ItemizedText",
   CellTags->"b:2.2.0",
   CellID->645287138],
  Cell[8952, 337, 242, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:2.2.0",
   CellID->24705447],
  Cell[9231, 350, 83, 2, 70, "Subsection",
   CellTags->"b:2.2.0",
   CellID->59474337],
  Cell[9317, 354, 331, 8, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->431099415],
  Cell[9651, 364, 621, 19, 70, "Text",
   CellTags->"b:2.2.0",
   CellID->330985121]},
 "net: 1"->{
  Cell[1433, 50, 108, 2, 70, "Section",
   CellTags->{"i:14", "b:2.2.0", "net: 1"},
   CellID->33819112],
  Cell[10321, 389, 107, 2, 70, "Section",
   CellTags->{"i:15", "b:2.2.1", "net: 1"},
   CellID->890737464],
  Cell[18207, 711, 107, 2, 70, "Section",
   CellTags->{"i:16", "b:2.2.2", "net: 1"},
   CellID->180333879]},
 "i:15"->{
  Cell[10321, 389, 107, 2, 70, "Section",
   CellTags->{"i:15", "b:2.2.1", "net: 1"},
   CellID->890737464]},
 "b:2.2.1"->{
  Cell[10321, 389, 107, 2, 70, "Section",
   CellTags->{"i:15", "b:2.2.1", "net: 1"},
   CellID->890737464],
  Cell[10431, 393, 134, 4, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->1729063],
  Cell[10590, 401, 86, 2, 70, "Subsection",
   CellTags->"b:2.2.1",
   CellID->212207308],
  Cell[10679, 405, 336, 11, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->69533225],
  Cell[11018, 418, 169, 10, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->185455875],
  Cell[11190, 430, 548, 16, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->438226950],
  Cell[11741, 448, 235, 10, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->101896323],
  Cell[12013, 463, 83, 2, 70, "Subsection",
   CellTags->"b:2.2.1",
   CellID->352313266],
  Cell[12099, 467, 212, 5, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->408623988],
  Cell[12314, 474, 211, 11, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->376297685],
  Cell[12528, 487, 191, 6, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->270000758],
  Cell[12722, 495, 173, 6, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->349481014],
  Cell[12932, 506, 105, 2, 70, "Subsection",
   CellTags->"b:2.2.1",
   CellID->13219885],
  Cell[13040, 510, 703, 20, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->271848570],
  Cell[13746, 532, 136, 8, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->449341957],
  Cell[13885, 542, 618, 17, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->488234074],
  Cell[14506, 561, 136, 8, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->109352644],
  Cell[14679, 574, 97, 2, 70, "Subsection",
   CellTags->"b:2.2.1",
   CellID->212405851],
  Cell[14779, 578, 380, 9, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->381104610],
  Cell[15162, 589, 185, 10, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->377280362],
  Cell[15350, 601, 1062, 30, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->50499196],
  Cell[16415, 633, 300, 13, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->36764031],
  Cell[16752, 651, 108, 2, 70, "Subsection",
   CellTags->"b:2.2.1",
   CellID->284726982],
  Cell[16863, 655, 231, 6, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->147962729],
  Cell[17097, 663, 265, 14, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->59709195],
  Cell[17365, 679, 190, 6, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->89874476],
  Cell[17558, 687, 162, 6, 70, "Program",
   CellTags->"b:2.2.1",
   CellID->14916802],
  Cell[17723, 695, 435, 10, 70, "Text",
   CellTags->"b:2.2.1",
   CellID->470771648]},
 "i:16"->{
  Cell[18207, 711, 107, 2, 70, "Section",
   CellTags->{"i:16", "b:2.2.2", "net: 1"},
   CellID->180333879]},
 "b:2.2.2"->{
  Cell[18207, 711, 107, 2, 70, "Section",
   CellTags->{"i:16", "b:2.2.2", "net: 1"},
   CellID->180333879],
  Cell[18317, 715, 687, 20, 70, "Text",
   CellTags->"b:2.2.2",
   CellID->643518632],
  Cell[19007, 737, 298, 10, 70, "Text",
   CellTags->"b:2.2.2",
   CellID->91256775]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:1", 21771, 809},
 {"i:14", 21863, 813},
 {"b:2.2.0", 21984, 817},
 {"net: 1", 25669, 933},
 {"i:15", 26005, 943},
 {"b:2.2.1", 26129, 947},
 {"i:16", 28633, 1032},
 {"b:2.2.2", 28757, 1036}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 694, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1319, 44, 89, 2, 70, "Title",
 CellTags->"i:1",
 CellID->263699052],
Cell[CellGroupData[{
Cell[1433, 50, 108, 2, 70, "Section",
 CellTags->{"i:14", "b:2.2.0", "net: 1"},
 CellID->33819112],
Cell[1544, 54, 708, 16, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->686025895],
Cell[2255, 72, 176, 5, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->182301266],
Cell[2434, 79, 631, 26, 70, "Program",
 CellTags->"b:2.2.0",
 CellID->238736929],
Cell[CellGroupData[{
Cell[3090, 109, 82, 2, 70, "Subsection",
 CellTags->"b:2.2.0",
 CellID->462862741],
Cell[3175, 113, 159, 3, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:2.2.0",
 CellID->463745213],
Cell[3337, 118, 105, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->34926882],
Cell[3445, 122, 131, 3, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->663310220],
Cell[3579, 127, 314, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->168484910],
Cell[3896, 138, 135, 3, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->355473865],
Cell[4034, 143, 407, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->629142656],
Cell[4444, 154, 222, 8, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->264649560],
Cell[4669, 164, 186, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->259825139],
Cell[4858, 171, 187, 6, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->5717342],
Cell[5048, 179, 149, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->650782794],
Cell[5200, 185, 187, 6, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->872684697],
Cell[5390, 193, 184, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->7776735],
Cell[5577, 200, 188, 6, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->358165444],
Cell[5768, 208, 148, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->26647657],
Cell[5919, 214, 185, 6, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->756602283],
Cell[6107, 222, 120, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->38854313],
Cell[6230, 226, 181, 6, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->53361962],
Cell[6414, 234, 146, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->496991418],
Cell[6563, 240, 182, 6, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->31141070],
Cell[6748, 248, 121, 2, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->249487471],
Cell[6872, 252, 181, 6, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->303813183],
Cell[7056, 260, 145, 4, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->14618442],
Cell[7204, 266, 238, 8, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->98069141],
Cell[7445, 276, 289, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->659177435],
Cell[7737, 287, 248, 8, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->103107998],
Cell[7988, 297, 247, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->14578784],
Cell[8238, 307, 236, 8, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->274966392],
Cell[8477, 317, 228, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->641319382],
Cell[8708, 327, 241, 8, 70, "ItemizedText",
 CellTags->"b:2.2.0",
 CellID->645287138],
Cell[8952, 337, 242, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:2.2.0",
 CellID->24705447]
}, Open  ]],
Cell[CellGroupData[{
Cell[9231, 350, 83, 2, 70, "Subsection",
 CellTags->"b:2.2.0",
 CellID->59474337],
Cell[9317, 354, 331, 8, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->431099415],
Cell[9651, 364, 621, 19, 70, "Text",
 CellTags->"b:2.2.0",
 CellID->330985121]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10321, 389, 107, 2, 70, "Section",
 CellTags->{"i:15", "b:2.2.1", "net: 1"},
 CellID->890737464],
Cell[10431, 393, 134, 4, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->1729063],
Cell[CellGroupData[{
Cell[10590, 401, 86, 2, 70, "Subsection",
 CellTags->"b:2.2.1",
 CellID->212207308],
Cell[10679, 405, 336, 11, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->69533225],
Cell[11018, 418, 169, 10, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->185455875],
Cell[11190, 430, 548, 16, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->438226950],
Cell[11741, 448, 235, 10, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->101896323]
}, Open  ]],
Cell[CellGroupData[{
Cell[12013, 463, 83, 2, 70, "Subsection",
 CellTags->"b:2.2.1",
 CellID->352313266],
Cell[12099, 467, 212, 5, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->408623988],
Cell[12314, 474, 211, 11, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->376297685],
Cell[12528, 487, 191, 6, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->270000758],
Cell[12722, 495, 173, 6, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->349481014]
}, Open  ]],
Cell[CellGroupData[{
Cell[12932, 506, 105, 2, 70, "Subsection",
 CellTags->"b:2.2.1",
 CellID->13219885],
Cell[13040, 510, 703, 20, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->271848570],
Cell[13746, 532, 136, 8, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->449341957],
Cell[13885, 542, 618, 17, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->488234074],
Cell[14506, 561, 136, 8, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->109352644]
}, Open  ]],
Cell[CellGroupData[{
Cell[14679, 574, 97, 2, 70, "Subsection",
 CellTags->"b:2.2.1",
 CellID->212405851],
Cell[14779, 578, 380, 9, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->381104610],
Cell[15162, 589, 185, 10, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->377280362],
Cell[15350, 601, 1062, 30, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->50499196],
Cell[16415, 633, 300, 13, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->36764031]
}, Open  ]],
Cell[CellGroupData[{
Cell[16752, 651, 108, 2, 70, "Subsection",
 CellTags->"b:2.2.1",
 CellID->284726982],
Cell[16863, 655, 231, 6, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->147962729],
Cell[17097, 663, 265, 14, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->59709195],
Cell[17365, 679, 190, 6, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->89874476],
Cell[17558, 687, 162, 6, 70, "Program",
 CellTags->"b:2.2.1",
 CellID->14916802],
Cell[17723, 695, 435, 10, 70, "Text",
 CellTags->"b:2.2.1",
 CellID->470771648]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18207, 711, 107, 2, 70, "Section",
 CellTags->{"i:16", "b:2.2.2", "net: 1"},
 CellID->180333879],
Cell[18317, 715, 687, 20, 70, "Text",
 CellTags->"b:2.2.2",
 CellID->643518632],
Cell[19007, 737, 298, 10, 70, "Text",
 CellTags->"b:2.2.2",
 CellID->91256775],
Cell[CellGroupData[{
Cell[19330, 751, 72, 1, 70, "RelatedTutorialsSection",
 CellID->542533105],
Cell[19405, 754, 214, 5, 70, "RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19658, 764, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

