(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28905,       1077]
NotebookOptionsPosition[     24181,        914]
NotebookOutlinePosition[     25613,        953]
CellTagsIndexPosition[     25570,        950]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Complexes" :> Documentation`HelpLookup["paclet:ref/Complexes"], 
         "CountRoots" :> Documentation`HelpLookup["paclet:ref/CountRoots"], 
         "IsolatingInterval" :> 
         Documentation`HelpLookup["paclet:ref/IsolatingInterval"], 
         "RootIntervals" :> 
         Documentation`HelpLookup["paclet:ref/RootIntervals"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Complexes\"\>", 
      2->"\<\"CountRoots\"\>", 3->"\<\"IsolatingInterval\"\>", 
      4->"\<\"RootIntervals\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Root Isolation", "Title",
 CellID->2416],

Cell[CellGroupData[{

Cell["Counting Roots of Polynomials", "Section",
 CellID->27852445],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CountRoots",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CountRoots"], "[", 
     RowBox[{
      StyleBox["poly", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "give the number of real roots of the polynomial ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CountRoots",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CountRoots"], "[", 
     RowBox[{
      StyleBox["poly", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "give the number of roots of the polynomial ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{"Re", "(", "a", ")"}], "\[LessEqual]", 
         RowBox[{"Re", "(", "r", ")"}], "\[LessEqual]", 
         RowBox[{"Re", "(", "b", ")"}]}], "\[And]", 
        RowBox[{
         RowBox[{"Im", "(", "a", ")"}], "\[LessEqual]", 
         RowBox[{"Im", "(", "r", ")"}], "\[LessEqual]", 
         RowBox[{"Im", "(", "b", ")"}]}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->516713636],

Cell["Counting roots of polynomials.", "Caption",
 CellID->490566573],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CountRoots",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountRoots"]], "InlineFormula"],
 " accepts polynomials with Gaussian rational coefficients. The root count \
includes multiplicities."
}], "Text",
 CellID->44465506],

Cell[TextData[{
 "This gives the number of real roots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "4"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->880013018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "4"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128681341],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->562828571]
}, Open  ]],

Cell[TextData[{
 "This counts the roots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "4"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " in the closed interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"1", ",", "2"}], "]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->9566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "4"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18725],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1941811409]
}, Open  ]],

Cell[TextData[{
 "The roots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "1"}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], TraditionalForm]], "InlineMath"],
 " in the vertical axis segment between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath"],
 " consist of a triple root at ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " and a single root at ",
 Cell[BoxData[
  FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->4232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "1"}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", " ", "\[ImaginaryI]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20680],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->715367604]
}, Open  ]],

Cell[TextData[{
 "This counts 17",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 "-degree roots of unity in the closed unit square. "
}], "MathCaption",
 CellID->25279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "17"], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"1", "+", "\[ImaginaryI]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26652],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1569864522]
}, Open  ]],

Cell["\<\
The coefficients of the polynomial can be Gaussian rationals.\
\>", "MathCaption",
 CellID->93356814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    RowBox[{"\[ImaginaryI]", " ", "x"}], "+", 
    FractionBox[
     RowBox[{"3", " ", "\[ImaginaryI]"}], "4"], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"1", "+", "\[ImaginaryI]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->444738568],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->728934212]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Isolating Intervals", "Section",
 CellID->37952421],

Cell[TextData[{
 "A set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"S", "\[SubsetEqual]", "K"}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalR]", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"],
 ", is an ",
 StyleBox["isolating set",
  FontSlant->"Italic"],
 " for a root ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " of a polynomial ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " is the only root of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 ". Isolating roots of a polynomial means finding disjoint isolating sets for \
all the roots of the polynomial. "
}], "Text",
 CellID->248950954],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RootIntervals",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RootIntervals"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "give a list of disjoint isolating intervals for the real roots of any \
of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", together with a list of which polynomials actually have each \
successive root"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RootIntervals",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RootIntervals"], "[", 
     StyleBox["poly", "TI"], "]"}], Cell["\<\
give disjoint isolating intervals for real roots of a single polynomial\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["RootIntervals",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RootIntervals"], "[", 
     RowBox[{
      StyleBox["polys", "TI"], ",", 
      ButtonBox["Complexes",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complexes"]}], "]"}], Cell[TextData[{
     "give disjoint isolating intervals or rectangles for complex roots of ",
     Cell[BoxData[
      StyleBox["polys", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IsolatingInterval",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IsolatingInterval"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give an isolating interval for the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IsolatingInterval",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IsolatingInterval"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["dx", "TI"]}], "]"}], Cell[TextData[{
     "give an isolating interval of width at most ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->388532087],

Cell["Functions for isolating roots of polynomials.", "Caption",
 CellID->135632607],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootIntervals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootIntervals"]], "InlineFormula"],
 " accepts polynomials with rational number coefficients."
}], "Text",
 CellID->257333825],

Cell[TextData[{
 "For a real root ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " the returned isolating interval is a pair of rational numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], TraditionalForm]], "InlineMath"],
 ", such that either ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "<", "r", "<", "b"}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[LongEqual]", "b", "\[LongEqual]", "r"}], TraditionalForm]],
   "InlineMath"],
 ". For a nonreal root ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " the isolating rectangle returned is a pair of Gaussian rational numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], TraditionalForm]], "InlineMath"],
 ", such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"Re", "(", "a", ")"}], "<", 
     RowBox[{"Re", "(", "r", ")"}], "<", 
     RowBox[{"Re", "(", "b", ")"}]}], "\[And]", 
    RowBox[{
     RowBox[{"Im", "(", "a", ")"}], "<", 
     RowBox[{"Im", "(", "r", ")"}], "<", 
     RowBox[{"Im", "(", "b", ")"}]}]}], TraditionalForm]], "InlineMath"],
 " and either ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Im", "(", "a", ")"}], "\[GreaterEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Im", "(", "b", ")"}], "\[LessEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->111208126],

Cell[TextData[{
 "Here are isolating intervals for the real roots of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->22575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "3"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", "4"}], ")"}]}]}], ";", " ", 
  RowBox[{"RootIntervals", "[", "f", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", 
        FractionBox["3", "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["3", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{386, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1950578596]
}, Open  ]],

Cell["\<\
The second list shows which interval contains a root of which polynomial. \
\>", "MathCaption",
 CellID->4169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "+", "3"}], ",", 
    RowBox[{"f", "+", "5"}], ",", 
    RowBox[{"f", "+", "7"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->16415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["5", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["9", "8"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["9", "8"]}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       FractionBox["9", "8"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["9", "8"], ",", 
       FractionBox["5", "4"]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{387, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->2036591517]
}, Open  ]],

Cell[TextData[{
 "This gives isolating intervals for all complex roots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "+", "3"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->32680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"f", "+", "3"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->8965],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "7"}], "-", 
        RowBox[{"7", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"-", 
        FractionBox["7", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["7", "4"]}], "+", 
        RowBox[{"7", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["7", "4"]}], "-", 
        RowBox[{"7", " ", "\[ImaginaryI]"}]}], ",", 
       FractionBox["7", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["7", "4"]}], ",", 
       RowBox[{
        FractionBox["7", "2"], "+", 
        RowBox[{"7", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{532, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->251776686]
}, Open  ]],

Cell["\<\
Here are isolating intervals for the third- and fourth-degree roots of unity. \
The second interval contains a root common to both polynomials. \
\>", "MathCaption",
 CellID->560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "-", "1"}], ",", 
     RowBox[{
      SuperscriptBox["x", "4"], "-", "1"}]}], "}"}], ",", "Complexes"}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->11645],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "4"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "4"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ",", 
       RowBox[{
        FractionBox["3", "8"], "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "16"]}], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "4"]}], ",", 
       RowBox[{
        FractionBox["3", "8"], "+", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{532, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1067977012]
}, Open  ]],

Cell["\<\
Here is an isolating interval for a root of a polynomial of degree seven. \
\>", "MathCaption",
 CellID->148652598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "7"}], "-", 
      RowBox[{"11", "#"}], "+", "3"}], "&"}], ",", "5"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->159513346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", 
   RowBox[{"4", " ", "\[ImaginaryI]"}]}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->821319058]
}, Open  ]],

Cell[TextData[{
 "This gives an isolating interval of width at most ",
 Cell[BoxData[
  SuperscriptBox["10", 
   RowBox[{"-", "10"}]]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->3692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "7"}], "-", 
       RowBox[{"11", "#"}], "+", "3"}], "&"}], ",", "5"}], "]"}], ",", 
   RowBox[{"10", "^", 
    RowBox[{"-", "10"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->26201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["866877392461", "1099511627776"]}], "+", 
    FractionBox[
     RowBox[{"355978878543", " ", "\[ImaginaryI]"}], "274877906944"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["3467509569843", "4398046511104"]}], "+", 
    FractionBox[
     RowBox[{"5695662056689", " ", "\[ImaginaryI]"}], "4398046511104"]}]}], 
  "}"}]], "Output",
 ImageSize->{498, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->2032008537]
}, Open  ]],

Cell["\<\
All numbers in the interval have the first ten decimal digits in common. \
\>", "MathCaption",
 CellID->20736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->13391],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.78842039553001086460426449776`9.866527479025487"}], "+", 
    RowBox[{
    "1.29504361591170891188085079193`10.082054023887009", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.7884203955297834909288212657`9.866527479025338"}], "+", 
    RowBox[{
    "1.29504361591193628555629402399`10.082054023887064", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{400, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->535043118]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Root Isolation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 22.3721376}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Counting roots of polynomials. CountRoots accepts polynomials with \
Gaussian rational coefficients. The root count includes multiplicities. This \
gives the number of real roots of (x^2-2) (x^2-3) (x^2-4). ", 
    "synonyms" -> {}, "title" -> "Root Isolation", "type" -> "Tutorial", 
    "uri" -> "tutorial/RootIsolation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 916, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1541, 47, 46, 1, 70, "Title",
 CellID->2416],
Cell[CellGroupData[{
Cell[1612, 52, 67, 1, 70, "Section",
 CellID->27852445],
Cell[1682, 55, 1533, 48, 70, "DefinitionBox",
 CellID->516713636],
Cell[3218, 105, 69, 1, 70, "Caption",
 CellID->490566573],
Cell[3290, 108, 272, 8, 70, "Text",
 CellID->44465506],
Cell[3565, 118, 442, 17, 70, "MathCaption",
 CellID->880013018],
Cell[CellGroupData[{
Cell[4032, 139, 403, 15, 30, "Input",
 CellID->128681341],
Cell[4438, 156, 158, 5, 36, "Output",
 CellID->562828571]
}, Open  ]],
Cell[4611, 164, 565, 22, 70, "MathCaption",
 CellID->9566],
Cell[CellGroupData[{
Cell[5201, 190, 455, 16, 30, "Input",
 CellID->18725],
Cell[5659, 208, 159, 5, 36, "Output",
 CellID->1941811409]
}, Open  ]],
Cell[5833, 216, 679, 24, 70, "MathCaption",
 CellID->4232],
Cell[CellGroupData[{
Cell[6537, 244, 351, 12, 70, "Input",
 CellID->20680],
Cell[6891, 258, 158, 5, 36, "Output",
 CellID->715367604]
}, Open  ]],
Cell[7064, 266, 205, 7, 70, "MathCaption",
 CellID->25279],
Cell[CellGroupData[{
Cell[7294, 277, 273, 9, 70, "Input",
 CellID->26652],
Cell[7570, 288, 159, 5, 36, "Output",
 CellID->1569864522]
}, Open  ]],
Cell[7744, 296, 111, 3, 70, "MathCaption",
 CellID->93356814],
Cell[CellGroupData[{
Cell[7880, 303, 394, 12, 70, "Input",
 CellID->444738568],
Cell[8277, 317, 158, 5, 36, "Output",
 CellID->728934212]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8484, 328, 57, 1, 70, "Section",
 CellID->37952421],
Cell[8544, 331, 1008, 35, 70, "Text",
 CellID->248950954],
Cell[9555, 368, 2244, 69, 70, "DefinitionBox",
 CellID->388532087],
Cell[11802, 439, 84, 1, 70, "Caption",
 CellID->135632607],
Cell[11889, 442, 235, 7, 70, "Text",
 CellID->257333825],
Cell[12127, 451, 1521, 52, 70, "Text",
 CellID->111208126],
Cell[13651, 505, 176, 6, 70, "MathCaption",
 CellID->22575],
Cell[CellGroupData[{
Cell[13852, 515, 426, 15, 70, "Input",
 CellID->5801],
Cell[14281, 532, 1101, 39, 73, "Output",
 CellID->1950578596]
}, Open  ]],
Cell[15397, 574, 120, 3, 70, "MathCaption",
 CellID->4169],
Cell[CellGroupData[{
Cell[15542, 581, 237, 8, 70, "Input",
 CellID->16415],
Cell[15782, 591, 1131, 40, 73, "Output",
 CellID->2036591517]
}, Open  ]],
Cell[16928, 634, 205, 7, 70, "MathCaption",
 CellID->32680],
Cell[CellGroupData[{
Cell[17158, 645, 159, 5, 70, "Input",
 CellID->8965],
Cell[17320, 652, 1482, 51, 73, "Output",
 CellID->251776686]
}, Open  ]],
Cell[18817, 706, 189, 4, 70, "MathCaption",
 CellID->560],
Cell[CellGroupData[{
Cell[19031, 714, 296, 11, 70, "Input",
 CellID->11645],
Cell[19330, 727, 2076, 70, 81, "Output",
 CellID->1067977012]
}, Open  ]],
Cell[21421, 800, 125, 3, 70, "MathCaption",
 CellID->148652598],
Cell[CellGroupData[{
Cell[21571, 807, 278, 10, 70, "Input",
 CellID->159513346],
Cell[21852, 819, 259, 9, 36, "Output",
 CellID->821319058]
}, Open  ]],
Cell[22126, 831, 192, 7, 70, "MathCaption",
 CellID->3692],
Cell[CellGroupData[{
Cell[22343, 842, 346, 12, 70, "Input",
 CellID->26201],
Cell[22692, 856, 560, 18, 51, "Output",
 CellID->2032008537]
}, Open  ]],
Cell[23267, 877, 120, 3, 70, "MathCaption",
 CellID->20736],
Cell[CellGroupData[{
Cell[23412, 884, 118, 4, 70, "Input",
 CellID->13391],
Cell[23533, 890, 582, 17, 36, "Output",
 CellID->535043118]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[24154, 912, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

