(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11803,        375]
NotebookOptionsPosition[      7413,        254]
NotebookOutlinePosition[     10659,        332]
CellTagsIndexPosition[     10565,        326]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Files and External Operations\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number" :> Documentation`HelpLookup["paclet:ref/Number"], 
          "ReadList" :> Documentation`HelpLookup["paclet:ref/ReadList"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Number\"\>", 
       2->"\<\"ReadList\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Running External Programs", "Title",
 CellTags->{"S1.11.10", "10.1"},
 CellID->1847],

Cell[TextData[{
 "Although ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does many things well, there are some things that are inevitably better \
done by external programs. You can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to control the external programs, or to analyze output they generate. "
}], "Text",
 CellID->7469],

Cell[TextData[{
 "On almost all computer systems, it is possible to run external programs \
directly from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " communicates with the external programs through interprocess communication \
mechanisms such as pipes. "
}], "Text",
 CellID->16345],

Cell[TextData[{
 "In the simplest cases, the only communication you need is to send and \
receive plain text. You can prepare input in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then give it as the standard input for the external program. Or you can \
take the standard output of the external program, and use it as input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->4380],

Cell[TextData[{
 "In general, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to treat streams of data exchanged with external programs just \
like files. In place of a file name, you give the external command to run, \
prefaced by an exclamation point. "
}], "Text",
 CellID->31913],

Cell[BoxData[GridBox[{
   {
    RowBox[{"<<", 
     StyleBox["file", "TI"]}], Cell["read in a file", "TableText"]},
   {
    RowBox[{"<<", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\""}], Cell[
    "run an external command, and read in the output it produces", 
     "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], ">>", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\""}], Cell[TextData[{
     "feed the textual form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to an external command"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReadList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReadList"], "[", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", ",", 
     ButtonBox["Number",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Number"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
run an external command, and read in a list of the numbers it produces\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14964],

Cell["Some ways to communicate with external programs. ", "Caption",
 CellID->25710],

Cell[TextData[{
 "This feeds the expression ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"y", "^", "2"}]}]], "InlineFormula"],
 " as input to the external command ",
 Cell[BoxData["lpr"], "InlineFormula"],
 ", which, on a typical Berkeley Unix system, sends output to a printer. "
}], "MathCaption",
 CellID->20061],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"y", "^", "2"}]}], ">>", "\"\<!lpr\>\""}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[1]:= ",
 CellID->25385],

Cell[TextData[{
 "With a text\[Hyphen]based interface, putting ",
 Cell[BoxData["!"], "InlineFormula"],
 " at the beginning of a line causes the remainder of the line to be executed \
as an external command. ",
 Cell[BoxData["squares"], "InlineFormula"],
 " is an external program which prints numbers and their squares. "
}], "MathCaption",
 CellID->20073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"squares", " ", "4"}]}]], "Input", "ConversionLockdown",
 CellLabel->"In[2]:= ",
 CellID->27504],

Cell[BoxData["\<\"1  1\\n2  4\\n3  9\\n4  16\\n\"\>"], "Print", "ConversionLockdown",
 CellID->9462]
}, Open  ]],

Cell[TextData[{
 "This runs the external command ",
 Cell[BoxData[
  RowBox[{"squares", "4"}]], "InlineFormula"],
 ", then reads numbers from the output it produces. "
}], "MathCaption",
 CellID->32703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<!squares 4\>\"", ",", "Number", ",", 
   RowBox[{"RecordLists", "->", "True"}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[3]:= ",
 CellID->28102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "16"}], "}"}]}], "}"}]], "Output", "ConversionLockdown",
 
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->11069]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->58054716],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Running External Programs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and External Operations", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/FilesAndExternalOperationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SplicingMathematicaOutputIntoExternalFiles"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MathLink"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 26.1066082}", "context" -> "", 
    "keywords" -> {
     "communication", "external programs", "Get", 
      "Interprocess communication", "IPC", "lpr", "pipes", 
      "printing expressions", "Put", "ReadList", "Unix"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Although Mathematica does many things well, there are some things that \
are inevitably better done by external programs. You can use Mathematica to \
control the external programs, or to analyze output they generate. On almost \
all computer systems, it is possible to run external programs directly from \
within Mathematica. Mathematica communicates with the external programs \
through interprocess communication mechanisms such as pipes. In the simplest \
cases, the only communication you need is to send and receive plain text. You \
can prepare input in Mathematica, then give it as the standard input for the \
external program. Or you can take the standard output of the external \
program, and use it as input to Mathematica. ", "synonyms" -> {"1.11.10"}, 
    "title" -> "Running External Programs", "type" -> "Tutorial", "uri" -> 
    "tutorial/RunningExternalPrograms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.10"->{
  Cell[1924, 60, 90, 2, 70, "Title",
   CellTags->{"S1.11.10", "10.1"},
   CellID->1847]},
 "10.1"->{
  Cell[1924, 60, 90, 2, 70, "Title",
   CellTags->{"S1.11.10", "10.1"},
   CellID->1847]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.10", 10349, 315},
 {"10.1", 10451, 319}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1299, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1924, 60, 90, 2, 70, "Title",
 CellTags->{"S1.11.10", "10.1"},
 CellID->1847],
Cell[2017, 64, 348, 10, 70, "Text",
 CellID->7469],
Cell[2368, 76, 356, 11, 70, "Text",
 CellID->16345],
Cell[2727, 89, 422, 11, 70, "Text",
 CellID->4380],
Cell[3152, 102, 301, 8, 70, "Text",
 CellID->31913],
Cell[3456, 112, 1444, 42, 70, "DefinitionBox",
 CellID->14964],
Cell[4903, 156, 84, 1, 70, "Caption",
 CellID->25710],
Cell[4990, 159, 344, 10, 70, "MathCaption",
 CellID->20061],
Cell[5337, 171, 196, 7, 70, "Input",
 CellID->25385],
Cell[5536, 180, 357, 8, 70, "MathCaption",
 CellID->20073],
Cell[CellGroupData[{
Cell[5918, 192, 135, 4, 70, "Input",
 CellID->27504],
Cell[6056, 198, 100, 1, 70, "Print",
 CellID->9462]
}, Open  ]],
Cell[6171, 202, 202, 6, 70, "MathCaption",
 CellID->32703],
Cell[CellGroupData[{
Cell[6398, 212, 218, 6, 70, "Input",
 CellID->28102],
Cell[6619, 220, 442, 16, 36, "Output",
 CellID->11069]
}, Open  ]],
Cell[CellGroupData[{
Cell[7098, 241, 71, 1, 70, "RelatedTutorialsSection",
 CellID->58054716],
Cell[7172, 244, 187, 4, 70, "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],
Cell[7386, 252, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

