(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31563,       1053]
NotebookOptionsPosition[     25898,        891]
NotebookOutlinePosition[     29149,        968]
CellTagsIndexPosition[     29055,        962]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinkConnect" :> 
          Documentation`HelpLookup["paclet:ref/LinkConnect"], "LinkCreate" :> 
          Documentation`HelpLookup["paclet:ref/LinkCreate"], "LinkLaunch" :> 
          Documentation`HelpLookup["paclet:ref/LinkLaunch"], "MLActivate" :> 
          Documentation`HelpLookup["paclet:ref/c/MLActivate"], "MLClose" :> 
          Documentation`HelpLookup["paclet:ref/c/MLClose"], "MLDeinitialize" :> 
          Documentation`HelpLookup["paclet:ref/c/MLDeinitialize"], 
          "MLEndPacket" :> 
          Documentation`HelpLookup["paclet:ref/c/MLEndPacket"], "MLENV" :> 
          Documentation`HelpLookup["paclet:ref/c/MLENV"], "MLFlush" :> 
          Documentation`HelpLookup["paclet:ref/c/MLFlush"], "MLInitialize" :> 
          Documentation`HelpLookup["paclet:ref/c/MLInitialize"], "MLINK" :> 
          Documentation`HelpLookup["paclet:ref/c/MLINK"], "MLNewPacket" :> 
          Documentation`HelpLookup["paclet:ref/c/MLNewPacket"], 
          "MLNextPacket" :> 
          Documentation`HelpLookup["paclet:ref/c/MLNewPacket"], 
          "MLOpenArgcArgv" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenArgv"], "MLOpenString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLOpenString"], "MLReady" :> 
          Documentation`HelpLookup["paclet:ref/c/MLReady"], "MLReadyParallel" :> 
          Documentation`HelpLookup["paclet:ref/c/MLReadyParallel"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LinkConnect\"\>", 
       2->"\<\"LinkCreate\"\>", 3->"\<\"LinkLaunch\"\>", 
       4->"\<\"MLActivate\"\>", 5->"\<\"MLClose\"\>", 
       6->"\<\"MLDeinitialize\"\>", 7->"\<\"MLEndPacket\"\>", 
       8->"\<\"MLENV\"\>", 9->"\<\"MLFlush\"\>", 10->"\<\"MLInitialize\"\>", 
       11->"\<\"MLINK\"\>", 12->"\<\"MLNewPacket\"\>", 
       13->"\<\"MLNextPacket\"\>", 14->"\<\"MLOpenArgcArgv\"\>", 
       15->"\<\"MLOpenString\"\>", 16->"\<\"MLReady\"\>", 
       17->"\<\"MLReadyParallel\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from Within an External Program"
}], "Title",
 CellTags->{"S2.13.14", "14.1"},
 CellID->31088],

Cell[TextData[{
 "To run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from within an external program requires making use of many general \
features of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". The first issue is how to establish a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->1563],

Cell[TextData[{
 "When you use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " templates to create external programs that can be called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", source code to establish a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection is automatically generated, and all you have to do in your \
external program is to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLMain",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLMain"], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["argc", "TI"], ",", 
     StyleBox["argv", "TI"]}], ")"}]}]], "InlineFormula"],
 ". But in general you need to call several functions to establish a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection. "
}], "Text",
 CellID->25834],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLENV",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLENV"], 
     ButtonBox["MLInitialize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLInitialize"], 
     RowBox[{"(", "0", ")"}]}], Cell[TextData[{
     "initialize ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library functions"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLINK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLINK"], 
     ButtonBox["MLOpenArgcArgv",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLOpenArgv"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"MLENV", " ", 
        StyleBox["env", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["argc", "TI"]}], ",", 
       RowBox[{"char", "**", 
        StyleBox["argv", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["errno", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "open a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection taking parameters from an ",
     Cell[BoxData["argv"], "InlineFormula"],
     " array"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLINK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLINK"], 
     ButtonBox["MLOpenString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLOpenString"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"MLENV", " ", 
        StyleBox["env", "TI"]}], ",", 
       RowBox[{"char", "*", 
        StyleBox["string", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["errno", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "open a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection taking parameters from a single character string"
    }], "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLActivate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLActivate"], 
     RowBox[{"(", 
      RowBox[{"MLINK", " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[TextData[{
     "activate a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection, waiting for the program at the other end to respond"
    }], "TableText"]},
   {
    RowBox[{"void", 
     ButtonBox["MLClose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLClose"], 
     RowBox[{"(", 
      RowBox[{"MLINK", " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[TextData[{
     "close a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection"
    }], "TableText"]},
   {
    RowBox[{"void", 
     ButtonBox["MLDeinitialize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDeinitialize"], 
     RowBox[{"(", 
      RowBox[{"MLENV", " ", 
       StyleBox["env", "TI"]}], ")"}]}], Cell[TextData[{
     "deinitialize ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " library functions"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, True, {False}, False},
    "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9850],

Cell[TextData[{
 "Opening and closing ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections. "
}], "Caption",
 CellID->17022],

Cell[TextData[{
 "Include the standard ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file. "
}], "MathCaption",
 CellID->21911],

Cell["\<\
#include \"mathlink.h\"
\
\>", "Program",
 CellID->9492],

Cell["int main(int argc, char *argv[]) {", "Program",
 CellID->5651],

Cell["\<\
   MLENV env;
   MLINK link;
   int errno;
\
\>", "Program",
 CellID->28580],

Cell[TextData[{
 "This initializes ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions. "
}], "MathCaption",
 CellID->15477],

Cell["   env = MLInitialize(0);", "Program",
 CellID->27616],

Cell[TextData[{
 "This opens a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection, using the same arguments as were passed to the main program. "
}], "MathCaption",
 CellID->29876],

Cell["   link = MLOpenArgcArgv(env, argc, argv, &errno);", "Program",
 CellID->19178],

Cell["\<\
This activates the connection, waiting for the other program to respond.\
\>", "MathCaption",
 CellID->5220],

Cell["   MLActivate(link);", "Program",
 CellID->14615],

Cell["\<\
   ...
}\
\>", "Program",
 CellID->22348],

Cell[TextData[{
 "Often the ",
 Cell[BoxData["argv"], "InlineFormula"],
 " that you pass to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLOpenArgcArgv",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLOpenArgv"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " will come directly from the ",
 Cell[BoxData["argv"], "InlineFormula"],
 " that is passed to ",
 Cell[BoxData[
  RowBox[{"main", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " when your whole program is started. "
}], "Text",
 CellID->32179],

Cell[TextData[{
 "The elements in the ",
 Cell[BoxData["argv"], "InlineFormula"],
 " array are character strings which mirror the arguments and options used in \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions ",
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->31635],

Cell[BoxData[GridBox[{
   {"\"\<-linklaunch\>\"", Cell[TextData[{
     "operate like ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkLaunch",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkLaunch"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"]
    }], "TableText"]},
   {"\"\<-linkcreate\>\"", Cell[TextData[{
     "operate like ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkCreate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkCreate"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"]
    }], "TableText"]},
   {"\"\<-linkconnect\>\"", Cell[TextData[{
     "operate like ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkConnect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkConnect"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"\"\<-linkname\>\"", ",", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], Cell[
    "give the name to use", "TableText"]},
   {
    RowBox[{"\"\<-linkprotocol\>\"", ",", "\"\<\!\(\*
StyleBox[\"protocol\", \"TI\"]\)\>\""}], Cell[TextData[{
     "give the link protocol to use (",
     Cell[BoxData["TCPIP"], "InlineFormula"],
     ", ",
     Cell[BoxData["Pipes"], "InlineFormula"],
     ", etc.)"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, {True}, False}, "RowsIndexed" -> {}},
 
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16857],

Cell[TextData[{
 "Possible elements of the ",
 Cell[BoxData["argv"], "InlineFormula"],
 " array passed to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLOpenArgcArgv",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLOpenArgv"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 "."
}], "Caption",
 CellID->2883],

Cell[TextData[{
 "As an alternative to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLOpenArgcArgv",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLOpenArgv"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " you can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLOpenString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLOpenString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ", which takes parameters concatenated into a single character string with \
spaces in between. "
}], "Text",
 CellID->1662],

Cell[TextData[{
 "Once you have successfully opened a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, you can then use standard ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions to exchange data with it. "
}], "Text",
 CellID->18902],

Cell[BoxData[GridBox[{
   {
    RowBox[{"int", 
     ButtonBox["MLEndPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLEndPacket"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[
    "indicate the end of a packet", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLNextPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLNewPacket"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[
    "find the head of the next packet", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLNewPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLNewPacket"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[
    "skip to the end of the current packet", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28262],

Cell[TextData[{
 "Functions often used in communicating with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. "
}], "Caption",
 CellID->19420],

Cell[TextData[{
 "Once you have sent all the pieces of a packet using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutFunction"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " etc., ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " requires you to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLEndPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLEndPacket"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to ensure synchronization and consistency. "
}], "Text",
 CellID->19770],

Cell[TextData[{
 "One of the main issues in writing an external program which communicates \
directly with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is handling all the various kinds of packets that the kernel can \
generate. "
}], "Text",
 CellID->19022],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLNextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLNextPacket"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " finds the head of the next packet that comes from the kernel, and returns \
a constant that indicates the type of the packet. "
}], "Text",
 CellID->9273],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " packet"
    }], "TableHeader"], Cell["constant", "TableHeader"], ""},
   {
    RowBox[{
     ButtonBox["ReturnPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReturnPacket"], "[", 
     StyleBox["expr", "TI"], "]"}], "RETURNPKT", Cell[
    "result from a computation", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReturnTextPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReturnTextPacket"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], "RETURNTEXTPKT", Cell[
    "textual form of a result", "TableText"]},
   {
    RowBox[{
     ButtonBox["InputNamePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputNamePacket"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], "INPUTNAMEPKT", Cell[
    "name of an input line", "TableText"]},
   {
    RowBox[{
     ButtonBox["OutputNamePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OutputNamePacket"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], "OUTPUTNAMEPKT", Cell[
    "name of an output line", "TableText"]},
   {
    RowBox[{
     ButtonBox["TextPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TextPacket"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], "TEXTPKT", Cell[TextData[{
     "textual output from functions like ",
     Cell[BoxData[
      ButtonBox["Print",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Print"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MessagePacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MessagePacket"], "[", 
     StyleBox["symb", "TI"], ",", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", "]"}], "MESSAGEPKT", Cell[TextData[{
     "name of a message generated by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InputPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputPacket"], "[", "\"\<\!\(\*
StyleBox[\"prompt\", \"TI\"]\)\>\"", "]"}], "INPUTPKT", Cell[TextData[{
     "request for a response to an ",
     Cell[BoxData[
      ButtonBox["Input",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Input"]], "InlineFormula"],
     " function"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CallPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CallPacket"], "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["list", "TI"], "]"}], "CALLPKT", Cell[
    "request for a call to an external function", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25841],

Cell[TextData[{
 "Some packets recognized by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLNextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLNextPacket"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->12686],

Cell[TextData[{
 "This keeps on reading data from a link, discarding it until an error or a \
",
 Cell[BoxData[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"]], "InlineFormula"],
 " is found. "
}], "MathCaption",
 CellID->3917],

Cell["\<\
while ((p = MLNextPacket(link)) && p != RETURNPKT)
    MLNewPacket(link);\
\>", "Program",
 CellID->31717],

Cell[TextData[{
 "If you want to write a complete front end to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you will need to handle all of the possible types of packets that the \
kernel can generate. Typically you can do this by setting up an appropriate \
",
 Cell[BoxData["switch"], "InlineFormula"],
 " on the value returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLNextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLNextPacket"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13698],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit contains sample source code for several simple but complete \
front ends. "
}], "Text",
 CellID->11267],

Cell[BoxData[GridBox[{
   {
    RowBox[{"int", 
     ButtonBox["MLReady",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReady"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell[
    "test whether there is data waiting to be read on a link", "TableText"]},
   {
    RowBox[{"int", " ", 
     ButtonBox["MLReadyParallel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLReadyParallel"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        ButtonBox["MLENV",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLENV"], " ", 
        StyleBox["e", "TI"]}], ",", " ", 
       RowBox[{
        ButtonBox["MLINK",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/c/MLINK"], " ", "*", 
        StyleBox["links", "TI"]}], ",", " ", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}], ",", " ", 
       RowBox[{"mltimeval", " ", 
        StyleBox["t", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
test in parallel whether there is data to be read from a list of links\
\>", "TableText"]},
   {
    RowBox[{"int", 
     ButtonBox["MLFlush",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLFlush"], 
     RowBox[{"(", 
      RowBox[{
       ButtonBox["MLINK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/c/MLINK"], " ", 
       StyleBox["link", "TI"]}], ")"}]}], Cell["\<\
flush out buffers containing data waiting to be sent on a link\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11749],

Cell["Flow of data on links. ", "Caption",
 CellID->65],

Cell[TextData[{
 "One feature of more sophisticated external programs such as front ends is \
that they may need to perform operations while they are waiting for data to \
be sent to them by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". When you call a standard ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library function such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLNextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLNextPacket"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " your program will normally block until all the data needed by this \
function is available."
}], "Text",
 CellID->10389],

Cell[TextData[{
 "You can avoid blocking by repeatedly calling ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLReady",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLReady"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ", and only calling functions like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLNextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLNextPacket"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " when ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLReady",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLReady"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " no longer returns ",
 Cell[BoxData["0"], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLReady",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLReady"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " is the analog of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["LinkReadyQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->6932],

Cell[TextData[{
 "Note that ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " sometimes buffers the data that you tell it to send. To make sure that all \
necessary data has been sent you should call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLFlush",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLFlush"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". Only after doing this does it make sense to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLReady",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLFlush"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " and wait for data to be sent back. "
}], "Text",
 CellID->25619],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->266395279],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Running Mathematica from Within an External Program - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ErrorAndInterruptHandling"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 26.6691226}", "context" -> "", 
    "keywords" -> {
     "argv array", "blocking", "CallPacket", "command-line arguments", 
      "command line", "InputNamePacket", "InputPacket", "main()", 
      "MessagePacket", "MLActivate()", "MLClose()", "MLDeinitialize()", 
      "MLEndPacket()", "MLFlush()", "MLInitialize()", "MLNewPacket()", 
      "MLNextPacket()", "MLOpenArgv()", "MLOpenString()", "MLReady()", 
      "nonblocking reads", "OutputNamePacket", "packets", "polling", 
      "ReturnPacket", "ReturnTextPacket", "TextPacket", "waiting"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "To run Mathematica from within an external program requires making use \
of many general features of MathLink. The first issue is how to establish a \
MathLink connection to Mathematica. When you use MathLink templates to create \
external programs that can be called from Mathematica, source code to \
establish a MathLink connection is automatically generated, and all you have \
to do in your external program is to call MLMain(argc,argv). But in general \
you need to call several functions to establish a MathLink connection. \
Opening and closing MathLink connections. ", "synonyms" -> {"2.13.14"}, 
    "title" -> "Running Mathematica from Within an External Program", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/RunningMathematicaFromWithinAnExternalProgram"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.14"->{
  Cell[3660, 86, 175, 7, 70, "Title",
   CellTags->{"S2.13.14", "14.1"},
   CellID->31088]},
 "14.1"->{
  Cell[3660, 86, 175, 7, 70, "Title",
   CellTags->{"S2.13.14", "14.1"},
   CellID->31088]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.14", 28835, 951},
 {"14.1", 28939, 955}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3035, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3660, 86, 175, 7, 70, "Title",
 CellTags->{"S2.13.14", "14.1"},
 CellID->31088],
Cell[3838, 95, 403, 16, 70, "Text",
 CellID->1563],
Cell[4244, 113, 782, 26, 70, "Text",
 CellID->25834],
Cell[5029, 141, 3451, 114, 70, "DefinitionBox",
 CellID->9850],
Cell[8483, 257, 135, 6, 70, "Caption",
 CellID->17022],
Cell[8621, 265, 140, 6, 70, "MathCaption",
 CellID->21911],
Cell[8764, 273, 66, 4, 70, "Program",
 CellID->9492],
Cell[8833, 279, 68, 1, 70, "Program",
 CellID->5651],
Cell[8904, 282, 86, 6, 70, "Program",
 CellID->28580],
Cell[8993, 290, 142, 6, 70, "MathCaption",
 CellID->15477],
Cell[9138, 298, 60, 1, 70, "Program",
 CellID->27616],
Cell[9201, 301, 192, 6, 70, "MathCaption",
 CellID->29876],
Cell[9396, 309, 85, 1, 70, "Program",
 CellID->19178],
Cell[9484, 312, 118, 3, 70, "MathCaption",
 CellID->5220],
Cell[9605, 317, 55, 1, 70, "Program",
 CellID->14615],
Cell[9663, 320, 51, 4, 70, "Program",
 CellID->22348],
Cell[9717, 326, 509, 18, 70, "Text",
 CellID->32179],
Cell[10229, 346, 655, 24, 70, "Text",
 CellID->31635],
Cell[10887, 372, 1720, 50, 70, "DefinitionBox",
 CellID->16857],
Cell[12610, 424, 312, 12, 70, "Caption",
 CellID->2883],
Cell[12925, 438, 523, 18, 70, "Text",
 CellID->1662],
Cell[13451, 458, 330, 12, 70, "Text",
 CellID->18902],
Cell[13784, 472, 1459, 45, 70, "DefinitionBox",
 CellID->28262],
Cell[15246, 519, 160, 6, 70, "Caption",
 CellID->19420],
Cell[15409, 527, 571, 20, 70, "Text",
 CellID->19770],
Cell[15983, 549, 279, 8, 70, "Text",
 CellID->19022],
Cell[16265, 559, 360, 11, 70, "Text",
 CellID->9273],
Cell[16628, 572, 3006, 88, 70, "DefinitionBox3Col",
 CellID->25841],
Cell[19637, 662, 253, 10, 70, "Caption",
 CellID->12686],
Cell[19893, 674, 272, 9, 70, "MathCaption",
 CellID->3917],
Cell[20168, 685, 116, 4, 70, "Program",
 CellID->31717],
Cell[20287, 691, 548, 17, 70, "Text",
 CellID->13698],
Cell[20838, 710, 191, 7, 70, "Text",
 CellID->11267],
Cell[21032, 719, 1900, 58, 70, "DefinitionBox",
 CellID->11749],
Cell[22935, 779, 55, 1, 70, "Caption",
 CellID->65],
Cell[22993, 782, 644, 19, 70, "Text",
 CellID->10389],
Cell[23640, 803, 1077, 41, 70, "Text",
 CellID->6932],
Cell[24720, 846, 646, 21, 70, "Text",
 CellID->25619],
Cell[CellGroupData[{
Cell[25391, 871, 72, 1, 70, "RelatedTutorialsSection",
 CellID->266395279],
Cell[25466, 874, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[25871, 889, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

