(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11442,        374]
NotebookOptionsPosition[      7164,        251]
NotebookOutlinePosition[     10164,        327]
CellTagsIndexPosition[     10072,        321]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "LinkConnect" :> 
          Documentation`HelpLookup["paclet:ref/LinkConnect"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Install\"\>", 
       2->"\<\"LinkConnect\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Running Programs on Remote Computers", "Title",
 CellTags->{"S2.13.10", "10.1"},
 CellID->16081],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " allows you to call an external program from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " even when that program is running on a remote computer. Typically, you \
need to start the program directly from the operating system on the remote \
computer. But then you can connect to it using commands within your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->2003],

Cell[TextData[{
 "Operating system on ",
 StyleBox["toad.wolfram.com", "MR"]
}], "SessionLabel",
 CellID->29130],

Cell[TextData[{
 "This starts the program ",
 Cell[BoxData["fprog"], "InlineFormula"],
 " and tells it to create a new link."
}], "MathCaption",
 CellID->13028],

Cell[TextData[StyleBox["fprog -linkcreate -linkprotocol TCPIP", "MB"]], \
"Program",
 CellID->18631],

Cell["\<\
The program responds with the specification of the link it has created. \
\>", "MathCaption",
 CellID->14589],

Cell[TextData[{
 "Link",
 StyleBox[" ", "TR"],
 "created",
 StyleBox[" ", "TR"],
 "on:",
 StyleBox[" ", "TR"],
 "2976@toad.wolfram.com,2977@toad.wolfram.com "
}], "Program",
 CellID->23152],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session on ",
 StyleBox["frog.wolfram.com", "MR"]
}], "SessionLabel",
 CellID->18630],

Cell["This connects to the link that has been created. ", "MathCaption",
 CellID->19172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Install", "[", 
  RowBox[{"LinkConnect", "[", 
   RowBox[{"\"\<2976@toad.wolfram.com,2977@toad.wolfram.com\>\"", ",", 
    RowBox[{"LinkProtocol", "\[Rule]", "\"\<TCPIP\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19864],

Cell["\<\
LinkObject[2976@toad.wolfram.com,2977@toad.wolfram.com, 1, 1]\
\>", "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6407]
}, Open  ]],

Cell[TextData[{
 "This now executes code in the external program on ",
 Cell[BoxData[
  RowBox[{"toad", ".", "wolfram", ".", "com"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "16", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25428],

Cell["561243", "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29681]
}, Open  ]],

Cell[TextData[{
 "External programs that are created using ",
 Cell[BoxData["mcc"], "InlineFormula"],
 " or ",
 Cell[BoxData["mprep"], "InlineFormula"],
 " always contain the code that is needed to set up ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections. If you start such programs directly from your operating \
system, they will prompt you to specify what kind of connection you want. \
Alternatively, if your operating system supports it, you can also give this \
information as a command\[Hyphen]line argument to the external program. "
}], "Text",
 CellID->18490],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["prog", "TI"], "-", "linkcreate", " ", "-", 
     RowBox[{"linkprotocol", " ", "TCPIP"}]}], Cell["\<\
operating system command to run a program and have it create a link\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Install",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Install"], "[", 
     RowBox[{
      ButtonBox["LinkConnect",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkConnect"], "[", 
      StyleBox[
       RowBox[{"\"\<\!\(\*
StyleBox[\"port1\", \"TI\"]\)@\!\(\*
StyleBox[\"host\", \"TI\"]\),\!\(\*
StyleBox[\"port2\", \"TI\"]\)@\!\(\*
StyleBox[\"host\", \"TI\"]\)\>\"", ",", 
        RowBox[{"LinkProtocol", "->", "\"\<TCPIP\>\""}]}],
       ShowStringCharacters->True], "]"}], "]"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " command to connect to the external program"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26610],

Cell["Running an external program on a remote computer. ", "Caption",
 CellID->26177],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->450274643],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Running Programs on Remote Computers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/RunningExternalProgramsUnderADebugger"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 27.4035164}", "context" -> "", 
    "keywords" -> {
     "command line arguments", "external programs", "networks", 
      "remote computers", "RPC"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "MathLink allows you to call an external program from within Mathematica \
even when that program is running on a remote computer. Typically, you need \
to start the program directly from the operating system on the remote \
computer. But then you can connect to it using commands within your \
Mathematica session. This starts the program fprog and tells it to create a \
new link. The program responds with the specification of the link it has \
created. ", "synonyms" -> {"2.13.10"}, "title" -> 
    "Running Programs on Remote Computers", "type" -> "Tutorial", "uri" -> 
    "tutorial/RunningProgramsOnRemoteComputers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.10"->{
  Cell[1980, 61, 102, 2, 70, "Title",
   CellTags->{"S2.13.10", "10.1"},
   CellID->16081]},
 "10.1"->{
  Cell[1980, 61, 102, 2, 70, "Title",
   CellTags->{"S2.13.10", "10.1"},
   CellID->16081]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.10", 9852, 310},
 {"10.1", 9956, 314}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1355, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1980, 61, 102, 2, 70, "Title",
 CellTags->{"S2.13.10", "10.1"},
 CellID->16081],
Cell[2085, 65, 481, 13, 70, "Text",
 CellID->2003],
Cell[2569, 80, 112, 4, 70, "SessionLabel",
 CellID->29130],
Cell[2684, 86, 160, 5, 70, "MathCaption",
 CellID->13028],
Cell[2847, 93, 100, 2, 70, "Program",
 CellID->18631],
Cell[2950, 97, 119, 3, 70, "MathCaption",
 CellID->14589],
Cell[3072, 102, 189, 9, 70, "Program",
 CellID->23152],
Cell[3264, 113, 153, 6, 70, "SessionLabel",
 CellID->18630],
Cell[3420, 121, 88, 1, 70, "MathCaption",
 CellID->19172],
Cell[CellGroupData[{
Cell[3533, 126, 268, 7, 70, "Input",
 CellID->19864],
Cell[3804, 135, 263, 9, 36, "Output",
 CellID->6407]
}, Open  ]],
Cell[4082, 147, 193, 6, 70, "MathCaption",
 CellID->12295],
Cell[CellGroupData[{
Cell[4300, 157, 94, 3, 70, "Input",
 CellID->25428],
Cell[4397, 162, 150, 5, 36, "Output",
 CellID->29681]
}, Open  ]],
Cell[4562, 170, 583, 13, 70, "Text",
 CellID->18490],
Cell[5148, 185, 1396, 39, 70, "DefinitionBox",
 CellID->26610],
Cell[6547, 226, 85, 1, 70, "Caption",
 CellID->26177],
Cell[CellGroupData[{
Cell[6657, 231, 72, 1, 70, "RelatedTutorialsSection",
 CellID->450274643],
Cell[6732, 234, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[7137, 249, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

