(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15045,        523]
NotebookOptionsPosition[     10115,        381]
NotebookOutlinePosition[     13352,        460]
CellTagsIndexPosition[     13261,        454]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Select" :> Documentation`HelpLookup["paclet:ref/Select"], 
          "True" :> Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Select\"\>", 
       2->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Selecting Parts of Expressions with Functions", "Title",
 CellTags->{"S2.2.7", "7.1"},
 CellID->5821],

Cell[TextData[{
 "\"",
 ButtonBox["Manipulating Elements of Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingElementsOfLists"],
 "\" showed how you can pick out elements of lists based on their ",
 StyleBox["positions",
  FontSlant->"Italic"],
 ". Often, however, you will need to select elements based not on ",
 StyleBox["where",
  FontSlant->"Italic"],
 " they are, but rather on ",
 StyleBox["what",
  FontSlant->"Italic"],
 " they are. "
}], "Text",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Select",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Select"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " selects elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " using the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " as a criterion. ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to each element of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " in turn, and keeps only those for which the result is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->2520],

Cell[TextData[{
 "This selects the elements of the list for which the pure function yields ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", i.e., those numerically greater than 4. "
}], "MathCaption",
 CellID->12927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "15", ",", "1", ",", "a", ",", "16", ",", "17"}], "}"}],
    ",", 
   RowBox[{
    RowBox[{"#", ">", "4"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->24773],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"15", ",", "16", ",", "17"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->25134]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " to pick out pieces of any expression, not just elements of a list. "
}], "Text",
 CellID->27251],

Cell[TextData[{
 "This gives a sum of terms involving ",
 Cell[BoxData["x"], "InlineFormula"],
 ", ",
 Cell[BoxData["y"], "InlineFormula"],
 " and ",
 Cell[BoxData["z"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z"}], ")"}], "^", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->13336],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"2", " ", "x", " ", "y"}], "+", 
  SuperscriptBox["y", "2"], "+", 
  RowBox[{"2", " ", "x", " ", "z"}], "+", 
  RowBox[{"2", " ", "y", " ", "z"}], "+", 
  SuperscriptBox["z", "2"]}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->16334]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 " to pick out only those terms in the sum that do not involve the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"t", ",", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->2737],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["y", "2"], "+", 
  RowBox[{"2", " ", "y", " ", "z"}], "+", 
  SuperscriptBox["z", "2"]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->9310]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Select",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Select"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "select the elements in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " for which the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Select",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Select"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["f", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "select the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " for which the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5974],

Cell["Selecting pieces of expressions. ", "Caption",
 CellID->7590],

Cell[TextData[{
 "\"",
 ButtonBox["Putting Constraints on Patterns",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"],
 "\" discusses some \[OpenCurlyDoubleQuote]predicates\[CloseCurlyDoubleQuote] \
that are often used as criteria in ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20356],

Cell["\<\
This gives the first element which satisfies the criterion you specify. \
\>", "MathCaption",
 CellID->1071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "3", ",", "10", ",", "12", ",", "14"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"#", ">", "3"}], "&"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->32080],

Cell[BoxData[
 RowBox[{"{", "10", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->10935]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->137601613],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->264993741],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->63922238],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->57646210]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Selecting Parts of Expressions with Functions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/BuildingListsFromFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 34.0599368}", "context" -> "", 
    "keywords" -> {
     "choose elements", "compress in APL", "criteria", "deleting elements", 
      "discard list elements", "elements of expressions", "expressions", 
      "filtering lists", "first occurrence", "lists", "mu operator", 
      "picking elements of lists", "predicates", "satisfying criterion", 
      "select", "subsets"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "\"Manipulating Elements of Lists\" showed how you can pick out elements \
of lists based on their positions. Often, however, you will need to select \
elements based not on where they are, but rather on what they are. \
Select[list,f] selects elements of list using the function f as a criterion. \
Select applies f to each element of list in turn, and keeps only those for \
which the result is True. This selects the elements of the list for which the \
pure function yields True, i.e., those numerically greater than 4. ", 
    "synonyms" -> {"2.2.7"}, "title" -> 
    "Selecting Parts of Expressions with Functions", "type" -> "Tutorial", 
    "uri" -> "tutorial/SelectingPartsOfExpressionsWithFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.7"->{
  Cell[1887, 59, 107, 2, 70, "Title",
   CellTags->{"S2.2.7", "7.1"},
   CellID->5821]},
 "7.1"->{
  Cell[1887, 59, 107, 2, 70, "Title",
   CellTags->{"S2.2.7", "7.1"},
   CellID->5821]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.7", 13050, 443},
 {"7.1", 13149, 447}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1262, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1887, 59, 107, 2, 70, "Title",
 CellTags->{"S2.2.7", "7.1"},
 CellID->5821],
Cell[1997, 63, 493, 16, 70, "Text",
 CellID->13855],
Cell[2493, 81, 895, 33, 70, "Text",
 CellID->2520],
Cell[3391, 116, 285, 8, 70, "MathCaption",
 CellID->12927],
Cell[CellGroupData[{
Cell[3701, 128, 262, 9, 28, "Input",
 CellID->24773],
Cell[3966, 139, 213, 7, 36, "Output",
 CellID->25134]
}, Open  ]],
Cell[4194, 149, 247, 8, 70, "Text",
 CellID->27251],
Cell[4444, 159, 228, 9, 70, "MathCaption",
 CellID->22675],
Cell[CellGroupData[{
Cell[4697, 172, 207, 7, 28, "Input",
 CellID->13336],
Cell[4907, 181, 389, 12, 36, "Output",
 CellID->16334]
}, Open  ]],
Cell[5311, 196, 303, 10, 70, "MathCaption",
 CellID->21001],
Cell[CellGroupData[{
Cell[5639, 210, 200, 7, 70, "Input",
 CellID->2737],
Cell[5842, 219, 267, 9, 36, "Output",
 CellID->9310]
}, Open  ]],
Cell[6124, 231, 1569, 51, 70, "DefinitionBox",
 CellID->5974],
Cell[7696, 284, 67, 1, 70, "Caption",
 CellID->7590],
Cell[7766, 287, 419, 13, 70, "Text",
 CellID->20356],
Cell[8188, 302, 118, 3, 70, "MathCaption",
 CellID->1071],
Cell[CellGroupData[{
Cell[8331, 309, 283, 10, 70, "Input",
 CellID->32080],
Cell[8617, 321, 178, 6, 36, "Output",
 CellID->10935]
}, Open  ]],
Cell[CellGroupData[{
Cell[8832, 332, 72, 1, 70, "RelatedTutorialsSection",
 CellID->137601613],
Cell[8907, 335, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]],
Cell[CellGroupData[{
Cell[9118, 344, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->264993741],
Cell[9219, 347, 413, 13, 70, "TutorialRelatedLinks",
 CellID->63922238],
Cell[9635, 362, 426, 13, 70, "TutorialRelatedLinks",
 CellID->57646210]
}, Open  ]]
}, Open  ]],
Cell[10088, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

