(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11358,        417]
NotebookOptionsPosition[      7411,        290]
NotebookOutlinePosition[      9741,        354]
CellTagsIndexPosition[      9650,        348]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sequence\"\>"}, "\<\"functions\"\>",
        
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sequences", "Title",
 CellTags->{"S2.2.11", "11.1"},
 CellID->32145],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " allows you to explicitly flatten out all sublists. "
}], "MathCaption",
 CellID->17282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->1825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->18718]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FlattenAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlattenAt"]], "InlineFormula"],
 " lets you specify at what positions you want sublists flattened. "
}], "MathCaption",
 CellID->13573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FlattenAt", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->4712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->13037]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects automatically get spliced in, and do not require any explicit \
flattening. "
}], "MathCaption",
 CellID->4998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"d", ",", "e"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->9905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->7162]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sequence"], "[", 
     SubscriptBox[
      StyleBox["e", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell["\<\
a sequence of arguments that will automatically be spliced into any function\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1717],

Cell["Representing sequences of arguments in functions. ", "Caption",
 CellID->8692],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " works in any function. "
}], "MathCaption",
 CellID->19539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"Sequence", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->28047],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->10946]
}, Open  ]],

Cell["This includes functions with special input forms. ", "MathCaption",
 CellID->19103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "==", 
  RowBox[{"Sequence", "[", 
   RowBox[{"b", ",", "c"}], "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->30231],

Cell[BoxData[
 RowBox[{"a", "\[Equal]", "b", "\[Equal]", "c"}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->24115]
}, Open  ]],

Cell[TextData[{
 "Here is a common way that ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"g", "[", "w", "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"z", ",", "y"}], "]"}]}], "}"}], "/.", 
  RowBox[{"f", "->", "Sequence"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->25858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "y", ",", 
   RowBox[{"g", "[", "w", "]"}], ",", "z", ",", "y"}], "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->20829]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->678963871],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sequences - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/StructuralOperations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 34.3255686}", "context" -> "", 
    "keywords" -> {
     "removing sublists", "runs of arguments", "sequence", "splicing", 
      "Sublists", "unpack"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The function Flatten allows you to explicitly flatten out all sublists. \
FlattenAt lets you specify at what positions you want sublists flattened. \
Sequence objects automatically get spliced in, and do not require any \
explicit flattening. ", "synonyms" -> {"2.2.11"}, "title" -> "Sequences", 
    "type" -> "Tutorial", "uri" -> "tutorial/Sequences"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.11"->{
  Cell[1819, 59, 74, 2, 70, "Title",
   CellTags->{"S2.2.11", "11.1"},
   CellID->32145]},
 "11.1"->{
  Cell[1819, 59, 74, 2, 70, "Title",
   CellTags->{"S2.2.11", "11.1"},
   CellID->32145]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.11", 9434, 337},
 {"11.1", 9536, 341}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1194, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1819, 59, 74, 2, 70, "Title",
 CellTags->{"S2.2.11", "11.1"},
 CellID->32145],
Cell[1896, 63, 241, 8, 70, "MathCaption",
 CellID->17282],
Cell[CellGroupData[{
Cell[2162, 75, 258, 9, 28, "Input",
 CellID->1825],
Cell[2423, 86, 230, 7, 36, "Output",
 CellID->18718]
}, Open  ]],
Cell[2668, 96, 240, 7, 70, "MathCaption",
 CellID->13573],
Cell[CellGroupData[{
Cell[2933, 107, 289, 10, 28, "Input",
 CellID->4712],
Cell[3225, 119, 270, 9, 36, "Output",
 CellID->13037]
}, Open  ]],
Cell[3510, 131, 257, 8, 70, "MathCaption",
 CellID->4998],
Cell[CellGroupData[{
Cell[3792, 143, 243, 8, 28, "Input",
 CellID->9905],
Cell[4038, 153, 229, 7, 36, "Output",
 CellID->7162]
}, Open  ]],
Cell[4282, 163, 724, 21, 70, "DefinitionBox",
 CellID->1717],
Cell[5009, 186, 84, 1, 70, "Caption",
 CellID->8692],
Cell[5096, 189, 197, 7, 70, "MathCaption",
 CellID->19539],
Cell[CellGroupData[{
Cell[5318, 200, 178, 6, 70, "Input",
 CellID->28047],
Cell[5499, 208, 215, 7, 36, "Output",
 CellID->10946]
}, Open  ]],
Cell[5729, 218, 89, 1, 70, "MathCaption",
 CellID->19103],
Cell[CellGroupData[{
Cell[5843, 223, 149, 5, 70, "Input",
 CellID->30231],
Cell[5995, 230, 201, 6, 36, "Output",
 CellID->24115]
}, Open  ]],
Cell[6211, 239, 212, 8, 70, "MathCaption",
 CellID->839],
Cell[CellGroupData[{
Cell[6448, 251, 340, 11, 70, "Input",
 CellID->25858],
Cell[6791, 264, 280, 8, 36, "Output",
 CellID->20829]
}, Open  ]],
Cell[CellGroupData[{
Cell[7108, 277, 72, 1, 70, "RelatedTutorialsSection",
 CellID->678963871],
Cell[7183, 280, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],
Cell[7384, 288, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

