(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29933,        919]
NotebookOptionsPosition[     23854,        738]
NotebookOutlinePosition[     27066,        814]
CellTagsIndexPosition[     26973,        808]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Except" :> Documentation`HelpLookup["paclet:ref/Except"], 
          "FilterRules" :> Documentation`HelpLookup["paclet:ref/FilterRules"],
           "Options" :> Documentation`HelpLookup["paclet:ref/Options"], 
          "OptionsPattern" :> 
          Documentation`HelpLookup["paclet:ref/OptionsPattern"], 
          "OptionValue" :> 
          Documentation`HelpLookup["paclet:ref/OptionValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Except\"\>", 
       2->"\<\"FilterRules\"\>", 3->"\<\"Options\"\>", 
       4->"\<\"OptionsPattern\"\>", 
       5->"\<\"OptionValue\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Setting Up Functions with Optional Arguments", "Title",
 CellTags->{"S2.3.10", "10.1"},
 CellID->14984],

Cell["\<\
When you define a complicated function, you will often want to let some of \
the arguments of the function be \[OpenCurlyDoubleQuote]optional\
\[CloseCurlyDoubleQuote]. If you do not give those arguments explicitly, you \
want them to take on certain \[OpenCurlyDoubleQuote]default\
\[CloseCurlyDoubleQuote] values.\
\>", "Text",
 CellID->16339],

Cell[TextData[{
 "Built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions use two basic methods for dealing with optional arguments. You \
can choose between the same two methods when you define your own functions in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->2556],

Cell[TextData[{
 "The first method is to have the meaning of each argument determined by its \
position, and then to allow one to drop arguments, replacing them by default \
values. Almost all built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions that use this method drop arguments from the end. For example, \
the built\[Hyphen]in function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " allows you to drop the second argument, which is taken to have a default \
value of ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->25808],

Cell[TextData[{
 "You can implement this kind of \[OpenCurlyDoubleQuote]positional\
\[CloseCurlyDoubleQuote] argument using ",
 Cell[BoxData[
  RowBox[{"_", ":"}]], "InlineFormula"],
 " patterns. "
}], "Text",
 CellID->4632],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], ",", 
     StyleBox["k", "TI"], 
     StyleBox["_", "MR"], 
     StyleBox[":", "MR"], 
     StyleBox["kdef", "TI"], "]", ":=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "a typical definition for a function whose second argument is optional, \
with default value ",
     Cell[BoxData[
      StyleBox["kdef", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21478],

Cell["Defining a function with positional arguments. ", "Caption",
 CellID->26814],

Cell[TextData[{
 "This defines a function with an optional second argument. When the second \
argument is omitted, it is taken to have the default value ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13787],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"list_", ",", 
    RowBox[{"n_:", "Infinity"}]}], "]"}], ":=", 
  RowBox[{"f0", "[", 
   RowBox[{"list", ",", "n"}], "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->7239],

Cell["Here is a function with two optional arguments. ", "MathCaption",
 CellID->28074],

Cell[BoxData[
 RowBox[{
  RowBox[{"fx", "[", 
   RowBox[{"list_", ",", 
    RowBox[{"n1_:", "1"}], ",", 
    RowBox[{"n2_:", "2"}]}], "]"}], ":=", 
  RowBox[{"fx0", "[", 
   RowBox[{"list", ",", "n1", ",", "n2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->25020],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that arguments are dropped from the end. As a result ",
 Cell[BoxData["m"], "InlineFormula"],
 " here gives the value of ",
 Cell[BoxData["n1"], "InlineFormula"],
 ", while ",
 Cell[BoxData["n2"], "InlineFormula"],
 " has its default value of ",
 Cell[BoxData["2"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fx", "[", 
  RowBox[{"k", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->2554],

Cell[BoxData[
 RowBox[{"fx0", "[", 
  RowBox[{"k", ",", "m", ",", "2"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->1988]
}, Open  ]],

Cell[TextData[{
 "The second method that built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions use for dealing with optional arguments is to give explicit \
names to the optional arguments, and then to allow their values to be given \
using transformation rules. This method is particularly convenient for \
functions like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " which have a very large number of optional parameters, only a few of which \
usually need to be set in any particular instance."
}], "Text",
 CellID->7441],

Cell[TextData[{
 "The typical arrangement is that values for \[OpenCurlyDoubleQuote]named\
\[CloseCurlyDoubleQuote] optional arguments can be specified by including the \
appropriate transformation rules at the end of the arguments to a particular \
function. Thus, for example, the rule ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joined",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Joined"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", which specifies the setting for the named optional argument ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 ", could appear as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16798],

Cell[TextData[{
 "When you set up named optional arguments for a function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", it is conventional to store the default values of these arguments as a \
list of transformation rules assigned to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->13642],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      StyleBox["f", "TI"], "[", 
      RowBox[{
       StyleBox["x_", "TI"], ",", 
       RowBox[{
        ButtonBox["OptionsPattern",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/OptionsPattern"], "[", "]"}]}], "]"}], ":=", 
     
     StyleBox["value", "TI"]}], Cell["\<\
a typical definition for a function with zero or more named optional \
arguments\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["OptionValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OptionValue"], "[", 
     StyleBox["name", "TI"], "]"}], Cell["\<\
the value of a named optional argument in the body of the function\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19002],

Cell["Named arguments. ", "Caption",
 CellID->16321],

Cell[TextData[{
 "This sets up default values for two named optional arguments ",
 Cell[BoxData["opt1"], "InlineFormula"],
 " and ",
 Cell[BoxData["opt2"], "InlineFormula"],
 " in the function ",
 Cell[BoxData["fn"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Options", "[", "fn", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"opt1", "->", "1"}], ",", 
    RowBox[{"opt2", "->", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->13946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"opt1", "\[Rule]", "1"}], ",", 
   RowBox[{"opt2", "\[Rule]", "2"}]}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->7056]
}, Open  ]],

Cell[TextData[{
 "Here is the definition for a function ",
 Cell[BoxData["fn"], "InlineFormula"],
 " which allows zero or more named optional arguments to be specified. "
}], "MathCaption",
 CellID->14804],

Cell[BoxData[
 RowBox[{
  RowBox[{"fn", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
  RowBox[{"k", "[", 
   RowBox[{"x", ",", 
    RowBox[{"OptionValue", "[", "opt2", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26385],

Cell[TextData[{
 "With no optional arguments specified, the default rule for ",
 Cell[BoxData["opt2"], "InlineFormula"],
 " is used."
}], "MathCaption",
 CellID->10142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fn", "[", "4", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->18842],

Cell[BoxData[
 RowBox[{"k", "[", 
  RowBox[{"4", ",", "2"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->301275276]
}, Open  ]],

Cell[TextData[{
 "If you explicitly give a rule for ",
 Cell[BoxData["opt2"], "InlineFormula"],
 ", it will override the default rules stored in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", "fn", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fn", "[", 
  RowBox[{"4", ",", 
   RowBox[{"opt2", "->", "7"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->31620],

Cell[BoxData[
 RowBox[{"k", "[", 
  RowBox[{"4", ",", "7"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->105003172]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FilterRules",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FilterRules"], "[", 
     RowBox[{
      StyleBox["opts", "TI"], ",", " ", 
      RowBox[{
       ButtonBox["Options",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Options"], "[", 
       StyleBox["name", "TI"], "]"}]}], "]"}], Cell[TextData[{
     "the rules in ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"],
     " used as options by the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FilterRules",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FilterRules"], "[", 
     RowBox[{
      StyleBox["opts", "TI"], ",", " ", 
      RowBox[{
       ButtonBox["Except",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Except"], "[", 
       RowBox[{
        ButtonBox["Options",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Options"], "[", 
        StyleBox["name", "TI"], "]"}], "]"}]}], "]"}], Cell[TextData[{
     "the rules in ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"],
     " not used as options by the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->47151264],

Cell["Filtering options.", "Caption",
 CellID->483707881],

Cell["\<\
Sometimes when you write a function you will want to pass on options to \
functions that it calls.\
\>", "Text",
 CellID->24519065],

Cell["\<\
Here is a simple function that solves a differential equation numerically and \
plots its solution:\
\>", "MathCaption",
 CellID->95394170],

Cell[BoxData[
 RowBox[{
  RowBox[{"odeplot", "[", 
   RowBox[{"de_", ",", " ", "y_", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x_", ",", " ", "x0_", ",", " ", "x1_"}], "}"}], ",", " ", 
    RowBox[{"opts", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], " ", ":=", " ", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "sol", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"sol", " ", "=", " ", 
      RowBox[{"NDSolve", "[", 
       RowBox[{"de", ",", " ", "y", ",", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", " ", 
        RowBox[{"FilterRules", "[", 
         RowBox[{
          RowBox[{"{", "opts", "}"}], ",", " ", 
          RowBox[{"Options", "[", "NDSolve", "]"}]}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Head", "[", "sol", "]"}], " ", "===", " ", "NDSolve"}], ",", 
       "\[IndentingNewLine]", "$Failed", ",", "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{"y", " ", "/.", " ", "sol"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", " ", 
         RowBox[{"Evaluate", "[", 
          RowBox[{"FilterRules", "[", 
           RowBox[{
            RowBox[{"{", "opts", "}"}], ",", " ", 
            RowBox[{"Options", "[", "Plot", "]"}]}], "]"}], "]"}]}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellLabel->"In[17]:=",
 CellID->147053138],

Cell[TextData[{
 "With no options given, the default options for ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " are used:"
}], "MathCaption",
 CellID->235388928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"odeplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", " ", 
       RowBox[{"y", "[", "x", "]"}]}], " ", "==", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
    "}"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->195599312],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->836825183]
}, Open  ]],

Cell[TextData[{
 "This changes the method used by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " and the color in the plot:"
}], "MathCaption",
 CellID->8579908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"odeplot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", " ", 
       RowBox[{"y", "[", "x", "]"}]}], " ", "==", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], " ", "\[Equal]", " ", "1"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}], 
    "}"}], ",", " ", 
   RowBox[{"y", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", "\"\<ExplicitRungeKutta\>\""}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->38001036],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->608654208]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->522659037],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Setting Up Functions with Optional Arguments - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OptionalAndDefaultArguments"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RepeatedPatterns"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 35.5443498}", "context" -> "", 
    "keywords" -> {"arguments", "functions", "optional arguments", "options"},
     "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "When you define a complicated function, you will often want to let some \
of the arguments of the function be 'optional'. If you do not give those \
arguments explicitly, you want them to take on certain 'default' values. \
Built-in Mathematica functions use two basic methods for dealing with \
optional arguments. You can choose between the same two methods when you \
define your own functions in Mathematica. The first method is to have the \
meaning of each argument determined by its position, and then to allow one to \
drop arguments, replacing them by default values. Almost all built-in \
Mathematica functions that use this method drop arguments from the end. For \
example, the built-in function Flatten[list,n] allows you to drop the second \
argument, which is taken to have a default value of Infinity. ", 
    "synonyms" -> {"2.3.10"}, "title" -> 
    "Setting Up Functions with Optional Arguments", "type" -> "Tutorial", 
    "uri" -> "tutorial/SettingUpFunctionsWithOptionalArguments"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.10"->{
  Cell[2212, 65, 109, 2, 70, "Title",
   CellTags->{"S2.3.10", "10.1"},
   CellID->14984]},
 "10.1"->{
  Cell[2212, 65, 109, 2, 70, "Title",
   CellTags->{"S2.3.10", "10.1"},
   CellID->14984]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.10", 26755, 797},
 {"10.1", 26858, 801}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1587, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2212, 65, 109, 2, 70, "Title",
 CellTags->{"S2.3.10", "10.1"},
 CellID->14984],
Cell[2324, 69, 355, 7, 70, "Text",
 CellID->16339],
Cell[2682, 78, 329, 11, 70, "Text",
 CellID->2556],
Cell[3014, 91, 832, 24, 70, "Text",
 CellID->25808],
Cell[3849, 117, 224, 7, 70, "Text",
 CellID->4632],
Cell[4076, 126, 810, 24, 70, "DefinitionBox",
 CellID->21478],
Cell[4889, 152, 82, 1, 70, "Caption",
 CellID->26814],
Cell[4974, 155, 315, 9, 70, "MathCaption",
 CellID->13787],
Cell[5292, 166, 230, 8, 70, "Input",
 CellID->7239],
Cell[5525, 176, 87, 1, 70, "MathCaption",
 CellID->28074],
Cell[5615, 179, 272, 9, 70, "Input",
 CellID->25020],
Cell[5890, 190, 400, 13, 70, "MathCaption",
 CellID->10827],
Cell[CellGroupData[{
Cell[6315, 207, 117, 4, 70, "Input",
 CellID->2554],
Cell[6435, 213, 216, 7, 36, "Output",
 CellID->1988]
}, Open  ]],
Cell[6666, 223, 623, 15, 70, "Text",
 CellID->7441],
Cell[7292, 240, 1139, 35, 70, "Text",
 CellID->16798],
Cell[8434, 277, 455, 14, 70, "Text",
 CellID->13642],
Cell[8892, 293, 1017, 32, 70, "DefinitionBox",
 CellID->19002],
Cell[9912, 327, 52, 1, 70, "Caption",
 CellID->16321],
Cell[9967, 330, 275, 9, 70, "MathCaption",
 CellID->30104],
Cell[CellGroupData[{
Cell[10267, 343, 229, 8, 70, "Input",
 CellID->13946],
Cell[10499, 353, 266, 9, 36, "Output",
 CellID->7056]
}, Open  ]],
Cell[10780, 365, 205, 5, 70, "MathCaption",
 CellID->14804],
Cell[10988, 372, 276, 9, 70, "Input",
 CellID->26385],
Cell[11267, 383, 168, 5, 70, "MathCaption",
 CellID->10142],
Cell[CellGroupData[{
Cell[11460, 392, 94, 3, 70, "Input",
 CellID->18842],
Cell[11557, 397, 208, 7, 36, "Output",
 CellID->301275276]
}, Open  ]],
Cell[11780, 407, 337, 11, 70, "MathCaption",
 CellID->22161],
Cell[CellGroupData[{
Cell[12142, 422, 145, 5, 70, "Input",
 CellID->31620],
Cell[12290, 429, 208, 7, 36, "Output",
 CellID->105003172]
}, Open  ]],
Cell[12513, 439, 1357, 44, 70, "DefinitionBox",
 CellID->47151264],
Cell[13873, 485, 57, 1, 70, "Caption",
 CellID->483707881],
Cell[13933, 488, 141, 4, 70, "Text",
 CellID->24519065],
Cell[14077, 494, 149, 4, 70, "MathCaption",
 CellID->95394170],
Cell[14229, 500, 1620, 42, 70, "Input",
 CellID->147053138],
Cell[15852, 544, 358, 13, 70, "MathCaption",
 CellID->235388928],
Cell[CellGroupData[{
Cell[16235, 561, 648, 20, 28, "Input",
 CellID->195599312],
Cell[16886, 583, 2832, 50, 127, "Output",
 Evaluatable->False,
 CellID->836825183]
}, Open  ]],
Cell[19733, 636, 237, 8, 70, "MathCaption",
 CellID->8579908],
Cell[CellGroupData[{
Cell[19995, 648, 777, 22, 47, "Input",
 CellID->38001036],
Cell[20775, 672, 2767, 49, 127, "Output",
 Evaluatable->False,
 CellID->608654208]
}, Open  ]],
Cell[CellGroupData[{
Cell[23579, 726, 72, 1, 70, "RelatedTutorialsSection",
 CellID->522659037],
Cell[23654, 729, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[23827, 736, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

