(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28653,        916]
NotebookOptionsPosition[     22192,        732]
NotebookOutlinePosition[     25952,        817]
CellTagsIndexPosition[     25859,        811]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"], 
          "Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>", 
       2->"\<\"Mathematica Packages\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Begin" :> Documentation`HelpLookup["paclet:ref/Begin"], 
          "BeginPackage" :> 
          Documentation`HelpLookup["paclet:ref/BeginPackage"], "End" :> 
          Documentation`HelpLookup["paclet:ref/End"], "EndPackage" :> 
          Documentation`HelpLookup["paclet:ref/EndPackage"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "Needs" :> 
          Documentation`HelpLookup["paclet:ref/Needs"], "$Packages" :> 
          Documentation`HelpLookup["paclet:ref/$Packages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Begin\"\>", 
       2->"\<\"BeginPackage\"\>", 3->"\<\"End\"\>", 4->"\<\"EndPackage\"\>", 
       5->"\<\"Get\"\>", 6->"\<\"Needs\"\>", 
       7->"\<\"$Packages\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Setting Up ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Packages"
}], "Title",
 CellTags->{"S2.7.10", "10.1"},
 CellID->5934],

Cell[TextData[{
 "In a typical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package, there are generally two kinds of new symbols that are introduced. \
The first kind are ones that you want to \[OpenCurlyDoubleQuote]export\
\[CloseCurlyDoubleQuote] for use outside the package. The second kind are \
ones that you want to use only internally within the package. You can \
distinguish these two kinds of symbols by putting them in different contexts. \
"
}], "Text",
 CellID->20415],

Cell[TextData[{
 "The usual convention is to put symbols intended for export in a context \
with a name ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["Package", "TI"], "`"}]]], "InlineFormula"],
 " that corresponds to the name of the package. Whenever the package is read \
in, it adds this context to the context search path, so that the symbols in \
this context can be referred to by their short names. "
}], "Text",
 CellID->656],

Cell[TextData[{
 "Symbols that are not intended for export, but are instead intended only for \
internal use within the package, are conventionally put into a context with \
the name ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["Package", "TI"], "`Private`"}]]], "InlineFormula"],
 ". This context is ",
 StyleBox["not",
  FontSlant->"Italic"],
 " added to the context search path. As a result, the symbols in this context \
cannot be accessed except by giving their full names. "
}], "Text",
 CellID->29761],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["Package", "TI"], 
     StyleBox["`", "MR"]}], Cell["symbols for export", "TableText"]},
   {
    RowBox[{
     StyleBox["Package", "TI"], 
     StyleBox["`Private`", "MR"]}], Cell[
    "symbols for internal use only", "TableText"]},
   {"System`", Cell[TextData[{
     "built\[Hyphen]in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " symbols"
    }], "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["Needed", "TI"], "1"], "`", Cell[", ", "TableText"], 
     SubscriptBox[
      StyleBox["Needed", "TI"], "2"], "`", Cell[
     ", \[Ellipsis]", "TableText"]}], Cell[
    "other contexts needed in the package", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25012],

Cell[TextData[{
 "Contexts conventionally used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages. "
}], "Caption",
 CellID->28411],

Cell[TextData[{
 "There is a standard sequence of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands that is typically used to set up the contexts in a package. These \
commands set the values of ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " so that the new symbols which are introduced are created in the \
appropriate contexts. "
}], "Text",
 CellID->11959],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BeginPackage",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BeginPackage"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"Package\", \"TI\"]`\)]\)\>\"", "]"}], Cell[TextData[{
     "set ",
     Cell[BoxData[
      RowBox[{
       StyleBox["Package", "TI"], 
       StyleBox["`", "MR"]}]], "InlineFormula"],
     " to be the current context, and put only ",
     Cell[BoxData["System`"], "InlineFormula"],
     " on the context search path"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "::", "usage", "=", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", Cell[", \[Ellipsis]", "TableText"]}], Cell[
    "introduce the objects intended for export (and no others)", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Begin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Begin"], "[", "\"\<`Private`\>\"", "]"}], Cell[
    TextData[{
     "set the current context to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["Package", "TI"], 
       StyleBox["`Private`", "MR"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", "=", 
     StyleBox["value", "TI"], Cell[", \[Ellipsis]", "TableText"]}], Cell[
    "give the main body of definitions in the package", "TableText"]},
   {
    RowBox[{
     ButtonBox["End",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/End"], "[", "]"}], Cell[TextData[{
     "revert to the previous context (here ",
     Cell[BoxData[
      RowBox[{
       StyleBox["Package", "TI"], 
       StyleBox["`", "MR"]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EndPackage",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EndPackage"], "[", "]"}], Cell[TextData[{
     "end the package, prepending the ",
     Cell[BoxData[
      RowBox[{
       StyleBox["Package", "TI"], 
       StyleBox["`", "MR"]}]], "InlineFormula"],
     " to the context search path"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16251],

Cell["\<\
The standard sequence of context control commands in a package. \
\>", "Caption",
 CellID->18738],

Cell["\<\
BeginPackage[\"Collatz`\"]

Collatz::usage =
        \"Collatz[n] gives a list of the iterates in the 3n+1 problem,
        starting from n. The conjecture is that this sequence always
        terminates.\"

Begin[\"`Private`\"]

Collatz[1] := {1}

Collatz[n_Integer]  := Prepend[Collatz[3 n + 1], n] /; OddQ[n] && n > 0

Collatz[n_Integer] := Prepend[Collatz[n/2], n] /; EvenQ[n] && n > 0

End[ ]

EndPackage[ ]\
\>", "Program",
 CellID->26124],

Cell[TextData[{
 "The sample package ",
 StyleBox["Collatz.m", "MR"],
 ". "
}], "Caption",
 CellID->8007],

Cell[TextData[{
 "Defining ",
 Cell[BoxData["usage"], "InlineFormula"],
 " messages at the beginning of a package is the standard way of making sure \
that symbols you want to export are created in the appropriate context. The \
way this works is that in defining these messages, the only symbols you \
mention are exactly the ones you want to export. These symbols are then \
created in the context ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["Package", "TI"], "`"}]]], "InlineFormula"],
 ", which is then current. "
}], "Text",
 CellID->17584],

Cell[TextData[{
 "In the actual definitions of the functions in a package, there are \
typically many new symbols, introduced as parameters, temporary variables, \
and so on. The convention is to put all these symbols in the context ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["Package", "TI"], "`Private`"}]]], "InlineFormula"],
 ", which is not put on the context search path when the package is read in. \
"
}], "Text",
 CellID->10951],

Cell["This reads in the sample package given above. ", "MathCaption",
 CellID->23101],

Cell[BoxData[
 RowBox[{"<<", "ExampleData/Collatz.m"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->14489],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 " command in the package adds the context associated with the package to the \
context search path. "
}], "MathCaption",
 CellID->24958],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[2]:= ",
 CellID->15441],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Collatz`\"\>", ",", "\<\"Global`\"\>", 
   ",", "\<\"System`\"\>"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->1790]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["Collatz"], "InlineFormula"],
 " function was created in the context ",
 Cell[BoxData["Collatz`"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "Collatz", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->30412],

Cell[BoxData["\<\"Collatz`\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->14855]
}, Open  ]],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData["n"], "InlineFormula"],
 " is put in the private context ",
 Cell[BoxData["Collatz`Private`"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Collatz`Private`*"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->7093],

Cell[BoxData["\<\"Collatz`Private`n\"\>"], "Print",
 CellID->8472]
}, Open  ]],

Cell[TextData[{
 "In the ",
 Cell[BoxData["Collatz"], "InlineFormula"],
 " package, the functions that are defined depend only on built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions. Often, however, the functions defined in one package may depend \
on functions defined in another package. "
}], "Text",
 CellID->25402],

Cell["\<\
Two things are needed to make this work. First, the other package must be \
read in, so that the functions needed are defined. And second, the context \
search path must include the context that these functions are in. \
\>", "Text",
 CellID->32676],

Cell[TextData[{
 "You can explicitly tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to read in a package at any point using the command ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox[
    RowBox[{
     StyleBox["context", "TI"], "`"}]]}]], "InlineFormula"],
 ". (\"",
 ButtonBox["Files for Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FilesForPackages"],
 "\" discusses the tricky issue of translation from \
system\[Hyphen]independent context names to system\[Hyphen]dependent file \
names.) Often, however, you want to set it up so that a particular package is \
read in only if it is needed. The command ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Needs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Needs"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
 " tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to read in a package if the context associated with that package is not \
already in the list ",
 Cell[BoxData[
  ButtonBox["$Packages",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Packages"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13543],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Get",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Get"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], "<<", 
     StyleBox["context", "TI"], 
     StyleBox["`", "MR"]}], Cell[
    "read in the package corresponding to the specified context", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Needs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Needs"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}], Cell[TextData[{
     "read in the package if the specified context is not already in ",
     Cell[BoxData[
      ButtonBox["$Packages",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Packages"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BeginPackage",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BeginPackage"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"Package\", \"TI\"]`\)]\)\>\"", ",", "{", "\"\<\>", 
     SubscriptBox[
      StyleBox["Needed", "TI"], "1"], "`", "\"\<, \!\(\*
StyleBox[\"\[Ellipsis]\", \"TR\"]\) }] \>"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "begin a package, specifying that certain contexts in addition to ",
     Cell[BoxData["System`"], "InlineFormula"],
     " are needed"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7373],

Cell["Functions for specifying interdependence of packages. ", "Caption",
 CellID->6266],

Cell[TextData[{
 "If you use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BeginPackage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BeginPackage"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"Package\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
 " with a single argument, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " puts on the context search path only the ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["Package", "TI"], "`"}]]], "InlineFormula"],
 " context and the contexts for built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols. If the definitions you give in your package involve functions \
from other packages, you must make sure that the contexts for these packages \
are also included in your context search path. You can do this by giving a \
list of the additional contexts as a second argument to ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " automatically calls ",
 Cell[BoxData[
  ButtonBox["Needs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Needs"]], "InlineFormula"],
 " on these contexts, reading in the corresponding packages if necessary, and \
then making sure that the contexts are on the context search path. "
}], "Text",
 CellID->27651],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Begin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Begin"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}], Cell[
    "switch to a new current context", "TableText"]},
   {
    RowBox[{
     ButtonBox["End",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/End"], "[", "]"}], Cell[
    "revert to the previous context", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15275],

Cell["Context manipulation functions. ", "Caption",
 CellID->21528],

Cell[TextData[{
 "Executing a function like ",
 Cell[BoxData[
  ButtonBox["Begin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Begin"]], "InlineFormula"],
 " which manipulates contexts changes the way that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interprets names you type in. However, you should realize that the change \
is effective only in subsequent expressions that you type in. The point is \
that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always reads in a complete input expression, and interprets the names in \
it, before it executes any part of the expression. As a result, by the time \
",
 Cell[BoxData[
  ButtonBox["Begin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Begin"]], "InlineFormula"],
 " is executed in a particular expression, the names in the expression have \
already been interpreted, and it is too late for ",
 Cell[BoxData[
  ButtonBox["Begin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Begin"]], "InlineFormula"],
 " to have an effect. "
}], "Text",
 CellID->532],

Cell[TextData[{
 "The fact that context manipulation functions do not have an effect until \
the ",
 StyleBox["next",
  FontSlant->"Italic"],
 " complete expression is read in means that you must be sure to give those \
functions as separate expressions, typically on separate lines, when you \
write ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages. "
}], "Text",
 CellID->10761],

Cell[TextData[{
 "The name ",
 Cell[BoxData["x"], "InlineFormula"],
 " is interpreted before this expression is executed, so the ",
 Cell[BoxData[
  ButtonBox["Begin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Begin"]], "InlineFormula"],
 " has no effect. "
}], "MathCaption",
 CellID->5469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<a`\>\"", "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"Context", "[", "x", "]"}], "]"}], ";", 
  RowBox[{"End", "[", "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->32503],

Cell[BoxData["\<\"Global`\"\>"], "Print",
 CellID->32729],

Cell[BoxData["\<\"a`\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->17107]
}, Open  ]],

Cell[TextData[{
 "Context manipulation functions are used primarily as part of packages \
intended to be read into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Sometimes, however, you may find it convenient to use such functions \
interactively. "
}], "Text",
 CellID->27892],

Cell[TextData[{
 "This can happen, for example, if you go into a dialog, say using ",
 Cell[BoxData[
  ButtonBox["TraceDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceDialog"]], "InlineFormula"],
 ", while executing a function defined in a package. The parameters and \
temporary variables in the function are typically in a private context \
associated with the package. Since this context is not on your context search \
path, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will print out the full names of the symbols, and will require you to type \
in these full names in order to refer to the symbols. You can however use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Begin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Begin"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"Package\", \"TI\"]`Private`\)]\)\>\"", "]"}]], "InlineFormula"],
 " to make the private context of the package your current context. This will \
make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " print out short names for the symbols, and allow you to refer to the \
symbols by their short names."
}], "Text",
 CellID->2451],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->7276399],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "RelatedTutorials",
 CellID->369732296]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Setting Up Mathematica Packages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ContextsAndPackages"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/AutomaticLoadingOfPackages"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 36.4193722}", "context" -> "", 
    "keywords" -> {
     "`", "::", "<<", "Begin", "BeginPackage", "Collatz", 
      "example of package", "contexts", "dialogs", "End", "EndPackage", 
      "exporting symbols from packages", "external symbols", "file names", 
      "Get", "hidden contexts", "InstallWizard", "loading packages", "Names", 
      "Needs", "packages", "printing", "Private contexts", "reading packages",
       "symbols", "usage messages"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In a typical Mathematica package, there are generally two kinds of new \
symbols that are introduced. The first kind are ones that you want to \
'export' for use outside the package. The second kind are ones that you want \
to use only internally within the package. You can distinguish these two \
kinds of symbols by putting them in different contexts. The usual convention \
is to put symbols intended for export in a context with a name Package` that \
corresponds to the name of the package. Whenever the package is read in, it \
adds this context to the context search path, so that the symbols in this \
context can be referred to by their short names. Symbols that are not \
intended for export, but are instead intended only for internal use within \
the package, are conventionally put into a context with the name \
Package`Private`. This context is not added to the context search path. As a \
result, the symbols in this context cannot be accessed except by giving their \
full names. ", "synonyms" -> {"2.7.10"}, "title" -> 
    "Setting Up Mathematica Packages", "type" -> "Tutorial", "uri" -> 
    "tutorial/SettingUpMathematicaPackages"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.10"->{
  Cell[2585, 70, 153, 7, 70, "Title",
   CellTags->{"S2.7.10", "10.1"},
   CellID->5934]},
 "10.1"->{
  Cell[2585, 70, 153, 7, 70, "Title",
   CellTags->{"S2.7.10", "10.1"},
   CellID->5934]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.10", 25643, 800},
 {"10.1", 25745, 804}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1960, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2585, 70, 153, 7, 70, "Title",
 CellTags->{"S2.7.10", "10.1"},
 CellID->5934],
Cell[2741, 79, 492, 11, 70, "Text",
 CellID->20415],
Cell[3236, 92, 442, 11, 70, "Text",
 CellID->656],
Cell[3681, 105, 518, 14, 70, "Text",
 CellID->29761],
Cell[4202, 121, 1059, 32, 70, "DefinitionBox",
 CellID->25012],
Cell[5264, 155, 147, 6, 70, "Caption",
 CellID->28411],
Cell[5414, 163, 588, 18, 70, "Text",
 CellID->11959],
Cell[6005, 183, 2391, 74, 70, "DefinitionBox",
 CellID->16251],
Cell[8399, 259, 107, 3, 70, "Caption",
 CellID->18738],
Cell[8509, 264, 455, 20, 70, "Program",
 CellID->26124],
Cell[8967, 286, 105, 5, 70, "Caption",
 CellID->8007],
Cell[9075, 293, 556, 14, 70, "Text",
 CellID->17584],
Cell[9634, 309, 449, 11, 70, "Text",
 CellID->10951],
Cell[10086, 322, 85, 1, 70, "MathCaption",
 CellID->23101],
Cell[10174, 325, 105, 3, 70, "Input",
 CellID->14489],
Cell[10282, 330, 285, 9, 70, "MathCaption",
 CellID->24958],
Cell[CellGroupData[{
Cell[10592, 343, 78, 2, 70, "Input",
 CellID->15441],
Cell[10673, 347, 257, 8, 36, "Output",
 CellID->1790]
}, Open  ]],
Cell[10945, 358, 196, 7, 70, "MathCaption",
 CellID->17013],
Cell[CellGroupData[{
Cell[11166, 369, 106, 3, 70, "Input",
 CellID->30412],
Cell[11275, 374, 170, 5, 36, "Output",
 CellID->14855]
}, Open  ]],
Cell[11460, 382, 202, 7, 70, "MathCaption",
 CellID->21060],
Cell[CellGroupData[{
Cell[11687, 393, 99, 3, 70, "Input",
 CellID->7093],
Cell[11789, 398, 66, 1, 70, "Print",
 CellID->8472]
}, Open  ]],
Cell[11870, 402, 349, 9, 70, "Text",
 CellID->25402],
Cell[12222, 413, 259, 5, 70, "Text",
 CellID->32676],
Cell[12484, 420, 1163, 36, 70, "Text",
 CellID->13543],
Cell[13650, 458, 1865, 52, 70, "DefinitionBox",
 CellID->7373],
Cell[15518, 512, 88, 1, 70, "Caption",
 CellID->6266],
Cell[15609, 515, 1444, 41, 70, "Text",
 CellID->27651],
Cell[17056, 558, 754, 23, 70, "DefinitionBox",
 CellID->15275],
Cell[17813, 583, 67, 1, 70, "Caption",
 CellID->21528],
Cell[17883, 586, 1040, 29, 70, "Text",
 CellID->532],
Cell[18926, 617, 395, 12, 70, "Text",
 CellID->10761],
Cell[19324, 631, 298, 10, 70, "MathCaption",
 CellID->5469],
Cell[CellGroupData[{
Cell[19647, 645, 232, 7, 70, "Input",
 CellID->32503],
Cell[19882, 654, 57, 1, 70, "Print",
 CellID->32729],
Cell[19942, 657, 164, 5, 36, "Output",
 CellID->17107]
}, Open  ]],
Cell[20121, 665, 286, 8, 70, "Text",
 CellID->27892],
Cell[20410, 675, 1136, 28, 70, "Text",
 CellID->2451],
Cell[CellGroupData[{
Cell[21571, 707, 70, 1, 70, "RelatedTutorialsSection",
 CellID->7276399],
Cell[21644, 710, 200, 5, 70, "RelatedTutorials",
 CellID->405226890],
Cell[21847, 717, 291, 9, 70, "RelatedTutorials",
 CellID->369732296]
}, Open  ]]
}, Open  ]],
Cell[22165, 730, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

