(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32479,       1051]
NotebookOptionsPosition[     26422,        862]
NotebookOutlinePosition[     29485,        939]
CellTagsIndexPosition[     29394,        933]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Shallow" :> Documentation`HelpLookup["paclet:ref/Shallow"], 
          "Short" :> Documentation`HelpLookup["paclet:ref/Short"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Shallow\"\>", 
       2->"\<\"Short\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Short and Shallow Output", "Title",
 CellTags->{"S2.9.5", "5.1"},
 CellID->17953],

Cell[TextData[{
 "When you generate a very large output expression in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you often do not want to see the whole expression at once. Rather, you \
would first like to get an idea of the general structure of the expression, \
and then, perhaps, go in and look at particular parts in more detail. "
}], "Text",
 CellID->28392],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " allow you to see \[OpenCurlyDoubleQuote]outlines\[CloseCurlyDoubleQuote] \
of large ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Text",
 CellID->22570],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Short",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Short"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "show a one\[Hyphen]line outline of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Short",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Short"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "show an ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]line outline of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Shallow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Shallow"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "show the \[OpenCurlyDoubleQuote]top parts\[CloseCurlyDoubleQuote] of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Shallow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Shallow"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["depth", "TI"], ",", 
     StyleBox["length", "TI"], "}", "]"}], Cell[TextData[{
     "show the parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to the specified depth and length"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->13519],

Cell["Showing outlines of expressions. ", "Caption",
 CellID->19472],

Cell["\<\
This generates a long expression. If the whole expression were printed out \
here, it would go on for 23 lines. \
\>", "MathCaption",
 CellID->23407],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", "y"}], ")"}], "^", "12"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[71]:=",
 CellID->22494],

Cell[TextData[{
 "This gives a one\[Hyphen]line \[OpenCurlyDoubleQuote]outline\
\[CloseCurlyDoubleQuote] of ",
 Cell[BoxData["t"], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  RowBox[{"<<", ">>"}]], "InlineFormula"],
 " indicates the number of terms omitted. "
}], "MathCaption",
 CellID->9505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", "t", "]"}]], "Input",
 CellLabel->"In[72]:=",
 CellID->28440],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", 
   RowBox[{"12", " ", "x"}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"495", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"\[LeftSkeleton]", "81", "\[RightSkeleton]"}], "+", 
   RowBox[{"132", " ", "x", " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["y", "11"]}], "+", 
   RowBox[{"12", " ", "x", " ", 
    SuperscriptBox["y", "11"]}], "+", 
   SuperscriptBox["y", "12"]}],
  Short]], "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[72]//Short=",
 CellID->322455860]
}, Open  ]],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " generates output in a textual format such as ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ", it first effectively writes the output in one long row. Then it looks at \
the width of text you have asked for, and it chops the row of output into a \
sequence of separate \[OpenCurlyDoubleQuote]lines\[CloseCurlyDoubleQuote]. \
Each of the \[OpenCurlyDoubleQuote]lines\[CloseCurlyDoubleQuote] may of \
course contain superscripts and built\[Hyphen]up fractions, and so may take \
up more than one actual line on your output device. When you specify a \
particular number of lines in ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes this to be the number of \[OpenCurlyDoubleQuote]logical lines\
\[CloseCurlyDoubleQuote] that you want, not the number of actual physical \
lines on your particular output device."
}], "Text",
 CellID->14262],

Cell[TextData[{
 "Here is a four\[Hyphen]line version of ",
 Cell[BoxData["t"], "InlineFormula"],
 ". More terms are shown in this case. "
}], "MathCaption",
 CellID->21409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"t", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[73]:=",
 CellID->28607],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", 
   RowBox[{"12", " ", "x"}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"495", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"792", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"924", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"792", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"495", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "10"]}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["x", "11"]}], "+", 
   SuperscriptBox["x", "12"], "+", 
   RowBox[{"12", " ", "y"}], "+", 
   RowBox[{"132", " ", "x", " ", "y"}], "+", 
   RowBox[{"\[LeftSkeleton]", "61", "\[RightSkeleton]"}], "+", 
   RowBox[{"495", " ", 
    SuperscriptBox["y", "8"]}], "+", 
   RowBox[{"1980", " ", "x", " ", 
    SuperscriptBox["y", "8"]}], "+", 
   RowBox[{"2970", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "8"]}], "+", 
   RowBox[{"1980", " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox["y", "8"]}], "+", 
   RowBox[{"495", " ", 
    SuperscriptBox["x", "4"], " ", 
    SuperscriptBox["y", "8"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["y", "9"]}], "+", 
   RowBox[{"660", " ", "x", " ", 
    SuperscriptBox["y", "9"]}], "+", 
   RowBox[{"660", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "9"]}], "+", 
   RowBox[{"220", " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox["y", "9"]}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"132", " ", "x", " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"66", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "10"]}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["y", "11"]}], "+", 
   RowBox[{"12", " ", "x", " ", 
    SuperscriptBox["y", "11"]}], "+", 
   SuperscriptBox["y", "12"]}],
  Short[#, 4]& ]], "Output",
 ImageSize->{545, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[73]//Short=",
 CellID->466222438]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " works in other formats too, such as ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". When using these formats, line-wrapping is determined by the notebook \
interface when displaying the output rather than by the kernel when creating \
the output. As a result, setting the number of lines generated by ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " can only approximate the actual number of lines displayed on-screen."
}], "Text",
 CellID->49364784],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " with other output forms, such as ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"InputForm", "[", "t", "]"}], "]"}]], "Input",
 CellLabel->"In[74]:=",
 CellID->5471],

Cell[BoxData[
 TagBox[
  FrameBox["\<\"1 + 12*x + 66*x^2 + 220*x^3 + 495*x^4 + <<83>> + 12*y^11 + \
12*x*y^11 + y^12\"\>",
   BoxFrame->False,
   FrameMargins->False],
  Short]], "Output",
 ImageSize->{529, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[74]//Short=",
 CellID->865361063]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " works by removing a sequence of parts from an expression until the output \
form of the result fits on the number of lines you specify. Sometimes, \
however, you may find it better to specify not how many final output lines \
you want, but which parts of the expression to drop. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shallow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shallow"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["depth", "TI"], ",", 
      StyleBox["length", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " includes only ",
 Cell[BoxData[
  StyleBox["length", "TI"]], "InlineFormula"],
 " arguments to any function, and drops all subexpressions that are below the \
specified depth. "
}], "Text",
 CellID->20654],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " shows a different outline of\[NonBreakingSpace]",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", "t", "]"}]], "Input",
 CellLabel->"In[75]:=",
 CellID->11514],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"12", " ", "x"}], "+", 
  RowBox[{"66", " ", 
   RowBox[{"Power", "[", 
    RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "]"}]}], "+", 
  RowBox[{"220", " ", 
   RowBox[{"Power", "[", 
    RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "]"}]}], "+", 
  RowBox[{"495", " ", 
   RowBox[{"Power", "[", 
    RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "]"}]}], "+", 
  RowBox[{"792", " ", 
   RowBox[{"Power", "[", 
    RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "]"}]}], "+", 
  RowBox[{"924", " ", 
   RowBox[{"Power", "[", 
    RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "]"}]}], "+", 
  RowBox[{"792", " ", 
   RowBox[{"Power", "[", 
    RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "]"}]}], "+", 
  RowBox[{"495", " ", 
   RowBox[{"Power", "[", 
    RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "]"}]}], "+", 
  RowBox[{"220", " ", 
   RowBox[{"Power", "[", 
    RowBox[{"\[LeftSkeleton]", "2", "\[RightSkeleton]"}], "]"}]}], "+", 
  RowBox[{"\[LeftSkeleton]", "81", "\[RightSkeleton]"}]}]], "Output",
 ImageSize->{536, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[75]//Shallow=",
 CellID->74545643]
}, Open  ]],

Cell["\<\
This includes only 10 arguments to each function, but allows any depth. \
\>", "MathCaption",
 CellID->21229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[76]:=",
 CellID->489],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"12", " ", "x"}], "+", 
  RowBox[{"66", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"220", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"495", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"792", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"924", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"792", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"495", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"220", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"\[LeftSkeleton]", "81", "\[RightSkeleton]"}]}]], "Output",
 ImageSize->{489, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[76]//Shallow=",
 CellID->15830212]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " is particularly useful when you want to drop parts in a uniform way \
throughout a highly nested expression, such as a large list structure \
returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->17887],

Cell["Here is the recursive definition of the Fibonacci function. ", \
"MathCaption",
 CellID->29756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"fib", "[", "0", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "1", "]"}], "=", "1"}]}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->26632],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->740459178]
}, Open  ]],

Cell["This generates a large list structure. ", "MathCaption",
 CellID->25739],

Cell[BoxData[
 RowBox[{
  RowBox[{"tr", "=", 
   RowBox[{"Trace", "[", 
    RowBox[{"fib", "[", "8", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->20666],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " to see an outline of the structure. "
}], "MathCaption",
 CellID->8522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", "tr", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->7283],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWU1z0zAQVW0nAUpK2mYgHJgJh7YMtL0DdzjxIzIdZtoD007p/w+W7E3V
55VXsi03pvVMYq8lvV3trj789Gt1d/n7z+ru6mK1/Hm7urm8uvi7/HF9m79K
d5RKPimlPi5U/rzOn8yPrs/5714spF39n25qqQzkI6H8iyC/CsQLrY/6Tj36
k+TiSXkfQflbkL8bL6FViHoCclqin8IdcVztfOsR7rmj/NgTZwHvv3n1+gXI
Ccij/BHfoYwYqON1BB0xMCVZwmvrp8fWH8On0wiYaPc4/9Oifq/xaEQUFc2V
P2TMTNFH9k9K68jKFMr9xumobJ3YKCN7ZVDlW7vWhEGlucmuh37hcNq0eyn0
xgeH60cs3Kb93O1IP+YU4lRykvK0khFx82jCth4L1hYZj7FDS0lHauuCcWWX
o9YplKNPx1D+pkH9Onu53JTs7RovpD+zwPqS/WzOBucKafPNAtS6j71gxsTX
dZMZOHRszwLbHwbWPxDs5TxdZy/md1u80P7PW/p7z9GOz8PUUbtt1E3+Zfdy
df3nZ8e2+3Z+XpdQDgXUUPldx3hoXxwvYOYPw9f4/df114IeTw8zGXvIjyy/
fUm8SCZUr9Z2v1E3B3kG8geQkdnAcgkPMzFUPzIpuEY4YprZfqa9Ja2yGeM9
yS5che3ocnH0i4bRUskJ7GNoTPxQMTLNbGkYn5oWfnZM2Vo2tjsqEttI6zzX
d5vvWjIe1SZhrqDsqkf4Z+Ud51ftS8pdXT4v7weWvbQPpv0N5byNU7CJ5DeO
j+1GQr8u1vWsp8SKSqOpb5YY86itfqxv4laJ3nuQXWyqL+vaN6uMXpPwzxzl
GesdPS8T56XvpRPNlTI51Qd/tt3sXmj5M7/u75uu+W1kUP4Hfj0GJruvr8wV
KPt9Z3fNqgyNMZVYz2ee39WPWLh9+YfTXyyvmJtcToSPLGROJT4Xtew1siI2
n4tWPfVTA84ffZ4ahPYf9Zn6W7q2bAeDzGVMl/hDO5dAbqnvc4nQ/qM+MyIb
Zfxmz1Izv8be0w6VBa4bQcPg94d5loKj9Wn6Gu3l5wCbfUnVQy5emQtnBZxb
H4vfl0ZY3+cmKLfVj371m8PxqwVXpobRq2nR7Oxim85V2Ei2toWPH/fFhOOu
uGhnS+cFdL5AO2CfcwW0Ifa5CRf1unMTwse51GTxxhWhpxhq5x9HiXzz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{552, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//Shallow= ",
 CellID->631751051]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " gives you a less uniform outline, which can be more difficult to \
understand. "
}], "MathCaption",
 CellID->17553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"tr", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->24705],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"fib", "[", "8", "]"}], ",", 
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"8", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"8", "-", "2"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"8", "-", "1"}], ",", "7"}], "}"}], ",", 
      RowBox[{"fib", "[", "7", "]"}], ",", 
      RowBox[{"\[LeftSkeleton]", "3", "\[RightSkeleton]"}], ",", 
      RowBox[{"13", "+", "8"}], ",", "21"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[LeftSkeleton]", "1", "\[RightSkeleton]"}], "}"}], ",", 
    RowBox[{"21", "+", "13"}], ",", "34"}], "}"}],
  Short[#, 3]& ]], "Output",
 ImageSize->{398, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//Short= ",
 CellID->27091]
}, Open  ]],

Cell[TextData[{
 "When generated outputs in the notebook interface are exceedingly large, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically applies ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " to the output. This user interface enhancement prevents ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from spending a lot of time generating and formatting the printed output \
for an evaluation which probably generated output you didn't expect."
}], "Text",
 CellID->27783810],

Cell["\<\
Typically, an assignment like this would have a semicolon at the end.\
\>", "MathCaption",
 CellID->232180627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lst", " ", "=", " ", 
  RowBox[{"Range", "[", 
   SuperscriptBox["10", "6"], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5601228],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   PanelBox[
    TagBox[GridBox[{
       {
        StyleBox[
         DynamicBox[ToBoxes[
           FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
           StandardForm],
          ImageSizeCache->{319., {2., 10.}}], "Panel",
         StripOnInput->False,
         FontSize->1 + Inherited,
         Background->None]},
       {
        ItemBox[
         TagBox[
          RowBox[{"{", 
           RowBox[{
           "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", 
            ",", "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", 
            ",", "14", ",", "15", ",", "16", ",", "17", ",", "18", ",", 
            RowBox[{"\[LeftSkeleton]", "999964", "\[RightSkeleton]"}], ",", 
            "999983", ",", "999984", ",", "999985", ",", "999986", ",", 
            "999987", ",", "999988", ",", "999989", ",", "999990", ",", 
            "999991", ",", "999992", ",", "999993", ",", "999994", ",", 
            "999995", ",", "999996", ",", "999997", ",", "999998", ",", 
            "999999", ",", "1000000"}], "}"}],
          Short[#, 5]& ],
         Background->GrayLevel[1],
         BaseStyle->{Deployed -> False},
         Frame->True,
         FrameStyle->GrayLevel[0.823529411764706],
         StripOnInput->False]},
       {
        RowBox[{
         ButtonBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
             StandardForm],
            ImageSizeCache->{58., {1., 10.}}], "Panel",
           StripOnInput->False,
           FontSize->1 + Inherited,
           Background->None],
          Appearance->Automatic,
          ButtonFrame->"DialogBox",
          
          ButtonFunction:>OutputSizeLimit`ButtonFunction[
           Identity, 6, 22064041263562755503, 5/2],
          Enabled->True,
          Evaluator->Automatic,
          Method->"Queued"], "\[ThinSpace]", 
         ButtonBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
             StandardForm],
            ImageSizeCache->{62., {1., 10.}}], "Panel",
           StripOnInput->False,
           FontSize->1 + Inherited,
           Background->None],
          Appearance->Automatic,
          ButtonFrame->"DialogBox",
          
          ButtonFunction:>OutputSizeLimit`ButtonFunction[
           Identity, 6, 22064041263562755503, 5 2],
          Enabled->True,
          Evaluator->Automatic,
          Method->"Queued"], "\[ThinSpace]", 
         ButtonBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
             StandardForm],
            ImageSizeCache->{96., {2., 10.}}], "Panel",
           StripOnInput->False,
           FontSize->1 + Inherited,
           Background->None],
          Appearance->Automatic,
          ButtonFrame->"DialogBox",
          
          ButtonFunction:>OutputSizeLimit`ButtonFunction[
           Identity, 6, 22064041263562755503, Infinity],
          Enabled->True,
          Evaluator->Automatic,
          Method->"Queued"], "\[ThinSpace]", 
         ButtonBox[
          StyleBox[
           DynamicBox[ToBoxes[
             FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
             StandardForm],
            ImageSizeCache->{85., {1., 9.}}], "Panel",
           StripOnInput->False,
           FontSize->1 + Inherited,
           Background->None],
          Appearance->Automatic,
          ButtonFrame->"DialogBox",
          ButtonFunction:>FrontEndExecute[{
             FrontEnd`SetOptions[
             FrontEnd`$FrontEnd, 
              FrontEnd`PreferencesSettings -> {"Page" -> "Evaluation"}], 
             FrontEnd`FrontEndToken["PreferencesDialog"]}],
          Evaluator->None,
          Method->"Preemptive"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxDividers->{
       "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{
       "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.56]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[1.2]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     "Column"],
    DefaultBaseStyle->{},
    ImageMargins->5],
   Deployed->True,
   StripOnInput->False],
  Out[6]]], "Output",
 ImageSize->{593, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->182518705]
}, Open  ]],

Cell[TextData[{
 "The buttons in the user interface allow you to control how much of the \
output you see. The size threshold at which this behavior takes effect is \
determined by the byte count of the output expression. That byte count can be \
set in the Preferences dialog of the notebook interface, which is opened by \
the ",
 StyleBox["Set Size Limit", "MenuName"],
 " button."
}], "Text",
 CellID->352179709],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->538498209],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Short and Shallow Output - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheInterpretationOfTextualForms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/StringOrientedOutputFormats"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 37.1693914}", "context" -> "", 
    "keywords" -> {
     "abbreviated output", "shorter output", "short output", "arguments", 
      "CompactDisplay", "compact display", 
      "dropping parts of expressions in printing", "line breaks", 
      "nested expressions", "outline", "output", "Shallow", "Short", 
      "skeleton output", "top of expression", "trace"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you generate a very large output expression in Mathematica, you \
often do not want to see the whole expression at once. Rather, you would \
first like to get an idea of the general structure of the expression, and \
then, perhaps, go in and look at particular parts in more detail. The \
functions Short and Shallow allow you to see 'outlines' of large Mathematica \
expressions. Showing outlines of expressions. ", "synonyms" -> {"2.9.5"}, 
    "title" -> "Short and Shallow Output", "type" -> "Tutorial", "uri" -> 
    "tutorial/ShortAndShallowOutput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.5"->{
  Cell[1900, 59, 87, 2, 70, "Title",
   CellTags->{"S2.9.5", "5.1"},
   CellID->17953]},
 "5.1"->{
  Cell[1900, 59, 87, 2, 70, "Title",
   CellTags->{"S2.9.5", "5.1"},
   CellID->17953]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.5", 29183, 922},
 {"5.1", 29282, 926}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1275, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1900, 59, 87, 2, 70, "Title",
 CellTags->{"S2.9.5", "5.1"},
 CellID->17953],
Cell[1990, 63, 376, 8, 70, "Text",
 CellID->28392],
Cell[2369, 73, 459, 17, 70, "Text",
 CellID->22570],
Cell[2831, 92, 1842, 57, 70, "DefinitionBox",
 CellID->13519],
Cell[4676, 151, 68, 1, 70, "Caption",
 CellID->19472],
Cell[4747, 154, 159, 4, 70, "MathCaption",
 CellID->23407],
Cell[4909, 160, 233, 9, 70, "Input",
 CellID->22494],
Cell[5145, 171, 295, 9, 70, "MathCaption",
 CellID->9505],
Cell[CellGroupData[{
Cell[5465, 184, 98, 3, 28, "Input",
 CellID->28440],
Cell[5566, 189, 824, 26, 50, "Output",
 CellID->322455860]
}, Open  ]],
Cell[6405, 218, 1126, 27, 70, "Text",
 CellID->14262],
Cell[7534, 247, 173, 5, 70, "MathCaption",
 CellID->21409],
Cell[CellGroupData[{
Cell[7732, 256, 121, 4, 70, "Input",
 CellID->28607],
Cell[7856, 262, 2206, 68, 85, "Output",
 CellID->466222438]
}, Open  ]],
Cell[10077, 333, 881, 24, 70, "Text",
 CellID->49364784],
Cell[10961, 359, 345, 13, 70, "MathCaption",
 CellID->4360],
Cell[CellGroupData[{
Cell[11331, 376, 133, 4, 70, "Input",
 CellID->5471],
Cell[11467, 382, 327, 11, 50, "Output",
 CellID->865361063]
}, Open  ]],
Cell[11809, 396, 924, 26, 70, "Text",
 CellID->20654],
Cell[12736, 424, 264, 9, 70, "MathCaption",
 CellID->29947],
Cell[CellGroupData[{
Cell[13025, 437, 100, 3, 70, "Input",
 CellID->11514],
Cell[13128, 442, 1252, 32, 68, "Output",
 CellID->74545643]
}, Open  ]],
Cell[14395, 477, 119, 3, 70, "MathCaption",
 CellID->21229],
Cell[CellGroupData[{
Cell[14539, 484, 178, 6, 70, "Input",
 CellID->489],
Cell[14720, 492, 756, 24, 50, "Output",
 CellID->15830212]
}, Open  ]],
Cell[15491, 519, 439, 14, 70, "Text",
 CellID->17887],
Cell[15933, 535, 101, 2, 70, "MathCaption",
 CellID->29756],
Cell[CellGroupData[{
Cell[16059, 541, 395, 14, 70, "Input",
 CellID->26632],
Cell[16457, 557, 159, 5, 36, "Output",
 CellID->740459178]
}, Open  ]],
Cell[16631, 565, 78, 1, 70, "MathCaption",
 CellID->25739],
Cell[16712, 568, 173, 6, 70, "Input",
 CellID->20666],
Cell[16888, 576, 224, 8, 70, "MathCaption",
 CellID->8522],
Cell[CellGroupData[{
Cell[17137, 588, 100, 3, 28, "Input",
 CellID->7283],
Cell[17240, 593, 1437, 27, 68, "Output",
 Evaluatable->False,
 CellID->631751051]
}, Open  ]],
Cell[18692, 623, 247, 8, 70, "MathCaption",
 CellID->17553],
Cell[CellGroupData[{
Cell[18964, 635, 123, 4, 70, "Input",
 CellID->24705],
Cell[19090, 641, 847, 26, 68, "Output",
 CellID->27091]
}, Open  ]],
Cell[19952, 670, 572, 15, 70, "Text",
 CellID->27783810],
Cell[20527, 687, 120, 3, 70, "MathCaption",
 CellID->232180627],
Cell[CellGroupData[{
Cell[20672, 694, 160, 5, 70, "Input",
 CellID->5601228],
Cell[20835, 701, 4824, 132, 70, "Output",
 CellID->182518705]
}, Open  ]],
Cell[25674, 836, 416, 9, 70, "Text",
 CellID->352179709],
Cell[CellGroupData[{
Cell[26115, 849, 72, 1, 70, "RelatedTutorialsSection",
 CellID->538498209],
Cell[26190, 852, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[26395, 860, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

