(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34699,       1241]
NotebookOptionsPosition[     27400,       1008]
NotebookOutlinePosition[     30520,       1084]
CellTagsIndexPosition[     30427,       1078]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series, Limits and Residues" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RSolve" :> Documentation`HelpLookup["paclet:ref/RSolve"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"RSolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Solving Recurrence Equations", "Title",
 CellTags->{"S3.6.8", "8.1"},
 CellID->21840],

Cell[TextData[{
 "If you represent the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " term in a sequence as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "[", "n", "]"}], TraditionalForm]], "InlineMath"],
 ", you can use a ",
 StyleBox["recurrence equation",
  FontSlant->"Italic"],
 " to specify how it is related to other terms in the sequence."
}], "Text",
 CellID->833],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " takes recurrence equations and solves them to get explicit formulas for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "[", "n", "]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->19285],

Cell["This solves a simple recurrence equation. ", "MathCaption",
 CellID->26900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "==", 
      RowBox[{"2", " ", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "1"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    SuperscriptBox["2", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176199013]
}, Open  ]],

Cell[TextData[{
 "This takes the solution and makes an explicit table of the first ten ",
 Cell[BoxData[
  RowBox[{"a", "[", "n", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "/.", 
    RowBox[{"First", "[", "%", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64", ",", 
   "128", ",", "256", ",", "512"}], "}"}]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2144345925]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RSolve"], "[", 
     StyleBox["eqn", "TI"], ",", 
     StyleBox["a", "TI"], "[", 
     StyleBox["n", "TI"], "]", ",", 
     StyleBox["n", "TI"], "]"}], Cell[
    "solve a recurrence equation", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18281],

Cell["Solving a recurrence equation. ", "Caption",
 CellID->18032],

Cell["This solves a recurrence equation for a geometric series. ", \
"MathCaption",
 CellID->16256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "==", 
      RowBox[{
       RowBox[{"r", " ", 
        RowBox[{"a", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], "+", "1"}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29910],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "n"]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", "r"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{120, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->951397521]
}, Open  ]],

Cell["This gives the same result. ", "MathCaption",
 CellID->8982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "==", 
      RowBox[{
       RowBox[{"r", " ", 
        RowBox[{"a", "[", "n", "]"}]}], "+", "1"}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23901],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["r", "n"]}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", "r"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{120, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2122383532]
}, Open  ]],

Cell["This gives an algebraic solution to a recurrence equation. ", \
"MathCaption",
 CellID->837099518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "==", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "1"}], "]"}]}], "+", 
      RowBox[{"a", "[", 
       RowBox[{"n", "-", "2"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->133212147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "-", 
         SqrtBox["5"]}], ")"}], "n"], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SqrtBox["5"]}], ")"}], "n"], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{277, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1196645654]
}, Open  ]],

Cell["This solves the Fibonacci recurrence equation. ", "MathCaption",
 CellID->10635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "==", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "1"}], "]"}], "+", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "2"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "==", 
      RowBox[{"a", "[", "2", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->17860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"Fibonacci", "[", "n", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->839152623]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " can be thought of as a discrete analog of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ". Many of the same functions generated in solving differential equations \
also appear in finding symbolic solutions to recurrence equations. "
}], "Text",
 CellID->29527],

Cell["\<\
This generates a gamma function, which generalizes the factorial. \
\>", "MathCaption",
 CellID->7137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "==", 
      RowBox[{"n", " ", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "1"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->8343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "n"}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1113024912]
}, Open  ]],

Cell["\<\
This second\[Hyphen]order recurrence equation comes out in terms of Bessel \
functions. \
\>", "MathCaption",
 CellID->28233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "==", 
      RowBox[{
       RowBox[{"n", " ", 
        RowBox[{"a", "[", "n", "]"}]}], "+", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "1"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->3995],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"BesselI", "[", 
        RowBox[{"n", ",", 
         RowBox[{"-", "2"}]}], "]"}], " ", 
       RowBox[{"BesselK", "[", 
        RowBox[{"1", ",", "2"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"BesselI", "[", 
        RowBox[{"1", ",", "2"}], "]"}], " ", 
       RowBox[{"BesselK", "[", 
        RowBox[{"n", ",", "2"}], "]"}]}]}], 
     RowBox[{
      RowBox[{
       RowBox[{"BesselI", "[", 
        RowBox[{"2", ",", "2"}], "]"}], " ", 
       RowBox[{"BesselK", "[", 
        RowBox[{"1", ",", "2"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"BesselI", "[", 
        RowBox[{"1", ",", "2"}], "]"}], " ", 
       RowBox[{"BesselK", "[", 
        RowBox[{"2", ",", "2"}], "]"}]}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{460, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->2027130614]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " does not require you to specify explicit values for terms such as ",
 Cell[BoxData[
  RowBox[{"a", "[", "1", "]"}]], "InlineFormula"],
 ". Like ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ", it automatically introduces undetermined constants ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " to give a general solution. "
}], "Text",
 CellID->7603],

Cell["\<\
This gives a general solution with one undetermined constant. \
\>", "MathCaption",
 CellID->28942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "==", 
    RowBox[{"n", " ", 
     RowBox[{"a", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->18011],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "n"}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{183, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->156169843]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " can solve equations that do not depend only linearly on ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "[", "n", "]"}], TraditionalForm]], "InlineMath"],
 ". For nonlinear equations, however, there are sometimes several distinct \
solutions that must be given. Just as for differential equations, it is a \
difficult matter to find symbolic solutions to recurrence equations, and \
standard mathematical functions only cover a limited set of cases. "
}], "Text",
 CellID->31034],

Cell["\<\
Here is the general solution to a nonlinear recurrence equation. \
\>", "MathCaption",
 CellID->14512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "==", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"n", "+", "1"}], "]"}], " ", 
      RowBox[{"a", "[", 
       RowBox[{"n", "-", "1"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->24593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"n", " ", "\[Pi]"}], "3"], "]"}]}], "+", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"Sin", "[", 
        FractionBox[
         RowBox[{"n", " ", "\[Pi]"}], "3"], "]"}]}]}]]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{215, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->521534667]
}, Open  ]],

Cell["This gives two distinct solutions. ", "MathCaption",
 CellID->14161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "==", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "+", "1"}], "]"}], " ", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "1"}], "]"}]}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->23234],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n", " ", 
          RowBox[{"ArcTan", "[", 
           SqrtBox["15"], "]"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n", " ", 
          RowBox[{"ArcTan", "[", 
           SqrtBox["15"], "]"}]}], "]"}]}]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "3"], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n", " ", 
          RowBox[{"ArcTan", "[", 
           SqrtBox["15"], "]"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n", " ", 
          RowBox[{"ArcTan", "[", 
           SqrtBox["15"], "]"}]}], "]"}]}]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{356, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1552384862]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " can solve not only ordinary ",
 StyleBox["difference equations",
  FontSlant->"Italic"],
 " in which the arguments of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " differ by integers, but also ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 StyleBox["\[Hyphen]difference equations",
  FontSlant->"Italic"],
 " in which the arguments of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " are related by multiplicative factors."
}], "Text",
 CellID->21926],

Cell[TextData[{
 "This solves the ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 "\[Hyphen]difference analog of the factorial equation. "
}], "MathCaption",
 CellID->5906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"q", " ", "n"}], "]"}], "==", 
    RowBox[{"n", " ", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->5191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["n", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         FractionBox[
          RowBox[{"Log", "[", "n", "]"}], 
          RowBox[{"Log", "[", "q", "]"}]]}], ")"}]}]], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{183, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1153548231]
}, Open  ]],

Cell[TextData[{
 "Here is a second\[Hyphen]order ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 "\[Hyphen]difference equation. "
}], "MathCaption",
 CellID->6188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "==", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"q", " ", "n"}], "]"}], "+", 
     RowBox[{"a", "[", 
      RowBox[{"n", "/", "q"}], "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->30227],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"Log", "[", "n", "]"}]}], 
        RowBox[{"3", " ", 
         RowBox[{"Log", "[", "q", "]"}]}]], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"Log", "[", "n", "]"}]}], 
        RowBox[{"3", " ", 
         RowBox[{"Log", "[", "q", "]"}]}]], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{335, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->202753301]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RSolve"], "[", "{", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["eqn", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "1"], Cell["[", "TableText"], 
     StyleBox["n", "TI"], "]", ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "2"], "[", 
     StyleBox["n", "TI"], "]", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["n", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["solve a coupled system of recurrence equations", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26484],

Cell["Solving systems of recurrence equations. ", "Caption",
 CellID->5224],

Cell["This solves a system of two coupled recurrence equations. ", \
"MathCaption",
 CellID->19093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "==", 
      RowBox[{
       RowBox[{"b", "[", 
        RowBox[{"n", "-", "1"}], "]"}], "+", "n"}]}], ",", 
     RowBox[{
      RowBox[{"b", "[", "n", "]"}], "==", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "1"}], "]"}], "-", "n"}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "==", 
      RowBox[{"b", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], ",", 
     RowBox[{"b", "[", "n", "]"}]}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->30435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"2", " ", "n"}]], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"2", " ", "n"}]], " ", "n"}]}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"b", "[", "n", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"4", "-", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "n"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"2", " ", "n"}]], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"2", " ", "n"}]], " ", "n"}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{571, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1765665765]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RSolve"], "[", 
     RowBox[{
      StyleBox["eqns", "TI"], ",", 
      RowBox[{
       StyleBox["a", "TI"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], "2"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], "1"], Cell[", ", "TableText"], 
        SubscriptBox[
         StyleBox["n", "TI"], "2"], Cell[", \[Ellipsis] }]", "TableText"], 
        StyleBox[" ", "TR"]}]}]}]}], "\[SpanFromLeft]"},
   {"", Cell["solve partial recurrence equations", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28094],

Cell["Solving partial recurrence equations. ", "Caption",
 CellID->3582],

Cell["\<\
Just as one can set up partial differential equations that involve functions \
of several variables, so one can also set up partial recurrence equations \
that involve multidimensional sequences. Just as in the differential \
equations case, general solutions to partial recurrence equations can involve \
undetermined functions.\
\>", "Text",
 CellID->8867],

Cell["\<\
This gives the general solution to a simple partial recurrence equation. \
\>", "MathCaption",
 CellID->8627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"i", "+", "1"}], ",", 
      RowBox[{"j", "+", "1"}]}], "]"}], "==", 
    RowBox[{"i", " ", "j", " ", 
     RowBox[{"a", "[", 
      RowBox[{"i", ",", "j"}], "]"}]}]}], ",", 
   RowBox[{"a", "[", 
    RowBox[{"i", ",", "j"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "j"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->22005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"i", ",", "j"}], "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"Gamma", "[", "i", "]"}], " ", 
      RowBox[{"Gamma", "[", "j", "]"}], " ", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "[", 
       RowBox[{"i", "-", "j"}], "]"}]}], 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "-", "i", "+", "j"}], "]"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{285, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1615478109]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->35479691],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solving Recurrence Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SummationOfSeries"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FindingLimits"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 46.2789996}", "context" -> "", 
    "keywords" -> {
     "arithmetic difference equations", "difference-algebraic equations", 
      "differential-algebraic equations", "difference equations", 
      "discrete equations", "divide-and-conquer equations", 
      "divide and conquer", "equations", "Fibonacci equations", 
      "finite difference equations", "geometric difference equations", 
      "integer sequence equations", "partial difference equations", 
      "partial recurrence equations", "recurrence equations", 
      "recursion equations", "RSolve", "sequence equations"}, "index" -> True,
     "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "If you represent the n^th term in a sequence as a[n], you can use a \
recurrence equation to specify how it is related to other terms in the \
sequence. RSolve takes recurrence equations and solves them to get explicit \
formulas for a[n]. This solves a simple recurrence equation. ", 
    "synonyms" -> {"3.6.8"}, "title" -> "Solving Recurrence Equations", 
    "type" -> "Tutorial", "uri" -> "tutorial/SolvingRecurrenceEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.8"->{
  Cell[1826, 59, 91, 2, 70, "Title",
   CellTags->{"S3.6.8", "8.1"},
   CellID->21840]},
 "8.1"->{
  Cell[1826, 59, 91, 2, 70, "Title",
   CellTags->{"S3.6.8", "8.1"},
   CellID->21840]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.8", 30216, 1067},
 {"8.1", 30315, 1071}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1201, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1826, 59, 91, 2, 70, "Title",
 CellTags->{"S3.6.8", "8.1"},
 CellID->21840],
Cell[1920, 63, 477, 16, 70, "Text",
 CellID->833],
Cell[2400, 81, 335, 11, 70, "Text",
 CellID->19285],
Cell[2738, 94, 81, 1, 70, "MathCaption",
 CellID->26900],
Cell[CellGroupData[{
Cell[2844, 99, 416, 14, 28, "Input",
 CellID->10968],
Cell[3263, 115, 338, 12, 39, "Output",
 CellID->176199013]
}, Open  ]],
Cell[3616, 130, 196, 6, 70, "MathCaption",
 CellID->16633],
Cell[CellGroupData[{
Cell[3837, 140, 259, 9, 28, "Input",
 CellID->13885],
Cell[4099, 151, 301, 9, 36, "Output",
 CellID->2144345925]
}, Open  ]],
Cell[4415, 163, 646, 19, 70, "DefinitionBox",
 CellID->18281],
Cell[5064, 184, 66, 1, 70, "Caption",
 CellID->18032],
Cell[5133, 187, 99, 2, 70, "MathCaption",
 CellID->16256],
Cell[CellGroupData[{
Cell[5257, 193, 446, 15, 70, "Input",
 CellID->29910],
Cell[5706, 210, 411, 15, 52, "Output",
 CellID->951397521]
}, Open  ]],
Cell[6132, 228, 66, 1, 70, "MathCaption",
 CellID->8982],
Cell[CellGroupData[{
Cell[6223, 233, 444, 15, 70, "Input",
 CellID->23901],
Cell[6670, 250, 412, 15, 52, "Output",
 CellID->2122383532]
}, Open  ]],
Cell[7097, 268, 104, 2, 70, "MathCaption",
 CellID->837099518],
Cell[CellGroupData[{
Cell[7226, 274, 420, 14, 70, "Input",
 CellID->133212147],
Cell[7649, 290, 614, 22, 43, "Output",
 CellID->1196645654]
}, Open  ]],
Cell[8278, 315, 86, 1, 70, "MathCaption",
 CellID->10635],
Cell[CellGroupData[{
Cell[8389, 320, 521, 17, 70, "Input",
 CellID->17860],
Cell[8913, 339, 302, 10, 36, "Output",
 CellID->839152623]
}, Open  ]],
Cell[9230, 352, 467, 13, 70, "Text",
 CellID->29527],
Cell[9700, 367, 112, 3, 70, "MathCaption",
 CellID->7137],
Cell[CellGroupData[{
Cell[9837, 374, 415, 14, 70, "Input",
 CellID->8343],
Cell[10255, 390, 325, 11, 36, "Output",
 CellID->1113024912]
}, Open  ]],
Cell[10595, 404, 135, 4, 70, "MathCaption",
 CellID->28233],
Cell[CellGroupData[{
Cell[10755, 412, 574, 19, 70, "Input",
 CellID->3995],
Cell[11332, 433, 1017, 33, 53, "Output",
 CellID->2027130614]
}, Open  ]],
Cell[12364, 469, 669, 22, 70, "Text",
 CellID->7603],
Cell[13036, 493, 109, 3, 70, "MathCaption",
 CellID->28942],
Cell[CellGroupData[{
Cell[13170, 500, 298, 10, 70, "Input",
 CellID->18011],
Cell[13471, 512, 382, 13, 36, "Output",
 CellID->156169843]
}, Open  ]],
Cell[13868, 528, 610, 14, 70, "Text",
 CellID->31034],
Cell[14481, 544, 112, 3, 70, "MathCaption",
 CellID->14512],
Cell[CellGroupData[{
Cell[14618, 551, 388, 13, 70, "Input",
 CellID->24593],
Cell[15009, 566, 646, 22, 48, "Output",
 CellID->521534667]
}, Open  ]],
Cell[15670, 591, 74, 1, 70, "MathCaption",
 CellID->14161],
Cell[CellGroupData[{
Cell[15769, 596, 418, 14, 70, "Input",
 CellID->23234],
Cell[16190, 612, 1369, 43, 79, "Output",
 CellID->1552384862]
}, Open  ]],
Cell[17574, 658, 651, 21, 70, "Text",
 CellID->21926],
Cell[18228, 681, 192, 6, 70, "MathCaption",
 CellID->5906],
Cell[CellGroupData[{
Cell[18445, 691, 297, 10, 70, "Input",
 CellID->5191],
Cell[18745, 703, 588, 20, 52, "Output",
 CellID->1153548231]
}, Open  ]],
Cell[19348, 726, 183, 6, 70, "MathCaption",
 CellID->6188],
Cell[CellGroupData[{
Cell[19556, 736, 357, 12, 70, "Input",
 CellID->30227],
Cell[19916, 750, 801, 27, 53, "Output",
 CellID->202753301]
}, Open  ]],
Cell[20732, 780, 1141, 31, 70, "DefinitionBox",
 CellID->26484],
Cell[21876, 813, 75, 1, 70, "Caption",
 CellID->5224],
Cell[21954, 816, 99, 2, 70, "MathCaption",
 CellID->19093],
Cell[CellGroupData[{
Cell[22078, 822, 700, 23, 70, "Input",
 CellID->30435],
Cell[22781, 847, 1395, 47, 51, "Output",
 CellID->1765665765]
}, Open  ]],
Cell[24191, 897, 1215, 35, 70, "DefinitionBox",
 CellID->28094],
Cell[25409, 934, 72, 1, 70, "Caption",
 CellID->3582],
Cell[25484, 937, 368, 7, 70, "Text",
 CellID->8867],
Cell[25855, 946, 119, 3, 70, "MathCaption",
 CellID->8627],
Cell[CellGroupData[{
Cell[25999, 953, 463, 16, 70, "Input",
 CellID->22005],
Cell[26465, 971, 588, 19, 53, "Output",
 CellID->1615478109]
}, Open  ]],
Cell[CellGroupData[{
Cell[27090, 995, 71, 1, 70, "RelatedTutorialsSection",
 CellID->35479691],
Cell[27164, 998, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[27373, 1006, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

