(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27560,        963]
NotebookOptionsPosition[     20676,        753]
NotebookOutlinePosition[     24243,        836]
CellTagsIndexPosition[     24152,        830]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abs" :> Documentation`HelpLookup["paclet:ref/Abs"], "ArcCos" :> 
          Documentation`HelpLookup["paclet:ref/ArcCos"], "ArcSin" :> 
          Documentation`HelpLookup["paclet:ref/ArcSin"], "ArcTan" :> 
          Documentation`HelpLookup["paclet:ref/ArcTan"], "Cos" :> 
          Documentation`HelpLookup["paclet:ref/Cos"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "E" :> 
          Documentation`HelpLookup["paclet:ref/E"], "Exp" :> 
          Documentation`HelpLookup["paclet:ref/Exp"], "FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"], "Infinity" :> 
          Documentation`HelpLookup["paclet:ref/Infinity"], 
          "Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"], "Log" :> 
          Documentation`HelpLookup["paclet:ref/Log"], "Max" :> 
          Documentation`HelpLookup["paclet:ref/Max"], "Min" :> 
          Documentation`HelpLookup["paclet:ref/Min"], "Mod" :> 
          Documentation`HelpLookup["paclet:ref/Mod"], "Pi" :> 
          Documentation`HelpLookup["paclet:ref/Pi"], "RandomReal" :> 
          Documentation`HelpLookup["paclet:ref/RandomReal"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"], "Sin" :> 
          Documentation`HelpLookup["paclet:ref/Sin"], "Sqrt" :> 
          Documentation`HelpLookup["paclet:ref/Sqrt"], "Tan" :> 
          Documentation`HelpLookup["paclet:ref/Tan"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Abs\"\>", 2->"\<\"ArcCos\"\>", 
       3->"\<\"ArcSin\"\>", 4->"\<\"ArcTan\"\>", 5->"\<\"Cos\"\>", 
       6->"\<\"Degree\"\>", 7->"\<\"E\"\>", 8->"\<\"Exp\"\>", 
       9->"\<\"FactorInteger\"\>", 10->"\<\"I\"\>", 11->"\<\"Infinity\"\>", 
       12->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>", 
       13->"\<\"Log\"\>", 14->"\<\"Max\"\>", 15->"\<\"Min\"\>", 
       16->"\<\"Mod\"\>", 17->"\<\"Pi\"\>", 18->"\<\"RandomReal\"\>", 
       19->"\<\"Round\"\>", 20->"\<\"Sin\"\>", 21->"\<\"Sqrt\"\>", 
       22->"\<\"Tan\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Some Mathematical Functions", "Title",
 CellTags->{"S1.1.3", "3.1"},
 CellID->32686],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " includes a very large collection of mathematical functions. \"",
 ButtonBox["Mathematical Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicalFunctionsOverview"],
 "\" gives the complete list. Here are a few of the common ones. "
}], "Text",
 CellID->16589],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sqrt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sqrt"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "square root (",
     Cell[BoxData[
      FormBox[
       SqrtBox["x"], TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Exp",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exp"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "exponential (",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["e", "x"], TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "natural logarithm (",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["log", "e"], "x"}], TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     StyleBox["b", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "logarithm to base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"],
     " (",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["log", "b"], "x"}], TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     StyleBox["x", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Cos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cos"], "[", 
     StyleBox["x", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Tan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tan"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[
    "trigonometric functions (with arguments in radians)", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcSin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSin"], "[", 
     StyleBox["x", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcCos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCos"], "[", 
     StyleBox["x", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcTan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTan"], "[", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["inverse trigonometric functions", "TableText"]},
   {
    RowBox[{
     StyleBox["n", "TI"], "!"}], Cell[TextData[{
     "factorial (product of integers ",
     Cell[BoxData[
      FormBox[
       RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", "n"}], 
       TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     StyleBox["x", "TI"], "]"}], Cell["absolute value", "TableText"]},
   {
    RowBox[{
     ButtonBox["Round",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Round"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "closest integer to ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " modulo ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " (remainder on division of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " by ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomReal"], "[", "]"}], Cell[
    "pseudorandom number between 0 and 1", "TableText"]},
   {
    RowBox[{
     ButtonBox["Max",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Max"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", Cell[", ", "TableText"], 
     ButtonBox["Min",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Min"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "maximum, minimum of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", ",", "y", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FactorInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorInteger"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "prime factors of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " (see \"",
     ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/IntegerAndNumberTheoreticalFunctions"],
     "\")"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->20540],

Cell["Some common mathematical functions. ", "Caption",
 CellID->18237],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] The arguments of all ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " functions are enclosed in ",
     StyleBox["square brackets",
      FontSlant->"Italic"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] The names of built\[Hyphen]in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " functions begin with ",
     StyleBox["capital letters",
      FontSlant->"Italic"],
     "."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->22850],

Cell[TextData[{
 "Two important points about functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->18759],

Cell[TextData[{
 "It is important to remember that all function arguments in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are enclosed in ",
 StyleBox["square brackets",
  FontSlant->"Italic"],
 ", not parentheses. Parentheses in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are used only to indicate the grouping of terms, and never to give \
function arguments."
}], "Text",
 CellID->9578],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["log", "e"], 
    RowBox[{"(", "8.4", ")"}]}], TraditionalForm]], "InlineMath"],
 ". Notice the capital letter for ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ", and the ",
 StyleBox["square brackets",
  FontSlant->"Italic"],
 " for the argument. "
}], "MathCaption",
 CellID->28956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "8.4", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->32677],

Cell[BoxData["2.128231705849268`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->2403]
}, Open  ]],

Cell[TextData[{
 "Just as with arithmetic operations, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to give exact values for mathematical functions when you give it \
exact input. "
}], "Text",
 CellID->28042],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  FormBox[
   SqrtBox["16"], TraditionalForm]], "InlineMath"],
 " as an exact integer. "
}], "MathCaption",
 CellID->6300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "16", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->15811],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->5225]
}, Open  ]],

Cell[TextData[{
 "This gives an approximate numerical result for ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->21143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", "2", "]"}], "//", "N"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->21595],

Cell[BoxData["1.4142135623730951`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->21016]
}, Open  ]],

Cell[TextData[{
 "The presence of an explicit decimal point tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to give an approximate numerical result. "
}], "MathCaption",
 CellID->26615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "2.", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->28804],

Cell[BoxData["1.4142135623730951`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->21006]
}, Open  ]],

Cell[TextData[{
 "Since you are not asking for an approximate numerical result, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leaves the number here in an exact symbolic form. "
}], "MathCaption",
 CellID->28368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "2", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->31641],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->30335]
}, Open  ]],

Cell[TextData[{
 "Here is the exact integer result for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"30", "\[Cross]", "29", "\[Cross]", "...", "\[Cross]", "1"}], 
   TraditionalForm]], "InlineMath"],
 ". Computing factorials like this can give you very large numbers. You \
should be able to calculate up to at least ",
 Cell[BoxData[
  RowBox[{"2000", "!"}]], "InlineFormula"],
 " in a short time. "
}], "MathCaption",
 CellID->698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"30", "!"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->1325],

Cell[BoxData["265252859812191058636308480000000"], "Output",
 ImageSize->{257, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->28313]
}, Open  ]],

Cell["\<\
This gives the approximate numerical value of the factorial. \
\>", "MathCaption",
 CellID->28023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"30", "!"}], "//", "N"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->22312],

Cell[BoxData["2.6525285981219107`*^32"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->24618]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Pi",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Pi"], Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{"\[Pi]", "\[TildeEqual]", "3.14159"}], TraditionalForm]], 
     "InlineMath"]], "TableText"]},
   {
    ButtonBox["E",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/E"], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"e", "\[TildeEqual]", "2.71828"}], TraditionalForm]], 
      "InlineMath"],
     " (normally output as ",
     Cell[BoxData[
      FormBox["\[ExponentialE]", TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["Degree",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Degree"], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Pi]", "/", "180"}], TraditionalForm]], "InlineMath"],
     ": degrees-to-radians conversion factor (normally output as ",
     Cell[BoxData[
      FormBox["\[Degree]", TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["I",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/I"], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"i", "=", 
        SqrtBox[
         RowBox[{"-", "1"}]]}], TraditionalForm]], "InlineMath"],
     " (normally output as ",
     Cell[BoxData[
      FormBox["\[ImaginaryI]", TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[Cell[BoxData[
     FormBox["\[Infinity]", TraditionalForm]], "InlineMath"]], "TableText"]}
  }]], "DefinitionBox",
 CellID->18457],

Cell["Some common mathematical constants. ", "Caption",
 CellID->18396],

Cell["\<\
Notice that the names of these built\[Hyphen]in constants all begin with \
capital letters. \
\>", "Text",
 CellID->8339],

Cell[TextData[{
 "This gives the numerical value of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Pi]", "2"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->21086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pi", "^", "2"}], "//", "N"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->32094],

Cell[BoxData["9.869604401089358`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->7846]
}, Open  ]],

Cell[TextData[{
 "This gives the exact result for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"\[Pi]", "/", "2"}], ")"}], TraditionalForm]], "InlineMath"],
 ". Notice that the arguments to trigonometric functions are always in \
radians. "
}], "MathCaption",
 CellID->27043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Pi", "/", "2"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->31522],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->12911]
}, Open  ]],

Cell[TextData[{
 "This gives the numerical value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    SuperscriptBox["20", "\[EmptySmallCircle]"], ")"}], TraditionalForm]], 
  "InlineMath"],
 ". Multiplying by the constant ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " converts the argument to radians."
}], "MathCaption",
 CellID->16280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"20", " ", "Degree"}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->23455],

Cell[BoxData["0.3420201433256687`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->26358]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives logarithms to base ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->26847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"E", "^", "5"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->28870],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->990]
}, Open  ]],

Cell[TextData[{
 "You can get logarithms in any base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{
    StyleBox["b", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ". As in standard mathematical notation, the ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is optional."
}], "MathCaption",
 CellID->3873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"2", ",", "256"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->4327],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->3413]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->159832190],

Cell[TextData[ButtonBox["Numerical Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalCalculationsOverview"]], "RelatedTutorials",
 CellID->21356267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Some Mathematical Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ExactAndApproximateResults"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ArbitraryPrecisionCalculations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 50.9041180}", "context" -> "", 
    "keywords" -> {
     "abs", "absolute value", "angles", "antilogarithm", "ArcCos", "ArcSin", 
      "ArcTan", "arc trigonometric functions", "arithmetic", "bang", 
      "brackets", "capital letters", "case sensitivity", "case sensitive", 
      "case independent", "circular functions", "constants", "Cos", "Degree", 
      "E", "exclamation point", "Exp", "exponential constant", 
      "exponential function", "factorial", "factoring", "FactorInteger", 
      "functions", "highest", "I", "infimum", "infinity", "integers", 
      "largest", "letters", "log", "logarithms", "lowest", 
      "mathematical constants", "Max", "maximum", "Min", "minimum", "mod", 
      "modulo", "modulus", "Monte Carlo methods", "natural logarithm", "pi", 
      "prime factors", "Pseudorandom numbers", "radians", "random", 
      "random numbers", "remainder", "roots", "round", "shriek", "sin", 
      "smallest", "Sqrt", "square roots", "Supremum", "tan", 
      "trigonometric functions", "uppercase letters"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica includes a very large collection of mathematical functions. \
\"Mathematical Functions\" gives the complete list. Here are a few of the \
common ones. Some common mathematical functions. Two important points about \
functions in Mathematica. ", "synonyms" -> {"1.1.3"}, "title" -> 
    "Some Mathematical Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/SomeMathematicalFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.1.3"->{
  Cell[3834, 88, 90, 2, 70, "Title",
   CellTags->{"S1.1.3", "3.1"},
   CellID->32686]},
 "3.1"->{
  Cell[3834, 88, 90, 2, 70, "Title",
   CellTags->{"S1.1.3", "3.1"},
   CellID->32686]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.1.3", 23941, 819},
 {"3.1", 24040, 823}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3209, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3834, 88, 90, 2, 70, "Title",
 CellTags->{"S1.1.3", "3.1"},
 CellID->32686],
Cell[3927, 92, 349, 9, 70, "Text",
 CellID->16589],
Cell[4279, 103, 5153, 173, 70, "DefinitionBox",
 CellID->20540],
Cell[9435, 278, 71, 1, 70, "Caption",
 CellID->18237],
Cell[9509, 281, 881, 28, 70, "FramedBox",
 CellID->22850],
Cell[10393, 311, 146, 6, 70, "Caption",
 CellID->18759],
Cell[10542, 319, 411, 13, 70, "Text",
 CellID->9578],
Cell[10956, 334, 439, 17, 70, "MathCaption",
 CellID->28956],
Cell[CellGroupData[{
Cell[11420, 355, 98, 3, 28, "Input",
 CellID->32677],
Cell[11521, 360, 171, 5, 36, "Output",
 CellID->2403]
}, Open  ]],
Cell[11707, 368, 224, 7, 70, "Text",
 CellID->28042],
Cell[11934, 377, 169, 7, 70, "MathCaption",
 CellID->6300],
Cell[CellGroupData[{
Cell[12128, 388, 98, 3, 70, "Input",
 CellID->15811],
Cell[12229, 393, 154, 5, 36, "Output",
 CellID->5225]
}, Open  ]],
Cell[12398, 401, 185, 7, 70, "MathCaption",
 CellID->21143],
Cell[CellGroupData[{
Cell[12608, 412, 121, 4, 70, "Input",
 CellID->21595],
Cell[12732, 418, 173, 5, 36, "Output",
 CellID->21016]
}, Open  ]],
Cell[12920, 426, 198, 6, 70, "MathCaption",
 CellID->26615],
Cell[CellGroupData[{
Cell[13143, 436, 98, 3, 70, "Input",
 CellID->28804],
Cell[13244, 441, 173, 5, 36, "Output",
 CellID->21006]
}, Open  ]],
Cell[13432, 449, 221, 6, 70, "MathCaption",
 CellID->28368],
Cell[CellGroupData[{
Cell[13678, 459, 97, 3, 70, "Input",
 CellID->31641],
Cell[13778, 464, 166, 6, 38, "Output",
 CellID->30335]
}, Open  ]],
Cell[13959, 473, 428, 12, 70, "MathCaption",
 CellID->698],
Cell[CellGroupData[{
Cell[14412, 489, 84, 3, 70, "Input",
 CellID->1325],
Cell[14499, 494, 188, 5, 36, "Output",
 CellID->28313]
}, Open  ]],
Cell[14702, 502, 108, 3, 70, "MathCaption",
 CellID->28023],
Cell[CellGroupData[{
Cell[14835, 509, 109, 4, 70, "Input",
 CellID->22312],
Cell[14947, 515, 177, 5, 36, "Output",
 CellID->24618]
}, Open  ]],
Cell[15139, 523, 1650, 53, 70, "DefinitionBox",
 CellID->18457],
Cell[16792, 578, 71, 1, 70, "Caption",
 CellID->18396],
Cell[16866, 581, 131, 4, 70, "Text",
 CellID->8339],
Cell[17000, 587, 188, 7, 70, "MathCaption",
 CellID->21086],
Cell[CellGroupData[{
Cell[17213, 598, 114, 4, 70, "Input",
 CellID->32094],
Cell[17330, 604, 171, 5, 36, "Output",
 CellID->7846]
}, Open  ]],
Cell[17516, 612, 295, 9, 70, "MathCaption",
 CellID->27043],
Cell[CellGroupData[{
Cell[17836, 625, 120, 4, 70, "Input",
 CellID->31522],
Cell[17959, 631, 155, 5, 36, "Output",
 CellID->12911]
}, Open  ]],
Cell[18129, 639, 420, 14, 70, "MathCaption",
 CellID->16280],
Cell[CellGroupData[{
Cell[18574, 657, 151, 5, 70, "Input",
 CellID->23455],
Cell[18728, 664, 174, 5, 36, "Output",
 CellID->26358]
}, Open  ]],
Cell[18917, 672, 310, 12, 70, "MathCaption",
 CellID->26847],
Cell[CellGroupData[{
Cell[19252, 688, 120, 4, 70, "Input",
 CellID->28870],
Cell[19375, 694, 154, 5, 36, "Output",
 CellID->990]
}, Open  ]],
Cell[19544, 702, 487, 18, 70, "MathCaption",
 CellID->3873],
Cell[CellGroupData[{
Cell[20056, 724, 121, 4, 70, "Input",
 CellID->4327],
Cell[20180, 730, 155, 5, 36, "Output",
 CellID->3413]
}, Open  ]],
Cell[CellGroupData[{
Cell[20372, 740, 72, 1, 70, "RelatedTutorialsSection",
 CellID->159832190],
Cell[20447, 743, 175, 4, 70, "RelatedTutorials",
 CellID->21356267]
}, Open  ]]
}, Open  ]],
Cell[20649, 751, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

