(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48902,       1826]
NotebookOptionsPosition[     38469,       1459]
NotebookOutlinePosition[     41177,       1528]
CellTagsIndexPosition[     41084,       1522]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Manipulating Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArrayRules" :> 
          Documentation`HelpLookup["paclet:ref/ArrayRules"], "Band" :> 
          Documentation`HelpLookup["paclet:ref/Band"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArrayRules\"\>", 2->"\<\"Band\"\>", 
       3->"\<\"Normal\"\>", 4->"\<\"SparseArray\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sparse Arrays: Manipulating Lists", "Title",
 CellTags->{"S2.4.5", "5.1"},
 CellID->23168],

Cell[TextData[{
 "Lists are normally specified in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just by giving explicit lists of their elements. But particularly in \
working with large arrays, it is often useful instead to be able to say what \
the values of elements are only at certain positions, with all other elements \
taken to have a default value, usually zero. You can do this in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Text",
 CellID->20027],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[", ", "TableText"], 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["11", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["12", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[", ", "TableText"], 
     StyleBox["\[Ellipsis]", "TR"]}], "\[SpanFromLeft]"},
   {"", Cell["ordinary lists", "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", 
     SubscriptBox[
      StyleBox["pos", "TI"], "1"], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["pos", "TI"], "2"], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["sparse arrays", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28148],

Cell["Ordinary lists and sparse arrays. ", "Caption",
 CellID->31993],

Cell["This specifies a sparse array. ", "MathCaption",
 CellID->10382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "->", "a"}], ",", 
    RowBox[{"5", "->", "b"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29271],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27669]
}, Open  ]],

Cell["Here it is as an ordinary list. ", "MathCaption",
 CellID->893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->20877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "a", ",", "0", ",", "0", ",", "b"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->1014]
}, Open  ]],

Cell["\<\
This specifies a two\[Hyphen]dimensional sparse array. \
\>", "MathCaption",
 CellID->19104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "->", "a"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], "->", "b"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "->", "c"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->484],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->2943]
}, Open  ]],

Cell["Here it is an ordinary list of lists. ", "MathCaption",
 CellID->11495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->26811],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "a", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "b", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->1293]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "sparse array version of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", 
     SubscriptBox[
      StyleBox["pos", "TI"], "1"], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["pos", "TI"], "2"], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "sparse array with values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["pos", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["pos", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["val", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["val", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["the same sparse array", "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Band",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Band"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["i", "TI"], ",", 
         StyleBox["j", "TI"]}], "}"}], "]"}], "->", 
      StyleBox["val", "TI"]}], "]"}], Cell[TextData[{
     "banded sparse array with values ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     StyleBox["data", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["d", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["d", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["d", "1"], "\[Cross]", 
        SubscriptBox["d", "2"], "\[Cross]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " sparse array"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     StyleBox["data", "TI"], ",", 
     StyleBox["dims", "TI"], ",", 
     StyleBox["val", "TI"], "]"}], Cell[TextData[{
     "sparse array with default value ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     StyleBox["array", "TI"], "]"}], Cell[TextData[{
     "ordinary list version of ",
     Cell[BoxData[
      StyleBox["array", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayRules",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayRules"], "[", 
     StyleBox["array", "TI"], "]"}], Cell[TextData[{
     "position\[Hyphen]value rules for ",
     Cell[BoxData[
      StyleBox["array", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, True, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->28892],

Cell["Creating and converting sparse arrays. ", "Caption",
 CellID->6798],

Cell["This generates a sparse array version of a list. ", "MathCaption",
 CellID->1990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->11299],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->14890]
}, Open  ]],

Cell["This converts back to an ordinary list. ", "MathCaption",
 CellID->8493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->29074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->1549]
}, Open  ]],

Cell[TextData[{
 "This makes a length 7 sparse array with default value ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "->", "a"}], ",", 
     RowBox[{"5", "->", "b"}]}], "}"}], ",", "7", ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[7]:= ",
 CellID->9314],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "7", "}"}], ",", "x"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->20173]
}, Open  ]],

Cell["Here is the corresponding ordinary list. ", "MathCaption",
 CellID->24069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->29218],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", "a", ",", "x", ",", "b", ",", "x", ",", "x"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->26865]
}, Open  ]],

Cell["This shows the rules used in the sparse array. ", "MathCaption",
 CellID->16833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", "%%", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->15238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", "3", "}"}], "\[Rule]", "a"}], ",", 
   RowBox[{
    RowBox[{"{", "5", "}"}], "\[Rule]", "b"}], ",", 
   RowBox[{
    RowBox[{"{", "_", "}"}], "\[Rule]", "x"}]}], "}"}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->19911]
}, Open  ]],

Cell["This creates a banded matrix. ", "MathCaption",
 CellID->14271596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "x"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "y"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->50369401],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWL9PAjEULgen4OFgjIkxDkaNGjcH9R/wRxyYnYkx0cFo1IGNkZGRkT+B
8UZGRkZGRkZGxufrj6N3Z8HWlhNJ7q5tXvt97XvvO+5Vqp9Pjy/Vz+eH6t7t
e/Xt6fnhY+/m9R2H8jlCyD1ed9sE24Atdt0D4JPfL/FewMFd1vPpPd9ut4H9
yBnr0zm8v8X69Xpd9PNsVoE1B4NBGIa0Sft0Ujn1XE+tVsKbh11PPFci9H6/
n1691WrFMf3pKsyGkDWD0bLACxhZyYeQVQYwmUxqtZpkkI9GOQnOyIpBEDuJ
OKMSG280GghGm94U3+v1er4b3MSOgwQyOhDdmERmZz8ajdzsfM5oglcRkjEV
5yPjz54P3Td1BF8q+hUhGZnTuOCpsTA2R9F5i6GcEscHdX4dp+zUsyv/2mof
uF7p7fUQkopzpDUrfb4/6VYg7Epaq5tEyWylCpT2RecMZilVOUt8pWJlxUBX
sbLyiJ5iqee6Z3NigZPOs1MwyaNlVSg9q03gOnahZc3/d8loOzc6X139ivxg
o2OmiuU+Ts0Ua0H4BoqVVabqKpZ7PjaK5Z6NWrFscKI8i/TLLI+WVaH0rOgZ
06C61rLmX3gyBq9+Nesn/TI7/xVwoVi28WOrWNb41oq1IB37E4/QvlvFsmGz
nxHOAdjk0bIqlIlVs9nUsJL1sbgVfrWPx2MQ0aOjT9GTe2c4HHY6HdqMVxfC
MBTVMBaKjrNBPcqrHd1uV1ELwi0Klj640oh5LNAjiVpYuhpYyISFjADJwkO/
ZOcT9pbCk+eCxBV7egrgWpdmc/hWiRVvL14gpM2NhaJLHI6+A/Nzi337iFo3
yX0BF4n3xA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->249561379]
}, Open  ]],

Cell[TextData[{
 "An important feature of ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " is that the positions you specify can be patterns. "
}], "Text",
 CellID->13252],

Cell[TextData[{
 "This specifies a 4x4 sparse array with ",
 Cell[BoxData["1"], "InlineFormula"],
 " at every position matching ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"i_", ",", "i_"}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "i_"}], "}"}], "->", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->6508],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->25149]
}, Open  ]],

Cell["The result is a 4x4 identity matrix. ", "MathCaption",
 CellID->23088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->12245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->6231]
}, Open  ]],

Cell["Here is an identity matrix with an extra element. ", "MathCaption",
 CellID->31920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "->", "a"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "->", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->10106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "a", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->19271]
}, Open  ]],

Cell[TextData[{
 "This makes the whole third column be\[NonBreakingSpace]",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"_", ",", "3"}], "}"}], "->", "a"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "->", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->6421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "a", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "a", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "a", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "a", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->15258]
}, Open  ]],

Cell[TextData[{
 "You can think of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   StyleBox["rules", "TI"], "]"}]], "InlineFormula"],
 " as taking all possible position specifications, then applying ",
 Cell[BoxData[
  StyleBox["rules", "TI"]], "InlineFormula"],
 " to determine values in each case. As usual, rules given earlier in the \
list will be tried first. "
}], "Text",
 CellID->4157],

Cell["This generates a random diagonal matrix. ", "MathCaption",
 CellID->9647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], ":>", 
      RowBox[{"RandomReal", "[", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->4982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.056070794834861534`", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0.630299795779359`", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0.3598942942214413`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->18238]
}, Open  ]],

Cell["You can have rules where values depend on indices. ", "MathCaption",
 CellID->24122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"i_", "->", 
     RowBox[{"i", "^", "2"}]}], ",", "10"}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->17723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",", 
   "64", ",", "81", ",", "100"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->906]
}, Open  ]],

Cell[TextData[{
 "This fills in even\[Hyphen]numbered positions with ",
 Cell[BoxData["p"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"_", "?", "EvenQ"}], "->", "p"}], ",", 
      RowBox[{"i_", "->", 
       RowBox[{"i", "^", "2"}]}]}], "}"}], ",", "10"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[16]:= ",
 CellID->10189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "p", ",", "9", ",", "p", ",", "25", ",", "p", ",", "49", ",", "p",
    ",", "81", ",", "p"}], "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->11156]
}, Open  ]],

Cell["You can use patterns involving alternatives. ", "MathCaption",
 CellID->30345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "|", "3"}], ",", 
       RowBox[{"2", "|", "4"}]}], "}"}], "->", "a"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->12351],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "a", ",", "0", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "a", ",", "0", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->6923]
}, Open  ]],

Cell["You can also give conditions on patterns. ", "MathCaption",
 CellID->7118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"i_", "/;", 
      RowBox[{"3", "<", "i", "<", "7"}]}], "->", "p"}], ",", "10"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->31550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "p", ",", "p", ",", "p", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->2097]
}, Open  ]],

Cell["\<\
This makes a band\[Hyphen]diagonal matrix. \
\>", "MathCaption",
 CellID->11836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"i", "-", "j"}], "]"}], "<", "2"}]}], "->", 
      RowBox[{"i", "+", "j"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->10591],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5", ",", "6", ",", "7", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "7", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "9", ",", "10"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{539, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->13406]
}, Open  ]],

Cell["Here is another way. ", "MathCaption",
 CellID->53937486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4", ",", "6", ",", "8", ",", "10"}], "}"}]}], ",", 
      
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"3", ",", "5", ",", "7", ",", "9"}], "}"}]}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"3", ",", "5", ",", "7", ",", "9"}], "}"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->205096747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5", ",", "6", ",", "7", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "7", ",", "8", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "9", ",", "10"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{539, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->16965504]
}, Open  ]],

Cell[TextData[{
 "For many purposes, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects just like the ordinary lists to which they correspond. Thus, for \
example, if you ask for parts of a sparse array object, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will operate as if you had asked for parts in the corresponding ordinary \
list. "
}], "Text",
 CellID->4510],

Cell["This generates a sparse array object. ", "MathCaption",
 CellID->25813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "->", "a"}], ",", 
      RowBox[{"4", "->", "b"}], ",", 
      RowBox[{"5", "->", "c"}]}], "}"}], ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->14651],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->25880]
}, Open  ]],

Cell["Here is the corresponding ordinary list. ", "MathCaption",
 CellID->27844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "s", "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->24743],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "a", ",", "0", ",", "b", ",", "c", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->7741]
}, Open  ]],

Cell["\<\
Parts of the sparse array are just like parts of the corresponding ordinary \
list. \
\>", "MathCaption",
 CellID->11245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->14578],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->4949]
}, Open  ]],

Cell["This part has the default value 0. ", "MathCaption",
 CellID->21705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "[", 
  RowBox[{"[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->24514],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->19785]
}, Open  ]],

Cell[TextData[{
 "Many operations treat ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects just like ordinary lists. When possible, they give sparse arrays \
as results. "
}], "Text",
 CellID->9227],

Cell["This gives a sparse array. ", "MathCaption",
 CellID->8624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "s"}], "+", "x"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->17204],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", "10", "}"}], ",", "x"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->28356]
}, Open  ]],

Cell["Here is the corresponding ordinary list. ", "MathCaption",
 CellID->23917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->6227],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{"3", " ", "a"}], "+", "x"}], ",", "x", ",", 
   RowBox[{
    RowBox[{"3", " ", "b"}], "+", "x"}], ",", 
   RowBox[{
    RowBox[{"3", " ", "c"}], "+", "x"}], ",", "x", ",", "x", ",", "x", ",", 
   "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{278, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->555]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " works directly with sparse array objects. "
}], "MathCaption",
 CellID->10102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", ".", "s"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->14286],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["b", "2"], "+", 
  SuperscriptBox["c", "2"]}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->19468]
}, Open  ]],

Cell["You can mix sparse arrays and ordinary lists. ", "MathCaption",
 CellID->11698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", ".", 
  RowBox[{"Range", "[", "10", "]"}]}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->8979],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "a"}], "+", 
  RowBox[{"4", " ", "b"}], "+", 
  RowBox[{"5", " ", "c"}]}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->21411]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents sparse arrays as expressions with head ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ". Whenever a sparse array is evaluated, it is automatically converted to an \
optimized standard form with structure ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", 
    StyleBox["dims", "TI"], ",", 
    StyleBox["val", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->12489],

Cell[TextData[{
 "This structure is, however, rarely evident, since even operations like ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " are set up to give results for the corresponding ordinary list, not for \
the raw ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " expression structure. "
}], "Text",
 CellID->10758],

Cell["This generates a sparse array. ", "MathCaption",
 CellID->13490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "a"}], ",", 
      RowBox[{"5", "->", "b"}]}], "}"}], ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->30775],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]= ",
 CellID->28410]
}, Open  ]],

Cell["Here is the underlying optimized expression structure. ", "MathCaption",
 CellID->17132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[29]:= ",
 CellID->27089],

Cell["\<\
SparseArray[Automatic, {10}, 0,   {1, {{0, 2}, {{1}, {5}}}, {a, b}}]\
\>", "Output",
 ImageSize->{476, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]//InputForm= ",
 CellID->27296]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " gives the length of the corresponding ordinary list. "
}], "MathCaption",
 CellID->11950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "t", "]"}]], "Input",
 CellLabel->"In[30]:= ",
 CellID->23112],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]= ",
 CellID->20122]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " also operates on individual values. "
}], "MathCaption",
 CellID->12529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"f", ",", "t"}], "]"}], "]"}]], "Input",
 CellLabel->"In[31]:= ",
 CellID->7672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "0", "]"}]}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]= ",
 CellID->25836]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->254544661],

Cell[TextData[ButtonBox["Manipulating Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsOverview"]], "RelatedTutorials",\

 CellID->30468725]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sparse Arrays: Manipulating Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Lists", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/ManipulatingListsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PartitioningAndPaddingLists"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 54.4979600}", "context" -> "", 
    "keywords" -> {
     "arrays", "band-diagonal matrices", "default values", "hashing", 
      "identity matrix", "lists", "matrices", "normal", 
      "position-value pairs", "rules", "SparseArray", "sparse arrays"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Lists are normally specified in Mathematica just by giving explicit \
lists of their elements. But particularly in working with large arrays, it is \
often useful instead to be able to say what the values of elements are only \
at certain positions, with all other elements taken to have a default value, \
usually zero. You can do this in Mathematica using SparseArray objects. \
Ordinary lists and sparse arrays. This specifies a sparse array. ", 
    "synonyms" -> {"2.4.5"}, "title" -> "Sparse Arrays: Manipulating Lists", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/SparseArrays-ManipulatingLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.4.5"->{
  Cell[2098, 62, 96, 2, 70, "Title",
   CellTags->{"S2.4.5", "5.1"},
   CellID->23168]},
 "5.1"->{
  Cell[2098, 62, 96, 2, 70, "Title",
   CellTags->{"S2.4.5", "5.1"},
   CellID->23168]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.4.5", 40873, 1511},
 {"5.1", 40972, 1515}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1473, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2098, 62, 96, 2, 70, "Title",
 CellTags->{"S2.4.5", "5.1"},
 CellID->23168],
Cell[2197, 66, 629, 17, 70, "Text",
 CellID->20027],
Cell[2829, 85, 1766, 52, 70, "DefinitionBox",
 CellID->28148],
Cell[4598, 139, 69, 1, 70, "Caption",
 CellID->31993],
Cell[4670, 142, 70, 1, 70, "MathCaption",
 CellID->10382],
Cell[CellGroupData[{
Cell[4765, 147, 203, 7, 28, "Input",
 CellID->29271],
Cell[4971, 156, 450, 16, 36, "Output",
 CellID->27669]
}, Open  ]],
Cell[5436, 175, 69, 1, 70, "MathCaption",
 CellID->893],
Cell[CellGroupData[{
Cell[5530, 180, 99, 3, 28, "Input",
 CellID->20877],
Cell[5632, 185, 229, 7, 36, "Output",
 CellID->1014]
}, Open  ]],
Cell[5876, 195, 102, 3, 70, "MathCaption",
 CellID->19104],
Cell[CellGroupData[{
Cell[6003, 202, 396, 14, 70, "Input",
 CellID->484],
Cell[6402, 218, 475, 17, 36, "Output",
 CellID->2943]
}, Open  ]],
Cell[6892, 238, 77, 1, 70, "MathCaption",
 CellID->11495],
Cell[CellGroupData[{
Cell[6994, 243, 99, 3, 70, "Input",
 CellID->26811],
Cell[7096, 248, 387, 13, 36, "Output",
 CellID->1293]
}, Open  ]],
Cell[7498, 264, 4566, 147, 70, "DefinitionBox",
 CellID->28892],
Cell[12067, 413, 73, 1, 70, "Caption",
 CellID->6798],
Cell[12143, 416, 87, 1, 70, "MathCaption",
 CellID->1990],
Cell[CellGroupData[{
Cell[12255, 421, 171, 5, 70, "Input",
 CellID->11299],
Cell[12429, 428, 450, 16, 36, "Output",
 CellID->14890]
}, Open  ]],
Cell[12894, 447, 78, 1, 70, "MathCaption",
 CellID->8493],
Cell[CellGroupData[{
Cell[12997, 452, 99, 3, 70, "Input",
 CellID->29074],
Cell[13099, 457, 219, 7, 36, "Output",
 CellID->1549]
}, Open  ]],
Cell[13333, 467, 153, 5, 70, "MathCaption",
 CellID->13774],
Cell[CellGroupData[{
Cell[13511, 476, 241, 9, 70, "Input",
 CellID->9314],
Cell[13755, 487, 460, 16, 36, "Output",
 CellID->20173]
}, Open  ]],
Cell[14230, 506, 80, 1, 70, "MathCaption",
 CellID->24069],
Cell[CellGroupData[{
Cell[14335, 511, 99, 3, 70, "Input",
 CellID->29218],
Cell[14437, 516, 254, 8, 36, "Output",
 CellID->26865]
}, Open  ]],
Cell[14706, 527, 86, 1, 70, "MathCaption",
 CellID->16833],
Cell[CellGroupData[{
Cell[14817, 532, 104, 3, 70, "Input",
 CellID->15238],
Cell[14924, 537, 376, 13, 36, "Output",
 CellID->19911]
}, Open  ]],
Cell[15315, 553, 72, 1, 70, "MathCaption",
 CellID->14271596],
Cell[CellGroupData[{
Cell[15412, 558, 526, 18, 28, "Input",
 CellID->50369401],
Cell[15941, 578, 1089, 22, 108, "Output",
 Evaluatable->False,
 CellID->249561379]
}, Open  ]],
Cell[17045, 603, 253, 8, 70, "Text",
 CellID->13252],
Cell[17301, 613, 257, 9, 70, "MathCaption",
 CellID->6463],
Cell[CellGroupData[{
Cell[17583, 626, 254, 9, 70, "Input",
 CellID->6508],
Cell[17840, 637, 477, 17, 36, "Output",
 CellID->25149]
}, Open  ]],
Cell[18332, 657, 76, 1, 70, "MathCaption",
 CellID->23088],
Cell[CellGroupData[{
Cell[18433, 662, 100, 3, 70, "Input",
 CellID->12245],
Cell[18536, 667, 497, 15, 36, "Output",
 CellID->6231]
}, Open  ]],
Cell[19048, 685, 89, 1, 70, "MathCaption",
 CellID->31920],
Cell[CellGroupData[{
Cell[19162, 690, 436, 15, 70, "Input",
 CellID->10106],
Cell[19601, 707, 498, 15, 36, "Output",
 CellID->19271]
}, Open  ]],
Cell[20114, 725, 154, 5, 70, "MathCaption",
 CellID->12368],
Cell[CellGroupData[{
Cell[20293, 734, 435, 15, 70, "Input",
 CellID->6421],
Cell[20731, 751, 498, 15, 36, "Output",
 CellID->15258]
}, Open  ]],
Cell[21244, 769, 477, 14, 70, "Text",
 CellID->4157],
Cell[21724, 785, 79, 1, 70, "MathCaption",
 CellID->9647],
Cell[CellGroupData[{
Cell[21828, 790, 357, 12, 70, "Input",
 CellID->4982],
Cell[22188, 804, 447, 14, 36, "Output",
 CellID->18238]
}, Open  ]],
Cell[22650, 821, 90, 1, 70, "MathCaption",
 CellID->24122],
Cell[CellGroupData[{
Cell[22765, 826, 216, 7, 70, "Input",
 CellID->17723],
Cell[22984, 835, 295, 9, 36, "Output",
 CellID->906]
}, Open  ]],
Cell[23294, 847, 150, 5, 70, "MathCaption",
 CellID->18706],
Cell[CellGroupData[{
Cell[23469, 856, 333, 12, 70, "Input",
 CellID->10189],
Cell[23805, 870, 292, 9, 36, "Output",
 CellID->11156]
}, Open  ]],
Cell[24112, 882, 84, 1, 70, "MathCaption",
 CellID->30345],
Cell[CellGroupData[{
Cell[24221, 887, 348, 12, 70, "Input",
 CellID->12351],
Cell[24572, 901, 497, 15, 36, "Output",
 CellID->6923]
}, Open  ]],
Cell[25084, 919, 80, 1, 70, "MathCaption",
 CellID->7118],
Cell[CellGroupData[{
Cell[25189, 924, 257, 9, 70, "Input",
 CellID->31550],
Cell[25449, 935, 288, 9, 36, "Output",
 CellID->2097]
}, Open  ]],
Cell[25752, 947, 90, 3, 70, "MathCaption",
 CellID->11836],
Cell[CellGroupData[{
Cell[25867, 954, 473, 16, 70, "Input",
 CellID->10591],
Cell[26343, 972, 631, 18, 36, "Output",
 CellID->13406]
}, Open  ]],
Cell[26989, 993, 63, 1, 70, "MathCaption",
 CellID->53937486],
Cell[CellGroupData[{
Cell[27077, 998, 909, 28, 70, "Input",
 CellID->205096747],
Cell[27989, 1028, 632, 18, 36, "Output",
 CellID->16965504]
}, Open  ]],
Cell[28636, 1049, 525, 16, 70, "Text",
 CellID->4510],
Cell[29164, 1067, 77, 1, 70, "MathCaption",
 CellID->25813],
Cell[CellGroupData[{
Cell[29266, 1072, 298, 10, 70, "Input",
 CellID->14651],
Cell[29567, 1084, 452, 16, 36, "Output",
 CellID->25880]
}, Open  ]],
Cell[30034, 1103, 80, 1, 70, "MathCaption",
 CellID->27844],
Cell[CellGroupData[{
Cell[30139, 1108, 100, 3, 70, "Input",
 CellID->24743],
Cell[30242, 1113, 288, 9, 36, "Output",
 CellID->7741]
}, Open  ]],
Cell[30545, 1125, 131, 4, 70, "MathCaption",
 CellID->11245],
Cell[CellGroupData[{
Cell[30701, 1133, 118, 4, 70, "Input",
 CellID->14578],
Cell[30822, 1139, 155, 5, 36, "Output",
 CellID->4949]
}, Open  ]],
Cell[30992, 1147, 74, 1, 70, "MathCaption",
 CellID->21705],
Cell[CellGroupData[{
Cell[31091, 1152, 118, 4, 70, "Input",
 CellID->24514],
Cell[31212, 1158, 156, 5, 36, "Output",
 CellID->19785]
}, Open  ]],
Cell[31383, 1166, 286, 9, 70, "Text",
 CellID->9227],
Cell[31672, 1177, 65, 1, 70, "MathCaption",
 CellID->8624],
Cell[CellGroupData[{
Cell[31762, 1182, 113, 4, 70, "Input",
 CellID->17204],
Cell[31878, 1188, 462, 16, 36, "Output",
 CellID->28356]
}, Open  ]],
Cell[32355, 1207, 80, 1, 70, "MathCaption",
 CellID->23917],
Cell[CellGroupData[{
Cell[32460, 1212, 99, 3, 70, "Input",
 CellID->6227],
Cell[32562, 1217, 431, 14, 36, "Output",
 CellID->555]
}, Open  ]],
Cell[33008, 1234, 206, 7, 70, "MathCaption",
 CellID->10102],
Cell[CellGroupData[{
Cell[33239, 1245, 90, 3, 70, "Input",
 CellID->14286],
Cell[33332, 1250, 260, 9, 36, "Output",
 CellID->19468]
}, Open  ]],
Cell[33607, 1262, 85, 1, 70, "MathCaption",
 CellID->11698],
Cell[CellGroupData[{
Cell[33717, 1267, 122, 4, 70, "Input",
 CellID->8979],
Cell[33842, 1273, 257, 9, 36, "Output",
 CellID->21411]
}, Open  ]],
Cell[34114, 1285, 768, 24, 70, "Text",
 CellID->12489],
Cell[34885, 1311, 474, 14, 70, "Text",
 CellID->10758],
Cell[35362, 1327, 70, 1, 70, "MathCaption",
 CellID->13490],
Cell[CellGroupData[{
Cell[35457, 1332, 260, 9, 70, "Input",
 CellID->30775],
Cell[35720, 1343, 452, 16, 36, "Output",
 CellID->28410]
}, Open  ]],
Cell[36187, 1362, 94, 1, 70, "MathCaption",
 CellID->17132],
Cell[CellGroupData[{
Cell[36306, 1367, 103, 3, 70, "Input",
 CellID->27089],
Cell[36412, 1372, 234, 7, 50, "Output",
 CellID->27296]
}, Open  ]],
Cell[36661, 1382, 223, 7, 70, "MathCaption",
 CellID->11950],
Cell[CellGroupData[{
Cell[36909, 1393, 100, 3, 70, "Input",
 CellID->23112],
Cell[37012, 1398, 157, 5, 36, "Output",
 CellID->20122]
}, Open  ]],
Cell[37184, 1406, 200, 7, 70, "MathCaption",
 CellID->12529],
Cell[CellGroupData[{
Cell[37409, 1417, 153, 5, 70, "Input",
 CellID->7672],
Cell[37565, 1424, 572, 17, 36, "Output",
 CellID->25836]
}, Open  ]],
Cell[CellGroupData[{
Cell[38174, 1446, 72, 1, 70, "RelatedTutorialsSection",
 CellID->254544661],
Cell[38249, 1449, 166, 4, 70, "RelatedTutorials",
 CellID->30468725]
}, Open  ]]
}, Open  ]],
Cell[38442, 1457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

