(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17519,        621]
NotebookOptionsPosition[     11801,        437]
NotebookOutlinePosition[     14575,        508]
CellTagsIndexPosition[     14484,        502]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Strings and Characters" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/StringsAndCharactersOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Strings and Characters\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Special Characters", "Title",
 CellTags->{"S2.8.6", "6.1"},
 CellID->11857],

Cell[TextData[{
 "In addition to the ordinary characters that appear on a standard keyboard, \
you can include in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings any of the special characters that are supported by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->8968],

Cell["Here is a string containing special characters. ", "MathCaption",
 CellID->1710],

Cell[CellGroupData[{

Cell[BoxData["\"\<\[Alpha]\[CirclePlus]\[Beta]\[CirclePlus]\[Ellipsis]\>\""], \
"Input",
 CellLabel->"In[1]:=",
 CellID->21968],

Cell[BoxData["\<\"\[Alpha]\[CirclePlus]\[Beta]\[CirclePlus]\[Ellipsis]\"\>"], \
"Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43815259]
}, Open  ]],

Cell["You can manipulate this string just as you would any other. ", \
"MathCaption",
 CellID->2641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"%", ",", 
   RowBox[{
   "\"\<\[CirclePlus]\>\"", "->", "\"\< \[CircleDot]\[CircleDot] \>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27732],

Cell[BoxData["\<\"\[Alpha] \[CircleDot]\[CircleDot] \[Beta] \[CircleDot]\
\[CircleDot] \[Ellipsis]\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1285115184]
}, Open  ]],

Cell["Here is the list of the characters in the string. ", "MathCaption",
 CellID->11684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[Alpha]\"\>", ",", "\<\" \"\>", ",", "\<\"\[CircleDot]\"\>", 
   ",", "\<\"\[CircleDot]\"\>", ",", "\<\" \"\>", ",", "\<\"\[Beta]\"\>", 
   ",", "\<\" \"\>", ",", "\<\"\[CircleDot]\"\>", ",", "\<\"\[CircleDot]\"\>",
    ",", "\<\" \"\>", ",", "\<\"\[Ellipsis]\"\>"}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1934144406]
}, Open  ]],

Cell[TextData[{
 "In a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, a special character such as ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " can always be displayed directly. But if you use a text\[Hyphen]based \
interface, then typically the only characters that can readily be displayed \
are the ones that appear on your keyboard. "
}], "Text",
 CellID->29869],

Cell[TextData[{
 "As a result, what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does in such situations is to try to approximate special characters by \
similar\[Hyphen]looking sequences of ordinary characters. And when this is \
not practical, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just gives the full name of the special character. "
}], "Text",
 CellID->28583],

Cell[TextData[{
 "In a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook using ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", special characters can be displayed directly. "
}], "MathCaption",
 CellID->29256],

Cell[CellGroupData[{

Cell[BoxData["\"\<Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\>\""], \
"Input",
 CellLabel->"In[4]:=",
 CellID->19692],

Cell[BoxData["\<\"Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\"\>"], \
"Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->208631320]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ", however, the special characters are approximated when possible by \
sequences of ordinary ones. "
}], "MathCaption",
 CellID->12087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "OutputForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->15012],

Cell[OutputFormData["\<\
\"Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\"\
\>", "\<\
Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\
\>"], "Output",
 ImageSize->{77, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//OutputForm=",
 CellID->153201573]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always uses full names for special characters in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". This means that when special characters are written out to files or \
external programs, they are by default represented purely as sequences of \
ordinary characters. "
}], "Text",
 CellID->5820],

Cell[TextData[{
 "This uniform representation is crucial in allowing special characters in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to be used in a way that does not depend on the details of particular \
computer systems. "
}], "Text",
 CellID->14835],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " the full names of all special characters are always written out \
explicitly. "
}], "MathCaption",
 CellID->1663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\>\"", "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->10615],

Cell["\"Lam\[EAcute] \[LongRightArrow] \[Alpha]\[Beta]+\"", "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//InputForm=",
 CellID->562858485]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    StyleBox["a", "TI"], Cell["a literal character", "TableText"]},
   {Cell[TextData[{
     "\[Backslash]",
     Cell[BoxData[
      RowBox[{"[", 
       StyleBox["Name", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"], Cell[
    "a character specified using its full name", "TableText"]},
   {Cell[TextData[{
     "\[Backslash]",
     Cell[BoxData["\"\< \>"], "InlineFormula"]
    }], "TableText"], Cell[TextData[{
     "a ",
     Cell[BoxData["\"\<\>"], "InlineFormula"],
     " to be included in a string"
    }], "TableText"]},
   {Cell["\[Backslash]\[Backslash]", "TableText"], Cell[
    "a \[Backslash] to be included in a string", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18677],

Cell["Ways to enter characters in a string. ", "Caption",
 CellID->2774],

Cell[TextData[{
 "You have to use \[Backslash] to \[OpenCurlyDoubleQuote]escape\
\[CloseCurlyDoubleQuote] any ",
 Cell[BoxData["\"\<\>"], "InlineFormula"],
 " or \[Backslash] characters in strings that you enter. "
}], "MathCaption",
 CellID->10134],

Cell[CellGroupData[{

Cell[BoxData["\"\<Strings can contain \\\"quotes\\\" and \\\\ \
characters.\>\""], "Input",
 CellLabel->"In[7]:=",
 CellID->27553],

Cell[BoxData["\<\"Strings can contain \\\"quotes\\\" and \\\\ \
characters.\"\>"], "Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->2039133611]
}, Open  ]],

Cell[TextData[{
 "\[Backslash]\[Backslash] produces a literal \[Backslash] rather than \
forming part of the specification of ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->28878],

Cell[CellGroupData[{

Cell[BoxData["\"\<\\\\[Alpha] is \[Alpha].\>\""], "Input",
 CellLabel->"In[8]:=",
 CellID->2286],

Cell[BoxData["\<\"\\\\[Alpha] is \[Alpha].\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->648404056]
}, Open  ]],

Cell["\<\
This breaks the string into a list of individual characters. \
\>", "MathCaption",
 CellID->2734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->18075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\\\\\"\>", ",", "\<\"[\"\>", ",", "\<\"A\"\>", 
   ",", "\<\"l\"\>", ",", "\<\"p\"\>", ",", "\<\"h\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"]\"\>", ",", "\<\" \"\>", ",", "\<\"i\"\>", ",", "\<\"s\"\>", 
   ",", "\<\" \"\>", ",", "\<\"\[Alpha]\"\>", ",", "\<\".\"\>"}], 
  "}"}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->2126124339]
}, Open  ]],

Cell[TextData[{
 "This creates a list of the characters in the full name of ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->30712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", 
  RowBox[{"ToString", "[", 
   RowBox[{"FullForm", "[", "\"\<\[Alpha]\>\"", "]"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[10]:=",
 CellID->26984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\\\"\"\>", ",", "\<\"\\\\\"\>", ",", "\<\"[\"\>", 
   ",", "\<\"A\"\>", ",", "\<\"l\"\>", ",", "\<\"p\"\>", ",", "\<\"h\"\>", 
   ",", "\<\"a\"\>", ",", "\<\"]\"\>", ",", "\<\"\\\"\"\>"}], "}"}]], "Output",\

 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->30657876]
}, Open  ]],

Cell[TextData[{
 "And this produces a string consisting of an actual ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " from its full name. "
}], "MathCaption",
 CellID->27792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"\"\<\\\"\\\\[\>\"", "<>", "\"\<Alpha\>\"", "<>", "\"\<]\\\"\>\""}],
   "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->6504],

Cell[BoxData["\<\"\[Alpha]\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1860638196]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->19152881],

Cell[TextData[ButtonBox["Strings and Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringsAndCharactersOverview"]], "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Special Characters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Strings and Characters", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/StringsAndCharactersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RegularExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NewlinesAndTabsInStrings"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 55.5136110}", "context" -> "", 
    "keywords" -> {
     "backslash", "characters", "full names of special characters", 
      "line feed", "newline in string", "quotes", "special characters", 
      "\\\"", "\\\\", "\\n", "\\r", "\\t"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In addition to the ordinary characters that appear on a standard \
keyboard, you can include in Mathematica strings any of the special \
characters that are supported by Mathematica. Here is a string containing \
special characters. You can manipulate this string just as you would any \
other. ", "synonyms" -> {"2.8.6"}, "title" -> "Special Characters", "type" -> 
    "Tutorial", "uri" -> "tutorial/SpecialCharacters-StringsAndCharacters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.8.6"->{
  Cell[1265, 43, 81, 2, 70, "Title",
   CellTags->{"S2.8.6", "6.1"},
   CellID->11857]},
 "6.1"->{
  Cell[1265, 43, 81, 2, 70, "Title",
   CellTags->{"S2.8.6", "6.1"},
   CellID->11857]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.8.6", 14273, 491},
 {"6.1", 14372, 495}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 640, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1265, 43, 81, 2, 70, "Title",
 CellTags->{"S2.8.6", "6.1"},
 CellID->11857],
Cell[1349, 47, 313, 10, 70, "Text",
 CellID->8968],
Cell[1665, 59, 86, 1, 70, "MathCaption",
 CellID->1710],
Cell[CellGroupData[{
Cell[1776, 64, 127, 3, 28, "Input",
 CellID->21968],
Cell[1906, 69, 218, 6, 36, "Output",
 CellID->43815259]
}, Open  ]],
Cell[2139, 78, 100, 2, 70, "MathCaption",
 CellID->2641],
Cell[CellGroupData[{
Cell[2264, 84, 213, 7, 28, "Input",
 CellID->27732],
Cell[2480, 93, 246, 6, 36, "Output",
 CellID->1285115184]
}, Open  ]],
Cell[2741, 102, 89, 1, 70, "MathCaption",
 CellID->11684],
Cell[CellGroupData[{
Cell[2855, 107, 102, 3, 28, "Input",
 CellID->32499],
Cell[2960, 112, 462, 10, 36, "Output",
 CellID->1934144406]
}, Open  ]],
Cell[3437, 125, 415, 11, 70, "Text",
 CellID->29869],
Cell[3855, 138, 391, 11, 70, "Text",
 CellID->28583],
Cell[4249, 151, 309, 11, 70, "MathCaption",
 CellID->29256],
Cell[CellGroupData[{
Cell[4583, 166, 122, 3, 70, "Input",
 CellID->19692],
Cell[4708, 171, 214, 6, 36, "Output",
 CellID->208631320]
}, Open  ]],
Cell[4937, 180, 283, 9, 70, "MathCaption",
 CellID->12087],
Cell[CellGroupData[{
Cell[5245, 193, 98, 3, 70, "Input",
 CellID->15012],
Cell[5346, 198, 294, 9, 55, "Output",
 CellID->153201573]
}, Open  ]],
Cell[5655, 210, 440, 12, 70, "Text",
 CellID->5820],
Cell[6098, 224, 265, 7, 70, "Text",
 CellID->14835],
Cell[6366, 233, 261, 9, 70, "MathCaption",
 CellID->1663],
Cell[CellGroupData[{
Cell[6652, 246, 154, 4, 70, "Input",
 CellID->10615],
Cell[6809, 252, 210, 5, 50, "Output",
 CellID->562858485]
}, Open  ]],
Cell[7034, 260, 1027, 28, 70, "DefinitionBox",
 CellID->18677],
Cell[8064, 290, 72, 1, 70, "Caption",
 CellID->2774],
Cell[8139, 293, 249, 6, 70, "MathCaption",
 CellID->10134],
Cell[CellGroupData[{
Cell[8413, 303, 130, 3, 70, "Input",
 CellID->27553],
Cell[8546, 308, 224, 6, 36, "Output",
 CellID->2039133611]
}, Open  ]],
Cell[8785, 317, 240, 7, 70, "MathCaption",
 CellID->28878],
Cell[CellGroupData[{
Cell[9050, 328, 96, 2, 70, "Input",
 CellID->2286],
Cell[9149, 332, 190, 5, 36, "Output",
 CellID->648404056]
}, Open  ]],
Cell[9354, 340, 107, 3, 70, "MathCaption",
 CellID->2734],
Cell[CellGroupData[{
Cell[9486, 347, 102, 3, 70, "Input",
 CellID->18075],
Cell[9591, 352, 462, 11, 36, "Output",
 CellID->2126124339]
}, Open  ]],
Cell[10068, 366, 190, 6, 70, "MathCaption",
 CellID->30712],
Cell[CellGroupData[{
Cell[10283, 376, 191, 6, 70, "Input",
 CellID->26984],
Cell[10477, 384, 383, 10, 36, "Output",
 CellID->30657876]
}, Open  ]],
Cell[10875, 397, 202, 6, 70, "MathCaption",
 CellID->27792],
Cell[CellGroupData[{
Cell[11102, 407, 182, 5, 70, "Input",
 CellID->6504],
Cell[11287, 414, 175, 5, 36, "Output",
 CellID->1860638196]
}, Open  ]],
Cell[CellGroupData[{
Cell[11499, 424, 71, 1, 70, "RelatedTutorialsSection",
 CellID->19152881],
Cell[11573, 427, 174, 4, 70, "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],
Cell[11774, 435, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

