(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27080,       1055]
NotebookOptionsPosition[     19679,        814]
NotebookOutlinePosition[     22844,        890]
CellTagsIndexPosition[     22753,        884]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transformation Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AppendTo" :> Documentation`HelpLookup["paclet:ref/AppendTo"], 
          "PrependTo" :> Documentation`HelpLookup["paclet:ref/PrependTo"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"AppendTo\"\>", 
       2->"\<\"PrependTo\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Special Forms of Assignment", "Title",
 CellTags->{"S2.5.4", "4.1"},
 CellID->4055],

Cell[TextData[{
 "Particularly when you write procedural programs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you will often need to modify the value of a particular variable \
repeatedly. You can always do this by constructing the new value and \
explicitly performing an assignment such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", however, provides special notations for incrementing the values of \
variables, and for some other common cases. "
}], "Text",
 CellID->18913],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["i", "TI"], "++"}], Cell[TextData[{
     "increment the value of ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData["1"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["i", "TI"], "--"}], Cell[TextData[{
     "decrement ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"++", 
     StyleBox["i", "TI"]}], Cell[TextData[{
     "pre\[Hyphen]increment ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"--", 
     StyleBox["i", "TI"]}], Cell[TextData[{
     "pre\[Hyphen]decrement ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["i", "TI"], "+=", 
     StyleBox["di", "TI"]}], Cell[TextData[{
     "add ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     " to the value of ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["i", "TI"], "-=", 
     StyleBox["di", "TI"]}], Cell[TextData[{
     "subtract ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "*=", 
     StyleBox["c", "TI"]}], Cell[TextData[{
     "multiply ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "/=", 
     StyleBox["c", "TI"]}], Cell[TextData[{
     "divide ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->462],

Cell["Modifying values of variables. ", "Caption",
 CellID->24473],

Cell[TextData[{
 "This assigns the value ",
 Cell[BoxData[
  RowBox[{"7", "x"}]], "InlineFormula"],
 " to the variable ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"7", "x"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->24160],

Cell[BoxData[
 RowBox[{"7", " ", "x"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->31122]
}, Open  ]],

Cell[TextData[{
 "This increments the value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " by ",
 Cell[BoxData[
  RowBox[{"18", "x"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "+=", 
  RowBox[{"18", "x"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->19397],

Cell[BoxData[
 RowBox[{"25", " ", "x"}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->11822]
}, Open  ]],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["t"], "InlineFormula"],
 " has been modified. "
}], "MathCaption",
 CellID->19750],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[3]:= ",
 CellID->21337],

Cell[BoxData[
 RowBox[{"25", " ", "x"}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->13917]
}, Open  ]],

Cell[TextData[{
 "This sets ",
 Cell[BoxData["t"], "InlineFormula"],
 " to ",
 Cell[BoxData["8"], "InlineFormula"],
 ", multiplies its value by ",
 Cell[BoxData["7"], "InlineFormula"],
 ", then gives the final value of\[NonBreakingSpace]",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "8"}], ";", 
  RowBox[{"t", "*=", "7"}], ";", "t"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->4931],

Cell[BoxData["56"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->22197]
}, Open  ]],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  RowBox[{"i", "++"}]], "InlineFormula"],
 " is the value of ",
 Cell[BoxData["i"], "InlineFormula"],
 " ",
 StyleBox["before",
  FontSlant->"Italic"],
 " the increment is done. "
}], "MathCaption",
 CellID->27505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "5"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"i", "++"}], "]"}], ";", 
  RowBox[{"Print", "[", "i", "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->29236],

Cell[CellGroupData[{

Cell[BoxData["5"], "Print",
 CellID->10357],

Cell[BoxData["6"], "Print",
 CellID->6599]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  RowBox[{"++", "i"}]], "InlineFormula"],
 " is the value of ",
 Cell[BoxData["i"], "InlineFormula"],
 " ",
 StyleBox["after",
  FontSlant->"Italic"],
 " the increment. "
}], "MathCaption",
 CellID->28290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "5"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"++", "i"}], "]"}], ";", 
  RowBox[{"Print", "[", "i", "]"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->1898],

Cell[CellGroupData[{

Cell[BoxData["6"], "Print",
 CellID->985],

Cell[BoxData["6"], "Print",
 CellID->21447]
}, Open  ]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "=", 
     StyleBox["y", "TI"], "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "assign the same value to both ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", "=", "{", 
     SubscriptBox[
      StyleBox["value", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["value", "TI"], "2"], "}"}], Cell[TextData[{
     "assign different values to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "}", "=", "{", 
     StyleBox["y", "TI"], ",", 
     StyleBox["x", "TI"], "}"}], Cell[TextData[{
     "interchange the values of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1084],

Cell["Assigning values to several variables at a time. ", "Caption",
 CellID->592],

Cell[TextData[{
 "This assigns the value ",
 Cell[BoxData["5"], "InlineFormula"],
 " to ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["8"], "InlineFormula"],
 " to\[NonBreakingSpace]",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{"5", ",", "8"}], "}"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->8996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "8"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->29855]
}, Open  ]],

Cell[TextData[{
 "This interchanges the values of ",
 Cell[BoxData["x"], "InlineFormula"],
 " and\[NonBreakingSpace]",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{"y", ",", "x"}], "}"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->15338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "5"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->17342]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData["x"], "InlineFormula"],
 " has value ",
 Cell[BoxData["8"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14428],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[9]:= ",
 CellID->29795],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->30742]
}, Open  ]],

Cell[TextData[{
 "And ",
 Cell[BoxData["y"], "InlineFormula"],
 " has value ",
 Cell[BoxData["5"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30037],

Cell[CellGroupData[{

Cell[BoxData["y"], "Input",
 CellLabel->"In[10]:= ",
 CellID->5506],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->6767]
}, Open  ]],

Cell["\<\
You can use assignments to lists to permute values of variables in any way. \
\>", "MathCaption",
 CellID->5053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "c"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "b"}], "}"}]}], ";", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->9793],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->28505]
}, Open  ]],

Cell[TextData[{
 "When you write programs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you will sometimes find it convenient to take a list, and successively \
add elements to it. You can do this using the functions ",
 Cell[BoxData[
  ButtonBox["PrependTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrependTo"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AppendTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppendTo"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24146],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PrependTo",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrependTo"], "[", 
     StyleBox["v", "TI"], ",", 
     StyleBox["elem", "TI"], "]"}], Cell[TextData[{
     "prepend ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " to the value of ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AppendTo",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AppendTo"], "[", 
     StyleBox["v", "TI"], ",", 
     StyleBox["elem", "TI"], "]"}], Cell[TextData[{
     "append ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["v", "TI"], "=", "{", 
     StyleBox["v", "TI"], ",", 
     StyleBox["elem", "TI"], "}"}], Cell[TextData[{
     "make a nested list containing ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3609],

Cell["Assignments for modifying lists. ", "Caption",
 CellID->13924],

Cell[TextData[{
 "This assigns the value of ",
 Cell[BoxData["v"], "InlineFormula"],
 " to be the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"5", ",", "7", ",", "9"}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"5", ",", "7", ",", "9"}], "}"}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->29465],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "7", ",", "9"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->12239]
}, Open  ]],

Cell[TextData[{
 "This appends the element ",
 Cell[BoxData["11"], "InlineFormula"],
 " to the value of ",
 Cell[BoxData["v"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AppendTo", "[", 
  RowBox[{"v", ",", "11"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->24209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "7", ",", "9", ",", "11"}], "}"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->15492]
}, Open  ]],

Cell[TextData[{
 "Now the value of ",
 Cell[BoxData["v"], "InlineFormula"],
 " has been modified. "
}], "MathCaption",
 CellID->16499],

Cell[CellGroupData[{

Cell[BoxData["v"], "Input",
 CellLabel->"In[14]:= ",
 CellID->18175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "7", ",", "9", ",", "11"}], "}"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->31036]
}, Open  ]],

Cell[TextData[{
 "Although ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AppendTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppendTo"], "[", 
   RowBox[{
    StyleBox["v", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " is always equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["v", "TI"], "=", 
   RowBox[{
    ButtonBox["Append",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Append"], "[", 
    RowBox[{
     StyleBox["v", "TI"], ",", 
     StyleBox["elem", "TI"]}], "]"}]}]], "InlineFormula"],
 ", it is often a convenient notation. However, you should realize that \
because of the way ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stores lists, it is usually less efficient to add a sequence of elements \
to a particular list than to create a nested structure that consists, for \
example, of lists of length 2 at each level. When you have built up such a \
structure, you can always reduce it to a single list using ",
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->23061],

Cell[TextData[{
 "This sets up a nested list structure for\[NonBreakingSpace]",
 Cell[BoxData["w"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"{", "1", "}"}]}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"w", "=", 
     RowBox[{"{", 
      RowBox[{"w", ",", 
       RowBox[{"k", "^", "2"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "4"}], "}"}]}], "]"}], ";", "w"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->15618],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "1"}], "}"}], ",", "4"}], "}"}], ",", 
     "9"}], "}"}], ",", "16"}], "}"}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->25013]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " to unravel the structure. "
}], "MathCaption",
 CellID->26727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "w", "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->15712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "4", ",", "9", ",", "16"}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->27896]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->621918848],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Special Forms of Assignment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MakingDefinitions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/MakingDefinitionsForIndexedObjects"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 55.8261190}", "context" -> "", 
    "keywords" -> {
     "/=", "*=", "-=", "+=", "--", "++", "AddTo", "AppendTo", "decrement", 
      "DivideBy", "efficiency", "exchange values", "flatten", "functions", 
      "increment", "interchange values", "lists", "permute values", 
      "post-decrement", "post-increment", "PreDecrement", "PreIncrement", 
      "PrependTo", "SubtractFrom", "swap values", "TimesBy"}, "index" -> True,
     "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Particularly when you write procedural programs in Mathematica, you will \
often need to modify the value of a particular variable repeatedly. You can \
always do this by constructing the new value and explicitly performing an \
assignment such as x=value. Mathematica, however, provides special notations \
for incrementing the values of variables, and for some other common cases. \
Modifying values of variables. This assigns the value 7x to the variable t. ",
     "synonyms" -> {"2.5.4"}, "title" -> "Special Forms of Assignment", 
    "type" -> "Tutorial", "uri" -> "tutorial/SpecialFormsOfAssignment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.4"->{
  Cell[1955, 60, 89, 2, 70, "Title",
   CellTags->{"S2.5.4", "4.1"},
   CellID->4055]},
 "4.1"->{
  Cell[1955, 60, 89, 2, 70, "Title",
   CellTags->{"S2.5.4", "4.1"},
   CellID->4055]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.4", 22544, 873},
 {"4.1", 22642, 877}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1330, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1955, 60, 89, 2, 70, "Title",
 CellTags->{"S2.5.4", "4.1"},
 CellID->4055],
Cell[2047, 64, 617, 17, 70, "Text",
 CellID->18913],
Cell[2667, 83, 2310, 85, 70, "DefinitionBox",
 CellID->462],
Cell[4980, 170, 66, 1, 70, "Caption",
 CellID->24473],
Cell[5049, 173, 200, 8, 70, "MathCaption",
 CellID->20084],
Cell[CellGroupData[{
Cell[5274, 185, 107, 4, 28, "Input",
 CellID->24160],
Cell[5384, 191, 177, 6, 36, "Output",
 CellID->31122]
}, Open  ]],
Cell[5576, 200, 194, 8, 70, "MathCaption",
 CellID->26053],
Cell[CellGroupData[{
Cell[5795, 212, 109, 4, 28, "Input",
 CellID->19397],
Cell[5907, 218, 178, 6, 36, "Output",
 CellID->11822]
}, Open  ]],
Cell[6100, 227, 130, 5, 70, "MathCaption",
 CellID->19750],
Cell[CellGroupData[{
Cell[6255, 236, 67, 2, 70, "Input",
 CellID->21337],
Cell[6325, 240, 178, 6, 36, "Output",
 CellID->13917]
}, Open  ]],
Cell[6518, 249, 317, 11, 70, "MathCaption",
 CellID->4006],
Cell[CellGroupData[{
Cell[6860, 264, 145, 5, 70, "Input",
 CellID->4931],
Cell[7008, 271, 156, 5, 36, "Output",
 CellID->22197]
}, Open  ]],
Cell[7179, 279, 263, 11, 70, "MathCaption",
 CellID->27505],
Cell[CellGroupData[{
Cell[7467, 294, 206, 7, 70, "Input",
 CellID->29236],
Cell[CellGroupData[{
Cell[7698, 305, 43, 1, 70, "Print",
 CellID->10357],
Cell[7744, 308, 42, 1, 70, "Print",
 CellID->6599]
}, Open  ]]
}, Open  ]],
Cell[7813, 313, 254, 11, 70, "MathCaption",
 CellID->28290],
Cell[CellGroupData[{
Cell[8092, 328, 205, 7, 70, "Input",
 CellID->1898],
Cell[CellGroupData[{
Cell[8322, 339, 41, 1, 70, "Print",
 CellID->985],
Cell[8366, 342, 43, 1, 70, "Print",
 CellID->21447]
}, Open  ]]
}, Open  ]],
Cell[8436, 347, 1509, 49, 70, "DefinitionBox",
 CellID->1084],
Cell[9948, 398, 82, 1, 70, "Caption",
 CellID->592],
Cell[10033, 401, 282, 11, 70, "MathCaption",
 CellID->18725],
Cell[CellGroupData[{
Cell[10340, 416, 182, 7, 70, "Input",
 CellID->8996],
Cell[10525, 425, 200, 7, 36, "Output",
 CellID->29855]
}, Open  ]],
Cell[10740, 435, 197, 7, 70, "MathCaption",
 CellID->24828],
Cell[CellGroupData[{
Cell[10962, 446, 183, 7, 70, "Input",
 CellID->15338],
Cell[11148, 455, 200, 7, 36, "Output",
 CellID->17342]
}, Open  ]],
Cell[11363, 465, 157, 7, 70, "MathCaption",
 CellID->14428],
Cell[CellGroupData[{
Cell[11545, 476, 67, 2, 70, "Input",
 CellID->29795],
Cell[11615, 480, 155, 5, 36, "Output",
 CellID->30742]
}, Open  ]],
Cell[11785, 488, 157, 7, 70, "MathCaption",
 CellID->30037],
Cell[CellGroupData[{
Cell[11967, 499, 67, 2, 70, "Input",
 CellID->5506],
Cell[12037, 503, 155, 5, 36, "Output",
 CellID->6767]
}, Open  ]],
Cell[12207, 511, 122, 3, 70, "MathCaption",
 CellID->5053],
Cell[CellGroupData[{
Cell[12354, 518, 438, 15, 70, "Input",
 CellID->9793],
Cell[12795, 535, 211, 7, 36, "Output",
 CellID->28505]
}, Open  ]],
Cell[13021, 545, 516, 17, 70, "Text",
 CellID->24146],
Cell[13540, 564, 1333, 43, 70, "DefinitionBox",
 CellID->3609],
Cell[14876, 609, 68, 1, 70, "Caption",
 CellID->13924],
Cell[14947, 612, 241, 9, 70, "MathCaption",
 CellID->19854],
Cell[CellGroupData[{
Cell[15213, 625, 147, 5, 70, "Input",
 CellID->29465],
Cell[15363, 632, 211, 7, 36, "Output",
 CellID->12239]
}, Open  ]],
Cell[15589, 642, 185, 7, 70, "MathCaption",
 CellID->26206],
Cell[CellGroupData[{
Cell[15799, 653, 126, 4, 70, "Input",
 CellID->24209],
Cell[15928, 659, 222, 7, 36, "Output",
 CellID->15492]
}, Open  ]],
Cell[16165, 669, 134, 5, 70, "MathCaption",
 CellID->16499],
Cell[CellGroupData[{
Cell[16324, 678, 68, 2, 70, "Input",
 CellID->18175],
Cell[16395, 682, 222, 7, 36, "Output",
 CellID->31036]
}, Open  ]],
Cell[16632, 692, 1132, 35, 70, "Text",
 CellID->23061],
Cell[17767, 729, 158, 5, 70, "MathCaption",
 CellID->13647],
Cell[CellGroupData[{
Cell[17950, 738, 367, 13, 70, "Input",
 CellID->15618],
Cell[18320, 753, 398, 15, 36, "Output",
 CellID->25013]
}, Open  ]],
Cell[18733, 771, 215, 8, 70, "MathCaption",
 CellID->26727],
Cell[CellGroupData[{
Cell[18973, 783, 101, 3, 70, "Input",
 CellID->15712],
Cell[19077, 788, 233, 7, 36, "Output",
 CellID->27896]
}, Open  ]],
Cell[CellGroupData[{
Cell[19347, 800, 72, 1, 70, "RelatedTutorialsSection",
 CellID->621918848],
Cell[19422, 803, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[19652, 812, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

