(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    304283,       8329]
NotebookOptionsPosition[    286425,       7792]
NotebookOutlinePosition[    292938,       7917]
CellTagsIndexPosition[    292841,       7911]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AiryAi" :> Documentation`HelpLookup["paclet:ref/AiryAi"], 
          "AiryAiPrime" :> Documentation`HelpLookup["paclet:ref/AiryAiPrime"],
           "AiryAiZero" :> Documentation`HelpLookup["paclet:ref/AiryAiZero"], 
          "AiryBi" :> Documentation`HelpLookup["paclet:ref/AiryBi"], 
          "AiryBiPrime" :> Documentation`HelpLookup["paclet:ref/AiryBiPrime"],
           "AiryBiZero" :> Documentation`HelpLookup["paclet:ref/AiryBiZero"], 
          "AppellF1" :> Documentation`HelpLookup["paclet:ref/AppellF1"], 
          "BesselI" :> Documentation`HelpLookup["paclet:ref/BesselI"], 
          "BesselJ" :> Documentation`HelpLookup["paclet:ref/BesselJ"], 
          "BesselJZero" :> Documentation`HelpLookup["paclet:ref/BesselJZero"],
           "BesselK" :> Documentation`HelpLookup["paclet:ref/BesselK"], 
          "BesselY" :> Documentation`HelpLookup["paclet:ref/BesselY"], 
          "BesselYZero" :> Documentation`HelpLookup["paclet:ref/BesselYZero"],
           "Beta" :> Documentation`HelpLookup["paclet:ref/Beta"], 
          "BetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/BetaRegularized"], "C" :> 
          Documentation`HelpLookup["paclet:ref/C"], "CoshIntegral" :> 
          Documentation`HelpLookup["paclet:ref/CoshIntegral"], "CosIntegral" :> 
          Documentation`HelpLookup["paclet:ref/CosIntegral"], "E" :> 
          Documentation`HelpLookup["paclet:ref/E"], "Erf" :> 
          Documentation`HelpLookup["paclet:ref/Erf"], "Erfc" :> 
          Documentation`HelpLookup["paclet:ref/Erfc"], "Erfi" :> 
          Documentation`HelpLookup["paclet:ref/Erfi"], "ExpIntegralE" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralE"], 
          "ExpIntegralEi" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralEi"], "FresnelC" :> 
          Documentation`HelpLookup["paclet:ref/FresnelC"], "FresnelS" :> 
          Documentation`HelpLookup["paclet:ref/FresnelS"], "Gamma" :> 
          Documentation`HelpLookup["paclet:ref/Gamma"], "GammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/GammaRegularized"], "HankelH1" :> 
          Documentation`HelpLookup["paclet:ref/HankelH1"], "HankelH2" :> 
          Documentation`HelpLookup["paclet:ref/HankelH2"], 
          "Hypergeometric0F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric0F1"], 
          "Hypergeometric0F1Regularized" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric0F1Regularized"],
           "Hypergeometric1F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1"], 
          "Hypergeometric1F1Regularized" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1Regularized"],
           "Hypergeometric2F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric2F1"], 
          "Hypergeometric2F1Regularized" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric2F1Regularized"],
           "HypergeometricPFQ" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricPFQ"], 
          "HypergeometricPFQRegularized" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricPFQRegularized"],
           "HypergeometricU" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricU"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"], "InverseBetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseBetaRegularized"], 
          "InverseErf" :> Documentation`HelpLookup["paclet:ref/InverseErf"], 
          "InverseErfc" :> Documentation`HelpLookup["paclet:ref/InverseErfc"],
           "InverseGammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseGammaRegularized"], 
          "KelvinBei" :> Documentation`HelpLookup["paclet:ref/KelvinBei"], 
          "KelvinBer" :> Documentation`HelpLookup["paclet:ref/KelvinBer"], 
          "KelvinKei" :> Documentation`HelpLookup["paclet:ref/KelvinKei"], 
          "KelvinKer" :> Documentation`HelpLookup["paclet:ref/KelvinKer"], 
          "LegendreP" :> Documentation`HelpLookup["paclet:ref/LegendreP"], 
          "LegendreQ" :> Documentation`HelpLookup["paclet:ref/LegendreQ"], 
          "LerchPhi" :> Documentation`HelpLookup["paclet:ref/LerchPhi"], 
          "LogIntegral" :> Documentation`HelpLookup["paclet:ref/LogIntegral"],
           "MeijerG" :> Documentation`HelpLookup["paclet:ref/MeijerG"], 
          "ParabolicCylinderD" :> 
          Documentation`HelpLookup["paclet:ref/ParabolicCylinderD"], 
          "Pochhammer" :> Documentation`HelpLookup["paclet:ref/Pochhammer"], 
          "PolyGamma" :> Documentation`HelpLookup["paclet:ref/PolyGamma"], 
          "PolyLog" :> Documentation`HelpLookup["paclet:ref/PolyLog"], 
          "ProductLog" :> Documentation`HelpLookup["paclet:ref/ProductLog"], 
          "RamanujanTau" :> 
          Documentation`HelpLookup["paclet:ref/RamanujanTau"], 
          "RamanujanTauL" :> 
          Documentation`HelpLookup["paclet:ref/RamanujanTauL"], 
          "RamanujanTauTheta" :> 
          Documentation`HelpLookup["paclet:ref/RamanujanTauTheta"], 
          "RamanujanTauZ" :> 
          Documentation`HelpLookup["paclet:ref/RamanujanTauZ"], 
          "RiemannSiegelTheta" :> 
          Documentation`HelpLookup["paclet:ref/RiemannSiegelTheta"], 
          "RiemannSiegelZ" :> 
          Documentation`HelpLookup["paclet:ref/RiemannSiegelZ"], 
          "SinhIntegral" :> 
          Documentation`HelpLookup["paclet:ref/SinhIntegral"], "SinIntegral" :> 
          Documentation`HelpLookup["paclet:ref/SinIntegral"], 
          "SphericalBesselJ" :> 
          Documentation`HelpLookup["paclet:ref/SphericalBesselJ"], 
          "SphericalBesselY" :> 
          Documentation`HelpLookup["paclet:ref/SphericalBesselY"], 
          "SphericalHankelH1" :> 
          Documentation`HelpLookup["paclet:ref/SphericalHankelH1"], 
          "SphericalHankelH2" :> 
          Documentation`HelpLookup["paclet:ref/SphericalHankelH2"], 
          "StieltjesGamma" :> 
          Documentation`HelpLookup["paclet:ref/StieltjesGamma"], "StruveH" :> 
          Documentation`HelpLookup["paclet:ref/StruveH"], "StruveL" :> 
          Documentation`HelpLookup["paclet:ref/StruveL"], "WhittakerM" :> 
          Documentation`HelpLookup["paclet:ref/WhittakerM"], "WhittakerW" :> 
          Documentation`HelpLookup["paclet:ref/WhittakerW"], "Zeta" :> 
          Documentation`HelpLookup["paclet:ref/Zeta"], "ZetaZero" :> 
          Documentation`HelpLookup["paclet:ref/ZetaZero"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AiryAi\"\>", 
       2->"\<\"AiryAiPrime\"\>", 3->"\<\"AiryAiZero\"\>", 4->"\<\"AiryBi\"\>",
        5->"\<\"AiryBiPrime\"\>", 6->"\<\"AiryBiZero\"\>", 
       7->"\<\"AppellF1\"\>", 8->"\<\"BesselI\"\>", 9->"\<\"BesselJ\"\>", 
       10->"\<\"BesselJZero\"\>", 11->"\<\"BesselK\"\>", 
       12->"\<\"BesselY\"\>", 13->"\<\"BesselYZero\"\>", 14->"\<\"Beta\"\>", 
       15->"\<\"BetaRegularized\"\>", 16->"\<\"C\"\>", 
       17->"\<\"CoshIntegral\"\>", 18->"\<\"CosIntegral\"\>", 19->"\<\"E\"\>",
        20->"\<\"Erf\"\>", 21->"\<\"Erfc\"\>", 22->"\<\"Erfi\"\>", 
       23->"\<\"ExpIntegralE\"\>", 24->"\<\"ExpIntegralEi\"\>", 
       25->"\<\"FresnelC\"\>", 26->"\<\"FresnelS\"\>", 27->"\<\"Gamma\"\>", 
       28->"\<\"GammaRegularized\"\>", 29->"\<\"HankelH1\"\>", 
       30->"\<\"HankelH2\"\>", 31->"\<\"Hypergeometric0F1\"\>", 
       32->"\<\"Hypergeometric0F1Regularized\"\>", 
       33->"\<\"Hypergeometric1F1\"\>", 
       34->"\<\"Hypergeometric1F1Regularized\"\>", 
       35->"\<\"Hypergeometric2F1\"\>", 
       36->"\<\"Hypergeometric2F1Regularized\"\>", 
       37->"\<\"HypergeometricPFQ\"\>", 
       38->"\<\"HypergeometricPFQRegularized\"\>", 
       39->"\<\"HypergeometricU\"\>", 40->"\<\"I\"\>", 
       41->"\<\"InverseBetaRegularized\"\>", 42->"\<\"InverseErf\"\>", 
       43->"\<\"InverseErfc\"\>", 44->"\<\"InverseGammaRegularized\"\>", 
       45->"\<\"KelvinBei\"\>", 46->"\<\"KelvinBer\"\>", 
       47->"\<\"KelvinKei\"\>", 48->"\<\"KelvinKer\"\>", 
       49->"\<\"LegendreP\"\>", 50->"\<\"LegendreQ\"\>", 
       51->"\<\"LerchPhi\"\>", 52->"\<\"LogIntegral\"\>", 
       53->"\<\"MeijerG\"\>", 54->"\<\"ParabolicCylinderD\"\>", 
       55->"\<\"Pochhammer\"\>", 56->"\<\"PolyGamma\"\>", 
       57->"\<\"PolyLog\"\>", 58->"\<\"ProductLog\"\>", 
       59->"\<\"RamanujanTau\"\>", 60->"\<\"RamanujanTauL\"\>", 
       61->"\<\"RamanujanTauTheta\"\>", 62->"\<\"RamanujanTauZ\"\>", 
       63->"\<\"RiemannSiegelTheta\"\>", 64->"\<\"RiemannSiegelZ\"\>", 
       65->"\<\"SinhIntegral\"\>", 66->"\<\"SinIntegral\"\>", 
       67->"\<\"SphericalBesselJ\"\>", 68->"\<\"SphericalBesselY\"\>", 
       69->"\<\"SphericalHankelH1\"\>", 70->"\<\"SphericalHankelH2\"\>", 
       71->"\<\"StieltjesGamma\"\>", 72->"\<\"StruveH\"\>", 
       73->"\<\"StruveL\"\>", 74->"\<\"WhittakerM\"\>", 
       75->"\<\"WhittakerW\"\>", 76->"\<\"Zeta\"\>", 
       77->"\<\"ZetaZero\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Special Functions", "Title",
 CellTags->{"S3.2.11", "11.1"},
 CellID->21909],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " includes all the common special functions of mathematical physics found in \
standard handbooks. We will discuss each of the various classes of functions \
in turn."
}], "Text",
 CellID->27841],

Cell[TextData[{
 "One point you should realize is that in the technical literature there are \
often several conflicting definitions of any particular special function. \
When you use a special function in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", therefore, you should be sure to look at the definition given here to \
confirm that it is exactly what you want. "
}], "Text",
 CellID->20130],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives exact results for some values of special functions. "
}], "MathCaption",
 CellID->9090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"15", "/", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->9034],

Cell[BoxData[
 FractionBox[
  RowBox[{"135135", " ", 
   SqrtBox["\[Pi]"]}], "128"]], "Output",
 ImageSize->{81, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->7915]
}, Open  ]],

Cell["No exact result is known here. ", "MathCaption",
 CellID->6286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"15", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->3523],

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  FractionBox["15", "7"], "]"}]], "Output",
 ImageSize->{72, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->20666]
}, Open  ]],

Cell["\<\
A numerical result, to arbitrary precision, can nevertheless be found. \
\>", "MathCaption",
 CellID->1344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "40"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->32736],

Cell[BoxData["1.0690715004486243979941376897026932673667159489615910120821`40.\
"], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->22037]
}, Open  ]],

Cell["You can give complex arguments to special functions. ", "MathCaption",
 CellID->5416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{"3", "+", 
    RowBox[{"4", "I"}]}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->5893],

Cell[BoxData[
 RowBox[{"0.005225538471369119`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.17254707929430008`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->1949]
}, Open  ]],

Cell["\<\
Special functions automatically get applied to each element in a list. \
\>", "MathCaption",
 CellID->30971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"3", "/", "2"}], ",", 
    RowBox[{"5", "/", "2"}], ",", 
    RowBox[{"7", "/", "2"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->10844],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox["\[Pi]"], "2"], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     SqrtBox["\[Pi]"]}], "4"], ",", 
   FractionBox[
    RowBox[{"15", " ", 
     SqrtBox["\[Pi]"]}], "8"]}], "}"}]], "Output",
 ImageSize->{155, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->22777]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows analytical properties of special functions, such as derivatives. "
}], "MathCaption",
 CellID->19285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->26200],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"PolyGamma", "[", 
     RowBox[{"0", ",", "x"}], "]"}], "2"]}], "+", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"1", ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->14590]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to find roots of special functions. "
}], "MathCaption",
 CellID->10285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->28325],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "2.404825557695773`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->17118]
}, Open  ]],

Cell[TextData[{
 "Special functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can usually be evaluated for arbitrary complex values of their arguments. \
Often, however, the defining relations given below apply only for some \
special choices of arguments. In these cases, the full function corresponds \
to a suitable extension or \[OpenCurlyDoubleQuote]analytic continuation\
\[CloseCurlyDoubleQuote] of these defining relations. Thus, for example, \
integral representations of functions are valid only when the integral \
exists, but the functions themselves can usually be defined elsewhere by \
analytic continuation. "
}], "Text",
 CellID->25668],

Cell[TextData[{
 "As a simple example of how the domain of a function can be extended, \
consider the function represented by the sum ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    SuperscriptBox["x", "k"]}], TraditionalForm]], "InlineMath"],
 ". This sum converges only when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[VerticalSeparator]", "x", "\[VerticalSeparator]", "<", "1"}], 
   TraditionalForm]], "InlineMath"],
 ". Nevertheless, it is easy to show analytically that for any ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", the complete function is equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". Using this form, you can easily find a value of the function for any ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", at least so long as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[NotEqual]", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->10006],

Cell[CellGroupData[{

Cell["Gamma and Related Functions", "Section",
 CellID->9729],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Beta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Beta"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "Euler beta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalBeta]", "(", 
        RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Beta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Beta"], "[", 
     StyleBox["z", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "incomplete beta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[CapitalBeta]", "z"], "(", 
        RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BetaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BetaRegularized"], "[", 
     StyleBox["z", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "regularized incomplete beta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"I", "(", 
        RowBox[{"z", ",", "a", ",", "b"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "Euler gamma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "incomplete gamma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalGamma]", "(", 
        RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     StyleBox["a", "TI"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "1"], "]"}], Cell[TextData[{
     "generalized incomplete gamma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"a", ",", 
          SubscriptBox["z", "0"]}], ")"}], "-", 
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"a", ",", 
          SubscriptBox["z", "1"]}], ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GammaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GammaRegularized"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "regularized incomplete gamma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Q", "(", 
        RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseBetaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseBetaRegularized"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["inverse beta function", "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseGammaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseGammaRegularized"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[
    "inverse gamma function", "TableText"]},
   {
    RowBox[{
     ButtonBox["Pochhammer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pochhammer"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Pochhammer symbol ",
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        RowBox[{"(", "a", ")"}], "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolyGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyGamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "digamma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Psi]", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolyGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyGamma"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " derivative of the digamma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["\[Psi]", 
         RowBox[{"(", "n", ")"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24008],

Cell["Gamma and related functions.", "Caption",
 CellID->14541],

Cell[TextData[{
 "The ",
 StyleBox["Euler gamma function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is defined by the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalGamma]", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      SuperscriptBox["t", 
       RowBox[{"z", "-", "1"}]], 
      SuperscriptBox["e", 
       RowBox[{"-", "t"}]], "d", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". For positive integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalGamma]", "(", "n", ")"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}], 
     RowBox[{"!", " "}]}]}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " can be viewed as a generalization of the factorial function, valid for \
complex arguments ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->225],

Cell[TextData[{
 "There are some computations, particularly in number theory, where the \
logarithm of the gamma function often appears. For positive real arguments, \
you can evaluate this simply as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{
    ButtonBox["Gamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Gamma"], "[", 
    StyleBox["z", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". For complex arguments, however, this form yields spurious \
discontinuities. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " therefore includes the separate function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogGamma"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ", which yields the ",
 StyleBox["logarithm of the gamma function", "TB"],
 " with a single branch cut along the negative real axis."
}], "Text",
 CellID->15536],

Cell[TextData[{
 "The ",
 StyleBox["Euler beta function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Beta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beta"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalBeta]", "(", 
     RowBox[{"a", ",", "b"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[CapitalGamma]", "(", "a", ")"}], 
      RowBox[{
       RowBox[{"\[CapitalGamma]", "(", "b", ")"}], "/", 
       RowBox[{"\[CapitalGamma]", "(", 
        RowBox[{"a", "+", "b"}], ")"}]}]}], "=", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{
       SuperscriptBox["t", 
        RowBox[{"a", "-", "1"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "t"}], ")"}], 
        RowBox[{"b", "-", "1"}]], "d", "t"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->11980],

Cell[TextData[{
 "The ",
 StyleBox["Pochhammer symbol", "TB"],
 " or ",
 StyleBox["rising factorial", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pochhammer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pochhammer"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     RowBox[{"(", "a", ")"}], "n"], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "(", 
       RowBox[{"a", "+", "1"}], ")"}], 
      RowBox[{"\[Ellipsis]", "(", 
       RowBox[{"a", "+", "n", "-", "1"}], ")"}]}], "=", 
     RowBox[{
      RowBox[{"\[CapitalGamma]", "(", 
       RowBox[{"a", "+", "n"}], ")"}], "/", 
      RowBox[{"\[CapitalGamma]", "(", "a", ")"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". It often appears in series expansions for hypergeometric functions. Note \
that the Pochhammer symbol has a definite value even when the gamma functions \
which appear in its definition are infinite."
}], "Text",
 CellID->716],

Cell[TextData[{
 "The ",
 StyleBox["incomplete gamma function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is defined by the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalGamma]", "(", 
     RowBox[{"a", ",", "z"}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "z", "\[Infinity]"], 
     RowBox[{
      SuperscriptBox["t", 
       RowBox[{"a", "-", "1"}]], 
      SuperscriptBox["e", 
       RowBox[{"-", "t"}]], "d", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " includes a generalized incomplete gamma function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["1", "TR"]]}], "]"}]], "InlineFormula"],
 " defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     SubscriptBox["z", "0"], 
     SubscriptBox["z", "1"]], 
    SuperscriptBox["t", 
     RowBox[{"a", "-", "1"}]], 
    SuperscriptBox["e", 
     RowBox[{"-", "t"}]], "d", "t"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->30470],

Cell[TextData[{
 "The alternative incomplete gamma function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", "(", 
    RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"],
 " can therefore be obtained in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", "0", ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15384],

Cell[TextData[{
 "The ",
 StyleBox["incomplete beta function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Beta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beta"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalBeta]", "z"], "(", 
     RowBox[{"a", ",", "b"}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      SuperscriptBox["t", 
       RowBox[{"a", "-", "1"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], 
       RowBox[{"b", "-", "1"}]], "d", "t"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". Notice that in the incomplete beta function, the parameter ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " is an ",
 StyleBox["upper",
  FontSlant->"Italic"],
 " limit of integration, and appears as the ",
 StyleBox["first",
  FontSlant->"Italic"],
 " argument of the function. In the incomplete gamma function, on the other \
hand, ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " is a ",
 StyleBox["lower",
  FontSlant->"Italic"],
 " limit of integration, and appears as the ",
 StyleBox["second",
  FontSlant->"Italic"],
 " argument of the function."
}], "Text",
 CellID->28747],

Cell[TextData[{
 "In certain cases, it is convenient not to compute the incomplete beta and \
gamma functions on their own, but instead to compute ",
 StyleBox["regularized forms",
  FontSlant->"Italic"],
 " in which these functions are divided by complete beta and gamma functions. \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " includes the ",
 StyleBox["regularized incomplete beta function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaRegularized"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " defined for most arguments by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"I", "(", 
     RowBox[{"z", ",", "a", ",", "b"}], ")"}], "=", 
    RowBox[{
     RowBox[{"\[CapitalBeta]", "(", 
      RowBox[{"z", ",", "a", ",", "b"}], ")"}], "/", 
     RowBox[{"\[CapitalBeta]", "(", 
      RowBox[{"a", ",", "b"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", but taking into account singular cases. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also includes the ",
 StyleBox["regularized incomplete gamma function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaRegularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Q", "(", 
     RowBox[{"a", ",", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"\[CapitalGamma]", "(", 
      RowBox[{"a", ",", "z"}], ")"}], "/", 
     RowBox[{"\[CapitalGamma]", "(", "a", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", with singular cases taken into account. "
}], "Text",
 CellID->20328],

Cell[TextData[{
 "The incomplete beta and gamma functions, and their inverses, are common in \
statistics. The ",
 StyleBox["inverse beta function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseBetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseBetaRegularized"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is the solution for ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{"I", "(", 
     RowBox[{"z", ",", "a", ",", "b"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". The ",
 StyleBox["inverse gamma function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseGammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGammaRegularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
 " is similarly the solution for ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{"Q", "(", 
     RowBox[{"a", ",", "z"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->27936],

Cell[TextData[{
 "Derivatives of the gamma function often appear in summing rational series. \
The ",
 StyleBox["digamma function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is the logarithmic derivative of the gamma function, given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Psi]", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[CapitalGamma]", "\[Prime]"], "(", "z", ")"}], "/", 
     RowBox[{"\[CapitalGamma]", "(", "z", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". For integer arguments, the digamma function satisfies the relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Psi]", "(", "n", ")"}], "=", 
    RowBox[{
     RowBox[{"-", "\[Gamma]"}], "+", 
     SubscriptBox["H", 
      RowBox[{"n", "-", "1"}]]}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineMath"],
 " is Euler\[CloseCurlyQuote]s constant (",
 Cell[BoxData[
  ButtonBox["EulerGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerGamma"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ") and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["H", "n"], TraditionalForm]], "InlineMath"],
 " are the harmonic numbers."
}], "Text",
 CellID->6204],

Cell[TextData[{
 "The ",
 StyleBox["polygamma functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Psi]", 
      RowBox[{"(", "n", ")"}]], "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox["d", "n"], 
     RowBox[{
      RowBox[{"\[Psi]", "(", "z", ")"}], "/", 
      RowBox[{"d", 
       SuperscriptBox["z", "n"]}]}]}]}], TraditionalForm]], "InlineMath"],
 ". Notice that the digamma function corresponds to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Psi]", 
     RowBox[{"(", "0", ")"}]], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". The general form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Psi]", 
     RowBox[{"(", "n", ")"}]], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 ", not the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 ", logarithmic derivative of the gamma function. The polygamma functions \
satisfy the relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Psi]", 
      RowBox[{"(", "n", ")"}]], "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"n", "!"}], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "0"}], "\[Infinity]",
       LimitsPositioning->True], 
      RowBox[{"1", "/", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "+", "k"}], ")"}], 
        RowBox[{"n", "+", "1"}]]}]}]}]}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is defined for arbitrary complex ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 " by fractional calculus analytic continuation."
}], "Text",
 CellID->10700],

Cell[TextData[{
 "Many exact results for gamma and polygamma functions are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->7523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyGamma", "[", "6", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->26364],

Cell[BoxData[
 RowBox[{
  FractionBox["137", "60"], "-", "EulerGamma"}]], "Output",
 ImageSize->{112, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->1411]
}, Open  ]],

Cell["\<\
Here is a contour plot of the gamma function in the complex plane. \
\>", "MathCaption",
 CellID->16040],

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Gamma", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->250]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zeta and Related Functions", "Section",
 CellID->11504],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LerchPhi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LerchPhi"], "[", 
     StyleBox["z", "TI"], ",", 
     StyleBox["s", "TI"], ",", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "Lerch\[CloseCurlyQuote]s transcendent ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalPhi]", "(", 
        RowBox[{"z", ",", "s", ",", "a"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolyLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyLog"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "polylogarithm function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["Li", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolyLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyLog"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["p", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "Nielsen generalized polylogarithm function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["S", 
         RowBox[{"n", ",", "p"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RamanujanTau",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RamanujanTau"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Ramanujan \[Tau] function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Tau]", 
        RowBox[{"(", "n", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RamanujanTauL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RamanujanTauL"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Ramanujan \[Tau] Dirichlet L-function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"L", 
        RowBox[{"(", "s", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RamanujanTauTheta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RamanujanTauTheta"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Ramanujan \[Tau] theta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Theta]", 
        RowBox[{"(", "t", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RamanujanTauZ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RamanujanTauZ"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Ramanujan \[Tau] Z function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Z", 
        RowBox[{"(", "t", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RiemannSiegelTheta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RiemannSiegelTheta"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "Riemann\[Hyphen]Siegel function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CurlyTheta]", "(", "t", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RiemannSiegelZ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RiemannSiegelZ"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "Riemann\[Hyphen]Siegel function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Z", "(", "t", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StieltjesGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StieltjesGamma"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "Stieltjes constants ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["\[Gamma]", "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Zeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Zeta"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "Riemann zeta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Zeta]", "(", "s", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Zeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Zeta"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "generalized Riemann zeta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Zeta]", "(", 
        RowBox[{"s", ",", "a"}], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->23483],

Cell["Zeta and related functions. ", "Caption",
 CellID->21766],

Cell[TextData[{
 "The ",
 StyleBox["Riemann zeta function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is defined by the relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Zeta]", 
    RowBox[{"(", "s", ")"}], "=", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "\[Infinity]",
     LimitsPositioning->True], 
    SuperscriptBox["k", 
     RowBox[{"-", "s"}]]}], TraditionalForm]], "InlineMath"],
 " (for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", ">", "1"}], TraditionalForm]], "InlineMath"],
 "). Zeta functions with integer arguments arise in evaluating various sums \
and integrals. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives exact results when possible for zeta functions with integer \
arguments."
}], "Text",
 CellID->16141],

Cell[TextData[{
 "There is an analytic continuation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Zeta]", "(", "s", ")"}], TraditionalForm]], "InlineMath"],
 " for arbitrary complex ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "\[NotEqual]", "1"}], TraditionalForm]], "InlineMath"],
 ". The zeta function for complex arguments is central to \
number\[Hyphen]theoretical studies of the distribution of primes. Of \
particular importance are the values on the critical line ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Re", " ", "s", "=", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->2670],

Cell[TextData[{
 "In studying ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Zeta]", "(", 
    RowBox[{
     FractionBox["1", "2"], "+", 
     RowBox[{"i", "t"}]}], ")"}], TraditionalForm]], "InlineMath"],
 ", it is often convenient to define the two ",
 StyleBox["Riemann\[Hyphen]Siegel functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RiemannSiegelZ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RiemannSiegelZ"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RiemannSiegelTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RiemannSiegelTheta"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " according to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Z", "(", "t", ")"}], "=", 
    RowBox[{
     SuperscriptBox["e", 
      RowBox[{"i", "\[CurlyTheta]", 
       RowBox[{"(", "t", ")"}]}]], 
     RowBox[{"\[Zeta]", "(", 
      RowBox[{
       FractionBox["1", "2"], "+", "i", "t"}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CurlyTheta]", "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"Im", " ", "log", 
      RowBox[{"\[CapitalGamma]", "(", 
       RowBox[{
        FractionBox["1", "4"], "+", "i", "t", "/", "2"}], ")"}]}], "-", 
     RowBox[{"t", " ", 
      RowBox[{
       RowBox[{"log", "(", "\[Pi]", ")"}], "/", "2"}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 " (for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " real). Note that the Riemann\[Hyphen]Siegel functions are both real as \
long as ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " is real. "
}], "Text",
 CellID->10845],

Cell[TextData[{
 "The ",
 StyleBox["Stieltjes constants", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StieltjesGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StieltjesGamma"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " are generalizations of Euler\[CloseCurlyQuote]s constant which appear in \
the series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Zeta]", "(", "s", ")"}], TraditionalForm]], "InlineMath"],
 " around its pole at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", "1"}], TraditionalForm]], "InlineMath"],
 "; the coefficient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "s"}], ")"}], "n"], TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Gamma]", "n"], "/", "n"}], 
    RowBox[{"!", " "}]}], TraditionalForm]], "InlineMath"],
 ". Euler\[CloseCurlyQuote]s constant is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Gamma]", "0"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->10506],

Cell[TextData[{
 "The ",
 StyleBox["generalized Riemann zeta function", "TB"],
 " or ",
 StyleBox["Hurwitz zeta function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " is implemented as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Zeta]", "(", 
     RowBox[{"s", ",", "a"}], ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"k", "+", "a"}], ")"}], "2"], ")"}], 
      RowBox[{
       RowBox[{"-", "s"}], "/", "2"}]]}]}], TraditionalForm]], "InlineMath"],
 ", where any term with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "+", "a", "=", "0"}], TraditionalForm]], "InlineMath"],
 " is excluded."
}], "Text",
 CellID->9088],

Cell[TextData[{
 "The Ramanujan \[Tau] Dirichlet L function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RamanujanTauL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RamanujanTauL"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     ButtonBox["L",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RamanujanTauL"], 
     RowBox[{"(", "s", ")"}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "1"}], "\[Infinity]"], 
     FractionBox[
      RowBox[{"\[Tau]", "(", "n", ")"}], 
      SuperscriptBox["n", "s"]]}]}], TraditionalForm]], "InlineMath"],
 " (for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     ButtonBox["Re",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Re"], 
     RowBox[{"(", "s", ")"}]}], ">", "6"}], TraditionalForm]], "InlineMath"],
 "), with coefficients ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RamanujanTau",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RamanujanTau"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". In analogy with the ",
 StyleBox["Riemann zeta function", "TB"],
 ", it is again convenient to define the functions ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RamanujanTauZ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RamanujanTauZ"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RamanujanTauTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RamanujanTauTheta"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->67327082],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives exact results for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Zeta]", 
    RowBox[{"(", 
     RowBox[{"2", "n"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->23256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zeta", "[", "6", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->25107],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "6"], "945"]], "Output",
 ImageSize->{30, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->8266]
}, Open  ]],

Cell["\<\
Here is a three\[Hyphen]dimensional picture of the Riemann zeta function in \
the complex plane. \
\>", "MathCaption",
 CellID->5857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Zeta", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "2", ",", "35"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->29683575],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->694014210]
}, Open  ]],

Cell[TextData[{
 "This is a plot of the absolute value of the Riemann zeta function on the \
critical line ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Re", " ", "z", "=", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath"],
 ". You can see the first few zeros of the zeta function. "
}], "MathCaption",
 CellID->12674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Zeta", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->545637444],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->375399153]
}, Open  ]],

Cell[TextData[{
 "This is a plot of the absolute value of the Ramanujan \[Tau] L function on \
its critical line ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Re", " ", "z"}], "=", "6"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->336838548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"RamanujanTauL", "[", 
     RowBox[{"6", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->400115892],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->112728935]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["polylogarithm functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyLog"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Li", "n"], "(", "z", ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SuperscriptBox["z", "k"], "/", 
      SuperscriptBox["k", "n"]}]}]}], TraditionalForm]], "InlineMath"],
 ". The polylogarithm function is sometimes known as ",
 StyleBox["Jonqui\[EGrave]re\[CloseCurlyQuote]s function", "TB"],
 ". The ",
 StyleBox["dilogarithm", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyLog"], "[", 
   RowBox[{"2", ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Li", "2"], "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "z", "0"], 
     RowBox[{
      RowBox[{
       RowBox[{"log", "(", 
        RowBox[{"1", "-", "t"}], ")"}], "/", "t"}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". Sometimes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Li", "2"], "(", 
    RowBox[{"1", "-", "z"}], ")"}], TraditionalForm]], "InlineMath"],
 " is known as ",
 StyleBox["Spence\[CloseCurlyQuote]s integral", "TB"],
 ". The ",
 StyleBox["Nielsen generalized polylogarithm functions", "TB"],
 " or ",
 StyleBox["hyperlogarithms", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolyLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyLog"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["p", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["S", 
      RowBox[{"n", ",", "p"}]], "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"n", "+", "p", "-", "1"}]], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "!", "p", "!"}], ")"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "1"], 
      RowBox[{
       RowBox[{
        SuperscriptBox["log", 
         RowBox[{"n", "-", "1"}]], "(", "t", ")"}], 
       RowBox[{
        RowBox[{
         SuperscriptBox["log", "p"], "(", 
         RowBox[{"1", "-", 
          RowBox[{"z", "\[InvisibleSpace]", "t"}]}], ")"}], "/", "t"}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". Polylogarithm functions appear in Feynman diagram integrals in elementary \
particle physics, as well as in algebraic K\[Hyphen]theory."
}], "Text",
 CellID->8990],

Cell[TextData[{
 "The ",
 StyleBox["Lerch transcendent", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LerchPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LerchPhi"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " is a generalization of the zeta and polylogarithm functions, given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{"z", ",", "s", ",", "a"}], ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SuperscriptBox["z", "k"], "/", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", "k"}], ")"}], 
         RowBox[{"s", "/", "2"}]], ")"}], "2"]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where any term with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "+", "k", "=", "0"}], TraditionalForm]], "InlineMath"],
 " is excluded. Many sums of reciprocal powers can be expressed in terms of \
the Lerch transcendent. For example, the ",
 StyleBox["Catalan beta function", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Beta]", "(", "s", ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "k"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "k"}], "+", "1"}], ")"}], 
       RowBox[{"-", "s"}]]}]}]}], TraditionalForm]], "InlineMath"],
 " can be obtained as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"-", "s"}]], "\[CapitalPhi]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "s", ",", 
      FractionBox["1", "2"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->29832],

Cell[TextData[{
 "The Lerch transcendent is related to integrals of the ",
 StyleBox["Fermi\[Hyphen]Dirac", "TB"],
 " distribution in statistical mechanics by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
     RowBox[{
      SuperscriptBox["k", "s"], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["e", 
          RowBox[{"k", "-", "\[Mu]"}]], "+", "1"}], ")"}], 
       RowBox[{"\[DifferentialD]", "k"}]}]}]}], "=", 
    RowBox[{
     SuperscriptBox["e", "\[Mu]"], 
     RowBox[{"\[CapitalGamma]", "(", 
      RowBox[{"s", "+", "1"}], ")"}], 
     RowBox[{"\[CapitalPhi]", "(", 
      RowBox[{"-", 
       SuperscriptBox["e", "\[Mu]"], ",", "s", "+", "1", ",", "1"}], 
      ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->30858],

Cell[TextData[{
 "The Lerch transcendent can also be used to evaluate ",
 StyleBox["Dirichlet ", "TB"],
 StyleBox["L", "TBI"],
 StyleBox["\[Hyphen]series", "TB"],
 " which appear in number theory. The basic ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 "\[Hyphen]series has the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"L", "(", 
     RowBox[{"s", ",", "\[Chi]"}], ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{"\[Chi]", "(", "k", ")"}], 
      SuperscriptBox["k", 
       RowBox[{"-", "s"}]]}]}]}], TraditionalForm]], "InlineMath"],
 ", where the \[OpenCurlyDoubleQuote]character\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Chi]", "(", "k", ")"}], TraditionalForm]], "InlineMath"],
 " is an integer function with period ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  FormBox["L", TraditionalForm]], "InlineMath"],
 "\[Hyphen]series of this kind can be written as sums of Lerch functions with \
",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " a power of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    RowBox[{"2", "\[Pi]", "i", "/", "m"}]], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->10996],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LerchPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LerchPhi"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    RowBox[{"DoublyInfinite", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " gives the doubly infinite sum ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "-", "\[Infinity]"}], "\[Infinity]",
     LimitsPositioning->True], 
    RowBox[{
     SuperscriptBox["z", "k"], "/", 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", "k"}], ")"}], 
        RowBox[{"s", "/", "2"}]], ")"}], "2"]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->8917],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ZetaZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZetaZero"], "[", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero of the zeta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Zeta]", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     " on the critical line"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ZetaZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZetaZero"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]}], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero above height ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->395097913],

Cell["Zeros of the zeta function. ", "Caption",
 CellID->155827115],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ZetaZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZetaZero"], "[", "1", "]"}]], "InlineFormula"],
 " represents the first nontrivial zero of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Zeta]", " ", 
    RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->20883269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zeta", "[", 
  RowBox[{"ZetaZero", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7518628],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158943822]
}, Open  ]],

Cell["This gives its numerical value.", "MathCaption",
 CellID->539987862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"ZetaZero", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106173321],

Cell[BoxData[
 RowBox[{"0.5`", "\[InvisibleSpace]", "+", 
  RowBox[{"14.134725141734695`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->174189602]
}, Open  ]],

Cell["This gives the first zero with height greater than 15.", "MathCaption",
 CellID->10904015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"ZetaZero", "[", 
   RowBox[{"1", ",", "15"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->473886493],

Cell[BoxData[
 RowBox[{"0.5`", "\[InvisibleSpace]", "+", 
  RowBox[{"21.022039638771556`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->677447989]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential Integral and Related Functions", "Section",
 CellID->28290],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CosIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CosIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "cosine integral function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Ci", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CoshIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CoshIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "hyperbolic cosine integral function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Chi", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpIntegralE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpIntegralE"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "exponential integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox[
         ButtonBox["E",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/E"], "n"], 
        RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpIntegralEi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpIntegralEi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "exponential integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Ei", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LogIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "logarithmic integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"li", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SinIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SinIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "sine integral function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Si", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SinhIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SinhIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "hyperbolic sine integral function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Shi", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3967],

Cell["Exponential integral and related functions. ", "Caption",
 CellID->1707],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has two forms of exponential integral: ",
 Cell[BoxData[
  ButtonBox["ExpIntegralE",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 "."
}], "Text",
 CellID->8234],

Cell[TextData[{
 "The ",
 StyleBox["exponential integral function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExpIntegralE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralE"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["E", "n"], "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "1", "\[Infinity]"], 
     RowBox[{
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{"-", "z", "t"}]], "/", 
       SuperscriptBox["t", "n"]}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->28246],

Cell[TextData[{
 "The second ",
 StyleBox["exponential integral function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExpIntegralEi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralEi"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Ei", "(", "z", ")"}], "=", 
    RowBox[{"-", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"-", "z"}], "\[Infinity]"], 
      RowBox[{
       RowBox[{
        SuperscriptBox["e", 
         RowBox[{"-", "t"}]], "/", "t"}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 " (for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", ">", "0"}], TraditionalForm]], "InlineMath"],
 "), where the principal value of the integral is taken. "
}], "Text",
 CellID->11462],

Cell[TextData[{
 "The ",
 StyleBox["logarithmic integral function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"li", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      RowBox[{
       RowBox[{"d", "t"}], "/", "log"}], " ", "t"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " (for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", ">", "1"}], TraditionalForm]], "InlineMath"],
 "), where the principal value of the integral is taken. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"li", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " is central to the study of the distribution of primes in number theory. \
The logarithmic integral function is sometimes also denoted by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Li", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 ". In some number\[Hyphen]theoretical applications, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"li", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " is defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "2", "z"], 
    RowBox[{
     RowBox[{
      RowBox[{"d", "t"}], "/", "log"}], " ", "t"}]}], TraditionalForm]], 
  "InlineMath"],
 ", with no principal value taken. This differs from the definition used in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by the constant ",
 Cell[BoxData[
  FormBox[
   RowBox[{"li", "(", "2", ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->19402],

Cell[TextData[{
 "The ",
 StyleBox["sine and cosine integral functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SinIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SinIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CosIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CosIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " are defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Si", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      RowBox[{
       RowBox[{"sin", "(", "t", ")"}], "/", "t"}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Ci", "(", "z", ")"}], "=", 
    RowBox[{"-", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "z", "\[Infinity]"], 
      RowBox[{
       RowBox[{
        RowBox[{"cos", "(", "t", ")"}], "/", "t"}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". The ",
 StyleBox["hyperbolic sine and cosine integral functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SinhIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SinhIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoshIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoshIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " are defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Shi", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      RowBox[{
       RowBox[{"sinh", "(", "t", ")"}], "/", "t"}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Chi", "(", "z", ")"}], "=", 
    RowBox[{"\[Gamma]", "+", 
     RowBox[{"log", "(", "z", ")"}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "z"], 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"cosh", "(", "t", ")"}], "-", "1"}], ")"}], "/", "t"}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->8239]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error Function and Related Functions", "Section",
 CellID->3426],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Erf",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erf"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "error function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"erf", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Erf",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erf"], "[", 
     SubscriptBox[
      StyleBox["z", "TI"], "0"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "1"], "]"}], Cell[TextData[{
     "generalized error function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"erf", "(", 
         SubscriptBox["z", "1"], ")"}], "-", 
        RowBox[{"erf", "(", 
         SubscriptBox["z", "0"], ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Erfc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erfc"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "complementary error function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"erfc", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Erfi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erfi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "imaginary error function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"erfi", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FresnelC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FresnelC"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "Fresnel integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        ButtonBox["C",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/C"], 
        RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FresnelS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FresnelS"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "Fresnel integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"S", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseErf",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseErf"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[
    "inverse error function", "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseErfc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseErfc"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[
    "inverse complementary error function", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19095],

Cell["Error function and related functions. ", "Caption",
 CellID->30906],

Cell[TextData[{
 "The ",
 StyleBox["error function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is the integral of the Gaussian distribution, given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"erf", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"2", "/", 
      SqrtBox["\[Pi]"]}], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "z"], 
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{"-", 
         SuperscriptBox["t", "2"]}]], "d", "t"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". The ",
 StyleBox["complementary error function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Erfc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erfc"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is given simply by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"erfc", "(", "z", ")"}], "=", 
    RowBox[{"1", "-", 
     RowBox[{"erf", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". The ",
 StyleBox["imaginary error function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Erfi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erfi"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"erfi", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"erf", "(", 
      RowBox[{"i", "\[InvisibleSpace]", "z"}], ")"}], "/", "i"}]}], 
   TraditionalForm]], "InlineMath"],
 ". The generalized error function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["1", "TR"]]}], "]"}]], "InlineFormula"],
 " is defined by the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "/", 
    SqrtBox["\[Pi]"], 
    SubsuperscriptBox["\[Integral]", 
     SubscriptBox["z", "0"], 
     SubscriptBox["z", "1"]], 
    SuperscriptBox["e", 
     RowBox[{"-", 
      SuperscriptBox["t", "2"]}]], "d", "t"}], TraditionalForm]], 
  "InlineMath"],
 ". The error function is central to many calculations in statistics."
}], "Text",
 CellID->8314],

Cell[TextData[{
 "The ",
 StyleBox["inverse error function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseErf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErf"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is defined as the solution for ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " in the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{"erf", "(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 ". The inverse error function appears in computing confidence intervals in \
statistics as well as in some algorithms for generating Gaussian random \
numbers."
}], "Text",
 CellID->10350],

Cell[TextData[{
 "Closely related to the error function are the ",
 StyleBox["Fresnel integrals", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FresnelC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelC"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"C", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      RowBox[{"cos", "(", 
       RowBox[{"\[Pi]", 
        RowBox[{
         SuperscriptBox["t", "2"], "/", "2"}]}], ")"}], "d", "t"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FresnelS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelS"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"S", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      RowBox[{"sin", "(", 
       RowBox[{"\[Pi]", 
        RowBox[{
         SuperscriptBox["t", "2"], "/", "2"}]}], ")"}], "d", "t"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". Fresnel integrals occur in diffraction theory."
}], "Text",
 CellID->4586]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bessel and Related Functions", "Section",
 CellID->5279],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AiryAi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryAi"], "[", 
     StyleBox["z", "TI"], "]", Cell[
     "\[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["AiryBi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryBi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "Airy functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Ai", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Bi", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AiryAiPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryAiPrime"], "[", 
     StyleBox["z", "TI"], "]", Cell[
     "\[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["AiryBiPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryBiPrime"], "[", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "derivatives of Airy functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BesselJ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselJ"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     "\[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["BesselY",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselY"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "Bessel functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["J", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["Y", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BesselI",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselI"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     "\[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["BesselK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselK"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "modified Bessel functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox[
         ButtonBox["I",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/I"], "n"], 
        RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["K", "n"], 
        RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["KelvinBer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KelvinBer"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     " \[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["KelvinBei",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KelvinBei"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "Kelvin functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["ber", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["bei", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["KelvinKer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KelvinKer"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     " \[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["KelvinKei",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KelvinKei"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "Kelvin functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["ker", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["kei", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HankelH1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HankelH1"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     " \[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["HankelH2",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HankelH2"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "Hankel functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["H", "n", 
         RowBox[{"(", "1", ")"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["H", "n", 
         RowBox[{"(", "2", ")"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SphericalBesselJ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalBesselJ"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     " \[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["SphericalBesselY",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalBesselY"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "spherical Bessel functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["j", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["y", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SphericalHankelH1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalHankelH1"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     " \[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["SphericalHankelH2",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalHankelH2"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "spherical Hankel functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["h", "n", 
         RowBox[{"(", "1", ")"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["h", "n", 
         RowBox[{"(", "2", ")"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StruveH",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StruveH"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     "\[ThinSpace]and\[ThinSpace]", "TableText"], 
     ButtonBox["StruveL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StruveL"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "Struve function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox[
         StyleBox["H",
          FontWeight->"Bold"], "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and modified Struve function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox[
         StyleBox["L",
          FontWeight->"Bold"], "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17776],

Cell["Bessel and related functions. ", "Caption",
 CellID->25822],

Cell[TextData[{
 "The ",
 StyleBox["Bessel functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselY"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " are linearly independent solutions to the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "2"], 
    SuperscriptBox["y", "\[Prime]\[Prime]"], "+", "z", 
    SuperscriptBox["y", "\[Prime]"], "+", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["z", "2"], "-", 
      SuperscriptBox["n", "2"]}], ")"}], "y", "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 ". For integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " are regular at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", while the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " have a logarithmic divergence at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->6879],

Cell["\<\
Bessel functions arise in solving differential equations for systems with \
cylindrical symmetry.\
\>", "Text",
 CellID->32301],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is often called the ",
 StyleBox["Bessel function of the first kind", "TB"],
 ", or simply ",
 StyleBox["the",
  FontSlant->"Italic"],
 " Bessel function. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is referred to as the ",
 StyleBox["Bessel function of the second kind", "TB"],
 ", the ",
 StyleBox["Weber function", "TB"],
 ", or the ",
 StyleBox["Neumann function", "TB"],
 " (denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["N", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 ")."
}], "Text",
 CellID->15812],

Cell[TextData[{
 "The ",
 StyleBox["Hankel functions", "TB"],
 " (or ",
 StyleBox["Bessel functions of the third kind", "TB"],
 ") ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HankelH1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelH1"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HankelH2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelH2"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " give an alternative pair of solutions to the Bessel differential equation, \
related according to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["H", "n", 
      RowBox[{"(", 
       RowBox[{"1", ",", "2"}], ")"}]], "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["J", "n"], "(", "z", ")"}], "\[PlusMinus]", 
     RowBox[{"i", "\[InvisibleSpace]", 
      RowBox[{
       SubscriptBox["Y", "n"], "(", "z", ")"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->5676],

Cell[TextData[{
 "The ",
 StyleBox["spherical Bessel functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalBesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalBesselJ"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalBesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalBesselY"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ", as well as the ",
 StyleBox["spherical Hankel functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalHankelH1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHankelH1"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SphericalHankelH2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHankelH2"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ", arise in studying wave phenomena with spherical symmetry. These are \
related to the ordinary functions by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["f", "n"], "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{"\[Pi]", "/", "2"}]], "/", 
      SqrtBox["z"]}], 
     RowBox[{
      SubscriptBox["F", 
       RowBox[{"n", "+", 
        FractionBox["1", "2"]}]], "(", "z", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 " can be ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["J", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["Y", TraditionalForm]], "InlineMath"],
 ", or ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["h", "i"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["H", "i"], TraditionalForm]], "InlineMath"],
 ". For integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", spherical Bessel functions can be expanded in terms of elementary \
functions by using ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->3164],

Cell[TextData[{
 "The ",
 StyleBox["modified Bessel functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselI",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselI"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselK"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " are solutions to the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "2"], 
    SuperscriptBox["y", "\[Prime]\[Prime]"], "+", "z", 
    SuperscriptBox["y", "\[Prime]"], "-", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["z", "2"], "+", 
      SuperscriptBox["n", "2"]}], ")"}], "y", "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 ". For integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["I", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is regular at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath"],
 "; ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["K", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " always has a logarithmic divergence at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["I", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " are sometimes known as ",
 StyleBox["hyperbolic Bessel functions", "TB"],
 "."
}], "Text",
 CellID->7357],

Cell[TextData[{
 "Particularly in electrical engineering, one often defines the ",
 StyleBox["Kelvin functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["KelvinBer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KelvinBer"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["KelvinBei",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KelvinBei"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["KelvinKer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KelvinKer"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["KelvinKei",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KelvinKei"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". These are related to the ordinary Bessel functions by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["ber", "n"], "(", "z", ")"}], "+", 
     RowBox[{"i", " ", 
      RowBox[{
       SubscriptBox["bei", "n"], "(", "z", ")"}]}]}], "=", 
    RowBox[{
     SuperscriptBox["e", 
      RowBox[{"n", "\[Pi]", "i"}]], 
     RowBox[{
      SubscriptBox["J", "n"], "(", 
      RowBox[{"z", 
       SuperscriptBox["e", 
        RowBox[{"-", "\[Pi]", "i", "/", "4"}]]}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["ker", "n"], "(", "z", ")"}], "+", 
     RowBox[{"i", " ", 
      RowBox[{
       SubscriptBox["kei", "n"], "(", "z", ")"}]}]}], "=", 
    RowBox[{
     SuperscriptBox["e", 
      RowBox[{"-", "n", "\[Pi]", "i", "/", "2"}]], 
     RowBox[{
      SubscriptBox["K", "n"], "(", 
      RowBox[{"z", 
       SuperscriptBox["e", 
        RowBox[{"\[Pi]", "i", "/", "4"}]]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->32570],

Cell[TextData[{
 "The ",
 StyleBox["Airy functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AiryAi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryAi"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AiryBi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryBi"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " are the two independent solutions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Ai", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Bi", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " to the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "\[Prime]\[Prime]"], "-", "z", "y", "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Ai", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " tends to zero for large positive ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", while ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Bi", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " increases unboundedly. The Airy functions are related to modified Bessel \
functions with one\[Hyphen]third\[Hyphen]integer orders. The Airy functions \
often appear as the solutions to boundary value problems in electromagnetic \
theory and quantum mechanics. In many cases the ",
 StyleBox["derivatives of the Airy functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AiryAiPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryAiPrime"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AiryBiPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryBiPrime"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " also appear."
}], "Text",
 CellID->6038],

Cell[TextData[{
 "The ",
 StyleBox["Struve function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StruveH",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StruveH"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " appears in the solution of the inhomogeneous Bessel equation which for \
integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " has the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "2"], 
    SuperscriptBox["y", "\[Prime]\[Prime]"], "+", "z", 
    SuperscriptBox["y", "\[Prime]"], "+", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["z", "2"], "-", 
      SuperscriptBox["n", "2"]}], ")"}], "y", "=", 
    FractionBox["2", "\[Pi]"], 
    FractionBox[
     SuperscriptBox["z", 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "n", "-", "1"}], ")"}], "!!"}]]}], TraditionalForm]], 
  "InlineMath"],
 "; the general solution to this equation consists of a linear combination of \
Bessel functions with the Struve function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["H", "TB"], "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " added. The ",
 StyleBox["modified Struve function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StruveL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StruveL"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is given in terms of the ordinary Struve function by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["L", "TB"], "n"], "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"-", "i"}], 
     SuperscriptBox["e", 
      RowBox[{"-", "i", "n", "\[Pi]", "/", "2"}]], 
     RowBox[{
      SubscriptBox[
       StyleBox["H", "TB"], "n"], "(", "z", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". Struve functions appear particularly in electromagnetic theory."
}], "Text",
 CellID->24312],

Cell[TextData[{
 "Here is a plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "0"], "(", 
    SqrtBox["x"], ")"}], TraditionalForm]], "InlineMath"],
 ". This is a curve that an idealized chain hanging from one end can form \
when you wiggle it. "
}], "MathCaption",
 CellID->10144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", 
     RowBox[{"Sqrt", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->519444637],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->721768932]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " generates explicit formulas for half\[Hyphen]integer\[Hyphen]order Bessel \
functions. "
}], "MathCaption",
 CellID->18200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->30643],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox["1", "x"]}], ")"}]}], 
  SqrtBox["x"]]], "Output",
 ImageSize->{105, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->21856]
}, Open  ]],

Cell["\<\
The Airy function plotted here gives the quantum\[Hyphen]mechanical amplitude \
for a particle in a potential that increases linearly from left to right. The \
amplitude is exponentially damped in the classically inaccessible region on \
the right. \
\>", "MathCaption",
 CellID->18061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"AiryAi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->83513533],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNnUtsXFcZxx3PjMfPjJ/jVzweO7GTNE2bApWyzIoGJEQfm6ygUQVKF4io
VCLAouwihFDFqymUNuVZXiK0ILHskiXL7MgyyyyzDPOd8917z3/8m3tsWipG
sj1zfe93/t/7O8/5wtVXr33la1dfffmlq/1nXrl6/drLL32j/9mvvzK41Dg2
Nnbs2tjY2L/7Y/b+0eCt//r72KNHj8Ya8cPgnf28H36Pfez/+k7405x/8ODB
e1euXHn9+vXrkw8fPnx69BPfDn9adteHly5devH27ds3bt68aU+PZR+buP76
4DVopPj3nWcHrzt37pyyD+P2XCPSH0tpBAqD10SW/v21wev+/fvFvy/+c/C6
ePHiycinUK0IyuXm6Ea+Ff916cPBa8C7Pxx+3z0zeN29ezd8OmG/Y2OtEnzK
SLO8oZVt7faLg9dAymlrJvGbN27cCJ92mLfmEG8lvy17f0fauNcfvO7du5e2
YdwYV3VttEq11agmomxc+NfgdeHCBdfvQan1P3obYl4tkN9OSax9NNV7A4W9
pg1ceW/wMvO3T09lSTyYH7wG/paSMJM1082R+Caopg0qvJAlYUwYMykJY8KY
yZH4fAXawkD49Fi8ZsI3JaRkxVhryH4u6qBgztzW5OSUzeHM8VLK4oh5ymZ9
ZoXXbg1e165dc8oSM5yy8fVwcnIyR/ly+DNRhBn7ZI+aMozkGVDvVLxWgAmf
nrTfoQGlK+Ic/BS27HQv/2Pwunz5ckpXlPhkFrl44OCnMOYz4FBToM+aFp4B
5sfh2ul4zTRimkmbEiutacrDk5mLydVUYWrYBSoNcJf9eM0eM02mCMTV8ghM
Liaf77722mv2swtu0YC4tA+mOA3x4oksgoJEIWJHYGZi5pIiKPwgfNqL16wl
azF8mgG51CCIAXxCvHLwUzy+Azw6ktR/CiRybQZsJIdk3BQwXr7rg+k1wdu9
eYnqM+ANeUFIshj8FILpg1m2wCxPxWuFTaVIxPPzSIbLokLLfeCrBQbjSIQh
R2JoDXUOyTaIn3yxB5pugSAckoTR2XjNVFkmpvP2Ow2t2yDBBvDXA+OnjH8K
3NSBSHA9n5WNBFaq9HrgQS3wlpPgy3PAYh4SFZ/C/RZ40AQ075CkCHRIEhzz
kEQhDSC7BdfaILldYMchSWTMQ6KQJhLZgqbawM4uKH0O7LUGUg+abwHME9AU
1YG74I9z4Pp5SNQBEO5PQFNtcH2HJBXhcWj+8SwkCsHC/QnwmjbYiEOSSHYc
ruUhHYzFIXttQURpg2XsQgMORCJ6Hoi4pcvGQoGFhFQ2QsIhQd9RraUDqs5D
Eg4cklQbmxB5JsEhduDZDjhEgJQmjx6ooQU8b4LJT4EX9kGuHQgWedlI0msB
z5tg8lPghVXtNA9M1ADZAuFT3N0AQ6fOi8tGUlAH2shDolQghcMGmPxUKYcd
CAIuG8n657JAxFXbQHYD5DAF8uoDE/NwLQ9Jwlgb5OCQJNpS96wPEpkHdnKQ
gsgnwRkdiMRT6qVtg40sxGuSRvKyoUwkbrkBJKag+W2wwwWQf/DRZBhUR+8a
5XBYLWpKVlIersdrEpBnQHs9MFpHLZEzSoEH7oZYyKOXWNQGpOvAkaOXsNwD
+S4AvRX7XTdYe8RB4i0w0zbYxDr40Az4Wg9MdxGaX2ct0DhnMK50GHgL6E2C
RayBTB2zhOke+P0iyOWomFniXojQKJtYxFoZXmZBpj2Q/SJcG4G5WesENbCp
RpAG10DANCDRAwEvwrMbZZCZ0He1MGmsUcg6TKnRHKbETKpXFkvN1ARlByK1
0hQo0oFIHnQgEraoXlmCNh7LQAq4fbBOEpYDkeKHRk0ciCSxJQCcA8JjqMLL
GpBwSNRhleaXAHoeEpUyQnYVyM5B7CH1LwH0PCQqZUT4DklSzBxYFfWhl0Hp
Z7OQqKiReLYKXjgHHkeG4JAks+YhifCn4fYuKGQOAgP1oZfBOAKktLNFHcxp
kFcX1DBXeibVFcsQNmoksgkmSmPjXRC+S0QiNSl9Ge7LQ6IqSOyhCwpxSBKV
SdYOSSqUPCRxbioOugBzDp7dBDdYidckZ+YhHRzLD5axCi5NQ1vUmV8BcHkg
VDjJtS5ED4dEnXkJB/6sJNYzGUhpNSRS6sKDxyEwbEAQ6IJ554AMeQ3laxJ5
B5raGFawxPs8EJrlkPRARtiBpjaAMfLHPCQhOzPaL8QeOsDOBlzrlvLKG7AI
enZ0zKABLZGDA6HwKQ4RZJMmhU0wwlnwGgciSaFTckrsdEGGedXIv2jex4HI
mEoHOKWxhC5YWg0kJ0GllFjQMhihQ5Jgvw6W5j4lVXMeEs37SPJfBpgdCALr
QM+LWgl8p7OQhOwcmOgyKLMDEl4Hu1mDZ/OQDpZSwVhXwLwdiCSFdaCyBnLN
A5EqhObEloHEPKih6nKvg83lgIQHPetIdloCw1wAl14DtVaQ8mZLZRP1iSQ9
LIDIHYjEXRpMyatGvGYOmqee48Lo5iUCr4Ep10AK4zRhmCYus7B3s8D9HKhr
CeLNAqiraoPm09YgHATAAe+z5bPPAdI45uHjXAcGbnylklymQSWaeFwER1wo
zW4GKM8AFedNIi0p4wWg98XDM9XwfxZ/4ysZhD6KaCQtu2gkblUjPSSkQDm0
N7x61X6mwYzcKyTo7P/PhHR0W6ECWuzHxSDlwQL4xvRogYj1b0Ab/xcC8fFk
mgamMVcJvS4Q6e1Olo5MKyRo1orE8FxJ5flPgHkJ1M48DZILbJq0mIQ2ZsGh
KI+NFMMQveeOLJB2KcxG+Y56ch2weedcOuM0zVGp3fk9OEcYwgtFyufLZ58F
pJ4PvFCReqPqOHjaOhjThmJfF1h0ZUjCJ2W8L0Dkdpec1GckpUWIAtT1dEgS
aXKQ0rUBIiU3VErzYtBduEb9hLxsqFNFhQ8VSOJ3XZDXBrBTAyn4RXCRr9qv
Y2mMwDRgIMvrneq+srF4Xyt9tpQ39b2r1UJt+K8/UZQT4X8LoxyMt4QQFx/z
tba1adfN7I0VM0uTVIj74+GJ4Gl2Lai5GX4HU7D7wx3z9i7St3dBzceDrYVr
9i58Ouy1Tv19qoFapZtxq9IDT52Dqi79fqSqh+IAzeH5s0XuyCldXPKTUHqs
kmatdLP0bcoyDKbgAq/JwK5bjDJsVgRQufxxQ+sc8r68zsWVErJlwiCy6cgs
qV5Cdo3qpWbyUX5a1ftfySgG1EljztKwtWOVuFVhBt/UZQxShvooqqEdUnk1
SB9hHlTj16T7Sb3pGmlLDerSllmmPXg2XpswbNauhQjDZc+Z9miY4oXREvBu
o4wMuctLX9+5lTEBmuL10Sda+kkbSARSXPXdMhswbiyz2f2hwPuewJUmHa7M
EDlciVAOV3rIAW468SeOQiDj8r6wo9UeMxSmruCZ3xeQtH5LfImsahmsbxks
jZaDENwooqbp0cqVUIwNoP5AkFIRJHZI6xeXR6MXK6H1NoQ0rvRoGteWpMz6
jO7r4qnGx/A04MGBk6Eyfx5ao1luurYF+jgF9LYqLk2Socz8oUCnmW/JyAtw
H40gr4CQSRm0tIygJ6ZUsv4jgX5wHUE6JkPTSDT7KbZPQ8Jb4LQEeGjqODD3
YwGcHa2nIQLqEVTxYRnMuAeMBcAB74aKJzjOTwSmdDRonoM68x0wE5ewRNgl
0AStDiQJJ5MUZmbB8n8q0Gm3EA3MUGoVq3foNGAvhkULNAl6EnwNT5D6GxE6
DbLRHBz10I+XhtAFM6GFYLRphAAnK5pKa74lgGkalYYUaKRZbHMFzG6pZGwb
fIIAuwDMKMywQotvCmABQlUpDVw5YAlrK2BsS+DOPXDOGujiYwo9O3fuzUu1
cRyepSURi8DiNtx3Eq5RYfUzgZ5dibAEJkGdDlqR4dAlN27DfQR9ubJwwxKi
yc8FOq1WPehgwUo74JxdAEcLiLdBTwQ4WSho9waabwlg2mVLIYymRqXWXgXd
UejcBkHVQJd2FbqURrSqiIIZLXRaBUekQb1+qTtyyUUwjl8IYAFSrcdaBjOh
SdfV8glvSjJiHwQQ5BpQksMqOMlRtO/cpUmrQ8VgVgHIArThgCWtkCHQs28L
dFoNKJGR+ndUuK4CJCpm+yD/GugyuK/QaW0l9fXE1arCdQ0EUM247oANE8x5
YPGdCJMWwNJaVLdhWp4knk6rnmn626FLb4X2eCbrQYrDR8ZuC3Raz5vt/s2C
EdEactrotQP0aqCLASp0IUGaoNVDDp3WN0ipRQMLO3CtZmetSP1dgU5rzanv
J5KbBbZpVwMNN+yAsdVAF6krdFq5T+sgxV6pNqQ1SLRYaKd0WHLOJNeWsv6l
ABaeKZpXfb+hyZDwiVYodSByuDRp/zcBFgkrYKk5KDdSiUh14DrQo377Lgil
BroYlkKn3bsiEYdO29toQZ/Qo7WIu8B2uBaQz8ITvxLAB/c9p30/ypySzGlt
Ha3i3K2stExTJGGKTgpYpERV9QpEE9oXtg70qgltr+AkJO4A4Bkwp18LYFGN
A5ZOFfX9ZsBy14FeBwRwEmRYA12eVei0dZCWJlMOFbLroP4OiMKhSxlK0BN8
puMQKn8TodMcGM3d0tT2NECilVTJpGWZdBy6TL3XQJfOiUIXm6OJG1ooMA2Q
aM0TbVY4Cd5RA13EqNCl+TYY0SoYxzSwTeuU5sBP3E0lihF0Snu/Feii9DZ4
9Sq4JBVdNWtkxXVPQRtxGaBRG7nRnbZY0zERyp2goQNSVsEGqC7bBDOnhWan
QPmxkD/UhnjiMhmQNZLBG3+XcJmekCAJaRWuUddwE1yTVnnvQUiYZ95okzzN
LE9CMylvfCCFIHUuKT+Ke2yCNKoe4z7EjBG80Xb0sNonrNdwziVdKEd01qbY
FXUGqaaiHXa043IPgspReRvSGwWK94RLsTA6SYp2jtDgG+22pPmIPeB8BJcj
NueT89GBU8qoAGsDMNqPMgkCoT2XNHuxVxptFTarrft0woCjkgTmTFAHbQJu
px0sk2DqzoQkNTqHbw+8sT8ai9j47wW6wKS1GNTfpMroBLBDEwT7AKkGuvSH
FTodJkh7icSmqTKizfVUoe9DGwQ9OTDK2A4V0x8EujRFZ29Va0NppbfPBEvY
o/C4XwEpC+gawJKKFbB4MJ1fRl26NjBWnUrklKV2OA2GRTNAdBq1AqZTOCXx
0YkxdCoRnTZI/azT4CcEPTkltTSOPwp0aaoFbkBdOsrtdO6EQ5e+0mmQZg10
EZlCl7RFZ59Sl46S+BZYPfUWTpfmFO4JeJvAjsKUrEmnp3s1LnF4AiTXAynR
aPBp8A6ScHLcpT0f4v2fInQ6xYNSLu0FngDJ0QE3dNrWGdBsDXSJIQpdmm9A
U16rSHCcALbpcCGqzB26pJ8a6GIwCl2UTscsUwenBSzSPOUUuL1vHpekT8Y2
DtHkzwJdglQD7JBOU6BzcLchwtCc6dnRxkbQJTopdJFIA9ihUxhbwM420HPo
EljPHtLFx+FZhS6SowORHbrE8GrLQR+o0CDgWTC7GsDi7ApYrHTk13AMWWQT
HHYbnI7WvZwFPUXoEwJ98FMUYX+JiONg1IQw86g6hrsH9teEa31gqF250/AR
SLDaqjkMNOhOUQ4fW16olA51awKiPiBvg+08BtdGiLNQQwq0Ot59qHTaGh1F
pDbeAX7a4J50JFloI15SBlSUw0fhF6LtjY4WNMInrFDZdA6cJYpBtpSUz9wR
lJK7B1eKzOUopaKhmLYDfkEDAOcgHADKMkk6yjh+3ixIFQJyPJJm3RxoLjd7
Bqyjkwi5pU5T+OtfBVjhH9aq8dUHNsfBT3bAc9tw3zlQ+BCwIjs6sGQdg56m
m/oMLdrInmv8OBjuEJZCT47l0+wJBTenQFi0w+VxAJ00nFYT2rDUGYl10Zcr
VNnsPOgmOSSz5Mb3/n0mIimSWoFyDxhx5ugcfkpe1lqZK7U1y1ep3e2Bvuhr
Jc4DgqS18l5v7ekqCpTV+T74XgOihX8fhCT7pKkSpjf1JUBG9d8TEHAC2UBV
idGXKtDXiIiBJhjLOKJkxRDpeyycrBQVyfHkZcD7IJL9crTW4S/qKJp5CgSe
HBrD1Joi98K0nZT0tpKzRUYAS/k1rzDVGa9PgUSTHrPxEyj+LVKL+gux3HCb
YuznU/GJumnrg1RCA2Yr4ZHo7lrzDO0STkm8UalieAFIocb09sgYHOWZ/c66
GG2bqfweHaAr4S/2xg81wzIe97kWRFO93QLXG0G5+ja6+DY1jfSU4FvgdnUk
B5CLy/638AaaYXhfGhH/GtFI9c1wUQRljMiTl8B+SPKlkmrIx6XnMNmefOdc
aCid3MvTo6OyJAfnSYhv0fGbeRK0QUJqx5ozmt8Ef6NNITUk4tp4PCEiu6FV
SdBhK1In1Bzv7SRoi5rIJ5BI85E/mF3xWdN2XGKvWYAWftYcOu0kJMV2QA95
ErRiiyYJakiIkydrKUuDqjmW+i2QBW0fzJOgBQw0FllDQnxxFpijAxmUhMz2
z4Kd1pCIC9gpiyhZmklSEiI6WuqXJyEKnALrnBr2jLfBCyahbdrtpSRI5tI2
rWNxEu+AEF3zUkPmSdAXHZnb27Vgq7R0y0ncBs0nQ+zl5hWaxlUSxe1pyrLW
jcHg+nOjSbwbubfbi7M3zLxNjPYo7cn3J+MaxjAMaE4R2KWTFPz2j/CFxqkF
1dw7duw/1CM+1g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 222},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->128556739]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BesselJZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselJZero"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero of the Bessel function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["J", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BesselJZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselJZero"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]}], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero greater than ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BesselYZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselYZero"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero of the Bessel function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["Y", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BesselYZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselYZero"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]}], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero greater than ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AiryAiZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryAiZero"], "[", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero of the Airy function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Ai", " ", 
        RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AiryAiZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryAiZero"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]}], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero less than ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AiryBiZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryBiZero"], "[", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero of the Airy function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Bi", " ", 
        RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AiryBiZero",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryBiZero"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]}], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero less than ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "0"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6056027],

Cell["Zeros of Bessel and Airy functions. ", "Caption",
 CellID->155351773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselJZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJZero"], "[", 
   RowBox[{"1", ",", "5"}], "]"}]], "InlineFormula"],
 " represents the fifth zero of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "1"], " ", 
    RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->30941568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{"1", ",", 
   RowBox[{"BesselJZero", "[", 
    RowBox[{"1", ",", "5"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->88935959],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->93368954]
}, Open  ]],

Cell["This gives its numerical value. ", "MathCaption",
 CellID->84534790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"BesselJZero", "[", 
   RowBox[{"1", ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->665272608],

Cell[BoxData["16.470630050877634`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->118262280]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Legendre and Related Functions", "Section",
 CellID->19808],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "Legendre functions of the first kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["P", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "associated Legendre functions of the first kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["P", "n", "m"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LegendreQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreQ"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "Legendre functions of the second kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["Q", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LegendreQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreQ"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "associated Legendre functions of the second kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["Q", "n", "m"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9290],

Cell["Legendre and related functions. ", "Caption",
 CellID->17452],

Cell[TextData[{
 "The ",
 StyleBox["Legendre functions", "TB"],
 " and ",
 StyleBox["associated Legendre functions", "TB"],
 " satisfy the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["z", "2"]}], ")"}], 
    SuperscriptBox["y", "\[Prime]\[Prime]"], "-", "2", "z", 
    SuperscriptBox["y", "\[Prime]"], "+", 
    RowBox[{"[", 
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}], "-", 
      SuperscriptBox["m", "2"], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["z", "2"]}], ")"}]}], "]"}], "y", "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". The ",
 StyleBox["Legendre functions of the first kind", "TB"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ", reduce to Legendre polynomials when ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " are integers. The ",
 StyleBox["Legendre functions of the second kind", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreQ"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreQ"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " give the second linearly independent solution to the differential \
equation. For integer ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " they have logarithmic singularities at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[PlusMinus]", "1"}], TraditionalForm]], "InlineMath"],
 ". The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["P", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Q", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " solve the differential equation with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->979],

Cell["\<\
Legendre functions arise in studies of quantum\[Hyphen]mechanical scattering \
processes. \
\>", "Text",
 CellID->32618],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[" or ", "TableText"], 
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], ",", "1", ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "type 1 function containing ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["z", "2"]}], ")"}], 
        RowBox[{"m", "/", "2"}]], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], ",", "2", ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "type 2 function containing ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "z"}], ")"}], 
         RowBox[{"m", "/", "2"}]], "/", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}], 
         RowBox[{"m", "/", "2"}]]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], ",", "3", ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "type 3 function containing ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "z"}], ")"}], 
         RowBox[{"m", "/", "2"}]], "/", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "z"}], ")"}], 
         RowBox[{"m", "/", "2"}]]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21419],

Cell[TextData[{
 "Types of Legendre functions. Analogous types exist for ",
 StyleBox["LegendreQ", "MR"],
 ". "
}], "Caption",
 CellID->24007],

Cell[TextData[{
 StyleBox["Legendre functions of type 1", "TB"],
 " and ",
 StyleBox["Legendre functions of type 2", "TB"],
 " have different symbolic forms, but the same numerical values. They have \
branch cuts from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ". ",
 StyleBox["Legendre functions of type 3", "TB"],
 ", sometimes denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[ScriptCapitalP]", "n", "m"], "(", "z", ")"}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[ScriptCapitalQ]", "n", "m"], "(", "z", ")"}], 
   TraditionalForm]], "InlineMath"],
 ", have a single branch cut from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->22284],

Cell[TextData[{
 StyleBox["Toroidal functions", "TB"],
 " or ",
 StyleBox["ring functions", "TB"],
 ", which arise in studying systems with toroidal symmetry, can be expressed \
in terms of the Legendre functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["P", 
     RowBox[{"\[Nu]", "-", 
      FractionBox["1", "2"]}], 
     RowBox[{" ", "\[Mu]"}]], "(", "cosh\[Eta]", ")"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["Q", 
     RowBox[{"\[Nu]", "-", 
      FractionBox["1", "2"]}], 
     RowBox[{" ", "\[Mu]"}]], "(", "cosh\[Eta]", ")"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->24547],

Cell[TextData[{
 StyleBox["Conical functions", "TB"],
 " can be expressed in terms of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["P", 
     RowBox[{"-", 
      FractionBox["1", "2"], "+", "i", "p"}], 
     RowBox[{" ", "\[Mu]"}]], "(", "cos\[Theta]", ")"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["Q", 
     RowBox[{"-", 
      FractionBox["1", "2"], "+", "i", "p"}], 
     RowBox[{" ", "\[Mu]"}]], "(", "cos\[Theta]", ")"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->29977],

Cell[TextData[{
 "When you use the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " with an integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", you get a Legendre polynomial. If you take ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " to be an arbitrary complex number, you get, in general, a Legendre \
function. "
}], "Text",
 CellID->15675],

Cell[TextData[{
 "In the same way, you can use the functions ",
 Cell[BoxData[
  ButtonBox["GegenbauerC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GegenbauerC"]], "InlineFormula"],
 " and so on with arbitrary complex indices to get ",
 StyleBox["Gegenbauer functions", "TB"],
 ", ",
 StyleBox["Chebyshev functions", "TB"],
 ", ",
 StyleBox["Hermite functions", "TB"],
 ", ",
 StyleBox["Jacobi functions", "TB"],
 " and ",
 StyleBox["Laguerre functions", "TB"],
 ". Unlike for associated Legendre functions, however, there is no need to \
distinguish different types in such cases."
}], "Text",
 CellID->18613]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hypergeometric Functions and Generalizations", "Section",
 CellID->12516],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Hypergeometric0F1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric0F1"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "0"], 
        RowBox[{
         SubscriptBox["F", "1"], "(", 
         RowBox[{";", "a", ";", "z"}], ")"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Hypergeometric0F1Regularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric0F1Regularized"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "regularized hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "0"], 
        RowBox[{
         RowBox[{
          SubscriptBox["F", "1"], "(", 
          RowBox[{";", "a", ";", "z"}], ")"}], "/", 
         RowBox[{"\[CapitalGamma]", "(", "a", ")"}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Hypergeometric1F1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric1F1"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "Kummer confluent hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "1"], 
        RowBox[{
         SubscriptBox["F", "1"], "(", 
         RowBox[{"a", ";", "b", ";", "z"}], ")"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Hypergeometric1F1Regularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric1F1Regularized"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "regularized confluent hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "1"], 
        RowBox[{
         RowBox[{
          SubscriptBox["F", "1"], "(", 
          RowBox[{"a", ";", "b", ";", "z"}], ")"}], "/", 
         RowBox[{"\[CapitalGamma]", "(", "b", ")"}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HypergeometricU",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricU"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "confluent hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"U", "(", 
        RowBox[{"a", ",", "b", ",", "z"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["WhittakerM",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WhittakerM"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["z", "TI"], "]", Cell[
     " \[ThinSpace]and \[ThinSpace]", "TableText"], 
     ButtonBox["WhittakerW",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WhittakerW"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "Whittaker functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["M", 
         RowBox[{"k", ",", "m"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["W", 
         RowBox[{"k", ",", "m"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ParabolicCylinderD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ParabolicCylinderD"], "[", "\[Nu]", ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "parabolic cylinder function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["D", "\[Nu]"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13371],

Cell["Confluent hypergeometric functions and related functions. ", "Caption",
 CellID->28642],

Cell[TextData[{
 "Many of the special functions that we have discussed so far can be viewed \
as special cases of the ",
 StyleBox["confluent hypergeometric function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric1F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->16339],

Cell[TextData[{
 "The confluent hypergeometric function can be obtained from the series \
expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "1"], 
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{"a", ";", "b", ";", "z"}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"a", "\[InvisibleSpace]", 
       RowBox[{"z", "/", "b"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"a", "+", "1"}], ")"}]}], "/", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{"b", "+", "1"}], ")"}]}]}], " ", 
       RowBox[{
        SuperscriptBox["z", "2"], "/", 
        RowBox[{"2", "!"}]}]}], "+", "\[CenterEllipsis]"}], "=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "0"}], "\[Infinity]",
       LimitsPositioning->True], 
      RowBox[{
       RowBox[{
        SubscriptBox[
         RowBox[{"(", "a", ")"}], "k"], "/", 
        SubscriptBox[
         RowBox[{"(", "b", ")"}], "k"]}], " ", 
       RowBox[{
        SuperscriptBox["z", "k"], "/", 
        RowBox[{"k", "!"}], " "}]}]}]}]}], TraditionalForm]], "InlineMath"],
 ". Some special results are obtained when ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " are both integers. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "<", "0"}], TraditionalForm]], "InlineMath"],
 ", and either ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", ">", "0"}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "<", "a"}], TraditionalForm]], "InlineMath"],
 ", the series yields a polynomial with a finite number of terms. "
}], "Text",
 CellID->6336],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " is zero or a negative integer, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    RowBox[{
     SubscriptBox["F", "1"], "(", 
     RowBox[{"a", ";", "b", ";", "z"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " itself is infinite. But the ",
 StyleBox["regularized confluent hypergeometric function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric1F1Regularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1Regularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    RowBox[{
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{"a", ";", "b", ";", "z"}], ")"}], "/", 
     RowBox[{"\[CapitalGamma]", "(", "b", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " has a finite value in all cases. "
}], "Text",
 CellID->32621],

Cell[TextData[{
 "Among the functions that can be obtained from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " are the Bessel functions, error function, incomplete gamma function, and \
Hermite and Laguerre polynomials. "
}], "Text",
 CellID->21501],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    RowBox[{
     SubscriptBox["F", "1"], "(", 
     RowBox[{"a", ";", "b", ";", "z"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " is sometimes denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{"a", ";", "b", ";", "z"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "(", 
    RowBox[{"a", ",", "b", ",", "z"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ". It is often known as the ",
 StyleBox["Kummer function", "TB"],
 "."
}], "Text",
 CellID->26034],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " function can be written in the integral representation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "1"], 
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{"a", ";", "b", ";", "z"}], ")"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[CapitalGamma]", "(", "b", ")"}], "/", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"b", "-", "a"}], ")"}], 
        RowBox[{"\[CapitalGamma]", "(", "a", ")"}]}], "]"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{" ", "0"}], "1"], 
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{"z", "\[InvisibleSpace]", "t"}]], 
       SuperscriptBox["t", 
        RowBox[{"a", "-", "1"}]]}]}]}]}], TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "t"}], ")"}], 
     RowBox[{"b", "-", "a", "-", "1"}]], " ", "d", "t"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->18129],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " confluent hypergeometric function is a solution to \
Kummer\[CloseCurlyQuote]s differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", 
    SuperscriptBox["y", "\[Prime]\[Prime]"], "+", 
    RowBox[{"(", 
     RowBox[{"b", "-", "z"}], ")"}], 
    SuperscriptBox["y", "\[Prime]"], "-", "a", "y", "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ", with the boundary conditions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "1"], 
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{"a", ";", "b", ";", "0"}], ")"}]}], "=", "1"}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"\[PartialD]", 
       RowBox[{"[", 
        RowBox[{
         SubscriptBox["\[Null]", "1"], 
         RowBox[{
          SubscriptBox["F", "1"], "(", 
          RowBox[{"a", ";", "b", ";", "z"}], ")"}]}], "]"}]}], "/", 
      RowBox[{"\[PartialD]", "z"}]}], 
     SubscriptBox["\[VerticalSeparator]", 
      RowBox[{"z", "=", "0"}]]}], "=", 
    RowBox[{"a", "/", "b"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->21358],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HypergeometricU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricU"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " gives a second linearly independent solution to Kummer\[CloseCurlyQuote]s \
equation. For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Re", " ", "b", ">", "1"}], TraditionalForm]], "InlineMath"],
 " this function behaves like ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", 
    RowBox[{"1", "-", "b"}]], TraditionalForm]], "InlineMath"],
 " for small ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ". It has a branch cut along the negative real axis in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane."
}], "Text",
 CellID->1436],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"U", "(", 
    RowBox[{"a", ",", "b", ",", "z"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " has the integral representation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"U", "(", 
     RowBox[{"a", ",", "b", ",", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"\[CapitalGamma]", "(", "a", ")"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{"-", "z", "t"}]], 
       SuperscriptBox["t", 
        RowBox[{"a", "-", "1"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "t"}], ")"}], 
        RowBox[{"b", "-", "a", "-", "1"}]], " ", "d", "t"}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->28469],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"U", "(", 
    RowBox[{"a", ",", "b", ",", "z"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ", like ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    RowBox[{
     SubscriptBox["F", "1"], "(", 
     RowBox[{"a", ";", "b", ";", "z"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ", is sometimes known as the ",
 StyleBox["Kummer function", "TB"],
 ". The ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 " function is sometimes denoted by ",
 Cell[BoxData[
  FormBox["\[CapitalPsi]", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->22897],

Cell[TextData[{
 "The ",
 StyleBox["Whittaker functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WhittakerM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhittakerM"], "[", 
   StyleBox["k", "TI"], ",", 
   StyleBox["m", "TI"], ",", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WhittakerW",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhittakerW"], "[", 
   StyleBox["k", "TI"], ",", 
   StyleBox["m", "TI"], ",", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " give a pair of solutions to the normalized Kummer differential equation, \
known as Whittaker's differential equation. The Whittaker function ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", 
    RowBox[{"\[Kappa]", ",", " ", "\[Mu]"}]], TraditionalForm]], 
  "InlineMath"],
 " is related to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["M", 
      RowBox[{"\[Kappa]", ",", " ", "\[Mu]"}]], "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox["e", 
      RowBox[{"-", "z", "/", "2"}]], 
     SuperscriptBox["z", 
      RowBox[{"1", "/", "2", "+", "\[Mu]"}]], 
     SubscriptBox["\[Null]", "1"], 
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{
       FractionBox["1", "2"], "+", "\[Mu]", "-", "\[Kappa]", ";", "1", "+", 
       "2", "\[Mu]", ";", "z"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". The second Whittaker function ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["W", 
    RowBox[{"\[Kappa]", ",", " ", "\[Mu]"}]], TraditionalForm]], 
  "InlineMath"],
 " obeys the same relation, with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " replaced by ",
 Cell[BoxData[
  FormBox["U", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->28504],

Cell[TextData[{
 "The ",
 StyleBox["parabolic cylinder functions", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParabolicCylinderD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParabolicCylinderD"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", " ", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " are related to the Hermite functions by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["D", "\[Nu]"], "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "\[Nu]"}], "/", "2"}]], 
     RowBox[{
      SuperscriptBox["e", 
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "/", "2"}], ")"}], "2"]}]], " ", "\[Cross]"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["H", "\[Nu]"], "(", 
    RowBox[{"z", "/", 
     SqrtBox["2"]}], ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->4798],

Cell[TextData[{
 "The ",
 StyleBox["Coulomb wave functions", "TB"],
 " are also special cases of the confluent hypergeometric function. Coulomb \
wave functions give solutions to the radial Schr\[ODoubleDot]dinger equation \
in the Coulomb potential of a point nucleus. The regular Coulomb wave \
function is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["F", "L"], "(", 
     RowBox[{"\[Eta]", ",", "\[Rho]"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["C", "L"], "(", "\[Eta]", ")"}], 
     SuperscriptBox["\[Rho]", 
      RowBox[{"L", "+", "1"}]], 
     SuperscriptBox["e", 
      RowBox[{"-", "i", "\[Rho]"}]], 
     SubscriptBox["\[Null]", "1"], 
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{
       RowBox[{"L", "+", "1", "-", 
        RowBox[{"i", "\[Eta]"}]}], ";", 
       RowBox[{
        RowBox[{"2", "L"}], "+", "2"}], ";", 
       RowBox[{"2", "i", "\[Rho]"}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["C", "L"], "(", "\[Eta]", ")"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["2", "L"], 
      SuperscriptBox["e", 
       RowBox[{"-", "\[Pi]\[Eta]", "/", "2"}]]}], "\[VerticalSeparator]", 
     RowBox[{"\[CapitalGamma]", "(", 
      RowBox[{"L", "+", "1", "+", 
       RowBox[{"i", "\[Eta]"}]}], ")"}], "\[VerticalSeparator]", 
     RowBox[{"/", 
      RowBox[{"\[CapitalGamma]", "(", 
       RowBox[{
        RowBox[{"2", "L"}], "+", "2"}], ")"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->4202],

Cell[TextData[{
 "Other special cases of the confluent hypergeometric function include the ",
 StyleBox["Toronto functions", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"T", "(", 
    RowBox[{"m", ",", "n", ",", "r"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 StyleBox["Poisson\[Hyphen]Charlier polynomials", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Rho]", "n"], "(", 
    RowBox[{"\[Nu]", ",", "x"}], ")"}], TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Cunningham functions", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Omega]", 
     RowBox[{"n", ",", "m"}]], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 StyleBox["Bateman functions", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["k", "\[Nu]"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->23105],

Cell[TextData[{
 "A limiting form of the confluent hypergeometric function which often \
appears is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric0F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric0F1"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". This function is obtained as the limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "0"], 
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{";", "a", ";", "z"}], ")"}]}], "=", 
    RowBox[{
     UnderscriptBox["lim", 
      RowBox[{"q", "\[Rule]", "\[Infinity]"}],
      LimitsPositioning->True], 
     RowBox[{
      SubscriptBox["\[Null]", "1"], 
      RowBox[{
       SubscriptBox["F", "1"], "(", 
       RowBox[{"q", ";", "a", ";", "z", "/", "q"}], ")"}]}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->1238],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "0"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " function has the series expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "0"], 
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{";", "a", ";", "z"}], ")"}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{"1", "/", 
       SubscriptBox[
        RowBox[{"(", "a", ")"}], "k"]}], " ", 
      RowBox[{
       SuperscriptBox["z", "k"], "/", 
       RowBox[{"k", "!"}]}]}]}]}], TraditionalForm]], "InlineMath"],
 " and satisfies the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", 
    SuperscriptBox["y", "\[Prime]\[Prime]"], "+", "a", 
    SuperscriptBox["y", "\[Prime]"], "-", "y", "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->15032],

Cell[TextData[{
 "Bessel functions of the first kind can be expressed in terms of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "0"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " function. "
}], "Text",
 CellID->20065],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Hypergeometric2F1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric2F1"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "2"], 
        RowBox[{
         SubscriptBox["F", "1"], "(", 
         RowBox[{"a", ",", 
          RowBox[{"b", ";", "c", ";", "z"}]}], ")"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Hypergeometric2F1Regularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric2F1Regularized"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "regularized hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "2"], 
        RowBox[{
         RowBox[{
          SubscriptBox["F", "1"], "(", 
          RowBox[{"a", ",", 
           RowBox[{"b", ";", "c", ";", "z"}]}], ")"}], "/", 
         RowBox[{"\[CapitalGamma]", "(", "c", ")"}]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HypergeometricPFQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricPFQ"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["p", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["q", "TI"]]}], "}"}], ",", 
      StyleBox["z", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "generalized hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "p"], 
        RowBox[{
         SubscriptBox["F", "q"], "(", 
         RowBox[{"a", ";", "b", ";", "z"}], ")"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HypergeometricPFQRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricPFQRegularized"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["p", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["q", "TI"]]}], "}"}], ",", 
      StyleBox["z", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "regularized generalized hypergeometric function", "TableText"]},
   {
    RowBox[{
     ButtonBox["MeijerG",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MeijerG"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["n", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           RowBox[{
            StyleBox["n", "TI"], "+", 
            StyleBox["1", "TR"]}]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["p", "TI"]]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["m", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           RowBox[{
            StyleBox["m", "TI"], "+", 
            StyleBox["1", "TR"]}]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["q", "TI"]]}], "}"}]}], "}"}], ",", 
      StyleBox["z", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["Meijer G function", "TableText"]},
   {
    RowBox[{
     ButtonBox["AppellF1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AppellF1"], "[", 
     StyleBox["a", "TI"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "2"], ",", 
     StyleBox["c", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell[TextData[{
     "Appell hypergeometric function of two variables ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["F", "1"], "(", 
        RowBox[{
         RowBox[{"a", ";", 
          SubscriptBox["b", "1"]}], ",", 
         RowBox[{
          SubscriptBox["b", "2"], ";", "c", ";", "x"}], ",", "y"}], ")"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6000000000000001]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14481],

Cell["Hypergeometric functions and generalizations. ", "Caption",
 CellID->15579],

Cell[TextData[{
 "The ",
 StyleBox["hypergeometric function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric2F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric2F1"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["c", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has series expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "2"], 
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{"a", ",", 
       RowBox[{"b", ";", "c", ";", "z"}]}], ")"}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox[
         RowBox[{"(", "a", ")"}], "k"], 
        SubscriptBox[
         RowBox[{"(", "b", ")"}], "k"]}], "/", 
       SubscriptBox[
        RowBox[{"(", "c", ")"}], "k"]}], " ", 
      RowBox[{
       SuperscriptBox["z", "k"], "/", 
       RowBox[{"k", "!"}], " "}]}]}]}], TraditionalForm]], "InlineMath"],
 ". The function is a solution of the hypergeometric differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"z", "(", 
       RowBox[{"1", "-", "z"}], ")"}], 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "+", 
     RowBox[{
      RowBox[{"[", 
       RowBox[{"c", "-", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "1"}], ")"}], "z"}], "]"}], 
      SuperscriptBox["y", "\[Prime]"]}], "-", 
     RowBox[{"a", "b", "y"}]}], "=", "0"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->9023],

Cell[TextData[{
 "The hypergeometric function can also be written as an integral: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "2"], 
     RowBox[{
      SubscriptBox["F", "1"], "(", 
      RowBox[{"a", ",", 
       RowBox[{"b", ";", "c", ";", "z"}]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"\[CapitalGamma]", "(", "c", ")"}], "/", 
     RowBox[{
      RowBox[{"[", 
       RowBox[{
        RowBox[{"\[CapitalGamma]", "(", "b", ")"}], 
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"c", "-", "b"}], ")"}]}], "]"}], " ", "\[Cross]"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    SuperscriptBox["t", 
     RowBox[{"b", "-", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "t"}], ")"}], 
     RowBox[{"c", "-", "b", "-", "1"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "t", "z"}], ")"}], 
     RowBox[{"-", "a"}]], " ", "d", "t"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->1727],

Cell[TextData[{
 "The hypergeometric function is also sometimes denoted by ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 ", and is known as the ",
 StyleBox["Gauss series", "TB"],
 " or the ",
 StyleBox["Kummer series", "TB"],
 "."
}], "Text",
 CellID->1771],

Cell[TextData[{
 "The Legendre functions, and the functions which give generalizations of \
other orthogonal polynomials, can be expressed in terms of the hypergeometric \
function. Complete elliptic integrals can also be expressed in terms of the \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "2"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " function."
}], "Text",
 CellID->31313],

Cell[TextData[{
 "The ",
 StyleBox["Riemann P function", "TB"],
 ", which gives solutions to Riemann\[CloseCurlyQuote]s differential \
equation, is also a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "2"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " function."
}], "Text",
 CellID->10382],

Cell[TextData[{
 "The ",
 StyleBox["generalized hypergeometric function", "TB"],
 " or ",
 StyleBox["Barnes extended hypergeometric function ", "TB"],
 Cell[BoxData[
  RowBox[{
   ButtonBox["HypergeometricPFQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricPFQ"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["p", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["q", "TI"]]}], "}"}], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has series expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "p"], 
     RowBox[{
      SubscriptBox["F", "q"], "(", 
      RowBox[{
       StyleBox["a", "TB"], ";", 
       StyleBox["b", "TB"], ";", "z"}], ")"}]}], "="}], TraditionalForm]], 
  "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox[
        RowBox[{"(", 
         SubscriptBox["a", "1"], ")"}], "k"], "...", 
       SubscriptBox[
        RowBox[{"(", 
         SubscriptBox["a", "p"], ")"}], "k"]}], "/", 
      RowBox[{"[", 
       RowBox[{
        SubscriptBox[
         RowBox[{"(", 
          SubscriptBox["b", "1"], ")"}], "k"], "...", 
        SubscriptBox[
         RowBox[{"(", 
          SubscriptBox["b", "q"], ")"}], "k"]}], "]"}]}], " ", 
     RowBox[{
      SuperscriptBox["z", "k"], "/", 
      RowBox[{"k", "!"}], " "}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->6140],

Cell[TextData[{
 "The ",
 StyleBox["Meijer G function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["MeijerG",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeijerG"], "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["n", "TI"]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["n", "TI"]], "+", "1"}], ",", "\[Ellipsis]", ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["p", "TI"]]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["b", "TI"], 
          StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", 
         SubscriptBox[
          StyleBox["b", "TI"], 
          StyleBox["m", "TI"]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["m", "TI"]], "+", "1"}], ",", "\[Ellipsis]", ",", 
         SubscriptBox[
          StyleBox["b", "TI"], 
          StyleBox["q", "TI"]]}], "}"}]}], "}"}], ",", 
     StyleBox["z", "TI"]}], "]"}], " "}]], "InlineFormula"],
 " is defined by the contour integral representation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["G", 
      RowBox[{"p", "q"}], 
      RowBox[{"m", "n"}]], "(", 
     RowBox[{"z", "\[VerticalSeparator]", GridBox[{
        {
         RowBox[{
          SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
          SubscriptBox["a", "p"]}]},
        {
         RowBox[{
          SubscriptBox["b", "1"], ",", "\[Ellipsis]", ",", 
          SubscriptBox["b", "q"]}]}
       }]}], ")"}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", "i"}]], 
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"\[CapitalGamma]", "(", 
        RowBox[{"1", "-", 
         SubscriptBox["a", "1"], "-", "s"}], ")"}], 
       RowBox[{
        RowBox[{"\[Ellipsis]\[CapitalGamma]", "(", 
         RowBox[{"1", "-", 
          SubscriptBox["a", "n"], "-", "s"}], ")"}], " ", 
        "\[Cross]"}]}]}]}]}], TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalGamma]", "(", 
     RowBox[{
      SubscriptBox["b", "1"], "+", "s"}], ")"}], 
    RowBox[{
     RowBox[{"\[Ellipsis]\[CapitalGamma]", "(", 
      RowBox[{
       SubscriptBox["b", "m"], "+", "s"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[CapitalGamma]", "(", 
        RowBox[{
         SubscriptBox["a", 
          RowBox[{"n", "+", "1"}]], "+", "s"}], ")"}], 
       RowBox[{"\[Ellipsis]\[CapitalGamma]", "(", 
        RowBox[{
         SubscriptBox["a", "p"], "+", "s"}], ")"}], 
       RowBox[{"\[CapitalGamma]", "(", 
        RowBox[{"1", "-", 
         SubscriptBox["b", 
          RowBox[{"m", "+", "1"}]], "-", "s"}], ")"}], 
       RowBox[{"\[Ellipsis]\[CapitalGamma]", "(", 
        RowBox[{"1", "-", 
         SubscriptBox["b", "q"], "-", "s"}], ")"}]}], ")"}]}], " ", 
    SuperscriptBox["z", 
     RowBox[{"-", "s"}]], "d", "\[InvisibleSpace]", "s"}], TraditionalForm]], 
  "InlineMath"],
 ", where the contour of integration is set up to lie between the poles of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalGamma]", "(", 
    RowBox[{"1", "-", 
     SubscriptBox["a", "i"], "-", "s"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " and the poles of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalGamma]", "(", 
    RowBox[{
     SubscriptBox["b", "i"], "+", "s"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " is a very general function whose special cases cover most of the functions \
discussed in the past few sections. "
}], "Text",
 CellID->24816],

Cell[TextData[{
 "The ",
 StyleBox["Appell hypergeometric function of two variables", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AppellF1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppellF1"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    SubscriptBox[
     StyleBox["b", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["b", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["c", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " has series expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["F", "1"], 
    RowBox[{"(", 
     RowBox[{"a", ";", 
      SubscriptBox["b", "1"], ",", 
      SubscriptBox["b", "2"], ";", "c", ";", "x", ",", "y"}], ")"}], "=", 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"m", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    SubscriptBox[
     RowBox[{"(", "a", ")"}], 
     RowBox[{"m", "+", "n"}]], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["b", "1"], ")"}], "m"], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["b", "2"], ")"}], "n"], "/", 
    RowBox[{"(", 
     RowBox[{"m", "!", "n", "!", 
      SubscriptBox[
       RowBox[{"(", "c", ")"}], 
       RowBox[{"m", "+", "n"}]]}], ")"}], 
    SuperscriptBox["x", "m"], 
    SuperscriptBox["y", "n"]}], TraditionalForm]], "InlineMath"],
 ". This function appears for example in integrating cubic polynomials to \
arbitrary powers."
}], "Text",
 CellID->28488]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Product Log Function", "Section",
 CellID->15319],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ProductLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ProductLog"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "product log function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"W", "(", "z", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5589],

Cell["The product log function.", "Caption",
 CellID->5513],

Cell[TextData[{
 "The ",
 StyleBox["product log function", "TB"],
 " gives the solution for ",
 Cell[BoxData[
  FormBox["w", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "w", 
    SuperscriptBox["e", "w"]}], TraditionalForm]], "InlineMath"],
 ". The function can be viewed as a generalization of a logarithm. It can be \
used to represent solutions to a variety of transcendental equations. The ",
 StyleBox["tree generating function", "TB"],
 " for counting distinct oriented trees is related to the product log by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"T", "(", "z", ")"}], "=", 
    RowBox[{"-", 
     RowBox[{"W", "(", 
      RowBox[{"-", "z"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->18259],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->35497276],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Special Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OrthogonalPolynomials"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SpecialFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 58.4668116}", "context" -> "", 
    "keywords" -> {
     "AiryAi", "AiryAiPrime", "AiryBi", "AiryBiPrime", "Airy functions", 
      "analytic continuation", "AppellF1", "Appell hypergeometric function", 
      "Barnes extended hypergeometric function", "Bateman functions", 
      "Bessel equation", "Bessel functions", "BesselI", "BesselJ", "BesselK", 
      "BesselY", "beta", "beta function", "BetaRegularized", 
      "Catalan beta function", "Chebyshev functions", "Clausen function", 
      "confidence intervals", "confluent hypergeometric function", 
      "conical functions", "CoshIntegral", "cosine integral", "CosIntegral", 
      "Coulomb wave functions", "critical line for zeta function", 
      "Cunningham functions", "cylindrical symmetry", 
      "differential equations", "diffraction theory", "digamma function", 
      "dilogarithm function", "Dirichlet L-series", "DoublyInfinite", 
      "electrical engineering", "Erf", "Erfc", "Erfi", "error function", 
      "Euler beta function", "Euler gamma function", "Eulers constant", 
      "ExpIntegralE", "ExpIntegralEi", "exponential function", 
      "exponential integrals", "factorial function", "Fermi-Dirac integrals", 
      "Feynman diagram integrals", "FresnelC", "FresnelS", "functions", 
      "gamma", "gamma function", "GammaRegularized", "regularized gamma", 
      "Gaussian distribution", "Gaussian random numbers", "Gauss series", 
      "Gegenbauer functions", "generalized hypergeometric function", 
      "Hankel functions", "HankelH1", "HankelH2", "harmonic sums", 
      "Hermite functions", "Hurwitz zeta function", 
      "hyperbolic cosine integral", "hyperbolic sine integral", 
      "Hypergeometric0F1", "Hypergeometric0F1Regularized", 
      "Hypergeometric1F1", "Hypergeometric1F1Regularized", 
      "Hypergeometric2F1", "Hypergeometric2F1Regularized", 
      "Hypergeometric functions", "HypergeometricPFQ", 
      "HypergeometricPFQRegularized", "HypergeometricU", "Hyperlogarithms", 
      "incomplete beta function", "incomplete gamma function", 
      "integral representations", "InverseBetaRegularized", "InverseErf", 
      "InverseErfc", "InverseGammaRegularized", "Jacobi functions", 
      "Jonquieres function", "KelvinBei", "KelvinBer", "Kelvin functions", 
      "KelvinKei", "KelvinKer", "K-theory", "Kummer function", 
      "Kummer series", "Laguerre functions", "LambertW function", 
      "Legendre functions", "LegendreP", "LegendreQ", "LerchPhi", 
      "Lerch transcendent", "logarithm", "logarithmic integral", "LogGamma", 
      "LogIntegral", "Lseries", "mathematical physics", "MeijerG", 
      "multivariate hypergeometric function", "Neumann function", 
      "Nielsen functions", "number theory", "ParabolicCylinderD", 
      "parabolic cylinder functions", "Pochhammer", "Pochhammer symbol", 
      "Poisson-Charlier polynomials", "PolyGamma", "PolyLog", 
      "polylogarithm functions", "primes", "ProductLog", "psi function", 
      "quantum-mechanical scattering processes", "quantum mechanics", 
      "radial Bessel functions", "Riemann P function", 
      "Riemann-Siegel functions", "RiemannSiegelTheta", "RiemannSiegelZ", 
      "Riemann zeta function", "ring functions", "rising factorial", 
      "sine integral", "SinhIntegral", "SinIntegral", "special functions", 
      "Spence integral", "SphericalBesselJ", "SphericalBesselY", 
      "SphericalHankelH1", "SphericalHankelH2", "statistical mechanics", 
      "statistics", "StieltjesGamma", "StruveH", "StruveL", "sums", 
      "toroidal functions", "transcendental equations", 
      "tree generating function", "Weber functions", "Whittaker functions", 
      "WhittakerM", "WhittakerW", "zeta", "zeta function"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica includes all the common special functions of mathematical \
physics found in standard handbooks. We will discuss each of the various \
classes of functions in turn. One point you should realize is that in the \
technical literature there are often several conflicting definitions of any \
particular special function. When you use a special function in Mathematica, \
therefore, you should be sure to look at the definition given here to confirm \
that it is exactly what you want. Mathematica gives exact results for some \
values of special functions. ", "synonyms" -> {"3.2.11"}, "title" -> 
    "Special Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/SpecialFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.11"->{
  Cell[10613, 197, 82, 2, 70, "Title",
   CellTags->{"S3.2.11", "11.1"},
   CellID->21909]},
 "11.1"->{
  Cell[10613, 197, 82, 2, 70, "Title",
   CellTags->{"S3.2.11", "11.1"},
   CellID->21909]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.11", 292621, 7900},
 {"11.1", 292725, 7904}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 9988, 170, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[10613, 197, 82, 2, 70, "Title",
 CellTags->{"S3.2.11", "11.1"},
 CellID->21909],
Cell[10698, 201, 261, 7, 70, "Text",
 CellID->27841],
Cell[10962, 210, 405, 9, 70, "Text",
 CellID->20130],
Cell[11370, 221, 161, 5, 70, "MathCaption",
 CellID->9090],
Cell[CellGroupData[{
Cell[11556, 230, 121, 4, 28, "Input",
 CellID->9034],
Cell[11680, 236, 221, 8, 56, "Output",
 CellID->7915]
}, Open  ]],
Cell[11916, 247, 69, 1, 70, "MathCaption",
 CellID->6286],
Cell[CellGroupData[{
Cell[12010, 252, 121, 4, 28, "Input",
 CellID->3523],
Cell[12134, 258, 208, 7, 51, "Output",
 CellID->20666]
}, Open  ]],
Cell[12357, 268, 117, 3, 70, "MathCaption",
 CellID->1344],
Cell[CellGroupData[{
Cell[12499, 275, 118, 4, 28, "Input",
 CellID->32736],
Cell[12620, 281, 221, 6, 36, "Output",
 CellID->22037]
}, Open  ]],
Cell[12856, 290, 91, 1, 70, "MathCaption",
 CellID->5416],
Cell[CellGroupData[{
Cell[12972, 295, 165, 6, 70, "Input",
 CellID->5893],
Cell[13140, 303, 272, 7, 36, "Output",
 CellID->1949]
}, Open  ]],
Cell[13427, 313, 118, 3, 70, "MathCaption",
 CellID->30971],
Cell[CellGroupData[{
Cell[13570, 320, 230, 8, 70, "Input",
 CellID->10844],
Cell[13803, 330, 384, 15, 56, "Output",
 CellID->22777]
}, Open  ]],
Cell[14202, 348, 175, 5, 70, "MathCaption",
 CellID->19285],
Cell[CellGroupData[{
Cell[14402, 357, 199, 7, 70, "Input",
 CellID->26200],
Cell[14604, 366, 441, 15, 36, "Output",
 CellID->14590]
}, Open  ]],
Cell[15060, 384, 227, 8, 70, "MathCaption",
 CellID->10285],
Cell[CellGroupData[{
Cell[15312, 396, 233, 8, 70, "Input",
 CellID->28325],
Cell[15548, 406, 223, 7, 36, "Output",
 CellID->17118]
}, Open  ]],
Cell[15786, 416, 669, 13, 70, "Text",
 CellID->25668],
Cell[16458, 431, 1136, 33, 70, "Text",
 CellID->10006],
Cell[CellGroupData[{
Cell[17619, 468, 61, 1, 70, "Section",
 CellID->9729],
Cell[17683, 471, 5587, 177, 70, "DefinitionBox",
 CellID->24008],
Cell[23273, 650, 63, 1, 70, "Caption",
 CellID->14541],
Cell[23339, 653, 1247, 45, 70, "Text",
 CellID->225],
Cell[24589, 700, 986, 29, 70, "Text",
 CellID->15536],
Cell[25578, 731, 997, 37, 70, "Text",
 CellID->11980],
Cell[26578, 770, 1047, 35, 70, "Text",
 CellID->716],
Cell[27628, 807, 1478, 55, 70, "Text",
 CellID->30470],
Cell[29109, 864, 534, 20, 70, "Text",
 CellID->15384],
Cell[29646, 886, 1411, 51, 70, "Text",
 CellID->28747],
Cell[31060, 939, 1842, 59, 70, "Text",
 CellID->20328],
Cell[32905, 1000, 1285, 46, 70, "Text",
 CellID->27936],
Cell[34193, 1048, 1426, 47, 70, "Text",
 CellID->6204],
Cell[35622, 1097, 2517, 90, 70, "Text",
 CellID->10700],
Cell[38142, 1189, 177, 6, 70, "MathCaption",
 CellID->7523],
Cell[CellGroupData[{
Cell[38344, 1199, 102, 3, 70, "Input",
 CellID->26364],
Cell[38449, 1204, 210, 7, 51, "Output",
 CellID->1411]
}, Open  ]],
Cell[38674, 1214, 114, 3, 70, "MathCaption",
 CellID->16040],
Cell[38791, 1219, 458, 15, 70, "Input",
 CellID->250]
}, Open  ]],
Cell[CellGroupData[{
Cell[39286, 1239, 61, 1, 70, "Section",
 CellID->11504],
Cell[39350, 1242, 4635, 153, 70, "DefinitionBox",
 CellID->23483],
Cell[43988, 1397, 63, 1, 70, "Caption",
 CellID->21766],
Cell[44054, 1400, 904, 31, 70, "Text",
 CellID->16141],
Cell[44961, 1433, 629, 18, 70, "Text",
 CellID->2670],
Cell[45593, 1453, 1718, 60, 70, "Text",
 CellID->10845],
Cell[47314, 1515, 1076, 38, 70, "Text",
 CellID->10506],
Cell[48393, 1555, 1007, 37, 70, "Text",
 CellID->9088],
Cell[49403, 1594, 1635, 57, 70, "Text",
 CellID->67327082],
Cell[51041, 1653, 270, 11, 70, "MathCaption",
 CellID->23256],
Cell[CellGroupData[{
Cell[51336, 1668, 97, 3, 70, "Input",
 CellID->25107],
Cell[51436, 1673, 204, 7, 54, "Output",
 CellID->8266]
}, Open  ]],
Cell[51655, 1683, 143, 4, 70, "MathCaption",
 CellID->5857],
Cell[CellGroupData[{
Cell[51823, 1691, 392, 13, 70, "Input",
 CellID->29683575],
Cell[52218, 1706, 90449, 1487, 70, "Output",
 Evaluatable->False,
 CellID->694014210]
}, Open  ]],
Cell[142682, 3196, 326, 9, 70, "MathCaption",
 CellID->12674],
Cell[CellGroupData[{
Cell[143033, 3209, 328, 11, 70, "Input",
 CellID->545637444],
Cell[143364, 3222, 10039, 169, 70, "Output",
 Evaluatable->False,
 CellID->375399153]
}, Open  ]],
Cell[153418, 3394, 274, 9, 70, "MathCaption",
 CellID->336838548],
Cell[CellGroupData[{
Cell[153717, 3407, 309, 10, 70, "Input",
 CellID->400115892],
Cell[154029, 3419, 7972, 135, 70, "Output",
 Evaluatable->False,
 CellID->112728935]
}, Open  ]],
Cell[162016, 3557, 3049, 106, 70, "Text",
 CellID->8990],
Cell[165068, 3665, 2016, 69, 70, "Text",
 CellID->29832],
Cell[167087, 3736, 858, 27, 70, "Text",
 CellID->30858],
Cell[167948, 3765, 1367, 43, 70, "Text",
 CellID->10996],
Cell[169318, 3810, 892, 32, 70, "Text",
 CellID->8917],
Cell[170213, 3844, 1533, 49, 70, "DefinitionBox",
 CellID->395097913],
Cell[171749, 3895, 67, 1, 70, "Caption",
 CellID->155827115],
Cell[171819, 3898, 374, 13, 70, "MathCaption",
 CellID->20883269],
Cell[CellGroupData[{
Cell[172218, 3915, 133, 4, 70, "Input",
 CellID->7518628],
Cell[172354, 3921, 158, 5, 36, "Output",
 CellID->158943822]
}, Open  ]],
Cell[172527, 3929, 74, 1, 70, "MathCaption",
 CellID->539987862],
Cell[CellGroupData[{
Cell[172626, 3934, 132, 4, 70, "Input",
 CellID->106173321],
Cell[172761, 3940, 257, 7, 36, "Output",
 CellID->174189602]
}, Open  ]],
Cell[173033, 3950, 96, 1, 70, "MathCaption",
 CellID->10904015],
Cell[CellGroupData[{
Cell[173154, 3955, 157, 5, 70, "Input",
 CellID->473886493],
Cell[173314, 3962, 257, 7, 36, "Output",
 CellID->677447989]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[173620, 3975, 77, 1, 70, "Section",
 CellID->28290],
Cell[173700, 3978, 2916, 93, 70, "DefinitionBox",
 CellID->3967],
Cell[176619, 4073, 78, 1, 70, "Caption",
 CellID->1707],
Cell[176700, 4076, 407, 15, 70, "Text",
 CellID->8234],
Cell[177110, 4093, 751, 29, 70, "Text",
 CellID->28246],
Cell[177864, 4124, 858, 31, 70, "Text",
 CellID->11462],
Cell[178725, 4157, 1683, 57, 70, "Text",
 CellID->19402],
Cell[180411, 4216, 2400, 88, 70, "Text",
 CellID->8239]
}, Open  ]],
Cell[CellGroupData[{
Cell[182848, 4309, 70, 1, 70, "Section",
 CellID->3426],
Cell[182921, 4312, 3061, 102, 70, "DefinitionBox",
 CellID->19095],
Cell[185985, 4416, 73, 1, 70, "Caption",
 CellID->30906],
Cell[186061, 4419, 2320, 86, 70, "Text",
 CellID->8314],
Cell[188384, 4507, 680, 22, 70, "Text",
 CellID->10350],
Cell[189067, 4531, 1241, 45, 70, "Text",
 CellID->4586]
}, Open  ]],
Cell[CellGroupData[{
Cell[190345, 4581, 62, 1, 70, "Section",
 CellID->5279],
Cell[190410, 4584, 8814, 287, 70, "DefinitionBox",
 CellID->17776],
Cell[199227, 4873, 65, 1, 70, "Caption",
 CellID->25822],
Cell[199295, 4876, 1527, 58, 70, "Text",
 CellID->6879],
Cell[200825, 4936, 137, 4, 70, "Text",
 CellID->32301],
Cell[200965, 4942, 765, 31, 70, "Text",
 CellID->15812],
Cell[201733, 4975, 1116, 41, 70, "Text",
 CellID->5676],
Cell[202852, 5018, 2572, 95, 70, "Text",
 CellID->3164],
Cell[205427, 5115, 1714, 66, 70, "Text",
 CellID->7357],
Cell[207144, 5183, 2115, 79, 70, "Text",
 CellID->32570],
Cell[209262, 5264, 1890, 63, 70, "Text",
 CellID->6038],
Cell[211155, 5329, 2048, 71, 70, "Text",
 CellID->24312],
Cell[213206, 5402, 302, 10, 70, "MathCaption",
 CellID->10144],
Cell[CellGroupData[{
Cell[213533, 5416, 278, 9, 70, "Input",
 CellID->519444637],
Cell[213814, 5427, 4382, 76, 70, "Output",
 Evaluatable->False,
 CellID->721768932]
}, Open  ]],
Cell[218211, 5506, 191, 6, 70, "MathCaption",
 CellID->18200],
Cell[CellGroupData[{
Cell[218427, 5516, 147, 5, 70, "Input",
 CellID->30643],
Cell[218577, 5523, 393, 15, 65, "Output",
 CellID->21856]
}, Open  ]],
Cell[218985, 5541, 296, 6, 70, "MathCaption",
 CellID->18061],
Cell[CellGroupData[{
Cell[219306, 5551, 239, 8, 70, "Input",
 CellID->83513533],
Cell[219548, 5561, 7001, 119, 70, "Output",
 Evaluatable->False,
 CellID->128556739]
}, Open  ]],
Cell[226564, 5683, 5109, 173, 70, "DefinitionBox",
 CellID->6056027],
Cell[231676, 5858, 75, 1, 70, "Caption",
 CellID->155351773],
Cell[231754, 5861, 411, 15, 70, "MathCaption",
 CellID->30941568],
Cell[CellGroupData[{
Cell[232190, 5880, 190, 6, 70, "Input",
 CellID->88935959],
Cell[232383, 5888, 158, 5, 36, "Output",
 CellID->93368954]
}, Open  ]],
Cell[232556, 5896, 74, 1, 70, "MathCaption",
 CellID->84534790],
Cell[CellGroupData[{
Cell[232655, 5901, 160, 5, 70, "Input",
 CellID->665272608],
Cell[232818, 5908, 177, 5, 36, "Output",
 CellID->118262280]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[233044, 5919, 65, 1, 70, "Section",
 CellID->19808],
Cell[233112, 5922, 2106, 67, 70, "DefinitionBox",
 CellID->9290],
Cell[235221, 5991, 67, 1, 70, "Caption",
 CellID->17452],
Cell[235291, 5994, 2713, 97, 70, "Text",
 CellID->979],
Cell[238007, 6093, 130, 4, 70, "Text",
 CellID->32618],
Cell[238140, 6099, 2579, 79, 70, "DefinitionBox",
 CellID->21419],
Cell[240722, 6180, 142, 5, 70, "Caption",
 CellID->24007],
Cell[240867, 6187, 1246, 45, 70, "Text",
 CellID->22284],
Cell[242116, 6234, 696, 25, 70, "Text",
 CellID->24547],
Cell[242815, 6261, 583, 22, 70, "Text",
 CellID->29977],
Cell[243401, 6285, 576, 19, 70, "Text",
 CellID->15675],
Cell[243980, 6306, 617, 19, 70, "Text",
 CellID->18613]
}, Open  ]],
Cell[CellGroupData[{
Cell[244634, 6330, 79, 1, 70, "Section",
 CellID->12516],
Cell[244716, 6333, 4746, 149, 70, "DefinitionBox",
 CellID->13371],
Cell[249465, 6484, 93, 1, 70, "Caption",
 CellID->28642],
Cell[249561, 6487, 478, 16, 70, "Text",
 CellID->16339],
Cell[250042, 6505, 1789, 59, 70, "Text",
 CellID->6336],
Cell[251834, 6566, 1090, 38, 70, "Text",
 CellID->32621],
Cell[252927, 6606, 345, 10, 70, "Text",
 CellID->21501],
Cell[253275, 6618, 651, 26, 70, "Text",
 CellID->26034],
Cell[253929, 6646, 1218, 43, 70, "Text",
 CellID->18129],
Cell[255150, 6691, 1324, 46, 70, "Text",
 CellID->21358],
Cell[256477, 6739, 889, 29, 70, "Text",
 CellID->1436],
Cell[257369, 6770, 848, 30, 70, "Text",
 CellID->28469],
Cell[258220, 6802, 658, 25, 70, "Text",
 CellID->22897],
Cell[258881, 6829, 2001, 69, 70, "Text",
 CellID->28504],
Cell[260885, 6900, 996, 38, 70, "Text",
 CellID->4798],
Cell[261884, 6940, 1612, 51, 70, "Text",
 CellID->4202],
Cell[263499, 6993, 908, 36, 70, "Text",
 CellID->23105],
Cell[264410, 7031, 930, 32, 70, "Text",
 CellID->1238],
Cell[265343, 7065, 1021, 36, 70, "Text",
 CellID->15032],
Cell[266367, 7103, 268, 9, 70, "Text",
 CellID->20065],
Cell[266638, 7114, 6212, 197, 70, "DefinitionBox",
 CellID->14481],
Cell[272853, 7313, 81, 1, 70, "Caption",
 CellID->15579],
Cell[272937, 7316, 1687, 58, 70, "Text",
 CellID->9023],
Cell[274627, 7376, 1091, 37, 70, "Text",
 CellID->1727],
Cell[275721, 7415, 280, 10, 70, "Text",
 CellID->1771],
Cell[276004, 7427, 431, 12, 70, "Text",
 CellID->31313],
Cell[276438, 7441, 336, 12, 70, "Text",
 CellID->10382],
Cell[276777, 7455, 1955, 71, 70, "Text",
 CellID->6140],
Cell[278735, 7528, 4112, 133, 70, "Text",
 CellID->24816],
Cell[282850, 7663, 1617, 54, 70, "Text",
 CellID->28488]
}, Open  ]],
Cell[CellGroupData[{
Cell[284504, 7722, 59, 1, 70, "Section",
 CellID->15319],
Cell[284566, 7725, 667, 20, 70, "DefinitionBox",
 CellID->5589],
Cell[285236, 7747, 59, 1, 70, "Caption",
 CellID->5513],
Cell[285298, 7750, 787, 24, 70, "Text",
 CellID->18259],
Cell[CellGroupData[{
Cell[286110, 7778, 71, 1, 70, "RelatedTutorialsSection",
 CellID->35497276],
Cell[286184, 7781, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[286398, 7790, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

