(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17535,        588]
NotebookOptionsPosition[     12226,        447]
NotebookOutlinePosition[     16032,        531]
CellTagsIndexPosition[     15941,        525]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Expressions" :> 
         Documentation`HelpLookup["paclet:tutorial/ExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Expressions\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Special Ways to Input Expressions", "Title",
 CellTags->{"S2.1.3", "3.1"},
 CellID->3012],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to use special notation for many common operators. For example, \
although internally ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents a sum of two terms as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", you can enter this expression in the much more convenient form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->3184],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language has a definite grammar which specifies how your input should be \
converted to internal form. One aspect of the grammar is that it specifies \
how pieces of your input should be grouped. For example, if you enter an \
expression such as ",
 Cell[BoxData[
  RowBox[{"a", "+", 
   RowBox[{"b", "^", "c"}]}]], "InlineFormula"],
 ", the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " grammar specifies that this should be considered, following standard \
mathematical notation, as ",
 Cell[BoxData[
  RowBox[{"a", "+", 
   RowBox[{"(", 
    RowBox[{"b", "^", "c"}], ")"}]}]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "^", "c"}]], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " chooses this grouping because it treats the operator ",
 Cell[BoxData["^"], "InlineFormula"],
 " as having a higher ",
 StyleBox["precedence",
  FontSlant->"Italic"],
 " than ",
 Cell[BoxData["+"], "InlineFormula"],
 ". In general, the arguments of operators with higher precedence are grouped \
before those of operators with lower precedence. "
}], "Text",
 CellID->21759],

Cell[TextData[{
 "You should realize that absolutely every special input form in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is assigned a definite precedence. This includes not only the traditional \
mathematical operators, but also forms such as ",
 Cell[BoxData["->"], "InlineFormula"],
 ", ",
 Cell[BoxData[":="], "InlineFormula"],
 " or the semicolons used to separate expressions in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program. "
}], "Text",
 CellID->23501],

Cell[TextData[{
 "The table in\[NonBreakingSpace]\"",
 ButtonBox["Operator Input Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#23301"],
 "\" gives all the operators of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in order of decreasing precedence. The precedence is arranged, where \
possible, to follow standard mathematical usage, and to minimize the number \
of parentheses that are usually needed. "
}], "Text",
 CellID->9574],

Cell[TextData[{
 "You will find, for example, that relational operators such as ",
 Cell[BoxData["<"], "InlineFormula"],
 " have lower precedence than arithmetic operators such as ",
 Cell[BoxData["+"], "InlineFormula"],
 ". This means that you can write expressions such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "+", "y"}], ">", "7"}]], "InlineFormula"],
 " without using parentheses. "
}], "Text",
 CellID->28733],

Cell[TextData[{
 "There are nevertheless many cases where you do have to use parentheses. For \
example, since ",
 Cell[BoxData[";"], "InlineFormula"],
 " has a lower precedence than ",
 Cell[BoxData["="], "InlineFormula"],
 ", you need to use parentheses to write ",
 Cell[BoxData[
  RowBox[{"x", "=", 
   RowBox[{"(", 
    RowBox[{"a", ";", "b"}], ")"}]}]], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interprets the expression \[ThinSpace]",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "=", "a"}], ";", "b"}]], "InlineFormula"],
 " \[ThinSpace]as \[ThinSpace]",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "=", "a"}], ")"}], ";", "b"}]], "InlineFormula"],
 ". In general, it can never hurt to include extra parentheses, but it can \
cause a great deal of trouble if you leave parentheses out, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interprets your input in a way you do not expect. "
}], "Text",
 CellID->5059],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], Cell["\[ThinSpace]", "TableText"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell[TextData[{
     "standard form for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "\[ThinSpace]",
     Cell[BoxData[
      RowBox[{"[", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "@", 
     StyleBox["x", "TI"]}], Cell[TextData[{
     "prefix form for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "\[ThinSpace]",
     Cell[BoxData[
      RowBox[{"[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "//", 
     StyleBox["f", "TI"]}], Cell[TextData[{
     "postfix form for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "\[ThinSpace]",
     Cell[BoxData[
      RowBox[{"[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "~", 
     StyleBox["f", "TI"], "~", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     "infix form for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "\[ThinSpace]",
     Cell[BoxData[
      RowBox[{"[", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27714],

Cell[TextData[{
 "Four ways to write expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->27649],

Cell[TextData[{
 "There are several common types of operators in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The ",
 Cell[BoxData["+"], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "+", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " is an \[OpenCurlyDoubleQuote]infix\[CloseCurlyDoubleQuote] operator. The \
",
 Cell[BoxData["-"], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 " is a \[OpenCurlyDoubleQuote]prefix\[CloseCurlyDoubleQuote] operator. Even \
when you enter an expression such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to do it in ways that mimic infix, prefix and postfix forms."
}], "Text",
 CellID->6595],

Cell[TextData[{
 "This \[OpenCurlyDoubleQuote]postfix form\[CloseCurlyDoubleQuote] is exactly \
equivalent to ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", "+", "y"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "//", "f"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->24541],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", "+", "y"}], "]"}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->20416]
}, Open  ]],

Cell[TextData[{
 "You will often want to add functions like ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " as \[OpenCurlyDoubleQuote]afterthoughts\[CloseCurlyDoubleQuote], and give \
them in postfix form. "
}], "MathCaption",
 CellID->15377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"3", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "4"}], ")"}]}], "+", "1"}], "//", "N"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->1052],

Cell[BoxData["2.3160740129524924`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->565]
}, Open  ]],

Cell["\<\
It is sometimes easier to understand what a function is doing when you write \
it in infix form. \
\>", "MathCaption",
 CellID->19891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "~", "Join", "~", 
  RowBox[{"{", 
   RowBox[{"d", ",", "e"}], "}"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->13310]
}, Open  ]],

Cell[TextData[{
 "You should notice that ",
 Cell[BoxData["//"], "InlineFormula"],
 " has very low precedence. If you put ",
 Cell[BoxData[
  RowBox[{"//", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " at the end of any expression containing arithmetic or logical operators, \
the ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is applied to the ",
 StyleBox["whole expression",
  FontSlant->"Italic"],
 ". So, for example, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "+", "y"}], "//", "f"}]], "InlineFormula"],
 " means ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", "+", "y"}], "]"}]], "InlineFormula"],
 ", not ",
 Cell[BoxData[
  RowBox[{"x", "+", 
   RowBox[{"f", "[", "y", "]"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20967],

Cell[TextData[{
 "The prefix form ",
 Cell[BoxData["@"], "InlineFormula"],
 " has a much higher precedence. ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "@", "x"}], "+", "y"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "+", "y"}]], "InlineFormula"],
 ", not ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", "+", "y"}], "]"}]], "InlineFormula"],
 ". You can write ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", "+", "y"}], "]"}]], "InlineFormula"],
 " in prefix form as ",
 Cell[BoxData[
  RowBox[{"f", "@", 
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15055],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->71860766],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsOverview"]], "RelatedTutorials",
 CellID->323659647]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Special Ways to Input Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Expressions", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/ExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheMeaningOfExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PartsOfExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 1.0918788}", "context" -> "", 
    "keywords" -> {
     "at sign", "binding of operators", "expressions", "functional notation", 
      "grammar of Mathematica", "grouping of input expressions", 
      "infix notation", "input", "input forms", "language specification", 
      "notation", "operators", "parentheses", "Postfix notation", 
      "precedence", "prefix notation", "syntax of Mathematica"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica allows you to use special notation for many common \
operators. For example, although internally Mathematica represents a sum of \
two terms as Plus[x,y], you can enter this expression in the much more \
convenient form x+y. The Mathematica language has a definite grammar which \
specifies how your input should be converted to internal form. One aspect of \
the grammar is that it specifies how pieces of your input should be grouped. \
For example, if you enter an expression such as a+b^c, the Mathematica \
grammar specifies that this should be considered, following standard \
mathematical notation, as a+(b^c) rather than (a+b)^c. Mathematica chooses \
this grouping because it treats the operator ^ as having a higher precedence \
than +. In general, the arguments of operators with higher precedence are \
grouped before those of operators with lower precedence. You should realize \
that absolutely every special input form in Mathematica is assigned a \
definite precedence. This includes not only the traditional mathematical \
operators, but also forms such as ->, := or the semicolons used to separate \
expressions in a Mathematica program. ", "synonyms" -> {"2.1.3"}, "title" -> 
    "Special Ways to Input Expressions", "type" -> "Tutorial", "uri" -> 
    "tutorial/SpecialWaysToInputExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.1.3"->{
  Cell[1224, 42, 95, 2, 70, "Title",
   CellTags->{"S2.1.3", "3.1"},
   CellID->3012]},
 "3.1"->{
  Cell[1224, 42, 95, 2, 70, "Title",
   CellTags->{"S2.1.3", "3.1"},
   CellID->3012]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.1.3", 15732, 514},
 {"3.1", 15830, 518}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 599, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1224, 42, 95, 2, 70, "Title",
 CellTags->{"S2.1.3", "3.1"},
 CellID->3012],
Cell[1322, 46, 667, 23, 70, "Text",
 CellID->3184],
Cell[1992, 71, 1245, 38, 70, "Text",
 CellID->21759],
Cell[3240, 111, 495, 14, 70, "Text",
 CellID->23501],
Cell[3738, 127, 466, 12, 70, "Text",
 CellID->9574],
Cell[4207, 141, 422, 11, 70, "Text",
 CellID->28733],
Cell[4632, 154, 980, 29, 70, "Text",
 CellID->5059],
Cell[5615, 185, 1818, 61, 70, "DefinitionBox",
 CellID->27714],
Cell[7436, 248, 140, 6, 70, "Caption",
 CellID->27649],
Cell[7579, 256, 949, 32, 70, "Text",
 CellID->6595],
Cell[8531, 290, 243, 8, 70, "MathCaption",
 CellID->28522],
Cell[CellGroupData[{
Cell[8799, 302, 113, 4, 70, "Input",
 CellID->24541],
Cell[8915, 308, 205, 7, 36, "Output",
 CellID->20416]
}, Open  ]],
Cell[9135, 318, 305, 9, 70, "MathCaption",
 CellID->15377],
Cell[CellGroupData[{
Cell[9465, 331, 187, 7, 70, "Input",
 CellID->1052],
Cell[9655, 340, 171, 5, 36, "Output",
 CellID->565]
}, Open  ]],
Cell[9841, 348, 144, 4, 70, "MathCaption",
 CellID->19891],
Cell[CellGroupData[{
Cell[10010, 356, 204, 7, 70, "Input",
 CellID->138],
Cell[10217, 365, 230, 7, 36, "Output",
 CellID->13310]
}, Open  ]],
Cell[10462, 375, 768, 28, 70, "Text",
 CellID->20967],
Cell[11233, 405, 688, 26, 70, "Text",
 CellID->15055],
Cell[CellGroupData[{
Cell[11946, 435, 71, 1, 70, "RelatedTutorialsSection",
 CellID->71860766],
Cell[12020, 438, 152, 3, 70, "RelatedTutorials",
 CellID->323659647]
}, Open  ]]
}, Open  ]],
Cell[12199, 445, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

