(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49123,       1676]
NotebookOptionsPosition[     38662,       1350]
NotebookOutlinePosition[     42790,       1439]
CellTagsIndexPosition[     42696,       1433]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndStreamsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Close" :> Documentation`HelpLookup["paclet:ref/Close"], 
          "Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "InputStream" :> Documentation`HelpLookup["paclet:ref/InputStream"],
           "OpenAppend" :> Documentation`HelpLookup["paclet:ref/OpenAppend"], 
          "OpenWrite" :> Documentation`HelpLookup["paclet:ref/OpenWrite"], 
          "Options" :> Documentation`HelpLookup["paclet:ref/Options"], 
          "OutputStream" :> 
          Documentation`HelpLookup["paclet:ref/OutputStream"], "SetOptions" :> 
          Documentation`HelpLookup["paclet:ref/SetOptions"], "Write" :> 
          Documentation`HelpLookup["paclet:ref/Write"], "WriteString" :> 
          Documentation`HelpLookup["paclet:ref/WriteString"], "$Output" :> 
          Documentation`HelpLookup["paclet:ref/$Output"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Close\"\>", 2->"\<\"Export\"\>", 
       3->"\<\"InputStream\"\>", 4->"\<\"OpenAppend\"\>", 
       5->"\<\"OpenWrite\"\>", 6->"\<\"Options\"\>", 
       7->"\<\"OutputStream\"\>", 8->"\<\"SetOptions\"\>", 9->"\<\"Write\"\>",
        10->"\<\"WriteString\"\>", 
       11->"\<\"$Output\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Streams and Low\[Hyphen]Level Input and Output\
\>", "Title",
 CellTags->{"S2.12.3", "3.1"},
 CellID->21617],

Cell[TextData[{
 "Files and pipes are both examples of general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects known as ",
 StyleBox["streams",
  FontSlant->"Italic"],
 ". A stream in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is a source of input or output. There are many operations that you can \
perform on streams. "
}], "Text",
 CellID->29182],

Cell[TextData[{
 "You can think of ",
 Cell[BoxData[">>"], "InlineFormula"],
 " and ",
 Cell[BoxData["<<"], "InlineFormula"],
 " as \[OpenCurlyDoubleQuote]high\[Hyphen]level\[CloseCurlyDoubleQuote] ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input\[Hyphen]output functions. They are based on a set of \
lower\[Hyphen]level input\[Hyphen]output primitives that work directly with \
streams. By using these primitives, you can exercise more control over \
exactly how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does input and output. You will often need to do this, for example, if you \
write ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs which store and retrieve intermediate data from files or pipes. "
}], "Text",
 CellID->19066],

Cell[TextData[{
 "The basic low\[Hyphen]level scheme for writing output to a stream in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is as follows. First, you call ",
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["OpenAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenAppend"]], "InlineFormula"],
 " to \[OpenCurlyDoubleQuote]open the stream\[CloseCurlyDoubleQuote], telling \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that you want to write output to a particular file or external program, \
and in what form the output should be written. Having opened a stream, you \
can then call ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["WriteString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WriteString"]], "InlineFormula"],
 " to write a sequence of expressions or strings to the stream. When you have \
finished, you call ",
 Cell[BoxData[
  ButtonBox["Close",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Close"]], "InlineFormula"],
 " to \[OpenCurlyDoubleQuote]close the stream\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellID->23116],

Cell[BoxData[GridBox[{
   {"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", Cell[
    "a file, specified by name", "TableText"]},
   {"\"\<!\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", Cell[
    "a command, specified by name", "TableText"]},
   {
    RowBox[{
     ButtonBox["InputStream",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputStream"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
     StyleBox["n", "TI"], "]"}], Cell["an input stream", "TableText"]},
   {
    RowBox[{
     ButtonBox["OutputStream",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OutputStream"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
     StyleBox["n", "TI"], "]"}], Cell["an output stream", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6388],

Cell[TextData[{
 "Streams in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->9425],

Cell[TextData[{
 "When you open a file or a pipe, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " creates a \[OpenCurlyDoubleQuote]stream object\[CloseCurlyDoubleQuote] \
that specifies the open stream associated with the file or pipe. In general, \
the stream object contains the name of the file or the external command used \
in a pipe, together with a unique number. "
}], "Text",
 CellID->13101],

Cell["\<\
The reason that the stream object needs to include a unique number is that in \
general you can have several streams connected to the same file or external \
program at the same time. For example, you may start several different \
instances of the same external program, each connected to a different stream. \
\
\>", "Text",
 CellID->5610],

Cell["\<\
Nevertheless, when you have opened a stream, you can still refer to it using \
a simple file name or external command name so long as there is only one \
stream associated with this object. \
\>", "Text",
 CellID->6450],

Cell[TextData[{
 "This opens an output stream to the file ",
 Cell[BoxData["tmp"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stmp", "=", 
  RowBox[{"OpenWrite", "[", "\"\<tmp\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->28621],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"tmp\"\>", ",", "19"}], "]"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->5193]
}, Open  ]],

Cell["This writes a sequence of expressions to the file. ", "MathCaption",
 CellID->27038],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"stmp", ",", "a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->16754],

Cell[TextData[{
 "Since you only have one stream associated with file ",
 Cell[BoxData["tmp"], "InlineFormula"],
 ", you can refer to it simply by giving the name of the file. "
}], "MathCaption",
 CellID->4593],

Cell[BoxData[
 RowBox[{"Write", "[", 
  RowBox[{"\"\<tmp\>\"", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->14895],

Cell["This closes the stream. ", "MathCaption",
 CellID->20280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "stmp", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->5638],

Cell[BoxData["\<\"tmp\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->25167]
}, Open  ]],

Cell["Here is what was written to the file. ", "MathCaption",
 CellID->17420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "tmp", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->4345],

Cell["\<\
abc
x\
\>", "Print",
 CellID->16883]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["OpenWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OpenWrite"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell["\<\
open an output stream to a file, wiping out the previous contents of the file\
\
\>", "TableText"]},
   {
    RowBox[{"OpenWrite", "[", "]"}], 
    RowBox[{
    "open", " ", "an", " ", "output", " ", "stream", " ", "to", " ", "a", " ",
      "new", " ", "temporary", " ", "file", " "}]},
   {
    RowBox[{
     ButtonBox["OpenAppend",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OpenAppend"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell["\<\
open an output stream to a file, appending to what was already in the file\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["OpenWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OpenWrite"], "[", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", "]"}], Cell[
    "open an output stream to an external command", "TableText"]},
   {
    RowBox[{
     ButtonBox["Write",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Write"], "[", 
     StyleBox["stream", "TI"], ",", 
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell["\<\
write a sequence of expressions to a stream, ending the output with a newline \
(line feed)\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["WriteString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WriteString"], "[", 
     StyleBox["stream", "TI"], ",", 
     SubscriptBox[
      StyleBox["str", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["str", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
write a sequence of character strings to a stream, with no extra newlines\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export",
      ButtonNote->"ObsLink: Display -> Export"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["graphics", "TI"], "]"}], Cell["\<\
write graphics or sound output to a stream, in PostScript form\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Close",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Close"], "[", 
     StyleBox["stream", "TI"], "]"}], Cell[TextData[{
     "tell ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " that you are finished with a stream"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23865],

Cell["Low\[Hyphen]level output functions. ", "Caption",
 CellID->24696],

Cell[TextData[{
 "When you call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Write",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Write"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 ", it writes an expression to the specified stream. The default is to write \
the expression in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input form. If you call ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " with a sequence of expressions, it will write these expressions one after \
another to the stream. In general, it leaves no space between the successive \
expressions. However, when it has finished writing all the expressions, ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " always ends its output with a newline. "
}], "Text",
 CellID->30833],

Cell[TextData[{
 "This re\[Hyphen]opens the file ",
 Cell[BoxData["tmp"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stmp", "=", 
  RowBox[{"OpenWrite", "[", "\"\<tmp\>\"", "]"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->22632],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"tmp\"\>", ",", "20"}], "]"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->20189]
}, Open  ]],

Cell["\<\
This writes a sequence of expressions to the file, then closes the file. \
\>", "MathCaption",
 CellID->17839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"stmp", ",", 
    RowBox[{"a", "^", "2"}], ",", 
    RowBox[{"1", "+", 
     RowBox[{"b", "^", "2"}]}]}], "]"}], ";", 
  RowBox[{"Write", "[", 
   RowBox[{"stmp", ",", 
    RowBox[{"c", "^", "3"}]}], "]"}], ";", 
  RowBox[{"Close", "[", "stmp", "]"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->20183],

Cell[BoxData["\<\"tmp\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->13817]
}, Open  ]],

Cell[TextData[{
 "All the expressions are written in input form. The expressions from a \
single ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " are put on the same line. "
}], "MathCaption",
 CellID->22129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<tmp\>\"", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->6753],

Cell["\<\
a^21 + b^2
c^3\
\>", "Print",
 CellID->10679]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " provides a way of writing out complete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. Sometimes, however, you may want to write out less structured \
data. ",
 Cell[BoxData[
  ButtonBox["WriteString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WriteString"]], "InlineFormula"],
 " allows you to write out any character string. Unlike ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["WriteString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WriteString"]], "InlineFormula"],
 " adds no newlines or other characters. "
}], "Text",
 CellID->18613],

Cell["This opens the stream. ", "MathCaption",
 CellID->10600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stmp", "=", 
  RowBox[{"OpenWrite", "[", "\"\<tmp\>\"", "]"}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->8252],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"tmp\"\>", ",", "21"}], "]"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->15145]
}, Open  ]],

Cell["This writes two strings to the stream. ", "MathCaption",
 CellID->19861],

Cell[BoxData[
 RowBox[{"WriteString", "[", 
  RowBox[{
  "stmp", ",", "\"\<Arbitrary output.\\n\>\"", ",", "\"\<More output.\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->2151],

Cell["This writes another string, then closes the stream. ", "MathCaption",
 CellID->28318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteString", "[", 
   RowBox[{"stmp", ",", "\"\< Second line.\\n\>\""}], "]"}], ";", 
  RowBox[{"Close", "[", "stmp", "]"}]}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->28963],

Cell[BoxData["\<\"tmp\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->7813]
}, Open  ]],

Cell["\<\
Here are the contents of the file. The strings were written exactly as \
specified, including only the newlines that were explicitly given. \
\>", "MathCaption",
 CellID->14907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "tmp", "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->29554],

Cell["\<\
Arbitrary output.
More output.  Second line.\
\>", "Print",
 CellID->31476]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Write",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Write"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["stream", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["stream", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "write expressions to a list of streams", "TableText"]},
   {
    RowBox[{
     ButtonBox["WriteString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WriteString"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["stream", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["stream", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      SubscriptBox[
       StyleBox["str", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["write strings to a list of streams", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->617],

Cell["Writing output to lists of streams. ", "Caption",
 CellID->11211],

Cell[TextData[{
 "An important feature of the functions ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WriteString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WriteString"]], "InlineFormula"],
 " is that they allow you to write output not just to a single stream, but \
also to a list of streams. "
}], "Text",
 CellID->25429],

Cell[TextData[{
 "In using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it is often convenient to define a ",
 StyleBox["channel",
  FontSlant->"Italic"],
 " which consists of a list of streams. You can then simply tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to write to the channel, and have it automatically write the same object \
to several streams. "
}], "Text",
 CellID->2264],

Cell[TextData[{
 "In a standard interactive ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, there are several output channels that are usually defined. These \
specify where particular kinds of output should be sent. Thus, for example, \
",
 Cell[BoxData[
  ButtonBox["$Output",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Output"]], "InlineFormula"],
 " specifies where standard output should go, while ",
 Cell[BoxData[
  ButtonBox["$Messages",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Messages"]], "InlineFormula"],
 " specifies where messages should go. The function ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " then works essentially by calling ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " with the ",
 Cell[BoxData[
  ButtonBox["$Output",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Output"]], "InlineFormula"],
 " channel. ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " works in the same way by calling ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " with the ",
 Cell[BoxData[
  ButtonBox["$Messages",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Messages"]], "InlineFormula"],
 " channel.\[NonBreakingSpace]\"",
 ButtonBox["The Main Loop",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheMainLoop"],
 "\" lists the channels used in a typical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->15966],

Cell[TextData[{
 "Note that when you run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " through ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", a different approach is usually used. All output is typically written to \
a single ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link, but each piece of output appears in a \[OpenCurlyDoubleQuote]packet\
\[CloseCurlyDoubleQuote] which indicates what type it is. "
}], "Text",
 CellID->19531],

Cell[TextData[{
 "In most cases, the names of files or external commands that you use in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " correspond exactly with those used by your computer\[CloseCurlyQuote]s \
operating system. On some systems, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports various streams with special names. "
}], "Text",
 CellID->29942],

Cell[BoxData[GridBox[{
   {"\"\<stdout\>\"", Cell["standard output", "TableText"]},
   {"\"\<stderr\>\"", Cell["standard error", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10698],

Cell["Special streams used on some computer systems. ", "Caption",
 CellID->19522],

Cell[TextData[{
 "The special stream ",
 Cell[BoxData["\"\<stdout\>\""], "InlineFormula"],
 " allows you to give output to the \[OpenCurlyDoubleQuote]standard output\
\[CloseCurlyDoubleQuote] provided by the operating system. Note however that \
you can use this stream only with simple text\[Hyphen]based interfaces to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If your interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is more complicated, then this stream will not work, and trying to use it \
may cause considerable trouble. "
}], "Text",
 CellID->31155],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["InputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputForm"], Cell[
    "the default output format to use", "TableText"]},
   {
    ButtonBox["PageWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageWidth"], "78", Cell[
    "the width of the page in characters", "TableText"]},
   {
    ButtonBox["NumberMarks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberMarks"], 
    ButtonBox["$NumberMarks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$NumberMarks"], Cell[TextData[{
     "whether to include ",
     Cell[BoxData["`"], "InlineFormula"],
     " marks in approximate numbers"
    }], "TableText"]},
   {
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], 
    ButtonBox["$CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$CharacterEncoding"], Cell[
    "encoding to be used for special characters", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.3], 
     Scaled[0.25], {
      Scaled[0.45]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->27587],

Cell["Some options for output streams. ", "Caption",
 CellID->15257],

Cell[TextData[{
 "You can associate a number of options with output streams. You can specify \
these options when you first open a stream using ",
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["OpenAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenAppend"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->23158],

Cell[TextData[{
 "This opens a stream, specifying that the default output format used should \
be ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stmp", "=", 
  RowBox[{"OpenWrite", "[", 
   RowBox[{"\"\<tmp\>\"", ",", 
    RowBox[{"FormatType", "->", "OutputForm"}]}], "]"}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->13762],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"tmp\"\>", ",", "22"}], "]"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->8510]
}, Open  ]],

Cell["\<\
This writes expressions to the stream, then closes the stream. \
\>", "MathCaption",
 CellID->30946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"stmp", ",", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], ",", "\"\< \>\"", ",", 
    RowBox[{"z", "^", "2"}]}], "]"}], ";", 
  RowBox[{"Close", "[", "stmp", "]"}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->31065],

Cell[BoxData["\<\"tmp\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->8380]
}, Open  ]],

Cell[TextData[{
 "The expressions were written to the stream in ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "tmp", "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->5946],

Cell["\<\
 2    2       2
x  + y       z\
\>", "Print",
 CellID->13540]
}, Open  ]],

Cell[TextData[{
 "Note that you can always override the output format specified for a \
particular stream by wrapping a particular expression you write to the stream \
with an explicit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " format directive, such as ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27297],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["PageWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageWidth"]], "InlineFormula"],
 " gives the width of the page available for textual output from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". All lines of output are broken so that they fit in this width. If you do \
not want any lines to be broken, you can set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PageWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageWidth"], "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ". Usually, however, you will want to set ",
 Cell[BoxData[
  ButtonBox["PageWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageWidth"]], "InlineFormula"],
 " to the value appropriate for your particular output device. On many \
systems, you will have to run an external program to find out what this value \
is. Using ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 ", you can make the default rule for ",
 Cell[BoxData[
  ButtonBox["PageWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageWidth"]], "InlineFormula"],
 " be, for example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PageWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageWidth"], ":>", 
   RowBox[{"<<", "\"\<!devicewidth\>\""}]}]], "InlineFormula"],
 ", so that an external program is run automatically to find the value of the \
option. "
}], "Text",
 CellID->8042],

Cell["\<\
This opens a stream, specifying that the page width is 20 characters. \
\>", "MathCaption",
 CellID->14464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stmp", "=", 
  RowBox[{"OpenWrite", "[", 
   RowBox[{"\"\<tmp\>\"", ",", 
    RowBox[{"PageWidth", "->", "20"}]}], "]"}]}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->23194],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"tmp\"\>", ",", "23"}], "]"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->12584]
}, Open  ]],

Cell["This writes out an expression, then closes the stream. ", "MathCaption",
 CellID->10270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"stmp", ",", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], "^", "5"}], "]"}]}], "]"}], ";", 
  RowBox[{"Close", "[", "stmp", "]"}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->32715],

Cell[BoxData["\<\"tmp\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->32200]
}, Open  ]],

Cell["\<\
The lines in the expression written out are all broken so as to be at most 20 \
characters long. \
\>", "MathCaption",
 CellID->1206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "tmp", "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->32106],

Cell["\<\
1 + 5*x + 10*x^2 + 
 10*x^3 + 5*x^4 + 
 x^5\
\>", "Print",
 CellID->31302]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 " allows you to specify a character encoding that will be used for all \
strings",
 " ",
 "which are sent to a particular output stream, whether by ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["WriteString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WriteString"]], "InlineFormula"],
 ". You will typically need to use ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 " if you want to modify an international character set, or prevent a \
particular output device from receiving characters that it cannot handle. "
}], "Text",
 CellID->8833],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["stream", "TI"], "]"}], Cell[
    "find the options that have been set for a stream", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetOptions"], "[", 
     StyleBox["stream", "TI"], ",", 
     SubscriptBox[
      StyleBox["opt", "TI"], "1"], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], "1"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "reset options for an open stream", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7611],

Cell["Manipulating options of streams. ", "Caption",
 CellID->19067],

Cell["This opens a stream with the default settings for options. ", \
"MathCaption",
 CellID->415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stmp", "=", 
  RowBox[{"OpenWrite", "[", "\"\<tmp\>\"", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104032922],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"tmp\"\>", ",", "4"}], "]"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->762616275]
}, Open  ]],

Cell[TextData[{
 "This changes the ",
 Cell[BoxData[
  ButtonBox["FormatType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FormatType"]], "InlineFormula"],
 " option for the open stream. "
}], "MathCaption",
 CellID->6354],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"stmp", ",", 
    RowBox[{"FormatType", "->", "TeXForm"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->430576362],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 " shows the options you have set for the open stream. "
}], "MathCaption",
 CellID->24919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "stmp", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->69906334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BinaryFormat", "\[Rule]", "False"}], ",", 
   RowBox[{"FormatType", "\[Rule]", "TeXForm"}], ",", 
   RowBox[{"PageWidth", "\[Rule]", "78"}], ",", 
   RowBox[{"PageHeight", "\[Rule]", "22"}], ",", 
   RowBox[{"TotalWidth", "\[Rule]", "\[Infinity]"}], ",", 
   RowBox[{"TotalHeight", "\[Rule]", "\[Infinity]"}], ",", 
   RowBox[{"CharacterEncoding", "\[RuleDelayed]", "Automatic"}], ",", 
   RowBox[{"NumberMarks", "\[RuleDelayed]", "$NumberMarks"}]}], 
  "}"}]], "Output",
 ImageSize->{440, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->641920935]
}, Open  ]],

Cell["This closes the stream again. ", "MathCaption",
 CellID->26321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "stmp", "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->7592],

Cell[BoxData["\<\"tmp\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->31597]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     ButtonBox["$Output",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$Output"], "]"}], Cell[TextData[{
     "find the options set for all streams in the channel ",
     Cell[BoxData[
      ButtonBox["$Output",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Output"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetOptions"], "[", 
     ButtonBox["$Output",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$Output"], ",", 
     SubscriptBox[
      StyleBox["opt", "TI"], "1"], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], "1"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "set options for all streams in the channel ",
     Cell[BoxData[
      ButtonBox["$Output",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Output"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22197],

Cell["Manipulating options for the standard output channel. ", "Caption",
 CellID->13509],

Cell[TextData[{
 "At every point in your session, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " maintains a list ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Streams",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Streams"], "[", "]"}]], "InlineFormula"],
 " of all the input and output streams that are currently open, together with \
their options. In some cases, you may find it useful to look at this list \
directly. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not, however, allow you to modify the list, except indirectly through \
",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 " and so on. "
}], "Text",
 CellID->8652],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->298897299],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Streams and Low-Level Input and Output - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ExternalPrograms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NamingAndFindingFiles"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 2.7950474}", "context" -> "", 
    "keywords" -> {
     "breaking", "channels", "CharacterEncoding", "characters", "close", 
      "devices", "display", "display parameters", "expressions", "files", 
      "format", "FormatType", "input", "InputStream", 
      "international characters", "IO primitives", "I/O", "line length", 
      "lines", "message", "names", "NumberMarks", "OpenAppend", "OpenWrite", 
      "output", "OutputStream", "packets", "PageWidth", "pipes", "print", 
      "raw output", "reset medium", "serial number", "standard error stream", 
      "standard output stream", "stderr", "stdout", "streams", "termcap", 
      "terminals", "verbatim output", "width", "window size", "write", 
      "WriteString"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Files and pipes are both examples of general Mathematica objects known \
as streams. A stream in Mathematica is a source of input or output. There are \
many operations that you can perform on streams. You can think of >> and << \
as 'high-level' Mathematica input-output functions. They are based on a set \
of lower-level input-output primitives that work directly with streams. By \
using these primitives, you can exercise more control over exactly how \
Mathematica does input and output. You will often need to do this, for \
example, if you write Mathematica programs which store and retrieve \
intermediate data from files or pipes. The basic low-level scheme for writing \
output to a stream in Mathematica is as follows. First, you call OpenWrite or \
OpenAppend to 'open the stream', telling Mathematica that you want to write \
output to a particular file or external program, and in what form the output \
should be written. Having opened a stream, you can then call Write or \
WriteString to write a sequence of expressions or strings to the stream. When \
you have finished, you call Close to 'close the stream'. ", 
    "synonyms" -> {"2.12.3"}, "title" -> 
    "Streams and Low-Level Input and Output", "type" -> "Tutorial", "uri" -> 
    "tutorial/StreamsAndLowLevelInputAndOutput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.3"->{
  Cell[2825, 73, 118, 4, 70, "Title",
   CellTags->{"S2.12.3", "3.1"},
   CellID->21617]},
 "3.1"->{
  Cell[2825, 73, 118, 4, 70, "Title",
   CellTags->{"S2.12.3", "3.1"},
   CellID->21617]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.3", 42481, 1422},
 {"3.1", 42582, 1426}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2200, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2825, 73, 118, 4, 70, "Title",
 CellTags->{"S2.12.3", "3.1"},
 CellID->21617],
Cell[2946, 79, 376, 13, 70, "Text",
 CellID->29182],
Cell[3325, 94, 772, 20, 70, "Text",
 CellID->19066],
Cell[4100, 116, 1294, 38, 70, "Text",
 CellID->23116],
Cell[5397, 156, 1075, 29, 70, "DefinitionBox",
 CellID->6388],
Cell[6475, 187, 116, 6, 70, "Caption",
 CellID->9425],
Cell[6594, 195, 407, 9, 70, "Text",
 CellID->13101],
Cell[7004, 206, 350, 7, 70, "Text",
 CellID->5610],
Cell[7357, 215, 229, 5, 70, "Text",
 CellID->6450],
Cell[7589, 222, 141, 5, 70, "MathCaption",
 CellID->19982],
Cell[CellGroupData[{
Cell[7755, 231, 138, 4, 70, "Input",
 CellID->28621],
Cell[7896, 237, 227, 7, 36, "Output",
 CellID->5193]
}, Open  ]],
Cell[8138, 247, 90, 1, 70, "MathCaption",
 CellID->27038],
Cell[8231, 250, 144, 4, 70, "Input",
 CellID->16754],
Cell[8378, 256, 211, 5, 70, "MathCaption",
 CellID->4593],
Cell[8592, 263, 131, 4, 70, "Input",
 CellID->14895],
Cell[8726, 269, 63, 1, 70, "MathCaption",
 CellID->20280],
Cell[CellGroupData[{
Cell[8814, 274, 100, 3, 70, "Input",
 CellID->5638],
Cell[8917, 279, 165, 5, 36, "Output",
 CellID->25167]
}, Open  ]],
Cell[9097, 287, 77, 1, 70, "MathCaption",
 CellID->17420],
Cell[CellGroupData[{
Cell[9199, 292, 103, 3, 70, "Input",
 CellID->4345],
Cell[9305, 297, 46, 4, 70, "Print",
 CellID->16883]
}, Open  ]],
Cell[9366, 304, 3061, 92, 70, "DefinitionBox",
 CellID->23865],
Cell[12430, 398, 71, 1, 70, "Caption",
 CellID->24696],
Cell[12504, 401, 962, 28, 70, "Text",
 CellID->30833],
Cell[13469, 431, 132, 5, 70, "MathCaption",
 CellID->10390],
Cell[CellGroupData[{
Cell[13626, 440, 138, 4, 70, "Input",
 CellID->22632],
Cell[13767, 446, 228, 7, 36, "Output",
 CellID->20189]
}, Open  ]],
Cell[14010, 456, 120, 3, 70, "MathCaption",
 CellID->17839],
Cell[CellGroupData[{
Cell[14155, 463, 363, 12, 70, "Input",
 CellID->20183],
Cell[14521, 477, 165, 5, 36, "Output",
 CellID->13817]
}, Open  ]],
Cell[14701, 485, 278, 9, 70, "MathCaption",
 CellID->22129],
Cell[CellGroupData[{
Cell[15004, 498, 111, 3, 70, "Input",
 CellID->6753],
Cell[15118, 503, 55, 4, 70, "Print",
 CellID->10679]
}, Open  ]],
Cell[15188, 510, 811, 26, 70, "Text",
 CellID->18613],
Cell[16002, 538, 62, 1, 70, "MathCaption",
 CellID->10600],
Cell[CellGroupData[{
Cell[16089, 543, 137, 4, 70, "Input",
 CellID->8252],
Cell[16229, 549, 228, 7, 36, "Output",
 CellID->15145]
}, Open  ]],
Cell[16472, 559, 78, 1, 70, "MathCaption",
 CellID->19861],
Cell[16553, 562, 192, 6, 70, "Input",
 CellID->2151],
Cell[16748, 570, 91, 1, 70, "MathCaption",
 CellID->28318],
Cell[CellGroupData[{
Cell[16864, 575, 213, 6, 70, "Input",
 CellID->28963],
Cell[17080, 583, 165, 5, 36, "Output",
 CellID->7813]
}, Open  ]],
Cell[17260, 591, 187, 4, 70, "MathCaption",
 CellID->14907],
Cell[CellGroupData[{
Cell[17472, 599, 105, 3, 70, "Input",
 CellID->29554],
Cell[17580, 604, 85, 4, 70, "Print",
 CellID->31476]
}, Open  ]],
Cell[17680, 611, 1641, 50, 70, "DefinitionBox",
 CellID->617],
Cell[19324, 663, 71, 1, 70, "Caption",
 CellID->11211],
Cell[19398, 666, 440, 14, 70, "Text",
 CellID->25429],
Cell[19841, 682, 409, 13, 70, "Text",
 CellID->2264],
Cell[20253, 697, 1688, 55, 70, "Text",
 CellID->15966],
Cell[21944, 754, 455, 14, 70, "Text",
 CellID->19531],
Cell[22402, 770, 390, 10, 70, "Text",
 CellID->29942],
Cell[22795, 782, 456, 11, 70, "DefinitionBox",
 CellID->10698],
Cell[23254, 795, 82, 1, 70, "Caption",
 CellID->19522],
Cell[23339, 798, 593, 14, 70, "Text",
 CellID->31155],
Cell[23935, 814, 1560, 46, 70, "DefinitionBox3Col",
 CellID->27587],
Cell[25498, 862, 68, 1, 70, "Caption",
 CellID->15257],
Cell[25569, 865, 433, 14, 70, "Text",
 CellID->23158],
Cell[26005, 881, 263, 9, 70, "MathCaption",
 CellID->4464],
Cell[CellGroupData[{
Cell[26293, 894, 207, 6, 70, "Input",
 CellID->13762],
Cell[26503, 902, 228, 7, 36, "Output",
 CellID->8510]
}, Open  ]],
Cell[26746, 912, 110, 3, 70, "MathCaption",
 CellID->30946],
Cell[CellGroupData[{
Cell[26881, 919, 314, 10, 70, "Input",
 CellID->31065],
Cell[27198, 931, 165, 5, 36, "Output",
 CellID->8380]
}, Open  ]],
Cell[27378, 939, 230, 8, 70, "MathCaption",
 CellID->13165],
Cell[CellGroupData[{
Cell[27633, 951, 104, 3, 70, "Input",
 CellID->5946],
Cell[27740, 956, 71, 4, 70, "Print",
 CellID->13540]
}, Open  ]],
Cell[27826, 963, 551, 18, 70, "Text",
 CellID->27297],
Cell[28380, 983, 1573, 46, 70, "Text",
 CellID->8042],
Cell[29956, 1031, 117, 3, 70, "MathCaption",
 CellID->14464],
Cell[CellGroupData[{
Cell[30098, 1038, 198, 6, 70, "Input",
 CellID->23194],
Cell[30299, 1046, 229, 7, 36, "Output",
 CellID->12584]
}, Open  ]],
Cell[30543, 1056, 94, 1, 70, "MathCaption",
 CellID->10270],
Cell[CellGroupData[{
Cell[30662, 1061, 300, 10, 70, "Input",
 CellID->32715],
Cell[30965, 1073, 166, 5, 36, "Output",
 CellID->32200]
}, Open  ]],
Cell[31146, 1081, 143, 4, 70, "MathCaption",
 CellID->1206],
Cell[CellGroupData[{
Cell[31314, 1089, 105, 3, 70, "Input",
 CellID->32106],
Cell[31422, 1094, 84, 5, 70, "Print",
 CellID->31302]
}, Open  ]],
Cell[31521, 1102, 917, 27, 70, "Text",
 CellID->8833],
Cell[32441, 1131, 1098, 31, 70, "DefinitionBox",
 CellID->7611],
Cell[33542, 1164, 68, 1, 70, "Caption",
 CellID->19067],
Cell[33613, 1167, 98, 2, 70, "MathCaption",
 CellID->415],
Cell[CellGroupData[{
Cell[33736, 1173, 141, 4, 70, "Input",
 CellID->104032922],
Cell[33880, 1179, 230, 7, 36, "Output",
 CellID->762616275]
}, Open  ]],
Cell[34125, 1189, 227, 8, 70, "MathCaption",
 CellID->6354],
Cell[34355, 1199, 192, 6, 70, "Input",
 CellID->430576362],
Cell[34550, 1207, 224, 7, 70, "MathCaption",
 CellID->24919],
Cell[CellGroupData[{
Cell[34799, 1218, 105, 3, 70, "Input",
 CellID->69906334],
Cell[34907, 1223, 654, 16, 71, "Output",
 CellID->641920935]
}, Open  ]],
Cell[35576, 1242, 69, 1, 70, "MathCaption",
 CellID->26321],
Cell[CellGroupData[{
Cell[35670, 1247, 101, 3, 70, "Input",
 CellID->7592],
Cell[35774, 1252, 166, 5, 36, "Output",
 CellID->31597]
}, Open  ]],
Cell[35955, 1260, 1566, 46, 70, "DefinitionBox",
 CellID->22197],
Cell[37524, 1308, 89, 1, 70, "Caption",
 CellID->13509],
Cell[37616, 1311, 730, 23, 70, "Text",
 CellID->8652],
Cell[CellGroupData[{
Cell[38371, 1338, 72, 1, 70, "RelatedTutorialsSection",
 CellID->298897299],
Cell[38446, 1341, 162, 3, 70, "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],
Cell[38635, 1348, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

