(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     69502,       2461]
NotebookOptionsPosition[     55339,       1975]
NotebookOutlinePosition[     58832,       2056]
CellTagsIndexPosition[     58739,       2050]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regular Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/RegularExpressions"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"], 
          "Strings and Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringsAndCharactersOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Regular Expressions\"\>", 
       2->"\<\"Working with String Patterns\"\>", 
       3->"\<\"Strings and Characters\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], 
          "CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"], "Characters" :> 
          Documentation`HelpLookup["paclet:ref/Characters"], "DigitCharacter" :> 
          Documentation`HelpLookup["paclet:ref/DigitCharacter"], "EndOfLine" :> 
          Documentation`HelpLookup["paclet:ref/EndOfLine"], "EndOfString" :> 
          Documentation`HelpLookup["paclet:ref/EndOfString"], "Except" :> 
          Documentation`HelpLookup["paclet:ref/Except"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "IgnoreCase" :> 
          Documentation`HelpLookup["paclet:ref/IgnoreCase"], 
          "LetterCharacter" :> 
          Documentation`HelpLookup["paclet:ref/LetterCharacter"], "Longest" :> 
          Documentation`HelpLookup["paclet:ref/Longest"], "NumberString" :> 
          Documentation`HelpLookup["paclet:ref/NumberString"], "Overlaps" :> 
          Documentation`HelpLookup["paclet:ref/Overlaps"], 
          "RegularExpression" :> 
          Documentation`HelpLookup["paclet:ref/RegularExpression"], 
          "Shortest" :> Documentation`HelpLookup["paclet:ref/Shortest"], 
          "StartOfLine" :> Documentation`HelpLookup["paclet:ref/StartOfLine"],
           "StartOfString" :> 
          Documentation`HelpLookup["paclet:ref/StartOfString"], "StringCases" :> 
          Documentation`HelpLookup["paclet:ref/StringCases"], "StringCount" :> 
          Documentation`HelpLookup["paclet:ref/StringCount"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"], 
          "StringFreeQ" :> Documentation`HelpLookup["paclet:ref/StringFreeQ"],
           "StringMatchQ" :> 
          Documentation`HelpLookup["paclet:ref/StringMatchQ"], 
          "StringPosition" :> 
          Documentation`HelpLookup["paclet:ref/StringPosition"], 
          "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], 
          "StringReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/StringReplaceList"], 
          "StringSplit" :> Documentation`HelpLookup["paclet:ref/StringSplit"],
           "True" :> Documentation`HelpLookup["paclet:ref/True"], 
          "Whitespace" :> Documentation`HelpLookup["paclet:ref/Whitespace"], 
          "WhitespaceCharacter" :> 
          Documentation`HelpLookup["paclet:ref/WhitespaceCharacter"], 
          "WordBoundary" :> 
          Documentation`HelpLookup["paclet:ref/WordBoundary"], 
          "WordCharacter" :> 
          Documentation`HelpLookup["paclet:ref/WordCharacter"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"All\"\>", 
       2->"\<\"CharacterRange\"\>", 3->"\<\"Characters\"\>", 
       4->"\<\"DigitCharacter\"\>", 5->"\<\"EndOfLine\"\>", 
       6->"\<\"EndOfString\"\>", 7->"\<\"Except\"\>", 8->"\<\"False\"\>", 
       9->"\<\"IgnoreCase\"\>", 10->"\<\"LetterCharacter\"\>", 
       11->"\<\"Longest\"\>", 12->"\<\"NumberString\"\>", 
       13->"\<\"Overlaps\"\>", 14->"\<\"RegularExpression\"\>", 
       15->"\<\"Shortest\"\>", 16->"\<\"StartOfLine\"\>", 
       17->"\<\"StartOfString\"\>", 18->"\<\"StringCases\"\>", 
       19->"\<\"StringCount\"\>", 20->"\<\"StringExpression\"\>", 
       21->"\<\"StringFreeQ\"\>", 22->"\<\"StringMatchQ\"\>", 
       23->"\<\"StringPosition\"\>", 24->"\<\"StringReplace\"\>", 
       25->"\<\"StringReplaceList\"\>", 26->"\<\"StringSplit\"\>", 
       27->"\<\"True\"\>", 28->"\<\"Whitespace\"\>", 
       29->"\<\"WhitespaceCharacter\"\>", 30->"\<\"WordBoundary\"\>", 
       31->"\<\"WordCharacter\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["String Patterns", "Title",
 CellTags->{"S2.8.4", "4.1"},
 CellID->12488],

Cell[TextData[{
 "An important feature of string manipulation functions like ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 " is that they handle not only literal strings but also patterns for \
collections of strings. "
}], "Text",
 CellID->24870],

Cell[TextData[{
 "This replaces ",
 Cell[BoxData["b"], "InlineFormula"],
 " or ",
 Cell[BoxData["c"], "InlineFormula"],
 " by ",
 Cell[BoxData["X"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcd abcd\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<b\>\"", "|", "\"\<c\>\""}], "->", "\"\<X\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->26072],

Cell[BoxData["\<\"aXXd aXXd\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->32176]
}, Open  ]],

Cell[TextData[{
 "This replaces any character by ",
 Cell[BoxData["u"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcd abcd\>\"", ",", 
   RowBox[{"_", "->", "\"\<u\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->15415],

Cell[BoxData["\<\"uuuuuuuuu\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->18086]
}, Open  ]],

Cell[TextData[{
 "You can specify patterns for strings by using ",
 StyleBox["string expressions",
  FontSlant->"Italic"],
 " that contain ordinary strings mixed with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbolic pattern objects. "
}], "Text",
 CellID->4231],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], "1"], "~~", 
     SubscriptBox[
      StyleBox["s", "TI"], "2"], "~~", 
     RowBox[{
      StyleBox["\[Ellipsis]", "TR"], Cell["  or  ", "TableText"], 
      RowBox[{
       ButtonBox["StringExpression",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StringExpression"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], "1"], Cell[", ", "TableText"], 
        SubscriptBox[
         StyleBox["s", "TI"], "2"], Cell[", \[Ellipsis] ]", "TableText"], 
        StyleBox[" ", "TR"]}]}]}]}], "\[SpanFromLeft]"},
   {"", Cell["a sequence of strings and pattern objects", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17480],

Cell["String expressions. ", "Caption",
 CellID->19975],

Cell[TextData[{
 "Here is a string expression that represents the string ",
 Cell[BoxData["ab"], "InlineFormula"],
 " followed by any single character. "
}], "MathCaption",
 CellID->30260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<ab\>\"", "~~", "_"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->20514],

Cell[BoxData[
 RowBox[{"\<\"ab\"\>", "~~", "_"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->8938]
}, Open  ]],

Cell["\<\
This makes a replacement for each occurrence of the string pattern. \
\>", "MathCaption",
 CellID->16657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abc abcb abdc\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<ab\>\"", "~~", "_"}], "->", "\"\<X\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[4]:= ",
 CellID->14990],

Cell[BoxData["\<\"X Xb Xc\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->19438]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringMatchQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringMatchQ"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      FormBox["\"\<s\>\"", TraditionalForm]], "InlineMath"],
     " matches ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringFreeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringFreeQ"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      FormBox["\"\<s\>\"", TraditionalForm]], "InlineMath"],
     " is free of substrings matching ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringCases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringCases"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "give a list of the substrings of ",
     Cell[BoxData[
      FormBox["\"\<s\>\"", TraditionalForm]], "InlineMath"],
     " that match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringCases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringCases"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "replace each case of ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringPosition"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "give a list of the positions of substrings that match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringCount"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "count how many substrings match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplace"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "replace every substring that matches ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringReplaceList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringReplaceList"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a list of all ways of replacing ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "split ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " at every substring that matches ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringSplit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringSplit"], "[", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\"", ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "split at ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ", inserting ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " in its place"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, True, False, False, False, True, False, False, True, {
     False}, False}, "RowsIndexed" -> {}}},
 CellID->28981],

Cell["Functions that support string patterns. ", "Caption",
 CellID->15447],

Cell["\<\
This gives all cases of the pattern that appear in the string. \
\>", "MathCaption",
 CellID->5242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abc abcb abdc\>\"", ",", 
   RowBox[{"\"\<ab\>\"", "~~", "_"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->24618],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abc\"\>", ",", "\<\"abc\"\>", ",", "\<\"abd\"\>"}], 
  "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->16070]
}, Open  ]],

Cell[TextData[{
 "This gives each character that appears after an ",
 Cell[BoxData["\"\<ab\>\""], "InlineFormula"],
 " string. "
}], "MathCaption",
 CellID->25631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abc abcb abdc\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<ab\>\"", "~~", "x_"}], "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->24061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"c\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->27219]
}, Open  ]],

Cell["This gives all pairs of identical characters in the string. ", \
"MathCaption",
 CellID->28781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abbcbccaabbabccaa\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->20990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"bb\"\>", ",", "\<\"cc\"\>", ",", "\<\"aa\"\>", 
   ",", "\<\"bb\"\>", ",", "\<\"cc\"\>", ",", "\<\"aa\"\>"}], "}"}]], "Output",\

 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->12833]
}, Open  ]],

Cell[TextData[{
 "You can use all the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pattern objects in string patterns. Single blanks (",
 Cell[BoxData["_"], "InlineFormula"],
 ") always stand for single characters. Double blanks (",
 Cell[BoxData["__"], "InlineFormula"],
 ") stand for sequences of one or more characters. "
}], "Text",
 CellID->8672],

Cell[TextData[{
 "Single blank (",
 Cell[BoxData["_"], "InlineFormula"],
 ") stands for any single character. "
}], "MathCaption",
 CellID->1563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<ab\>\"", ",", "\"\<abc\>\"", ",", "\"\<abcd\>\""}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"\"\<b\>\"", "~~", "_"}], "->", "\"\<X\>\""}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->21302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"aX\"\>", ",", "\<\"aXd\"\>"}], 
  "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->502]
}, Open  ]],

Cell[TextData[{
 "Double blank (",
 Cell[BoxData["__"], "InlineFormula"],
 ") stands for any sequence of one or more characters. "
}], "MathCaption",
 CellID->26928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<ab\>\"", ",", "\"\<abc\>\"", ",", "\"\<abcd\>\""}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"\"\<b\>\"", "~~", "__"}], "->", "\"\<X\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[9]:= ",
 CellID->30721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"aX\"\>", ",", "\<\"aX\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->24898]
}, Open  ]],

Cell[TextData[{
 "Triple blank (",
 Cell[BoxData["___"], "InlineFormula"],
 ") stands for any sequence of zero or more characters. "
}], "MathCaption",
 CellID->31447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<ab\>\"", ",", "\"\<abc\>\"", ",", "\"\<abcd\>\""}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{"\"\<b\>\"", "~~", "___"}], "->", "\"\<X\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[10]:= ",
 CellID->10945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aX\"\>", ",", "\<\"aX\"\>", ",", "\<\"aX\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->28406]
}, Open  ]],

Cell[BoxData[GridBox[{
   {"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[
    "a literal string of characters", "TableText"]},
   {"_", Cell["any single character", "TableText"]},
   {"__", Cell["any sequence of one or more characters", "TableText"]},
   {"___", Cell["any sequence of zero or more characters", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], Cell[", ", "TableText"], 
     StyleBox["x", "TI"], 
     StyleBox["__", "MR"], Cell[", ", "TableText"], 
     StyleBox["x", "TI"], 
     StyleBox["___", "MR"]}], Cell[TextData[{
     "substrings given the name ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], ":", 
     StyleBox["pattern", "TI"]}], Cell[TextData[{
     "pattern given the name ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], ".."}], Cell[
    "pattern repeated one or more times", "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], "..."}], Cell[
    "pattern repeated zero or more times", "TableText"]},
   {
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["patt", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["patt", "TI"], "2"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell["  or  ", "TableText"], 
      SubscriptBox[
       StyleBox["patt", "TI"], "1"]}], "|", 
     SubscriptBox[
      StyleBox["patt", "TI"], "2"], "|", 
     StyleBox["\[Ellipsis]", "TR"], "  "}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a pattern matching at least one of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["patt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["patt", "TI"], "/;", 
     StyleBox["cond", "TI"]}], Cell[TextData[{
     "a pattern for which ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     " evaluates to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["pattern", "TI"], "?", 
     StyleBox["test", "TI"]}], Cell[TextData[{
     "a pattern for which ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " for each character"
    }], "TableText"]},
   {
    ButtonBox["Whitespace",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Whitespace"], Cell[
    "a sequence of whitespace characters", "TableText"]},
   {
    ButtonBox["NumberString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberString"], Cell[
    "the characters of a number", "TableText"]},
   {
    StyleBox["charobj", "TI"], Cell[
    "an object representing a character class (see below)", "TableText"]},
   {
    RowBox[{
     ButtonBox["RegularExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regexp\", \"TI\"]\)\>\"", "]"}], Cell[
    "substring matching a regular expression", "TableText"]}
  }]], "DefinitionBox",
 CellID->2222],

Cell["Objects in string patterns. ", "Caption",
 CellID->8686],

Cell["This splits at either a colon or semicolon. ", "MathCaption",
 CellID->5794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<a:b;c:d\>\"", ",", 
   RowBox[{"\"\<:\>\"", "|", "\"\<;\>\""}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->23577],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->12844]
}, Open  ]],

Cell[TextData[{
 "This finds all runs containing only ",
 Cell[BoxData["a"], "InlineFormula"],
 " or ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aababbcccdbaa\>\"", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\"\<a\>\"", "|", "\"\<b\>\""}], ")"}], ".."}]}], "]"}]], "Input",\

 CellLabel->"In[12]:= ",
 CellID->21547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aababb\"\>", ",", "\<\"baa\"\>"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->13240]
}, Open  ]],

Cell["Alternatives can be given in lists in string patterns. ", "MathCaption",
 CellID->485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aababbcccdbaa\>\"", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<a\>\"", ",", "\"\<b\>\""}], "}"}], ".."}]}], "]"}]], "Input",\

 CellLabel->"In[13]:= ",
 CellID->16464],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aababb\"\>", ",", "\<\"baa\"\>"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->31723]
}, Open  ]],

Cell[TextData[{
 "You can use standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " constructs such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Characters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Characters"], "[", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\!\(\*
StyleBox[\"\[Ellipsis]\", \"TR\"]\)\>\"", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"], "[", 
   RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}]], "InlineFormula"],
 " to generate lists of alternative characters to use in string patterns. "
}], "Text",
 CellID->20337],

Cell["This gives a list of characters. ", "MathCaption",
 CellID->16653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Characters", "[", "\"\<aeiou\>\"", "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->27168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"e\"\>", ",", "\<\"i\"\>", ",", "\<\"o\"\>", 
   ",", "\<\"u\"\>"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->28130]
}, Open  ]],

Cell["This replaces the vowel characters. ", "MathCaption",
 CellID->15255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcdefghijklm\>\"", ",", 
   RowBox[{
    RowBox[{"Characters", "[", "\"\<aeiou\>\"", "]"}], "->", "\"\<X\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->1466],

Cell[BoxData["\<\"XbcdXfghXjklm\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->4858]
}, Open  ]],

Cell[TextData[{
 "This gives characters in the range ",
 Cell[BoxData["\"\<A\>\""], "InlineFormula"],
 " through ",
 Cell[BoxData["\"\<H\>\""], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacterRange", "[", 
  RowBox[{"\"\<A\>\"", ",", "\"\<H\>\""}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->29656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"C\"\>", ",", "\<\"D\"\>", 
   ",", "\<\"E\"\>", ",", "\<\"F\"\>", ",", "\<\"G\"\>", ",", "\<\"H\"\>"}], 
  "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->3318]
}, Open  ]],

Cell[TextData[{
 "In addition to allowing explicit lists of characters, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides symbolic specifications for several common classes of possible \
characters in string patterns. "
}], "Text",
 CellID->13201],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "any of the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\"\<\>", 
        SubscriptBox["c", "i"], "\"\<\>"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Characters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Characters"], "[", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\!\(\*
StyleBox[\"\[Ellipsis]\", \"TR\"]\)\>\"", "]"}], Cell[TextData[{
     "any of the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\"\<\>", 
        SubscriptBox["c", "i"], "\"\<\>"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CharacterRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacterRange"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], Cell[TextData[{
     "any character in the range ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\"\<\>", 
        SubscriptBox["c", "1"], "\"\<\>"}], TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\"\<\>", 
        SubscriptBox["c", "2"], "\"\<\>"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["DigitCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DigitCharacter"], Cell[
    "digit 0\[Dash]9", "TableText"]},
   {
    ButtonBox["LetterCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LetterCharacter"], Cell["letter", "TableText"]},
   {
    ButtonBox["WhitespaceCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WhitespaceCharacter"], Cell[
    "space, newline, tab or other whitespace character", "TableText"]},
   {
    ButtonBox["WordCharacter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordCharacter"], Cell[
    "letter or digit", "TableText"]},
   {
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "any character except ones matching ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->142],

Cell["Specifications for classes of characters. ", "Caption",
 CellID->21276],

Cell["This picks out the digit characters in a string. ", "MathCaption",
 CellID->31506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a6;b23c456;\>\"", ",", "DigitCharacter"}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->32702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"6\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", ",", "\<\"4\"\>", 
   ",", "\<\"5\"\>", ",", "\<\"6\"\>"}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->10684]
}, Open  ]],

Cell["This picks out all characters except digits. ", "MathCaption",
 CellID->15023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a6;b23c456;\>\"", ",", 
   RowBox[{"Except", "[", "DigitCharacter", "]"}]}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->30270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\";\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>", 
   ",", "\<\";\"\>"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->26312]
}, Open  ]],

Cell["This picks out all runs of one or more digits. ", "MathCaption",
 CellID->8250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a6;b23c456\>\"", ",", 
   RowBox[{"DigitCharacter", ".."}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->13475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"6\"\>", ",", "\<\"23\"\>", ",", "\<\"456\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->20311]
}, Open  ]],

Cell["The results are strings. ", "MathCaption",
 CellID->26850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->19195],

Cell["{\"6\", \"23\", \"456\"}", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]//InputForm= ",
 CellID->5488]
}, Open  ]],

Cell["This converts the strings to numbers. ", "MathCaption",
 CellID->11520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToExpression", "[", "%", "]"}], "+", "1"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->26101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "24", ",", "457"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->20183]
}, Open  ]],

Cell["\<\
String patterns are often used as a way to extract structure from strings of \
textual data. Typically this works by having different parts of a string \
pattern match substrings that correspond to different parts of the structure. \
\
\>", "Text",
 CellID->24798],

Cell[TextData[{
 "This picks out each ",
 Cell[BoxData["="], "InlineFormula"],
 " followed by a number. "
}], "MathCaption",
 CellID->27892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1=6.7, b2=8.87\>\"", ",", 
   RowBox[{"\"\<=\>\"", "~~", "NumberString"}]}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->18848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"=6.7\"\>", ",", "\<\"=8.87\"\>"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->6784]
}, Open  ]],

Cell["This gives the numbers alone. ", "MathCaption",
 CellID->30245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1=6.7, b2=8.87\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<=\>\"", "~~", 
     RowBox[{"x", ":", "NumberString"}]}], "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->12187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"6.7\"\>", ",", "\<\"8.87\"\>"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->14462]
}, Open  ]],

Cell["\<\
This extracts \[OpenCurlyDoubleQuote]variables\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]values\[CloseCurlyDoubleQuote] from the string. \
\>", "MathCaption",
 CellID->28343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a1=6.7, b2=8.87\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"v", ":", 
      RowBox[{"WordCharacter", ".."}]}], "~~", "\"\<=\>\"", "~~", 
     RowBox[{"x", ":", "NumberString"}]}], "->", 
    RowBox[{"{", 
     RowBox[{"v", ",", "x"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->18258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a1\"\>", ",", "\<\"6.7\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"b2\"\>", ",", "\<\"8.87\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->16859]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " converts them to ordinary symbols and numbers. "
}], "MathCaption",
 CellID->8871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToExpression", "[", "%", "]"}], "^", "2"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->14016],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["a1", "2"], ",", "44.89`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["b2", "2"], ",", "78.67689999999999`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{203, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->8172]
}, Open  ]],

Cell[TextData[{
 "In many situations, textual data may contain sequences of spaces, newlines \
or tabs that should be considered \[OpenCurlyDoubleQuote]whitespace\
\[CloseCurlyDoubleQuote], and perhaps ignored. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the symbol ",
 Cell[BoxData[
  ButtonBox["Whitespace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Whitespace"]], "InlineFormula"],
 " stands for any such sequence. "
}], "Text",
 CellID->22832],

Cell["This removes all whitespace from the string. ", "MathCaption",
 CellID->24441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<aa b cc d\>\"", ",", 
   RowBox[{"Whitespace", "->", "\"\<\>\""}]}], "]"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->17683],

Cell[BoxData["\<\"aabccd\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->16088]
}, Open  ]],

Cell["This replaces each sequence of spaces by a single comma. ", \
"MathCaption",
 CellID->22015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<aa b cc d\>\"", ",", 
   RowBox[{"Whitespace", "->", "\"\<,\>\""}]}], "]"}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->13976],

Cell[BoxData["\<\"aa,b,cc,d\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->18516]
}, Open  ]],

Cell[TextData[{
 "String patterns normally apply to substrings that appear at any position in \
a given string. Sometimes, however, it is convenient to specify that patterns \
can apply only to substrings at particular positions. You can do this by \
including symbols such as ",
 Cell[BoxData[
  ButtonBox["StartOfString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StartOfString"]], "InlineFormula"],
 " in your string patterns. "
}], "Text",
 CellID->18298],

Cell[BoxData[GridBox[{
   {
    ButtonBox["StartOfString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StartOfString"], Cell[
    "start of the whole string", "TableText"]},
   {
    ButtonBox["EndOfString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EndOfString"], Cell[
    "end of the whole string", "TableText"]},
   {
    ButtonBox["StartOfLine",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StartOfLine"], Cell[
    "start of a line", "TableText"]},
   {
    ButtonBox["EndOfLine",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EndOfLine"], Cell[
    "end of a line", "TableText"]},
   {
    ButtonBox["WordBoundary",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordBoundary"], Cell[
    "boundary between word characters and others", "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Except",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Except"], "[", 
      ButtonBox["StartOfString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StartOfString"], "]"}], Cell[
     ", etc.", "TableText"]}], Cell[TextData[{
     "anywhere except at the particular positions ",
     Cell[BoxData[
      ButtonBox["StartOfString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StartOfString"]], "InlineFormula"],
     ", etc."
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, True, True, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->39],

Cell["Constructs representing special positions in a string. ", "Caption",
 CellID->31283],

Cell[TextData[{
 "This replaces ",
 Cell[BoxData["\"\<a\>\""], "InlineFormula"],
 " wherever it appears in a string. "
}], "MathCaption",
 CellID->3205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<abc\>\"", ",", "\"\<baca\>\""}], "}"}], ",", 
   RowBox[{"\"\<a\>\"", "->", "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->19997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"XXbc\"\>", ",", "\<\"bXXcXX\"\>"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]= ",
 CellID->29146]
}, Open  ]],

Cell[TextData[{
 "This replaces ",
 Cell[BoxData["\"\<a\>\""], "InlineFormula"],
 " only when it immediately follows the start of a string. "
}], "MathCaption",
 CellID->5769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<abc\>\"", ",", "\"\<baca\>\""}], "}"}], ",", 
   RowBox[{
    RowBox[{"StartOfString", "~~", "\"\<a\>\""}], "->", "\"\<XX\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[29]:= ",
 CellID->23675],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"XXbc\"\>", ",", "\<\"baca\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]= ",
 CellID->917]
}, Open  ]],

Cell[TextData[{
 "This replaces all occurrences of the substring ",
 Cell[BoxData["\"\<the\>\""], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<the others\>\"", ",", 
   RowBox[{"\"\<the\>\"", "->", "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[30]:= ",
 CellID->15020],

Cell[BoxData["\<\"XX oXXrs\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]= ",
 CellID->6030]
}, Open  ]],

Cell["\<\
This replaces only occurrences that have a word boundary on both sides. \
\>", "MathCaption",
 CellID->17442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<the others\>\"", ",", 
   RowBox[{
    RowBox[{"WordBoundary", "~~", "\"\<the\>\"", "~~", "WordBoundary"}], 
    "->", "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[31]:= ",
 CellID->21735],

Cell[BoxData["\<\"XX others\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]= ",
 CellID->32389]
}, Open  ]],

Cell[TextData[{
 "String patterns allow the same kind of ",
 Cell[BoxData["/;"], "InlineFormula"],
 " and other conditions as ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns. "
}], "Text",
 CellID->20373],

Cell["\<\
This gives cases of unequal successive characters in the string. \
\>", "MathCaption",
 CellID->3480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aaabbcaaaabaaa\>\"", ",", 
   RowBox[{
    RowBox[{"x_", "~~", "y_"}], "/;", 
    RowBox[{"x", "!=", "y"}]}]}], "]"}]], "Input",
 CellLabel->"In[32]:= ",
 CellID->12073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"bc\"\>", ",", "\<\"ab\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]= ",
 CellID->10777]
}, Open  ]],

Cell[TextData[{
 "When you give an object such as ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "__"}]]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["e", "TI"], ".."}]], "InlineFormula"],
 " in a string pattern, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally assumes that you want this to match the longest possible sequence \
of characters. Sometimes, however, you may instead want to match the shortest \
possible sequence of characters. You can specify this using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->786],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Longest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Longest"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "the longest consistent match for ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " (default)"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Shortest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Shortest"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "the shortest consistent match for ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8381],

Cell["Objects representing longest and shortest matches. ", "Caption",
 CellID->31785],

Cell["\<\
The string pattern by default matches the longest possible sequence of \
characters. \
\>", "MathCaption",
 CellID->522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<-(a)--(bb)--(c)-\>\"", ",", 
   RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<)\>\""}]}], "]"}]], "Input",
 CellLabel->"In[33]:= ",
 CellID->18345],

Cell[BoxData[
 RowBox[{"{", "\<\"(a)--(bb)--(c)\"\>", "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]= ",
 CellID->20979]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " specifies that instead the shortest possible match should be found. "
}], "MathCaption",
 CellID->16085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<-(a)--(bb)--(c)-\>\"", ",", 
   RowBox[{"Shortest", "[", 
    RowBox[{"\"\<(\>\"", "~~", "__", "~~", "\"\<)\>\""}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[34]:= ",
 CellID->15713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"(a)\"\>", ",", "\<\"(bb)\"\>", ",", "\<\"(c)\"\>"}], 
  "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]= ",
 CellID->30935]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default treats characters such ",
 Cell[BoxData["\"\<X\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 " as distinct. But by setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " in string manipulation operations, you can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to treat all such upper\[Hyphen] and lower\[Hyphen]case letters as \
equivalent. "
}], "Text",
 CellID->19735],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["IgnoreCase",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IgnoreCase"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell["\<\
treat upper\[Hyphen] and lower\[Hyphen]case letters as equivalent\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30883],

Cell["\<\
Specifying case\[Hyphen]independent string operations. \
\>", "Caption",
 CellID->2186],

Cell[TextData[{
 "This replaces all occurrences of ",
 Cell[BoxData["\"\<the\>\""], "InlineFormula"],
 ", independent of case. "
}], "MathCaption",
 CellID->16096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<The cat in the hat.\>\"", ",", 
   RowBox[{"\"\<the\>\"", "->", "\"\<a\>\""}], ",", 
   RowBox[{"IgnoreCase", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[35]:= ",
 CellID->20648],

Cell[BoxData["\<\"a cat in a hat.\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]= ",
 CellID->2085]
}, Open  ]],

Cell[TextData[{
 "In some string operations, one may have to specify whether to include \
overlaps between substrings. By default ",
 Cell[BoxData[
  ButtonBox["StringCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCases"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StringCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringCount"]], "InlineFormula"],
 " do not include overlaps, but ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " does. "
}], "Text",
 CellID->14752],

Cell["\<\
This picks out pairs of successive characters, by default omitting overlaps. \
\
\>", "MathCaption",
 CellID->521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcdefg\>\"", ",", 
   RowBox[{"_", "~~", "_"}]}], "]"}]], "Input",
 CellLabel->"In[36]:= ",
 CellID->9260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"cd\"\>", ",", "\<\"ef\"\>"}], 
  "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]= ",
 CellID->21982]
}, Open  ]],

Cell["This includes the overlaps. ", "MathCaption",
 CellID->6636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcdefg\>\"", ",", 
   RowBox[{"_", "~~", "_"}], ",", 
   RowBox[{"Overlaps", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[37]:= ",
 CellID->7688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ab\"\>", ",", "\<\"bc\"\>", ",", "\<\"cd\"\>", 
   ",", "\<\"de\"\>", ",", "\<\"ef\"\>", ",", "\<\"fg\"\>"}], "}"}]], "Output",\

 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]= ",
 CellID->19919]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 " includes overlaps by default. "
}], "MathCaption",
 CellID->17236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abcdefg\>\"", ",", 
   RowBox[{"_", "~~", "_"}]}], "]"}]], "Input",
 CellLabel->"In[38]:= ",
 CellID->26792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]= ",
 CellID->27065]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Overlaps",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Overlaps"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}], Cell[
    "include all overlaps", "TableText"]},
   {
    RowBox[{
     ButtonBox["Overlaps",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Overlaps"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[
    "include at most one overlap beginning at each position", "TableText"]},
   {
    RowBox[{
     ButtonBox["Overlaps",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Overlaps"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell[
    "exclude all overlaps", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19278],

Cell["Options for handling overlaps in strings. ", "Caption",
 CellID->4198],

Cell["This yields only a single match. ", "MathCaption",
 CellID->31496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcd\>\"", ",", "__", ",", 
   RowBox[{"Overlaps", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[39]:= ",
 CellID->26386],

Cell[BoxData[
 RowBox[{"{", "\<\"abcd\"\>", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]= ",
 CellID->21011]
}, Open  ]],

Cell["This yields a succession of overlapping matches. ", "MathCaption",
 CellID->10976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcd\>\"", ",", "__", ",", 
   RowBox[{"Overlaps", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[40]:= ",
 CellID->7547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abcd\"\>", ",", "\<\"bcd\"\>", ",", "\<\"cd\"\>", 
   ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]= ",
 CellID->12121]
}, Open  ]],

Cell["This includes all possible overlapping matches. ", "MathCaption",
 CellID->23202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcd\>\"", ",", "__", ",", 
   RowBox[{"Overlaps", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[41]:= ",
 CellID->7245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"abcd\"\>", ",", "\<\"abc\"\>", ",", "\<\"ab\"\>", 
   ",", "\<\"a\"\>", ",", "\<\"bcd\"\>", ",", "\<\"bc\"\>", ",", "\<\"b\"\>", 
   ",", "\<\"cd\"\>", ",", "\<\"c\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]= ",
 CellID->6702]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->17473532],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "TutorialMoreAbout",
 CellID->6738482]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->323168965],

Cell[TextData[ButtonBox["Regular Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RegularExpressions"]], "RelatedTutorials",
 CellID->268986192],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "RelatedTutorials",
 CellID->22514736],

Cell[TextData[ButtonBox["Strings and Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringsAndCharactersOverview"]], "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"String Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Strings and Characters", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/StringsAndCharactersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CharactersInStrings"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RegularExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 3.8888254}", "context" -> "", 
    "keywords" -> {
     "alphabetic character", "case sensitive", "case independence", 
      "case independent", "lowercase", "character classes", "CharacterRange", 
      "characters", "DigitCharacter", "EndOfLine", "EndOfString", "except", 
      "greedy string patterns", "IgnoreCase", "LetterCharacter", 
      "LongestMatch", "newlines", "nongreedy string patterns", "NumberString",
       "overlaps", "patterns", "reluctant string patterns", "ShortestMatch", 
      "spaces", "StartOfLine", "start of line", "StartOfString", 
      "start of string", "StringCases", "string cases", "StringCount", 
      "string count", "StringExpression", "string expression", "StringFreeQ", 
      "StringMatchQ", "string match", "string patterns", "StringPosition", 
      "string position", "StringReplace", "string replace", 
      "StringReplaceList", "StringSplit", "string split", "tabs", "uppercase",
       "Whitespace", "WhitespaceCharacter", "WordBoundary", "word boundary", 
      "WordCharacter", "word character"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "An important feature of string manipulation functions like StringReplace \
is that they handle not only literal strings but also patterns for \
collections of strings. This replaces b or c by X. This replaces any \
character by u. ", "synonyms" -> {"2.8.4"}, "title" -> "String Patterns", 
    "type" -> "Tutorial", "uri" -> "tutorial/StringPatterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.8.4"->{
  Cell[6185, 135, 78, 2, 70, "Title",
   CellTags->{"S2.8.4", "4.1"},
   CellID->12488]},
 "4.1"->{
  Cell[6185, 135, 78, 2, 70, "Title",
   CellTags->{"S2.8.4", "4.1"},
   CellID->12488]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.8.4", 58526, 2039},
 {"4.1", 58626, 2043}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 5560, 108, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6185, 135, 78, 2, 70, "Title",
 CellTags->{"S2.8.4", "4.1"},
 CellID->12488],
Cell[6266, 139, 334, 9, 70, "Text",
 CellID->24870],
Cell[6603, 150, 207, 9, 70, "MathCaption",
 CellID->31754],
Cell[CellGroupData[{
Cell[6835, 163, 222, 7, 28, "Input",
 CellID->26072],
Cell[7060, 172, 171, 5, 36, "Output",
 CellID->32176]
}, Open  ]],
Cell[7246, 180, 130, 5, 70, "MathCaption",
 CellID->26701],
Cell[CellGroupData[{
Cell[7401, 189, 178, 5, 28, "Input",
 CellID->15415],
Cell[7582, 196, 171, 5, 36, "Output",
 CellID->18086]
}, Open  ]],
Cell[7768, 204, 276, 9, 70, "Text",
 CellID->4231],
Cell[8047, 215, 1144, 31, 70, "DefinitionBox",
 CellID->17480],
Cell[9194, 248, 55, 1, 70, "Caption",
 CellID->19975],
Cell[9252, 251, 188, 5, 70, "MathCaption",
 CellID->30260],
Cell[CellGroupData[{
Cell[9465, 260, 99, 3, 70, "Input",
 CellID->20514],
Cell[9567, 265, 186, 6, 36, "Output",
 CellID->8938]
}, Open  ]],
Cell[9768, 274, 115, 3, 70, "MathCaption",
 CellID->16657],
Cell[CellGroupData[{
Cell[9908, 281, 219, 7, 70, "Input",
 CellID->14990],
Cell[10130, 290, 169, 5, 36, "Output",
 CellID->19438]
}, Open  ]],
Cell[10314, 298, 4586, 142, 70, "DefinitionBox",
 CellID->28981],
Cell[14903, 442, 75, 1, 70, "Caption",
 CellID->15447],
Cell[14981, 445, 109, 3, 70, "MathCaption",
 CellID->5242],
Cell[CellGroupData[{
Cell[15115, 452, 181, 5, 70, "Input",
 CellID->24618],
Cell[15299, 459, 244, 8, 36, "Output",
 CellID->16070]
}, Open  ]],
Cell[15558, 470, 163, 5, 70, "MathCaption",
 CellID->25631],
Cell[CellGroupData[{
Cell[15746, 479, 208, 6, 70, "Input",
 CellID->24061],
Cell[15957, 487, 236, 8, 36, "Output",
 CellID->27219]
}, Open  ]],
Cell[16208, 498, 101, 2, 70, "MathCaption",
 CellID->28781],
Cell[CellGroupData[{
Cell[16334, 504, 178, 5, 70, "Input",
 CellID->20990],
Cell[16515, 511, 301, 9, 36, "Output",
 CellID->12833]
}, Open  ]],
Cell[16831, 523, 370, 10, 70, "Text",
 CellID->8672],
Cell[17204, 535, 145, 5, 70, "MathCaption",
 CellID->1563],
Cell[CellGroupData[{
Cell[17374, 544, 289, 9, 70, "Input",
 CellID->21302],
Cell[17666, 555, 239, 8, 36, "Output",
 CellID->502]
}, Open  ]],
Cell[17920, 566, 165, 5, 70, "MathCaption",
 CellID->26928],
Cell[CellGroupData[{
Cell[18110, 575, 292, 10, 70, "Input",
 CellID->30721],
Cell[18405, 587, 240, 8, 36, "Output",
 CellID->24898]
}, Open  ]],
Cell[18660, 598, 167, 5, 70, "MathCaption",
 CellID->31447],
Cell[CellGroupData[{
Cell[18852, 607, 294, 10, 70, "Input",
 CellID->10945],
Cell[19149, 619, 241, 8, 36, "Output",
 CellID->28406]
}, Open  ]],
Cell[19405, 630, 3366, 105, 70, "DefinitionBox",
 CellID->2222],
Cell[22774, 737, 62, 1, 70, "Caption",
 CellID->8686],
Cell[22839, 740, 82, 1, 70, "MathCaption",
 CellID->5794],
Cell[CellGroupData[{
Cell[22946, 745, 182, 5, 70, "Input",
 CellID->23577],
Cell[23131, 752, 256, 8, 36, "Output",
 CellID->12844]
}, Open  ]],
Cell[23402, 763, 182, 7, 70, "MathCaption",
 CellID->18683],
Cell[CellGroupData[{
Cell[23609, 774, 237, 8, 70, "Input",
 CellID->21547],
Cell[23849, 784, 224, 7, 36, "Output",
 CellID->13240]
}, Open  ]],
Cell[24088, 794, 92, 1, 70, "MathCaption",
 CellID->485],
Cell[CellGroupData[{
Cell[24205, 799, 237, 8, 70, "Input",
 CellID->16464],
Cell[24445, 809, 224, 7, 36, "Output",
 CellID->31723]
}, Open  ]],
Cell[24684, 819, 920, 28, 70, "Text",
 CellID->20337],
Cell[25607, 849, 72, 1, 70, "MathCaption",
 CellID->16653],
Cell[CellGroupData[{
Cell[25704, 854, 116, 3, 70, "Input",
 CellID->27168],
Cell[25823, 859, 275, 8, 36, "Output",
 CellID->28130]
}, Open  ]],
Cell[26113, 870, 75, 1, 70, "MathCaption",
 CellID->15255],
Cell[CellGroupData[{
Cell[26213, 875, 236, 7, 70, "Input",
 CellID->1466],
Cell[26452, 884, 175, 5, 36, "Output",
 CellID->4858]
}, Open  ]],
Cell[26642, 892, 202, 7, 70, "MathCaption",
 CellID->22512],
Cell[CellGroupData[{
Cell[26869, 903, 147, 4, 70, "Input",
 CellID->29656],
Cell[27019, 909, 332, 9, 36, "Output",
 CellID->3318]
}, Open  ]],
Cell[27366, 921, 261, 7, 70, "Text",
 CellID->13201],
Cell[27630, 930, 2997, 91, 70, "DefinitionBox",
 CellID->142],
Cell[30630, 1023, 77, 1, 70, "Caption",
 CellID->21276],
Cell[30710, 1026, 88, 1, 70, "MathCaption",
 CellID->31506],
Cell[CellGroupData[{
Cell[30823, 1031, 159, 4, 70, "Input",
 CellID->32702],
Cell[30985, 1037, 294, 8, 36, "Output",
 CellID->10684]
}, Open  ]],
Cell[31294, 1048, 84, 1, 70, "MathCaption",
 CellID->15023],
Cell[CellGroupData[{
Cell[31403, 1053, 193, 5, 70, "Input",
 CellID->30270],
Cell[31599, 1060, 275, 8, 36, "Output",
 CellID->26312]
}, Open  ]],
Cell[31889, 1071, 85, 1, 70, "MathCaption",
 CellID->8250],
Cell[CellGroupData[{
Cell[31999, 1076, 178, 5, 70, "Input",
 CellID->13475],
Cell[32180, 1083, 241, 8, 36, "Output",
 CellID->20311]
}, Open  ]],
Cell[32436, 1094, 64, 1, 70, "MathCaption",
 CellID->26850],
Cell[CellGroupData[{
Cell[32525, 1099, 103, 3, 70, "Input",
 CellID->19195],
Cell[32631, 1104, 181, 5, 50, "Output",
 CellID->5488]
}, Open  ]],
Cell[32827, 1112, 77, 1, 70, "MathCaption",
 CellID->11520],
Cell[CellGroupData[{
Cell[32929, 1117, 129, 4, 70, "Input",
 CellID->26101],
Cell[33061, 1123, 214, 7, 36, "Output",
 CellID->20183]
}, Open  ]],
Cell[33290, 1133, 274, 6, 70, "Text",
 CellID->24798],
Cell[33567, 1141, 140, 5, 70, "MathCaption",
 CellID->27892],
Cell[CellGroupData[{
Cell[33732, 1150, 194, 5, 70, "Input",
 CellID->18848],
Cell[33929, 1157, 223, 7, 36, "Output",
 CellID->6784]
}, Open  ]],
Cell[34167, 1167, 69, 1, 70, "MathCaption",
 CellID->30245],
Cell[CellGroupData[{
Cell[34261, 1172, 246, 7, 70, "Input",
 CellID->12187],
Cell[34510, 1181, 222, 7, 36, "Output",
 CellID->14462]
}, Open  ]],
Cell[34747, 1191, 195, 4, 70, "MathCaption",
 CellID->28343],
Cell[CellGroupData[{
Cell[34967, 1199, 369, 11, 70, "Input",
 CellID->18258],
Cell[35339, 1212, 339, 11, 36, "Output",
 CellID->16859]
}, Open  ]],
Cell[35693, 1226, 228, 7, 70, "MathCaption",
 CellID->8871],
Cell[CellGroupData[{
Cell[35946, 1237, 129, 4, 70, "Input",
 CellID->14016],
Cell[36078, 1243, 380, 14, 39, "Output",
 CellID->8172]
}, Open  ]],
Cell[36473, 1260, 469, 13, 70, "Text",
 CellID->22832],
Cell[36945, 1275, 84, 1, 70, "MathCaption",
 CellID->24441],
Cell[CellGroupData[{
Cell[37054, 1280, 187, 5, 70, "Input",
 CellID->17683],
Cell[37244, 1287, 169, 5, 36, "Output",
 CellID->16088]
}, Open  ]],
Cell[37428, 1295, 98, 2, 70, "MathCaption",
 CellID->22015],
Cell[CellGroupData[{
Cell[37551, 1301, 188, 5, 70, "Input",
 CellID->13976],
Cell[37742, 1308, 172, 5, 36, "Output",
 CellID->18516]
}, Open  ]],
Cell[37929, 1316, 466, 11, 70, "Text",
 CellID->18298],
Cell[38398, 1329, 1554, 49, 70, "DefinitionBox",
 CellID->39],
Cell[39955, 1380, 90, 1, 70, "Caption",
 CellID->31283],
Cell[40048, 1383, 152, 5, 70, "MathCaption",
 CellID->3205],
Cell[CellGroupData[{
Cell[40225, 1392, 242, 7, 70, "Input",
 CellID->19997],
Cell[40470, 1401, 226, 7, 36, "Output",
 CellID->29146]
}, Open  ]],
Cell[40711, 1411, 175, 5, 70, "MathCaption",
 CellID->5769],
Cell[CellGroupData[{
Cell[40911, 1420, 283, 9, 70, "Input",
 CellID->23675],
Cell[41197, 1431, 221, 7, 36, "Output",
 CellID->917]
}, Open  ]],
Cell[41433, 1441, 155, 5, 70, "MathCaption",
 CellID->9387],
Cell[CellGroupData[{
Cell[41613, 1450, 191, 5, 70, "Input",
 CellID->15020],
Cell[41807, 1457, 170, 5, 36, "Output",
 CellID->6030]
}, Open  ]],
Cell[41992, 1465, 119, 3, 70, "MathCaption",
 CellID->17442],
Cell[CellGroupData[{
Cell[42136, 1472, 255, 7, 70, "Input",
 CellID->21735],
Cell[42394, 1481, 172, 5, 36, "Output",
 CellID->32389]
}, Open  ]],
Cell[42581, 1489, 229, 8, 70, "Text",
 CellID->20373],
Cell[42813, 1499, 111, 3, 70, "MathCaption",
 CellID->3480],
Cell[CellGroupData[{
Cell[42949, 1506, 228, 7, 70, "Input",
 CellID->12073],
Cell[43180, 1515, 241, 8, 36, "Output",
 CellID->10777]
}, Open  ]],
Cell[43436, 1526, 731, 24, 70, "Text",
 CellID->786],
Cell[44170, 1552, 958, 30, 70, "DefinitionBox",
 CellID->8381],
Cell[45131, 1584, 86, 1, 70, "Caption",
 CellID->31785],
Cell[45220, 1587, 130, 4, 70, "MathCaption",
 CellID->522],
Cell[CellGroupData[{
Cell[45375, 1595, 204, 5, 70, "Input",
 CellID->18345],
Cell[45582, 1602, 200, 6, 36, "Output",
 CellID->20979]
}, Open  ]],
Cell[45797, 1611, 242, 7, 70, "MathCaption",
 CellID->16085],
Cell[CellGroupData[{
Cell[46064, 1622, 244, 7, 70, "Input",
 CellID->15713],
Cell[46311, 1631, 246, 8, 36, "Output",
 CellID->30935]
}, Open  ]],
Cell[46572, 1642, 694, 22, 70, "Text",
 CellID->19735],
Cell[47269, 1666, 648, 19, 70, "DefinitionBox",
 CellID->30883],
Cell[47920, 1687, 97, 3, 70, "Caption",
 CellID->2186],
Cell[48020, 1692, 163, 5, 70, "MathCaption",
 CellID->16096],
Cell[CellGroupData[{
Cell[48208, 1701, 246, 6, 70, "Input",
 CellID->20648],
Cell[48457, 1709, 178, 5, 36, "Output",
 CellID->2085]
}, Open  ]],
Cell[48650, 1717, 597, 19, 70, "Text",
 CellID->14752],
Cell[49250, 1738, 124, 4, 70, "MathCaption",
 CellID->521],
Cell[CellGroupData[{
Cell[49399, 1746, 166, 5, 70, "Input",
 CellID->9260],
Cell[49568, 1753, 241, 8, 36, "Output",
 CellID->21982]
}, Open  ]],
Cell[49824, 1764, 66, 1, 70, "MathCaption",
 CellID->6636],
Cell[CellGroupData[{
Cell[49915, 1769, 211, 6, 70, "Input",
 CellID->7688],
Cell[50129, 1777, 302, 9, 36, "Output",
 CellID->19919]
}, Open  ]],
Cell[50446, 1789, 216, 7, 70, "MathCaption",
 CellID->17236],
Cell[CellGroupData[{
Cell[50687, 1800, 170, 5, 70, "Input",
 CellID->26792],
Cell[50860, 1807, 536, 19, 36, "Output",
 CellID->27065]
}, Open  ]],
Cell[51411, 1829, 1158, 36, 70, "DefinitionBox",
 CellID->19278],
Cell[52572, 1867, 76, 1, 70, "Caption",
 CellID->4198],
Cell[52651, 1870, 72, 1, 70, "MathCaption",
 CellID->31496],
Cell[CellGroupData[{
Cell[52748, 1875, 186, 5, 70, "Input",
 CellID->26386],
Cell[52937, 1882, 189, 6, 36, "Output",
 CellID->21011]
}, Open  ]],
Cell[53141, 1891, 88, 1, 70, "MathCaption",
 CellID->10976],
Cell[CellGroupData[{
Cell[53254, 1896, 184, 5, 70, "Input",
 CellID->7547],
Cell[53441, 1903, 264, 8, 36, "Output",
 CellID->12121]
}, Open  ]],
Cell[53720, 1914, 87, 1, 70, "MathCaption",
 CellID->23202],
Cell[CellGroupData[{
Cell[53832, 1919, 183, 5, 70, "Input",
 CellID->7245],
Cell[54018, 1926, 379, 9, 36, "Output",
 CellID->6702]
}, Open  ]],
Cell[CellGroupData[{
Cell[54434, 1940, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->17473532],
Cell[54502, 1943, 147, 3, 70, "TutorialMoreAbout",
 CellID->6738482]
}, Open  ]],
Cell[CellGroupData[{
Cell[54686, 1951, 72, 1, 70, "RelatedTutorialsSection",
 CellID->323168965],
Cell[54761, 1954, 159, 3, 70, "RelatedTutorials",
 CellID->268986192],
Cell[54923, 1959, 185, 4, 70, "RelatedTutorials",
 CellID->22514736],
Cell[55111, 1965, 174, 4, 70, "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],
Cell[55312, 1973, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

