(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42559,       1608]
NotebookOptionsPosition[     34540,       1328]
NotebookOutlinePosition[     36731,       1385]
CellTagsIndexPosition[     36636,       1379]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FormBox" :> Documentation`HelpLookup["paclet:ref/FormBox"], 
          "FractionBox" :> Documentation`HelpLookup["paclet:ref/FractionBox"],
           "OverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/OverscriptBox"], "RadicalBox" :> 
          Documentation`HelpLookup["paclet:ref/RadicalBox"], "RowBox" :> 
          Documentation`HelpLookup["paclet:ref/RowBox"], "SqrtBox" :> 
          Documentation`HelpLookup["paclet:ref/SqrtBox"], "SubscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubscriptBox"], 
          "SubsuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubsuperscriptBox"], 
          "SuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SuperscriptBox"], 
          "UnderoverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/UnderoverscriptBox"], 
          "UnderscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/UnderscriptBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FormBox\"\>", 
       2->"\<\"FractionBox\"\>", 3->"\<\"OverscriptBox\"\>", 
       4->"\<\"RadicalBox\"\>", 5->"\<\"RowBox\"\>", 6->"\<\"SqrtBox\"\>", 
       7->"\<\"SubscriptBox\"\>", 8->"\<\"SubsuperscriptBox\"\>", 
       9->"\<\"SuperscriptBox\"\>", 10->"\<\"UnderoverscriptBox\"\>", 
       11->"\<\"UnderscriptBox\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["String Representation of Boxes", "Title",
 CellTags->{"S2.9.12", "12.1"},
 CellID->28564],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a compact way of representing boxes in terms of strings. This is \
particularly convenient when you want to import or export specifications of \
boxes as ordinary text."
}], "Text",
 CellID->31539],

Cell[TextData[{
 "This generates an ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " string that represents the ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], ",", "InputForm"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->2257],

Cell[BoxData["\<\"\\\\(x\\\\^2\\\\)\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->2370]
}, Open  ]],

Cell[TextData[{
 "This creates the ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\\(", 
  RowBox[{"x", "\\^", "2"}], "\\)"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->31654],

Cell[BoxData[
 RowBox[{"SuperscriptBox", "[", 
  RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->19359]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " interprets the ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 " as a power. "
}], "MathCaption",
 CellID->11080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToExpression", "[", "%", "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->7298],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", "2"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm= ",
 CellID->23391]
}, Open  ]],

Cell[TextData[{
 "It is important to distinguish between forms that represent just raw boxes, \
and forms that represent the ",
 StyleBox["meaning",
  FontSlant->"Italic"],
 " of the boxes. "
}], "Text",
 CellID->23960],

Cell[TextData[{
 "This corresponds to a raw ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\\(", 
  RowBox[{"x", "\\^", "2"}], "\\)"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->29591],

Cell[BoxData[
 RowBox[{"SuperscriptBox", "[", 
  RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->25867]
}, Open  ]],

Cell[TextData[{
 "This corresponds to the power that the ",
 Cell[BoxData[
  ButtonBox["SuperscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SuperscriptBox"]], "InlineFormula"],
 " represents. "
}], "MathCaption",
 CellID->22033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\\!", 
  RowBox[{"\\(", 
   RowBox[{"x", "\\^", "2"}], "\\)"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->1675],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->12136]
}, Open  ]],

Cell["The expression generated here is a power. ", "MathCaption",
 CellID->30499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"\\!", 
   RowBox[{"\\(", 
    RowBox[{"x", "\\^", "2"}], "\\)"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->17775],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", "2"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//FullForm= ",
 CellID->25790]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[Backslash]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["input", "TI"], "\[Backslash]"}], ")"}]}], Cell[
    "raw boxes", "TableText"]},
   {
    RowBox[{"\[Backslash]", 
     RowBox[{"!", 
      RowBox[{"\[Backslash]", 
       RowBox[{"(", 
        RowBox[{
         StyleBox["input", "TI"], "\[Backslash]"}], ")"}]}]}]}], Cell[
    "the meaning of the boxes", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14376],

Cell["\<\
Distinguishing raw boxes from the expressions they represent. \
\>", "Caption",
 CellID->31256],

Cell[TextData[{
 "If you copy the contents of a ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " cell into another program, such as a text editor, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will generate a ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"!", 
    RowBox[{"\[Backslash]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]}]}]], 
  "InlineFormula"],
 " form where necessary. This is done so that if you subsequently paste the \
form back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the original contents of the ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " cell will automatically be re\[Hyphen]created. Without the ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "!"}]], "InlineFormula"],
 ", only the raw boxes corresponding to these contents would be obtained."
}], "Text",
 CellID->20272],

Cell[TextData[{
 "With default settings for options, ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"!", 
    RowBox[{"\[Backslash]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]}]}]], 
  "InlineFormula"],
 " forms pasted into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks are automatically displayed in two\[Hyphen]dimensional form."
}], "Text",
 CellID->20703],

Cell[BoxData[GridBox[{
   {"\"\<\[Backslash](\!\(\*
StyleBox[\"input\", \"TI\"]\)\[Backslash])\>\"", Cell[
    "a raw character string", "TableText"]},
   {"\"\<\[Backslash]!\[Backslash](\!\(\*
StyleBox[\"input\", \"TI\"]\)\[Backslash])\>\"", Cell[
    "a string containing boxes", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5086],

Cell["\<\
Embedding two\[Hyphen]dimensional box structures in strings. \
\>", "Caption",
 CellID->20967],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will usually treat a ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 " form that appears within a string just like any other sequence of \
characters. But by inserting a ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "!"}]], "InlineFormula"],
 " you can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " instead to treat this form like the boxes it represents. In this way you \
can therefore embed box structures within ordinary character strings."
}], "Text",
 CellID->9515],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats this as an ordinary character string. "
}], "MathCaption",
 CellID->23542],

Cell[CellGroupData[{

Cell[BoxData["\"\<\\( x \\^ 2 \\)\>\""], "Input",
 CellLabel->"In[7]:= ",
 CellID->23495],

Cell[BoxData["\<\"\\( x \\^ 2 \\)\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->3566]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"!", "\[Backslash]"}]], "InlineFormula"],
 " tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that this string contains boxes. "
}], "MathCaption",
 CellID->18456],

Cell[CellGroupData[{

Cell[BoxData["\"\<\\!\\( x \\^ 2 \\)\>\""], "Input",
 CellLabel->"In[8]:= ",
 CellID->14186],

Cell[BoxData["\<\"\\!\\( x \\^ 2 \\)\"\>"], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->8437]
}, Open  ]],

Cell["You can mix boxes with ordinary text. ", "MathCaption",
 CellID->19198],

Cell[CellGroupData[{

Cell[BoxData["\"\<box 1: \\!\\(x\\^2\\); box 2: \\!\\(y\\^3\\)\>\""], "Input",
 CellLabel->"In[9]:= ",
 CellID->12626],

Cell[BoxData["\<\"box 1: \\!\\(x\\^2\\); box 2: \\!\\(y\\^3\\)\"\>"], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->18364]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[Backslash]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox[
        StyleBox["box", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["box", "TI"], 
        StyleBox["2", "TR"]], ",", 
       RowBox[{
        StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}]}], ")"}]}], 
    RowBox[{
     ButtonBox["RowBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RowBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], "1"], "\[Backslash]", "^", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"]}], 
    RowBox[{
     ButtonBox["SuperscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], "1"], "\[Backslash]", "_", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"]}], 
    RowBox[{
     ButtonBox["SubscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], "1"], "\[Backslash]", "_", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], "\[Backslash]", "%", 
     SubscriptBox[
      StyleBox["box", "TI"], "3"]}], 
    RowBox[{
     ButtonBox["SubsuperscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubsuperscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "3"], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], "1"], "\[Backslash]", "&", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"]}], 
    RowBox[{
     ButtonBox["OverscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], "1"], "\[Backslash]", "+", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"]}], 
    RowBox[{
     ButtonBox["UnderscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], "1"], "\[Backslash]", "+", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], "\[Backslash]", "%", 
     SubscriptBox[
      StyleBox["box", "TI"], "3"]}], 
    RowBox[{
     ButtonBox["UnderoverscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderoverscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "3"], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], "1"], "\[Backslash]", "/", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"]}], 
    RowBox[{
     ButtonBox["FractionBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FractionBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], "]"}]},
   {
    RowBox[{"\[Backslash]", 
     RowBox[{"@", 
      StyleBox["box", "TI"]}]}], 
    RowBox[{
     ButtonBox["SqrtBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SqrtBox"], "[", 
     StyleBox["box", "TI"], "]"}]},
   {
    RowBox[{"\\@", 
     RowBox[{
      SubscriptBox[
       StyleBox["box", "TI"], 
       StyleBox["1", "TR"]], "\\%", 
      SubscriptBox[
       StyleBox["box", "TI"], 
       StyleBox["2", "TR"]]}]}], 
    RowBox[{
     ButtonBox["RadicalBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RadicalBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], "2"], "]"}]},
   {
    RowBox[{
     StyleBox["form", "TI"], "\[Backslash]", "`", " ", 
     StyleBox["box", "TI"]}], 
    RowBox[{
     ButtonBox["FormBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormBox"], "[", 
     StyleBox["box", "TI"], ",", 
     StyleBox["form", "TI"], "]"}]},
   {
    RowBox[{"\\*", 
     StyleBox["input", "TI"]}], Cell[TextData[{
     "construct boxes from ",
     Cell[BoxData[
      StyleBox["input", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1085],

Cell["Input forms for boxes. ", "Caption",
 CellID->31665],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " requires that any input forms you give for boxes be enclosed within ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "("}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", ")"}]], "InlineFormula"],
 ". But within these outermost ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "("}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", ")"}]], "InlineFormula"],
 " you can use additional ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "("}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", ")"}]], "InlineFormula"],
 " to specify grouping. "
}], "Text",
 CellID->18908],

Cell["Here ordinary parentheses are used to indicate grouping. ", \
"MathCaption",
 CellID->20340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{"x", "\\/", 
    RowBox[{"(", 
     RowBox[{"y", "+", "z"}], ")"}]}], "\\)"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->1360],

Cell[BoxData[
 TagBox[
  FractionBox["x", 
   RowBox[{"(", 
    RowBox[{"y", "+", "z"}], ")"}]],
  DisplayForm]], "Output",
 ImageSize->{49, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//DisplayForm= ",
 CellID->2814]
}, Open  ]],

Cell["Without the parentheses, the grouping would be different. ", \
"MathCaption",
 CellID->21154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{
    RowBox[{"x", "\\/", "y"}], "+", "z"}], "\\)"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->18012],

Cell[BoxData[
 TagBox[
  RowBox[{
   FractionBox["x", "y"], "+", "z"}],
  DisplayForm]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]//DisplayForm= ",
 CellID->19752]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[Backslash]", "("}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", ")"}]], "InlineFormula"],
 " specify grouping, but are not displayed as explicit parentheses. "
}], "MathCaption",
 CellID->3338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{"x", "\\/", 
    RowBox[{"\\(", 
     RowBox[{"y", "+", "z"}], "\\)"}]}], "\\)"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->8706],

Cell[BoxData[
 TagBox[
  FractionBox["x", 
   RowBox[{"y", "+", "z"}]],
  DisplayForm]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//DisplayForm= ",
 CellID->12525]
}, Open  ]],

Cell[TextData[{
 "The inner ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "("}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", ")"}]], "InlineFormula"],
 " lead to the construction of a ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\\(", 
  RowBox[{"x", "\\/", 
   RowBox[{"\\(", 
    RowBox[{"y", "+", "z"}], "\\)"}]}], "\\)"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->29249],

Cell[BoxData[
 RowBox[{"FractionBox", "[", 
  RowBox[{"\<\"x\"\>", ",", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"y\"\>", ",", "\<\"+\"\>", ",", "\<\"z\"\>"}], "}"}], 
    "]"}]}], "]"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->23179]
}, Open  ]],

Cell[TextData[{
 "When you type ",
 Cell[BoxData[
  RowBox[{"aa", "+", "bb"}]], "InlineFormula"],
 " as input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the first thing that happens is that ",
 Cell[BoxData["aa"], "InlineFormula"],
 ", ",
 Cell[BoxData["+"], "InlineFormula"],
 " and ",
 Cell[BoxData["bb"], "InlineFormula"],
 " are recognized as being separate \[OpenCurlyDoubleQuote]tokens\
\[CloseCurlyDoubleQuote]. The same separation into tokens is done when boxes \
are constructed from input enclosed in ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 ". However, inside the boxes each token is given as a string, rather than in \
its raw form."
}], "Text",
 CellID->3079],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " has ",
 Cell[BoxData["aa"], "InlineFormula"],
 ", ",
 Cell[BoxData["+"], "InlineFormula"],
 " and ",
 Cell[BoxData["bb"], "InlineFormula"],
 " broken into separate strings. "
}], "MathCaption",
 CellID->8313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{"aa", "+", "bb"}], "\\)"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->28838],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"RowBox", "[", 
    RowBox[{"List", "[", 
     RowBox[{"\"\<aa\>\"", ",", "\"\<+\>\"", ",", "\"\<bb\>\""}], "]"}], 
    "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//FullForm= ",
 CellID->32517]
}, Open  ]],

Cell[TextData[{
 "Spaces around the ",
 Cell[BoxData["+"], "InlineFormula"],
 " are by default discarded. "
}], "MathCaption",
 CellID->8421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{"aa", " ", "+", " ", "bb"}], "\\)"}], "//", "FullForm"}]], "Input",\

 CellLabel->"In[15]:= ",
 CellID->14145],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"RowBox", "[", 
    RowBox[{"List", "[", 
     RowBox[{"\"\<aa\>\"", ",", "\"\<+\>\"", ",", "\"\<bb\>\""}], "]"}], 
    "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]//FullForm= ",
 CellID->5991]
}, Open  ]],

Cell[TextData[{
 "Here two nested ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " objects are formed. "
}], "MathCaption",
 CellID->16565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{"aa", "+", 
    RowBox[{"bb", "/", "cc"}]}], "\\)"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->23762],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"RowBox", "[", 
    RowBox[{"List", "[", 
     RowBox[{"\"\<aa\>\"", ",", "\"\<+\>\"", ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"List", "[", 
        RowBox[{"\"\<bb\>\"", ",", "\"\</\>\"", ",", "\"\<cc\>\""}], "]"}], 
       "]"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]//FullForm= ",
 CellID->19473]
}, Open  ]],

Cell[TextData[{
 "The same box structure is formed even when the string given does not \
correspond to a complete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. "
}], "MathCaption",
 CellID->23681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{"aa", "+", 
    RowBox[{"bb", "/"}]}], "\\)"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->21970],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"RowBox", "[", 
    RowBox[{"List", "[", 
     RowBox[{"\"\<aa\>\"", ",", "\"\<+\>\"", ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"List", "[", 
        RowBox[{"\"\<bb\>\"", ",", "\"\</\>\""}], "]"}], "]"}]}], "]"}], 
    "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]//FullForm= ",
 CellID->23147]
}, Open  ]],

Cell[TextData[{
 "Within ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 " sequences, you can set up certain kinds of boxes by using backslash \
notations such as ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "^"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "@"}]], "InlineFormula"],
 ". But for other kinds of boxes, you need to give ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input, prefaced by\[NonBreakingSpace]",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "*"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->27053],

Cell[TextData[{
 "This constructs a ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{"\\*", 
    RowBox[{"GridBox", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<a\>\"", ",", "\"\<b\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<c\>\"", ",", "\"\<d\>\""}], "}"}]}], "}"}], "]"}]}], 
   "\\)"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->6508],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b"},
    {"c", "d"}
   }],
  DisplayForm]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]//DisplayForm= ",
 CellID->16715]
}, Open  ]],

Cell[TextData[{
 "This constructs a ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{"\\*", 
    RowBox[{"StyleBox", "[", 
     RowBox[{"\"\<text\>\"", ",", 
      RowBox[{"FontWeight", "->", "\"\<Bold\>\""}]}], "]"}]}], "\\)"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->31066],

Cell[BoxData[
 TagBox[
  StyleBox["text",
   FontWeight->"Bold"],
  DisplayForm]], "Output",
 ImageSize->{32, 16},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]//DisplayForm= ",
 CellID->27689]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[Backslash]", "*"}]], "InlineFormula"],
 " in effect acts like an escape: it allows you to enter ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax even within a ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 " sequence. Note that the input you give after a ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "*"}]], "InlineFormula"],
 " can itself in turn contain ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 " sequences. "
}], "Text",
 CellID->14663],

Cell[TextData[{
 "You can alternate nested ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "*"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 ". Explicit quotes are needed outside of ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\\(", 
   RowBox[{"x", "+", 
    RowBox[{"\\*", 
     RowBox[{"GridBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<a\>\"", ",", "\"\<b\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\\(", 
           RowBox[{"c", "\\^", "2"}], "\\)"}], ",", 
          RowBox[{"\\(", 
           RowBox[{"d", "\\/", 
            RowBox[{"\\*", 
             RowBox[{"GridBox", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], "}"}], 
              "]"}]}]}], "\\)"}]}], "}"}]}], "}"}], "]"}]}]}], "\\)"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->5541],

Cell[BoxData[
 TagBox[
  RowBox[{"x", "+", GridBox[{
     {"a", "b"},
     {
      SuperscriptBox["c", "2"], 
      FractionBox["d", GridBox[{
         {"x", "y"},
         {"x", "y"}
        }]]}
    }]}],
  DisplayForm]], "Output",
 ImageSize->{69, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]//DisplayForm= ",
 CellID->16259]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[Backslash]", 
     RowBox[{"!", 
      RowBox[{"\[Backslash]", 
       RowBox[{"(", 
        RowBox[{
         StyleBox["input", "TI"], "\[Backslash]"}], ")"}]}]}]}], Cell[
    "interpret input in the current form", "TableText"]},
   {
    RowBox[{"\[Backslash]", 
     RowBox[{"!", 
      RowBox[{"\[Backslash]", 
       RowBox[{"(", 
        RowBox[{
         StyleBox["form", "TI"], "\[Backslash]", 
         StyleBox[
          RowBox[{"`", 
           StyleBox["input", "TI"]}]], "\[Backslash]"}], ")"}]}]}]}], Cell[
    "interpret input using the specified form", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23572],

Cell["Controlling the way input is interpreted. ", "Caption",
 CellID->2514],

Cell[TextData[{
 "In a ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " cell, this will be interpreted in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", yielding a product. "
}], "MathCaption",
 CellID->10966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\\!", 
  RowBox[{"\\(", 
   RowBox[{"c", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}], "\\)"}]}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->25988],

Cell[BoxData[
 RowBox[{"c", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->18170]
}, Open  ]],

Cell[TextData[{
 "The backslash backquote sequence tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to interpret this in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\\!", 
  RowBox[{"\\(", 
   RowBox[{"TraditionalForm", "\\`", 
    RowBox[{"c", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}]}], "\\)"}]}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->22199],

Cell[BoxData[
 RowBox[{"c", "[", 
  RowBox[{"1", "+", "x"}], "]"}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->655]
}, Open  ]],

Cell["\<\
When you copy the contents of a cell from a notebook into a program such as a \
text editor, no explicit backslash backquote sequence is usually included. \
But if you expect to paste what you get back into a cell of a different type \
from the one it came from, then you will typically need to include a \
backslash backquote sequence in order to ensure that everything is \
interpreted correctly.\
\>", "Text",
 CellID->3850],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->870471983],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"String Representation of Boxes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 4.6388446}", "context" -> "", 
    "keywords" -> {
     "backslash notations", "boxes", "control", "embedding", "escapes", 
      "FormBox", "Inline formulas", "input forms", "input raw boxes", 
      "Intext formulas", "lexical analysis", "make 2D menu item", 
      "pasting of boxes", "raw boxes", "strings", "text", "tokens", 
      "TraditionalForm", "Twodimensional notation", "two-dimensional string"},
     "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica provides a compact way of representing boxes in terms of \
strings. This is particularly convenient when you want to import or export \
specifications of boxes as ordinary text. This generates an InputForm string \
that represents the SuperscriptBox. This creates the SuperscriptBox. ", 
    "synonyms" -> {"2.9.12"}, "title" -> "String Representation of Boxes", 
    "type" -> "Tutorial", "uri" -> "tutorial/StringRepresentationOfBoxes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.12"->{
  Cell[2997, 77, 95, 2, 70, "Title",
   CellTags->{"S2.9.12", "12.1"},
   CellID->28564]},
 "12.1"->{
  Cell[2997, 77, 95, 2, 70, "Title",
   CellTags->{"S2.9.12", "12.1"},
   CellID->28564]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.12", 36420, 1368},
 {"12.1", 36522, 1372}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2372, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2997, 77, 95, 2, 70, "Title",
 CellTags->{"S2.9.12", "12.1"},
 CellID->28564],
Cell[3095, 81, 274, 7, 70, "Text",
 CellID->31539],
Cell[3372, 90, 363, 13, 70, "MathCaption",
 CellID->2572],
Cell[CellGroupData[{
Cell[3760, 107, 217, 7, 28, "Input",
 CellID->2257],
Cell[3980, 116, 178, 5, 36, "Output",
 CellID->2370]
}, Open  ]],
Cell[4173, 124, 209, 8, 70, "MathCaption",
 CellID->21920],
Cell[CellGroupData[{
Cell[4407, 136, 118, 4, 28, "Input",
 CellID->31654],
Cell[4528, 142, 235, 7, 36, "Output",
 CellID->19359]
}, Open  ]],
Cell[4778, 152, 346, 12, 70, "MathCaption",
 CellID->11080],
Cell[CellGroupData[{
Cell[5149, 168, 135, 4, 28, "Input",
 CellID->7298],
Cell[5287, 174, 344, 13, 50, "Output",
 CellID->23391]
}, Open  ]],
Cell[5646, 190, 219, 7, 70, "Text",
 CellID->23960],
Cell[5868, 199, 218, 8, 70, "MathCaption",
 CellID->30510],
Cell[CellGroupData[{
Cell[6111, 211, 118, 4, 70, "Input",
 CellID->29591],
Cell[6232, 217, 235, 7, 36, "Output",
 CellID->25867]
}, Open  ]],
Cell[6482, 227, 242, 8, 70, "MathCaption",
 CellID->22033],
Cell[CellGroupData[{
Cell[6749, 239, 138, 5, 70, "Input",
 CellID->1675],
Cell[6890, 246, 178, 6, 36, "Output",
 CellID->12136]
}, Open  ]],
Cell[7083, 255, 81, 1, 70, "MathCaption",
 CellID->30499],
Cell[CellGroupData[{
Cell[7189, 260, 176, 6, 70, "Input",
 CellID->17775],
Cell[7368, 268, 344, 13, 50, "Output",
 CellID->25790]
}, Open  ]],
Cell[7727, 284, 740, 23, 70, "DefinitionBox",
 CellID->14376],
Cell[8470, 309, 105, 3, 70, "Caption",
 CellID->31256],
Cell[8578, 314, 1060, 32, 70, "Text",
 CellID->20272],
Cell[9641, 348, 444, 15, 70, "Text",
 CellID->20703],
Cell[10088, 365, 608, 15, 70, "DefinitionBox",
 CellID->5086],
Cell[10699, 382, 104, 3, 70, "Caption",
 CellID->20967],
Cell[10806, 387, 664, 20, 70, "Text",
 CellID->9515],
Cell[11473, 409, 149, 5, 70, "MathCaption",
 CellID->23542],
Cell[CellGroupData[{
Cell[11647, 418, 89, 2, 70, "Input",
 CellID->23495],
Cell[11739, 422, 176, 5, 36, "Output",
 CellID->3566]
}, Open  ]],
Cell[11930, 430, 225, 9, 70, "MathCaption",
 CellID->18456],
Cell[CellGroupData[{
Cell[12180, 443, 92, 2, 70, "Input",
 CellID->14186],
Cell[12275, 447, 179, 5, 36, "Output",
 CellID->8437]
}, Open  ]],
Cell[12469, 455, 77, 1, 70, "MathCaption",
 CellID->19198],
Cell[CellGroupData[{
Cell[12571, 460, 118, 2, 70, "Input",
 CellID->12626],
Cell[12692, 464, 207, 5, 36, "Output",
 CellID->18364]
}, Open  ]],
Cell[12914, 472, 5259, 181, 70, "DefinitionBox",
 CellID->1085],
Cell[18176, 655, 58, 1, 70, "Caption",
 CellID->31665],
Cell[18237, 658, 687, 23, 70, "Text",
 CellID->18908],
Cell[18927, 683, 98, 2, 70, "MathCaption",
 CellID->20340],
Cell[CellGroupData[{
Cell[19050, 689, 207, 8, 70, "Input",
 CellID->1360],
Cell[19260, 699, 263, 10, 65, "Output",
 CellID->2814]
}, Open  ]],
Cell[19538, 712, 99, 2, 70, "MathCaption",
 CellID->21154],
Cell[CellGroupData[{
Cell[19662, 718, 182, 7, 70, "Input",
 CellID->18012],
Cell[19847, 727, 239, 9, 65, "Output",
 CellID->19752]
}, Open  ]],
Cell[20101, 739, 263, 8, 70, "MathCaption",
 CellID->3338],
Cell[CellGroupData[{
Cell[20389, 751, 211, 8, 70, "Input",
 CellID->8706],
Cell[20603, 761, 239, 9, 65, "Output",
 CellID->12525]
}, Open  ]],
Cell[20857, 773, 366, 14, 70, "MathCaption",
 CellID->30630],
Cell[CellGroupData[{
Cell[21248, 791, 172, 6, 70, "Input",
 CellID->29249],
Cell[21423, 799, 349, 11, 36, "Output",
 CellID->23179]
}, Open  ]],
Cell[21787, 813, 808, 25, 70, "Text",
 CellID->3079],
Cell[22598, 840, 351, 14, 70, "MathCaption",
 CellID->8313],
Cell[CellGroupData[{
Cell[22974, 858, 151, 5, 70, "Input",
 CellID->28838],
Cell[23128, 865, 422, 15, 50, "Output",
 CellID->32517]
}, Open  ]],
Cell[23565, 883, 141, 5, 70, "MathCaption",
 CellID->8421],
Cell[CellGroupData[{
Cell[23731, 892, 163, 6, 70, "Input",
 CellID->14145],
Cell[23897, 900, 421, 15, 50, "Output",
 CellID->5991]
}, Open  ]],
Cell[24333, 918, 211, 8, 70, "MathCaption",
 CellID->16565],
Cell[CellGroupData[{
Cell[24569, 930, 177, 6, 70, "Input",
 CellID->23762],
Cell[24749, 938, 554, 18, 50, "Output",
 CellID->19473]
}, Open  ]],
Cell[25318, 959, 217, 7, 70, "MathCaption",
 CellID->23681],
Cell[CellGroupData[{
Cell[25560, 970, 171, 6, 70, "Input",
 CellID->21970],
Cell[25734, 978, 532, 18, 50, "Output",
 CellID->23147]
}, Open  ]],
Cell[26281, 999, 677, 23, 70, "Text",
 CellID->27053],
Cell[26961, 1024, 196, 8, 70, "MathCaption",
 CellID->22708],
Cell[CellGroupData[{
Cell[27182, 1036, 387, 13, 70, "Input",
 CellID->6508],
Cell[27572, 1051, 237, 10, 62, "Output",
 CellID->16715]
}, Open  ]],
Cell[27824, 1064, 197, 8, 70, "MathCaption",
 CellID->4429],
Cell[CellGroupData[{
Cell[28046, 1076, 274, 9, 70, "Input",
 CellID->31066],
Cell[28323, 1087, 233, 9, 51, "Output",
 CellID->27689]
}, Open  ]],
Cell[28571, 1099, 738, 25, 70, "Text",
 CellID->14663],
Cell[29312, 1126, 522, 20, 70, "MathCaption",
 CellID->11771],
Cell[CellGroupData[{
Cell[29859, 1150, 883, 27, 70, "Input",
 CellID->5541],
Cell[30745, 1179, 374, 16, 82, "Output",
 CellID->16259]
}, Open  ]],
Cell[31134, 1198, 940, 28, 70, "DefinitionBox",
 CellID->23572],
Cell[32077, 1228, 76, 1, 70, "Caption",
 CellID->2514],
Cell[32156, 1231, 380, 13, 70, "MathCaption",
 CellID->10966],
Cell[CellGroupData[{
Cell[32561, 1248, 184, 7, 70, "Input",
 CellID->25988],
Cell[32748, 1257, 225, 8, 36, "Output",
 CellID->18170]
}, Open  ]],
Cell[32988, 1268, 309, 11, 70, "MathCaption",
 CellID->28168],
Cell[CellGroupData[{
Cell[33322, 1283, 227, 8, 70, "Input",
 CellID->22199],
Cell[33552, 1293, 204, 7, 36, "Output",
 CellID->655]
}, Open  ]],
Cell[33771, 1303, 437, 8, 70, "Text",
 CellID->3850],
Cell[CellGroupData[{
Cell[34233, 1315, 72, 1, 70, "RelatedTutorialsSection",
 CellID->870471983],
Cell[34308, 1318, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[34513, 1326, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

