(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39105,       1140]
NotebookOptionsPosition[     33220,        965]
NotebookOutlinePosition[     36503,       1043]
CellTagsIndexPosition[     36409,       1037]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Mathematical and Other Notation" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/MathematicalAndOtherNotationOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Mathematical and Other Notation\"\>"}, "\<\"related tutorials\"\
\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Structural Elements and Keyboard Characters", "Title",
 CellTags->{"S3.10.5", "5.1"},
 CellID->13444],

Cell[BoxData[GridBox[{
   {GridBox[{
      {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
      {"\[InvisibleComma]", Cell[BoxData[
        ButtonBox["\\[InvisibleComma]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/InvisibleComma"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace],\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[InvisibleApplication]", Cell[BoxData[
        ButtonBox["\\[InvisibleApplication]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/InvisibleApplication"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]@\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[InvisibleSpace]", Cell[BoxData[
        ButtonBox["\\[InvisibleSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/InvisibleSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]is\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[ImplicitPlus]", Cell[BoxData[
        ButtonBox["\\[ImplicitPlus]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/ImplicitPlus"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]+\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
      {"\[AlignmentMarker]", Cell[BoxData[
        ButtonBox["\\[AlignmentMarker]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/AlignmentMarker"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]am\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[NoBreak]", Cell[BoxData[
        ButtonBox["\\[NoBreak]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/NoBreak"]], "InlineCharacterName"],
        Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]nb\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[Null]", Cell[BoxData[
        ButtonBox["\\[Null]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/Null"]], "InlineCharacterName"], 
       Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]null\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->12936],

Cell["Invisible characters.", "Caption",
 CellID->16278],

Cell[TextData[{
 "In the input there is an invisible comma between the ",
 Cell[BoxData["1"], "InlineFormula"],
 " and ",
 Cell[BoxData["2"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19406],

Cell[CellGroupData[{

Cell[BoxData[
 SubscriptBox["m", 
  RowBox[{"1", "\[InvisibleComma]", "2"}]]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29427],

Cell[BoxData[
 SubscriptBox["m", 
  RowBox[{"1", ",", "2"}]]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->10313]
}, Open  ]],

Cell[TextData[{
 "Here there is an invisible space between the ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ", interpreted as multiplication. "
}], "MathCaption",
 CellID->7523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"x", "\[InvisibleSpace]", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->32371],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"x", ",", "y"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm= ",
 CellID->23327]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[Null]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Null"]], "InlineCharacterName"],
 " does not display, but can take modifications such as superscripts. "
}], "MathCaption",
 CellID->17073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", 
   RowBox[{"\[Null]", "^", "a"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->23461],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", 
   SuperscriptBox["\[Null]", "a"]}], "]"}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->19199427]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["\\[AlignmentMarker]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/AlignmentMarker"]], 
  "InlineCharacterName"],
 " does not display, but shows how to line up the elements of the column. "
}], "MathCaption",
 CellID->9934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "\"\<b \[AlignmentMarker]+ c + d\>\"", "}"}], ",", 
      RowBox[{"{", "\"\<a + b \[AlignmentMarker]+ c\>\"", "}"}]}], "}"}], ",",
     
    RowBox[{"Alignment", "->", "\"\<\[AlignmentMarker]\>\""}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->31102],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {"\<\"b \[AlignmentMarker]+ c + d\"\>"},
     {"\<\"a + b \[AlignmentMarker]+ c\"\>"}
    },
    GridBoxAlignment->{
     "Columns" -> {{"\[AlignmentMarker]"}}, 
      "Rows" -> {{"\[AlignmentMarker]"}}}],
   "Grid"],
  DisplayForm]], "Output",
 ImageSize->{95, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]//DisplayForm=",
 CellID->643606580]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["\\[ImplicitPlus]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ImplicitPlus"]], "InlineCharacterName"],
 " operator is used as a hidden plus sign in mixed fractions."
}], "MathCaption",
 CellID->6979432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "\[ImplicitPlus]", 
  FractionBox["2", "3"]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249949940],

Cell[BoxData[
 FractionBox["5", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120025161]
}, Open  ]],

Cell[BoxData[GridBox[{
   {GridBox[{
      {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
      {"\[VeryThinSpace]", Cell[BoxData[
        ButtonBox["\\[VeryThinSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/VeryThinSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]\[SpaceIndicator]\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[ThinSpace]", Cell[BoxData[
        ButtonBox["\\[ThinSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/ThinSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox[
        "\[ThinSpace]\[SpaceIndicator]\[SpaceIndicator]\[ThinSpace]", 
         "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[MediumSpace]", Cell[BoxData[
        ButtonBox["\\[MediumSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/MediumSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox[
        "\[ThinSpace]\[SpaceIndicator]\[SpaceIndicator]\[SpaceIndicator]\
\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[ThickSpace]", Cell[BoxData[
        ButtonBox["\\[ThickSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/ThickSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox[
        "\[ThinSpace]\[SpaceIndicator]\[SpaceIndicator]\[SpaceIndicator]\
\[SpaceIndicator]\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[InvisibleSpace]", Cell[BoxData[
        ButtonBox["\\[InvisibleSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/InvisibleSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]is\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\n", Cell[BoxData[
        ButtonBox["\\[NewLine]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/NewLine"]], "InlineCharacterName"],
        ""}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
      {"\[NegativeVeryThinSpace]", Cell[BoxData[
        ButtonBox["\\[NegativeVeryThinSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/NegativeVeryThinSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]-\[SpaceIndicator]\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[NegativeThinSpace]", Cell[BoxData[
        ButtonBox["\\[NegativeThinSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/NegativeThinSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox[
        "\[ThinSpace]-\[SpaceIndicator]\[SpaceIndicator]\[ThinSpace]", 
         "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[NegativeMediumSpace]", Cell[BoxData[
        ButtonBox["\\[NegativeMediumSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/NegativeMediumSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox[
        "\[ThinSpace]-\[SpaceIndicator]\[SpaceIndicator]\[SpaceIndicator]\
\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[NegativeThickSpace]", Cell[BoxData[
        ButtonBox["\\[NegativeThickSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/NegativeThickSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox[
        "\[ThinSpace]-\[SpaceIndicator]\[SpaceIndicator]\[SpaceIndicator]\
\[SpaceIndicator]\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[NonBreakingSpace]", Cell[BoxData[
        ButtonBox["\\[NonBreakingSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/NonBreakingSpace"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]nbs\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[IndentingNewLine]", Cell[BoxData[
        ButtonBox["\\[IndentingNewLine]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/IndentingNewLine"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]nl\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->31417],

Cell["Spacing and newline characters. ", "Caption",
 CellID->31463],

Cell[BoxData[GridBox[{
   {GridBox[{
      {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
       "alias", "TableHeader"]},
      {"\[SelectionPlaceholder]", Cell[BoxData[
        ButtonBox["\\[SelectionPlaceholder]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/SelectionPlaceholder"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]spl\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
       "alias", "TableHeader"]},
      {"\[Placeholder]", Cell[BoxData[
        ButtonBox["\\[Placeholder]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/Placeholder"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]pl\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->6153],

Cell["Characters used in buttons. ", "Caption",
 CellID->26126],

Cell[TextData[{
 "In the buttons in a palette, you often want to set up a template with \
placeholders to indicate where expressions should be inserted. ",
 Cell[BoxData[
  ButtonBox["\\[SelectionPlaceholder]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/SelectionPlaceholder"]], 
  "InlineCharacterName"],
 " marks the position where an expression that is currently selected should \
be inserted when the contents of the button are pasted. ",
 Cell[BoxData[
  ButtonBox["\\[Placeholder]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Placeholder"]], "InlineCharacterName"],
 " marks other positions where subsequent expressions can be inserted. The \
Tab key will take you from one such position to the next. "
}], "Text",
 CellID->20595],

Cell[BoxData[GridBox[{
   {GridBox[{
      {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
       "alias", "TableHeader"]},
      {"\[SpaceIndicator]", Cell[BoxData[
        ButtonBox["\\[SpaceIndicator]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/SpaceIndicator"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]space\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[ReturnIndicator]", Cell[BoxData[
        ButtonBox["\\[ReturnIndicator]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/ReturnIndicator"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]ret\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[ReturnKey]", Cell[BoxData[
        ButtonBox["\\[ReturnKey]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/ReturnKey"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox[
        "\[ThinSpace]\[SpaceIndicator]ret\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[EnterKey]", Cell[BoxData[
        ButtonBox["\\[EnterKey]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/EnterKey"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]ent\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[EscapeKey]", Cell[BoxData[
        ButtonBox["\\[EscapeKey]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/EscapeKey"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox[
        "\[ThinSpace]\[SpaceIndicator]esc\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[AliasIndicator]", Cell[BoxData[
        ButtonBox["\\[AliasIndicator]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/AliasIndicator"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]esc\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], Cell[
       "alias", "TableHeader"]},
      {"\[RoundSpaceIndicator]", Cell[BoxData[
        ButtonBox["\\[RoundSpaceIndicator]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RoundSpaceIndicator"]], 
        "InlineCharacterName"], ""},
      {"\[ControlKey]", Cell[BoxData[
        ButtonBox["\\[ControlKey]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/ControlKey"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]ctrl\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[CommandKey]", Cell[BoxData[
        ButtonBox["\\[CommandKey]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/CommandKey"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]cmd\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[LeftModified]", Cell[BoxData[
        ButtonBox["\\[LeftModified]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/LeftModified"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace][\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[RightModified]", Cell[BoxData[
        ButtonBox["\\[RightModified]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RightModified"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]]\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]},
      {"\[CloverLeaf]", Cell[BoxData[
        ButtonBox["\\[CloverLeaf]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/CloverLeaf"]], 
        "InlineCharacterName"], Cell[TextData[{
        StyleBox["Esc", "KeyEvent"],
        StyleBox["\[ThinSpace]cl\[ThinSpace]", "InlineCode"],
        StyleBox["Esc", "KeyEvent"]
       }], "TableText"]}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->1495],

Cell["Representations of keys on a keyboard. ", "Caption",
 CellID->29213],

Cell[TextData[{
 "In describing how to enter input into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it is sometimes useful to give explicit representations for keys you \
should press. You can do this using characters like ",
 Cell[BoxData["\[ReturnIndicator]"], "InlineFormula"],
 " and ",
 Cell[BoxData["\[EscapeKey]"], "InlineFormula"],
 ". Note that ",
 Cell[BoxData["\[SpaceIndicator]"], "InlineFormula"],
 " and ",
 Cell[BoxData["\[RoundSpaceIndicator]"], "InlineFormula"],
 " are actually treated as spacing characters by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->2406],

Cell[TextData[{
 "This string shows how to type ",
 Cell[BoxData[
  SuperscriptBox["\[Alpha]", "2"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27370],

Cell[CellGroupData[{

Cell[BoxData["\"\<\[EscapeKey]a\[EscapeKey] \[ControlKey]\[LeftModified]^\
\[RightModified]2 \[ControlKey]\[LeftModified]\[SpaceIndicator]\
\[RightModified]\>\""], "Input",
 CellLabel->"In[5]:= ",
 CellID->23859],

Cell[BoxData["\<\"\[EscapeKey]a\[EscapeKey] \[ControlKey]\[LeftModified]^\
\[RightModified]2 \[ControlKey]\[LeftModified]\[SpaceIndicator]\
\[RightModified]\"\>"], "Output",
 ImageSize->{120, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->23305]
}, Open  ]],

Cell[BoxData[GridBox[{
   {GridBox[{
      {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
      {"\[Continuation]", Cell[BoxData[
        ButtonBox["\\[Continuation]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/Continuation"]], 
        "InlineCharacterName"], ""},
      {"\[LeftSkeleton]", Cell[BoxData[
        ButtonBox["\\[LeftSkeleton]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/LeftSkeleton"]], 
        "InlineCharacterName"], ""},
      {"\[RightSkeleton]", Cell[BoxData[
        ButtonBox["\\[RightGuillemet]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RightSkeleton"]], 
        "InlineCharacterName"], ""}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
      {"\[SkeletonIndicator]", Cell[BoxData[
        ButtonBox["\\[SkeletonIndicator]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/SkeletonIndicator"]], 
        "InlineCharacterName"], ""},
      {"\[ErrorIndicator]", Cell[BoxData[
        ButtonBox["\\[ErrorIndicator]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/ErrorIndicator"]], 
        "InlineCharacterName"], ""}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->22496],

Cell[TextData[{
 "Characters generated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. "
}], "Caption",
 CellID->24833],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a ",
 Cell[BoxData[
  ButtonBox["\\[Continuation]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Continuation"]], "InlineCharacterName"],
 " character to indicate that the number continues onto the next line. "
}], "MathCaption",
 CellID->24223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"80", "!"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4852],

Cell[BoxData[\
"71569457046263802294811533723186532165584657342365752577109445058227039255480\
148842668944867280814080000000000000000000"], "Output",
 ImageSize->{583, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->429803374]
}, Open  ]],

Cell[BoxData[GridBox[{
   {GridBox[{
      {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
      {"\t", Cell[BoxData[
        ButtonBox["\\[RawTab]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawTab"]], "InlineCharacterName"], 
       ""},
      {"\n", Cell[BoxData[
        ButtonBox["\\[NewLine]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/NewLine"]], "InlineCharacterName"],
        ""},
      {"\n", Cell[BoxData[
        ButtonBox["\\[RawReturn]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawReturn"]], 
        "InlineCharacterName"], ""},
      {" ", Cell[BoxData[
        ButtonBox["\\[RawSpace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawSpace"]], 
        "InlineCharacterName"], ""},
      {"!", Cell[BoxData[
        ButtonBox["\\[RawExclamation]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawExclamation"]], 
        "InlineCharacterName"], ""},
      {"\"\<\>", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawDoubleQuote", "]"}]}], ""},
      {"#", Cell[BoxData[
        ButtonBox["\\[RawNumberSign]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawNumberSign"]], 
        "InlineCharacterName"], ""},
      {"$", Cell[BoxData[
        ButtonBox["\\[RawDollar]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawDollar"]], 
        "InlineCharacterName"], ""},
      {"%", Cell[BoxData[
        ButtonBox["\\[RawPercent]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawPercent"]], 
        "InlineCharacterName"], ""},
      {"&", Cell[BoxData[
        ButtonBox["\\[RawAmpersand]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawAmpersand"]], 
        "InlineCharacterName"], ""},
      {"'", Cell[BoxData[
        ButtonBox["\\[RawQuote]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawQuote"]], 
        "InlineCharacterName"], ""},
      {"(", Cell[BoxData[
        ButtonBox["\\[RawLeftParenthesis]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawLeftParenthesis"]], 
        "InlineCharacterName"], ""},
      {")", Cell[BoxData[
        ButtonBox["\\[RawRightParenthesis]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawRightParenthesis"]], 
        "InlineCharacterName"], ""},
      {"*", Cell[BoxData[
        ButtonBox["\\[RawStar]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawStar"]], "InlineCharacterName"],
        ""},
      {"+", Cell[BoxData[
        ButtonBox["\\[RawPlus]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawPlus"]], "InlineCharacterName"],
        ""},
      {",", Cell[BoxData[
        ButtonBox["\\[RawComma]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawComma"]], 
        "InlineCharacterName"], ""},
      {"-", Cell[BoxData[
        ButtonBox["\\[RawDash]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawDash"]], "InlineCharacterName"],
        ""},
      {".", Cell[BoxData[
        ButtonBox["\\[RawDot]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawDot"]], "InlineCharacterName"], 
       ""}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {Cell["form", "TableHeader"], Cell["full name", "TableHeader"], ""},
      {"/", Cell[BoxData[
        ButtonBox["\\[RawSlash]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawSlash"]], 
        "InlineCharacterName"], ""},
      {":", Cell[BoxData[
        ButtonBox["\\[RawColon]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawColon"]], 
        "InlineCharacterName"], ""},
      {";", Cell[BoxData[
        ButtonBox["\\[RawSemicolon]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawSemicolon"]], 
        "InlineCharacterName"], ""},
      {"<", Cell[BoxData[
        ButtonBox["\\[RawLess]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawLess"]], "InlineCharacterName"],
        ""},
      {"=", Cell[BoxData[
        ButtonBox["\\[RawEqual]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawEqual"]], 
        "InlineCharacterName"], ""},
      {">", Cell[BoxData[
        ButtonBox["\\[RawGreater]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawGreater"]], 
        "InlineCharacterName"], ""},
      {"?", Cell[BoxData[
        ButtonBox["\\[RawQuestion]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawQuestion"]], 
        "InlineCharacterName"], ""},
      {"@", Cell[BoxData[
        ButtonBox["\\[RawAt]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawAt"]], "InlineCharacterName"], 
       ""},
      {"[", Cell[BoxData[
        ButtonBox["\\[RawLeftBracket]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawLeftBracket"]], 
        "InlineCharacterName"], ""},
      {"\\", Cell[BoxData[
        ButtonBox["\\[RawBackslash]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawBackslash"]], 
        "InlineCharacterName"], ""},
      {"]", Cell[BoxData[
        ButtonBox["\\[RawRightBracket]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawRightBracket"]], 
        "InlineCharacterName"], ""},
      {"^", Cell[BoxData[
        ButtonBox["\\[RawWedge]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawWedge"]], 
        "InlineCharacterName"], ""},
      {"_", Cell[BoxData[
        ButtonBox["\\[RawUnderscore]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawUnderscore"]], 
        "InlineCharacterName"], ""},
      {"`", Cell[BoxData[
        ButtonBox["\\[RawBackquote]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawBackquote"]], 
        "InlineCharacterName"], ""},
      {"{", Cell[BoxData[
        ButtonBox["\\[RawLeftBrace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawLeftBrace"]], 
        "InlineCharacterName"], ""},
      {"|", Cell[BoxData[
        ButtonBox["\\[RawVerticalBar]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawVerticalBar"]], 
        "InlineCharacterName"], ""},
      {"}", Cell[BoxData[
        ButtonBox["\\[RawRightBrace]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawRightBrace"]], 
        "InlineCharacterName"], ""},
      {"~", Cell[BoxData[
        ButtonBox["\\[RawTilde]",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/character/RawTilde"]], 
        "InlineCharacterName"], ""}
     },
     GridBoxAlignment->{
      "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->30519],

Cell["Raw keyboard characters. ", "Caption",
 CellID->6126],

Cell[TextData[{
 "The fonts that are distributed with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contain their own renderings of many ordinary keyboard characters. The \
reason for this is that standard system fonts often do not contain \
appropriate renderings. For example, ",
 Cell[BoxData["^"], "InlineFormula"],
 " and ",
 Cell[BoxData["~"], "InlineFormula"],
 " are often drawn small and above the centerline, while for clarity in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " they must be drawn larger and centered on the centerline."
}], "Text",
 CellID->7793],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->151604493],

Cell[TextData[ButtonBox["Mathematical and Other Notation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "RelatedTutorials",\

 CellID->5715683]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Structural Elements and Keyboard Characters - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical and Other Notation", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Operators#27644"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 6.3107624}", "context" -> "", 
    "keywords" -> {
     "AliasIndicator", "apart", "Apple key", "\\backprime (TeX)", 
      "bird tracks", "black blobs", "closer", "CloverLeaf", "comma", 
      "command key", "\\diagup (TeX)", "empty boxes", "escape indicator", 
      "filled boxes", "font matching", "further", "iconic characters", 
      "implicit function application", "implicit multiplication", 
      "indentation", "indicator characters", "indices", "insertion box", 
      "InvisibleApplication", "invisible characters", "InvisibleComma", 
      "keys", "\\lbrace (TeX)", "line breaking", "\\lq (TeX)", 
      "Macintosh command key", "matching", "matrix indices", "modifier keys", 
      "Nonprinting characters", "RawBackquote", "RawLeftBrace", 
      "RawLeftParenthesis", "RawQuote", "RawRightBrace", "RawSlash", 
      "\\rbrace (TeX)", "roundabout indicator", "round brackets", 
      "RoundSpaceIndicator", "\\rq (TeX)", "slash", "solidus", 
      "spacing characters", "stroke", "subscripts", "tie", "together", 
      "Zerowidth space"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Invisible characters. In the input there is an invisible comma between \
the 1 and 2. Here there is an invisible space between the x and y, \
interpreted as multiplication. ", "synonyms" -> {"3.10.5"}, "title" -> 
    "Structural Elements and Keyboard Characters", "type" -> "Tutorial", 
    "uri" -> "tutorial/StructuralElementsAndKeyboardCharacters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.10.5"->{
  Cell[1293, 44, 107, 2, 70, "Title",
   CellTags->{"S3.10.5", "5.1"},
   CellID->13444]},
 "5.1"->{
  Cell[1293, 44, 107, 2, 70, "Title",
   CellTags->{"S3.10.5", "5.1"},
   CellID->13444]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.10.5", 36194, 1026},
 {"5.1", 36295, 1030}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 668, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1293, 44, 107, 2, 70, "Title",
 CellTags->{"S3.10.5", "5.1"},
 CellID->13444],
Cell[1403, 48, 3190, 77, 70, "DoubleBox",
 CellID->12936],
Cell[4596, 127, 56, 1, 70, "Caption",
 CellID->16278],
Cell[4655, 130, 200, 7, 70, "MathCaption",
 CellID->19406],
Cell[CellGroupData[{
Cell[4880, 141, 127, 4, 28, "Input",
 CellID->29427],
Cell[5010, 147, 199, 7, 36, "Output",
 CellID->10313]
}, Open  ]],
Cell[5224, 157, 222, 7, 70, "MathCaption",
 CellID->7523],
Cell[CellGroupData[{
Cell[5471, 168, 140, 4, 28, "Input",
 CellID->32371],
Cell[5614, 174, 344, 13, 50, "Output",
 CellID->23327]
}, Open  ]],
Cell[5973, 190, 253, 7, 70, "MathCaption",
 CellID->17073],
Cell[CellGroupData[{
Cell[6251, 201, 146, 5, 28, "Input",
 CellID->23461],
Cell[6400, 208, 238, 8, 36, "Output",
 CellID->19199427]
}, Open  ]],
Cell[6653, 219, 290, 9, 70, "MathCaption",
 CellID->9934],
Cell[CellGroupData[{
Cell[6968, 232, 395, 12, 70, "Input",
 CellID->31102],
Cell[7366, 246, 435, 15, 62, "Output",
 CellID->643606580]
}, Open  ]],
Cell[7816, 264, 271, 8, 70, "MathCaption",
 CellID->6979432],
Cell[CellGroupData[{
Cell[8112, 276, 127, 4, 70, "Input",
 CellID->249949940],
Cell[8242, 282, 178, 6, 51, "Output",
 CellID->120025161]
}, Open  ]],
Cell[8435, 291, 5378, 130, 70, "DoubleBox",
 CellID->31417],
Cell[13816, 423, 67, 1, 70, "Caption",
 CellID->31463],
Cell[13886, 426, 1394, 34, 70, "DoubleBox",
 CellID->6153],
Cell[15283, 462, 63, 1, 70, "Caption",
 CellID->26126],
Cell[15349, 465, 768, 17, 70, "Text",
 CellID->20595],
Cell[16120, 484, 5018, 122, 70, "DoubleBox",
 CellID->1495],
Cell[21141, 608, 74, 1, 70, "Caption",
 CellID->29213],
Cell[21218, 611, 625, 18, 70, "Text",
 CellID->2406],
Cell[21846, 631, 160, 6, 70, "MathCaption",
 CellID->27370],
Cell[CellGroupData[{
Cell[22031, 641, 212, 4, 70, "Input",
 CellID->23859],
Cell[22246, 647, 301, 7, 36, "Output",
 CellID->23305]
}, Open  ]],
Cell[22562, 657, 1598, 39, 70, "DoubleBox",
 CellID->22496],
Cell[24163, 698, 137, 6, 70, "Caption",
 CellID->24833],
Cell[24303, 706, 332, 10, 70, "MathCaption",
 CellID->24223],
Cell[CellGroupData[{
Cell[24660, 720, 83, 3, 70, "Input",
 CellID->4852],
Cell[24746, 725, 281, 7, 54, "Output",
 CellID->429803374]
}, Open  ]],
Cell[25042, 735, 7178, 192, 70, "DoubleBox",
 CellID->30519],
Cell[32223, 929, 59, 1, 70, "Caption",
 CellID->6126],
Cell[32285, 932, 589, 15, 70, "Text",
 CellID->7793],
Cell[CellGroupData[{
Cell[32899, 951, 72, 1, 70, "RelatedTutorialsSection",
 CellID->151604493],
Cell[32974, 954, 192, 5, 70, "RelatedTutorials",
 CellID->5715683]
}, Open  ]]
}, Open  ]],
Cell[33193, 963, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

