(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49900,       1811]
NotebookOptionsPosition[     40203,       1498]
NotebookOutlinePosition[     43789,       1580]
CellTagsIndexPosition[     43694,       1574]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distribute" :> 
          Documentation`HelpLookup["paclet:ref/Distribute"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], "Flatten" :> 
          Documentation`HelpLookup["paclet:ref/Flatten"], "FlattenAt" :> 
          Documentation`HelpLookup["paclet:ref/FlattenAt"], "Inner" :> 
          Documentation`HelpLookup["paclet:ref/Inner"], "Order" :> 
          Documentation`HelpLookup["paclet:ref/Order"], "OrderedQ" :> 
          Documentation`HelpLookup["paclet:ref/OrderedQ"], "Ordering" :> 
          Documentation`HelpLookup["paclet:ref/Ordering"], "Outer" :> 
          Documentation`HelpLookup["paclet:ref/Outer"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "Thread" :> 
          Documentation`HelpLookup["paclet:ref/Thread"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Distribute\"\>", 2->"\<\"False\"\>", 
       3->"\<\"Flatten\"\>", 4->"\<\"FlattenAt\"\>", 5->"\<\"Inner\"\>", 
       6->"\<\"Order\"\>", 7->"\<\"OrderedQ\"\>", 8->"\<\"Ordering\"\>", 
       9->"\<\"Outer\"\>", 10->"\<\"Sort\"\>", 11->"\<\"Thread\"\>", 
       12->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Structural Operations", "Title",
 CellTags->{"S2.2.10", "10.1"},
 CellID->31585],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contains some powerful primitives for making structural changes to \
expressions. You can use these primitives both to implement mathematical \
properties such as associativity and distributivity, and to provide the basis \
for some succinct and efficient programs. "
}], "Text",
 CellID->21465],

Cell[TextData[{
 "Here we describe various operations that you can explicitly perform on \
expressions. \"",
 ButtonBox["Attributes",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Attributes"],
 "\" describes how some of these operations can be performed automatically on \
all expressions with a particular head by assigning appropriate attributes to \
that head. "
}], "Text",
 CellID->31371],

Cell[TextData[{
 "You can use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " to sort elements not only of lists, but of expressions with any head. In \
this way, you can implement the mathematical properties of commutativity or \
symmetry for arbitrary functions. "
}], "Text",
 CellID->15444],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " to put the arguments of any function into a standard order. "
}], "MathCaption",
 CellID->17107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"f", "[", 
   RowBox[{"c", ",", "a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->17271],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->24087]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sort",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sort"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["\<\
sort the elements of a list or other expression into a standard order\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Sort",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sort"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["pred", "TI"], "]"}], Cell[TextData[{
     "sort using the function ",
     Cell[BoxData[
      StyleBox["pred", "TI"]], "InlineFormula"],
     " to determine whether pairs are in order"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Ordering",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ordering"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "give the ordering of elements when sorted", "TableText"]},
   {
    RowBox[{
     ButtonBox["Ordering",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ordering"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the ordering of the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements when sorted"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Ordering",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ordering"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["pred", "TI"], "]"}], Cell[TextData[{
     "use the function ",
     Cell[BoxData[
      StyleBox["pred", "TI"]], "InlineFormula"],
     " to determine whether pairs are in order"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OrderedQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OrderedQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the elements of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " are in standard order, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Order",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Order"], "[", 
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData["1"], "InlineFormula"],
     " if ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], "1"]], "InlineFormula"],
     " comes before ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], "2"]], "InlineFormula"],
     " in standard order, and ",
     Cell[BoxData[
      RowBox[{"-", "1"}]], "InlineFormula"],
     " if it comes after"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28099],

Cell["Sorting into order. ", "Caption",
 CellID->16519],

Cell[TextData[{
 "The second argument to ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " is a function used to determine whether pairs are in order. This sorts \
numbers into descending order. "
}], "MathCaption",
 CellID->8596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "8", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#2", "<", "#1"}], ")"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->5715],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "5", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->17552]
}, Open  ]],

Cell[TextData[{
 "This sorting criterion puts elements that do not depend on ",
 Cell[BoxData["x"], "InlineFormula"],
 " before those that do. "
}], "MathCaption",
 CellID->22492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", "y", ",", 
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"y", "-", "2"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"#1", ",", "x"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->14753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "y"}], ",", 
   RowBox[{"x", "+", "y"}], ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{132, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->8257]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "flatten out all nested functions with the same head as ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "flatten at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " levels of nesting"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["h", "TI"], "]"}], Cell[TextData[{
     "flatten functions with head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FlattenAt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FlattenAt"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "flatten only the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " element of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27590],

Cell["Flattening out expressions. ", "Caption",
 CellID->24959],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " removes nested occurrences of a function. "
}], "MathCaption",
 CellID->13357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", 
    RowBox[{"f", "[", 
     RowBox[{"b", ",", "c"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "d", "]"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->10886],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->7809]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " to \[OpenCurlyDoubleQuote]splice\[CloseCurlyDoubleQuote] sequences of \
elements into lists or other expressions. "
}], "MathCaption",
 CellID->5865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "c"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b", ",", "d"}], "]"}]}], "}"}], ",", "1", ",", "f"}],
   "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->25686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "a", ",", "b", ",", "d"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->32019]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " to implement the mathematical property of associativity. The function ",
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 " allows you to implement properties such as distributivity and linearity. "
}], "Text",
 CellID->259],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Distribute",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Distribute"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["a", "TI"], "+", 
     StyleBox["b", "TI"], "+", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", "]"}], Cell[TextData[{
     "distribute ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over sums to give ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["f", "TI"], "[", 
        RowBox[{
         StyleBox["a", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], "+", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        RowBox[{
         StyleBox["b", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], "+", 
       StyleBox["\[Ellipsis]", "TR"], "  "}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Distribute",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Distribute"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", ",", 
     StyleBox["g", "TI"], "]"}], Cell[TextData[{
     "distribute ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over any arguments which have head ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Distribute",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Distribute"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "distribute only when the head is ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Distribute",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Distribute"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["f", "TI"], ",", 
     StyleBox["gp", "TI"], ",", 
     StyleBox["fp", "TI"], "]"}], Cell[TextData[{
     "distribute ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ", replacing them with ",
     Cell[BoxData[
      StyleBox["fp", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["gp", "TI"]], "InlineFormula"],
     ", respectively"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22313],

Cell["Applying distributive laws. ", "Caption",
 CellID->2435],

Cell[TextData[{
 "This \[OpenCurlyDoubleQuote]distributes\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["f"], "InlineFormula"],
 " over ",
 Cell[BoxData[
  RowBox[{"a", "+", "b"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{"f", "[", 
   RowBox[{"a", "+", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->4101],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a", "]"}], "+", 
  RowBox[{"f", "[", "b", "]"}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->10468]
}, Open  ]],

Cell["Here is a more complicated example. ", "MathCaption",
 CellID->22869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"c", "+", "d"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->456],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "c"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "d"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", "c"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", "d"}], "]"}]}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->6731]
}, Open  ]],

Cell[TextData[{
 "In general, if ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is distributive over ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", then an expression like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["a", "TI"], "+", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " can be \[OpenCurlyDoubleQuote]expanded\[CloseCurlyDoubleQuote] to give ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["a", "TI"], "]"}], "+", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["b", "TI"], "]"}]}]], "InlineFormula"],
 ". The function ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " does this kind of expansion for standard algebraic operators such as ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 " allows you to perform the same kind of expansion for arbitrary operators. \
"
}], "Text",
 CellID->7578],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " uses the distributivity of ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " over ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " to perform algebraic expansions. "
}], "MathCaption",
 CellID->26074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"c", "+", "d"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->11395],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "c"}], "+", 
  RowBox[{"b", " ", "c"}], "+", 
  RowBox[{"a", " ", "d"}], "+", 
  RowBox[{"b", " ", "d"}]}]], "Output",
 ImageSize->{110, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->30843]
}, Open  ]],

Cell["\<\
This applies distributivity over lists, rather than sums. The result contains \
all possible pairs of arguments. \
\>", "MathCaption",
 CellID->31274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ",", "List"}], "]"}]], "Input",\

 CellLabel->"In[9]:= ",
 CellID->13316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "d"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->15024]
}, Open  ]],

Cell[TextData[{
 "This distributes over lists, but does so only if the head of the whole \
expression is ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ",", "List", ",", "f"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->18585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "d"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->5722]
}, Open  ]],

Cell[TextData[{
 "This distributes over lists, making sure that the head of the whole \
expression is ",
 Cell[BoxData["f"], "InlineFormula"],
 ". In the result, it uses ",
 Cell[BoxData["gp"], "InlineFormula"],
 " in place of ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ", and ",
 Cell[BoxData["fp"], "InlineFormula"],
 " in place of ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distribute", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ",", "List", ",", "f", ",", 
   "gp", ",", "fp"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->10057],

Cell[BoxData[
 RowBox[{"gp", "[", 
  RowBox[{
   RowBox[{"fp", "[", 
    RowBox[{"a", ",", "c"}], "]"}], ",", 
   RowBox[{"fp", "[", 
    RowBox[{"a", ",", "d"}], "]"}], ",", 
   RowBox[{"fp", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", 
   RowBox[{"fp", "[", 
    RowBox[{"b", ",", "d"}], "]"}]}], "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->14095]
}, Open  ]],

Cell[TextData[{
 "Related to ",
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 " is the function ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 ". What ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " effectively does is to apply a function in parallel to all the elements of \
a list or other expression. "
}], "Text",
 CellID->8174],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Thread",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Thread"], "[", 
     StyleBox["f", "TI"], "[", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "2"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["b", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], "2"], "}", "]", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "thread ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over lists to give ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["f", "TI"], "["}]], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], "1"]], "InlineFormula"],
     Cell[BoxData[","], "InlineFormula"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], "1"]], "InlineFormula"],
     Cell[BoxData[
      RowBox[{"]", ",", 
       StyleBox["f", "TI"], "["}]], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], "2"]], "InlineFormula"],
     Cell[BoxData[","], "InlineFormula"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], "2"]], "InlineFormula"],
     Cell[BoxData[
      RowBox[{"]", "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Thread",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Thread"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", ",", 
     StyleBox["g", "TI"], "]"}], Cell[TextData[{
     "thread ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over objects with head ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["args", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5038],

Cell["Functions for threading expressions. ", "Caption",
 CellID->2183],

Cell["Here is a function whose arguments are lists. ", "MathCaption",
 CellID->26658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a1", ",", "a2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->17295],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a1", ",", "a2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2"}], "}"}]}], "]"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->25722]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " applies the function \[OpenCurlyDoubleQuote]in parallel\
\[CloseCurlyDoubleQuote] to each element of the lists. "
}], "MathCaption",
 CellID->16983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", "%", "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->6231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a1", ",", "b1"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a2", ",", "b2"}], "]"}]}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->29503]
}, Open  ]],

Cell["Arguments that are not lists get repeated. ", "MathCaption",
 CellID->2232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a1", ",", "a2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b1", ",", "b2"}], "}"}], ",", "c", ",", "d"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->24300],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a1", ",", "b1", ",", "c", ",", "d"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a2", ",", "b2", ",", "c", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->15590]
}, Open  ]],

Cell[TextData[{
 "As mentioned in \"",
 ButtonBox["Collecting Objects Together",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CollectingObjectsTogether"],
 "\", and discussed in more detail in \"",
 ButtonBox["Attributes",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Attributes"],
 "\", many built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions have the property of being \[OpenCurlyDoubleQuote]listable\
\[CloseCurlyDoubleQuote], so that they are automatically threaded over any \
lists that appear as arguments. "
}], "Text",
 CellID->21480],

Cell[TextData[{
 "Built\[Hyphen]in mathematical functions such as ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " are listable, so that they are automatically threaded over lists. "
}], "MathCaption",
 CellID->17408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->15505],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", "a", "]"}], ",", 
   RowBox[{"Log", "[", "b", "]"}], ",", 
   RowBox[{"Log", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->32702]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " is, however, not automatically threaded over equations. "
}], "MathCaption",
 CellID->22858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"x", "==", "y"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->9818],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"x", "\[Equal]", "y"}], "]"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->10557]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " to get functions applied to both sides of an equation. "
}], "MathCaption",
 CellID->15561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"%", ",", "Equal"}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->24120],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "x", "]"}], "\[Equal]", 
  RowBox[{"Log", "[", "y", "]"}]}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->5028]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Outer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Outer"], "[", 
     StyleBox["f", "TI"], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], "2"], "]"}], Cell[
    "generalized outer product", "TableText"]},
   {
    RowBox[{
     ButtonBox["Inner",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inner"], "[", 
     StyleBox["f", "TI"], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], "2"], ",", 
     StyleBox["g", "TI"], "]"}], Cell[
    "generalized inner product", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23656],

Cell["Generalized outer and inner products. ", "Caption",
 CellID->25713],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ","}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list", "TI"], "1"], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list", "TI"], "2"], TraditionalForm]], "InlineMath"],
 Cell[BoxData["]"], "InlineFormula"],
 " takes all possible combinations of elements from ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list", "TI"], "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list", "TI"], "2"], TraditionalForm]], "InlineMath"],
 ", and combines them with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " can be viewed as a generalization of a Cartesian product for tensors, as \
discussed in \"",
 ButtonBox["Tensors",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Tensors"],
 "\". "
}], "Text",
 CellID->3332],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " forms all possible combinations of elements, and applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " to them. "
}], "MathCaption",
 CellID->23092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->17182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "3"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->26467]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " produces a lower\[Hyphen]triangular Boolean matrix. "
}], "MathCaption",
 CellID->11320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"Greater", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->7358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"False", ",", "False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "False"}], "}"}]}], "}"}]], "Output",
 ImageSize->{444, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->21074]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " on any sequence of expressions with the same head. "
}], "MathCaption",
 CellID->3987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"g", ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "d"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->9094],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "c"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"a", ",", "d"}], "]"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"b", ",", "c"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"b", ",", "d"}], "]"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{286, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->4983]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 ", like ",
 Cell[BoxData[
  ButtonBox["Distribute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Distribute"]], "InlineFormula"],
 ", constructs all possible combinations of elements. On the other hand, ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 ", like ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 ", constructs only combinations of elements that have corresponding \
positions in the expressions it acts on. "
}], "Text",
 CellID->21364],

Cell[TextData[{
 "Here is a structure built by ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", "g"}], "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->19714],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "d"}], "]"}]}], "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->26746]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 " is a generalization of ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->10425],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "c"}], "+", 
  RowBox[{"b", " ", "d"}]}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->26255]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->212489708],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->240027226],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->88299964]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Structural Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/WorkingWithOperators"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Sequences"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 6.9201530}", "context" -> "", 
    "keywords" -> {
     "associativity", "collating", "commutativity", "distribute", 
      "distributivity", "expansion", "expressions", "flatten", "FlattenAt", 
      "inner", "linearity", "listability", "lists", "operations", "order", 
      "OrderedQ", "ordering", "outer", "parallel operations", "permutations", 
      "positions", "ranking", "ravel in APL", "sort", "sorting", "splicing", 
      "squash", "structural operations", "subexpressions", 
      "symmetric functions", "thread", "threading", "unpack", "unravel", 
      "zip"}, "index" -> True, "label" -> "Mathematica Tutorial", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica contains some powerful primitives for making structural \
changes to expressions. You can use these primitives both to implement \
mathematical properties such as associativity and distributivity, and to \
provide the basis for some succinct and efficient programs. Here we describe \
various operations that you can explicitly perform on expressions. \
\"Attributes\" describes how some of these operations can be performed \
automatically on all expressions with a particular head by assigning \
appropriate attributes to that head. You can use the Mathematica function \
Sort[expr] to sort elements not only of lists, but of expressions with any \
head. In this way, you can implement the mathematical properties of \
commutativity or symmetry for arbitrary functions. ", 
    "synonyms" -> {"2.2.10"}, "title" -> "Structural Operations", "type" -> 
    "Tutorial", "uri" -> "tutorial/StructuralOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.10"->{
  Cell[2853, 73, 86, 2, 70, "Title",
   CellTags->{"S2.2.10", "10.1"},
   CellID->31585]},
 "10.1"->{
  Cell[2853, 73, 86, 2, 70, "Title",
   CellTags->{"S2.2.10", "10.1"},
   CellID->31585]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.10", 43478, 1563},
 {"10.1", 43580, 1567}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2228, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2853, 73, 86, 2, 70, "Title",
 CellTags->{"S2.2.10", "10.1"},
 CellID->31585],
Cell[2942, 77, 363, 8, 70, "Text",
 CellID->21465],
Cell[3308, 87, 400, 10, 70, "Text",
 CellID->31371],
Cell[3711, 99, 485, 15, 70, "Text",
 CellID->15444],
Cell[4199, 116, 243, 8, 70, "MathCaption",
 CellID->17107],
Cell[CellGroupData[{
Cell[4467, 128, 159, 5, 28, "Input",
 CellID->17271],
Cell[4629, 135, 215, 7, 36, "Output",
 CellID->24087]
}, Open  ]],
Cell[4859, 145, 3283, 107, 70, "DefinitionBox",
 CellID->28099],
Cell[8145, 254, 55, 1, 70, "Caption",
 CellID->16519],
Cell[8203, 257, 297, 9, 70, "MathCaption",
 CellID->8596],
Cell[CellGroupData[{
Cell[8525, 270, 260, 9, 70, "Input",
 CellID->5715],
Cell[8788, 281, 220, 7, 36, "Output",
 CellID->17552]
}, Open  ]],
Cell[9023, 291, 179, 5, 70, "MathCaption",
 CellID->22492],
Cell[CellGroupData[{
Cell[9227, 300, 347, 12, 70, "Input",
 CellID->14753],
Cell[9577, 314, 313, 11, 39, "Output",
 CellID->8257]
}, Open  ]],
Cell[9905, 328, 1897, 60, 70, "DefinitionBox",
 CellID->27590],
Cell[11805, 390, 63, 1, 70, "Caption",
 CellID->24959],
Cell[11871, 393, 214, 7, 70, "MathCaption",
 CellID->13357],
Cell[CellGroupData[{
Cell[12110, 404, 279, 9, 70, "Input",
 CellID->10886],
Cell[12392, 415, 224, 7, 36, "Output",
 CellID->7809]
}, Open  ]],
Cell[12631, 425, 302, 9, 70, "MathCaption",
 CellID->5865],
Cell[CellGroupData[{
Cell[12958, 438, 321, 11, 70, "Input",
 CellID->25686],
Cell[13282, 451, 244, 8, 36, "Output",
 CellID->32019]
}, Open  ]],
Cell[13541, 462, 452, 13, 70, "Text",
 CellID->259],
Cell[13996, 477, 2757, 88, 70, "DefinitionBox",
 CellID->22313],
Cell[16756, 567, 62, 1, 70, "Caption",
 CellID->2435],
Cell[16821, 570, 234, 8, 70, "MathCaption",
 CellID->1028],
Cell[CellGroupData[{
Cell[17080, 582, 154, 5, 70, "Input",
 CellID->4101],
Cell[17237, 589, 233, 8, 36, "Output",
 CellID->10468]
}, Open  ]],
Cell[17485, 600, 75, 1, 70, "MathCaption",
 CellID->22869],
Cell[CellGroupData[{
Cell[17585, 605, 203, 7, 70, "Input",
 CellID->456],
Cell[17791, 614, 405, 14, 36, "Output",
 CellID->6731]
}, Open  ]],
Cell[18211, 631, 1254, 43, 70, "Text",
 CellID->7578],
Cell[19468, 676, 471, 17, 70, "MathCaption",
 CellID->26074],
Cell[CellGroupData[{
Cell[19964, 697, 220, 8, 70, "Input",
 CellID->11395],
Cell[20187, 707, 290, 10, 36, "Output",
 CellID->30843]
}, Open  ]],
Cell[20492, 720, 160, 4, 70, "MathCaption",
 CellID->31274],
Cell[CellGroupData[{
Cell[20677, 728, 291, 11, 70, "Input",
 CellID->13316],
Cell[20971, 741, 437, 15, 36, "Output",
 CellID->15024]
}, Open  ]],
Cell[21423, 759, 186, 6, 70, "MathCaption",
 CellID->30511],
Cell[CellGroupData[{
Cell[21634, 769, 303, 11, 70, "Input",
 CellID->18585],
Cell[21940, 782, 437, 15, 36, "Output",
 CellID->5722]
}, Open  ]],
Cell[22392, 800, 486, 17, 70, "MathCaption",
 CellID->8971],
Cell[CellGroupData[{
Cell[22903, 821, 326, 11, 70, "Input",
 CellID->10057],
Cell[23232, 834, 448, 15, 36, "Output",
 CellID->14095]
}, Open  ]],
Cell[23695, 852, 555, 19, 70, "Text",
 CellID->8174],
Cell[24253, 873, 2307, 74, 70, "DefinitionBox",
 CellID->5038],
Cell[26563, 949, 71, 1, 70, "Caption",
 CellID->2183],
Cell[26637, 952, 85, 1, 70, "MathCaption",
 CellID->26658],
Cell[CellGroupData[{
Cell[26747, 957, 220, 8, 70, "Input",
 CellID->17295],
Cell[26970, 967, 309, 11, 36, "Output",
 CellID->25722]
}, Open  ]],
Cell[27294, 981, 282, 8, 70, "MathCaption",
 CellID->16983],
Cell[CellGroupData[{
Cell[27601, 993, 99, 3, 70, "Input",
 CellID->6231],
Cell[27703, 998, 314, 11, 36, "Output",
 CellID->29503]
}, Open  ]],
Cell[28032, 1012, 81, 1, 70, "MathCaption",
 CellID->2232],
Cell[CellGroupData[{
Cell[28138, 1017, 281, 10, 70, "Input",
 CellID->24300],
Cell[28422, 1029, 354, 11, 36, "Output",
 CellID->15590]
}, Open  ]],
Cell[28791, 1043, 587, 16, 70, "Text",
 CellID->21480],
Cell[29381, 1061, 283, 8, 70, "MathCaption",
 CellID->17408],
Cell[CellGroupData[{
Cell[29689, 1073, 154, 5, 70, "Input",
 CellID->15505],
Cell[29846, 1080, 305, 10, 36, "Output",
 CellID->32702]
}, Open  ]],
Cell[30166, 1093, 220, 7, 70, "MathCaption",
 CellID->22858],
Cell[CellGroupData[{
Cell[30411, 1104, 120, 4, 70, "Input",
 CellID->9818],
Cell[30534, 1110, 215, 7, 36, "Output",
 CellID->10557]
}, Open  ]],
Cell[30764, 1120, 242, 8, 70, "MathCaption",
 CellID->15561],
Cell[CellGroupData[{
Cell[31031, 1132, 127, 4, 70, "Input",
 CellID->24120],
Cell[31161, 1138, 245, 8, 36, "Output",
 CellID->5028]
}, Open  ]],
Cell[31421, 1149, 1009, 32, 70, "DefinitionBox",
 CellID->23656],
Cell[32433, 1183, 73, 1, 70, "Caption",
 CellID->25713],
Cell[32509, 1186, 1214, 45, 70, "Text",
 CellID->3332],
Cell[33726, 1233, 278, 9, 70, "MathCaption",
 CellID->23092],
Cell[CellGroupData[{
Cell[34029, 1246, 240, 8, 70, "Input",
 CellID->17182],
Cell[34272, 1256, 668, 23, 36, "Output",
 CellID->26467]
}, Open  ]],
Cell[34955, 1282, 230, 8, 70, "MathCaption",
 CellID->11320],
Cell[CellGroupData[{
Cell[35210, 1294, 255, 8, 70, "Input",
 CellID->7358],
Cell[35468, 1304, 422, 13, 36, "Output",
 CellID->21074]
}, Open  ]],
Cell[35905, 1320, 235, 8, 70, "MathCaption",
 CellID->3987],
Cell[CellGroupData[{
Cell[36165, 1332, 239, 8, 70, "Input",
 CellID->9094],
Cell[36407, 1342, 546, 19, 36, "Output",
 CellID->4983]
}, Open  ]],
Cell[36968, 1364, 721, 23, 70, "Text",
 CellID->21364],
Cell[37692, 1389, 203, 8, 70, "MathCaption",
 CellID->27264],
Cell[CellGroupData[{
Cell[37920, 1401, 240, 8, 70, "Input",
 CellID->19714],
Cell[38163, 1411, 315, 11, 36, "Output",
 CellID->26746]
}, Open  ]],
Cell[38493, 1425, 307, 12, 70, "MathCaption",
 CellID->24390],
Cell[CellGroupData[{
Cell[38825, 1441, 247, 8, 70, "Input",
 CellID->10425],
Cell[39075, 1451, 224, 8, 36, "Output",
 CellID->26255]
}, Open  ]],
Cell[CellGroupData[{
Cell[39336, 1464, 72, 1, 70, "RelatedTutorialsSection",
 CellID->212489708],
Cell[39411, 1467, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]],
Cell[CellGroupData[{
Cell[39622, 1476, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->240027226],
Cell[39723, 1479, 426, 13, 70, "TutorialRelatedLinks",
 CellID->88299964]
}, Open  ]]
}, Open  ]],
Cell[40176, 1496, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

