(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17191,        595]
NotebookOptionsPosition[     12353,        453]
NotebookOutlinePosition[     15376,        528]
CellTagsIndexPosition[     15285,        522]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>", 
       2->"\<\"Formatted Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Style" :> Documentation`HelpLookup["paclet:ref/Style"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Style\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Styles and Fonts in Output", "Title",
 CellTags->{"S2.9.9", "9.1"},
 CellID->26291],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Style",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Style"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["options", "TI"]}], "]"}], Cell[
    "print with the specified style options", "TableText"]},
   {
    RowBox[{
     ButtonBox["Style",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Style"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}], "]"}], Cell[
    "print with the specified cell style", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31988],

Cell["Specifying output styles. ", "Caption",
 CellID->10929],

Cell[TextData[{
 "The second ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " is here shown in boldface. "
}], "MathCaption",
 CellID->9072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"FontWeight", "->", "\"\<Bold\>\""}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->30977],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   StyleBox[
    SuperscriptBox["x", "2"],
    StripOnInput->False,
    FontWeight->"Bold"]}], "}"}]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->721829529]
}, Open  ]],

Cell[TextData[{
 "This shows the word ",
 Cell[BoxData["text"], "InlineFormula"],
 " in font sizes from 10 to 20 points. "
}], "MathCaption",
 CellID->8],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"\"\<text\>\"", ",", 
     RowBox[{"FontSize", "->", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "10", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->12254],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->10], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->11], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->12], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->13], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->14], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->15], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->16], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->17], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->18], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->19], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->20]}], "}"}]], "Output",
 ImageSize->{526, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->145033300]
}, Open  ]],

Cell["This shows the text in the Helvetica font. ", "MathCaption",
 CellID->30876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<some text\>\"", ",", 
   RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->15137],

Cell[BoxData[
 StyleBox[
  StyleBox["\<\"some text\"\>",
   StripOnInput->False,
   FontFamily->"Helvetica"],
  StripOnInput->False,
  FontFamily->"Helvetica"]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->102755005]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " allows an abbreviated form of some options. For options such as ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontWeight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontWeight"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontSlant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSlant"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FontColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontColor"]], "InlineFormula"],
 ", you can include merely the setting of the option."
}], "Text",
 CellID->300326266],

Cell["Options are specified here in a short form.", "MathCaption",
 CellID->340945626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<text\>\"", ",", "20", ",", " ", "Italic"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->148877114],

Cell[BoxData[
 StyleBox[
  StyleBox["\<\"text\"\>",
   StripOnInput->False,
   FontSize->20,
   FontSlant->Italic],
  StripOnInput->False,
  FontSize->20,
  FontSlant->Italic]], "Output",
 ImageSize->{52, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->605137539]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["typical setting(s)", "TableHeader"], 
    ""},
   {
    ButtonBox["FontSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontSize"], "12", Cell["\<\
size of characters in printer\[CloseCurlyQuote]s points\
\>", "TableText"]},
   {
    ButtonBox["FontWeight",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontWeight"], 
    RowBox[{"\"\<Plain\>\"", Cell[" or ", "TableText"], "\"\<Bold\>\""}], 
    Cell["weight of characters", "TableText"]},
   {
    ButtonBox["FontSlant",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontSlant"], 
    RowBox[{"\"\<Plain\>\"", Cell[" or ", "TableText"], "\"\<Italic\>\""}], 
    Cell["slant of characters", "TableText"]},
   {
    ButtonBox["FontFamily",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontFamily"], 
    RowBox[{
    "\"\<Courier\>\"", Cell[", ", "TableText"], "\"\<Times\>\"", Cell[
     ", ", "TableText"], "\"\<Helvetica\>\""}], Cell[
    "font family", "TableText"]},
   {
    ButtonBox["FontColor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontColor"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}], Cell[
    "color of characters", "TableText"]},
   {
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "1", "]"}], Cell[
    "background color for characters", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.2], 
     Scaled[0.4], {
      Scaled[0.4]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13803],

Cell[TextData[{
 "A few options that can be used in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->21090],

Cell[TextData[{
 "If you use the notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then each piece of output that is generated will by default be in the \
style of the cell in which the output appears. By using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " however, you can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to output a particular expression in a different style. "
}], "Text",
 CellID->7912],

Cell["\<\
Here is an expression output in the style normally used for section headings. \
\
\>", "MathCaption",
 CellID->12289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "\"\<Section\>\""}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->17253],

Cell[BoxData[
 StyleBox[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "Section",
   StripOnInput->False], "Section",
  StripOnInput->False]], "Output",
 ImageSize->{62, 21},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->608999096]
}, Open  ]],

Cell[TextData[{
 "\"",
 ButtonBox["Cells as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
 "\" describes in more detail how cell styles work. By using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", ",", 
    StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
 " you can generate output that is in a particular style, but with certain \
options modified. "
}], "Text",
 CellID->7299],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->103037059],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "RelatedTutorials",
 CellID->175077611]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Styles and Fonts in Output - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TablesAndMatrices"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/RepresentingTextualFormsByBoxes"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 9.3420900}", "context" -> "", 
    "keywords" -> {
     "background", "background color", "\\bf (TeX)", "boldface", "bold fonts",
       "\\boldmath (TeX)", "color", "courier fonts", "emphasis", "\\em (TeX)",
       "face", "family", "FontColor", "FontFamily", "fonts", "FontSize", 
      "FontSlant", "FontWeight", "Helvetica fonts", "italic fonts", "italics",
       "\\it (TeX)", "oblique", "oblique fonts", "options", "\\rm (TeX)", 
      "Roman fonts", "\\sf (TeX)", "size", "slant", "\\sl (TeX)", 
      "styled text", "StyleForm", "times fonts", "\\tt (TeX)", "typeface", 
      "typewriter font", "courier", "weight"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Specifying output styles. The second x^2 is here shown in boldface. This \
shows the word text in font sizes from 10 to 20 points. ", 
    "synonyms" -> {"2.9.9"}, "title" -> "Styles and Fonts in Output", "type" -> 
    "Tutorial", "uri" -> "tutorial/StylesAndFontsInOutput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.9"->{
  Cell[1952, 61, 89, 2, 70, "Title",
   CellTags->{"S2.9.9", "9.1"},
   CellID->26291]},
 "9.1"->{
  Cell[1952, 61, 89, 2, 70, "Title",
   CellTags->{"S2.9.9", "9.1"},
   CellID->26291]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.9", 15074, 511},
 {"9.1", 15173, 515}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1327, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1952, 61, 89, 2, 70, "Title",
 CellTags->{"S2.9.9", "9.1"},
 CellID->26291],
Cell[2044, 65, 888, 27, 70, "DefinitionBox",
 CellID->31988],
Cell[2935, 94, 61, 1, 70, "Caption",
 CellID->10929],
Cell[2999, 97, 186, 7, 70, "MathCaption",
 CellID->9072],
Cell[CellGroupData[{
Cell[3210, 108, 268, 10, 28, "Input",
 CellID->30977],
Cell[3481, 120, 317, 12, 39, "Output",
 CellID->721829529]
}, Open  ]],
Cell[3813, 135, 153, 5, 70, "MathCaption",
 CellID->8],
Cell[CellGroupData[{
Cell[3991, 144, 285, 9, 28, "Input",
 CellID->12254],
Cell[4279, 155, 1043, 40, 39, "Output",
 CellID->145033300]
}, Open  ]],
Cell[5337, 198, 82, 1, 70, "MathCaption",
 CellID->30876],
Cell[CellGroupData[{
Cell[5444, 203, 186, 5, 28, "Input",
 CellID->15137],
Cell[5633, 210, 301, 11, 36, "Output",
 CellID->102755005]
}, Open  ]],
Cell[5949, 224, 793, 27, 70, "Text",
 CellID->300326266],
Cell[6745, 253, 86, 1, 70, "MathCaption",
 CellID->340945626],
Cell[CellGroupData[{
Cell[6856, 258, 156, 4, 70, "Input",
 CellID->148877114],
Cell[7015, 264, 317, 13, 44, "Output",
 CellID->605137539]
}, Open  ]],
Cell[7347, 280, 2110, 61, 70, "DefinitionBox3Col",
 CellID->13803],
Cell[9460, 343, 204, 8, 70, "Caption",
 CellID->21090],
Cell[9667, 353, 642, 19, 70, "Text",
 CellID->7912],
Cell[10312, 374, 127, 4, 70, "MathCaption",
 CellID->12289],
Cell[CellGroupData[{
Cell[10464, 382, 208, 7, 70, "Input",
 CellID->17253],
Cell[10675, 391, 328, 12, 42, "Output",
 CellID->608999096]
}, Open  ]],
Cell[11018, 406, 847, 25, 70, "Text",
 CellID->7299],
Cell[CellGroupData[{
Cell[11890, 435, 72, 1, 70, "RelatedTutorialsSection",
 CellID->103037059],
Cell[11965, 438, 178, 4, 70, "RelatedTutorials",
 CellID->364580606],
Cell[12146, 444, 153, 3, 70, "RelatedTutorials",
 CellID->175077611]
}, Open  ]]
}, Open  ]],
Cell[12326, 451, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

