(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18139,        632]
NotebookOptionsPosition[     13553,        492]
NotebookOutlinePosition[     16333,        564]
CellTagsIndexPosition[     16241,        558]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Input and Output in Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Subscripts, Bars and Other Modifiers", "Title",
 CellTags->{"S1.10.6", "6.1"},
 CellID->24956],

Cell["Here is a typical palette of modifiers. ", "MathCaption",
 CellID->16158],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm0tOwkAYgKcPBAEXGt1zBg6hK3cQ3WhSGxNYGAlyGLwbXoEr4PyVlpb+
nUxtO4/2bzLNMPM/vs57pvQx2CzeP4LNMgwmD+tgtViGX5P7zzVP8hzGWMjD
asIgfuDR4y1khwOPvcEP5y/OPLbf79l0Oo3CK9ydfP52+x2FF7g7DQr5GSEe
niHBlxR2QWQOImfe3DIGbthsNndB5A6JRbncPFyxtlfG/DXb7X64CpgBOQi3
kmlp3RigVOGQ87TRAaT5oDvobBmQ83Ta+JgGF8Qg9DoBdAEGeiB3gZjvJ7lY
T/GTXJ4B2fEVcWO4XqLhJn3QM+MRPMkSPz3CJYFXAh8RpB2QWofw+MnTzRsr
K+PmFHJeq/PZsVXHyqUX4JUN0AaBnLfJuRVzD0ESZDshNazbzdx9Mj/jiF99
Sc5hUjQYXZRbzxYzAnLZyVYMjPmlAwZjpjg6/euyc9oytLZqtTrvJyNIlYMI
3Mr/gfLTaGU6sclOoJpUzd3tcbLOvaSwr7Rj5FtkI0zizcg4t92Q4OwJlXCH
eth9a3DFuQRpHaRs+1OGiw1OJQYiZeO2sUyF84Zx86kha4qmFl6tZNJfXd1Y
AtJJAp0kNOF8lJ3vVWCIXY4Ei3dldHL+VaLir0ti86fXL64805lSYY3UuJgr
9RSFQOI3YhpwMQyCtBgS/xtnWVxl3WqId3qMvXAOUDSO2YZa2AgMmUwtW6wb
u48xkUl/dXVjDVy38ycQYVLfbCn+IE1GKACZjJbzCziQ5Ho=\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{99, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->29749],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to use any expression as a subscript. "
}], "MathCaption",
 CellID->24620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["x", 
      RowBox[{"1", "+", "n"}]]}], ")"}], "4"], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23296],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"4", " ", 
   SubscriptBox["x", 
    RowBox[{"1", "+", "n"}]]}], "+", 
  RowBox[{"6", " ", 
   SubsuperscriptBox["x", 
    RowBox[{"1", "+", "n"}], "2"]}], "+", 
  RowBox[{"4", " ", 
   SubsuperscriptBox["x", 
    RowBox[{"1", "+", "n"}], "3"]}], "+", 
  SubsuperscriptBox["x", 
   RowBox[{"1", "+", "n"}], "4"]}]], "Output",
 ImageSize->{182, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->19724]
}, Open  ]],

Cell[TextData[{
 "Unless you specifically tell it otherwise, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will interpret a superscript as a power. "
}], "MathCaption",
 CellID->13120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   SubsuperscriptBox["x", "n", "4"], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->24526],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SubscriptBox["x", "n"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SubscriptBox["x", "n"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SubsuperscriptBox["x", "n", "2"]}], ")"}]}]], "Output",
 ImageSize->{157, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->16406]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["-", "KeyEvent"]
    }], "TableText"], Cell[
    "go to the position for a subscript", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["+", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["=", "KeyEvent"]
    }], "TableText"], Cell["go to the position underneath", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["6", "KeyEvent"]
    }], "TableText"], Cell[
    "go to the position for a superscript", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["7", "KeyEvent"]
    }], "TableText"], Cell["go to the position on top", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell["return from a special position", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {True}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8983],

Cell["\<\
Special input forms based on control characters. The second forms given \
should work on any keyboard. \
\>", "Caption",
 CellID->3445],

Cell["\[ThinSpace]", "Text",
 CellID->137458079],

Cell["This enters a subscript using control keys. ", "MathCaption",
 CellID->30574],

Cell[CellGroupData[{

Cell[TextData[{
 "Expand[(1 + x\[ThinSpace]",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 "\[ThinSpace]1+n\[ThinSpace]",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "\[ThinSpace]",
 ")^4]"
}], "Input",
 CellLabel->"In[3]:= ",
 CellID->21691],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"4", " ", 
   SubscriptBox["x", 
    RowBox[{"1", "+", "n"}]]}], "+", 
  RowBox[{"6", " ", 
   SubsuperscriptBox["x", 
    RowBox[{"1", "+", "n"}], "2"]}], "+", 
  RowBox[{"4", " ", 
   SubsuperscriptBox["x", 
    RowBox[{"1", "+", "n"}], "3"]}], "+", 
  SubsuperscriptBox["x", 
   RowBox[{"1", "+", "n"}], "4"]}]], "Output",
 ImageSize->{182, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->26588]
}, Open  ]],

Cell[TextData[{
 "Just as ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " and ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " go to superscript and subscript positions, so also ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["&", "KeyEvent"],
 " and ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["=", "KeyEvent"],
 " can be used to go to positions directly above and below. With the layout \
of a standard English\[Hyphen]language keyboard ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["&", "KeyEvent"],
 " is directly to the right of ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " while ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["=", "KeyEvent"],
 " is directly to the right of ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 ". "
}], "Text",
 CellID->30538],

Cell[BoxData[GridBox[{
   {Cell["key sequence", "TableHeader"], Cell[
    "displayed form", "TableHeader"], Cell[
    "expression form", "TableHeader"]},
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " _"
    }], "TableText"], 
    OverscriptBox[
     StyleBox["x", "TI"], "_"], 
    RowBox[{
     ButtonBox["OverBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverBar"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]vec\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"], 
    OverscriptBox[
     StyleBox["x", "TI"], "\[RightVector]"], 
    RowBox[{
     ButtonBox["OverVector",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverVector"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " ~"
    }], "TableText"], 
    OverscriptBox[
     StyleBox["x", "TI"], "~"], 
    RowBox[{
     ButtonBox["OverTilde",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverTilde"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " ^"
    }], "TableText"], 
    OverscriptBox[
     StyleBox["x", "TI"], "^"], 
    RowBox[{
     ButtonBox["OverHat",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverHat"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " ."
    }], "TableText"], 
    OverscriptBox[
     StyleBox["x", "TI"], "."], 
    RowBox[{
     ButtonBox["OverDot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverDot"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["=", "KeyEvent"],
     " _"
    }], "TableText"], 
    UnderscriptBox[
     StyleBox["x", "TI"], "_"], 
    RowBox[{
     ButtonBox["UnderBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderBar"], "[", 
     StyleBox["x", "TI"], "]"}]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20664],

Cell["Ways to enter some common modifiers using control keys. ", "Caption",
 CellID->18104],

Cell[TextData[{
 "Here is ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", "_"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->20877],

Cell[CellGroupData[{

Cell[TextData[{
 "x\[ThinSpace]",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["&", "KeyEvent"],
 "\[ThinSpace]_ ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"]
}], "Input",
 CellLabel->"In[4]:= ",
 CellID->20353],

Cell[BoxData[
 OverscriptBox["x", "_"]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->2942]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", "_"], TraditionalForm]], "InlineMath"],
 " as a variable. "
}], "MathCaption",
 CellID->17004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], "==", "%"}], ",", "a"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->30623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       OverscriptBox["x", "_"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", 
     SqrtBox[
      OverscriptBox["x", "_"]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{163, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->14852]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->90179831],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subscripts, Bars and Other Modifiers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EnteringTablesAndMatrices"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NonEnglishCharactersAndKeyboards"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 10.5764966}", "context" -> "", 
    "keywords" -> {
     "Bar", "control", "Control7", "diacritical marks", "Dot", 
      "fluxion notation", "modifiers", "on top", "Overscripts", "tilde", 
      "underline", "underneath", "Underscripts", "vector sign"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Here is a typical palette of modifiers. Mathematica allows you to use \
any expression as a subscript. Unless you specifically tell it otherwise, \
Mathematica will interpret a superscript as a power. ", 
    "synonyms" -> {"1.10.6"}, "title" -> 
    "Subscripts, Bars and Other Modifiers", "type" -> "Tutorial", "uri" -> 
    "tutorial/SubscriptsBarsAndOtherModifiers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.6"->{
  Cell[1286, 44, 100, 2, 70, "Title",
   CellTags->{"S1.10.6", "6.1"},
   CellID->24956]},
 "6.1"->{
  Cell[1286, 44, 100, 2, 70, "Title",
   CellTags->{"S1.10.6", "6.1"},
   CellID->24956]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.6", 16026, 547},
 {"6.1", 16127, 551}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 661, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 44, 100, 2, 70, "Title",
 CellTags->{"S1.10.6", "6.1"},
 CellID->24956],
Cell[1389, 48, 79, 1, 70, "MathCaption",
 CellID->16158],
Cell[1471, 51, 966, 19, 70, "Picture",
 Evaluatable->False,
 CellID->29749],
Cell[2440, 72, 153, 5, 70, "MathCaption",
 CellID->24620],
Cell[CellGroupData[{
Cell[2618, 81, 224, 8, 30, "Input",
 CellID->23296],
Cell[2845, 91, 497, 17, 38, "Output",
 CellID->19724]
}, Open  ]],
Cell[3357, 111, 193, 6, 70, "MathCaption",
 CellID->13120],
Cell[CellGroupData[{
Cell[3575, 121, 155, 5, 30, "Input",
 CellID->24526],
Cell[3733, 128, 431, 16, 39, "Output",
 CellID->16406]
}, Open  ]],
Cell[4179, 147, 1889, 53, 70, "DefinitionBox",
 CellID->8983],
Cell[6071, 202, 145, 4, 70, "Caption",
 CellID->3445],
Cell[6219, 208, 48, 1, 70, "Text",
 CellID->137458079],
Cell[6270, 211, 83, 1, 70, "MathCaption",
 CellID->30574],
Cell[CellGroupData[{
Cell[6378, 216, 351, 13, 70, "Input",
 CellID->21691],
Cell[6732, 231, 497, 17, 38, "Output",
 CellID->26588]
}, Open  ]],
Cell[7244, 251, 1116, 36, 70, "Text",
 CellID->30538],
Cell[8363, 289, 3273, 112, 70, "DefinitionBox3Col",
 CellID->20664],
Cell[11639, 403, 91, 1, 70, "Caption",
 CellID->18104],
Cell[11733, 406, 157, 7, 70, "MathCaption",
 CellID->20877],
Cell[CellGroupData[{
Cell[11915, 417, 300, 11, 70, "Input",
 CellID->20353],
Cell[12218, 430, 176, 6, 36, "Output",
 CellID->2942]
}, Open  ]],
Cell[12409, 439, 175, 7, 70, "MathCaption",
 CellID->17004],
Cell[CellGroupData[{
Cell[12609, 450, 171, 6, 70, "Input",
 CellID->30623],
Cell[12783, 458, 418, 16, 47, "Output",
 CellID->14852]
}, Open  ]],
Cell[CellGroupData[{
Cell[13238, 479, 71, 1, 70, "RelatedTutorialsSection",
 CellID->90179831],
Cell[13312, 482, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[13526, 490, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

