(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27625,       1014]
NotebookOptionsPosition[     22200,        840]
NotebookOutlinePosition[     24870,        909]
CellTagsIndexPosition[     24779,        903]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematicsOverview"], 
          "Iterator Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeGeneralNotationsAndConventions#27272"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Symbolic Mathematics\"\>", 
       2->"\<\"Iterator Notation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Product" :> Documentation`HelpLookup["paclet:ref/Product"], 
          "Sum" :> Documentation`HelpLookup["paclet:ref/Sum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Product\"\>", 
       2->"\<\"Sum\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sums and Products", "Title",
 CellTags->{"S1.5.4", "4.1"},
 CellID->5396],

Cell[TextData[{
 "This constructs the sum ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "7",
     LimitsPositioning->True], 
    FractionBox[
     SuperscriptBox["x", "i"], "i"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->4566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], "/", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->25230],

Cell[BoxData[
 RowBox[{"x", "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["x", "3"], "3"], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], "4"], "+", 
  FractionBox[
   SuperscriptBox["x", "5"], "5"], "+", 
  FractionBox[
   SuperscriptBox["x", "6"], "6"], "+", 
  FractionBox[
   SuperscriptBox["x", "7"], "7"]}]], "Output",
 ImageSize->{187, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->21665]
}, Open  ]],

Cell[TextData[{
 "You can leave out the lower limit if it is equal to ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], "/", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->32000],

Cell[BoxData[
 RowBox[{"x", "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["x", "3"], "3"], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], "4"], "+", 
  FractionBox[
   SuperscriptBox["x", "5"], "5"], "+", 
  FractionBox[
   SuperscriptBox["x", "6"], "6"], "+", 
  FractionBox[
   SuperscriptBox["x", "7"], "7"]}]], "Output",
 ImageSize->{187, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->3617]
}, Open  ]],

Cell[TextData[{
 "This makes ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " increase in steps of ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 ", so that only odd\[Hyphen]numbered values are included. "
}], "MathCaption",
 CellID->29173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], "/", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "5", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->30786],

Cell[BoxData[
 RowBox[{"x", "+", 
  FractionBox[
   SuperscriptBox["x", "3"], "3"], "+", 
  FractionBox[
   SuperscriptBox["x", "5"], "5"]}]], "Output",
 ImageSize->{70, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->10668]
}, Open  ]],

Cell["Products work just like sums. ", "MathCaption",
 CellID->31597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"x", "+", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->31579],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->26224]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sum"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "the sum ",
     Cell[BoxData[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{
         StyleBox["i", "TI"], "=", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["min", "TI"]]}], 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]],
        LimitsPositioning->True], " ", 
       StyleBox["f", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Sum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sum"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], ",", 
     StyleBox["di", "TI"], "}", "]"}], Cell[TextData[{
     "the sum with ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " increasing in steps of ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Sum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sum"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["j", "TI"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the nested sum ",
     Cell[BoxData[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{
         StyleBox["i", "TI"], "=", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["min", "TI"]]}], 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]],
        LimitsPositioning->True], 
       UnderoverscriptBox["\[Sum]", 
        RowBox[{
         StyleBox["j", "TI"], "=", 
         SubscriptBox[
          StyleBox["j", "TI"], 
          StyleBox["min", "TI"]]}], 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["max", "TI"]],
        LimitsPositioning->True], " ", 
       StyleBox["f", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Product",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Product"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "the product ",
     Cell[BoxData[
      RowBox[{
       UnderoverscriptBox["\[Product]", 
        RowBox[{
         StyleBox["i", "TI"], "=", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["min", "TI"]]}], 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]],
        LimitsPositioning->True], " ", 
       StyleBox["f", "TI"]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17728],

Cell["Sums and products. ", "Caption",
 CellID->26260],

Cell[TextData[{
 "This sum is computed symbolically as a function of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->12158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"i", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->23425],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "n"}]}], ")"}]}]], "Output",
 ImageSize->{123, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->23267]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can also give an exact result for this infinite sum."
}], "MathCaption",
 CellID->19312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"i", "^", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->734],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "4"], "90"]], "Output",
 ImageSize->{23, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->452]
}, Open  ]],

Cell["\<\
As with integrals, simple sums can lead to complicated results.\
\>", "MathCaption",
 CellID->5169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"i", " ", 
      RowBox[{"(", 
       RowBox[{"i", "+", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->29562],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox["x", 
     RowBox[{"1", "/", "4"}]]}], "+", 
   RowBox[{"EllipticTheta", "[", 
    RowBox[{"2", ",", "0", ",", "x"}], "]"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["x", 
    RowBox[{"1", "/", "4"}]]}]]], "Output",
 ImageSize->{210, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->1570]
}, Open  ]],

Cell["\<\
This sum cannot be evaluated exactly using standard mathematical functions. \
\>", "MathCaption",
 CellID->8211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "!"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "i"}], ")"}], "!"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->29235],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"i", "=", "1"}], "\[Infinity]"], 
  FractionBox["1", 
   RowBox[{
    RowBox[{"i", "!"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", "i"}], ")"}], "!"}]}]]}]], "Output",
 ImageSize->{93, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->6890]
}, Open  ]],

Cell["\<\
You can nevertheless find a numerical approximation to the result. \
\>", "MathCaption",
 CellID->1711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->2064],

Cell[BoxData["0.37319734675969646`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->4750]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also has a notation for multiple sums and products. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ","}]}]}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["i", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["i", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["j", "TI"], ","}]}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["j", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[","], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["j", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  RowBox[{"}", "]"}]], "InlineFormula"],
 " represents a sum over ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 ", which would be written in standard mathematical notation as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", 
      SubscriptBox["i", 
       StyleBox["min", "TI"]]}], 
     SubscriptBox["i", 
      StyleBox["max", "TI"]],
     LimitsPositioning->True], 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"j", "=", 
      SubscriptBox["j", 
       StyleBox["min", "TI"]]}], 
     SubscriptBox["j", 
      StyleBox["max", "TI"]],
     LimitsPositioning->True], " ", "f"}], TraditionalForm]], "InlineMath"],
 ". Notice that in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notation, as in standard mathematical notation, the range of the ",
 StyleBox["outermost",
  FontSlant->"Italic"],
 " variable is given ",
 StyleBox["first",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->28960],

Cell[TextData[{
 "This is the multiple sum ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "3",
     LimitsPositioning->True], 
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"j", "=", "1"}], "i",
     LimitsPositioning->True], 
    SuperscriptBox["x", "i"], 
    SuperscriptBox["y", "j"]}], TraditionalForm]], "InlineMath"],
 ". Notice that the outermost sum over ",
 Cell[BoxData["i"], "InlineFormula"],
 " is given first, just as in the mathematical notation. "
}], "MathCaption",
 CellID->7545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "i"}], " ", 
    RowBox[{"y", "^", "j"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "1", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->14767],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "y"}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", "y"}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox["y", "3"]}]}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->21754]
}, Open  ]],

Cell[TextData[{
 "The way the ranges of variables are specified in ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Product",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Product"]], "InlineFormula"],
 " is an example of the rather general ",
 StyleBox["iterator notation",
  FontSlant->"Italic"],
 " that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses. You will see this notation again when we discuss generating tables \
and lists using ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " (\"",
 ButtonBox["Making Tables of Values",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MakingTablesOfValues"],
 "\"), and when we describe ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " loops (\"",
 ButtonBox["Repetitive Operations",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RepetitiveOperations"],
 "\")."
}], "Text",
 CellID->30787],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}"}], Cell[TextData[{
     "iterate ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " times, without incrementing any variables"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}"}], 
    RowBox[{
     StyleBox["i", "TI"], Cell[" goes from ", "TableText"], "1", Cell[
     " to ", "TableText"], 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], Cell[" in steps of ", "TableText"], "1"}]},
   {
    RowBox[{"{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}"}], 
    RowBox[{
     StyleBox["i", "TI"], Cell[" goes from ", "TableText"], 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], Cell[" to ", "TableText"], 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], Cell[" in steps of ", "TableText"], "1"}]},
   {
    RowBox[{"{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], ",", 
     StyleBox["di", "TI"], "}"}], 
    RowBox[{
     StyleBox["i", "TI"], Cell[" goes from ", "TableText"], 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], Cell[" to ", "TableText"], 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], Cell[" in steps of ", "TableText"], 
     StyleBox["di", "TI"]}]},
   {
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["i", "TI"], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["j", "TI"], ",", 
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"], "  "}], 
    RowBox[{
     StyleBox["i", "TI"], Cell[" goes from ", "TableText"], 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], Cell[" to ", "TableText"], 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], Cell[
     ", and for each such value, ", "TableText"], 
     StyleBox["j", "TI"], Cell[" goes from ", "TableText"], 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["min", "TI"]], Cell[" to ", "TableText"], 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["max", "TI"]], Cell[", etc.", "TableText"]}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8217],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " iterator notation. "
}], "Caption",
 CellID->24565],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->125083047],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452],

Cell[TextData[ButtonBox["Iterator Notation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SomeGeneralNotationsAndConventions#27272"]], \
"RelatedTutorials",
 CellID->1572669998]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sums and Products - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Integration"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Equations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 14.1390878}", "context" -> "", 
    "keywords" -> {
     "iteration functions", "iterators", "numerical summation", "product", 
      "products", "ranges", "sequences", "sum", "sums", "symbolic sums"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "This constructs the sum UnderoverscriptBox[\\[Sum], RowBox[{i, =, 1}], \
7, LimitsPositioning -> True]FractionBox[SuperscriptBox[x, i], i]. You can \
leave out the lower limit if it is equal to 1. This makes i increase in steps \
of 2, so that only odd-numbered values are included. ", 
    "synonyms" -> {"1.5.4"}, "title" -> "Sums and Products", "type" -> 
    "Tutorial", "uri" -> "tutorial/SumsAndProducts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.4"->{
  Cell[2060, 62, 79, 2, 70, "Title",
   CellTags->{"S1.5.4", "4.1"},
   CellID->5396]},
 "4.1"->{
  Cell[2060, 62, 79, 2, 70, "Title",
   CellTags->{"S1.5.4", "4.1"},
   CellID->5396]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.4", 24570, 892},
 {"4.1", 24668, 896}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1435, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2060, 62, 79, 2, 70, "Title",
 CellTags->{"S1.5.4", "4.1"},
 CellID->5396],
Cell[2142, 66, 313, 12, 70, "MathCaption",
 CellID->4566],
Cell[CellGroupData[{
Cell[2480, 82, 227, 8, 28, "Input",
 CellID->25230],
Cell[2710, 92, 504, 18, 54, "Output",
 CellID->21665]
}, Open  ]],
Cell[3229, 113, 151, 5, 70, "MathCaption",
 CellID->26152],
Cell[CellGroupData[{
Cell[3405, 122, 217, 8, 28, "Input",
 CellID->32000],
Cell[3625, 132, 503, 18, 54, "Output",
 CellID->3617]
}, Open  ]],
Cell[4143, 153, 282, 9, 70, "MathCaption",
 CellID->29173],
Cell[CellGroupData[{
Cell[4450, 166, 237, 8, 28, "Input",
 CellID->30786],
Cell[4690, 176, 279, 10, 54, "Output",
 CellID->10668]
}, Open  ]],
Cell[4984, 189, 69, 1, 70, "MathCaption",
 CellID->31597],
Cell[CellGroupData[{
Cell[5078, 194, 206, 7, 70, "Input",
 CellID->31579],
Cell[5287, 203, 386, 14, 36, "Output",
 CellID->26224]
}, Open  ]],
Cell[5688, 220, 4055, 136, 70, "DefinitionBox",
 CellID->17728],
Cell[9746, 358, 54, 1, 70, "Caption",
 CellID->26260],
Cell[9803, 361, 176, 6, 70, "MathCaption",
 CellID->12158],
Cell[CellGroupData[{
Cell[10004, 371, 202, 7, 70, "Input",
 CellID->23425],
Cell[10209, 380, 338, 12, 51, "Output",
 CellID->23267]
}, Open  ]],
Cell[10562, 395, 156, 5, 70, "MathCaption",
 CellID->19312],
Cell[CellGroupData[{
Cell[10743, 404, 232, 8, 70, "Input",
 CellID->734],
Cell[10978, 414, 202, 7, 54, "Output",
 CellID->452]
}, Open  ]],
Cell[11195, 424, 109, 3, 70, "MathCaption",
 CellID->5169],
Cell[CellGroupData[{
Cell[11329, 431, 315, 11, 70, "Input",
 CellID->29562],
Cell[11647, 444, 443, 16, 56, "Output",
 CellID->1570]
}, Open  ]],
Cell[12105, 463, 122, 3, 70, "MathCaption",
 CellID->8211],
Cell[CellGroupData[{
Cell[12252, 470, 356, 13, 70, "Input",
 CellID->29235],
Cell[12611, 485, 381, 14, 58, "Output",
 CellID->6890]
}, Open  ]],
Cell[13007, 502, 113, 3, 70, "MathCaption",
 CellID->1711],
Cell[CellGroupData[{
Cell[13145, 509, 93, 3, 70, "Input",
 CellID->2064],
Cell[13241, 514, 173, 5, 36, "Output",
 CellID->4750]
}, Open  ]],
Cell[13429, 522, 2081, 78, 70, "Text",
 CellID->28960],
Cell[15513, 602, 555, 17, 70, "MathCaption",
 CellID->7545],
Cell[CellGroupData[{
Cell[16093, 623, 322, 11, 70, "Input",
 CellID->14767],
Cell[16418, 636, 557, 20, 36, "Output",
 CellID->21754]
}, Open  ]],
Cell[16990, 659, 1096, 38, 70, "Text",
 CellID->30787],
Cell[18089, 699, 3475, 110, 70, "DefinitionBox",
 CellID->8217],
Cell[21567, 811, 119, 5, 70, "Caption",
 CellID->24565],
Cell[CellGroupData[{
Cell[21711, 820, 72, 1, 70, "RelatedTutorialsSection",
 CellID->125083047],
Cell[21786, 823, 172, 4, 70, "RelatedTutorials",
 CellID->391267452],
Cell[21961, 829, 185, 5, 70, "RelatedTutorials",
 CellID->1572669998]
}, Open  ]]
}, Open  ]],
Cell[22173, 838, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

