(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14032,        481]
NotebookOptionsPosition[     10614,        379]
NotebookOutlinePosition[     13055,        444]
CellTagsIndexPosition[     12964,        438]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"D" :> Documentation`HelpLookup["paclet:ref/D"], "Integrate" :> 
          Documentation`HelpLookup["paclet:ref/Integrate"], "Limit" :> 
          Documentation`HelpLookup["paclet:ref/Limit"], "Minimize" :> 
          Documentation`HelpLookup["paclet:ref/Minimize"], "Series" :> 
          Documentation`HelpLookup["paclet:ref/Series"], "Solve" :> 
          Documentation`HelpLookup["paclet:ref/Solve"], "Sum" :> 
          Documentation`HelpLookup["paclet:ref/Sum"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"D\"\>", 2->"\<\"Integrate\"\>", 
       3->"\<\"Limit\"\>", 4->"\<\"Minimize\"\>", 5->"\<\"Series\"\>", 
       6->"\<\"Solve\"\>", 7->"\<\"Sum\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Symbolic Mathematics: Basic Operations", "Title",
 CellTags->{"S1.5.1", "1.1"},
 CellID->16683],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ability to deal with symbolic expressions, as well as \
numbers, allows you to use it for many kinds of mathematics."
}], "Text",
 CellID->13716],

Cell[TextData[{
 "Calculus is one example. With ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can differentiate an expression ",
 StyleBox["symbolically",
  FontSlant->"Italic"],
 ", and get a formula for the result. "
}], "Text",
 CellID->19932],

Cell[TextData[{
 "This finds the derivative of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "n"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->25452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->2741],

Cell[BoxData[
 RowBox[{"n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->4954]
}, Open  ]],

Cell["Here is a slightly more complicated example. ", "MathCaption",
 CellID->6813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"x", "+", "a"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->2862],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{"a", "+", "x"}]], "+", 
  RowBox[{"2", " ", "x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", "x"}], "]"}]}]}]], "Output",
 ImageSize->{129, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->10396]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/D"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["f", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["x", "TI"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "the (partial) derivative ",
     Cell[BoxData[
      FormBox[
       FractionBox[
        RowBox[{"\[PartialD]", "f"}], 
        RowBox[{"\[PartialD]", "x"}]], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Integrate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["f", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["x", "TI"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "the indefinite integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Integral]", 
        RowBox[{"f", " ", "d", "\[InvisibleSpace]", "x"}]}], 
       TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Sum",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["f", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["{", "MR"],
     StyleBox["i", "TI"],
     StyleBox[",", "MR"],
     " ",
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], TraditionalForm]], "InlineFormula"],
     StyleBox[",", "MR"],
     " ",
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], TraditionalForm]], "InlineFormula"],
     StyleBox["}]", "MR"],
     " "
    }]], Cell[TextData[{
     "the sum ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"i", "=", 
          SubscriptBox["i", 
           StyleBox["min", "TI"]]}], 
         SubscriptBox["i", 
          StyleBox["max", "TI"]],
         LimitsPositioning->True], " ", "f"}], TraditionalForm]], 
      "InlineMath"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Solve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["lhs", "TI"],
     StyleBox["==", "MR"],
     StyleBox["rhs", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["x", "TI"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "solution to an equation for ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Series",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Series"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["f", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["{", "MR"],
     StyleBox["x", "TI"],
     StyleBox[",", "MR"],
     " ",
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["x", "TI"], "0"], TraditionalForm]], "InlineFormula"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["order", "TI"],
     StyleBox["}]", "MR"],
     " "
    }]], Cell[TextData[{
     "a power series expansion of ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " about the point ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "=", 
        SubscriptBox["x", "0"]}], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Limit",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["f", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["x", "TI"],
     StyleBox["->", "MR"],
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["x", "TI"], "0"], TraditionalForm]], "InlineFormula"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "the limit ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderscriptBox["lim", 
         RowBox[{"x", "\[Rule]", 
          SubscriptBox["x", "0"]}],
         LimitsPositioning->True], "f"}], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Minimize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
     StyleBox["[", "MR"],
     StyleBox["f", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["x", "TI"],
     StyleBox["]", "MR"],
     " "
    }]], Cell[TextData[{
     "minimization of ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " with respect to ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15460],

Cell["Some symbolic mathematical operations. ", "Caption",
 CellID->20615],

Cell[TextData[{
 "Getting formulas as the results of computations is usually desirable when \
it is possible. There are however many circumstances where it is \
mathematically impossible to get an explicit formula as the result of a \
computation. This happens, for example, when you try to solve an equation for \
which there is no \[OpenCurlyDoubleQuote]closed form\[CloseCurlyDoubleQuote] \
solution. In such cases, you must resort to numerical methods and \
approximations. These are discussed in \"",
 ButtonBox["Numerical Mathematics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalMathematicsOverview"],
 "\". "
}], "Text",
 CellID->10904],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->819438955],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Symbolic Mathematics: Basic Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Integration"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 14.7328530}", "context" -> "", 
    "keywords" -> {
     "closed form solutions", "mathematical operations", 
      "symbolic mathematics"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica's ability to deal with symbolic expressions, as well as \
numbers, allows you to use it for many kinds of mathematics. Calculus is one \
example. With Mathematica, you can differentiate an expression symbolically, \
and get a formula for the result. This finds the derivative of x^n. ", 
    "synonyms" -> {"1.5.1"}, "title" -> 
    "Symbolic Mathematics: Basic Operations", "type" -> "Tutorial", "uri" -> 
    "tutorial/SymbolicMathematics-BasicOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.1"->{
  Cell[2338, 65, 101, 2, 70, "Title",
   CellTags->{"S1.5.1", "1.1"},
   CellID->16683]},
 "1.1"->{
  Cell[2338, 65, 101, 2, 70, "Title",
   CellTags->{"S1.5.1", "1.1"},
   CellID->16683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.1", 12751, 427},
 {"1.1", 12851, 431}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1713, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2338, 65, 101, 2, 70, "Title",
 CellTags->{"S1.5.1", "1.1"},
 CellID->16683],
Cell[2442, 69, 232, 6, 70, "Text",
 CellID->13716],
Cell[2677, 77, 260, 9, 70, "Text",
 CellID->19932],
Cell[2940, 88, 179, 7, 70, "MathCaption",
 CellID->25452],
Cell[CellGroupData[{
Cell[3144, 99, 140, 5, 28, "Input",
 CellID->2741],
Cell[3287, 106, 244, 9, 36, "Output",
 CellID->4954]
}, Open  ]],
Cell[3546, 118, 83, 1, 70, "MathCaption",
 CellID->6813],
Cell[CellGroupData[{
Cell[3654, 123, 223, 8, 28, "Input",
 CellID->2862],
Cell[3880, 133, 337, 12, 54, "Output",
 CellID->10396]
}, Open  ]],
Cell[4232, 148, 5315, 196, 70, "DefinitionBox",
 CellID->15460],
Cell[9550, 346, 74, 1, 70, "Caption",
 CellID->20615],
Cell[9627, 349, 661, 13, 70, "Text",
 CellID->10904],
Cell[CellGroupData[{
Cell[10313, 366, 72, 1, 70, "RelatedTutorialsSection",
 CellID->819438955],
Cell[10388, 369, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[10587, 377, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

