(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17595,        615]
NotebookOptionsPosition[     14597,        523]
NotebookOutlinePosition[     16249,        565]
CellTagsIndexPosition[     16206,        562]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SymmetricPolynomial" :> 
         Documentation`HelpLookup["paclet:ref/SymmetricPolynomial"], 
         "SymmetricReduction" :> 
         Documentation`HelpLookup["paclet:ref/SymmetricReduction"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"SymmetricPolynomial\"\>", 
      2->"\<\"SymmetricReduction\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Symmetric Polynomials", "Title",
 CellID->19070],

Cell[TextData[{
 "A ",
 StyleBox["symmetric polynomial",
  FontSlant->"Italic"],
 " in variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " is a polynomial that is invariant under arbitrary permutations of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 ". Polynomials"
}], "Text",
 CellID->628870290],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["s", "1"], "=", 
    RowBox[{
     SubscriptBox["x", "1"], "+", 
     SubscriptBox["x", "2"], "+", "\[Ellipsis]", "+", 
     SubscriptBox["x", "n"]}]}], TraditionalForm]]],
 "\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["s", "2"], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "1"], 
      SubscriptBox["x", "2"]}], "+", 
     RowBox[{
      SubscriptBox["x", "1"], 
      SubscriptBox["x", "3"]}], "+", "\[Ellipsis]", "+", 
     RowBox[{
      SubscriptBox["x", 
       RowBox[{"n", "-", "1"}]], 
      SubscriptBox["x", "n"]}]}]}], TraditionalForm]]],
 "\n",
 "\[Ellipsis]",
 "\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["s", "n"], "=", 
    RowBox[{
     SubscriptBox["x", "1"], 
     SubscriptBox["x", "2"], "\[Ellipsis]", " ", 
     SubscriptBox["x", "n"]}]}], TraditionalForm]]]
}], "DisplayMath",
 CellID->425794118],

Cell[TextData[{
 "are called ",
 StyleBox["elementary symmetric polynomials",
  FontSlant->"Italic"],
 " in variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->78032873],

Cell[TextData[{
 "The fundamental theorem of symmetric polynomials says that every symmetric \
polynomial in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " can be represented as a polynomial in elementary symmetric polynomials in \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->688],

Cell[TextData[{
 "When the ordering of variables is fixed, an arbitrary polynomial ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " can be uniquely represented as a sum of a symmetric polynomial ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", called the symmetric part of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", and a remainder ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " that does not contain descending monomials. A monomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", 
    SubsuperscriptBox["x", "1", 
     SubscriptBox["e", "1"]], "\[Ellipsis]", " ", 
    SubsuperscriptBox["x", "n", 
     SubscriptBox["e", "n"]]}], TraditionalForm]], "InlineMath"],
 " is called descending iff ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "\[GreaterEqual]", "\[Ellipsis]", 
    "\[GreaterEqual]", 
    SubscriptBox["e", "n"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->5429],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SymmetricPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SymmetricPolynomial"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["n", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " elementary symmetric polynomial in the variables ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SymmetricReduction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SymmetricReduction"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["n", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "give a pair of polynomials ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"p", ",", "q"}], "}"}], TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
     " such that ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "==", 
        RowBox[{"p", "+", "q"}]}], TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " is the symmetric part and ",
     Cell[BoxData[
      FormBox["q", TraditionalForm]], "InlineMath"],
     " is the remainder"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SymmetricReduction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SymmetricReduction"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["n", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["n", "TI"]]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the pair ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"p", ",", "q"}], "}"}], TraditionalForm]], "InlineMath"],
     " with the elementary symmetric polynomials in ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " replaced by ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["s", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["s", "n"]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->460948040],

Cell["Functions for symmetric polynomial computations.", "Caption",
 CellID->164046235],

Cell["\<\
Here is the elementary symmetric polynomial of degree three in four \
variables. \
\>", "MathCaption",
 CellID->7347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetricPolynomial", "[", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6547],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", " ", "x", " ", "y"}], "+", 
  RowBox[{"t", " ", "x", " ", "z"}], "+", 
  RowBox[{"t", " ", "y", " ", "z"}], "+", 
  RowBox[{"x", " ", "y", " ", "z"}]}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11993959]
}, Open  ]],

Cell[TextData[{
 "This writes the polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "z"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "y"}], ")"}], "2"]}], TraditionalForm]], 
  "InlineMath"],
 " in terms of elementary symmetric polynomials. The input polynomial is \
symmetric, so the remainder is zero. "
}], "MathCaption",
 CellID->27584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetricReduction", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "+", "z"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "y"}], ")"}], "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", "y", "+", "z"}], ")"}], "2"]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "+", 
       RowBox[{"x", " ", "z"}], "+", 
       RowBox[{"y", " ", "z"}]}], ")"}]}]}], ",", "0"}], "}"}]], "Output",
 ImageSize->{225, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->542500418]
}, Open  ]],

Cell[TextData[{
 "Here the elementary symmetric polynomials in the symmetric part are \
replaced with variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["s", "1"], ",", 
    SubscriptBox["s", "2"], ",", 
    SubscriptBox["s", "3"]}], TraditionalForm]], "InlineMath"],
 ". The polynomial is not symmetric, so the remainder is not zero."
}], "MathCaption",
 CellID->14488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetricReduction", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["y", "5"], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["s", "1"], ",", 
     SubscriptBox["s", "2"], ",", 
     SubscriptBox["s", "3"]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22763],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["s", "1", "5"], "-", 
    RowBox[{"5", " ", 
     SubsuperscriptBox["s", "1", "3"], " ", 
     SubscriptBox["s", "2"]}], "+", 
    RowBox[{"5", " ", 
     SubscriptBox["s", "1"], " ", 
     SubsuperscriptBox["s", "2", "2"]}], "+", 
    RowBox[{"5", " ", 
     SubsuperscriptBox["s", "1", "2"], " ", 
     SubscriptBox["s", "3"]}], "-", 
    RowBox[{"5", " ", 
     SubscriptBox["s", "2"], " ", 
     SubscriptBox["s", "3"]}]}], ",", 
   RowBox[{
    SuperscriptBox["z", "4"], "-", 
    SuperscriptBox["z", "5"]}]}], "}"}]], "Output",
 ImageSize->{282, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->476304999]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SymmetricReduction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SymmetricReduction"]], "InlineFormula"],
 " can be applied to polynomials with symbolic coefficients."
}], "MathCaption",
 CellID->97105199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymmetricReduction", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["y", "5"], "+", 
    SuperscriptBox["z", "4"], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["y", "4"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["z", "5"]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["s", "1"], ",", 
     SubscriptBox["s", "2"], ",", 
     SubscriptBox["s", "3"]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->538827322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SubsuperscriptBox["s", "1", "4"]}], "+", 
    SubsuperscriptBox["s", "1", "5"], "-", 
    RowBox[{"4", " ", "a", " ", 
     SubsuperscriptBox["s", "1", "2"], " ", 
     SubscriptBox["s", "2"]}], "-", 
    RowBox[{"5", " ", 
     SubsuperscriptBox["s", "1", "3"], " ", 
     SubscriptBox["s", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SubsuperscriptBox["s", "2", "2"]}], "+", 
    RowBox[{"5", " ", 
     SubscriptBox["s", "1"], " ", 
     SubsuperscriptBox["s", "2", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", 
     SubscriptBox["s", "1"], " ", 
     SubscriptBox["s", "3"]}], "+", 
    RowBox[{"5", " ", 
     SubsuperscriptBox["s", "1", "2"], " ", 
     SubscriptBox["s", "3"]}], "-", 
    RowBox[{"5", " ", 
     SubscriptBox["s", "2"], " ", 
     SubscriptBox["s", "3"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}], " ", 
     SuperscriptBox["y", "4"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "a"}], ")"}], " ", 
     SuperscriptBox["z", "4"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "c"}], ")"}], " ", 
     SuperscriptBox["z", "5"]}]}]}], "}"}]], "Output",
 ImageSize->{435, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->27464408]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Symmetric Polynomials - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 15.0766118}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A symmetric polynomial in variables x_1,...,x_n is a polynomial that is \
invariant under arbitrary permutations of x_1,...,x_n. Polynomials are called \
elementary symmetric polynomials in variables x_1,...,x_n. The fundamental \
theorem of symmetric polynomials says that every symmetric polynomial in \
x_1,...,x_n can be represented as a polynomial in elementary symmetric \
polynomials in x_1,...,x_n.", "synonyms" -> {}, "title" -> 
    "Symmetric Polynomials", "type" -> "Tutorial", "uri" -> 
    "tutorial/SymmetricPolynomials"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 729, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1354, 44, 54, 1, 70, "Title",
 CellID->19070],
Cell[1411, 47, 532, 18, 70, "Text",
 CellID->628870290],
Cell[1946, 67, 936, 37, 70, "DisplayMath",
 CellID->425794118],
Cell[2885, 106, 312, 12, 70, "Text",
 CellID->78032873],
Cell[3200, 120, 536, 17, 70, "Text",
 CellID->688],
Cell[3739, 139, 1009, 30, 70, "Text",
 CellID->5429],
Cell[4751, 171, 3476, 112, 70, "DefinitionBox",
 CellID->460948040],
Cell[8230, 285, 87, 1, 70, "Caption",
 CellID->164046235],
Cell[8320, 288, 127, 4, 70, "MathCaption",
 CellID->7347],
Cell[CellGroupData[{
Cell[8472, 296, 202, 6, 70, "Input",
 CellID->6547],
Cell[8677, 304, 332, 10, 36, "Output",
 CellID->11993959]
}, Open  ]],
Cell[9024, 317, 534, 18, 70, "MathCaption",
 CellID->27584],
Cell[CellGroupData[{
Cell[9583, 339, 463, 16, 70, "Input",
 CellID->26251],
Cell[10049, 357, 517, 18, 39, "Output",
 CellID->542500418]
}, Open  ]],
Cell[10581, 378, 387, 11, 70, "MathCaption",
 CellID->14488],
Cell[CellGroupData[{
Cell[10993, 393, 448, 15, 70, "Input",
 CellID->22763],
Cell[11444, 410, 738, 24, 39, "Output",
 CellID->476304999]
}, Open  ]],
Cell[12197, 437, 254, 7, 70, "MathCaption",
 CellID->97105199],
Cell[CellGroupData[{
Cell[12476, 448, 638, 21, 70, "Input",
 CellID->538827322],
Cell[13117, 471, 1426, 46, 58, "Output",
 CellID->27464408]
}, Open  ]]
}, Open  ]],
Cell[14570, 521, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

