(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11752,        394]
NotebookOptionsPosition[      6669,        235]
NotebookOutlinePosition[     10116,        332]
CellTagsIndexPosition[     10028,        326]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Systemwide Defaults on Mac OS X", "Title",
 CellTags->"i:1",
 CellID->333046040],

Cell[TextData[{
 "If you have installed ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a location where multiple users run it (for example, on a file server \
or multi-user machine), then you can set up systemwide defaults for the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end and kernel. This is ideal for setting up ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for use in computer labs and classrooms. If you share the directory ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 " across the network, these defaults will also take effect on local \
installations that use the shared ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 "."
}], "Text",
 CellTags->"b:7.4",
 CellID->371496363],

Cell[TextData[{
 "The following instructions assume that ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 " and ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 " have their default values, /Library/Mathematica and ~/Library/Mathematica, \
respectively. "
}], "Text",
 CellTags->"b:7.4",
 CellID->91071220],

Cell[CellGroupData[{

Cell["To set up a configuration file for the front end:", "Section",
 CellTags->"b:7.4",
 CellID->164711552],

Cell[TextData[{
 "Launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and set up any changes to the front end that you need. For example, you \
may want to modify default file locations, language",
 " ",
 "options, or menu settings."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:7.4",
 CellID->643493748],

Cell[TextData[{
 "Quit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "ItemizedText",
 CellTags->"b:7.4",
 CellID->945334221],

Cell[CellGroupData[{

Cell["\<\
Copy the file ~/Library/Mathematica/FrontEnd/init.m to the directory \
/Library/Mathematica/FrontEnd. \
\>", "ItemizedText",
 CellTags->"b:7.4",
 CellID->39644670],

Cell["\<\
These settings will now be used by the front end unless overridden by the \
local init.m file stored in the user\[CloseCurlyQuote]s \
~/Library/Mathematica/FrontEnd directory. \
\>", "Text",
 CellTags->"b:7.4",
 CellID->18564345]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["To set up a configuration file for the kernel:", "Section",
 CellTags->"b:7.4",
 CellID->241781887],

Cell[TextData[{
 "Launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and create a new file."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:7.4",
 CellID->236636254],

Cell[TextData[{
 "Add any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands that should be evaluated on startup. For example, you may want to \
add a function definition or display a message at startup. Enter all the \
commands in the same cell, separating commands with semicolons."
}], "ItemizedText",
 CellTags->"b:7.4",
 CellID->375806146],

Cell[TextData[{
 "Make this cell an initialization cell by selecting the cell bracket and \
then choosing ",
 StyleBox["Cell", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Cell Properties", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Initialization Cell", "MenuName"],
 ". "
}], "ItemizedText",
 CellTags->"b:7.4",
 CellID->248145801],

Cell[CellGroupData[{

Cell[TextData[{
 "When you have finished making your changes, choose ",
 StyleBox["File", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Save", "MenuName"],
 StyleBox[" and s", "TR"],
 "elect ",
 StyleBox["Mathematica Package", "DialogElementName"],
 " from the ",
 StyleBox["Save as type", "DialogElementName"],
 " pop-up menu. Then save the file as ",
 StyleBox["/Library/Mathematica/Kernel/init.m",
  HyphenationOptions->{"HyphenationCharacter"->" "}],
 ". "
}], "ItemizedText",
 CellTags->"b:7.4",
 CellID->114411460],

Cell[TextData[{
 "These commands will be evaluated when users launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you added a function definition, that function will be available to",
 " ",
 "all users."
}], "Text",
 CellTags->"b:7.4",
 CellID->242450150]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->882974543],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Systemwide Defaults on Mac OS X - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 16.1703898}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If you have installed Mathematica in a location where multiple users run \
it (for example, on a file server or multi-user machine), then you can set up \
systemwide defaults for the Mathematica front end and kernel. This is ideal \
for setting up Mathematica for use in computer labs and classrooms. If you \
share the directory $BaseDirectory across the network, these defaults will \
also take effect on local installations that use the shared $BaseDirectory. \
The following instructions assume that $BaseDirectory and $UserBaseDirectory \
have their default values, /Library/Mathematica and ~/Library/Mathematica, \
respectively. These settings will now be used by the front end unless \
overridden by the local init.m file stored in the user's \
~/Library/Mathematica/FrontEnd directory. ", "synonyms" -> {}, "title" -> 
    "Systemwide Defaults on Mac OS X", "type" -> "Tutorial", "uri" -> 
    "tutorial/SystemwideDefaultsOnMacOSX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:1"->{
  Cell[1565, 48, 86, 2, 70, "Title",
   CellTags->"i:1",
   CellID->333046040]},
 "b:7.4"->{
  Cell[1654, 52, 874, 23, 70, "Text",
   CellTags->"b:7.4",
   CellID->371496363],
  Cell[2531, 77, 460, 13, 70, "Text",
   CellTags->"b:7.4",
   CellID->91071220],
  Cell[3016, 94, 108, 2, 70, "Section",
   CellTags->"b:7.4",
   CellID->164711552],
  Cell[3127, 98, 348, 11, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:7.4",
   CellID->643493748],
  Cell[3478, 111, 139, 7, 70, "ItemizedText",
   CellTags->"b:7.4",
   CellID->945334221],
  Cell[3642, 122, 173, 5, 70, "ItemizedText",
   CellTags->"b:7.4",
   CellID->39644670],
  Cell[3818, 129, 239, 6, 70, "Text",
   CellTags->"b:7.4",
   CellID->18564345],
  Cell[4106, 141, 105, 2, 70, "Section",
   CellTags->"b:7.4",
   CellID->241781887],
  Cell[4214, 145, 208, 8, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:7.4",
   CellID->236636254],
  Cell[4425, 155, 357, 9, 70, "ItemizedText",
   CellTags->"b:7.4",
   CellID->375806146],
  Cell[4785, 166, 413, 11, 70, "ItemizedText",
   CellTags->"b:7.4",
   CellID->248145801],
  Cell[5223, 181, 558, 16, 70, "ItemizedText",
   CellTags->"b:7.4",
   CellID->114411460],
  Cell[5784, 199, 269, 9, 70, "Text",
   CellTags->"b:7.4",
   CellID->242450150]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:1", 8680, 277},
 {"b:7.4", 8773, 281}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 86, 2, 70, "Title",
 CellTags->"i:1",
 CellID->333046040],
Cell[1654, 52, 874, 23, 70, "Text",
 CellTags->"b:7.4",
 CellID->371496363],
Cell[2531, 77, 460, 13, 70, "Text",
 CellTags->"b:7.4",
 CellID->91071220],
Cell[CellGroupData[{
Cell[3016, 94, 108, 2, 70, "Section",
 CellTags->"b:7.4",
 CellID->164711552],
Cell[3127, 98, 348, 11, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:7.4",
 CellID->643493748],
Cell[3478, 111, 139, 7, 70, "ItemizedText",
 CellTags->"b:7.4",
 CellID->945334221],
Cell[CellGroupData[{
Cell[3642, 122, 173, 5, 70, "ItemizedText",
 CellTags->"b:7.4",
 CellID->39644670],
Cell[3818, 129, 239, 6, 70, "Text",
 CellTags->"b:7.4",
 CellID->18564345]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4106, 141, 105, 2, 70, "Section",
 CellTags->"b:7.4",
 CellID->241781887],
Cell[4214, 145, 208, 8, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:7.4",
 CellID->236636254],
Cell[4425, 155, 357, 9, 70, "ItemizedText",
 CellTags->"b:7.4",
 CellID->375806146],
Cell[4785, 166, 413, 11, 70, "ItemizedText",
 CellTags->"b:7.4",
 CellID->248145801],
Cell[CellGroupData[{
Cell[5223, 181, 558, 16, 70, "ItemizedText",
 CellTags->"b:7.4",
 CellID->114411460],
Cell[5784, 199, 269, 9, 70, "Text",
 CellTags->"b:7.4",
 CellID->242450150]
}, Open  ]],
Cell[CellGroupData[{
Cell[6090, 213, 72, 1, 70, "RelatedTutorialsSection",
 CellID->882974543],
Cell[6165, 216, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[6382, 223, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6642, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

