(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14417,        497]
NotebookOptionsPosition[      7638,        282]
NotebookOutlinePosition[     12335,        423]
CellTagsIndexPosition[     12075,        410]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Testing the Installation on Mac OS X", "Title",
 CellTags->{"b:7.1.2", "net: 1", "i:2"},
 CellID->49496837],

Cell[TextData[{
 "The following simple commands allow you to test the installation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Running these commands does not guarantee that the installation was \
successful, but a failed command can indicate that a serious problem \
occurred",
 " ",
 "during installation. "
}], "Text",
 CellTags->"b:7.1.2",
 CellID->233397142],

Cell["\<\
You should run these tests from a regular user account and not from an \
account with administrator privileges.\
\>", "Text",
 CellTags->"b:5.1.2",
 CellID->271841050],

Cell[TextData[{
 "To run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a network license, both the client machine and the license server \
must be on the network and ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " must be running."
}], "Text",
 CellTags->"b:3.2",
 CellID->115680351],

Cell[TextData[{
 "If you run into problems when doing these tests, see the troubleshooting \
tips in \"",
 ButtonBox["Troubleshooting on MacOSX",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TroubleshootingOnMacOSX"],
 "\". If you do not find the answer there, check the Technical Support \
website at ",
 ButtonBox["support.wolfram.com/mathematica",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com/mathematica"], None}],
 "."
}], "Text",
 CellTags->"b:7.1.2",
 CellID->397435993],

Cell[CellGroupData[{

Cell["To test the kernel:", "Section",
 CellTags->{"b:7.1.0", "net: 1", "i:3"},
 CellID->464557400],

Cell[CellGroupData[{

Cell[TextData[{
 "To start the kernel, open the Terminal application and type the full \
pathname of the MathKernel binary in the window that appears. For example, if \
you installed ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the Applications folder, type ",
 StyleBox["/Applications/Mathematica.app/Contents/MacOS/MathKernel", 
  "InlineCode"],
 " in a Terminal window and press ",
 StyleBox["Return", "KeyEvent"],
 "."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"b:7.1.0", "i:3"},
 CellID->42638319],

Cell["In[1]:=", "Program",
 CellTags->"b:7.1.0",
 CellID->269535209]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Type ",
 StyleBox["N[Pi, 20]", "InlineCode"],
 " and press ",
 StyleBox["Return", "KeyEvent"],
 ". The number in the output should match the output shown here."
}], "ItemizedText",
 CellTags->"b:7.1.0",
 CellID->200439412],

Cell["\<\
In[1]:= N[Pi, 20] 

Out[1]= 3.1415926535897932385

In[2]:=\
\>", "Program",
 CellTags->"b:7.1.0",
 CellID->308287543]
}, Open  ]],

Cell[TextData[{
 "To exit the kernel, type ",
 StyleBox["Exit", "InlineCode"],
 " and press ",
 StyleBox["Return", "KeyEvent"],
 "."
}], "ItemizedText",
 CellTags->"b:7.1.0",
 CellID->293633820]
}, Open  ]],

Cell[CellGroupData[{

Cell["To test the front end:", "Section",
 CellTags->{"b:7.1.1", "net: 1", "i:1"},
 CellID->27263840],

Cell[TextData[{
 "Launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by double-clicking the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " icon. Three windows appear. "
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:7.1.1",
 CellID->301795376],

Cell[TextData[{
 "Click anywhere inside the leftmost empty window. This window is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "ItemizedText",
 CellTags->"b:7.1.1",
 CellID->7232037],

Cell[TextData[{
 "Type ",
 StyleBox["N[Pi, 20]", "InlineCode"],
 ". Then hold down the ",
 StyleBox["Shift", "KeyEvent"],
 " key and press ",
 StyleBox["Return", "KeyEvent"],
 " to evaluate. This should send the command to the kernel and return the \
same result as before. The ",
 StyleBox["In[1]", "InlineCode"],
 " and ",
 StyleBox["Out[1]", "InlineCode"],
 " labels are prepended once the evaluation is completed."
}], "ItemizedTextParagraph",
 CellTags->"b:7.1.1",
 CellID->490494612],

Cell["\<\
In the notebook window, there should be a horizontal line across the \
notebook; this is the horizontal insertion bar. If you do not see one, move \
the pointer until it becomes a horizontal I\[Hyphen]beam and click once to \
see the insertion bar. \
\>", "ItemizedTextParagraph",
 CellTags->"b:7.1.1",
 CellID->895862018],

Cell[TextData[{
 "Press the ",
 StyleBox["Esc", "KeyEvent"],
 " key. You should see three small horizontal lines in a column (\
\[AliasIndicator]). Type ",
 StyleBox["int", "InlineCode"],
 " and press ",
 StyleBox["Esc", "KeyEvent"],
 " again. You should see an integral sign (\[Integral]\[ThinSpace]). As an \
additional font check, typing ",
 StyleBox["\[Backslash][CheckmarkedBox]", "InlineCode"],
 " and ",
 StyleBox["\[Backslash][CirclePlus]", "InlineCode"],
 " should print the symbols ",
 StyleBox["\[CheckmarkedBox]", "InlineCode"],
 " and ",
 StyleBox["\[CirclePlus]", "InlineCode"],
 ", respectively. If the symbols show up correctly, the fonts have been \
properly installed."
}], "ItemizedText",
 CellTags->"b:7.1.1",
 CellID->10747502],

Cell[TextData[{
 "From the ",
 StyleBox["Help", "MenuName"],
 " menu, choose ",
 StyleBox["Documentation Center", "MenuName"],
 ". The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Documentation Center should appear."
}], "ItemizedText",
 CellTags->"b:7.1.1",
 CellID->375475349],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->803609],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Testing the Installation on Mac OS X - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 25.4675028}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The following simple commands allow you to test the installation of \
Mathematica. Running these commands does not guarantee that the installation \
was successful, but a failed command can indicate that a serious problem \
occurred during installation. You should run these tests from a regular user \
account and not from an account with administrator privileges. To run \
Mathematica using a network license, both the client machine and the license \
server must be on the network and MathLM must be running.", "synonyms" -> {}, 
    "title" -> "Testing the Installation on Mac OS X", "type" -> "Tutorial", 
    "uri" -> "tutorial/TestingTheInstallationOnMacOSX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:7.1.2"->{
  Cell[1565, 48, 113, 2, 70, "Title",
   CellTags->{"b:7.1.2", "net: 1", "i:2"},
   CellID->49496837],
  Cell[1681, 52, 378, 11, 70, "Text",
   CellTags->"b:7.1.2",
   CellID->233397142],
  Cell[2620, 87, 517, 15, 70, "Text",
   CellTags->"b:7.1.2",
   CellID->397435993]},
 "net: 1"->{
  Cell[1565, 48, 113, 2, 70, "Title",
   CellTags->{"b:7.1.2", "net: 1", "i:2"},
   CellID->49496837],
  Cell[3162, 106, 99, 2, 70, "Section",
   CellTags->{"b:7.1.0", "net: 1", "i:3"},
   CellID->464557400],
  Cell[4559, 170, 101, 2, 70, "Section",
   CellTags->{"b:7.1.1", "net: 1", "i:1"},
   CellID->27263840]},
 "i:2"->{
  Cell[1565, 48, 113, 2, 70, "Title",
   CellTags->{"b:7.1.2", "net: 1", "i:2"},
   CellID->49496837]},
 "b:5.1.2"->{
  Cell[2062, 65, 177, 5, 70, "Text",
   CellTags->"b:5.1.2",
   CellID->271841050]},
 "b:3.2"->{
  Cell[2242, 72, 375, 13, 70, "Text",
   CellTags->"b:3.2",
   CellID->115680351]},
 "b:7.1.0"->{
  Cell[3162, 106, 99, 2, 70, "Section",
   CellTags->{"b:7.1.0", "net: 1", "i:3"},
   CellID->464557400],
  Cell[3286, 112, 549, 15, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->{"b:7.1.0", "i:3"},
   CellID->42638319],
  Cell[3838, 129, 68, 2, 70, "Program",
   CellTags->"b:7.1.0",
   CellID->269535209],
  Cell[3943, 136, 240, 8, 70, "ItemizedText",
   CellTags->"b:7.1.0",
   CellID->200439412],
  Cell[4186, 146, 127, 8, 70, "Program",
   CellTags->"b:7.1.0",
   CellID->308287543],
  Cell[4328, 157, 194, 8, 70, "ItemizedText",
   CellTags->"b:7.1.0",
   CellID->293633820]},
 "i:3"->{
  Cell[3162, 106, 99, 2, 70, "Section",
   CellTags->{"b:7.1.0", "net: 1", "i:3"},
   CellID->464557400],
  Cell[3286, 112, 549, 15, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->{"b:7.1.0", "i:3"},
   CellID->42638319]},
 "b:7.1.1"->{
  Cell[4559, 170, 101, 2, 70, "Section",
   CellTags->{"b:7.1.1", "net: 1", "i:1"},
   CellID->27263840],
  Cell[4663, 174, 293, 11, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:7.1.1",
   CellID->301795376],
  Cell[4959, 187, 209, 7, 70, "ItemizedText",
   CellTags->"b:7.1.1",
   CellID->7232037],
  Cell[5171, 196, 489, 15, 70, "ItemizedTextParagraph",
   CellTags->"b:7.1.1",
   CellID->490494612],
  Cell[5663, 213, 332, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:7.1.1",
   CellID->895862018],
  Cell[5998, 222, 748, 21, 70, "ItemizedText",
   CellTags->"b:7.1.1",
   CellID->10747502],
  Cell[6749, 245, 288, 11, 70, "ItemizedText",
   CellTags->"b:7.1.1",
   CellID->375475349]},
 "i:1"->{
  Cell[4559, 170, 101, 2, 70, "Section",
   CellTags->{"b:7.1.1", "net: 1", "i:1"},
   CellID->27263840]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:7.1.2", 9384, 320},
 {"net: 1", 9671, 330},
 {"i:2", 9997, 340},
 {"b:5.1.2", 10115, 344},
 {"b:3.2", 10212, 348},
 {"b:7.1.0", 10310, 352},
 {"i:3", 10936, 372},
 {"b:7.1.1", 11205, 380},
 {"i:1", 11945, 403}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 113, 2, 70, "Title",
 CellTags->{"b:7.1.2", "net: 1", "i:2"},
 CellID->49496837],
Cell[1681, 52, 378, 11, 70, "Text",
 CellTags->"b:7.1.2",
 CellID->233397142],
Cell[2062, 65, 177, 5, 70, "Text",
 CellTags->"b:5.1.2",
 CellID->271841050],
Cell[2242, 72, 375, 13, 70, "Text",
 CellTags->"b:3.2",
 CellID->115680351],
Cell[2620, 87, 517, 15, 70, "Text",
 CellTags->"b:7.1.2",
 CellID->397435993],
Cell[CellGroupData[{
Cell[3162, 106, 99, 2, 70, "Section",
 CellTags->{"b:7.1.0", "net: 1", "i:3"},
 CellID->464557400],
Cell[CellGroupData[{
Cell[3286, 112, 549, 15, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->{"b:7.1.0", "i:3"},
 CellID->42638319],
Cell[3838, 129, 68, 2, 70, "Program",
 CellTags->"b:7.1.0",
 CellID->269535209]
}, Open  ]],
Cell[CellGroupData[{
Cell[3943, 136, 240, 8, 70, "ItemizedText",
 CellTags->"b:7.1.0",
 CellID->200439412],
Cell[4186, 146, 127, 8, 70, "Program",
 CellTags->"b:7.1.0",
 CellID->308287543]
}, Open  ]],
Cell[4328, 157, 194, 8, 70, "ItemizedText",
 CellTags->"b:7.1.0",
 CellID->293633820]
}, Open  ]],
Cell[CellGroupData[{
Cell[4559, 170, 101, 2, 70, "Section",
 CellTags->{"b:7.1.1", "net: 1", "i:1"},
 CellID->27263840],
Cell[4663, 174, 293, 11, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:7.1.1",
 CellID->301795376],
Cell[4959, 187, 209, 7, 70, "ItemizedText",
 CellTags->"b:7.1.1",
 CellID->7232037],
Cell[5171, 196, 489, 15, 70, "ItemizedTextParagraph",
 CellTags->"b:7.1.1",
 CellID->490494612],
Cell[5663, 213, 332, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:7.1.1",
 CellID->895862018],
Cell[5998, 222, 748, 21, 70, "ItemizedText",
 CellTags->"b:7.1.1",
 CellID->10747502],
Cell[6749, 245, 288, 11, 70, "ItemizedText",
 CellTags->"b:7.1.1",
 CellID->375475349],
Cell[CellGroupData[{
Cell[7062, 260, 69, 1, 70, "RelatedTutorialsSection",
 CellID->803609],
Cell[7134, 263, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[7351, 270, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7611, 280, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

