(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14699,        507]
NotebookOptionsPosition[      7927,        292]
NotebookOutlinePosition[     12527,        430]
CellTagsIndexPosition[     12291,        418]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Testing the Installation on Windows", "Title",
 CellTags->{"b:5.1.2", "net: 1", "i:2"},
 CellID->7030193],

Cell[TextData[{
 "The following simple commands allow you to test the installation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Running these commands does not guarantee that the installation was \
successful, but a failed command can indicate that a serious problem \
occurred",
 " ",
 "during installation. "
}], "Text",
 CellTags->"b:5.1.2",
 CellID->105925447],

Cell["\<\
You should run these tests from a regular user account and not from an \
account with administrative privileges.\
\>", "Text",
 CellTags->"b:5.1.2",
 CellID->475298738],

Cell[TextData[{
 "To run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a network license, both the client machine and the license server \
must be on the network and ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " must be running."
}], "Text",
 CellTags->"b:3.2",
 CellID->758137242],

Cell[TextData[{
 "If you run into problems when doing these tests, see the troubleshooting \
tips in \"",
 ButtonBox["Troubleshooting on Windows",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TroubleshootingOnWindows"],
 "\". If you do not find the answer there, check the Technical Support \
website at ",
 ButtonBox["support.wolfram.com/mathematica",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com/mathematica"], None}],
 "."
}], "Text",
 CellTags->"b:5.1.2",
 CellID->249910306],

Cell[CellGroupData[{

Cell["To test the kernel:", "Section",
 CellTags->{"b:5.1.0", "net: 1", "i:3"},
 CellID->658382637],

Cell[CellGroupData[{

Cell[TextData[{
 "To start the kernel, choose ",
 StyleBox["Programs", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Mathematica 6", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Mathematica 6 Kernel", "MenuName"],
 " from the ",
 StyleBox["Start", "MenuName"],
 " menu."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedText", 0}},
 CellTags->"b:5.1.0",
 CellID->736620415],

Cell["In[1]:=", "Program",
 CellTags->"b:5.1.0",
 CellID->302222049]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Type ",
 StyleBox["N[Pi, 20]", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 ". The number in the output should match the output shown here."
}], "ItemizedText",
 CellTags->"b:5.1.0",
 CellID->279117902],

Cell["\<\
In[1]:= N[Pi, 20]

Out[1]= 3.1415926535897932385 

In[2]:=\
\>", "Program",
 CellTags->"b:5.1.0",
 CellID->146743347]
}, Open  ]],

Cell[TextData[{
 "To exit the kernel, type ",
 StyleBox["Exit", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "ItemizedText",
 CellTags->"b:5.1.0",
 CellID->1012889753]
}, Open  ]],

Cell[CellGroupData[{

Cell["To test the front end:", "Section",
 CellTags->{"b:5.1.1", "net: 1", "i:1"},
 CellID->1039255],

Cell[TextData[{
 "Launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by choosing ",
 StyleBox["Programs", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Mathematica 6", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Mathematica 6 ", "MenuName"],
 "from the ",
 StyleBox["Start", "MenuName"],
 " menu."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedText", 0}},
 CellTags->"b:5.1.1",
 CellID->85751496],

Cell["\<\
A splash screen with initialization information appears briefly, after which \
three windows appear. \
\>", "ItemizedTextParagraph",
 CellTags->"b:5.1.1",
 CellID->171564553],

Cell[TextData[{
 "Click anywhere inside the leftmost empty window. This window is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "ItemizedText",
 CellTags->"b:5.1.1",
 CellID->59779500],

Cell[TextData[{
 "Type ",
 StyleBox["N[Pi,20]", "InlineCode"],
 ". Then hold down the ",
 StyleBox["Shift", "KeyEvent"],
 " key and press ",
 StyleBox["Enter", "KeyEvent"],
 " to evaluate. This should send the command to the kernel and return the \
same result as before. The ",
 StyleBox["In[1]", "InlineCode"],
 " and ",
 StyleBox["Out[1]", "InlineCode"],
 " labels are prepended once the evaluation is completed."
}], "ItemizedTextParagraph",
 CellTags->"b:5.1.1",
 CellID->185546907],

Cell["\<\
In the notebook window, there should be a horizontal line across the \
notebook; this is the horizontal insertion bar. If you do not see one, move \
the pointer until it becomes a horizontal I\[Hyphen]beam and click once to \
see the insertion bar.\
\>", "ItemizedTextParagraph",
 CellTags->"b:5.1.1",
 CellID->662382506],

Cell[TextData[{
 "Press the ",
 StyleBox["Esc", "KeyEvent"],
 " key. You should see three small horizontal lines in a column (\
\[AliasIndicator]). Type ",
 StyleBox["int", "InlineCode"],
 " and press ",
 StyleBox["Esc", "KeyEvent"],
 " again. You should see an integral sign (\[Integral]\[ThinSpace]). As an \
additional font check, typing ",
 StyleBox["\[Backslash][CheckmarkedBox]", "InlineCode"],
 " and ",
 StyleBox["\[Backslash][CirclePlus]", "InlineCode"],
 " should print the symbols ",
 StyleBox["\[CheckmarkedBox]", "InlineCode"],
 " and ",
 StyleBox["\[CirclePlus]", "InlineCode"],
 ", respectively. If the symbols show up correctly, the fonts have been \
properly installed."
}], "ItemizedText",
 CellTags->"b:5.1.1",
 CellID->303554426],

Cell[TextData[{
 "From the ",
 StyleBox["Help", "MenuName"],
 " menu, choose ",
 StyleBox["Documentation Center", "MenuName"],
 ". The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Documentation Center should appear."
}], "ItemizedText",
 CellTags->"b:5.1.1",
 CellID->236230046],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->88165736],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Testing the Installation on Windows - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 25.7643854}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The following simple commands allow you to test the installation of \
Mathematica. Running these commands does not guarantee that the installation \
was successful, but a failed command can indicate that a serious problem \
occurred during installation. You should run these tests from a regular user \
account and not from an account with administrative privileges. To run \
Mathematica using a network license, both the client machine and the license \
server must be on the network and MathLM must be running.", "synonyms" -> {}, 
    "title" -> "Testing the Installation on Windows", "type" -> "Tutorial", 
    "uri" -> "tutorial/TestingTheInstallationOnWindows"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:5.1.2"->{
  Cell[1565, 48, 111, 2, 70, "Title",
   CellTags->{"b:5.1.2", "net: 1", "i:2"},
   CellID->7030193],
  Cell[1679, 52, 378, 11, 70, "Text",
   CellTags->"b:5.1.2",
   CellID->105925447],
  Cell[2060, 65, 178, 5, 70, "Text",
   CellTags->"b:5.1.2",
   CellID->475298738],
  Cell[2619, 87, 519, 15, 70, "Text",
   CellTags->"b:5.1.2",
   CellID->249910306]},
 "net: 1"->{
  Cell[1565, 48, 111, 2, 70, "Title",
   CellTags->{"b:5.1.2", "net: 1", "i:2"},
   CellID->7030193],
  Cell[3163, 106, 99, 2, 70, "Section",
   CellTags->{"b:5.1.0", "net: 1", "i:3"},
   CellID->658382637],
  Cell[4463, 168, 100, 2, 70, "Section",
   CellTags->{"b:5.1.1", "net: 1", "i:1"},
   CellID->1039255]},
 "i:2"->{
  Cell[1565, 48, 111, 2, 70, "Title",
   CellTags->{"b:5.1.2", "net: 1", "i:2"},
   CellID->7030193]},
 "b:3.2"->{
  Cell[2241, 72, 375, 13, 70, "Text",
   CellTags->"b:3.2",
   CellID->758137242]},
 "b:5.1.0"->{
  Cell[3163, 106, 99, 2, 70, "Section",
   CellTags->{"b:5.1.0", "net: 1", "i:3"},
   CellID->658382637],
  Cell[3287, 112, 453, 13, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedText", 0}},
   CellTags->"b:5.1.0",
   CellID->736620415],
  Cell[3743, 127, 68, 2, 70, "Program",
   CellTags->"b:5.1.0",
   CellID->302222049],
  Cell[3848, 134, 239, 8, 70, "ItemizedText",
   CellTags->"b:5.1.0",
   CellID->279117902],
  Cell[4090, 144, 127, 8, 70, "Program",
   CellTags->"b:5.1.0",
   CellID->146743347],
  Cell[4232, 155, 194, 8, 70, "ItemizedText",
   CellTags->"b:5.1.0",
   CellID->1012889753]},
 "i:3"->{
  Cell[3163, 106, 99, 2, 70, "Section",
   CellTags->{"b:5.1.0", "net: 1", "i:3"},
   CellID->658382637]},
 "b:5.1.1"->{
  Cell[4463, 168, 100, 2, 70, "Section",
   CellTags->{"b:5.1.1", "net: 1", "i:1"},
   CellID->1039255],
  Cell[4566, 172, 491, 16, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedText", 0}},
   CellTags->"b:5.1.1",
   CellID->85751496],
  Cell[5060, 190, 184, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:5.1.1",
   CellID->171564553],
  Cell[5247, 197, 210, 7, 70, "ItemizedText",
   CellTags->"b:5.1.1",
   CellID->59779500],
  Cell[5460, 206, 487, 15, 70, "ItemizedTextParagraph",
   CellTags->"b:5.1.1",
   CellID->185546907],
  Cell[5950, 223, 331, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:5.1.1",
   CellID->662382506],
  Cell[6284, 232, 749, 21, 70, "ItemizedText",
   CellTags->"b:5.1.1",
   CellID->303554426],
  Cell[7036, 255, 288, 11, 70, "ItemizedText",
   CellTags->"b:5.1.1",
   CellID->236230046]},
 "i:1"->{
  Cell[4463, 168, 100, 2, 70, "Section",
   CellTags->{"b:5.1.1", "net: 1", "i:1"},
   CellID->1039255]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:5.1.2", 9673, 330},
 {"net: 1", 10043, 343},
 {"i:2", 10367, 353},
 {"b:3.2", 10482, 357},
 {"b:5.1.0", 10580, 361},
 {"i:3", 11199, 381},
 {"b:5.1.1", 11320, 385},
 {"i:1", 12162, 411}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 111, 2, 70, "Title",
 CellTags->{"b:5.1.2", "net: 1", "i:2"},
 CellID->7030193],
Cell[1679, 52, 378, 11, 70, "Text",
 CellTags->"b:5.1.2",
 CellID->105925447],
Cell[2060, 65, 178, 5, 70, "Text",
 CellTags->"b:5.1.2",
 CellID->475298738],
Cell[2241, 72, 375, 13, 70, "Text",
 CellTags->"b:3.2",
 CellID->758137242],
Cell[2619, 87, 519, 15, 70, "Text",
 CellTags->"b:5.1.2",
 CellID->249910306],
Cell[CellGroupData[{
Cell[3163, 106, 99, 2, 70, "Section",
 CellTags->{"b:5.1.0", "net: 1", "i:3"},
 CellID->658382637],
Cell[CellGroupData[{
Cell[3287, 112, 453, 13, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedText", 0}},
 CellTags->"b:5.1.0",
 CellID->736620415],
Cell[3743, 127, 68, 2, 70, "Program",
 CellTags->"b:5.1.0",
 CellID->302222049]
}, Open  ]],
Cell[CellGroupData[{
Cell[3848, 134, 239, 8, 70, "ItemizedText",
 CellTags->"b:5.1.0",
 CellID->279117902],
Cell[4090, 144, 127, 8, 70, "Program",
 CellTags->"b:5.1.0",
 CellID->146743347]
}, Open  ]],
Cell[4232, 155, 194, 8, 70, "ItemizedText",
 CellTags->"b:5.1.0",
 CellID->1012889753]
}, Open  ]],
Cell[CellGroupData[{
Cell[4463, 168, 100, 2, 70, "Section",
 CellTags->{"b:5.1.1", "net: 1", "i:1"},
 CellID->1039255],
Cell[4566, 172, 491, 16, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedText", 0}},
 CellTags->"b:5.1.1",
 CellID->85751496],
Cell[5060, 190, 184, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:5.1.1",
 CellID->171564553],
Cell[5247, 197, 210, 7, 70, "ItemizedText",
 CellTags->"b:5.1.1",
 CellID->59779500],
Cell[5460, 206, 487, 15, 70, "ItemizedTextParagraph",
 CellTags->"b:5.1.1",
 CellID->185546907],
Cell[5950, 223, 331, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:5.1.1",
 CellID->662382506],
Cell[6284, 232, 749, 21, 70, "ItemizedText",
 CellTags->"b:5.1.1",
 CellID->303554426],
Cell[7036, 255, 288, 11, 70, "ItemizedText",
 CellTags->"b:5.1.1",
 CellID->236230046],
Cell[CellGroupData[{
Cell[7349, 270, 71, 1, 70, "RelatedTutorialsSection",
 CellID->88165736],
Cell[7423, 273, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[7640, 280, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7900, 290, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

