(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26142,        925]
NotebookOptionsPosition[     20087,        740]
NotebookOutlinePosition[     23304,        818]
CellTagsIndexPosition[     23211,        812]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stack" :> Documentation`HelpLookup["paclet:ref/Stack"], 
          "StackBegin" :> Documentation`HelpLookup["paclet:ref/StackBegin"], 
          "StackComplete" :> 
          Documentation`HelpLookup["paclet:ref/StackComplete"], 
          "StackInhibit" :> 
          Documentation`HelpLookup["paclet:ref/StackInhibit"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Stack\"\>", 2->"\<\"StackBegin\"\>",
        3->"\<\"StackComplete\"\>", 
       4->"\<\"StackInhibit\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Evaluation Stack", "Title",
 CellTags->{"S2.6.13", "13.1"},
 CellID->1927],

Cell[TextData[{
 "Throughout any computation, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " maintains an ",
 StyleBox["evaluation stack",
  FontSlant->"Italic"],
 " containing the expressions it is currently evaluating. You can use the \
function ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " to look at the stack. This means, for example, that if you interrupt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the middle of a computation, you can use ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " to find out what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is doing. "
}], "Text",
 CellID->269],

Cell[TextData[{
 "The expression that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " most recently started to evaluate always appears as the last element of \
the evaluation stack. The previous elements of the stack are the other \
expressions whose evaluation is currently in progress. "
}], "Text",
 CellID->30393],

Cell[TextData[{
 "Thus at the point when ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is being evaluated, the stack associated with the evaluation of an \
expression like ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 "\[ThinSpace]",
 Cell[BoxData[
  RowBox[{"[", 
   RowBox[{
    StyleBox["g", "TI"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 " will have the form ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 "\[ThinSpace]",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"[", 
     RowBox[{
      StyleBox["g", "TI"], "[", 
      StyleBox["x", "TI"], "]"}], "]"}], ",", 
    RowBox[{
     StyleBox["g", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], ",", 
    StyleBox["x", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21033],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"], "[", "_", "]"}]], "InlineFormula"],
 " gives the expressions that are being evaluated at the time when it is \
called, in this case including the ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " function. "
}], "MathCaption",
 CellID->8431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"g", "[", 
    RowBox[{"Print", "[", 
     RowBox[{"Stack", "[", "_", "]"}], "]"}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->3592],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"g", "[", 
       RowBox[{"Print", "[", 
        RowBox[{"Stack", "[", "_", "]"}], "]"}], "]"}], "]"}], ";"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f", "[", 
     RowBox[{"g", "[", 
      RowBox[{"Print", "[", 
       RowBox[{"Stack", "[", "_", "]"}], "]"}], "]"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"g", "[", 
     RowBox[{"Print", "[", 
      RowBox[{"Stack", "[", "_", "]"}], "]"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Print", "[", 
     RowBox[{"Stack", "[", "_", "]"}], "]"}],
    HoldForm]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[22]:=",
 CellID->927867682]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"], "[", "]"}]], "InlineFormula"],
 " gives the tags associated with the evaluations that are being done when it \
is called. "
}], "MathCaption",
 CellID->19026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"g", "[", 
    RowBox[{"Print", "[", 
     RowBox[{"Stack", "[", "]"}], "]"}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->5842],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CompoundExpression", ",", "f", ",", "g", ",", "Print"}], 
  "}"}]], "Print",
 CellID->19080]
}, Open  ]],

Cell[TextData[{
 "In general, you can think of the evaluation stack as showing what functions \
called what other functions to get to the point ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is at in your computation. The sequence of expressions corresponds to the \
first elements in the successively nested lists returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " with the option ",
 Cell[BoxData[
  ButtonBox["TraceAbove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceAbove"]], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18616],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Stack",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Stack"], "[", "]"}], Cell["\<\
give a list of the tags associated with evaluations that are currently being \
done\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Stack",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Stack"], "[", "_", "]"}], Cell[
    "give a list of all expressions currently being evaluated", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Stack",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Stack"], "[", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "include only expressions which match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4961],

Cell["Looking at the evaluation stack. ", "Caption",
 CellID->28717],

Cell[TextData[{
 "It is rather rare to call ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " directly in your main ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. More often, you will want to call ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " in the middle of a computation. Typically, you can do this from within a \
dialog, or subsidiary session, as discussed in \"",
 ButtonBox["Dialogs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Dialogs"],
 "\". "
}], "Text",
 CellID->15907],

Cell["\<\
Here is the standard recursive definition of the factorial function. \
\>", "MathCaption",
 CellID->5920],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fac", "[", "1", "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"fac", "[", "n_", "]"}], ":=", 
   RowBox[{"n", " ", 
    RowBox[{"fac", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->13245],

Cell[TextData[{
 "This evaluates ",
 Cell[BoxData[
  RowBox[{"fac", "[", "10", "]"}]], "InlineFormula"],
 ", starting a dialog when it encounters ",
 Cell[BoxData[
  RowBox[{"fac", "[", "4", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->22166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraceDialog", "[", 
  RowBox[{
   RowBox[{"fac", "[", "10", "]"}], ",", 
   RowBox[{"fac", "[", "4", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->30121],

Cell[BoxData[
 RowBox[{
  RowBox[{"TraceDialog", "::", "\<\"dgbgn\"\>"}], ":", 
  " ", "\<\"Entering Dialog; use Return[] to exit.\"\>"}]], "Message", "MSG",
 CellID->27782],

Cell[BoxData[
 TagBox[
  RowBox[{"fac", "[", "4", "]"}],
  HoldForm]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->2782]
}, Open  ]],

Cell["\<\
This shows what objects were being evaluated when the dialog was started. \
\>", "MathCaption",
 CellID->27006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stack", "[", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->6491],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "TraceDialog", ",", "Times", ",", "Times", ",", "Times", ",", "Times", ",", 
   "Times", ",", "Times", ",", "fac"}], "}"}]], "Output",
 ImageSize->{405, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->31870]
}, Open  ]],

Cell["This ends the dialog. ", "MathCaption",
 CellID->14615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Return", "[", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->22195],

Cell[BoxData[
 RowBox[{
  RowBox[{"TraceDialog", "::", "\<\"dgend\"\>"}], ":", 
  " ", "\<\"Exiting Dialog.\"\>"}]], "Message", "MSG",
 CellID->13143],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->11763]
}, Open  ]],

Cell[TextData[{
 "In the simplest cases, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluation stack is set up to record ",
 StyleBox["all",
  FontSlant->"Italic"],
 " expressions currently being evaluated. Under some circumstances, however, \
this may be inconvenient. For example, executing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "[", 
   RowBox[{
    ButtonBox["Stack",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Stack"], "[", "]"}], "]"}]], "InlineFormula"],
 " will always show a stack with ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " as the last function. "
}], "Text",
 CellID->14771],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["StackInhibit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackInhibit"]], "InlineFormula"],
 " allows you to avoid this kind of problem. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StackInhibit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackInhibit"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " without modifying the stack. "
}], "Text",
 CellID->23592],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StackInhibit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackInhibit"]], "InlineFormula"],
 " prevents ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " from being included on the stack. "
}], "MathCaption",
 CellID->14935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"g", "[", 
    RowBox[{"StackInhibit", "[", 
     RowBox[{"Print", "[", 
      RowBox[{"Stack", "[", "]"}], "]"}], "]"}], "]"}], "]"}], ";"}]], "Input",\

 CellLabel->"In[7]:= ",
 CellID->19217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CompoundExpression", ",", "f", ",", "g"}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->25412]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["TraceDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceDialog"]], "InlineFormula"],
 " automatically call ",
 Cell[BoxData[
  ButtonBox["StackInhibit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackInhibit"]], "InlineFormula"],
 " each time they start a dialog. This means that ",
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " does not show functions that are called within the dialog, only those \
outside. "
}], "Text",
 CellID->5881],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StackInhibit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StackInhibit"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " without modifying the stack"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StackBegin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StackBegin"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with a fresh stack"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StackComplete",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StackComplete"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with intermediate expressions in evaluation chains included on the \
stack"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13467],

Cell["Controlling the evaluation stack. ", "Caption",
 CellID->26721],

Cell[TextData[{
 "By using ",
 Cell[BoxData[
  ButtonBox["StackInhibit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackInhibit"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StackBegin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackBegin"]], "InlineFormula"],
 ", you can control which parts of the evaluation process are recorded on the \
stack. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StackBegin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackBegin"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", starting a fresh stack. This means that during the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", the stack does not include anything outside the ",
 Cell[BoxData[
  ButtonBox["StackBegin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackBegin"]], "InlineFormula"],
 ". Functions like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceDialog"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " call ",
 Cell[BoxData[
  ButtonBox["StackBegin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackBegin"]], "InlineFormula"],
 " before they begin evaluating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", so that the stack shows how ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is evaluated, but not how ",
 Cell[BoxData[
  ButtonBox["TraceDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceDialog"]], "InlineFormula"],
 " was called. "
}], "Text",
 CellID->16952],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["StackBegin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackBegin"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " uses a fresh stack in the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"StackBegin", "[", 
   RowBox[{"g", "[", 
    RowBox[{"h", "[", 
     RowBox[{"StackInhibit", "[", 
      RowBox[{"Print", "[", 
       RowBox[{"Stack", "[", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->1828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"g", ",", "h"}], "}"}]], "Print",
 CellID->18230],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", "Null", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->429]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Stack",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stack"]], "InlineFormula"],
 " normally shows you only those expressions that are currently being \
evaluated. As a result, it includes only the latest form of each expression. \
Sometimes, however, you may find it useful also to see earlier forms of the \
expressions. You can do this using ",
 Cell[BoxData[
  ButtonBox["StackComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StackComplete"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21424],

Cell[TextData[{
 "What ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StackComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackComplete"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " effectively does is to keep on the stack the complete evaluation chain for \
each expression that is currently being evaluated. In this case, the stack \
corresponds to the sequence of expressions obtained from ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " with the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceBackward",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceBackward"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " as well as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceAbove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceAbove"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->17699],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->452939901],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Evaluation Stack - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TracingEvaluation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ControllingInfiniteEvaluation"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 33.2958282}", "context" -> "", 
    "keywords" -> {
     "dialogs", "pending evaluations", "stack", "StackBegin", "StackComplete",
       "StackInhibit", "TraceAbove", "TraceBackward", "TraceDialog", 
      "unwinding the stack"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Throughout any computation, Mathematica maintains an evaluation stack \
containing the expressions it is currently evaluating. You can use the \
function Stack to look at the stack. This means, for example, that if you \
interrupt Mathematica in the middle of a computation, you can use Stack to \
find out what Mathematica is doing. The expression that Mathematica most \
recently started to evaluate always appears as the last element of the \
evaluation stack. The previous elements of the stack are the other \
expressions whose evaluation is currently in progress. Thus at the point when \
x is being evaluated, the stack associated with the evaluation of an \
expression like f [g[x]] will have the form {f [g[x]],g[x],x}. ", 
    "synonyms" -> {"2.6.12"}, "title" -> "The Evaluation Stack", "type" -> 
    "Tutorial", "uri" -> "tutorial/TheEvaluationStack"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.13"->{
  Cell[2164, 64, 84, 2, 70, "Title",
   CellTags->{"S2.6.13", "13.1"},
   CellID->1927]},
 "13.1"->{
  Cell[2164, 64, 84, 2, 70, "Title",
   CellTags->{"S2.6.13", "13.1"},
   CellID->1927]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.13", 22997, 801},
 {"13.1", 23098, 805}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1539, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2164, 64, 84, 2, 70, "Title",
 CellTags->{"S2.6.13", "13.1"},
 CellID->1927],
Cell[2251, 68, 771, 26, 70, "Text",
 CellID->269],
Cell[3025, 96, 324, 8, 70, "Text",
 CellID->30393],
Cell[3352, 106, 836, 32, 70, "Text",
 CellID->21033],
Cell[4191, 140, 434, 14, 70, "MathCaption",
 CellID->8431],
Cell[CellGroupData[{
Cell[4650, 158, 209, 7, 70, "Input",
 CellID->3592],
Cell[4862, 167, 723, 26, 70, "Print",
 CellID->927867682]
}, Open  ]],
Cell[5600, 196, 282, 9, 70, "MathCaption",
 CellID->19026],
Cell[CellGroupData[{
Cell[5907, 209, 204, 7, 70, "Input",
 CellID->5842],
Cell[6114, 218, 132, 4, 70, "Print",
 CellID->19080]
}, Open  ]],
Cell[6261, 225, 753, 23, 70, "Text",
 CellID->18616],
Cell[7017, 250, 1102, 34, 70, "DefinitionBox",
 CellID->4961],
Cell[8122, 286, 68, 1, 70, "Caption",
 CellID->28717],
Cell[8193, 289, 649, 21, 70, "Text",
 CellID->15907],
Cell[8845, 312, 115, 3, 70, "MathCaption",
 CellID->5920],
Cell[8963, 317, 281, 10, 70, "Input",
 CellID->13245],
Cell[9247, 329, 256, 9, 70, "MathCaption",
 CellID->22166],
Cell[CellGroupData[{
Cell[9528, 342, 190, 6, 70, "Input",
 CellID->30121],
Cell[9721, 350, 173, 4, 70, "Message",
 CellID->27782],
Cell[9897, 356, 206, 8, 36, "Output",
 CellID->2782]
}, Open  ]],
Cell[10118, 367, 121, 3, 70, "MathCaption",
 CellID->27006],
Cell[CellGroupData[{
Cell[10264, 374, 92, 3, 70, "Input",
 CellID->6491],
Cell[10359, 379, 304, 9, 36, "Output",
 CellID->31870]
}, Open  ]],
Cell[10678, 391, 61, 1, 70, "MathCaption",
 CellID->14615],
Cell[CellGroupData[{
Cell[10764, 396, 94, 3, 70, "Input",
 CellID->22195],
Cell[10861, 401, 150, 4, 70, "Message",
 CellID->13143],
Cell[11014, 407, 161, 5, 36, "Output",
 CellID->11763]
}, Open  ]],
Cell[11190, 415, 764, 25, 70, "Text",
 CellID->14771],
Cell[11957, 442, 527, 18, 70, "Text",
 CellID->23592],
Cell[12487, 462, 344, 12, 70, "MathCaption",
 CellID->14935],
Cell[CellGroupData[{
Cell[12856, 478, 250, 9, 70, "Input",
 CellID->19217],
Cell[13109, 489, 228, 7, 36, "Output",
 CellID->25412]
}, Open  ]],
Cell[13352, 499, 591, 19, 70, "Text",
 CellID->5881],
Cell[13946, 520, 1361, 43, 70, "DefinitionBox",
 CellID->13467],
Cell[15310, 565, 69, 1, 70, "Caption",
 CellID->26721],
Cell[15382, 568, 1725, 57, 70, "Text",
 CellID->16952],
Cell[17110, 627, 339, 12, 70, "MathCaption",
 CellID->17322],
Cell[CellGroupData[{
Cell[17474, 643, 302, 10, 70, "Input",
 CellID->1828],
Cell[17779, 655, 88, 3, 70, "Print",
 CellID->18230],
Cell[17870, 660, 240, 8, 36, "Output",
 CellID->429]
}, Open  ]],
Cell[18125, 671, 558, 15, 70, "Text",
 CellID->21424],
Cell[18686, 688, 1067, 35, 70, "Text",
 CellID->17699],
Cell[CellGroupData[{
Cell[19778, 727, 72, 1, 70, "RelatedTutorialsSection",
 CellID->452939901],
Cell[19853, 730, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[20060, 738, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

