(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7814,        245]
NotebookOptionsPosition[      4478,        156]
NotebookOutlinePosition[      7401,        230]
CellTagsIndexPosition[      7312,        224]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Building Up Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BuildingUpCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Building Up Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Part" :> Documentation`HelpLookup["paclet:ref/Part"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Part\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "The Four Kinds of Bracketing in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellTags->{"S1.2.5", "5.1"},
 CellID->8720],

Cell[TextData[{
 "There are four kinds of bracketing used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Each kind of bracketing has a very different meaning. It is important \
that you remember all of them. "
}], "Text",
 CellID->30144],

Cell[BoxData[GridBox[{
   {
    RowBox[{"(", 
     StyleBox["term", "TI"], ")"}], Cell[
    "parentheses for grouping", "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[
    "square brackets for functions", "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], "}"}], Cell[
    "curly braces for lists", "TableText"]},
   {
    RowBox[{
     StyleBox["v", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "double brackets for indexing (",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Part",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Part"], "[", 
       StyleBox["v", "TI"], ",", 
       StyleBox["i", "TI"], "]"}]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30388],

Cell[TextData[{
 "The four kinds of bracketing in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->14077],

Cell[TextData[{
 "When the expressions you type in are complicated, it is often a good idea \
to put extra space inside each set of brackets. This makes it somewhat easier \
for you to see matching pairs of brackets. ",
 Cell[BoxData[
  RowBox[{
   StyleBox["v", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}], "]"}], "]"}]], "InlineFormula"],
 " is, for example, easier to recognize than ",
 Cell[BoxData[
  RowBox[{
   StyleBox["v", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18213],

Cell[TextData[ButtonBox["Building Up Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BuildingUpCalculationsOverview"]], "RelatedTutorials",
 CellID->71949343]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Four Kinds of Bracketing in Mathematica - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Building Up Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/BuildingUpCalculationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ManipulatingElementsOfLists"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SequencesOfOperations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 33.8739680}", "context" -> "", 
    "keywords" -> {
     "]]", "[[", "braces", "brackets", "curly braces", "delimiters", 
      "parentheses"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "There are four kinds of bracketing used in Mathematica. Each kind of \
bracketing has a very different meaning. It is important that you remember \
all of them. The four kinds of bracketing in Mathematica. When the \
expressions you type in are complicated, it is often a good idea to put extra \
space inside each set of brackets. This makes it somewhat easier for you to \
see matching pairs of brackets. v[[{a,b}]] is, for example, easier to \
recognize than v[[{a,b}]]. ", "synonyms" -> {"1.2.5"}, "title" -> 
    "The Four Kinds of Bracketing in Mathematica", "type" -> "Tutorial", 
    "uri" -> "tutorial/TheFourKindsOfBracketingInMathematica"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.2.5"->{
  Cell[1796, 57, 158, 6, 70, "Title",
   CellTags->{"S1.2.5", "5.1"},
   CellID->8720]},
 "5.1"->{
  Cell[1796, 57, 158, 6, 70, "Title",
   CellTags->{"S1.2.5", "5.1"},
   CellID->8720]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.2.5", 7101, 213},
 {"5.1", 7200, 217}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1171, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1796, 57, 158, 6, 70, "Title",
 CellTags->{"S1.2.5", "5.1"},
 CellID->8720],
Cell[1957, 65, 249, 7, 70, "Text",
 CellID->30144],
Cell[2209, 74, 1187, 38, 70, "DefinitionBox",
 CellID->30388],
Cell[3399, 114, 138, 6, 70, "Caption",
 CellID->14077],
Cell[3540, 122, 715, 23, 70, "Text",
 CellID->18213],
Cell[4258, 147, 178, 4, 70, "RelatedTutorials",
 CellID->71949343]
}, Open  ]],
Cell[4451, 154, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

