(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48599,       1638]
NotebookOptionsPosition[     39694,       1368]
NotebookOutlinePosition[     43360,       1449]
CellTagsIndexPosition[     43266,       1443]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Aspects of Mathematica Sessions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Global Aspects of Mathematica Sessions\"\>", 
       2->"\<\"Mathematica Sessions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Stand-alone Mathematica Kernels" :> 
          Documentation`HelpLookup[
           "paclet:guide/StandaloneMathematicaKernels"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematica Sessions\"\>", 
       2->"\<\"Stand-alone Mathematica Kernels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exit" :> Documentation`HelpLookup["paclet:ref/Exit"], "In" :> 
          Documentation`HelpLookup["paclet:ref/In"], "InString" :> 
          Documentation`HelpLookup["paclet:ref/InString"], "Message" :> 
          Documentation`HelpLookup["paclet:ref/Message"], "MessageList" :> 
          Documentation`HelpLookup["paclet:ref/MessageList"], "Out" :> 
          Documentation`HelpLookup["paclet:ref/Out"], "Print" :> 
          Documentation`HelpLookup["paclet:ref/Print"], "Quit" :> 
          Documentation`HelpLookup["paclet:ref/Quit"], "Streams" :> 
          Documentation`HelpLookup["paclet:ref/Streams"], "$Echo" :> 
          Documentation`HelpLookup["paclet:ref/$Echo"], "$Epilog" :> 
          Documentation`HelpLookup["paclet:ref/$Epilog"], "$HistoryLength" :> 
          Documentation`HelpLookup["paclet:ref/$HistoryLength"], "$IgnoreEOF" :> 
          Documentation`HelpLookup["paclet:ref/$IgnoreEOF"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"], "$Language" :> 
          Documentation`HelpLookup["paclet:ref/$Language"], "$Line" :> 
          Documentation`HelpLookup["paclet:ref/$Line"], "$MessagePrePrint" :> 
          Documentation`HelpLookup["paclet:ref/$MessagePrePrint"], 
          "$Messages" :> Documentation`HelpLookup["paclet:ref/$Messages"], 
          "$Output" :> Documentation`HelpLookup["paclet:ref/$Output"], 
          "$Post" :> Documentation`HelpLookup["paclet:ref/$Post"], "$Pre" :> 
          Documentation`HelpLookup["paclet:ref/$Pre"], "$PrePrint" :> 
          Documentation`HelpLookup["paclet:ref/$PrePrint"], "$PreRead" :> 
          Documentation`HelpLookup["paclet:ref/$PreRead"], "$SyntaxHandler" :> 
          Documentation`HelpLookup["paclet:ref/$SyntaxHandler"], "$Urgent" :> 
          Documentation`HelpLookup["paclet:ref/$Urgent"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Exit\"\>", 2->"\<\"In\"\>", 
       3->"\<\"InString\"\>", 4->"\<\"Message\"\>", 5->"\<\"MessageList\"\>", 
       6->"\<\"Out\"\>", 7->"\<\"Print\"\>", 8->"\<\"Quit\"\>", 
       9->"\<\"Streams\"\>", 10->"\<\"$Echo\"\>", 11->"\<\"$Epilog\"\>", 
       12->"\<\"$HistoryLength\"\>", 13->"\<\"$IgnoreEOF\"\>", 
       14->"\<\"$Input\"\>", 15->"\<\"$Language\"\>", 16->"\<\"$Line\"\>", 
       17->"\<\"$MessagePrePrint\"\>", 18->"\<\"$Messages\"\>", 
       19->"\<\"$Output\"\>", 20->"\<\"$Post\"\>", 21->"\<\"$Pre\"\>", 
       22->"\<\"$PrePrint\"\>", 23->"\<\"$PreRead\"\>", 
       24->"\<\"$SyntaxHandler\"\>", 
       25->"\<\"$Urgent\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Main Loop", "Title",
 CellTags->{"S2.14.1", "1.1"},
 CellID->13888],

Cell[TextData[{
 "In any interactive session, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively operates in a loop. It waits for your input, processes the \
input, prints the result, then goes back to waiting for input again. As part \
of this \[OpenCurlyDoubleQuote]main loop\[CloseCurlyDoubleQuote], ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " maintains and uses various global objects. You will often find it useful \
to work with these objects. "
}], "Text",
 CellID->2823],

Cell[TextData[{
 "You should realize, however, that if you use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " through a special front end, your front end may set up its own main loop, \
and what is said here may not apply. "
}], "Text",
 CellID->11825],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["In",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/In"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the expression on the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " input line"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InString"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the textual form of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " input line"
    }], "TableText"]},
   {
    RowBox[{"%", 
     StyleBox["n", "TI"], Cell[" \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Out",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Out"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the expression on the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " output line"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Out",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Out"], "[", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "a list of output expressions", "TableText"]},
   {
    RowBox[{"%%", 
     StyleBox["\[Ellipsis]", "TR"], "%", Cell[TextData[{
      " (",
      Cell[BoxData[
       StyleBox["n", "TI"]], "InlineFormula"],
      " times) or "
     }], "TableText"], 
     ButtonBox["Out",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Out"], "[", "-", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the expression on the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " previous output line"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MessageList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MessageList"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "a list of messages produced while processing the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " line"
    }], "TableText"]},
   {
    ButtonBox["$Line",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Line"], Cell[
    "the current line number (resettable)", "TableText"]}
  }]], "DefinitionBox",
 CellID->9251],

Cell["Input and output expressions. ", "Caption",
 CellID->6190],

Cell[TextData[{
 "In a standard interactive session, there is a sequence of input and output \
lines. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stores the values of the expressions on these lines in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7639],

Cell[TextData[{
 "As indicated by the usual ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["In",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/In"], "[", 
    StyleBox["n", "TI"], "]"}], ":="}]], "InlineFormula"],
 " prompt, the input expressions are stored with delayed assignments. This \
means that whenever you ask for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ", the input expression will always be re\[Hyphen]evaluated in your current \
environment. "
}], "Text",
 CellID->32046],

Cell[TextData[{
 "This assigns a value to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "7"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->5775],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->17624]
}, Open  ]],

Cell[TextData[{
 "Now the value for ",
 Cell[BoxData["x"], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->14078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "-", 
  RowBox[{"x", "^", "2"}], "+", 
  RowBox[{"5", "x"}], "-", "1"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->4985],

Cell[BoxData[
 RowBox[{"-", "8"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->10103]
}, Open  ]],

Cell[TextData[{
 "This removes the value assigned to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26781],

Cell[BoxData[
 RowBox[{"x", "=."}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->377],

Cell[TextData[{
 "This is re\[Hyphen]evaluated in your current environment, where there is no \
value assigned to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"In", "[", "2", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->6048],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"6", " ", "x"}], "-", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->20170]
}, Open  ]],

Cell["\<\
This gives the textual form of the second input line, appropriate for editing \
or other textual manipulation. \
\>", "MathCaption",
 CellID->18494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InString", "[", "2", "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->20216],

Cell["\"x - x^2 + 5x - 1\"", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//InputForm= ",
 CellID->12729]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$HistoryLength",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$HistoryLength"], Cell[
    "the number of previous lines of input and output to keep", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29726],

Cell["Specifying the length of session history to keep. ", "Caption",
 CellID->16038],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default stores ",
 StyleBox["all",
  FontSlant->"Italic"],
 " your input and output lines for the duration of the session. In a very \
long session, this may take up a large amount of computer memory. You can \
nevertheless get rid of the input and output lines by explicitly clearing the \
values of ",
 Cell[BoxData[
  ButtonBox["In",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/In"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Out",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Out"]], "InlineFormula"],
 ", using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unprotect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unprotect"], "[", 
   RowBox[{
    ButtonBox["In",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/In"], ",", 
    ButtonBox["Out",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Out"]}], "]"}]], "InlineFormula"],
 ", followed by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"], "[", 
   RowBox[{
    ButtonBox["In",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/In"], ",", 
    ButtonBox["Out",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Out"]}], "]"}]], "InlineFormula"],
 ". You can also tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to keep only a limited number of lines of history by setting the global \
variable ",
 Cell[BoxData[
  ButtonBox["$HistoryLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$HistoryLength"]], "InlineFormula"],
 "."
}], "Text",
 CellID->29915],

Cell[TextData[{
 "Note that at any point in a session, you can reset the line number counter \
",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 ", so that for example new lines are numbered so as to overwrite previous \
ones. "
}], "Text",
 CellID->28672],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$PreRead",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PreRead"], Cell[TextData[{
     "a function applied to each input string before being fed to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {
    ButtonBox["$Pre",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Pre"], Cell["\<\
a function applied to each input expression before evaluation\
\>", "TableText"]},
   {
    ButtonBox["$Post",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Post"], Cell[
    "a function applied to each expression after evaluation", "TableText"]},
   {
    ButtonBox["$PrePrint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PrePrint"], Cell[TextData[{
     "a function applied after ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Out",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Out"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " is assigned, but before the result is printed"
    }], "TableText"]},
   {
    ButtonBox["$SyntaxHandler",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SyntaxHandler"], Cell["\<\
a function applied to any input line that yields a syntax error\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18352],

Cell["Global functions used in the main loop. ", "Caption",
 CellID->15862],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a variety of \[OpenCurlyDoubleQuote]hooks\[CloseCurlyDoubleQuote] \
that allow you to insert functions to be applied to expressions at various \
stages in the main loop. Thus, for example, any function you assign as the \
value of the global variable ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " will automatically be applied before evaluation to any expression you give \
as input. "
}], "Text",
 CellID->6421],

Cell[TextData[{
 "For a particular input line, the standard main loop begins by getting a \
text string of input. Particularly if you need to deal with special \
characters, you may want to modify this text string before it is further \
processed by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can do this by assigning a function as the value of the global \
variable ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 ". This function will be applied to the text string, and the result will be \
used as the actual input string for the particular input line. "
}], "Text",
 CellID->27667],

Cell[TextData[{
 "This tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to replace ",
 Cell[BoxData["listHead"], "InlineFormula"],
 " by ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["\[Ellipsis]", "TR"], "}"}]], "InlineFormula"],
 " in every input string. "
}], "MathCaption",
 CellID->11128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$PreRead", "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"ReplaceAll", "[", 
     RowBox[{"#", ",", 
      RowBox[{"\"\<listHead\>\"", "\[RuleDelayed]", "\"\<List\>\""}]}], "]"}],
     "&"}], ")"}]}]], "Input",
 CellLabel->"In[61]:=",
 CellID->21465],

Cell[BoxData[
 RowBox[{
  RowBox[{"#1", "/.", "\[InvisibleSpace]", 
   RowBox[{"\<\"listHead\"\>", "\[RuleDelayed]", "\<\"List\"\>"}]}], 
  "&"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[61]=",
 CellID->800570927]
}, Open  ]],

Cell[TextData[{
 "You can now enter lists as ",
 Cell[BoxData["listHead"], "InlineFormula"],
 " expressions."
}], "MathCaption",
 CellID->259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"listHead", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->24082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->1210521634]
}, Open  ]],

Cell[TextData[{
 "You can remove the value for ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " like this, at least so long as your definition for ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " does not modify this very input string. "
}], "MathCaption",
 CellID->24986],

Cell[BoxData[
 RowBox[{"$PreRead", "=."}]], "Input",
 CellLabel->"In[65]:=",
 CellID->606939199],

Cell[TextData[{
 "Once ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has successfully read an input expression, it then evaluates this \
expression. Before doing the evaluation, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applies any function you have specified as the value of ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 ", and after the evaluation, it applies any function specified as the value \
of ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 ". Note that unless the ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " function holds its arguments unevaluated, the function will have exactly \
the same effect as ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11896],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 " allows you to specify arbitrary \[OpenCurlyDoubleQuote]post processing\
\[CloseCurlyDoubleQuote] to be done on results obtained from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Thus, for example, to make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " get a numerical approximation to every result it generates, all you need \
do is to set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["$Post",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Post"], "=", 
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26141],

Cell[TextData[{
 "This tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to apply ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to every result it generates. "
}], "MathCaption",
 CellID->2150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$Post", "=", "N"}]], "Input",
 CellLabel->"In[69]:=",
 CellID->28432],

Cell[BoxData["N"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[69]=",
 CellID->1661819518]
}, Open  ]],

Cell[TextData[{
 "Now ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gets a numerical approximation to anything you type in. "
}], "MathCaption",
 CellID->32361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "7", "]"}]], "Input",
 CellLabel->"In[70]:=",
 CellID->4770],

Cell[BoxData["2.6457513110645907`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[70]=",
 CellID->28326144]
}, Open  ]],

Cell["\<\
This removes the post\[Hyphen]processing function you specified. \
\>", "MathCaption",
 CellID->27165],

Cell[BoxData[
 RowBox[{"$Post", "=."}]], "Input",
 CellLabel->"In[71]:=",
 CellID->25645],

Cell[TextData[{
 "As soon as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has generated a result, and applied any ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 " function you have specified, it takes the result, and assigns it as the \
value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   ButtonBox["$Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Line"], "]"}]], "InlineFormula"],
 ". The next step is for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to print the result. However, before doing this, it applies any function \
you have specified as the value of ",
 Cell[BoxData[
  ButtonBox["$PrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PrePrint"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->8120],

Cell[TextData[{
 "This tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to shorten all output to two lines. "
}], "MathCaption",
 CellID->1810],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", 
   RowBox[{
    RowBox[{"Short", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}]}], ";"}]], "Input",
 CellLabel->"In[77]:=",
 CellID->32128],

Cell["\<\
Only a two\[Hyphen]line version of the output is now shown. \
\>", "MathCaption",
 CellID->25970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "^", "40"}], "]"}]], "Input",
 CellLabel->"In[78]:=",
 CellID->6621],

Cell[BoxData[
 TagBox[
  RowBox[{
   SuperscriptBox["x", "40"], "+", 
   RowBox[{"40", " ", 
    SuperscriptBox["x", "39"], " ", "y"}], "+", 
   RowBox[{"780", " ", 
    SuperscriptBox["x", "38"], " ", 
    SuperscriptBox["y", "2"]}], "+", 
   RowBox[{"9880", " ", 
    SuperscriptBox["x", "37"], " ", 
    SuperscriptBox["y", "3"]}], "+", 
   RowBox[{"91390", " ", 
    SuperscriptBox["x", "36"], " ", 
    SuperscriptBox["y", "4"]}], "+", 
   RowBox[{"658008", " ", 
    SuperscriptBox["x", "35"], " ", 
    SuperscriptBox["y", "5"]}], "+", 
   RowBox[{"\[LeftSkeleton]", "30", "\[RightSkeleton]"}], "+", 
   RowBox[{"91390", " ", 
    SuperscriptBox["x", "4"], " ", 
    SuperscriptBox["y", "36"]}], "+", 
   RowBox[{"9880", " ", 
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox["y", "37"]}], "+", 
   RowBox[{"780", " ", 
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "38"]}], "+", 
   RowBox[{"40", " ", "x", " ", 
    SuperscriptBox["y", "39"]}], "+", 
   SuperscriptBox["y", "40"]}],
  Short[#, 2]& ]], "Output",
 ImageSize->{465, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[78]=",
 CellID->1483616221]
}, Open  ]],

Cell[TextData[{
 "This removes the value you assigned to ",
 Cell[BoxData[
  ButtonBox["$PrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PrePrint"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15004],

Cell[BoxData[
 RowBox[{"$PrePrint", "=."}]], "Input",
 CellLabel->"In[79]:=",
 CellID->8514],

Cell[TextData[{
 "There are various kinds of output generated in a typical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. In general, each kind of output is sent to a definite ",
 StyleBox["output channel",
  FontSlant->"Italic"],
 ", as discussed in\[NonBreakingSpace]\"",
 ButtonBox["Streams and Low-Level Input and Output",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"],
 "\". Associated with each output channel, there is a global variable which \
gives a list of the output streams to be included in that output channel. "
}], "Text",
 CellID->20799],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$Output",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Output"], Cell[TextData[{
     "standard output and text generated by ",
     Cell[BoxData[
      ButtonBox["Print",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Print"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["$Echo",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Echo"], Cell[TextData[{
     "an echo of each input line (as stored in ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["InString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InString"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    ButtonBox["$Urgent",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Urgent"], Cell[
    "input prompts and other urgent output", "TableText"]},
   {
    ButtonBox["$Messages",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Messages"], Cell[TextData[{
     "standard messages and output generated by ",
     Cell[BoxData[
      ButtonBox["Message",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Message"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23210],

Cell[TextData[{
 "Output channels in a standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Caption",
 CellID->25269],

Cell[TextData[{
 "By modifying the list of streams in a given output channel, you can \
redirect or copy particular kinds of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. Thus, for example, by opening an output stream to a file, and \
including that stream in the ",
 Cell[BoxData[
  ButtonBox["$Echo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Echo"]], "InlineFormula"],
 " list, you can get each piece of input you give to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " saved in a file. "
}], "Text",
 CellID->19552],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Streams",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Streams"], "[", "]"}], Cell[
    "list of all open streams", "TableText"]},
   {
    RowBox[{
     ButtonBox["Streams",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Streams"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "list of all open streams with the specified name", "TableText"]},
   {
    ButtonBox["$Input",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Input"], Cell[
    "the name of the current input stream", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32235],

Cell[TextData[{
 "Open streams in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Caption",
 CellID->471],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Streams",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Streams"]], "InlineFormula"],
 " shows you all the input, output and other streams that are open at a \
particular point in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. The variable ",
 Cell[BoxData[
  ButtonBox["$Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Input"]], "InlineFormula"],
 " gives the name of the current stream from which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input is being taken at a particular point. ",
 Cell[BoxData[
  ButtonBox["$Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Input"]], "InlineFormula"],
 " is reset, for example, during the execution of a ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " command. "
}], "Text",
 CellID->16344],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$MessagePrePrint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MessagePrePrint"], Cell["\<\
a function to be applied to expressions that are given in messages\
\>", "TableText"]},
   {
    ButtonBox["$Language",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Language"], Cell[
    "list of default languages to use for messages", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11830],

Cell["Parameters for messages. ", "Caption",
 CellID->6382],

Cell[TextData[{
 "There are various global parameters which determine the form of messages \
generated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->27261],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Messages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Messages"],
 "\", typical messages include a sequence of expressions which are combined \
with the text of the message through ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["$MessagePrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessagePrePrint"]], "InlineFormula"],
 " gives a function to be applied to the expressions before they are printed. \
The default for ",
 Cell[BoxData[
  ButtonBox["$MessagePrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessagePrePrint"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " for text formatting and a combination of ",
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " for typesetting. "
}], "Text",
 CellID->26395],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["International Messages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternationalMessages"],
 "\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to specify the language in which you want messages to be \
produced. In a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you can assign a list of language names as the value of ",
 Cell[BoxData[
  ButtonBox["$Language",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Language"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27151],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Exit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exit"], "[", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Quit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quit"], "[", "]"}], Cell[TextData[{
     "terminate your ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]},
   {
    ButtonBox["$Epilog",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Epilog"], Cell[
    "a global variable to be evaluated before termination", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20666],

Cell[TextData[{
 "Terminating ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions. "
}], "Caption",
 CellID->83],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will continue in its main loop until you explicitly tell it to exit. Most \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interfaces provide special ways to do this. Nevertheless, you can always \
do it by explicitly calling ",
 Cell[BoxData[
  ButtonBox["Exit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exit"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Quit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quit"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->28710],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to give a value to the global variable ",
 Cell[BoxData[
  ButtonBox["$Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Epilog"]], "InlineFormula"],
 " to specify operations to perform just before ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " actually exits. In this way, you can for example make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always save certain objects before exiting. "
}], "Text",
 CellID->26758],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$IgnoreEOF",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$IgnoreEOF"], Cell["\<\
whether to ignore the end\[Hyphen]of\[Hyphen]file character\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7372],

Cell["\<\
A global variable that determines the treatment of \
end\[Hyphen]of\[Hyphen]file characters. \
\>", "Caption",
 CellID->2295],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Special Characters: Strings and Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SpecialCharacters-StringsAndCharacters"],
 "\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " usually does not treat special characters in a special way. There is one \
potential exception, however. With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["$IgnoreEOF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$IgnoreEOF"], "=", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " recognizes end\[Hyphen]of\[Hyphen]file characters. If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " receives an end\[Hyphen]of\[Hyphen]file character as the only thing on a \
particular input line in a standard interactive ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, then it will exit the session. "
}], "Text",
 CellID->17906],

Cell["\<\
Exactly how you enter an end\[Hyphen]of\[Hyphen]file character depends on the \
computer system you are using. Under Unix, for example, you typically press \
Control\[Hyphen]D. \
\>", "Text",
 CellID->30014],

Cell[TextData[{
 "Note that if you use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a \[OpenCurlyDoubleQuote]batch mode\[CloseCurlyDoubleQuote], with all \
its input coming from a file, then it will automatically exit when it reaches \
the end of the file, regardless of the value of ",
 Cell[BoxData[
  ButtonBox["$IgnoreEOF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IgnoreEOF"]], "InlineFormula"],
 "."
}], "Text",
 CellID->13452],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->65110285],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"]
}], "TutorialMoreAbout",
 CellID->83059526],

Cell[TextData[{
 ButtonBox["Stand-alone ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
  FontSlant->"Italic"],
 ButtonBox[" Kernels",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"]
}], "TutorialMoreAbout",
 CellID->97664395]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->137204083],

Cell[TextData[{
 ButtonBox["Global Aspects of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]
}], "RelatedTutorials",
 CellID->1006056654],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "RelatedTutorials",
 CellID->522604605]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Main Loop - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Global Aspects of Mathematica Sessions", "OverviewNavText"],
         BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Dialogs"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 35.4208826}", "context" -> "", 
    "keywords" -> {
     "%%", "%", "batch mode", "channels", "character", "commands", "copying", 
      "counter", "EBCDIC", "end of file character", "EndOfFile", "errors", 
      "exit", "evaluation of expressions", "reading of expressions", "Get", 
      "global switches", "history", "hooks", "In label", "In object", "input",
       "InString", "journaling", "keyboard", "lines", "listener", "macros", 
      "main loop", "memory", "MessageList", "message list", "messages", 
      "line number", "open files", "Out label", "Out object", "output", 
      "output lines", "parsing", "Postprocessor", "Preprocessor", "prompts", 
      "Quit", "reader", "reading input", "record", "redirection", 
      "re-executing input lines", "re-evaluation", "reevaluation", 
      "replaying input", "sessions", "special characters", "streams", 
      "StringReplace", "syntax errors", "terminals", "Unix", "display", 
      "echo", "Epilog", "HistoryLength", "IgnoreEOF", "input", "language", 
      "MessagePrePrint", "messages", "output", "Post", "Pre", "PrePrint", 
      "PreRead", "SoundDisplay", "SyntaxHandler", "urgent"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "In any interactive session, Mathematica effectively operates in a loop. \
It waits for your input, processes the input, prints the result, then goes \
back to waiting for input again. As part of this 'main loop', Mathematica \
maintains and uses various global objects. You will often find it useful to \
work with these objects. You should realize, however, that if you use \
Mathematica through a special front end, your front end may set up its own \
main loop, and what is said here may not apply. Input and output expressions. \
", "synonyms" -> {"2.14.1", "%2", "%3"}, "title" -> "The Main Loop", "type" -> 
    "Tutorial", "uri" -> "tutorial/TheMainLoop"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.14.1"->{
  Cell[5149, 112, 77, 2, 70, "Title",
   CellTags->{"S2.14.1", "1.1"},
   CellID->13888]},
 "1.1"->{
  Cell[5149, 112, 77, 2, 70, "Title",
   CellTags->{"S2.14.1", "1.1"},
   CellID->13888]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.14.1", 43051, 1432},
 {"1.1", 43152, 1436}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 4524, 85, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5149, 112, 77, 2, 70, "Title",
 CellTags->{"S2.14.1", "1.1"},
 CellID->13888],
Cell[5229, 116, 505, 12, 70, "Text",
 CellID->2823],
Cell[5737, 130, 260, 7, 70, "Text",
 CellID->11825],
Cell[6000, 139, 2826, 95, 70, "DefinitionBox",
 CellID->9251],
Cell[8829, 236, 64, 1, 70, "Caption",
 CellID->6190],
Cell[8896, 239, 575, 21, 70, "Text",
 CellID->7639],
Cell[9474, 262, 620, 20, 70, "Text",
 CellID->32046],
Cell[10097, 284, 122, 5, 70, "MathCaption",
 CellID->3362],
Cell[CellGroupData[{
Cell[10244, 293, 88, 3, 28, "Input",
 CellID->5775],
Cell[10335, 298, 155, 5, 36, "Output",
 CellID->17624]
}, Open  ]],
Cell[10505, 306, 125, 5, 70, "MathCaption",
 CellID->14078],
Cell[CellGroupData[{
Cell[10655, 315, 149, 5, 70, "Input",
 CellID->4985],
Cell[10807, 322, 172, 6, 36, "Output",
 CellID->10103]
}, Open  ]],
Cell[10994, 331, 134, 5, 70, "MathCaption",
 CellID->26781],
Cell[11131, 338, 83, 3, 70, "Input",
 CellID->377],
Cell[11217, 343, 195, 6, 70, "MathCaption",
 CellID->26350],
Cell[CellGroupData[{
Cell[11437, 353, 94, 3, 70, "Input",
 CellID->6048],
Cell[11534, 358, 252, 9, 36, "Output",
 CellID->20170]
}, Open  ]],
Cell[11801, 370, 158, 4, 70, "MathCaption",
 CellID->18494],
Cell[CellGroupData[{
Cell[11984, 378, 133, 4, 70, "Input",
 CellID->20216],
Cell[12120, 384, 177, 5, 50, "Output",
 CellID->12729]
}, Open  ]],
Cell[12312, 392, 533, 14, 70, "DefinitionBox",
 CellID->29726],
Cell[12848, 408, 85, 1, 70, "Caption",
 CellID->16038],
Cell[12936, 411, 1607, 56, 70, "Text",
 CellID->29915],
Cell[14546, 469, 323, 10, 70, "Text",
 CellID->28672],
Cell[14872, 481, 1600, 48, 70, "DefinitionBox",
 CellID->18352],
Cell[16475, 531, 75, 1, 70, "Caption",
 CellID->15862],
Cell[16553, 534, 560, 14, 70, "Text",
 CellID->6421],
Cell[17116, 550, 677, 16, 70, "Text",
 CellID->27667],
Cell[17796, 568, 305, 12, 70, "MathCaption",
 CellID->11128],
Cell[CellGroupData[{
Cell[18126, 584, 274, 9, 70, "Input",
 CellID->21465],
Cell[18403, 595, 289, 9, 36, "Output",
 CellID->800570927]
}, Open  ]],
Cell[18707, 607, 142, 5, 70, "MathCaption",
 CellID->259],
Cell[CellGroupData[{
Cell[18874, 616, 134, 4, 70, "Input",
 CellID->24082],
Cell[19011, 622, 215, 7, 36, "Output",
 CellID->1210521634]
}, Open  ]],
Cell[19241, 632, 424, 13, 70, "MathCaption",
 CellID->24986],
Cell[19668, 647, 96, 3, 70, "Input",
 CellID->606939199],
Cell[19767, 652, 995, 32, 70, "Text",
 CellID->11896],
Cell[20765, 686, 736, 24, 70, "Text",
 CellID->26141],
Cell[21504, 712, 269, 11, 70, "MathCaption",
 CellID->2150],
Cell[CellGroupData[{
Cell[21798, 727, 93, 3, 70, "Input",
 CellID->28432],
Cell[21894, 732, 160, 5, 36, "Output",
 CellID->1661819518]
}, Open  ]],
Cell[22069, 740, 169, 6, 70, "MathCaption",
 CellID->32361],
Cell[CellGroupData[{
Cell[22263, 750, 96, 3, 70, "Input",
 CellID->4770],
Cell[22362, 755, 176, 5, 36, "Output",
 CellID->28326144]
}, Open  ]],
Cell[22553, 763, 112, 3, 70, "MathCaption",
 CellID->27165],
Cell[22668, 768, 89, 3, 70, "Input",
 CellID->25645],
Cell[22760, 773, 893, 30, 70, "Text",
 CellID->8120],
Cell[23656, 805, 155, 6, 70, "MathCaption",
 CellID->1810],
Cell[23814, 813, 194, 7, 70, "Input",
 CellID->32128],
Cell[24011, 822, 107, 3, 70, "MathCaption",
 CellID->25970],
Cell[CellGroupData[{
Cell[24143, 829, 171, 6, 70, "Input",
 CellID->6621],
Cell[24317, 837, 1173, 36, 54, "Output",
 CellID->1483616221]
}, Open  ]],
Cell[25505, 876, 221, 8, 70, "MathCaption",
 CellID->15004],
Cell[25729, 886, 92, 3, 70, "Input",
 CellID->8514],
Cell[25824, 891, 613, 14, 70, "Text",
 CellID->20799],
Cell[26440, 907, 1551, 48, 70, "DefinitionBox",
 CellID->23210],
Cell[27994, 957, 144, 6, 70, "Caption",
 CellID->25269],
Cell[28141, 965, 551, 16, 70, "Text",
 CellID->19552],
Cell[28695, 983, 934, 27, 70, "DefinitionBox",
 CellID->32235],
Cell[29632, 1012, 130, 6, 70, "Caption",
 CellID->471],
Cell[29765, 1020, 915, 30, 70, "Text",
 CellID->16344],
Cell[30683, 1052, 717, 20, 70, "DefinitionBox",
 CellID->11830],
Cell[31403, 1074, 59, 1, 70, "Caption",
 CellID->6382],
Cell[31465, 1077, 191, 7, 70, "Text",
 CellID->27261],
Cell[31659, 1086, 1203, 39, 70, "Text",
 CellID->26395],
Cell[32865, 1127, 587, 19, 70, "Text",
 CellID->27151],
Cell[33455, 1148, 916, 28, 70, "DefinitionBox",
 CellID->20666],
Cell[34374, 1178, 124, 6, 70, "Caption",
 CellID->83],
Cell[34501, 1186, 569, 20, 70, "Text",
 CellID->28710],
Cell[35073, 1208, 523, 16, 70, "Text",
 CellID->26758],
Cell[35599, 1226, 530, 15, 70, "DefinitionBox",
 CellID->7372],
Cell[36132, 1243, 135, 4, 70, "Caption",
 CellID->2295],
Cell[36270, 1249, 1026, 30, 70, "Text",
 CellID->17906],
Cell[37299, 1281, 217, 5, 70, "Text",
 CellID->30014],
Cell[37519, 1288, 455, 13, 70, "Text",
 CellID->13452],
Cell[CellGroupData[{
Cell[37999, 1305, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->65110285],
Cell[38067, 1308, 285, 9, 70, "TutorialMoreAbout",
 CellID->83059526],
Cell[38355, 1319, 410, 12, 70, "TutorialMoreAbout",
 CellID->97664395]
}, Open  ]],
Cell[CellGroupData[{
Cell[38802, 1336, 72, 1, 70, "RelatedTutorialsSection",
 CellID->137204083],
Cell[38877, 1339, 469, 12, 70, "RelatedTutorials",
 CellID->1006056654],
Cell[39349, 1353, 291, 9, 70, "RelatedTutorials",
 CellID->522604605]
}, Open  ]]
}, Open  ]],
Cell[39667, 1366, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

