(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16425,        589]
NotebookOptionsPosition[     11837,        446]
NotebookOutlinePosition[     14437,        514]
CellTagsIndexPosition[     14346,        508]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Series, Limits and Residues" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>", 
      
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Representation of Power Series", "Title",
 CellTags->{"S3.6.2", "2.1"},
 CellID->8901],

Cell[TextData[{
 "Power series are represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects."
}], "Text",
 CellID->17653],

Cell[TextData[{
 "The power series is printed out as a sum of terms, ending with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["O",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/O"], "[", "x", "]"}]], "InlineFormula"],
 " raised to a power. "
}], "MathCaption",
 CellID->14520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30503],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 0, 
    Rational[1, 24]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{118, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->918315660]
}, Open  ]],

Cell[TextData[{
 "Internally, however, the series is stored as a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->20],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1932],

Cell["SeriesData[x, 0, {1, 0, -1/2, 0, 1/24}, 0, 5, 1]", "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->166326631]
}, Open  ]],

Cell[TextData[{
 "By using ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects, rather than ordinary expressions, to represent power series, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can keep track of the order and expansion point, and do operations on the \
power series appropriately. You should not normally need to know the internal \
structure of ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects. "
}], "Text",
 CellID->10824],

Cell[TextData[{
 "You can recognize a power series that is printed out in standard output \
form by the presence of an ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["O",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/O"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " term. This term mimics the standard mathematical notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ", and represents omitted terms of order ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". For various reasons of consistency, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the notation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["O",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/O"], "[", 
    StyleBox["x", "TI"], "]"}], "^", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " for omitted terms of order ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "n"], TraditionalForm]], "InlineMath"],
 ", corresponding to the mathematical notation ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"O", "(", "x", ")"}], "n"], TraditionalForm]], "InlineMath"],
 ", rather than the slightly more familiar, though equivalent, form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"O", "(", 
    SuperscriptBox["x", "n"], ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->5033],

Cell[TextData[{
 "Any time that an object like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["O",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/O"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " appears in a sum of terms, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will in fact convert the whole sum into a power series. "
}], "Text",
 CellID->30057],

Cell[TextData[{
 "The presence of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["O",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/O"], "[", "x", "]"}]], "InlineFormula"],
 " makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " convert the whole sum to a power series. "
}], "MathCaption",
 CellID->15665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "+", 
  RowBox[{"Exp", "[", "x", "]"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "3"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2732],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], " ", "x"}], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1 + $CellContext`a, 
    Rational[1, 2]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{150, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1575462470]
}, Open  ]],

Cell["Series objects can involve fractional powers.", "MathCaption",
 CellID->47870725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", 
     RowBox[{"x", "^", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->258006153],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["3"], " ", 
    SqrtBox[
     RowBox[{"x", "-", "1"}]]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
    SqrtBox["3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], "+", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"5", "/", "2"}]]}], 
    RowBox[{"8", " ", 
     SqrtBox["3"]}]], "+", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], 
       RowBox[{"7", "/", "2"}]]}], 
     RowBox[{"16", " ", 
      SqrtBox["3"]}]]}], "+", 
   FractionBox[
    RowBox[{"11", " ", "\[ImaginaryI]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"9", "/", "2"}]]}], 
    RowBox[{"384", " ", 
     SqrtBox["3"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], 
     RowBox[{"11", "/", "2"}]],
    SeriesData[$CellContext`x, 1, {}, 1, 11, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
   Complex[0, 1] 3^Rational[1, 2], 0, Complex[0, 
      Rational[1, 2]] 3^Rational[1, 2], 0, Complex[0, 
      Rational[1, 8]] 3^Rational[-1, 2], 0, Complex[0, 
      Rational[-1, 16]] 3^Rational[-1, 2], 0, Complex[0, 
      Rational[11, 384]] 3^Rational[-1, 2]}, 1, 11, 2],
  Editable->False]], "Output",
 ImageSize->{564, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->324365780]
}, Open  ]],

Cell["Here is the series' internal representation.", "MathCaption",
 CellID->207198977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1302168374],

Cell["\<\
SeriesData[x, 1, {I*Sqrt[3], 0, (I/2)*Sqrt[3], 0, (I/8)/Sqrt[3], 0, \
(-I/16)/Sqrt[3], 0, ((11*I)/384)/Sqrt[3]}, 1, 11, 
 2]\
\>", "Output",
 ImageSize->{826, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//InputForm=",
 CellID->538015241]
}, Open  ]],

Cell["Series can involve logarithmic terms.", "MathCaption",
 CellID->695345499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"x", "^", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->575315439],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "3"], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "4"], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Log[$CellContext`x], Rational[1, 2] Log[$CellContext`x]^2, Rational[1, 6] 
    Log[$CellContext`x]^3, Rational[1, 24] Log[$CellContext`x]^4}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{398, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1516001617]
}, Open  ]],

Cell["\<\
The logarithmic factors appear explicitly inside the SeriesData coefficient \
list.\
\>", "MathCaption",
 CellID->121176342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "InputForm"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->364928823],

Cell["\<\
SeriesData[x, 0, {1, Log[x], Log[x]^2/2, Log[x]^3/6, Log[x]^4/24}, 0, 5, 1]\
\>", "Output",
 ImageSize->{525, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//InputForm=",
 CellID->1693188911]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->686890197],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Representation of Power Series - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MakingPowerSeriesExpansions"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OperationsOnPowerSeries"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 39.9209978}", "context" -> "", 
    "keywords" -> {"O", "power series", "SeriesData"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Power series are represented in Mathematica as SeriesData objects. The \
power series is printed out as a sum of terms, ending with O[x] raised to a \
power. Internally, however, the series is stored as a SeriesData object. ", 
    "synonyms" -> {"3.6.2"}, "title" -> "The Representation of Power Series", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/TheRepresentationOfPowerSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.2"->{
  Cell[1285, 44, 96, 2, 70, "Title",
   CellTags->{"S3.6.2", "2.1"},
   CellID->8901]},
 "2.1"->{
  Cell[1285, 44, 96, 2, 70, "Title",
   CellTags->{"S3.6.2", "2.1"},
   CellID->8901]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.2", 14137, 497},
 {"2.1", 14235, 501}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 660, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1285, 44, 96, 2, 70, "Title",
 CellTags->{"S3.6.2", "2.1"},
 CellID->8901],
Cell[1384, 48, 274, 11, 70, "Text",
 CellID->17653],
Cell[1661, 61, 278, 9, 70, "MathCaption",
 CellID->14520],
Cell[CellGroupData[{
Cell[1964, 74, 211, 7, 28, "Input",
 CellID->30503],
Cell[2178, 83, 585, 20, 54, "Output",
 CellID->918315660]
}, Open  ]],
Cell[2778, 106, 235, 8, 70, "MathCaption",
 CellID->20],
Cell[CellGroupData[{
Cell[3038, 118, 100, 3, 28, "Input",
 CellID->1932],
Cell[3141, 123, 208, 5, 50, "Output",
 CellID->166326631]
}, Open  ]],
Cell[3364, 131, 617, 18, 70, "Text",
 CellID->10824],
Cell[3984, 151, 1376, 44, 70, "Text",
 CellID->5033],
Cell[5363, 197, 376, 13, 70, "Text",
 CellID->30057],
Cell[5742, 212, 314, 12, 70, "MathCaption",
 CellID->15665],
Cell[CellGroupData[{
Cell[6081, 228, 202, 7, 70, "Input",
 CellID->2732],
Cell[6286, 237, 603, 20, 54, "Output",
 CellID->1575462470]
}, Open  ]],
Cell[6904, 260, 87, 1, 70, "MathCaption",
 CellID->47870725],
Cell[CellGroupData[{
Cell[7016, 265, 267, 9, 70, "Input",
 CellID->258006153],
Cell[7286, 276, 1738, 57, 58, "Output",
 CellID->324365780]
}, Open  ]],
Cell[9039, 336, 87, 1, 70, "MathCaption",
 CellID->207198977],
Cell[CellGroupData[{
Cell[9151, 341, 102, 3, 70, "Input",
 CellID->1302168374],
Cell[9256, 346, 292, 9, 66, "Output",
 CellID->538015241]
}, Open  ]],
Cell[9563, 358, 80, 1, 70, "MathCaption",
 CellID->695345499],
Cell[CellGroupData[{
Cell[9668, 363, 208, 7, 70, "Input",
 CellID->575315439],
Cell[9879, 372, 1088, 33, 51, "Output",
 CellID->1516001617]
}, Open  ]],
Cell[10982, 408, 134, 4, 70, "MathCaption",
 CellID->121176342],
Cell[CellGroupData[{
Cell[11141, 416, 101, 3, 70, "Input",
 CellID->364928823],
Cell[11245, 421, 244, 7, 50, "Output",
 CellID->1693188911]
}, Open  ]],
Cell[CellGroupData[{
Cell[11526, 433, 72, 1, 70, "RelatedTutorialsSection",
 CellID->686890197],
Cell[11601, 436, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[11810, 444, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

