(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38096,       1370]
NotebookOptionsPosition[     29555,       1096]
NotebookOutlinePosition[     32907,       1175]
CellTagsIndexPosition[     32814,       1169]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plus" :> Documentation`HelpLookup["paclet:ref/Plus"], "Power" :> 
          Documentation`HelpLookup["paclet:ref/Power"], "Times" :> 
          Documentation`HelpLookup["paclet:ref/Times"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Plus\"\>", 2->"\<\"Power\"\>", 
       3->"\<\"Times\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Standard Evaluation Procedure", "Title",
 CellTags->{"S2.6.4", "4.1"},
 CellID->18938],

Cell[TextData[{
 "Here we describe the standard procedure used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to evaluate expressions. This procedure is the one followed for most kinds \
of expressions. There are however some kinds of expressions, such as those \
used to represent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs and control structures, which are evaluated in a \
non\[Hyphen]standard way."
}], "Text",
 CellID->27445],

Cell[TextData[{
 "In the standard evaluation procedure, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " first evaluates the head of an expression, and then evaluates each element \
of the expressions. These elements are in general themselves expressions, to \
which the same evaluation procedure is recursively applied. "
}], "Text",
 CellID->21228],

Cell[TextData[{
 "The three ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " functions are evaluated in turn, each printing its argument, then \
returning the value ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Print", "[", "1", "]"}], ",", 
   RowBox[{"Print", "[", "2", "]"}], ",", 
   RowBox[{"Print", "[", "3", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->14526],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellID->2178],

Cell[BoxData["2"], "Print",
 CellID->15745],

Cell[BoxData["3"], "Print",
 CellID->6928]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", "Null", ",", "Null"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->4205]
}, Open  ]],

Cell[TextData[{
 "This assigns the symbol ",
 Cell[BoxData["ps"], "InlineFormula"],
 " to be ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", "=", "Plus"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->15257],

Cell[BoxData["Plus"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->5312]
}, Open  ]],

Cell[TextData[{
 "The head ",
 Cell[BoxData["ps"], "InlineFormula"],
 " is evaluated first, so this expression behaves just like a sum of terms. "
}], "MathCaption",
 CellID->9401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", "[", 
  RowBox[{
   RowBox[{"ps", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->25199],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->24727]
}, Open  ]],

Cell[TextData[{
 "As soon as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has evaluated the head of an expression, it sees whether the head is a \
symbol that has attributes. If the symbol has the attributes ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ", then immediately after evaluating the elements of the expression ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " performs the transformations associated with these attributes. "
}], "Text",
 CellID->32692],

Cell[TextData[{
 "The next step in the standard evaluation procedure is to use definitions \
that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows for the expression it is evaluating. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " first tries to use definitions that you have made, and if there are none \
that apply, it tries built\[Hyphen]in definitions. "
}], "Text",
 CellID->22353],

Cell[TextData[{
 "If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " finds a definition that applies, it performs the corresponding \
transformation on the expression. The result is another expression, which \
must then in turn be evaluated according to the standard evaluation \
procedure. "
}], "Text",
 CellID->27795],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Evaluate the head of the expression.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Evaluate each element in turn.\
\>", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Apply transformations associated with the \
attributes ",
     Cell[BoxData[
      ButtonBox["Orderless",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Listable",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Flat",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
     "."
    }], "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Apply any definitions that you have given.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Apply any built\[Hyphen]in definitions.\
\>", "TableText"]},
   {Cell["\[FilledSmallSquare] Evaluate the result.", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26542],

Cell["The standard evaluation procedure. ", "Caption",
 CellID->22567],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Principles of Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PrinciplesOfEvaluation"],
 "\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows the principle that each expression is evaluated until no further \
definitions apply. This means that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " must continue re\[Hyphen]evaluating results until it gets an expression \
which remains unchanged through the evaluation procedure. "
}], "Text",
 CellID->27149],

Cell[TextData[{
 "Here is an example that shows how the standard evaluation procedure works \
on a simple expression. We assume that ",
 Cell[BoxData[
  RowBox[{"a", "=", "7"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->12376],

Cell[BoxData[GridBox[{
   {
    RowBox[{"2", "a", "x", "+", "a", "^", "2", "+", "1"}], Cell[
    "here is the original expression", "TableText"]},
   {
    RowBox[{
     ButtonBox["Plus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plus"], "[", 
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", "2", ",", "a", ",", "x", "]", ",",
      
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", "a", ",", "2", "]", ",", "1", 
     "]"}], "\[SpanFromLeft]"},
   {"", Cell["this is the internal form", "TableText"]},
   {
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", "2", ",", "a", ",", "x", "]"}], 
    Cell["this is evaluated first", "TableText"]},
   {
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", "2", ",", "7", ",", "x", "]"}], 
    Cell["a is evaluated to give 7", "TableText"]},
   {
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", "14", ",", "x", "]"}], Cell[
    TextData[{
     "built\[Hyphen]in definitions for ",
     Cell[BoxData[
      ButtonBox["Times",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Times"]], "InlineFormula"],
     " give this result"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", "a", ",", "2", "]"}], Cell[
    "this is evaluated next", "TableText"]},
   {
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", "7", ",", "2", "]"}], Cell[
    TextData[{
     "here is the result after evaluating ",
     Cell[BoxData["a"], "InlineFormula"]
    }], "TableText"]},
   {"49", Cell[TextData[{
     "built\[Hyphen]in definitions for ",
     Cell[BoxData[
      ButtonBox["Power",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Power"]], "InlineFormula"],
     " give this result"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Plus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plus"], "[", 
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", "14", ",", "x", "]", ",", "49", 
     ",", "1", "]"}], Cell[TextData[{
     "here is the result after the arguments of ",
     Cell[BoxData[
      ButtonBox["Plus",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
     " have been evaluated"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Plus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plus"], "[", "50", ",", 
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", "14", ",", "x", "]", "]"}], Cell[
    TextData[{
     "built\[Hyphen]in definitions for ",
     Cell[BoxData[
      ButtonBox["Plus",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
     " give this result"
    }], "TableText"]},
   {
    RowBox[{"50", "+", "14", "x"}], Cell[
    "the result is printed like this", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, True, False, False, True, False, False, True, 
     False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14255],

Cell[TextData[{
 "A simple example of evaluation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->26742],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides various ways to \[OpenCurlyDoubleQuote]trace\
\[CloseCurlyDoubleQuote] the evaluation process, as discussed in \"",
 ButtonBox["Tracing Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TracingEvaluation"],
 "\". The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives a nested list showing each subexpression generated during \
evaluation. (Note that the standard evaluation traverses the expression tree \
in a depth\[Hyphen]first way, so that the smallest subparts of the expression \
appear first in the results of ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ".) "
}], "Text",
 CellID->16748],

Cell[TextData[{
 "First set ",
 Cell[BoxData["a"], "InlineFormula"],
 " to ",
 Cell[BoxData["7"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", "7"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->22815],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->14047]
}, Open  ]],

Cell["\<\
This gives a nested list of all the subexpressions generated during the \
evaluation of the expression. \
\>", "MathCaption",
 CellID->11073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"2", " ", "a", " ", "x"}], "+", 
   RowBox[{"a", "^", "2"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->28965],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox["a",
        HoldForm], ",", 
       TagBox["7",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"2", " ", "7", " ", "x"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"14", " ", "x"}],
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox["a",
        HoldForm], ",", 
       TagBox["7",
        HoldForm]}], "}"}], ",", 
     TagBox[
      SuperscriptBox["7", "2"],
      HoldForm], ",", 
     TagBox["49",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{
     RowBox[{"14", " ", "x"}], "+", "49", "+", "1"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"50", "+", 
     RowBox[{"14", " ", "x"}]}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{410, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->4749]
}, Open  ]],

Cell[TextData[{
 "The order in which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applies different kinds of definitions is important. The fact that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applies definitions you have given before it applies built\[Hyphen]in \
definitions means that you can give definitions which override the built\
\[Hyphen]in ones, as discussed in \"",
 ButtonBox["Modifying Built-in Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ModifyingBuiltInFunctions"],
 "\". "
}], "Text",
 CellID->137],

Cell[TextData[{
 "This expression is evaluated using the built\[Hyphen]in definition for ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", "1", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->14331],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->7970]
}, Open  ]],

Cell[TextData[{
 "You can give your own definitions for ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 ". You need to remove the protection attribute first. "
}], "MathCaption",
 CellID->26053],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "ArcSin", "]"}], ";", 
  RowBox[{
   RowBox[{"ArcSin", "[", "1", "]"}], "=", 
   RowBox[{"5", 
    RowBox[{"Pi", "/", "2"}]}]}], ";"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->8768],

Cell["Your definition is used before the one that is built in. ", \
"MathCaption",
 CellID->28052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", "1", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->13178],

Cell[BoxData[
 FractionBox[
  RowBox[{"5", " ", "\[Pi]"}], "2"]], "Output",
 ImageSize->{27, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->11156]
}, Open  ]],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Associating Definitions with Different Symbols",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"],
 "\", you can associate definitions with symbols either as upvalues or \
downvalues. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always tries upvalue definitions before downvalue ones. "
}], "Text",
 CellID->24981],

Cell[TextData[{
 "If you have an expression like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["g", "TI"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 ", there are in general two sets of definitions that could apply: downvalues \
associated with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", and upvalues associated with ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries the definitions associated with ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " before those associated with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->12695],

Cell[TextData[{
 "This ordering follows the general strategy of trying specific definitions \
before more general ones. By applying upvalues associated with arguments \
before applying downvalues associated with a function, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to make definitions for special arguments which override the \
general definitions for the function with any arguments. "
}], "Text",
 CellID->17586],

Cell[TextData[{
 "This defines a rule for ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}]], "InlineFormula"],
 ", to be associated with ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13929],

Cell[BoxData[
 RowBox[{"f", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"frule", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->731],

Cell[TextData[{
 "This defines a rule for ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}]], "InlineFormula"],
 ", to be associated with ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4278],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"grule", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->17859],

Cell[TextData[{
 "The rule associated with ",
 Cell[BoxData["g"], "InlineFormula"],
 " is tried before the rule associated with ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->5089],

Cell[BoxData[
 RowBox[{"grule", "[", "2", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->31958]
}, Open  ]],

Cell[TextData[{
 "If you remove rules associated with ",
 Cell[BoxData["g"], "InlineFormula"],
 ", the rule associated with ",
 Cell[BoxData["f"], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->20238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "g", "]"}], ";", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->7054],

Cell[BoxData[
 RowBox[{"frule", "[", "1", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->27972]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] Definitions associated with ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " are applied before definitions associated with ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in the expression ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["g", "TI"], "[", 
       StyleBox["x", "TI"], "]", "]"}]], "InlineFormula"],
     "."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4208],

Cell["The order in which definitions are applied. ", "Caption",
 CellID->25656],

Cell[TextData[{
 "Most functions such as ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " have downvalues. There are, however, some objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " which have built\[Hyphen]in upvalues. For example, ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects, which represent power series, have built\[Hyphen]in upvalues with \
respect to various mathematical operations. "
}], "Text",
 CellID->24171],

Cell[TextData[{
 "For an expression like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["g", "TI"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 ", the complete sequence of definitions that are tried in the standard \
evaluation procedure is: "
}], "Text",
 CellID->18147],

Cell[TextData[{
 "Definitions you have given associated with ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 "; "
}], "Notes",
 CellID->8503],

Cell[TextData[{
 "Built\[Hyphen]in definitions associated with ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ";"
}], "Notes",
 CellID->354929591],

Cell[TextData[{
 "Definitions you have given associated with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ";"
}], "Notes",
 CellID->46832390],

Cell[TextData[{
 "Built\[Hyphen]in definitions associated with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->207415005],

Cell["\<\
The fact that upvalues are used before downvalues is important in many \
situations. In a typical case, you might want to define an operation such as \
composition. If you give upvalues for various objects with respect to \
composition, these upvalues will be used whenever such objects appear. \
However, you can also give a general procedure for composition, to be used if \
no special objects are present. You can give this procedure as a downvalue \
for composition. Since downvalues are tried after upvalues, the general \
procedure will be used only if no objects with upvalues are present. \
\>", "Text",
 CellID->19511],

Cell[TextData[{
 "Here is a definition associated with ",
 Cell[BoxData["q"], "InlineFormula"],
 " for composition of \[OpenCurlyDoubleQuote]",
 Cell[BoxData["q"], "InlineFormula"],
 " objects\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->32174],

Cell[BoxData[
 RowBox[{"q", "/:", 
  RowBox[{"comp", "[", 
   RowBox[{
    RowBox[{"q", "[", "x_", "]"}], ",", 
    RowBox[{"q", "[", "y_", "]"}]}], "]"}], ":=", 
  RowBox[{"qcomp", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->28819],

Cell[TextData[{
 "Here is a general rule for composition, associated with ",
 Cell[BoxData["comp"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26107],

Cell[BoxData[
 RowBox[{
  RowBox[{"comp", "[", 
   RowBox[{
    RowBox[{"f_", "[", "x_", "]"}], ",", 
    RowBox[{"f_", "[", "y_", "]"}]}], "]"}], ":=", 
  RowBox[{"gencomp", "[", 
   RowBox[{"f", ",", "x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->12205],

Cell[TextData[{
 "If you compose two ",
 Cell[BoxData["q"], "InlineFormula"],
 " objects, the rule associated with ",
 Cell[BoxData["q"], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->22599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"comp", "[", 
  RowBox[{
   RowBox[{"q", "[", "1", "]"}], ",", 
   RowBox[{"q", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->788],

Cell[BoxData[
 RowBox[{"qcomp", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->13261]
}, Open  ]],

Cell[TextData[{
 "If you compose ",
 Cell[BoxData["r"], "InlineFormula"],
 " objects, the general rule associated with ",
 Cell[BoxData["comp"], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->29045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"comp", "[", 
  RowBox[{
   RowBox[{"r", "[", "1", "]"}], ",", 
   RowBox[{"r", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->24435],

Cell[BoxData[
 RowBox[{"gencomp", "[", 
  RowBox[{"r", ",", "1", ",", "2"}], "]"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->7492]
}, Open  ]],

Cell[TextData[{
 "In general, there can be several objects that have upvalues in a particular \
expression. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " first looks at the head of the expression, and tries any upvalues \
associated with it. Then it successively looks at each element of the \
expression, trying any upvalues that exist. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " performs this procedure first for upvalues that you have explicitly \
defined, and then for upvalues that are built in. The procedure means that in \
a sequence of elements, upvalues associated with earlier elements take \
precedence over those associated with later elements. "
}], "Text",
 CellID->5732],

Cell[TextData[{
 "This defines an upvalue for ",
 Cell[BoxData["p"], "InlineFormula"],
 " with respect to ",
 Cell[BoxData["c"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30076],

Cell[BoxData[
 RowBox[{"p", "/:", 
  RowBox[{"c", "[", 
   RowBox[{"l___", ",", 
    RowBox[{"p", "[", "x_", "]"}], ",", "r___"}], "]"}], ":=", 
  RowBox[{"cp", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "r"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->4667],

Cell[TextData[{
 "This defines an upvalue for ",
 Cell[BoxData["q"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->403],

Cell[BoxData[
 RowBox[{"q", "/:", 
  RowBox[{"c", "[", 
   RowBox[{"l___", ",", 
    RowBox[{"q", "[", "x_", "]"}], ",", "r___"}], "]"}], ":=", 
  RowBox[{"cq", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "r"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->18367],

Cell[TextData[{
 "Which upvalue is used depends on which occurs first in the sequence of \
arguments to ",
 Cell[BoxData["c"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c", "[", 
    RowBox[{
     RowBox[{"p", "[", "1", "]"}], ",", 
     RowBox[{"q", "[", "2", "]"}]}], "]"}], ",", 
   RowBox[{"c", "[", 
    RowBox[{
     RowBox[{"q", "[", "1", "]"}], ",", 
     RowBox[{"p", "[", "2", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->21054],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"cp", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"q", "[", "2", "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"cq", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"p", "[", "2", "]"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->10167]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->234306403],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Standard Evaluation Procedure - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Attributes"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NonStandardEvaluation"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 46.4211642}", "context" -> "", 
    "keywords" -> {
     "arguments", "builtin rules", "built-in rules", "built-in functions", 
      "composition", "definitions", "DownValues", "down values", "evaluation",
       "evaluation order", "evaluation sequence", "flat", "functions", 
      "heads", "Listable", "orderless", "overriding built-in definitions", 
      "trace", "UpValues"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Here we describe the standard procedure used by Mathematica to evaluate \
expressions. This procedure is the one followed for most kinds of \
expressions. There are however some kinds of expressions, such as those used \
to represent Mathematica programs and control structures, which are evaluated \
in a non-standard way. In the standard evaluation procedure, Mathematica \
first evaluates the head of an expression, and then evaluates each element of \
the expressions. These elements are in general themselves expressions, to \
which the same evaluation procedure is recursively applied. The three Print \
functions are evaluated in turn, each printing its argument, then returning \
the value Null. ", "synonyms" -> {"2.6.4"}, "title" -> 
    "The Standard Evaluation Procedure", "type" -> "Tutorial", "uri" -> 
    "tutorial/TheStandardEvaluationProcedure"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.4"->{
  Cell[1983, 60, 96, 2, 70, "Title",
   CellTags->{"S2.6.4", "4.1"},
   CellID->18938]},
 "4.1"->{
  Cell[1983, 60, 96, 2, 70, "Title",
   CellTags->{"S2.6.4", "4.1"},
   CellID->18938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.4", 32603, 1158},
 {"4.1", 32702, 1162}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1358, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1983, 60, 96, 2, 70, "Title",
 CellTags->{"S2.6.4", "4.1"},
 CellID->18938],
Cell[2082, 64, 462, 12, 70, "Text",
 CellID->27445],
Cell[2547, 78, 356, 8, 70, "Text",
 CellID->21228],
Cell[2906, 88, 388, 14, 70, "MathCaption",
 CellID->8194],
Cell[CellGroupData[{
Cell[3319, 106, 221, 7, 70, "Input",
 CellID->14526],
Cell[CellGroupData[{
Cell[3565, 117, 42, 1, 70, "Print",
 CellID->2178],
Cell[3610, 120, 43, 1, 70, "Print",
 CellID->15745],
Cell[3656, 123, 42, 1, 23, "Print",
 CellID->6928]
}, Open  ]],
Cell[3713, 127, 219, 7, 36, "Output",
 CellID->4205]
}, Open  ]],
Cell[3947, 137, 247, 10, 70, "MathCaption",
 CellID->15149],
Cell[CellGroupData[{
Cell[4219, 151, 93, 3, 70, "Input",
 CellID->15257],
Cell[4315, 156, 157, 5, 36, "Output",
 CellID->5312]
}, Open  ]],
Cell[4487, 164, 180, 5, 70, "MathCaption",
 CellID->9401],
Cell[CellGroupData[{
Cell[4692, 173, 173, 6, 70, "Input",
 CellID->25199],
Cell[4868, 181, 187, 6, 36, "Output",
 CellID->24727]
}, Open  ]],
Cell[5070, 190, 804, 25, 70, "Text",
 CellID->32692],
Cell[5877, 217, 406, 11, 70, "Text",
 CellID->22353],
Cell[6286, 230, 327, 9, 70, "Text",
 CellID->27795],
Cell[6616, 241, 1382, 42, 70, "FramedBox",
 CellID->26542],
Cell[8001, 285, 70, 1, 70, "Caption",
 CellID->22567],
Cell[8074, 288, 543, 15, 70, "Text",
 CellID->27149],
Cell[8620, 305, 230, 7, 70, "Text",
 CellID->12376],
Cell[8853, 314, 3677, 114, 70, "DefinitionBox",
 CellID->14255],
Cell[12533, 430, 140, 6, 70, "Caption",
 CellID->26742],
Cell[12676, 438, 897, 25, 70, "Text",
 CellID->16748],
Cell[13576, 465, 156, 7, 70, "MathCaption",
 CellID->30103],
Cell[CellGroupData[{
Cell[13757, 476, 89, 3, 70, "Input",
 CellID->22815],
Cell[13849, 481, 155, 5, 36, "Output",
 CellID->14047]
}, Open  ]],
Cell[14019, 489, 151, 4, 70, "MathCaption",
 CellID->11073],
Cell[CellGroupData[{
Cell[14195, 497, 189, 6, 70, "Input",
 CellID->28965],
Cell[14387, 505, 962, 42, 39, "Output",
 CellID->4749]
}, Open  ]],
Cell[15364, 550, 556, 15, 70, "Text",
 CellID->137],
Cell[15923, 567, 247, 8, 70, "MathCaption",
 CellID->32169],
Cell[CellGroupData[{
Cell[16195, 579, 99, 3, 70, "Input",
 CellID->14331],
Cell[16297, 584, 178, 6, 49, "Output",
 CellID->7970]
}, Open  ]],
Cell[16490, 593, 265, 8, 70, "MathCaption",
 CellID->26053],
Cell[16758, 603, 236, 8, 70, "Input",
 CellID->8768],
Cell[16997, 613, 98, 2, 70, "MathCaption",
 CellID->28052],
Cell[CellGroupData[{
Cell[17120, 619, 99, 3, 70, "Input",
 CellID->13178],
Cell[17222, 624, 202, 7, 51, "Output",
 CellID->11156]
}, Open  ]],
Cell[17439, 634, 423, 11, 70, "Text",
 CellID->24981],
Cell[17865, 647, 740, 26, 70, "Text",
 CellID->12695],
Cell[18608, 675, 439, 9, 70, "Text",
 CellID->17586],
Cell[19050, 686, 248, 9, 70, "MathCaption",
 CellID->13929],
Cell[19301, 697, 189, 6, 70, "Input",
 CellID->731],
Cell[19493, 705, 247, 9, 70, "MathCaption",
 CellID->4278],
Cell[19743, 716, 192, 6, 70, "Input",
 CellID->17859],
Cell[19938, 724, 208, 7, 70, "MathCaption",
 CellID->8752],
Cell[CellGroupData[{
Cell[20171, 735, 122, 4, 70, "Input",
 CellID->5089],
Cell[20296, 741, 187, 6, 36, "Output",
 CellID->31958]
}, Open  ]],
Cell[20498, 750, 213, 7, 70, "MathCaption",
 CellID->20238],
Cell[CellGroupData[{
Cell[20736, 761, 178, 6, 70, "Input",
 CellID->7054],
Cell[20917, 769, 187, 6, 36, "Output",
 CellID->27972]
}, Open  ]],
Cell[21119, 778, 821, 24, 70, "FramedBox",
 CellID->4208],
Cell[21943, 804, 79, 1, 70, "Caption",
 CellID->25656],
Cell[22025, 807, 671, 20, 70, "Text",
 CellID->24171],
Cell[22699, 829, 329, 11, 70, "Text",
 CellID->18147],
Cell[23031, 842, 154, 6, 70, "Notes",
 CellID->8503],
Cell[23188, 850, 160, 6, 70, "Notes",
 CellID->354929591],
Cell[23351, 858, 157, 6, 70, "Notes",
 CellID->46832390],
Cell[23511, 866, 160, 6, 70, "Notes",
 CellID->207415005],
Cell[23674, 874, 637, 10, 70, "Text",
 CellID->19511],
Cell[24314, 886, 254, 7, 70, "MathCaption",
 CellID->32174],
Cell[24571, 895, 275, 9, 70, "Input",
 CellID->28819],
Cell[24849, 906, 158, 5, 70, "MathCaption",
 CellID->26107],
Cell[25010, 913, 278, 9, 70, "Input",
 CellID->12205],
Cell[25291, 924, 204, 7, 70, "MathCaption",
 CellID->22599],
Cell[CellGroupData[{
Cell[25520, 935, 177, 6, 70, "Input",
 CellID->788],
Cell[25700, 943, 210, 7, 36, "Output",
 CellID->13261]
}, Open  ]],
Cell[25925, 953, 211, 7, 70, "MathCaption",
 CellID->29045],
Cell[CellGroupData[{
Cell[26161, 964, 179, 6, 70, "Input",
 CellID->24435],
Cell[26343, 972, 222, 7, 36, "Output",
 CellID->7492]
}, Open  ]],
Cell[26580, 982, 707, 15, 70, "Text",
 CellID->5732],
Cell[27290, 999, 187, 7, 70, "MathCaption",
 CellID->30076],
Cell[27480, 1008, 304, 10, 70, "Input",
 CellID->4667],
Cell[27787, 1020, 125, 5, 70, "MathCaption",
 CellID->403],
Cell[27915, 1027, 305, 10, 70, "Input",
 CellID->18367],
Cell[28223, 1039, 185, 6, 70, "MathCaption",
 CellID->18899],
Cell[CellGroupData[{
Cell[28433, 1049, 345, 12, 70, "Input",
 CellID->21054],
Cell[28781, 1063, 428, 15, 36, "Output",
 CellID->10167]
}, Open  ]],
Cell[CellGroupData[{
Cell[29246, 1083, 72, 1, 70, "RelatedTutorialsSection",
 CellID->234306403],
Cell[29321, 1086, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[29528, 1094, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

