(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38794,        816]
NotebookOptionsPosition[     35103,        711]
NotebookOutlinePosition[     37767,        781]
CellTagsIndexPosition[     37675,        775]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell" :> Documentation`HelpLookup["paclet:ref/Cell"], 
          "CellGroupData" :> 
          Documentation`HelpLookup["paclet:ref/CellGroupData"], "InputForm" :> 
          Documentation`HelpLookup["paclet:ref/InputForm"], "OutputForm" :> 
          Documentation`HelpLookup["paclet:ref/OutputForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cell\"\>", 
       2->"\<\"CellGroupData\"\>", 3->"\<\"InputForm\"\>", 
       4->"\<\"OutputForm\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Structure of Cells", "Title",
 CellTags->{"S2.11.7", "7.1"},
 CellID->5793],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     StyleBox["contents", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", "]"}], Cell[
    "a cell in a particular style", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     RowBox[{
      StyleBox["contents", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style1\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"style2\", \"TI\"]\)\>\"", ",", "\[Ellipsis]"}], "]"}], Cell[
    "a cell with multiple styles", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cell"], "[", 
     StyleBox["contents", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", ",", 
     StyleBox["options", "TI"], "]"}], Cell[
    "a cell with additional options set", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11977],

Cell["Expressions corresponding to cells. ", "Caption",
 CellID->29854],

Cell[TextData[{
 "Here is a notebook containing a text cell and a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input cell. "
}], "MathCaption",
 CellID->15012],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 86},
 ImageMargins->0,
 CellID->324481075],

Cell["Here are the expressions corresponding to these cells. ", "MathCaption",
 CellID->14889],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 108},
 ImageMargins->0,
 CellID->1737366090],

Cell[TextData[{
 "Here is a notebook containing a text cell with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input inside. "
}], "MathCaption",
 CellID->32647],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 55},
 ImageMargins->0,
 CellID->11299],

Cell[TextData[{
 "This is the expression corresponding to the cell. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input is in a cell embedded inside the text. "
}], "MathCaption",
 CellID->2489],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdnQW4VMXbwJe7N+HSSBh/AQu7ExO7xW5BbMVubBS70QcTA0wsDFRUTBTs
BltBxS7Edr75vWfec2d355zde/fei883z3P37s6eM2fm7ZrZLQcffcC+Qwcf
feCQwb03PnLw4QccOOSo3hsddqTtyrbJZCrmyWQyp/TO8N7Yt+6lofXgJZPJ
Rp/kO/vSlZc2ricbf5XR79Mu+uijj+z3d911l7x04KVCOrPSqePojVUND7bN
XmfeeeedTPSOl3ZybyW9+q158MEHK8IP51/DvZ1Snpt7T0V0j7Z6XtJmXZ0z
a52bLFrB01ZuqIyX5S5ImXj+A6PFaKuRz1X5oOLqTLMOyp+FcPMOGpxpTSIU
c6m0NmGWLbL0Zh3UW1MrzPQ/B0/HrP9xJP3XBr1JXrPmjz/+ME888YR57rnn
ojG3c8+4avTzZvd9x8rfrkPGmLPOfyxTl/f8MihPn//XX3+ZadOmmZNOOin3
+T/+9Jv5YtZP8vfpZ9+bbXe7oeD5TSTSedyzZ86caT777DPz999/RzLU9v3y
yy/m+++/l0/tXN+///5rvvjiC/PPP//EfT/88IP5888/5VO163P3uU+F4+kz
fv75Z4F7tJio7/PPP5cx/eu+/vpr89tvv8mnnq7PziF+Rn1gLm3dCL/++qvM
m2fb5+lj/KVo30UXXRQPKa/buy9mffWzRf1Y+VQyO6eDvqt82ddMmjTJLLLI
ImbAgAFmk002MfPNN5959tln5Z53333X7LLLLmb55Zc3Sy65pFl00UXNDTfc
IHNfYYUVTKdOnczEiRPNY489Ju+XXXZZUCggOP74480yyyxj+vfvb7p3724O
OOAA8/vvv5sXX3zRLLHEEqa6utr069fPLL744ubxxx+vcPjbZ599TO/evU3P
nj3NUUcdZbp27cr/6OvlzPPPPy8zZGT+n3nmmakzpYH4/fbbz3Tr1s3MM888
8oi6urr4+xdeeEGuX2qppeTRW265pfnyyy/luzvuuMOstdZasgqmtMEGG5i3
3npLvrv++utl9qyuR48e8v6MM85I+67O4fOqq64yY8eOBZCOPquQnKZXr16y
Yqby8ccfu+/mT4JK0Wmw7C5dughyN9tsM0Gwo/c0JCnLNC89FhdFnd3w33zz
jenYsaN59NFHMxVu+GOOOcbceuutMsYaa6xhLr744vi7Tz75xNx9993y3ZNP
Pmn22GMP911bs/vuuwuN0y655BKz3nrrxSCANUHD7NmzK9yjIQTlYKVJ2LRv
377C8UhJpmIJLeuWb59mrrnmGhnxu+++Mw8//LA/y2iUnjmTvPHGG81GG20k
MuGnn34yAwcOFDJTcgXPd955p3yG2W666SZhMksTpl27drH5yndPPfWUeeWV
VxRn5557rrn88svlU2WgT8Xm22+/jaiHo2IRySogCROLzcTFh4aOVtrBHHTQ
Qeaee+5R0hEU3H777cVQ0DJUly4FuzgqGTlypEhB2owZM2SaMA3QgBwqKyvp
y5rrrrvOghWYe8SmdOjT2nbbbSd0GN1SLbSri6Y5QlMwg8mll15asI4WmTp1
agONZc0222xjnnnmGQ/MWX9emfyJbbHFFqBAJ8Y8lb7GjBmD6IyVzm233SaC
mAEq5DVrRo8eLbTmP64YYelUH3jgAaFv+2fvta9VDmHjx48XeMLdNI/awIly
WwIkkgmuTm6ZMmWKOe+888yQIUNE0n/44YcBPGR9PMRLmztyrtIcccQR5tBD
D5XrrdlRYUaNGmW74R2WBKdbAFWY888/31HXSiutFBOepYlYArLKp59+Wr7b
a6+9EPaZ6L6sOfvss4VOmIcv5qZPn+4hrsq8/vrrwt2rr766EIt9VsanP/Sk
DzVvipnQHFmd5at4jqpLaaeddpoZNGhQTIQQDfqcUXTeKCaw3RQiRH9/+umn
/Nl77WulIxUoCqMBClcLDkJEAoOi9ddfPxUgyWRYJaYQgD3kkENkTEuC7rsa
RQpLkz8fKWULviY6XqpuR4wYYXbccUc3sCEWAm4WF9WERrNAEYzRrK1mampq
RBqh0v73v/+JyqI99NBDYqZ88MEHoisAEqYMlEJDYi288MJmzTXXlHGwpN54
4w357rXXXjOvvvqqXIs0Hjp0qPTDq9dee63YlscddxwsIshzY2aiuXYIzvXl
l1+W5917772ilRErSoE8Y+ONN846usBshR4YZt555xV9xWemhSliaSFTqopV
y5/7mfrpp5+Opo9urxfSQAVCBmuvvbbMhscnQCFN09J34YUXyq34LRjls2bN
KoaMuW3fgXdMXdy9aCkdZWnQMQ0kYPLOP//8IhUOP/xwoQMAyhL33HNPs+66
6wqi7PIdYvqaq6++2iy00EIyNpY6S1caYumoOWgWMxh/BQjTrMst9IUJbGlC
bCMaLt8555wj9zEf6IrPiq2EeapaQguuttpqgmQsfiU9oIcjMmfOHLf8WrHm
IVMaBACLsAzkybhx40JEkEx6WXPBBReI+Gq4rj5H3+KFoUOGDRuWBIFkuqsW
uxWVw+oWW2wx06dPH3xkFYQBPMSzbW2a6+KmPGHCBJkuuF911VXFRpg8efKi
7unIvzfffFM+tXd9kBsRGYu3eOWIPfDIsjDwWaIdutZBWoMo6D4LtGy4W/nA
+jfirVoZZR+wzjrr2L7lllsu1no14du7zSVQ6nO/+uorEfmw72Kuz/lMOfAj
qgNcrTcaox/Ksba+eL51bnkYIjvssIPZfvvt8XKy4e7e4e4ubmAciSuvvBL7
L1rojiUAo9yA7V/lALyE+O3fLTe+IkkjHcazngpCkV+0LGFp+AwP4YorrsiZ
ix+WVGtx1113xeWVT6u4vptvvtmcddZZDbgZ27JzVvhZDz+GX0jG6Tp22203
IVs+zev6/BigwgDYO3sqluYoBowQq29adW3+OtLWhryvqKgw77//vtPxVcKP
6GpCVQhJDGs1W9Lig4RIOnToIDFCrgOnjH3ggQeqeiG6tcACC4jWIeBnFVlG
I2vIlzZt2qCmWxVUKFznT6SCyoJI7rXLdSHYrDnxxBPFTjSmwbJLiZPIZ0xb
/BJMEPwZWMI+X0FEfNMFscWawXxVagJkBJgsdKPlj2kdEL333nvm2GOPTQSR
H5RnuSbW3iEQZdWz9wIXtQVRFqx+LD/iIVaS6K0IFYjSnx7G3o8//iifSgZL
GQpEn0ufC9sEwdIrEQTpXqWuFarBRrNGc45QxXGL1/pAOSSQrmg6pKDa7+vu
VgvZnnLKKdLprTl2CIs5mQhLSJxxkBSYuHAm5Idy6dy5cyaKtGTFBNbnRzfP
fThEArReHGMsLeZNKIOGssYzyIeNNbYjdHdK9IGIDuFM4APDXYMHDxbfGOcU
w/fUU09Fx1Tg5Ngl+/FbWmg2d5YDrNIZBFFYCsBOOOEE0R6IYo3Hs1II3drW
Et/F2ua91Tyd3FA4cwAlmnf0kNBQLbxa1f84ivfff7/7FL36tm1XN8W9995b
YiEEqKwCUCnh2+GV4UtLXk0Zwq2fezSMB2Py3/71Dne3BnzlglLs9cRVz117
vfzxi8NoWYce7E+1TS17KGkSXsulrdysuprnSGW9Tl7vaNlpR1TVTUxFsp8Y
N8RXeH/wwQfL/cOHDxfNePTRR4uBwHeYpi6pIu/RKgS68e9HjBhR4YYlfMPl
bdu2FcnKezwV2ksvvSRmGolXzFHsDKJBFDMk5KSVqTFdGHLq1KkRBFqYJfu6
4dGBRHxNLGCqxJrWdt9995HBiyMeGPHqJAI5jHUrkHQZxOEwao1pyMdsvvnm
EpaEtYECyLjssstkiNzcbdZPi8Z9+ErEmKdMmVI6aMogoKaBpkqIn8wFJsbW
W2/tJQhqfLhIw1AnFW99nPh+EqXApTCTl40zeT5cnFUsn+S1FMZqIZIh9jpn
zhwZg2C5Nc/idVF2QHobHw+YWbM6ES7IGRjPklh8P34ycCnMMGX9DFMzmGzF
YdDHDY97gNVh4ZDRpC30TRzx5JNPFiFIsMua27qMlVdeObaVqO6wbBGrdEgH
OYPLnHWgAVzbbrutBGeJuOLEObZxaY7KYJrjvpalAnVTKUCg2f9xigMMId+w
JC3dKmCwnwgnE7BEsu60007MXAHDSNAHd2K6b7XVVg73lWKnMhrW2ueffx6N
2F5I/7DDDpOQAaMdeeSRsUhJCMPHDq8/cXlTlsObrqa7uWWgJADOKqusAvlr
1QX1SyS0fbhS3JGvQiEPUgJ2iXG2OG9IefzNLUv8amy2b99eqA5GnT59uq6G
fJzWi+hqqBUhOOGvhiEJ106cODFeTd6QjVpNE/OdOkW1T+z/jKv9tnDV6LYm
d/jUK3BH+RTUGsHl4s9YzCGCJAQCnD+rrJdx3eht7baXLOQmgx9IaPjbb7/N
dHSTIWw3bty4+PIZM2Zklk+5ngAPxQBcS5WH/RwHevzQc32grzLQp2QG2dFH
mHRW6wAPrbjggguK9zxp0iQFHkIMBxxrc+TIkQo8nC9i2bNnz46BgfAiTIHO
W3HFFQFYTKh+nHu+lDFwzMlrEQrCn581a1YMUD9+Xh/oqwz0KUBRXpQHTZ48
Ob7On9OnJQC5DMXTy0GTSiTwjZiw4NLZQUauxRYST8K/N0azZ7nFu5pySijK
pTRJi4M0SQdSGMIf0q8vVmEIIvP7CsMUkRFHcBsEKqL95IDWRBMIULUQSthr
/IKEtEtkxyETN1+HisJ76wN9aSFZ1JYlgpy5+HMuhRCaqFCjXEk3sRthKWsr
iO0ArSN4aKAMYwrvDJuCHCp+hj6Wz9hm3M+9EyZMqHBwSCrwTS1T7pZaWIt1
i4WK54ARhE+Il0ODe/ET6+vrZUius9Z/hcNemqsJHaJs6WdG4B19FN07X7A0
2kpduRZly1gYqxhW6vUyZYxXAERSnKlqAWNKIiZIjxG+a0q6D9/X1a3EfiZ1
zBj7zJM/HAyLHTXi/ByTn4jGs27YNtDPn5I0lkXujKIs2i233CJ0gBtLjSDG
JI+rra0V0DBtV+kmIKbWBJrCuNx///2FnjARAHPnzp1F4ZBlYMlch09ACQ7z
AvRg2y5dIgSPPPJICHLNwY0+eFqcG+cXgiHjqo28DlVZNMrgqKGnETgAqc4i
lLEY2/oKAkVMc6IDcHJKcXOoOls9g7RqYzgb+labjoqcKF0UjUCJDI57RIFR
X2FAo1p4D0LBYGWaeHbW8dfinaQKcNhs4MCB0WWdJTnFCmhkalBUWjqHFUZJ
kmqWhPxekPPq3CxTc4KVotxUJll469pwJYjxuKCzuCMWTsp3fsJS+Y54B/Ho
BqKsLuA7nmbBpPPdd999xZRogGpWhB8s3NBXJywHq2E3oimJWZPlUhgRAtdr
EekULtHwBbG2FAWwJ656iI+ag998sJTFb6WaQXXCV37DP9RwPsu37+MIChE4
n+esV5bRuppNN91UojKu8FsL1L2ab2mO17RwNqnGGiShJDHwlYUaw1ZEULWh
AqxZofThF71rnaZjqfgWLSWkERMZM2ZMRjdmEFqAZrTlJYNDKNe4Rt6lCjpk
CcRP5GXUqFFKDJReokMoRFATLJTFhtlJxVL4FzLLFC4snMgxcoU/fGqrqvVx
SXyDO64NOYKBgoZP4xv4DIGAvcN0idy0BN+EkvufuL4W4pt53YAsFYoF8mho
YvO0Sy+9FDHsA91nGQc9lZ7QKtW5rlI9K+HIar9IXZorrFeuCZSEy2UoMbgG
da3JfL7DmtAGF/FUjLxiXER1ozZIwRKpz0Vauu9zEcYOFDNo0CAxVGA+GiRP
IFrvx6DBnrT3BGsKQoTcNnCdlj/r/iZMA5QEbKb6me+Q3mSZCQJa4dDHG54k
TkQehY9UyYcpgAnAktnfZBVITHxJjEMuXBv5cqZMg3Ess8TXYtWobUgjeIF9
iDkA/1tCaHbG+dL1tbCPjcDDsyDUb6EeIWsJmR2mCg0bDeJQJgFJDAP0mC2i
wyXS08ro5fu0nQBpRe2YNHiAXA+mIJ6hQ4cqK6CgoFWCjUzPGtxIHCXbgqB7
BQIh00ei89iG3Evgq8imA+Efpg67wtYIaJWoSvNIVKq1CBHBa+qsJtSnpFh2
dYk1LTTqfizBx0SKa4oNR8NE5/lIXWpdKIUgOregexZogHCttohFTIipuA7m
Yf1YrRa2KUzVXnw+XFzMEvxJvGrdkwpT4d9C5BAtJmlDJXyV1PeAbpJLlKIj
d+YGU5VtsXWTMiavPlQoHU7AzEIrQHI0LDJIRM0vogmEV9Q1x5aaNm1aBKF+
of0BcluxbQ4JVfvyHV4AdjYuLdIZDqL6hYZsgFmpwIISYXKugcNoeSkbdXfQ
r0yPDYdMl4gM3jet2M4KZ+ZldCw8aK8OSAgLptP9CppRTKlyCjKY9vkpIn1m
WsWU7ixiyaADuca1jplk/va9HYva/lqJKqiAoEHcfHZbDLo4Ss2rstLZsVOd
VJrx7OnQKthLCL0NGDDA6cjOPntKI8bLTEEu4TtEHJ6E5nJhT9gVOYk4tFjM
aM4XbwOoaywEsZXGcj5UQzr7P6UDq0VpgWR4BF8CGreaQSvM/TydGjj+thG1
49AysBhQQlhyDW6spfnYEyjEXkF+r6frJtiOM0AwfsMNN1RSyStR8zdlIjKQ
8jWBh6k5i2iBsMnOjh8/XueAGEC3Er2yQliXiR7BhOZTch1jwRLS8NuiIjo9
iDW/eyjamQgppG9nrXj2M5gKAL+sTjMxBGOJglhRG+MwL6upOESCQlHYBJbh
FId5hXmKQyIxWOURORU+TJMYqA/kNARmiU5L4MnkoD2sARN7o34FYXV4rhWB
SysDfcrIGNrYRtYgbuls2w5ueD81u4y3Whpe0rx519GnsM4rOdTVYkQ64zKz
emDIf0pcWTlnH7VwojeUil010CcDXVjOXNLZbgU3tJ/BXDXQV/48St/KFjrs
xy9p1ASdL600uac1GH6ffyiQf3iQ9inz+Lt8VHuHDjIq2OJXKlyaeFZcxC3z
pZ6Jk3bWTtphNCgwVA52Ew4A3/Xv3z8xc4NZSxAGK4RnkGHBpFW4M29qLwl5
Y+Xo/cg0noF8I39AvQ3jkKcHxths5BxYF33QnkqMlMyNZgwDu4/k1oQzehL3
vTaGwpu8ub9t6nEytJxTasLlmKFNx7gqbvN6Sjimr5ikavRD9GRR8F5hdpI9
EBMNJgExmrlBJ2M8YYQTIoZwOJiFRvJINzLj8eMAoEZpCXmAiMfahfZFJZ1w
k3wqV1k8WMp5NFk9pCUH5IVVotV+lag0hyqdemlYqs3BEo1yFvqAqnU+NaAO
6ZPI0YbxBP3AMdZlUe/fxw8Nb0YDQ0nx5tDOrCJn45SNnybqDi3kcGeY5OCo
WMVq+SwVIQt5DJ0SGcDch40wB608dYEte5Xa+vA0KCIVboW4Bsvy0QT919fX
axwmFNz0saT7xyrd9aHTUuY2itwhHzmg15M+or5gVW3aQR+lYamHYAlBRwgS
Z4uACwIQXxxthAzmM3IYben8HrFIQBZqBdcPUKrGcxiLw2yE9ZDt2gKhM+kv
3PpW6299C506UhbmyvDFFXMfFZyRUZdzRkZSzW9zoU6lIZSCPNKkEfoGCif9
SVBH1SrXweQYHkSTqSviPYGAEOowlNjyrC0QWpF+b2teJrQ3L3BwR8swXSmn
STb2eAxFDMDFRbbIcZZv2wJrUBMUKAKqrgjUjB49OiqBrBHlSCIMGwK7gSg4
MIZ+1DH2d/qFohjlA6l0x6OEczAUOpAJXcOHD4/9Aj8ckHYEh39do5b3H/Zn
S37GXNvJV3wNT7rh/WpauWm1cp6bvi6tQvb92+RTJypjcxumtWaDXorSUTdV
3WO/HlZDZv7hFnodiknv7eJd50p5Yzeaa9QtD9XIlg+qUqPC6QdZpLnCSCDG
wsJljWgHUv5x8Wn4IAtdAelCPF4UDqlHK+TjjH/CRkfVLSASPYd+4mvqZTQp
gemhlZlIYRwKtEokg7oFq0iLlTumHOehq8HtYyoAESDtvPPObjVLikLA0ATI
DEFBn8Ya0CWoWnLJrNKdHyFuBI9BI2DxMB0Sr9jkTIvGclGpWF4QDr4f1Uu0
tKpPVDpqmLExCNE2qFhUiRZd++WWjSLGJspVjTkXHgJRrR68MqC68EpkYBCP
GDoGnNYyyWhCJ3RMSK0blkQQHgPpf4suielbflYDq3BPYJ2UKm+44YYyHFID
21fL4vEbLeHEZjgQds09MrmO0hUwRbe2zalfSjknRdU+eUgXg4pdSmgNExHG
ZKbEeayO1clhuOOCN9zSXigcqxCtDbnQsDr1TF8/7461R8ldco68WnABc9Mw
xquqqohGqwHsFxg2isKaKO4iCqvJOVaCVhh1qCmIOsDsRMws7mID3Hfk27kl
Ay4MeKwZjDSCNVa2JZNUViDujkiNPU1HSvHjLSnFWidUM+jIJ77ep5+042Fr
AwSkFAJ5IjzYa6QYRRtQ5KLNUVFliQREjlx3wqEoixEQXiXb23FrYGJkpyUg
1at+pZ2MqbH2FsuoFRJPYTikNueIWBoaBPEMAVnPJnREjdIPKhblhkJDeaEF
rPpNox9kgTspPYd+1G9DzdrH5NBPfrWcKwOLZ+yXgaUdthsSQH6WjetmzpwZ
I5Rj97WWVenHGv0h+kE30agrVJcY+tHTXoBeMfohqkCdFW4j5gKlIlp7v0U5
tFJc2PR0AxY56ycKz3QMbnrGKIGp2QgMt1AZqb9bUOyon8iLqpfrUGtAi5VQ
joi8wyLQjIC371tpCtlD6tY6uXE4ReMDNOiL6WD9ogks7USw6160sCyhOEq+
Szn4SFGDBGKXNIABGOhz3R8EZUOtmEsMDdr1NwR4PLE7zCVIgtWgvGnYDhRS
EqDiZDXKA3Dv9ZBUoiFKduCzGNkhl4iQAFhSQhi/uvxSya6J2a3QTvZoWr3S
jlaS/0ln0tJgVII9cCN06s70lEB1YQAn6wdwYo8eHco9VqLHlSQcBkAfVJK3
0z4WcASauM6iIQ4QqRZRYmRsZCm0bgVXBNH2RYuw0kqBQke86o/CABqMbsCA
rKT6V6kQPwRjn/sAJezrNmcK5bI8SqyhRhJvbNcjV0A/PEVSD9GP68MmB7QH
4MGpgLJhadiXIwWSqTDadsvcmAPK2FpuseObV5wlc1unRMpsYrYuosz64B7/
Rp5hpREm/6gBJRZSqk7exn1oQPQvxrmGjfyyJr3OrwHq5lYOdGAaytwpQbf8
n9GsQF4pkdZh5JUzNQq4TUio6XkMecUuoeOyVDr4pxro4tVP8Psw3rFkrSCM
AeeP5ydLtB6nu5sOshzBihqZMWOGwiyvokdhllc+1GiCLENU+rUwy/FGzko4
wqM7/bY1ZhU9rGWfsYQb3i+NWTvQp2F2JIluL5fBz2qd+fklM2sH+lT6kVHH
l6X8UAYf0bLzU1Yo9jtaaaU1/nUadwz9pleo3MYvo0krt/FjjKFym8TCjVLh
10QjJYJBeglOM/8sVXCtfj0+1xG7RKtHP9ERzTFpHmklOHqCbdJPeaH5iYWg
N5gn8tDSUmw/pv5CWPvE8py0qF6oMrxs9DfREoiMkA4t/TNQyeXYXcTI8A7X
SHucfE6o1Ykw0jUxqscKcThoHBWP+QlWaEk1ObqJLFTHQ0sIqqUVHetWo0Yj
uAnWiMq3UHlPc/0OUzJmqwswm7MFuLZgC3BefY/SVmGMLesjMy5Ugb3QRgn1
O6GSH51oQmwr7WRt1u+s9Qj4Z5eIxybqOY0YhcqAmuvnjBqDy5yNqbUFG1Pz
ioB8XObGu8K4JGHCpnFaoNInuTAoMc5U7JR0hUFr4rKwXqh5fxkowudCBcUN
BATU01S8IhK5t9hWyqSCoWKhJoflWKSybv0JsaQfY/ICa1Hgqy6njightJO6
56Ms/VoGqgsLjJrtR3j0FOk8LFdIAGWBHCQTpNPjLZK29aWVFhUL4SiS1TrC
gIRY1AhL+uWjYmVHgfBJqRu8WgPJmjBoll/rqXZD5jMt6gy4Y/qQowZ35BWH
DRsW54kLAynVAleMVsJZpJ9IGVg9V2qVUqLdcqb7Wn8vepe9x5jtdr8x9FPN
TXRN1LVr+o/4hOqX9AeVQ7GYYjVNCgwQjYAjAJUDDP3x6jfe/gKAJP1udVNL
nX534/m/0b3VTtfzP/gb2U2wGaVTf6La/y1u/ubM+bP03+IucU3SWuVX08v9
+aX/rzMtgSCkNXdkLXGW5VQDNm7p1TlL91jGddqXtgKFyvxxis0t2jDES708
NlsqUqOn8NIpb42ZZr5Hm2oPtL1+W3hPRgEiL114idS8N1IPd3Gb/wM4lc2o
\
\>"], "Picture",
 ImageSize->{533, 126},
 ImageMargins->0,
 CellID->1621908397],

Cell[BoxData[GridBox[{
   {"\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", Cell["plain text", "TableText"]},
   {
    RowBox[{"TextData", "[", "{", 
     SubscriptBox[
      StyleBox["text", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["text", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "text potentially in different styles, or containing cells", 
     "TableText"]},
   {
    RowBox[{"BoxData", "[", 
     StyleBox["boxes", "TI"], "]"}], Cell[TextData[{
     "formatted ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expressions"
    }], "TableText"]},
   {
    RowBox[{"GraphicsData", "[", "\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", 
     StyleBox["data", "TI"], "]"}], Cell["graphics or sounds", "TableText"]},
   {
    RowBox[{"OutputFormData", "[", "\"\<\!\(\*
StyleBox[\"itext\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"otext\", \"TI\"]\)\>\"", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "text as generated by ",
     Cell[BoxData[
      ButtonBox["InputForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["OutputForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"RawData", "[", "\"\<\!\(\*
StyleBox[\"data\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "unformatted expressions as obtained using ",
     StyleBox["Show Expression", "SR"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CellGroupData",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellGroupData"], "[", "{", 
     SubscriptBox[
      StyleBox["cell", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["cell", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "Open", "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["an open group of cells", "TableText"]},
   {
    RowBox[{
     ButtonBox["CellGroupData",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellGroupData"], "[", "{", 
     SubscriptBox[
      StyleBox["cell", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["cell", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "Closed", "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell["a closed group of cells", "TableText"]},
   {
    RowBox[{"StyleData", "[", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", "]"}], Cell[
    "a style definition cell", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, True, False, False, 
     False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25836],

Cell["Expressions representing possible forms of cell contents. ", "Caption",
 CellID->6612],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->95134933],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Structure of Cells - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExecutingNotebookCommandsDirectlyInTheFrontEnd"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 46.9836786}", "context" -> "", 
    "keywords" -> {
     "BoxData", "cell", "CellGroupData", "GraphicsData", "OutputFormData", 
      "RawData", "show Expression menu item", "structure", "TextData"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Expressions corresponding to cells. Here is a notebook containing a text \
cell and a Mathematica input cell. Here are the expressions corresponding to \
these cells. ", "synonyms" -> {"2.11.7"}, "title" -> "The Structure of Cells",
     "type" -> "Tutorial", "uri" -> "tutorial/TheStructureOfCells"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.7"->{
  Cell[2133, 63, 85, 2, 70, "Title",
   CellTags->{"S2.11.7", "7.1"},
   CellID->5793]},
 "7.1"->{
  Cell[2133, 63, 85, 2, 70, "Title",
   CellTags->{"S2.11.7", "7.1"},
   CellID->5793]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.7", 37464, 764},
 {"7.1", 37563, 768}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1508, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2133, 63, 85, 2, 70, "Title",
 CellTags->{"S2.11.7", "7.1"},
 CellID->5793],
Cell[2221, 67, 1250, 36, 70, "DefinitionBox",
 CellID->11977],
Cell[3474, 105, 71, 1, 70, "Caption",
 CellID->29854],
Cell[3548, 108, 169, 6, 70, "MathCaption",
 CellID->15012],
Cell[3720, 116, 4017, 68, 70, "Picture",
 CellID->324481075],
Cell[7740, 186, 94, 1, 70, "MathCaption",
 CellID->14889],
Cell[7837, 189, 9168, 153, 70, "Picture",
 CellID->1737366090],
Cell[17008, 344, 170, 6, 70, "MathCaption",
 CellID->32647],
Cell[17181, 352, 3725, 64, 70, "Picture",
 CellID->11299],
Cell[20909, 418, 207, 6, 70, "MathCaption",
 CellID->2489],
Cell[21119, 426, 10555, 176, 70, "Picture",
 CellID->1621908397],
Cell[31677, 604, 3003, 87, 70, "DefinitionBox",
 CellID->25836],
Cell[34683, 693, 92, 1, 70, "Caption",
 CellID->6612],
Cell[CellGroupData[{
Cell[34800, 698, 71, 1, 70, "RelatedTutorialsSection",
 CellID->95134933],
Cell[34874, 701, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[35076, 709, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

