(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53322,       1625]
NotebookOptionsPosition[     44326,       1342]
NotebookOutlinePosition[     47685,       1420]
CellTagsIndexPosition[     47591,       1414]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"The Structure of Graphics and Sound\"\>", 
       2->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Graphics Directives " :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Graphics Directives \"\>", 3->"\<\"3D Graphics Options\"\>", 
       4->"\<\"Combining Graphics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AspectRatio" :> 
          Documentation`HelpLookup["paclet:ref/AspectRatio"], "FullGraphics" :> 
          Documentation`HelpLookup["paclet:ref/FullGraphics"], "Graphics" :> 
          Documentation`HelpLookup["paclet:ref/Graphics"], "Graphics3D" :> 
          Documentation`HelpLookup["paclet:ref/Graphics3D"], "Options" :> 
          Documentation`HelpLookup["paclet:ref/Options"], "PlotRange" :> 
          Documentation`HelpLookup["paclet:ref/PlotRange"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Show" :> 
          Documentation`HelpLookup["paclet:ref/Show"], "Thickness" :> 
          Documentation`HelpLookup["paclet:ref/Thickness"], "Ticks" :> 
          Documentation`HelpLookup["paclet:ref/Ticks"], "ViewPoint" :> 
          Documentation`HelpLookup["paclet:ref/ViewPoint"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AspectRatio\"\>", 
       2->"\<\"FullGraphics\"\>", 3->"\<\"Graphics\"\>", 
       4->"\<\"Graphics3D\"\>", 5->"\<\"Options\"\>", 6->"\<\"PlotRange\"\>", 
       7->"\<\"RGBColor\"\>", 8->"\<\"Show\"\>", 9->"\<\"Thickness\"\>", 
       10->"\<\"Ticks\"\>", 11->"\<\"ViewPoint\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Structure of Graphics", "Title",
 CellTags->{"S2.10.1", "1.1"},
 CellID->11957],

Cell[TextData[{
 "\"",
 ButtonBox["Graphics and Sound",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"],
 "\" discussed how to use functions like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " to plot graphs of functions and data. Here, we discuss how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents such graphics, and how you can program ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to create more complicated images. "
}], "Text",
 CellID->15503],

Cell[TextData[{
 "The basic idea is that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents all graphics in terms of a collection of ",
 StyleBox["graphics primitives",
  FontSlant->"Italic"],
 ". The primitives are objects like ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 ", that represent elements of a graphical image, as well as directives such \
as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19491],

Cell["This generates a plot of a list of points. ", "MathCaption",
 CellID->10482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->2829],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
     7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {13.,
      41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {19., 
     67.}, {20., 71.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->173491428]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " shows how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents the graphics. Each point is represented as a coordinate in a ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " graphics primitive. All the various graphics options used in this case are \
also given. "
}], "MathCaption",
 CellID->13361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->952],

Cell["\<\
Graphics[{{{}, {Hue[0.67, 0.6, 0.6], Point[{{1., 2.}, 
     {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, 
     {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 
     31.}, {12., 37.}, {13., 41.}, {14., 43.}, {15., 
     47.}, {16., 53.}, {17., 59.}, {18., 61.}, {19., 
     67.}, {20., 71.}}]}, {}}}, 
 {AspectRatio -> GoldenRatio^(-1), Axes -> True, 
  AxesOrigin -> {0, 0}, PlotRange -> 
   {{0., 20.}, {0., 71.}}, PlotRangeClipping -> True, 
  PlotRangePadding -> {Scaled[0.02], Scaled[0.02]}}]\
\>", "Output",
 ImageSize->{399, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]//InputForm=",
 CellID->2232728]
}, Open  ]],

Cell[TextData[{
 "Each complete piece of graphics in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is represented as a ",
 StyleBox["graphics object",
  FontSlant->"Italic"],
 ". There are several different kinds of graphics object, corresponding to \
different types of graphics. Each kind of graphics object has a definite head \
which identifies its type. "
}], "Text",
 CellID->5646],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Graphics",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Graphics"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["\<\
general two\[Hyphen]dimensional graphics\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Graphics3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Graphics3D"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["\<\
general three\[Hyphen]dimensional graphics\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15183],

Cell[TextData[{
 "Graphics objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->15597],

Cell[TextData[{
 "The functions like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " discussed in \"",
 ButtonBox["Graphics and Sound",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"],
 "\" all work by building up ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics objects, and then displaying them. "
}], "Text",
 CellID->11554],

Cell[TextData[{
 "You can create other kinds of graphical images in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by building up your own graphics objects. Since graphics objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are just symbolic expressions, you can use all the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions to manipulate them. "
}], "Text",
 CellID->5945],

Cell[TextData[{
 "Graphics objects are automatically formatted by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end as graphics upon output. Graphics may also be printed as a side \
effect using the ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " command."
}], "Text",
 CellID->20476],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object is computed by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but its output is suppressed by the semicolon."
}], "MathCaption",
 CellID->281234861],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Graphics", "[", 
   RowBox[{"Circle", "[", "]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"2", "+", "2"}]}], "Input",
 CellLabel->"In[29]:=",
 CellID->177299711],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->178853154]
}, Open  ]],

Cell[TextData[{
 "A side effect output can be generated using the ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " command. It has no Out[] label because it is a side effect."
}], "MathCaption",
 CellID->746158989],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"2", "+", "2"}]}], "Input",
 CellLabel->"In[31]:=",
 CellID->681546501],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}]]], "Print",
 CellLabel->"During evaluation of In[31]:=",
 CellID->25506308],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->262917273]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Show",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Show"], "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", " ", 
      StyleBox["opts", "TI"]}], "]"}], Cell[TextData[{
     "display a graphics object with new options specified by ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Show",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Show"], "[", 
     SubscriptBox[
      StyleBox["g", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "display several graphics objects combined using the options from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Show",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Show"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], 
      StyleBox[",", "TR"], 
      StyleBox["opts", "TI"]}], 
     StyleBox["]", "TR"]}], Cell[TextData[{
     "display several graphics objects with new options specified by ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28224],

Cell["Displaying graphics objects. ", "Caption",
 CellID->9081],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " can be used to change the options of an existing graphic or to combine \
multiple graphics."
}], "Text",
 CellID->307637545],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " ",
 "to adjust the ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " option of an existing graphic."
}], "MathCaption",
 CellID->226535831],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g1", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"g1", ",", " ", 
   RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]}], "Input",
 CellLabel->"In[33]:=",
 CellID->102649177],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->375088423]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " to combine two graphics. The values used for ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " and other options are based upon those which were set for the first \
graphic."
}], "MathCaption",
 CellID->976724534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"g1", ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Circle", "[", "]"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->111366503],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->683354859]
}, Open  ]],

Cell["Here, new options are specified for the entire graphic.", "MathCaption",
 CellID->438438196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"g1", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->778666741],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->22813381]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["Graphics directives", "TableText"], Cell[TextData[{
     "Examples: ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Thickness",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Thickness"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["Graphics options", "TableText"], Cell[TextData[{
     "Examples: ",
     Cell[BoxData[
      ButtonBox["PlotRange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Ticks",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["AspectRatio",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["ViewPoint",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19654],

Cell["Local and global ways to modify graphics. ", "Caption",
 CellID->24652],

Cell[TextData[{
 "Given a particular list of graphics primitives, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides two basic mechanisms for modifying the final form of graphics you \
get. First, you can insert into the list of graphics primitives certain ",
 StyleBox["graphics directives",
  FontSlant->"Italic"],
 ", such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", which modify the subsequent graphical elements in the list. In this way, \
you can specify how a particular set of graphical elements should be \
rendered. "
}], "Text",
 CellID->23399],

Cell[TextData[{
 "This creates a two\[Hyphen]dimensional graphics object that contains the ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " graphics primitive."
}], "MathCaption",
 CellID->28343],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"n", " ", 
           RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"n", " ", 
           RowBox[{"Pi", "/", "5"}]}], "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", "poly", "]"}]}], "Input",
 CellLabel->"In[41]:=",
 CellID->22602],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[{{1., 0.}, {0.8090169943749475, 0.5877852522924731}, {
   0.30901699437494745`, 0.9510565162951535}, {-0.30901699437494745`, 
   0.9510565162951535}, {-0.8090169943749475, 0.5877852522924731}, {-1., 
   0.}}]]], "Output",
 ImageSize->{184, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->74714634]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " shows the complete graphics object. "
}], "MathCaption",
 CellID->3282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->19989],

Cell["\<\
Graphics[Polygon[{{1., 0.}, {0.8090169943749475, 
    0.5877852522924731}, {0.30901699437494745, 
    0.9510565162951535}, {-0.30901699437494745, 
    0.9510565162951535}, {-0.8090169943749475, 
    0.5877852522924731}, {-1., 0.}}]]\
\>", "Output",
 ImageSize->{343, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]//InputForm=",
 CellID->304224854]
}, Open  ]],

Cell[TextData[{
 "This takes the graphics primitive created above, and adds the graphics \
directives ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"0.3", ",", "0.5", ",", "1"}], "]"}], ",", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Thickness", "[", "0.01", "]"}], "]"}], ",", "poly"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->30132],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.3, 0.5, 1], EdgeForm[Thickness[0.01]], 
   PolygonBox[{{1., 0.}, {0.8090169943749475, 0.5877852522924731}, {
    0.30901699437494745`, 0.9510565162951535}, {-0.30901699437494745`, 
    0.9510565162951535}, {-0.8090169943749475, 0.5877852522924731}, {-1., 
    0.}}]}]], "Output",
 ImageSize->{184, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->199610760]
}, Open  ]],

Cell[TextData[{
 "By inserting graphics directives, you can specify how particular graphical \
elements should be rendered. Often, however, you want to make global \
modifications to the way a whole graphics object is rendered. You can do this \
using ",
 StyleBox["graphics options",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->22590],

Cell[TextData[{
 "By adding the graphics option ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " you can modify the overall appearance of the graphics. "
}], "MathCaption",
 CellID->29204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Frame", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->32177],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.3, 0.5, 1], EdgeForm[Thickness[0.01]], 
   PolygonBox[{{1., 0.}, {0.8090169943749475, 0.5877852522924731}, {
    0.30901699437494745`, 0.9510565162951535}, {-0.30901699437494745`, 
    0.9510565162951535}, {-0.8090169943749475, 0.5877852522924731}, {-1., 
    0.}}]},
  Frame->True]], "Output",
 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->440226311]
}, Open  ]],

Cell[TextData[{
 "InputForm shows that the option was introduced into the resulting ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object."
}], "MathCaption",
 CellID->5319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->4750],

Cell["\<\
Graphics[{RGBColor[0.3, 0.5, 1], 
  EdgeForm[Thickness[0.01]], 
  Polygon[{{1., 0.}, {0.8090169943749475, 
     0.5877852522924731}, {0.30901699437494745, 
     0.9510565162951535}, {-0.30901699437494745, 
     0.9510565162951535}, {-0.8090169943749475, 
     0.5877852522924731}, {-1., 0.}}]}, {Frame -> True}]\
\>", "Output",
 ImageSize->{392, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]//InputForm=",
 CellID->389153061]
}, Open  ]],

Cell[TextData[{
 "You can specify graphics options in ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ". As a result, it is straightforward to take a single graphics object, and \
show it with many different choices of graphics options. "
}], "Text",
 CellID->20228],

Cell[TextData[{
 "Notice however that ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " always returns the graphics objects it has displayed. If you specify \
graphics options in ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 ", then these options are automatically inserted into the graphics objects \
that ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " returns. As a result, if you call ",
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " again on the same objects, the same graphics options will be used, unless \
you explicitly specify other ones. Note that in all cases new options you \
specify will overwrite ones already there. "
}], "Text",
 CellID->5722],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["g", "TI"], "]"}], Cell[
    "give a list of all graphics options for a graphics object", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["g", "TI"], ",", 
     StyleBox["opt", "TI"], "]"}], Cell[
    "give the setting for a particular option", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29668],

Cell["Finding the options for a graphics object. ", "Caption",
 CellID->8785],

Cell[TextData[{
 "Some graphics options can be used as options to visualization functions \
which generate graphics. Options which can take the right-hand side of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " are sometimes resolved into specific values by the visualization \
functions."
}], "Text",
 CellID->23774],

Cell["Here is a plot. ", "MathCaption",
 CellID->19184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zplot", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Zeta", "[", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "+", 
       RowBox[{"I", " ", "x"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]}]], "Input",
 CellLabel->"In[56]:=",
 CellID->6651],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[56]=",
 CellID->238291373]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses an internal algorithm to compute an explicit value for ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " in the resulting graphic."
}], "MathCaption",
 CellID->27037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"zplot", ",", "PlotRange"}], "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->10915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotRange", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "9.999999795918367`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5262533242798757`", ",", "1.5491945399661666`"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{313, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[57]=",
 CellID->617200719]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FullGraphics",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullGraphics"], "[", 
     StyleBox["g", "TI"], "]"}], Cell["\<\
translate objects specified by graphics options into lists of explicit \
graphics primitives\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5850],

Cell["Finding the complete form of a piece of graphics. ", "Caption",
 CellID->4546],

Cell[TextData[{
 "When you use a graphics option such as ",
 Cell[BoxData[
  ButtonBox["Axes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axes"]], "InlineFormula"],
 ", the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end automatically draws objects such as axes that you have \
requested. The objects are represented merely by the option values rather \
than by a specific list of graphics primitives. Sometimes, however, you may \
find it useful to represent these objects as the equivalent list of graphics \
primitives. The function ",
 Cell[BoxData[
  ButtonBox["FullGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullGraphics"]], "InlineFormula"],
 " gives the complete list of graphics primitives needed to generate a \
particular plot, without any options being used. "
}], "Text",
 CellID->29260],

Cell["This plots a list of values. ", "MathCaption",
 CellID->6427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"EulerPhi", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->22233],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 1.}, {3., 2.}, {4., 2.}, {5., 4.}, {6., 2.}, {7.,
      6.}, {8., 4.}, {9., 6.}, {10., 4.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0., 10.}, {1., 6.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->175841016]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullGraphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullGraphics"]], "InlineFormula"],
 " yields a graphics object that includes graphics primitives representing \
axes and so on. "
}], "MathCaption",
 CellID->3161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"InputForm", "[", 
    RowBox[{"FullGraphics", "[", "%", "]"}], "]"}], ",", "6"}], 
  "]"}]], "Input",
 CellLabel->"In[63]:=",
 CellID->27818],

Cell[BoxData[
 TagBox[
  FrameBox["\<\"Graphics[{{{{}, {Hue[0.67, 0.6, 0.6], Point[{{1., 1.}, {2., \
1.}, {3., 2.}, {4., 2.}, {5., 4.}, {6., 2.}, {7., 6.}, {8., 4.}, {9., 6.}, \
{10., 4.}}]}, {}}}, {{GrayLevel[0.], AbsoluteThickness[0.25], Line[{{2., 1.}, \
{2., 1.0505635621484342}}]}, <<56>>}}]\"\>",
   BoxFrame->False,
   FrameMargins->False],
  Short[#, 6]& ]], "Output",
 ImageSize->{487, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[63]//Short=",
 CellID->3805341]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->13339898],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "TutorialMoreAbout",
 CellID->498289123],

Cell[TextData[ButtonBox["Graphics Directives ",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "TutorialMoreAbout",
 CellID->340465473],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "TutorialMoreAbout",
 CellID->8690014],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "TutorialMoreAbout",
 CellID->302762036]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->101498966],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->28810171]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Structure of Graphics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TwoDimensionalGraphicsElements"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 47.7024470}", "context" -> "", 
    "keywords" -> {
     "AbsoluteOptions", "automatic options", "ContourGraphics", "ContourPlot",
       "DensityGraphics", "DensityPlot", "diagrams", "display", 
      "DisplayFunction", "frame", "FullGraphics", "graphics", "Graphics3D", 
      "GraphicsArray", "graphics directives", "graphics objects", 
      "graphics primitives", "GrayLevel", "InputForm", "internal form", 
      "ListContourPlot", "ListDensityPlot", "ListPlot", "ListPlot3D", 
      "options", "output", "ParametricPlot", "ParametricPlot3D", "pictures", 
      "plot", "Plot3D", "PlotRange", "plots", "polygon", "primitives", 
      "programming", "redisplay graphics", "redraw plot", "rendering", "show",
       "SurfaceGraphics", "wrappers", "DisplayFunction"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"Graphics and Sound\" discussed how to use functions like Plot and \
ListPlot to plot graphs of functions and data. Here, we discuss how \
Mathematica represents such graphics, and how you can program Mathematica to \
create more complicated images. The basic idea is that Mathematica represents \
all graphics in terms of a collection of graphics primitives. The primitives \
are objects like Point, Line and Polygon, that represent elements of a \
graphical image, as well as directives such as RGBColor and Thickness. This \
generates a plot of a list of points. ", "synonyms" -> {}, "title" -> 
    "The Structure of Graphics", "type" -> "Tutorial", "uri" -> 
    "tutorial/TheStructureOfGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.1"->{
  Cell[4021, 97, 89, 2, 70, "Title",
   CellTags->{"S2.10.1", "1.1"},
   CellID->11957]},
 "1.1"->{
  Cell[4021, 97, 89, 2, 70, "Title",
   CellTags->{"S2.10.1", "1.1"},
   CellID->11957]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.1", 47378, 1403},
 {"1.1", 47478, 1407}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3396, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4021, 97, 89, 2, 70, "Title",
 CellTags->{"S2.10.1", "1.1"},
 CellID->11957],
Cell[4113, 101, 706, 23, 70, "Text",
 CellID->15503],
Cell[4822, 126, 973, 35, 70, "Text",
 CellID->19491],
Cell[5798, 163, 82, 1, 70, "MathCaption",
 CellID->10482],
Cell[CellGroupData[{
Cell[5905, 168, 242, 8, 28, "Input",
 CellID->2829],
Cell[6150, 178, 691, 19, 141, "Output",
 CellID->173491428]
}, Open  ]],
Cell[6856, 200, 521, 16, 70, "MathCaption",
 CellID->13361],
Cell[CellGroupData[{
Cell[7402, 220, 100, 3, 28, "Input",
 CellID->952],
Cell[7505, 225, 674, 16, 194, "Output",
 CellID->2232728]
}, Open  ]],
Cell[8194, 244, 396, 11, 70, "Text",
 CellID->5646],
Cell[8593, 257, 839, 26, 70, "DefinitionBox",
 CellID->15183],
Cell[9435, 285, 126, 6, 70, "Caption",
 CellID->15597],
Cell[9564, 293, 585, 20, 70, "Text",
 CellID->11554],
Cell[10152, 315, 419, 12, 70, "Text",
 CellID->5945],
Cell[10574, 329, 374, 12, 70, "Text",
 CellID->20476],
Cell[10951, 343, 311, 11, 70, "MathCaption",
 CellID->281234861],
Cell[CellGroupData[{
Cell[11287, 358, 204, 6, 70, "Input",
 CellID->177299711],
Cell[11494, 366, 159, 5, 36, "Output",
 CellID->178853154]
}, Open  ]],
Cell[11668, 374, 284, 8, 70, "MathCaption",
 CellID->746158989],
Cell[CellGroupData[{
Cell[11977, 386, 241, 8, 70, "Input",
 CellID->681546501],
Cell[12221, 396, 120, 3, 70, "Print",
 CellID->25506308],
Cell[12344, 401, 159, 5, 36, "Output",
 CellID->262917273]
}, Open  ]],
Cell[12518, 409, 1822, 57, 70, "DefinitionBox",
 CellID->28224],
Cell[14343, 468, 63, 1, 70, "Caption",
 CellID->9081],
Cell[14409, 471, 254, 8, 70, "Text",
 CellID->307637545],
Cell[14666, 481, 363, 14, 70, "MathCaption",
 CellID->226535831],
Cell[CellGroupData[{
Cell[15054, 499, 423, 14, 47, "Input",
 CellID->102649177],
Cell[15480, 515, 2466, 44, 128, "Output",
 Evaluatable->False,
 CellID->375088423]
}, Open  ]],
Cell[17961, 562, 435, 14, 70, "MathCaption",
 CellID->976724534],
Cell[CellGroupData[{
Cell[18421, 580, 217, 7, 28, "Input",
 CellID->111366503],
Cell[18641, 589, 3316, 58, 128, "Output",
 Evaluatable->False,
 CellID->683354859]
}, Open  ]],
Cell[21972, 650, 98, 1, 70, "MathCaption",
 CellID->438438196],
Cell[CellGroupData[{
Cell[22095, 655, 342, 10, 28, "Input",
 CellID->778666741],
Cell[22440, 667, 2883, 51, 81, "Output",
 Evaluatable->False,
 CellID->22813381]
}, Open  ]],
Cell[25338, 721, 1398, 43, 70, "DefinitionBox",
 CellID->19654],
Cell[26739, 766, 77, 1, 70, "Caption",
 CellID->24652],
Cell[26819, 769, 653, 17, 70, "Text",
 CellID->23399],
Cell[27475, 788, 269, 8, 70, "MathCaption",
 CellID->28343],
Cell[CellGroupData[{
Cell[27769, 800, 631, 20, 70, "Input",
 CellID->22602],
Cell[28403, 822, 393, 10, 111, "Output",
 CellID->74714634]
}, Open  ]],
Cell[28811, 835, 211, 7, 70, "MathCaption",
 CellID->3282],
Cell[CellGroupData[{
Cell[29047, 846, 102, 3, 70, "Input",
 CellID->19989],
Cell[29152, 851, 401, 11, 114, "Output",
 CellID->304224854]
}, Open  ]],
Cell[29568, 865, 393, 14, 70, "MathCaption",
 CellID->28350],
Cell[CellGroupData[{
Cell[29986, 883, 320, 10, 70, "Input",
 CellID->30132],
Cell[30309, 895, 453, 11, 111, "Output",
 CellID->199610760]
}, Open  ]],
Cell[30777, 909, 342, 9, 70, "Text",
 CellID->22590],
Cell[31122, 920, 258, 8, 70, "MathCaption",
 CellID->29204],
Cell[CellGroupData[{
Cell[31405, 932, 152, 5, 70, "Input",
 CellID->32177],
Cell[31560, 939, 468, 12, 116, "Output",
 CellID->440226311]
}, Open  ]],
Cell[32043, 954, 251, 8, 70, "MathCaption",
 CellID->5319],
Cell[CellGroupData[{
Cell[32319, 966, 101, 3, 70, "Input",
 CellID->4750],
Cell[32423, 971, 481, 13, 146, "Output",
 CellID->389153061]
}, Open  ]],
Cell[32919, 987, 333, 9, 70, "Text",
 CellID->20228],
Cell[33255, 998, 934, 27, 70, "Text",
 CellID->5722],
Cell[34192, 1027, 849, 25, 70, "DefinitionBox",
 CellID->29668],
Cell[35044, 1054, 77, 1, 70, "Caption",
 CellID->8785],
Cell[35124, 1057, 396, 10, 70, "Text",
 CellID->23774],
Cell[35523, 1069, 55, 1, 70, "MathCaption",
 CellID->19184],
Cell[CellGroupData[{
Cell[35603, 1074, 415, 13, 28, "Input",
 CellID->6651],
Cell[36021, 1089, 2617, 47, 130, "Output",
 Evaluatable->False,
 CellID->238291373]
}, Open  ]],
Cell[38653, 1139, 316, 10, 70, "MathCaption",
 CellID->27037],
Cell[CellGroupData[{
Cell[38994, 1153, 135, 4, 70, "Input",
 CellID->10915],
Cell[39132, 1159, 434, 14, 36, "Output",
 CellID->617200719]
}, Open  ]],
Cell[39581, 1176, 622, 18, 70, "DefinitionBox",
 CellID->5850],
Cell[40206, 1196, 84, 1, 70, "Caption",
 CellID->4546],
Cell[40293, 1199, 840, 21, 70, "Text",
 CellID->29260],
Cell[41136, 1222, 67, 1, 70, "MathCaption",
 CellID->6427],
Cell[CellGroupData[{
Cell[41228, 1227, 246, 8, 70, "Input",
 CellID->22233],
Cell[41477, 1237, 553, 17, 146, "Output",
 CellID->175841016]
}, Open  ]],
Cell[42045, 1257, 271, 8, 70, "MathCaption",
 CellID->3161],
Cell[CellGroupData[{
Cell[42341, 1269, 202, 7, 70, "Input",
 CellID->27818],
Cell[42546, 1278, 513, 13, 102, "Output",
 CellID->3805341]
}, Open  ]],
Cell[CellGroupData[{
Cell[43096, 1296, 65, 1, 70, "TutorialMoreAboutSection",
 CellID->13339898],
Cell[43164, 1299, 151, 3, 70, "TutorialMoreAbout",
 CellID->498289123],
Cell[43318, 1304, 158, 3, 70, "TutorialMoreAbout",
 CellID->340465473],
Cell[43479, 1309, 154, 3, 70, "TutorialMoreAbout",
 CellID->8690014],
Cell[43636, 1314, 155, 3, 70, "TutorialMoreAbout",
 CellID->302762036]
}, Open  ]],
Cell[CellGroupData[{
Cell[43828, 1322, 72, 1, 70, "RelatedTutorialsSection",
 CellID->101498966],
Cell[43903, 1325, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717],
Cell[44107, 1332, 165, 4, 70, "RelatedTutorials",
 CellID->28810171]
}, Open  ]]
}, Open  ]],
Cell[44299, 1340, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

