(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45092,       1676]
NotebookOptionsPosition[     35491,       1378]
NotebookOutlinePosition[     39514,       1467]
CellTagsIndexPosition[     39419,       1461]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Textual Input and Output" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "The Syntax of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Language"
}], "Title",
 CellTags->{"S2.9.14", "14.1"},
 CellID->25726],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses various syntactic rules to interpret input that you give, and to \
convert strings and boxes into expressions. The version of these rules that \
is used for ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " in effect defines the basic ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. The rules used for other forms, such as ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", follow the same overall principles, but differ in many details."
}], "Text",
 CellID->23201],

Cell[BoxData[GridBox[{
   {
    RowBox[{
    "a", Cell[", ", "TableText"], "xyz", Cell[", ", "TableText"], "\[Alpha]", 
     "\[Beta]", "\[Gamma]"}], Cell["symbols", "TableText"]},
   {
    RowBox[{
    "\"\<some text\>\"", Cell[", ", "TableText"], "\"\<\>", "\[Alpha]", "+", 
     "\[Beta]", "\"\< \>"}], Cell["strings", "TableText"]},
   {
    RowBox[{"123.456", Cell[", ", "TableText"], "3*^45"}], Cell[
    "numbers", "TableText"]},
   {
    RowBox[{
    "+", Cell[", ", "TableText"], "->", Cell[", ", "TableText"], 
     "\[NotEqual]"}], Cell["operators", "TableText"]},
   {
    RowBox[{"(*", "comment", "*)"}], Cell[
    "input to be ignored", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->773],

Cell[TextData[{
 "Types of tokens in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. "
}], "Caption",
 CellID->25306],

Cell[TextData[{
 "When you give text as input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the first thing that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does is to break the text into a sequence of ",
 StyleBox["tokens",
  FontSlant->"Italic"],
 ", with each token representing a separate syntactic unit. "
}], "Text",
 CellID->3080],

Cell[TextData[{
 "Thus, for example, if you give the input ",
 Cell[BoxData[
  RowBox[{"xx", "+", "yy", "-", "zzzz"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will break this into the sequence of tokens ",
 Cell[BoxData["xx"], "InlineFormula"],
 ", ",
 Cell[BoxData["+"], "InlineFormula"],
 ", ",
 Cell[BoxData["yy"], "InlineFormula"],
 ", ",
 Cell[BoxData["-"], "InlineFormula"],
 " and ",
 Cell[BoxData["zzzz"], "InlineFormula"],
 ". Here ",
 Cell[BoxData["xx"], "InlineFormula"],
 ", ",
 Cell[BoxData["yy"], "InlineFormula"],
 " and ",
 Cell[BoxData["zzzz"], "InlineFormula"],
 " are tokens that correspond to symbols, while ",
 Cell[BoxData["+"], "InlineFormula"],
 " and ",
 Cell[BoxData["-"], "InlineFormula"],
 " are operators."
}], "Text",
 CellID->31593],

Cell[TextData[{
 "Operators are ultimately what determine the structure of the expression \
formed from a particular piece of input. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language involves several general classes of operators, distinguished by \
the different positions in which they appear with respect to their operands. \
"
}], "Text",
 CellID->23990],

Cell[BoxData[GridBox[{
   {Cell["prefix", "TableText"], 
    RowBox[{"!", 
     StyleBox["x", "TI"]}], 
    RowBox[{
     ButtonBox["Not",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Not"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {Cell["postfix", "TableText"], 
    RowBox[{
     StyleBox["x", "TI"], "!"}], 
    RowBox[{
     ButtonBox["Factorial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factorial"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {Cell["infix", "TableText"], 
    RowBox[{
     StyleBox["x", "TI"], "+", 
     StyleBox["y", "TI"], "+", 
     StyleBox["z", "TI"]}], 
    RowBox[{
     ButtonBox["Plus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plus"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "]"}]},
   {Cell["matchfix", "TableText"], 
    RowBox[{"{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "}"}], 
    RowBox[{
     ButtonBox["List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/List"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "]"}]},
   {Cell["compound", "TableText"], 
    RowBox[{
     StyleBox["x", "TI"], "/:", 
     StyleBox["y", "TI"], "=", 
     StyleBox["z", "TI"]}], 
    RowBox[{
     ButtonBox["TagSet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TagSet"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "]"}]},
   {Cell["overfix", "TableText"], 
    OverscriptBox[
     StyleBox["x", "TI"], "^"], Cell[TextData[{
     "OverHat",
     "[",
     StyleBox["x", "TI"],
     "]"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4591],

Cell[TextData[{
 "Examples of classes of operators in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. "
}], "Caption",
 CellID->24214],

Cell["\<\
Operators typically work by picking up operands from definite positions \
around them. But when a string contains more than one operator, the result \
can in general depend on which operator picks up its operands first. \
\>", "Text",
 CellID->3223],

Cell[TextData[{
 "Thus, for example, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "*", "b"}], "+", "c"}]], "InlineFormula"],
 " could potentially be interpreted either as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "*", "b"}], ")"}], "+", "c"}]], "InlineFormula"],
 " or as ",
 Cell[BoxData[
  RowBox[{"a", "*", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}]}]], "InlineFormula"],
 " depending on whether ",
 Cell[BoxData["*"], "InlineFormula"],
 " or ",
 Cell[BoxData["+"], "InlineFormula"],
 " picks up its operands first. "
}], "Text",
 CellID->5857],

Cell[TextData[{
 "To avoid such ambiguities, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assigns a ",
 StyleBox["precedence",
  FontSlant->"Italic"],
 " to each operator that can appear. Operators with higher precedence are \
then taken to pick up their operands first."
}], "Text",
 CellID->2700],

Cell[TextData[{
 "Thus, for example, the multiplication operator ",
 Cell[BoxData["*"], "InlineFormula"],
 " is assigned higher precedence than ",
 Cell[BoxData["+"], "InlineFormula"],
 ", so that it picks up its operands first, and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "*", "b"}], "+", "c"}]], "InlineFormula"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "*", "b"}], ")"}], "+", "c"}]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  RowBox[{"a", "*", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18849],

Cell[TextData[{
 "The ",
 Cell[BoxData["*"], "InlineFormula"],
 " operator has higher precedence than ",
 Cell[BoxData["+"], "InlineFormula"],
 ", so in both cases ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " is the innermost function. "
}], "MathCaption",
 CellID->2322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FullForm", "[", 
    RowBox[{
     RowBox[{"a", "*", "b"}], "+", "c"}], "]"}], ",", 
   RowBox[{"FullForm", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", "*", "c"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->13285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"Plus", "[", 
      RowBox[{
       RowBox[{"Times", "[", 
        RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Plus", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Times", "[", 
        RowBox[{"b", ",", "c"}], "]"}]}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->6762]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["//"], "InlineFormula"],
 " operator has rather low precedence. "
}], "MathCaption",
 CellID->2702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "*", "b"}], "+", "c"}], "//", "f"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->1268],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"a", " ", "b"}], "+", "c"}], "]"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->21374]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["@"], "InlineFormula"],
 " operator has high precedence. "
}], "MathCaption",
 CellID->5152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "@", "a"}], "*", "b"}], "+", "c"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->23848],

Cell[BoxData[
 RowBox[{"c", "+", 
  RowBox[{"b", " ", 
   RowBox[{"f", "[", "a", "]"}]}]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->29235]
}, Open  ]],

Cell["\<\
Whatever the precedence of the operators you are using, you can always \
specify the structure of the expressions you want to form by explicitly \
inserting appropriate parentheses.\
\>", "Text",
 CellID->28638],

Cell[TextData[{
 "Inserting parentheses makes ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " the innermost function. "
}], "MathCaption",
 CellID->22762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"a", "*", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->28237],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Plus", "[", 
      RowBox[{"b", ",", "c"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm= ",
 CellID->6272]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["Extensions of symbol names", "TableText"], Cell[TextData[{
     StyleBox["x", "TI"],
     StyleBox["_", "MR"],
     ", #2, ",
     StyleBox["e", "TI"],
     "::",
     StyleBox["s", "TI"],
     ",",
     "  ",
     "etc."
    }], "TableText"]},
   {Cell["Function application variants", "TableText"], Cell[TextData[{
     StyleBox["e", "TI"],
     "[",
     StyleBox["e", "TI"],
     "]",
     ", ",
     StyleBox["e", "TI"],
     "@@",
     StyleBox["e", "TI"],
     ",  etc."
    }], "TableText"]},
   {Cell["Power\[Hyphen]related operators", "TableText"], Cell[TextData[{
     "\[Sqrt]",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "^",
     StyleBox["e", "TI"],
     ",  etc."
    }], "TableText"]},
   {
    StyleBox[Cell["\<\
Multiplication\[Hyphen]related operators\
\>", "TableText"],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", 
    RowBox[{
     RowBox[{"\[Del]", 
      StyleBox["e", "TI"]}], Cell[", ", "TableText"], 
     RowBox[{
      StyleBox["e", "TI"], "/", 
      StyleBox["e", "TI"]}], Cell[", ", "TableText"], 
     RowBox[{
      StyleBox["e", "TI"], "\[CircleTimes]", Cell["e", "TableText"]}], 
     StyleBox[
      RowBox[{",", " "}], "TR"], 
     StyleBox["e", "TI"], 
     StyleBox["e", "TI"], Cell[",  etc.", "TableText"]}]},
   {Cell["Addition\[Hyphen]related operators", "TableText"], Cell[TextData[{
     StyleBox["e", "TI"],
     "\[CirclePlus]",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "+",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "\[Union]",
     StyleBox["e", "TI"],
     ",  etc."
    }], "TableText"]},
   {Cell["Relational operators", "TableText"], Cell[TextData[{
     StyleBox["e", "TI"],
     "==",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "\[Tilde]",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "\[NestedLessLess]",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "\[LeftTriangleBar]",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "\[Element]",
     StyleBox["e", "TI"],
     ",  etc."
    }], "TableText"]},
   {Cell["Arrow and vector operators", "TableText"], Cell[TextData[{
     StyleBox["e", "TI"],
     "\[LongRightArrow]",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "\[UpperRightArrow]",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "\[Equilibrium]",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "\[RightVectorBar]",
     StyleBox["e", "TI"],
     ",  etc."
    }], "TableText"]},
   {Cell["Logic operators", "TableText"], 
    RowBox[{
     SubscriptBox["\[ForAll]", 
      StyleBox["e", "TI"]], 
     StyleBox["e", "TI"], Cell[", ", "TableText"], 
     StyleBox["e", "TI"], "&&", 
     StyleBox["e", "TI"], Cell[", ", "TableText"], 
     StyleBox["e", "TI"], "\[Or]", 
     StyleBox["e", "TI"], Cell[", ", "TableText"], 
     StyleBox["e", "TI"], "\[RightTee]", 
     StyleBox["e", "TI"], Cell[",  etc.", "TableText"]}]},
   {Cell["Pattern and rule operators", "TableText"], Cell[TextData[{
     StyleBox["e", "TI"],
     "..",
     ", ",
     StyleBox["e", "TI"],
     "|",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "->",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     "/.",
     StyleBox["e", "TI"],
     ",  etc."
    }], "TableText"]},
   {Cell["Pure function operator", "TableText"], Cell[TextData[{
     StyleBox["e", "TI"],
     "&"
    }], "TableText"]},
   {Cell["Assignment operators", "TableText"], Cell[TextData[{
     StyleBox["e", "TI"],
     "=",
     StyleBox["e", "TI"],
     ", ",
     StyleBox["e", "TI"],
     ":=",
     StyleBox["e", "TI"],
     ",  etc."
    }], "TableText"]},
   {Cell["Compound expression", "TableText"], Cell[TextData[{
     StyleBox["e", "TI"],
     ";",
     StyleBox["e", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1792],

Cell["Outline of operators in order of decreasing precedence. ", "Caption",
 CellID->12200],

Cell[TextData[{
 "The table in\[NonBreakingSpace]\"",
 ButtonBox["Operator Input Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#23301"],
 "\" gives the complete ordering by precedence of all operators in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Much of this ordering, as in the case of ",
 Cell[BoxData["*"], "InlineFormula"],
 " and ",
 Cell[BoxData["+"], "InlineFormula"],
 ", is determined directly by standard mathematical usage. But in general the \
ordering is simply set up to make it less likely for explicit parentheses to \
have to be inserted in typical pieces of input. "
}], "Text",
 CellID->26343],

Cell["\<\
Operator precedences are such that this requires no parentheses. \
\>", "MathCaption",
 CellID->17519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["\[ForAll]", "x"], 
    RowBox[{
     SubscriptBox["\[Exists]", "y"], 
     RowBox[{
      RowBox[{"x", "\[CircleTimes]", "y"}], "\[Succeeds]", "y"}]}]}], 
   "\[And]", 
   RowBox[{"m", "\[NotEqual]", "0"}]}], "\[Implies]", 
  RowBox[{"n", "\[NotRightTriangleBar]", "m"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->7481],

Cell[BoxData[
 RowBox[{"Implies", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[ForAll]", "x"], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Exists]", "y"], 
       RowBox[{
        RowBox[{"x", "\[CircleTimes]", "y"}], "\[Succeeds]", "y"}]}], ")"}]}],
     "&&", 
    RowBox[{"m", "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"n", "\[NotRightTriangleBar]", "m"}]}], "]"}]], "Output",
 ImageSize->{247, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->3370]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " shows the structure of the expression that was constructed. "
}], "MathCaption",
 CellID->8991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->29145],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Implies", "[", 
    RowBox[{
     RowBox[{"And", "[", 
      RowBox[{
       RowBox[{"ForAll", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Exists", "[", 
          RowBox[{"y", ",", 
           RowBox[{"Succeeds", "[", 
            RowBox[{
             RowBox[{"CircleTimes", "[", 
              RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "]"}]}], 
        "]"}], ",", 
       RowBox[{"Unequal", "[", 
        RowBox[{"m", ",", "0"}], "]"}]}], "]"}], ",", 
     RowBox[{"NotRightTriangleBar", "[", 
      RowBox[{"n", ",", "m"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{555, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//FullForm= ",
 CellID->19984]
}, Open  ]],

Cell["\<\
Note that the first and second forms here are identical; the third requires \
explicit parentheses. \
\>", "MathCaption",
 CellID->12714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "->", 
     RowBox[{"#", "^", "2"}]}], "&"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "->", 
      RowBox[{"#", "^", "2"}]}], ")"}], "&"}], ",", 
   RowBox[{"x", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"#", "^", "2"}], "&"}], ")"}]}]}], "}"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->27085],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     SuperscriptBox["#1", "2"]}], "&"}], ",", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     SuperscriptBox["#1", "2"]}], "&"}], ",", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["#1", "2"], "&"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{214, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->30079]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["flat", "TableText"], 
    RowBox[{
     StyleBox["x", "TI"], "+", 
     StyleBox["y", "TI"], "+", 
     StyleBox["z", "TI"]}], Cell[TextData[{
     StyleBox["x", "TI"],
     "+",
     StyleBox["y", "TI"],
     "+",
     StyleBox["z", "TI"]
    }], "TableText"]},
   {Cell["left grouping", "TableText"], 
    RowBox[{
     StyleBox["x", "TI"], "/", 
     StyleBox["y", "TI"], "/", 
     StyleBox["z", "TI"]}], Cell[TextData[{
     "(",
     StyleBox["x", "TI"],
     "/",
     StyleBox["y", "TI"],
     ")",
     "/",
     StyleBox["z", "TI"]
    }], "TableText"]},
   {Cell["right grouping", "TableText"], 
    RowBox[{
     StyleBox["x", "TI"], "^", 
     StyleBox["y", "TI"], "^", 
     StyleBox["z", "TI"]}], Cell[TextData[{
     StyleBox["x", "TI"],
     "^",
     "(",
     StyleBox["y", "TI"],
     "^",
     StyleBox["z", "TI"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24399],

Cell["Types of grouping for infix operators. ", "Caption",
 CellID->16282],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " function, so no grouping is necessary here. "
}], "MathCaption",
 CellID->14386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->27119],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//FullForm= ",
 CellID->2650]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " is not ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ", so the operands have to be grouped in pairs. "
}], "MathCaption",
 CellID->12193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"a", "^", 
   RowBox[{"b", "^", 
    RowBox[{"c", "^", "d"}]}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->30185],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Power", "[", 
      RowBox[{"b", ",", 
       RowBox[{"Power", "[", 
        RowBox[{"c", ",", "d"}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]//FullForm= ",
 CellID->25516]
}, Open  ]],

Cell[TextData[{
 "The syntax of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language is defined not only for characters that you can type on a typical \
keyboard, but also for all the various special characters that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports. "
}], "Text",
 CellID->28608],

Cell[TextData[{
 "Letters such as ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalL]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Aleph]", TraditionalForm]], "InlineMath"],
 " from any alphabet are treated just like ordinary English letters, and can \
for example appear in the names of symbols. The same is true of letter\
\[Hyphen]like forms such as ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[HBar]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Angle]", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->17888],

Cell[TextData[{
 "But many other special characters are treated as operators. Thus, for \
example, ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[UnionPlus]", TraditionalForm]], "InlineMath"],
 " are infix operators, while ",
 Cell[BoxData[
  FormBox["\[Not]", TraditionalForm]], "InlineMath"],
 " is a prefix operator, and ",
 Cell[BoxData[
  FormBox["\[LeftAngleBracket]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[RightAngleBracket]", TraditionalForm]], "InlineMath"],
 " are matchfix operators."
}], "Text",
 CellID->9499],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " is an infix operator. "
}], "MathCaption",
 CellID->12425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "a", " ", "\[CirclePlus]", " ", "b", " ", "\[CirclePlus]", " ", "c"}], "//",
   "FullForm"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->26896],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"CirclePlus", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]//FullForm= ",
 CellID->27769]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Times]", TraditionalForm]], "InlineMath"],
 " is an infix operator which means the same as ",
 Cell[BoxData["*"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", " ", "\[Times]", " ", "a", " ", "\[Times]", " ", "a", " ", 
  "\[Times]", " ", "b", " ", "\[Times]", " ", "b", " ", "\[Times]", " ", 
  "c"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->9814],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "3"], " ", 
  SuperscriptBox["b", "2"], " ", "c"}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->11502]
}, Open  ]],

Cell[TextData[{
 "Some special characters form elements of fairly complicated compound \
operators. Thus, for example, ",
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 "\[ThinSpace]",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 "\[ThinSpace]",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 "\[ThinSpace]",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " contains the compound operator with elements ",
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->5970],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " form parts of a compound operator. "
}], "MathCaption",
 CellID->19537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", " ", 
   RowBox[{
    RowBox[{"k", "[", "x", "]"}], " ", 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "//", "FullForm"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->17598],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"k", "[", "x", "]"}], ",", "x"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//FullForm= ",
 CellID->31077]
}, Open  ]],

Cell[TextData[{
 "No parentheses are needed here: the \[OpenCurlyDoubleQuote]inner precedence\
\[CloseCurlyDoubleQuote] of ",
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " is lower than ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", " ", 
   RowBox[{
    RowBox[{"a", "[", "x", "]"}], " ", 
    RowBox[{"b", "[", "x", "]"}], " ", 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
  RowBox[{"c", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->6851],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "[", "x", "]"}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "x", "]"}], " ", 
     RowBox[{"b", "[", "x", "]"}]}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Output",
 ImageSize->{134, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->11888]
}, Open  ]],

Cell["Parentheses are needed here, however. ", "MathCaption",
 CellID->14463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", "x", "]"}], "+", 
      RowBox[{"b", "[", "x", "]"}]}], ")"}], " ", 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
  RowBox[{"c", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->29053],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "[", "x", "]"}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", "x", "]"}], "+", 
      RowBox[{"b", "[", "x", "]"}]}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Output",
 ImageSize->{158, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->3505]
}, Open  ]],

Cell[TextData[{
 "Input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be given not only in the form of one\[Hyphen]dimensional strings, but \
also in the form of two\[Hyphen]dimensional boxes. The syntax of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language covers not only one\[Hyphen]dimensional constructs but also two\
\[Hyphen]dimensional ones."
}], "Text",
 CellID->15741],

Cell["This superscript is interpreted as a power. ", "MathCaption",
 CellID->21267],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"a", "+", "b"}]]], "Input",
 CellLabel->"In[15]:= ",
 CellID->19662],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"a", "+", "b"}]]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->29655]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox["\[PartialD]", 
    StyleBox["x", "TI"]], 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " is a two\[Hyphen]dimensional compound operator. "
}], "MathCaption",
 CellID->14081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  SuperscriptBox["x", "n"]}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->9695],

Cell[BoxData[
 RowBox[{"n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->19618]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
 " is part of a more complicated two\[Hyphen]dimensional compound operator. "
}], "MathCaption",
 CellID->26872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"n", "=", "1"}], "\[Infinity]"], 
  FractionBox["1", 
   SuperscriptBox["n", "s"]]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->25094],

Cell[BoxData[
 RowBox[{"Zeta", "[", "s", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->19670]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
 " operator has higher precedence than ",
 Cell[BoxData["+"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n", "=", "1"}], "\[Infinity]"], 
   FractionBox["1", 
    SuperscriptBox["n", "s"]]}], "+", "n"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->7121],

Cell[BoxData[
 RowBox[{"n", "+", 
  RowBox[{"Zeta", "[", "s", "]"}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->1445]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->149675697],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->70288627],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->615522028],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->533778372]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Syntax of the Mathematica Language - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ConvertingBetweenStringsBoxesAndExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 49.6399966}", "context" -> "", 
    "keywords" -> {
     "`", "~~", ";;", "::", ">>>", "<>", ">>", "<<", "<=", "<", ">=", ">", 
      ";", "}", "{", "]]", "[[", "|", "||", "&&", "&", "___", "__", "_", ":", 
      "/=", "*=", "-=", "+=", "--", "++", "**", "##", "#", "/;", "//.", "/.", 
      "@@@", "@@", "//@", "/@", "@", "...", "..", "%%", "%", "=!=", "!=", 
      "===", "==", "/:", "^:=", "^=", "=.", ":=", "=", ":>", "->", "^^", "/", 
      "!!", "!", "??", "?", "(*", "*)", "//", "associativity", "atoms", 
      "binding of operators", "comments", "compound operators", "delimiters", 
      "flat operators", "grammar", "grammar of Mathematica", "grouping", 
      "infix operators", "integrals", "interpreting input", 
      "language specification", "leaf", "leaves", "Matchfix operators", 
      "operators", "Overfix operators", "Parenthesization", "parsing", 
      "Postfix operators", "precedence", "prefix operators", 
      "spatial grammar", "special characters", "syntax of Mathematica", 
      "tokens", "Twodimensional grammar", "units"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica uses various syntactic rules to interpret input that you \
give, and to convert strings and boxes into expressions. The version of these \
rules that is used for StandardForm and InputForm in effect defines the basic \
Mathematica language. The rules used for other forms, such as \
TraditionalForm, follow the same overall principles, but differ in many \
details. Types of tokens in the Mathematica language. When you give text as \
input to Mathematica, the first thing that Mathematica does is to break the \
text into a sequence of tokens, with each token representing a separate \
syntactic unit. ", "synonyms" -> {"2.9.14"}, "title" -> 
    "The Syntax of the Mathematica Language", "type" -> "Tutorial", "uri" -> 
    "tutorial/TheSyntaxOfTheMathematicaLanguage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.14"->{
  Cell[1270, 43, 161, 7, 70, "Title",
   CellTags->{"S2.9.14", "14.1"},
   CellID->25726]},
 "14.1"->{
  Cell[1270, 43, 161, 7, 70, "Title",
   CellTags->{"S2.9.14", "14.1"},
   CellID->25726]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.14", 39201, 1450},
 {"14.1", 39304, 1454}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 645, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1270, 43, 161, 7, 70, "Title",
 CellTags->{"S2.9.14", "14.1"},
 CellID->25726],
Cell[1434, 52, 859, 25, 70, "Text",
 CellID->23201],
Cell[2296, 79, 1015, 28, 70, "DefinitionBox",
 CellID->773],
Cell[3314, 109, 138, 6, 70, "Caption",
 CellID->25306],
Cell[3455, 117, 361, 12, 70, "Text",
 CellID->3080],
Cell[3819, 131, 801, 29, 70, "Text",
 CellID->31593],
Cell[4623, 162, 375, 9, 70, "Text",
 CellID->23990],
Cell[5001, 173, 2066, 70, 70, "DefinitionBox3Col",
 CellID->4591],
Cell[7070, 245, 155, 6, 70, "Caption",
 CellID->24214],
Cell[7228, 253, 259, 5, 70, "Text",
 CellID->3223],
Cell[7490, 260, 578, 21, 70, "Text",
 CellID->5857],
Cell[8071, 283, 308, 10, 70, "Text",
 CellID->2700],
Cell[8382, 295, 616, 21, 70, "Text",
 CellID->18849],
Cell[9001, 318, 345, 12, 70, "MathCaption",
 CellID->2322],
Cell[CellGroupData[{
Cell[9371, 334, 286, 10, 70, "Input",
 CellID->13285],
Cell[9660, 346, 720, 27, 36, "Output",
 CellID->6762]
}, Open  ]],
Cell[10395, 376, 138, 5, 70, "MathCaption",
 CellID->2702],
Cell[CellGroupData[{
Cell[10558, 385, 136, 5, 70, "Input",
 CellID->1268],
Cell[10697, 392, 229, 8, 36, "Output",
 CellID->21374]
}, Open  ]],
Cell[10941, 403, 131, 5, 70, "MathCaption",
 CellID->5152],
Cell[CellGroupData[{
Cell[11097, 412, 136, 5, 70, "Input",
 CellID->23848],
Cell[11236, 419, 229, 8, 36, "Output",
 CellID->29235]
}, Open  ]],
Cell[11480, 430, 221, 5, 70, "Text",
 CellID->28638],
Cell[11704, 437, 354, 13, 70, "MathCaption",
 CellID->22762],
Cell[CellGroupData[{
Cell[12083, 454, 173, 6, 70, "Input",
 CellID->28237],
Cell[12259, 462, 405, 15, 50, "Output",
 CellID->6272]
}, Open  ]],
Cell[12679, 480, 4512, 165, 70, "DefinitionBox",
 CellID->1792],
Cell[17194, 647, 91, 1, 70, "Caption",
 CellID->12200],
Cell[17288, 650, 651, 16, 70, "Text",
 CellID->26343],
Cell[17942, 668, 112, 3, 70, "MathCaption",
 CellID->17519],
Cell[CellGroupData[{
Cell[18079, 675, 387, 13, 70, "Input",
 CellID->7481],
Cell[18469, 690, 537, 18, 38, "Output",
 CellID->3370]
}, Open  ]],
Cell[19021, 711, 233, 7, 70, "MathCaption",
 CellID->8991],
Cell[CellGroupData[{
Cell[19279, 722, 101, 3, 70, "Input",
 CellID->29145],
Cell[19383, 727, 859, 28, 68, "Output",
 CellID->19984]
}, Open  ]],
Cell[20257, 758, 147, 4, 70, "MathCaption",
 CellID->12714],
Cell[CellGroupData[{
Cell[20429, 766, 389, 15, 70, "Input",
 CellID->27085],
Cell[20821, 783, 472, 17, 39, "Output",
 CellID->30079]
}, Open  ]],
Cell[21308, 803, 1238, 46, 70, "DefinitionBox3Col",
 CellID->24399],
Cell[22549, 851, 74, 1, 70, "Caption",
 CellID->16282],
Cell[22626, 854, 332, 12, 70, "MathCaption",
 CellID->14386],
Cell[CellGroupData[{
Cell[22983, 870, 144, 4, 70, "Input",
 CellID->27119],
Cell[23130, 876, 363, 13, 50, "Output",
 CellID->2650]
}, Open  ]],
Cell[23508, 892, 338, 12, 70, "MathCaption",
 CellID->12193],
Cell[CellGroupData[{
Cell[23871, 908, 173, 6, 70, "Input",
 CellID->30185],
Cell[24047, 916, 473, 17, 50, "Output",
 CellID->25516]
}, Open  ]],
Cell[24535, 936, 325, 10, 70, "Text",
 CellID->28608],
Cell[24863, 948, 723, 23, 70, "Text",
 CellID->17888],
Cell[25589, 973, 626, 19, 70, "Text",
 CellID->9499],
Cell[26218, 994, 153, 5, 70, "MathCaption",
 CellID->12425],
Cell[CellGroupData[{
Cell[26396, 1003, 181, 6, 70, "Input",
 CellID->26896],
Cell[26580, 1011, 361, 13, 50, "Output",
 CellID->27769]
}, Open  ]],
Cell[26956, 1027, 216, 7, 70, "MathCaption",
 CellID->25331],
Cell[CellGroupData[{
Cell[27197, 1038, 220, 5, 70, "Input",
 CellID->9814],
Cell[27420, 1045, 236, 8, 36, "Output",
 CellID->11502]
}, Open  ]],
Cell[27671, 1056, 685, 22, 70, "Text",
 CellID->5970],
Cell[28359, 1080, 262, 9, 70, "MathCaption",
 CellID->19537],
Cell[CellGroupData[{
Cell[28646, 1093, 220, 7, 70, "Input",
 CellID->17598],
Cell[28869, 1102, 381, 14, 50, "Output",
 CellID->31077]
}, Open  ]],
Cell[29265, 1119, 530, 18, 70, "MathCaption",
 CellID->5398],
Cell[CellGroupData[{
Cell[29820, 1141, 279, 9, 70, "Input",
 CellID->6851],
Cell[30102, 1152, 376, 13, 50, "Output",
 CellID->11888]
}, Open  ]],
Cell[30493, 1168, 77, 1, 70, "MathCaption",
 CellID->14463],
Cell[CellGroupData[{
Cell[30595, 1173, 325, 11, 70, "Input",
 CellID->29053],
Cell[30923, 1186, 403, 14, 50, "Output",
 CellID->3505]
}, Open  ]],
Cell[31341, 1203, 411, 11, 70, "Text",
 CellID->15741],
Cell[31755, 1216, 83, 1, 70, "MathCaption",
 CellID->21267],
Cell[CellGroupData[{
Cell[31863, 1221, 114, 4, 70, "Input",
 CellID->19662],
Cell[31980, 1227, 202, 7, 36, "Output",
 CellID->29655]
}, Open  ]],
Cell[32197, 1237, 233, 8, 70, "MathCaption",
 CellID->14081],
Cell[CellGroupData[{
Cell[32455, 1249, 140, 5, 70, "Input",
 CellID->9695],
Cell[32598, 1256, 246, 9, 36, "Output",
 CellID->19618]
}, Open  ]],
Cell[32859, 1268, 197, 5, 70, "MathCaption",
 CellID->26872],
Cell[CellGroupData[{
Cell[33081, 1277, 203, 7, 70, "Input",
 CellID->25094],
Cell[33287, 1286, 186, 6, 36, "Output",
 CellID->19670]
}, Open  ]],
Cell[33488, 1295, 213, 8, 70, "MathCaption",
 CellID->2538],
Cell[CellGroupData[{
Cell[33726, 1307, 229, 8, 70, "Input",
 CellID->7121],
Cell[33958, 1317, 208, 7, 36, "Output",
 CellID->1445]
}, Open  ]],
Cell[CellGroupData[{
Cell[34203, 1329, 72, 1, 70, "RelatedTutorialsSection",
 CellID->149675697],
Cell[34278, 1332, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]],
Cell[CellGroupData[{
Cell[34493, 1341, 97, 1, 70, "TutorialRelatedLinksSection",
 CellID->70288627],
Cell[34593, 1344, 414, 13, 70, "TutorialRelatedLinks",
 CellID->615522028],
Cell[35010, 1359, 427, 13, 70, "TutorialRelatedLinks",
 CellID->533778372]
}, Open  ]]
}, Open  ]],
Cell[35464, 1376, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

