(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     78363,       1765]
NotebookOptionsPosition[     70937,       1549]
NotebookOutlinePosition[     74629,       1633]
CellTagsIndexPosition[     74535,       1627]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Primitives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"], 
          "The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Primitives\"\>", 
       2->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"],
           "EdgeForm" :> Documentation`HelpLookup["paclet:ref/EdgeForm"], 
          "FaceForm" :> Documentation`HelpLookup["paclet:ref/FaceForm"], 
          "Lighting" :> Documentation`HelpLookup["paclet:ref/Lighting"], 
          "None" :> Documentation`HelpLookup["paclet:ref/None"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 
       2->"\<\"EdgeForm\"\>", 3->"\<\"FaceForm\"\>", 4->"\<\"Lighting\"\>", 
       5->"\<\"None\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Three\[Hyphen]Dimensional Graphics Directives\
\>", "Title",
 CellTags->{"S2.10.9", "9.1"},
 CellID->11149],

Cell["\<\
In three dimensions, just as in two dimensions, you can give various graphics \
directives to specify how the different elements in a graphics object should \
be rendered. \
\>", "Text",
 CellID->27277],

Cell["\<\
All the graphics directives for two dimensions also work in three dimensions. \
There are however some additional directives in three dimensions. \
\>", "Text",
 CellID->31826],

Cell[TextData[{
 "Just as in two dimensions, you can use the directives ",
 Cell[BoxData[
  ButtonBox["PointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PointSize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " how to render ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " elements. Note that in three dimensions, the lengths that appear in these \
directives are measured as fractions of the total width of the display area \
for your plot. "
}], "Text",
 CellID->29348],

Cell["\<\
This generates a list of 20 random points in three dimensions. \
\>", "MathCaption",
 CellID->1278],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Point", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", "]"}], ",", 
        RowBox[{"{", "3", "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", "20", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17777],

Cell["\<\
This displays the points, with each one being a circle whose diameter is 5% \
of the display area width. \
\>", "MathCaption",
 CellID->22338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"PointSize", "[", "0.05", "]"}], ",", "pts"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15175],

Cell[BoxData[
 Graphics3DBox[
  {PointSize[0.05], 
   Point3DBox[{0.05046021514546495, 0.6721670273991309, 0.9072787729656773}], 
   Point3DBox[{0.8561500047303312, 0.06612155347665793, 
    0.028936891721782265`}], 
   Point3DBox[{0.8522974188874646, 0.7406249214485014, 0.42687772899810317`}],
    Point3DBox[{0.24791906813938813`, 0.6891072818277661, 
    0.9669805442671626}], 
   Point3DBox[{0.9194374713981466, 0.24800823791496218`, 0.6330287854832288}],
    Point3DBox[{0.07046210430995159, 0.894476869084134, 0.6096045368478289}], 
   Point3DBox[{0.16191255153926942`, 0.5682796168458604, 0.9457529661977588}],
    Point3DBox[{0.45072791769468723`, 0.2161979320265608, 
    0.3233653377142227}], 
   Point3DBox[{0.43441825097664855`, 0.793211830981235, 0.6817674999311139}], 
   Point3DBox[{0.6422144234168867, 0.9286636973992815, 0.8710293736301589}], 
   Point3DBox[{0.3785304838284058, 0.8035961873546926, 0.6529471082877965}], 
   Point3DBox[{0.15224343178440436`, 0.1496568025101832, 0.2317873071108525}],
    Point3DBox[{0.7088528141569292, 0.8871677003298841, 
    0.28914544210446746`}], 
   Point3DBox[{0.7033182451902023, 0.5154580939435882, 0.09248409269417324}], 
   Point3DBox[{0.031839088484591827`, 0.5779019629602915, 0.975400021701023}],
    Point3DBox[{0.24888504023212543`, 0.4564034646776809, 0.732354146685928}],
    Point3DBox[{0.01861899844826187, 0.12886988735842264`, 
    0.21875986552794524`}], 
   Point3DBox[{0.8959310644410212, 0.43469708797524786`, 0.993711556166486}], 
   Point3DBox[{0.2731128308960331, 0.4437894087992247, 0.3623798790110764}], 
   Point3DBox[{0.15490552896337295`, 0.5119014750239503, 
    0.5262947341974897}]}]], "Output",
 ImageSize->{184, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->514026524,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "As in two dimensions, you can use ",
 Cell[BoxData[
  ButtonBox["AbsolutePointSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsolutePointSize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AbsoluteThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 " if you want to measure length in absolute units. "
}], "Text",
 CellID->6125],

Cell["\<\
This generates a line through 10 random points in three dimensions. \
\>", "MathCaption",
 CellID->139],

Cell[BoxData[
 RowBox[{
  RowBox[{"line", "=", 
   RowBox[{"Line", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", "]"}], ",", 
      RowBox[{"{", "10", "}"}], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->19821],

Cell["\<\
This shows the line dashed, with a thickness of 2 printer\[CloseCurlyQuote]s \
points. \
\>", "MathCaption",
 CellID->6340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
    RowBox[{"AbsoluteDashing", "[", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}], "]"}], ",", "line"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->3640],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[2], AbsoluteDashing[{5, 5}], 
   Line3DBox[{{0.49286792409205993`, 0.5206251628316636, 
    0.5429201950773195}, {0.10734440710814952`, 0.2062923837384889, 
    0.21798672343109882`}, {0.8405241901888523, 0.5161129879831614, 
    0.40792692369950956`}, {0.09113535740543499, 0.887455923279717, 
    0.7227462410086949}, {0.8968565463296292, 0.2655061000885717, 
    0.9539959668639955}, {0.09005626420865154, 0.38681018519953114`, 
    0.8156684543110093}, {0.20659947443059146`, 0.17957711482620087`, 
    0.6231211434420711}, {0.8440133505663501, 0.5133380811887074, 
    0.2971722009410931}, {0.908330324873619, 0.47893824307306976`, 
    0.8288799463873153}, {0.5216500541886344, 0.21278791929469243`, 
    0.06738688686913696}}]}]], "Output",
 ImageSize->{184, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->93741035,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " objects, the color specification directives also work the same in three \
dimensions as in two dimensions. For ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " objects, however, they can work differently. "
}], "Text",
 CellID->29081],

Cell[TextData[{
 "In two dimensions, polygons are always assumed to have an intrinsic color, \
specified directly by graphics directives such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 ". In three dimensions, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " generates colors for polygons using a more physical approach based on \
simulated illumination. Polygons continue to have an intrinsic color defined \
by color directives, but the final color observed when rendering the graphic \
may be different based upon the values of the lights shining on the polygon. \
Polygons are intrinsically white by default."
}], "Text",
 CellID->8148],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Lighting",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Lighting"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], Cell[
    "use default light placements and values", "TableText"]},
   {
    RowBox[{
     ButtonBox["Lighting",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Lighting"], "->", 
     ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"]}], Cell[
    "disable all lights", "TableText"]},
   {
    RowBox[{
     ButtonBox["Lighting",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Lighting"], "->", "\"\<Neutral\>\""}], Cell[
    "lighting using only white light sources", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17547],

Cell["Some schemes for coloring polygons in three dimensions. ", "Caption",
 CellID->9951],

Cell["\<\
This draws an icosahedron with default lighting. The intrinsic color value of \
the polygons is white.\
\>", "MathCaption",
 CellID->299518562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->543622575],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
     0, 0, 5 (50 - 10 5^Rational[1, 2])^
       Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
      0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
       Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
      Rational[-1, 2]}, {
     Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
       5^Rational[1, 2]), 
      Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
       5^Rational[1, 2]), Rational[
      1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
       5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
      Rational[-1, 2]}, {
     Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
       5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
      Rational[-1, 2]}, {
     Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
       5^Rational[1, 2]), 
      Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
       Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
       5^Rational[1, 2]), 
      Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
       Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
       5^Rational[1, 2]), 
      Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
       Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
       5^Rational[1, 2]), 
      Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
       Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
     0, 0, -0.9510565162951536}, {
     0, 0, 0.9510565162951536}, {-0.85065080835204, 
      0, -0.42532540417601994`}, {
     0.85065080835204, 0, 0.42532540417601994`}, {
     0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
     0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
     0.42532540417601994`}, {-0.6881909602355868, 0.5, 
     0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
     0.8090169943749475, -0.42532540417601994`}, {
     0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
     0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
   Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 12}, {
    5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 8}, {8, 
    3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 12,
     6}, {3, 8, 10}, {9, 7, 3}}]]]], "Output",
 ImageSize->{184, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->392369743,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
This draws the icosahedron using the same lighting parameters, but defines \
the intrinsic color value of the polygons to be gray. \
\>", "MathCaption",
 CellID->3110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->6557],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], 
   GraphicsComplex3DBox[
    NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
      0, 0, 5 (50 - 10 5^Rational[1, 2])^
        Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
       0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
        Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[
       1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
      0, 0, -0.9510565162951536}, {
      0, 0, 0.9510565162951536}, {-0.85065080835204, 
       0, -0.42532540417601994`}, {
      0.85065080835204, 0, 0.42532540417601994`}, {
      0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
      0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
      0.42532540417601994`}, {-0.6881909602355868, 0.5, 
      0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
      0.8090169943749475, -0.42532540417601994`}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
      0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
    Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 12}, {
     5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 8}, {8, 
     3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 
     12, 6}, {3, 8, 10}, {9, 7, 3}}]]}]], "Output",
 ImageSize->{184, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->586303875,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "The intrinsic color value of the polygons becomes more obvious when using \
the ",
 Cell[BoxData["\"\<Neutral\>\""], "InlineFormula"],
 " lighting scheme. "
}], "MathCaption",
 CellID->2867777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Gray", ",", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->171011247],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.5], 
   GraphicsComplex3DBox[
    NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
      0, 0, 5 (50 - 10 5^Rational[1, 2])^
        Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
       0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
        Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[
       1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
      0, 0, -0.9510565162951536}, {
      0, 0, 0.9510565162951536}, {-0.85065080835204, 
       0, -0.42532540417601994`}, {
      0.85065080835204, 0, 0.42532540417601994`}, {
      0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
      0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
      0.42532540417601994`}, {-0.6881909602355868, 0.5, 
      0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
      0.8090169943749475, -0.42532540417601994`}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
      0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
    Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 12}, {
     5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 8}, {8, 
     3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 
     12, 6}, {3, 8, 10}, {9, 7, 3}}]]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{184, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->379848954,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
This applies the gray color only to the line, which is not affected by the \
lights.\
\>", "MathCaption",
 CellID->168563962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}], ",", 
    "Gray", ",", 
    RowBox[{"Thickness", "[", "0.1", "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->801613034],

Cell[BoxData[
 Graphics3DBox[{
   GraphicsComplex3DBox[
    NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
      0, 0, 5 (50 - 10 5^Rational[1, 2])^
        Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
       0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
        Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[
       1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
      0, 0, -0.9510565162951536}, {
      0, 0, 0.9510565162951536}, {-0.85065080835204, 
       0, -0.42532540417601994`}, {
      0.85065080835204, 0, 0.42532540417601994`}, {
      0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
      0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
      0.42532540417601994`}, {-0.6881909602355868, 0.5, 
      0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
      0.8090169943749475, -0.42532540417601994`}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
      0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
    Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 12}, {
     5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 8}, {8, 
     3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 
     12, 6}, {3, 8, 10}, {9, 7, 3}}]], 
   {GrayLevel[0.5], Thickness[0.1], 
    Line3DBox[{{0, 0, -2}, {0, 0, 2}}]}}]], "Output",
 ImageSize->{122, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->344409398,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
As with two-dimensional directives, the color directive can be scoped to the \
line by using a sublist.\
\>", "MathCaption",
 CellID->49663631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{"Thickness", "[", "0.1", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    ",", 
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->824694],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.5], Thickness[0.1], Line3DBox[{{0, 0, -2}, {0, 0, 2}}]}, 
   GraphicsComplex3DBox[
    NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
      0, 0, 5 (50 - 10 5^Rational[1, 2])^
        Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
       0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
        Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[
       1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
        5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
      Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
      0, 0, -0.9510565162951536}, {
      0, 0, 0.9510565162951536}, {-0.85065080835204, 
       0, -0.42532540417601994`}, {
      0.85065080835204, 0, 0.42532540417601994`}, {
      0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
      0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
      0.42532540417601994`}, {-0.6881909602355868, 0.5, 
      0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
      0.8090169943749475, -0.42532540417601994`}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
      0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
    Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 12}, {
     5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 8}, {8, 
     3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 
     12, 6}, {3, 8, 10}, {9, 7, 3}}]]}]], "Output",
 ImageSize->{122, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->491662,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EdgeForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EdgeForm"], "[", "]"}], Cell[
    "draw no lines at the edges of polygons", "TableText"]},
   {
    RowBox[{
     ButtonBox["EdgeForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EdgeForm"], "[", 
     StyleBox["g", "TI"], "]"}], Cell[TextData[{
     "use the graphics directives ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " to determine how to draw lines at the edges of polygons"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15454],

Cell["Giving graphics directives for all the edges of polygons. ", "Caption",
 CellID->369],

Cell[TextData[{
 "When you render a three\[Hyphen]dimensional graphics object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", there are two kinds of lines that can appear. The first kind are lines \
from explicit ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " primitives that you included in the graphics object. The second kind are \
lines that were generated as the edges of polygons. "
}], "Text",
 CellID->11906],

Cell[TextData[{
 "You can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " how to render all lines of the second kind by giving a list of graphics \
directives inside ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->32485],

Cell["\<\
This renders a dodecahedron with its edges shown as thick gray lines. \
\>", "MathCaption",
 CellID->24999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<Dodecahedron\>\"", ",", "\"\<Faces\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->28048],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->46861723]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FaceForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FaceForm"], "[", 
     StyleBox["gfront", "TI"], ",", 
     StyleBox["gback", "TI"], "]"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["gfront", "TI"]], "InlineFormula"],
     " graphics directives for the front face of each polygon, and ",
     Cell[BoxData[
      StyleBox["gback", "TI"]], "InlineFormula"],
     " for the back"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->573],

Cell["Rendering the fronts and backs of polygons differently. ", "Caption",
 CellID->26658],

Cell[TextData[{
 "An important aspect of polygons in three dimensions is that they have both \
front and back faces. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the following convention to define the \[OpenCurlyDoubleQuote]front \
face\[CloseCurlyDoubleQuote] of a polygon: if you look at a polygon from the \
front, then the corners of the polygon will appear counterclockwise, when \
taken in the order that you specified them. "
}], "Text",
 CellID->25816],

Cell["\<\
This makes the front (outside) face of each polygon mostly transparent, and \
the back (inside) face fully opaque. \
\>", "MathCaption",
 CellID->15791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FaceForm", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Opacity", "[", "0.3", "]"}], "}"}], ",", "White"}], "]"}], 
    ",", 
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<Cube\>\"", ",", "\"\<Faces\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[47]:=",
 CellID->25422],

Cell[BoxData[
 Graphics3DBox[
  {FaceForm[Opacity[0.3], GrayLevel[1]], 
   GraphicsComplex3DBox[
    NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[
       1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
     0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5, 
     0.5, -0.5}, {0.5, 0.5, 0.5}}], 
    Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {1, 
     3, 7, 5}, {2, 1, 5, 6}}]]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->804095886,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->367207367],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "RelatedTutorials",
 CellID->215572698],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Three-Dimensional Graphics Directives - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CoordinateSystemsForThreeDimensionalGraphics"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 51.1869112}", "context" -> "", 
    "keywords" -> {
     "AbsoluteDashing", "AbsolutePointSize", "AbsoluteThickness", 
      "backs of polygons", "borders of polygons in three dimensions", "color",
       "dashing", "EdgeForm", "exterior faces of three-dimensional objects", 
      "FaceForm", "faces", "fronts of polygons", "graphics directives", 
      "icosahedron", "illumination", "insides of three-dimensional objects", 
      "interior faces of three-dimensional objects", "lighting", "line", 
      "lines", "orientation", "point", "points", "PointSize", "polygons", 
      "polyhedra", "seams between polygons in three dimensions", "shading", 
      "thickness", "three-dimensional graphics"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In three dimensions, just as in two dimensions, you can give various \
graphics directives to specify how the different elements in a graphics \
object should be rendered. All the graphics directives for two dimensions \
also work in three dimensions. There are however some additional directives \
in three dimensions. Just as in two dimensions, you can use the directives \
PointSize, Thickness and Dashing to tell Mathematica how to render Point and \
Line elements. Note that in three dimensions, the lengths that appear in \
these directives are measured as fractions of the total width of the display \
area for your plot. ", "synonyms" -> {}, "title" -> 
    "Three-Dimensional Graphics Directives", "type" -> "Tutorial", "uri" -> 
    "tutorial/ThreeDimensionalGraphicsDirectives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.9"->{
  Cell[2469, 68, 117, 4, 70, "Title",
   CellTags->{"S2.10.9", "9.1"},
   CellID->11149]},
 "9.1"->{
  Cell[2469, 68, 117, 4, 70, "Title",
   CellTags->{"S2.10.9", "9.1"},
   CellID->11149]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.9", 74320, 1616},
 {"9.1", 74421, 1620}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1844, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2469, 68, 117, 4, 70, "Title",
 CellTags->{"S2.10.9", "9.1"},
 CellID->11149],
Cell[2589, 74, 212, 5, 70, "Text",
 CellID->27277],
Cell[2804, 81, 186, 4, 70, "Text",
 CellID->31826],
Cell[2993, 87, 969, 33, 70, "Text",
 CellID->29348],
Cell[3965, 122, 109, 3, 70, "MathCaption",
 CellID->1278],
Cell[4077, 127, 359, 12, 70, "Input",
 CellID->17777],
Cell[4439, 141, 152, 4, 70, "MathCaption",
 CellID->22338],
Cell[CellGroupData[{
Cell[4616, 149, 195, 7, 28, "Input",
 CellID->15175],
Cell[4814, 158, 5030, 87, 223, 1684, 28, "CachedBoxData", "BoxData", "Output",
 
 CellID->514026524]
}, Open  ]],
Cell[9859, 248, 559, 18, 70, "Text",
 CellID->6125],
Cell[10421, 268, 113, 3, 70, "MathCaption",
 CellID->139],
Cell[10537, 273, 302, 10, 70, "Input",
 CellID->19821],
Cell[10842, 285, 133, 4, 70, "MathCaption",
 CellID->6340],
Cell[CellGroupData[{
Cell[11000, 293, 307, 10, 70, "Input",
 CellID->3640],
Cell[11310, 305, 4648, 81, 225, 798, 13, "CachedBoxData", "BoxData", "Output",
 
 CellID->93741035]
}, Open  ]],
Cell[15973, 389, 570, 19, 70, "Text",
 CellID->29081],
Cell[16546, 410, 864, 21, 70, "Text",
 CellID->8148],
Cell[17413, 433, 1081, 33, 70, "DefinitionBox",
 CellID->17547],
Cell[18497, 468, 90, 1, 70, "Caption",
 CellID->9951],
Cell[18590, 471, 153, 4, 70, "MathCaption",
 CellID->299518562],
Cell[CellGroupData[{
Cell[18768, 479, 230, 7, 70, "Input",
 CellID->543622575],
Cell[19001, 488, 7433, 129, 228, 2988, 52, "CachedBoxData", "BoxData", \
"Output",
 CellID->392369743]
}, Open  ]],
Cell[26449, 620, 177, 4, 70, "MathCaption",
 CellID->3110],
Cell[CellGroupData[{
Cell[26651, 628, 254, 8, 70, "Input",
 CellID->6557],
Cell[26908, 638, 7488, 130, 228, 3059, 53, "CachedBoxData", "BoxData", \
"Output",
 CellID->586303875]
}, Open  ]],
Cell[34411, 771, 211, 6, 70, "MathCaption",
 CellID->2867777],
Cell[CellGroupData[{
Cell[34647, 781, 338, 10, 70, "Input",
 CellID->171011247],
Cell[34988, 793, 7503, 131, 228, 3082, 54, "CachedBoxData", "BoxData", \
"Output",
 CellID->379848954]
}, Open  ]],
Cell[42506, 927, 135, 4, 70, "MathCaption",
 CellID->168563962],
Cell[CellGroupData[{
Cell[42666, 935, 569, 18, 70, "Input",
 CellID->801613034],
Cell[43238, 955, 6849, 120, 237, 3119, 54, "CachedBoxData", "BoxData", \
"Output",
 CellID->344409398]
}, Open  ]],
Cell[50102, 1078, 153, 4, 70, "MathCaption",
 CellID->49663631],
Cell[CellGroupData[{
Cell[50280, 1086, 625, 20, 70, "Input",
 CellID->824694],
Cell[50908, 1108, 6841, 119, 237, 3114, 53, "CachedBoxData", "BoxData", \
"Output",
 CellID->491662]
}, Open  ]],
Cell[57764, 1230, 882, 26, 70, "DefinitionBox",
 CellID->15454],
Cell[58649, 1258, 91, 1, 70, "Caption",
 CellID->369],
Cell[58743, 1261, 497, 13, 70, "Text",
 CellID->11906],
Cell[59243, 1276, 333, 12, 70, "Text",
 CellID->32485],
Cell[59579, 1290, 117, 3, 70, "MathCaption",
 CellID->24999],
Cell[CellGroupData[{
Cell[59721, 1297, 430, 13, 47, "Input",
 CellID->28048],
Cell[60154, 1312, 3864, 67, 229, "Output",
 Evaluatable->False,
 CellID->46861723]
}, Open  ]],
Cell[64033, 1382, 812, 24, 70, "DefinitionBox",
 CellID->573],
Cell[64848, 1408, 91, 1, 70, "Caption",
 CellID->26658],
Cell[64942, 1411, 475, 10, 70, "Text",
 CellID->25816],
Cell[65420, 1423, 162, 4, 70, "MathCaption",
 CellID->15791],
Cell[CellGroupData[{
Cell[65607, 1431, 385, 13, 70, "Input",
 CellID->25422],
Cell[65995, 1446, 4368, 78, 216, 866, 16, "CachedBoxData", "BoxData", \
"Output",
 CellID->804095886]
}, Open  ]],
Cell[CellGroupData[{
Cell[70400, 1529, 72, 1, 70, "RelatedTutorialsSection",
 CellID->367207367],
Cell[70475, 1532, 204, 4, 70, "RelatedTutorials",
 CellID->215572698],
Cell[70682, 1538, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[70910, 1547, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

