(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    164397,       3315]
NotebookOptionsPosition[    157381,       3104]
NotebookOutlinePosition[    160512,       3180]
CellTagsIndexPosition[    160416,       3174]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"], 
          "The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>", 
       2->"\<\"The Structure of Graphics and Sound\"\>", 
       3->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cuboid" :> Documentation`HelpLookup["paclet:ref/Cuboid"], 
          "Cylinder" :> Documentation`HelpLookup["paclet:ref/Cylinder"], 
          "Graphics Primitives For Text" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsPrimitivesForText"], "Line" :> 
          Documentation`HelpLookup["paclet:ref/Line"], "Point" :> 
          Documentation`HelpLookup["paclet:ref/Point"], "Polygon" :> 
          Documentation`HelpLookup["paclet:ref/Polygon"], "Sphere" :> 
          Documentation`HelpLookup["paclet:ref/Sphere"], "Text" :> 
          Documentation`HelpLookup["paclet:ref/Text"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cuboid\"\>", 2->"\<\"Cylinder\"\>", 
       3->"\<\"Graphics Primitives For Text\"\>", 4->"\<\"Line\"\>", 
       5->"\<\"Point\"\>", 6->"\<\"Polygon\"\>", 7->"\<\"Sphere\"\>", 
       8->"\<\"Text\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Three\[Hyphen]Dimensional Graphics Primitives\
\>", "Title",
 CellTags->{"S2.10.8", "8.1"},
 CellID->32364],

Cell[TextData[{
 "One of the most powerful aspects of graphics in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the availability of three\[Hyphen]dimensional as well as \
two\[Hyphen]dimensional graphics primitives. By combining \
three\[Hyphen]dimensional graphics primitives, you can represent and render \
three\[Hyphen]dimensional objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->568],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Point",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Point"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "}", "]"}], Cell[TextData[{
     "point with coordinates ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Line",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Line"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "line through the points ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], "1"]], "InlineFormula"],
     "}",
     StyleBox[", ", "TR"],
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "2"]], "InlineFormula"],
     Cell[BoxData[","], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "2"]], "InlineFormula"],
     Cell[BoxData[","], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], "2"]], "InlineFormula"],
     Cell[BoxData["}"], "InlineFormula"],
     ", \[Ellipsis]"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Polygon",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Polygon"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "filled polygon with the specified list of corners", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cuboid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cuboid"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["min", "TI"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell["cuboid", "TableText"]},
   {
    RowBox[{
     ButtonBox["Text",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Text"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "}", "]"}], Cell[TextData[{
     "text at position ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"], "}"}]], "InlineFormula"],
     " (see \"",
     ButtonBox["Graphics Primitives For Text",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/GraphicsPrimitivesForText"],
     "\")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5994],

Cell["\<\
Three\[Hyphen]dimensional graphics elements. \
\>", "Caption",
 CellID->579],

Cell[TextData[{
 "Every time you evaluate ",
 Cell[BoxData["rcoord"], "InlineFormula"],
 ", it generates a random coordinate in three dimensions. "
}], "MathCaption",
 CellID->24023],

Cell[BoxData[
 RowBox[{"rcoord", ":=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1.", ",", 
    RowBox[{"{", "3", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[51]:=",
 CellID->25709],

Cell["\<\
This generates a list of 20 random points in three\[Hyphen]dimensional space. \
\
\>", "MathCaption",
 CellID->31657],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Point", "[", "rcoord", "]"}], ",", 
     RowBox[{"{", "20", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->4141],

Cell["Here is a plot of the points. ", "MathCaption",
 CellID->29285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", "pts", "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->8477],

Cell[BoxData[
 Graphics3DBox[{
   Point3DBox[{0.21889961999372987`, 0.7575668767421109, 0.9520911158762673}],
    Point3DBox[{0.05494858366400357, 0.394957873006861, 0.8931681355425047}], 
   Point3DBox[{0.8948478842365986, 0.6997270804133582, 0.2514238311832431}], 
   Point3DBox[{0.3696837583635877, 0.6581065276116247, 0.9818359575308913}], 
   Point3DBox[{0.8811891757548149, 0.7819032792687759, 0.29383683381826087`}],
    Point3DBox[{0.7296106155355904, 0.04771899921110512, 0.9521111756383969}],
    Point3DBox[{0.85546467383257, 0.5752958787238187, 0.01741576811871348}], 
   Point3DBox[{0.951235656419416, 0.10299304769802653`, 0.1388978724705463}], 
   Point3DBox[{0.059745613473030534`, 0.23263913093954502`, 
    0.6820332347708289}], 
   Point3DBox[{0.2940354814945325, 0.7132758972292073, 0.7755564655024989}], 
   Point3DBox[{0.4257057463887475, 0.3903874330282595, 0.8374535127825815}], 
   Point3DBox[{0.18123277407714977`, 0.2150288586250817, 0.6493662010965673}],
    Point3DBox[{0.3311635201302312, 0.314073693870228, 0.9077858263178302}], 
   Point3DBox[{0.7818376331363124, 0.09184120671941343, 0.6712964326084507}], 
   Point3DBox[{0.6708999565997775, 0.29980885813321523`, 0.3789008745658582}],
    Point3DBox[{0.2874650842524322, 0.8204743637030949, 0.9208885959601558}], 
   Point3DBox[{0.21002408803307593`, 0.5458771190752438, 0.8852418007307943}],
    Point3DBox[{0.5448101206812443, 0.11732331264555373`, 
    0.48476443359256804`}], 
   Point3DBox[{0.6118477356732392, 0.5673314529683569, 0.42312244244744934`}],
    Point3DBox[{0.7145748476556615, 0.2412496558357322, 
    0.7053625024757382}]}]], "Output",
 ImageSize->{184, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->115810351,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
This gives a plot showing a line through 10 random points in three \
dimensions. \
\>", "MathCaption",
 CellID->27272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Line", "[", 
   RowBox[{"Table", "[", 
    RowBox[{"rcoord", ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->8828],

Cell[BoxData[
 Graphics3DBox[
  Line3DBox[{{0.49792121655715005`, 0.6867438902728671, 
   0.37011862570147747`}, {0.36273563076585935`, 0.08015688102683605, 
   0.7372992881775509}, {0.8380873007535246, 0.2516404094252571, 
   0.6808265229207502}, {0.703791314365118, 0.7949242010122781, 
   0.4708328627884544}, {0.5604808665463015, 0.06804229953068952, 
   0.10175953352025902`}, {0.5437604931135842, 0.7241073104486562, 
   0.724287367418625}, {0.8792931438836957, 0.7976974865876216, 
   0.7433101386980185}, {0.3439842450327977, 0.7107104912011166, 
   0.9273775232637047}, {0.18918970278328784`, 0.6748969379626244, 
   0.45116244143109996`}, {0.2625738601931973, 0.898133875078323, 
   0.12473389986520722`}}]]], "Output",
 ImageSize->{184, 212},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->22528878,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "If you give a list of graphics elements in two dimensions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " simply draws each element in turn, with later elements obscuring earlier \
ones. In three dimensions, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " collects together all the graphics elements you specify, then displays \
them as three\[Hyphen]dimensional objects, with the ones in front in three\
\[Hyphen]dimensional space obscuring those behind. "
}], "Text",
 CellID->13549],

Cell[TextData[{
 "Every time you evaluate ",
 Cell[BoxData["rantri"], "InlineFormula"],
 ", it generates a random triangle in three\[Hyphen]dimensional space. "
}], "MathCaption",
 CellID->12517],

Cell[BoxData[
 RowBox[{"rantri", ":=", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{"rcoord", ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[55]:=",
 CellID->9009],

Cell["This draws a single random triangle. ", "MathCaption",
 CellID->27743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", "rantri", "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->30867],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[{{0.40366556676779375`, 0.17343191407105785`, 
   0.7223808805975236}, {0.43380095405263175`, 0.3966695514435954, 
   0.05501710244473257}, {0.8093213790457661, 0.45193632958075436`, 
   0.18421156149986295`}}]]], "Output",
 ImageSize->{150, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[57]=",
 CellID->670477397,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
This draws a collection of 5 random triangles. The triangles in front obscure \
those behind. \
\>", "MathCaption",
 CellID->21590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"rantri", ",", 
    RowBox[{"{", "5", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[58]:=",
 CellID->12891],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[{{0.7655605401692447, 0.07640555602916699, 
    0.5197682037034657}, {0.3416295121394348, 0.2955692644150034, 
    0.6012213298929383}, {0.3619867530547114, 0.24028707309015096`, 
    0.0704910479818357}}], 
   Polygon3DBox[{{0.3319370856508932, 0.18106748222835511`, 
    0.33089742572574066`}, {0.08682142224110012, 0.6227907077351467, 
    0.5118156496034898}, {0.18046614598453825`, 0.12807616484373296`, 
    0.9016016568878094}}], 
   Polygon3DBox[{{0.07357538449259438, 0.6607996071275466, 
    0.4335985097077497}, {0.9852631092163129, 0.46126626753120337`, 
    0.9566788941939846}, {0.25292813161181416`, 0.06158378073577442, 
    0.15520631612592872`}}], 
   Polygon3DBox[{{0.3391876466470729, 0.21603356373040739`, 
    0.818294718783948}, {0.4017821391229355, 0.07658295578036256, 
    0.8365739916798851}, {0.9792519773284722, 0.35035623380845315`, 
    0.1440048015478732}}], 
   Polygon3DBox[{{0.2511978253060929, 0.47624227261703367`, 
    0.8451015265650874}, {0.14014750942260412`, 0.6645342741617544, 
    0.887550144467977}, {0.0268633547464463, 0.2615395572676422, 
    0.009102553240460498}}]}]], "Output",
 ImageSize->{184, 196},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[58]=",
 CellID->559139824,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "By creating an appropriate list of polygons, you can build up any three\
\[Hyphen]dimensional object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Thus, for example, all the surfaces produced by ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " are represented essentially as lists of polygons. "
}], "Text",
 CellID->1538],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Point",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Point"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}], "]"}], Cell[
    TextData[{
     "a multipoint consisting of points at ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Line",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Line"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["line", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["line", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}], "]"}], Cell[
    TextData[{
     "a multiline consisting of lines ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["line", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["line", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Polygon",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Polygon"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}], "]"}], Cell[
    TextData[{
     "a multipolygon consisting of polygons ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4706875],

Cell["Primitives which can take multiple elements. ", "Caption",
 CellID->82696337],

Cell["\<\
As with the two-dimensional primitives, some three-dimensional graphics \
primitives have multi-coordinate forms which are a more efficient \
representation. When dealing with a very large number of primitives, using \
these multi-coordinate forms where possible can both reduce the memory \
footprint of the resulting graphic and make it render much more quickly.\
\>", "Text",
 CellID->491473416],

Cell[TextData[{
 Cell[BoxData["rantricoords"], "InlineFormula"],
 " defines merely the coordinates of a random triangle."
}], "MathCaption",
 CellID->148366640],

Cell[BoxData[
 RowBox[{"rantricoords", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{"rcoord", ",", 
    RowBox[{"{", "3", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[59]:=",
 CellID->423261710],

Cell[TextData[{
 "Using the multi-coordinate form of ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 ", this efficiently represents a very large number of triangles."
}], "MathCaption",
 CellID->200786782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{"rantricoords", ",", 
     RowBox[{"{", "10000", "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->813583247],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytfQm0HVWV9rGGe9/LSwgQJmda7ba77WsLzo1Dq63236uvYYEiDq2SvBAj
gcggYU4CYTD8DCKCkKCMMQkhSBCjYoAACQ5MBggJYwATEgIkBDIg1Pr/vfe3
9zmnzqsHj7X6rXp1q+6tW7X3d749nH1O1e0edNR3xx160FETxh605xePOOj7
350w9sg9vzDpCHorf5Nz7lf0f9sejrb/H23J/zFVVbl83Lhxlfy5j/PK/YDW
Bb25j+wdSeuM9nJ9/Td593DdK6Mz0FrPcBit+c1246cT9bvDeK/wV6eNj8nn
E/Tbwwf5fLx+fyTvlf5zvcZH5ZhxesxOiYZZsv8hOXqMXnFn+ZSQwQEubzz6
O3ru3ZJP06M/KEf/T6wNn1s/bYn02Hfyx9IXjef4hl5xh+Qcgn7hz8FH8Yle
Q6a95civ6fl2bDhfKzlDKtFecoYDVCs+A58Ah9mJeu0cKlrzOb6sUoxSuTM7
Vzn/FoWE/p76JbWaXKHbmaooOaAXnfEDcsb99Iy70muPyHDGZ2+ilz/+Hmq6
0p+juu0y13Cef5XzjFbtdqFXhjcjgdpyPj4T/oD0LWsrPRnvl41n66pUu6h+
fLbeRLoskq5+zlTC98s5/0slHOXxB2a0pkXasN3tHEIvuEZyJcUSUOSDXuU/
q2BFpV4EeocWwtU3LPsRLsf68cVyvRx/GLHBkEuv15HrfSG6XmuAVjhPt9Ov
5ykjDHndbrhOO7nOv8h1PqfojYz4z9/o1dYRnfI511QNV+K/nuRKRUPb40qf
iSytT75VbXhRv7VHKi83eWrd0RnfJ2f8dBW83w7yrQ0vApkXV5m8QKI7xvZT
eYd2pU8oSn2Jl4j5NnH0k7QAr59+fXmEB8uVRTiydLs04Ja20D/Ltf9NtRyh
FiiEK/0FabFL9iRt1aMsuUL3++ya1ZN3GitIYTF/vWRD6/2TvP9RRWCEWpnx
P6PrZ6YyfzClc3nA/Zudi/TagkvvVQuCN4NcGzbxO1/5XiWMkxjmj1j7pHmD
ygKDbqS+HDJ+WJEarjZatxm0lcLlHMkr8kdys+jCnwJy05qWEXJBljDSpNXt
HOvlpEse0Fk8zLkB3v0fRa4Pqlx9il05iO/IG2Ty7RRk4nfoBZb4w8/drGcY
LkhBLhKHFsYSvqN6ga/zt0XPNrTve0XGD2j7DlMZRbTcg+d9QaYcl/YugSPY
zsLmKpt8AvhUZvABrS0iyX63cy69nH4bCJ2RzLFNIE7d97B+B+IPIv/7q5BJ
iRdXjFmPUuXFNeu2KRxVf50bqgVQJWlpKRNJc9239m+UuvBSu4F2/Q8i8fsi
xFnSXrMolbgwFnQ/sipIq5QwnHOILpueEwHlWHb+S72ftBeJ2hQfIOU/Rd6H
j2KTYqa1WLrCS0drL5+2e66IFpFMvLaWX8BfI8n6EplgGVecycczinx8GiP/
XmR7bxVyQXwL7sH4Cu2P//elkbYst7YgYPUoBV/FptYXScl/yAVnzazlPDVv
xRJnEZ49iczvEeHeo63uZS4XXBWyRbmIxfdWkFzMLJI+Y+GVG7zZVgXk+gxy
DrC9RxuiJg+f8ReWRfMt1iRvYAY0eVeEPrxmrIn5EGAbbK7t8Q94Q6LqR+eZ
RPxR4cwAaRkmR6y7r55xQgde+7wKCsh+Poj07xbp94xyB0GUhIdcPtY4s0b5
3KxRVWE94NMii0z1kP3AfPMcv6OX8756H3IDUkrOz2rkUMc20/zAteBVsF4v
523W7u1V6JMIvdE0WIuu8AT1+BPrKO5d45HFHidOXiOK17LOuKA39PTnJj2L
RE/7LNZT+NITe0/oiVZJff+75O23ViFXFp/PeuZBX8Gu7B4W5R7dDXrlx/aN
c2ivsbKT27YdtSoryNrmScuXqqH4bdIszfNFqzLVqqm38Xei0R7afjtZtqXs
zBefj9y5uOGgJThR9eRj4pfNH//1d9M0RyDxlJFba/GgCPEBSuCodVes0/fE
2grvIWjD96X1CLAn6NPUj4Emu1WhZ2ttws3yNge3IBK1A5KkkEh76AXVIPYU
Wga+BV6hu/cDAzzdgFxfIOh2rvbX+tHnfiNHpbzaU2TfJconhVdmTd5FsCbM
j9YlnVNqmZt6CfitNOMI2iLDYV3NeFhbYVzBGtkfc0vyO+rJzvSt4iT17HZ+
7S3ONIPVsnbyRw3V1L94p+ixUzWwb+NlawVvaOaURVwUyybdzXuoB33JvjNK
5PD60bIjH3n6YlhIG20FPKBZ9cITwSewag590ZRtzbrsmLzLuRVY8uqly/js
t65Gz5ZkF6uh195I5r+u1Ex0xcZqZ3l/UudSeuE1b+JcJD69/HLf+Yo7bw1s
X9ZHjm95BnY7y2R9NTT07SORFj3Fev8yrdG9Q7QcGfFSjh4/9m+06NVZR/yx
py5JQzmGXnmT+52FqAO1eJP3c1NWcjpJKmkPvg8Wxlr2Ks/MwmJ9WUsw957N
fDy0s2zI5cGPC/KDahZXSfvU8jJWTzXlk7EWpUkLLViH7qfXxnpltJJvp/o2
vFcqLrAcn2mQ0nL0l86EFr3dznHO/g6eykfNubVSDqdeshiAhpCYm2W9ueBq
3UtuoP95e0CjVvUtFQ9GT7xbAX6ifQtDJdKrJ9nPfKv6b6q9Rfu02dJzwWci
NoDnxvvSMCliTDKCA/E2zo0f/dGjyhXgwDB4ZpTKjHUvAYwBaLwtoNFKatxV
PfO/78Q/CQd9S7KTirUMeDVwYABW/hgmFryA2YrhxV67pceZDQljCCagU21e
4x1ETpiBFWANrRO81mzZrngZtos8e6RTmYM9lj+8BlaD1PoNi5zAMksQTQkq
5AfdyZUHAS3kvaDC1zaT8W8ZdAMRzhJ2Zbpr6OaGstqyIqX4eRx7v3RmXDv6
nTPL4zVi1aKzX8HHHkrr/y6Kru15V6yP8qA0e3mrILVD8q54rdLjeOdKoElI
MgcsIrp8zcI4VjEkwxr4xiign0ksijiXohVhenBncnpE4Znmabb5ZW1JICSA
HYdcI8HIZUw4PrjfnDqjZf2n12NbM0p5VR994U3xVq1gjeKwSAmuruUnf+1J
w0W+lmiYG27blrzqDEeWecb5VfgW5+VmndmEsS+LWcbAuYhnBBXQYn7JuRU8
+EaPGxhD6KH/RfrAQLEmzCzzihmWW9kCyK1HfyHF7i2DMkwqiQQPv5aMDWtC
r7Gx+RimWvrPCCN42hl1z5daICEkPbkSyEQ4Gp/y4O+15/rv6+Izlt3zAruc
4oRvLllXKb/wTU8uxTfK5RSd1P7ePCg6I2PG8KuXBzu0BlawnXbiu566pfK+
akAMRGYnchF8LGsP4SRYq+XlA62Ndwga1GXOq4wRFhObxnwMEc7Y8fmzc55x
iIvimwmVpj7V4KjgrKuOvE6vUiogeN8j4zJaWZ7gPW+SG7kCOBCVNOcV23Jq
V3w0vzrr13oGOdiZ+W1gGnBKWYR+ZnXDVOySQkWCDaQPeTI+D+xpqu/s0YgR
Wx+yUzIsUISlTHiUKVixj00zSYn2DFDbswdAOTgkcDHuY49+/x99LmE5Qm+C
TdqTSLESzYfFmdYpf5asSdCDvUl7Mni5wuca7E32Q+RLGQb0RjTmD67WL5Gr
zd5rKqp3CqBKajhZ5AK5OAZkP+j0g2M/8KOXCIBpXENMP+YslRQfWPwr0EWh
XVpGJFiJzm2PDyDa8pN+tkFpYcIIOReYBdurtoT6LTKZOD9IvffujTjlVX0O
wPTOFP4uobRTop1cv+eH+97rr3D35/vxMQEjHLOqmgK1I7Q0vcUjiW12+ytB
oIDG2s6kNZCK83BmB9oFOivSpnHEi9SqdmvUl9WETUJTOTVpK3LzK/2JvyZ7
wRWCxmhv0jreL17cphKox7HcE3/rX9Y2+skHL3YFcaN7iB6eMzMInNx27Kza
g+shlCSrmbD3LWAy3I5ctSfqoc9ylgsRIYSx5pTViBjz1Gqa0WHOoAalUDir
wK34ImtdPf385Uc8gwwwYUaEC+wrWEvb9OdT0SsW+aZiINLCNIQlUcZDi4yG
ERrwEv0Vb2aKjisYHvkz/gwSudhahrnIWl6DO7s2osMYcj+efSmsQ9M7Z/E8
9hDdDz6m2O23z4P+XcYhey3Nc6+5jYb3V1BbNoG111mvG1sMEwK+et9Ojalt
71OhuKqPHoIzT1mhjtHMj5Z5i/LFR4PlMlfeaRywjFf2q9Wbai2RZi9KA2cc
ghUYFtJn553S+WzXuYfW+BG5/npP2e9fddiT2i88XtuHVFCJVlheBxZfe9JG
ejmTkJIosB42nNZ6dhE0hifv9liEjqwFkpGR6P7u8qZWSgWNvLpzcdx3yBIk
5Iytam0FVtACD9qK7EKa+RDJRspuxLmLblRsesgYoDyoMXO5CLBigVWc63XX
LRsfoxfCghbkHK/V0xzViAZjxphmiTcVSymmHhGiotizH6cmOBSJvoQDshnF
j1I5wXajtrH/1pgBJetvf6w+eD8QCPYI4gtIX9QL4pGOTRubx3AH1zuu6Mjp
ZP870jIMAzzidztn6OfaCp+0DEQ+b3mMnHUcGSWuSLcbkGhpS3LB+UgbfyuA
CBkALZAqYOJnB+q+zbax+RgSm5dMfoC9R5o97NyoOx8FT7j12BNqZ73k+O26
jxGFYAHow1105Auhpag1UivIGrRuJVrbcTavjFQ2v7OkNlJbjO5cCrW7H38C
nueeZbX8sggo0Dt3XfiS9gon24gGWmzwiLHToPjAE33HrLQ7UX148BmQ6Ncn
rI3awZVrxgW7vu6qSnGLs3RGU8baCMwYP8PTYo3ZjRiUzhxpN2AJuRjFCJma
TU0+tWqKOB95RHFOUeyJUON1Uw+xGTk+aniCk/CTYVJL4jX8wSeflGqW9fkI
j1akP899Yq/v844YD2uDBq7JBQFHt/NL0YmIZoyr93ue+stV3CJLLtJ9RipC
Ma2xl4F/fPKb9VsEmUM0SvkX83y9zklJbXTHQZHUvtnJdZluqOcHEQMlYyN4
8T6YyN4qnhlj38uMhmrS4jkZ55YfdfGoS1UpQbptWY8ST/1Yp98Tk8GWvpvB
q+DGdYrnn7LRV2Yj/sTDPz97jbgkQAk372EcHMW+5F22d8TbgJJzvC1Me/mn
t6BHAxAIEloYxdI4mIxB+VyvlvvVUUGmD2FBQNtmYDKmIPrN83kTcXvteG1T
Hm2T64axTZ0XcMd1eqbXrymPbMQCcxldrW+9q6IwIMqFsXvvpepZYbZyMypH
zBJuqYnzJVRcdayzIiilfLmyRxJnL28P7ehcCRioovFrP3KOVAnrhc7Pbe92
fkGLQz/8TG8HhSGk6QB8XRj6QoBPGbNDI0qcF8hocvnKQwHhV2YtQTvUIiBj
hJzh0XMfMmwIF7EXwgWeOmRGPcqOXssJWTlpVM2P5sdeite2v1APhr8GEvLW
FM1JTkzY4ucy5IZN1HZ+jHTj5sY59M3IlMoXlz97duyBcoJErtKOo9z5+8xx
iHW44srNdS8G58Jr9vcs9fDItvgQRktavgXLUYMRIHoNB4BASx7hwGvJaatn
nwfjoT7a4+lJ5yopUr1HDGo34PDhv1Ud7t6nn/MndhvNsw5hK6wz80FkeHW9
fNlHtzJkTWRkD+Kg4Yl/6VX7yW9ehwP2R6e0AF8WQusDO1fGrV3DBVlJ4Idz
05eazw0WhO/B2RJYtKAq9rfnQpeT2TLQ1wwf1Ip6pEEOwbyHdmw32Oa18N7m
OZXgDF9q5WbBSn2MywGesUUQIcgMyxS1tvmXFsPmHK2xQehJb6UXiM39C785
82OzxKBQC56CfIUAAyaMlvzduFjuj8gIG7UxwaOJR8BkWAMm8BabJpkv1HkO
VlySfSZTO9I+Y+VzZ/FY24oZY7kR6zrKfIp3tD5WQXeX0WtGCFhfspaLk8+d
SC8BF2RgUb2Ky26Uh49SDNAu287/vfJD51ZKGULqn+Mwl7cZB5HruouDt44w
kREFtiyCJc1cwBPKbDxVzLyYIjgTkBHxZf9n99v+KPW/hY9KBAkhgiWOPaZ0
fw0d/Hl0WKfFa+XWEjCCskMNaJgzsXHSMWRSsCrGTDKbcbivL0akrxGnMsKJ
oWopLuZzi4g7GzaZTPUszxUxUMYmsYHWkr1CTwWk2cln2ISL2lKhtuSZ0/PE
Mw958hBfAA2BImdnPDS3403eLxNs5Cy9t85iOcmoaKENQOXgqiE5gjl5a1qE
E0NCLfTrlV6KRC8hJjOypNodLE6snbBBf89zh6xKWivxLCNihFzoc6At9vcV
Q/DBo6MVDSWLFTV0lzFCDQWYyKbxB7vmjwvELicm1zTW24wJ803ye8JgByUJ
bMWzY0CUNpsSFKQKHlDQqlaES9HAHI7fknu3fP5rgXyicSUZOehi1CD7yuhn
oS8iFOFCyyCYRGNO/N20BtiMiB9nIkQ4DklaF+1bTsN90vheB4vw2RQSjA9Q
wLSO5T0Pwr2MA6w4fQX60yEP7Is8M28Ot7GlwhuWYkMx/oYQzxfQoqMbnVOt
3QgrsA81MuaQfJOBYhr6ziiSIJsykNlUi4gjA3HrbWBSipPWq3xMz6N9Y1am
x2UJ83jdlB9mBGWvomf9rj4XjY4n/Gvah/cnb6XntTstbnAwQMJ2AeyUIHTo
q0mbE4SGYN//GlKMgIzyTA+jbkWCBJg2RTjPvXdmmfgsQqFUraVisl/nDj71
sETrUjNmotG12sf03keYlLswH8e4VDz1RIVpTmZ1ZZhlAj7JNavZJ7cUDWmB
IaEg1lh4FCIMRJbpSECNGQLA3xY9ixuwGJFCuQCkCBNCZIpG5YI2gBjBE3NH
o7tFrl0kJaSNsZ0zcVS3c4dDdDd9r5X9axUy9IADU4CW9VgVKpCGP1kkpzn6
JxUt8JuEFe4Rn30yFnC8Pjqe8iqdgzvsdRHFuXz/K7K59P6sjCHNnb+3jXnd
HgQ/m2fhnX1UidRU0sHj7Wh5VC45QT8jyvHFjSDsvNPy6/2n8ZdjutXmHgJD
afHXxS8eCWyyycGxk5oFAdWnqCBTqx5/GWb41Manhe1TtGJYVs9Gldsrr7Ix
gM/YHIBWEvlkM+nJhqq4q0XMYaq98O6gihZcc822cE2bS+CKTWf2exzBUKWg
TKUDk5mBXloFUdDUcWVGsEywGxrvONPAmMC1vteIuJbm2wShsYmLSnxlMlz2
ZxY5YUlT4lFXwtOPr0ZoWh+YZR4WqiYraXFieyvrFjzXwYLlHCNSHAeho+I7
AE3OxzCTXjATqy4Djs69PPch/WSo7EO8+dMnav3u/NbuObqPtlEjdZort6pr
OOcBrkRTQlXiFEEKNgYkC+NtPCbrXFx/I2B3VrttW7VcEO3XIclcUSV054qn
ZxgRTcSocU1iIwDUupi3YQXNYgbs+JcXArTcDawgAK30LsZWFD/5tIjeszpH
qKaY50l2i11AROCIZ33ov4lsoaLJ42Mf7Zd8eYoOGXvnlh08MKNPs4ndA/MU
JGae+S7EkrmKlmuDdbTGBqk082OzrJd7Zjy7gjPjWqQl4LReR8DBgr31Eoa0
NM5Ea0aQLVaygTHn6pjMSyecbXjIPsIvg5XTSuyPcNJq76X+bqg6ZnHf2ZmL
e718bOcBdXE1YUH0DiDarxhPBHweTUXQ6uiM4Q6KPRvniglcs0hihqjwywuz
N4SWfH/x9RUW8Jw2apgRmLZPbOuNcBSRlH07GCb8hg8M/h3PvrcYTpHtqUX2
e2hkAEkzoG023xVVNURSzAsAl3iECmMKnkO0NI0N9w5qd7jWX4+L59KytnGP
p2hglOR1LD29Bm6hZz0mnoU3Bjlw7KXeabxq+ZkRAsBKqKkxA/rDsLqdP/ic
3qxIq8Bw2rqfmwUt/a+T5SRvCIs9Ej1z1ZP9T2uMppCWJ0U68d9bNcb3+fHH
IL9V9v+gx9odBHYva6ZRiF6XWfTRmReVr10MSQtfv86n/bweqbHP0Qf7aTUg
at2HR0PT89E4mgVdWBt1CG1MjM81+2aG76htGI9Bm0X/Qa8datFxTojxVsYA
tdfZJzfdRQm9Uzvno6RmdvghNmdlQ63qQ+plqpv2SZMRJYygslbZGJU+yktM
w92Nue3Ym1/5aNU94EXAdIDWwGYkmZOnsrb+fleafFrfR89CB517FAG5D3RI
CPBR8i1CYLg2qNZpX3pVGxOaBg/GmvJ7xQBfZZFylOqdm3ysaucolvco9WVH
xe0Y7D6bAbuJx9WN9yck+9b65hOW+bM8cMryN4yEv48t/9ZPazZQTutM8mfm
bCJTnMSzlOdH0k/3Y6++F1Rt3do8IlzfTzOy4ZrRar9pEWub2e0whB4WxL/L
768UzzCOvEzlmKH7k2hBj6A2B5e4ZdnxCf5d9jBW01a2Kr8yyz4KIIzI4ev6
+v20vtaMd6a2R0Z40+WK1dzr5SrcAHwZbQhuEKnbsbPh98ka2dkUsopzODbP
NGrEdUj7iLXrs5ps4N/2k/qLkGMsAtLAMcY4C6Oxk5rv6457FYxskskBTfVY
FoVZ/59M0LHBa090zc9o6xnUjyECzL1eqrFEU5GQEJMIQUghB3/qwMBW5qjc
a/o6mVnRwM8wPlJtfNEyEfF/eYQglgzvHoX5gh6rWQ9jVqEe4QoPi89xk1ky
BQHkpc8YpNeouTUj1apshE3JpufOOMRxY/qOVvU0M3yecKNk5hWeebSAOX87
8fggD4+dyeuH+2P0epusv3RRrmzQqlyGJ/qNyrW82fZbtz4XM42svD9+yh//
6R0J4a4whhlnYod59E9kxn4aL4Fe6jn5XR3VO+EUPR+QAGy0pkXknWeVI2QI
wV5ph2ADcuwm+Y10dLZH0cgIDO8F9XrCWMt8SH3pt9Abx4tKfGOFxoexNoNb
s/L/eDjer1UwGRK9935NHF9p/wlfT3qDCE3vHOw4IhysFePuOYXiwjSLsdDz
KxYuP004VxsFUFzYl6E+MDfJQ8zv92MTMXa6b3r0F1hhQkwiMUC7XeyMelzX
ywHXO4sgvqZ5T56gmUfXs+szp/A+qktst1KVZvgGzEAf1ohcu4FbsPpl425w
Zphip3wpwpFtM5unvvhZ6g1Ogz9mVrFnHdHg11T6A2yeknClZ24UwwOSGhoU
S4ZT/dsiy8w5IBzLUhCSalO3Y4FvBKKAM/ua9dBSZs5K7ogavK+iM8gRHebz
cDv42RwlUoTDvbAhVsvcHga48BCrBbfmqQsiVLHIV+kVETbUeXm/Z1CvJvyg
xIgwmiW+qIwRZlSHpWge61G/XYDlFRh8PbD8mmWl5dYz5CyCaPfb22wco1+i
IJERPUtv1QRa02ymZrxsNobgkztzbxgrZv9GWGTKN8y+6Ezzrdaqblky54TN
uCzgGO75F1UDFBlkYdN9hS3MLMi6U6221h/GI8SMpystobPPrHlTfM2x2oKM
n635yOtr46njIRMhqcREjznMY+0ZgGE+ZM6F+46CFYuNEn654mfZMubgoCp4
y5KITS5UKZlnLQPO2Z/xCwgcsIntW3vG/XEfAxAi3j9XERGnqx88CtnRsfz5
7QbX9TITw74/HpcimMApMM/x4zbOthz6z14iC7KuDDkMQbemarxnqz0odsaL
g/05eBtWHGrCOScrfKhaaTtCVY+gHUTUGrINoxHmKQUlDkXFfob0acCulBoO
bk9DGcfwTuNCGpeoPabniri2j5j35UFOJqa04leftU3XAta09htZdHZqAD+3
mFuA/OksuxNs9eX1+5TgOwVUN9APoB3Sd33dj6BHSxD5Do7bgHuFnIf4HLDa
ugW56S8u8FgUcAfcAAMRt5HIfADi0mrRaKj0McH3/jiSAQHxC/rlUjNy9g1i
cx5bhKW41gJUBSd+LcM+Wk/nCEYM56gFyz7u83dFMjRzuxFTaCTURuXicTwp
4dZPTaSFsVq9Wd5fsDBTdLXPQfA6d0mn/xLF50QwM+3J2Div8LgFPLHQ9rqx
ExHJpnrOtjyuzvsRiyh4b6+HjTtCYo8GHfFD9RSfWjvO/vS7t6f354wcgCbH
+DiD6o7eZBmoz0iHhqzdB1tSGiW6L1TZASnP6t8seYyiKVwtAKfqwkTljzR+
MbrpHAKVbfk8a/nTNCQTqoA3U29RTNVXxRbZN/MU+IJf6i32shzdajw/dDq+
OU4f6UTw0oINh6AmHkVqBgHhHm0hT2Gfsxnmtm+5lWrke5jSz3hjXNa0Kjfk
ic+FIp65kOEH77BgpZekpcmDZRERo+VcB1ok22D3ASjGciZFPVfM86mdmoeU
Y6dbfRJ9xlCriutvJTWBsEN8BfD3eNbuSDzD38sSUNca57lxn9T7/wR/2EQY
jdZRrfn+3m1Baij4+3FA7Thk9CrYaRWENlZv9hJZJORnEW6pXdu3gMtoU45p
+Uo9FJn3oEbkwHzn9lP+Fqepv53q60PinYqGuSyMc2HZRYQzbS7XUbCvbkoh
9PcBuPwM30tTSxHMeR23O/cktDrn4x5i0QnXh2xOZB8y0kA09NH4KPLbMq5m
MBe+Lxswlur88Sb/uufjOruU/mNtCd4DvVdANBQXfpr5j6kRE41d2diQn6Bm
QlxmjJXTMc6Gkj0NMSe4rc1QVeUnZdjfrM4R43j+93hj8bkUZRfH5zG0B3gZ
qVIlPbiI5VkD9njQYWOLSF/62tMJfW2AnLEXX4JhbtHfGN726FcbX/XYCrvl
yWS/uLeyLBnnAOqCw4Fa4z8N9QpxGvzGWEy3fK6y0TzzFgU7bz5izmqU8X6o
514e9+Vyc9jam5Gch6Hm99SR9KSMQCX2z9C3jifY7L22VlCHhmirEVH22nhW
ZAxawc5BPC2IK9oTfmhv2jAeyRmWz5OYdKDvx4oq5p1d/urUQ/V4zO/5Xjzy
KZ63umA84cmQMnulmEK4emgdxsV4vVzvRrA+srkNe9KLoFvoG4JxI76Pfb3f
8E0z5zgyBn87FHQH1HMIWz9GZvpyXsJvLnziBRyz9Ikswh9rz1FqB24KHEGN
Aaf90vy/avw4z0YDyqgl8gO1GtlGbkL4owmq++V2+fIeu4sEsVHIzp7jF49r
ZJfmQFugReV3SpBl8Ai2Itmv/ZDId6f1WBkpJ7Tj/givi9dAnf+GhrrPRZTQ
mQujAfUeYUa4F4q3OGdyFvAXSEsyS/t9WGTqZ2YHhDgt8Oo29l7EUZHZjzY5
+6bY1zPWhrNldrCmx+2p1xeMj47nX8ywGALMXjnFAmJhiOcecXhAngTEItEr
fLf+9kbt2Wgx+mk2qHWjaLzhDeBfOp+LhBHDzKpEGiU1LhP4KhGBX6tZaD4i
bE9Qjz8PXJn7hPX9ZOTA8C+eW34lNQEWmTEtacP6g8gB68Am0xxZKHkYP+EA
7ZDRS8ZNILwfs4U3W85FdWZAn9Erv99m7PkS8/e/wWTxYzwR4mjbwb1MY5b3
mny3drVeON9jx1Cbg3H59hmSXBDm1ku3yk3wv+ZdUszlribCVMasiMPw09Lf
Fl+gT+tbHVdWC4aw8LjRIloPnxHV+R7dv/8bSB8ER6y/gaibCY89lt3ONXY3
vvKYgPS4KnlbMY60bqp3Ast0RCPFEjYNn0FI0oIZFkvxWGT1F4VKFPVKDDkl
aEbwCSO3n4c6avXgg7QEv1HDn4MmqgH3X83C5eybGWP+5sWrKlq0NQPWOo5s
fqPbORqMHLPFcjqZDZZ/w18H7INvYHBxhssjOYJXAGf9mHpaUyoC1s01vGak
0S6WvQm8iNdcUpKsZOkT8A6MslUcgnxFwk/xHYYwvfJm8q0u2MsThS5AgQL9
av4GocyOWZhtaJOL8Dxos2ew7vl5csbDD7GWeMo/0UI8BUZC+qNq61lap1Ef
4coLI00Y/7gnSTS3mrP1WmgD49oEsva0q2rg6PjgaFuOLF0Vy0JKSjlQ09dS
KnNbI9nDL3gl+NgyQtszriCMvZNGpTLurN2MOsjte1t0NNTH4emC2T16YyK9
CuS0ErSY4nwAHrxFqAOdw/0daUWKOtrZx0naOcvaGkjzOv0lrnQ+Gap5YLfd
p8CID43TRQPKkBsoC4nAvq1xPM8ihL3fLZxlerRgZirQJDAFUTki1NkI2lz7
7OwrwHuCcYHc8EQ47gBV+3eJMPHIlRqq5G+c/lIRned3kDfcc1fzrUPmn427
BUQ0Lqmhxx5VPk5QifPelvbd0l9c83VzQoIWnvt0gUfyhdWLq2suNHwJH/UC
K5InPMpT73md2QPjg+sgbokF/k9nhh29sMYjYMhr2fS27Gt7Yd4iri4Ri70q
S9NYU2vkmOaIj798RCd4p/y0uyqzYXnTe05akhijPbgiQbY0G+6p5pzP371t
Hi0eg+oOeb4uB2NIwCRUfZh98nrNhXHWhuO2TrFfPJLMn0DX7Gmm+AACVkZF
W1GfgYE97Oe4wzvCMmCdYFmO2eceZ3888oRc7rmnojs9pDQ5NJRln4VDH+II
9d06LmxzPUz3rVu0PbfWs3TALDgkSDPyGOW7bZ5VD3JtkTSzLfV9PEerepTv
nn3xSK7JwRsynkV3Cu43C6zVH6ZgD5nWQeXX+Qhdfu8mAB2en3XxXRUttbGr
oFFAmRnbbPtpxdJ7xTg/JfOXWfcEWRlhxX87Ki51//YOIPyo3Tucq+YlaS5u
mzTG4rXvdqaMVC0u0W+ZVvZ7iRgl9NyaY78/EXpBvUPWkzmjVVVfa7VsJldd
kZlgwpLOfLva6nF09Pet33Nt7W6h3Kqk5VFJzQ/Xm7ykNsOYcxsX/E7BoKHH
/mvfksUCsQz4v4LxKmIM09bnBErmxnZPwd05ZTX/GC/JOLv7Kp9zfpz716qA
BCneC6PqTePARSO2vA+Znp00vdYymn5vt0lgGRGprVhKDCMo/aifZi7wOjYX
xU9RUHbgeYH8J7PXCT28D5tjxLyl5R4z67vN/J6CZjM6zonOXRJ6qDfMPyY/
4pN3xBW/1EY1Ai7DrBQJvzbDqFgwP3i1prGvZvxg4Xfuy0ZYLTzFFbSZuYG8
ZAR7FEGMeT4zpt/b4bX6DJbMEu7qgfv5IM0L7v1F1DqkzmTMeCTUvEfKvN/X
x4gQaPiEN6x3p7jRRq+2Fhh6irUzYyjXJG9Fct37n9pn8jMn6zwbGk5F5Wfk
LjyF8AFavJY2T5CCr/hqrc1cEaMFVpznj5AR8lPv9DOOL3NWSOO1jUXpeMuK
DZozUR4jn/hnml24sioiJF2bnaA4PH0CieYFBKjmcefo6NWEyn/MUBobBfZv
f0irHoAT2hyj2fyf0Z6Yr5sHBjZV75ux5ep9r6KofZsH1nlosq+GOnpOEAqY
f3jez+l3OcEWXVOoVnrb1Q3fb+vywwAn6wy82RcUTi2WN1b8N1SaaVmkQYaY
MvN7yJ3RtyDoaLH2uoLfmVABRj+65YqfrfBjScfkhGPjqGDiDSPLpg5He1Ac
7XkxVVWbu7vwlB/rWIYfu0D6IfGVzFQitNa6mXNyzNptFS3qraYltYDgCVNv
BKSoK6GFTB5RzxXb0iP54IH9RETmosYhMWxv1a3gDRnXK0T2CVU8Q2mV/zy7
43C5e78JTe3jLIMWi45Zbd8hWg7OxxhH+13SqDKgWRwjN0wvh5xjy1Hf1fNj
pAIdKsq9aMHTmzozeyP9fXsXZy2Pas0MQz7m7Fp8bA9EhKllM55Jx1VgDoFB
L7xGJu9N1emvs2t7xfzSNsMD5xp6agNR6bVMjcOD0yeFsMPnjdvXPk0Lf/jA
OsVHrGrjod8XhhGtIAUbL0JtGl+FMbSLWsAd9+vvCFDARXZzzzetpqJ9MEXX
2KgBBPc1tpCDA1GsGeOCNq02C1YfxxWMo7kgZjG5X6lk9v9auV7eiBLaV2EC
4luP/r6kbQWwUo3pOzspOmZ/oqp8iHSkWnI/fi04/7n8ngCXRMRvrdv0V87M
lO1XQPqFdZstQvA8bXzGMOSAgzcbrbjU0qD8MaO0avOtV/y7QAg+L4yaRzN0
in2PUx7f/bjedfF6qPVE3GLc5FdV6DN46Jd1TP1uexbDzzB7jXHD03EYJZk5
hsljtJtFmPEfIpz3xLrBKDJ1pOd+zJE2j/Rca+/s5GX6PAGPJACEH6UN8xM3
eXDgzWCTAUftYEc5ncZozUc8ZnjSwdAQK51ZY/Xk83LO7ToK7XMMsT5LywhJ
EU5QXXpDoRiiz7VF7nPIfo7fhckYoRxIySatYLEEmWa1kJxhw1+Z7Jvf4YkA
r5xtM1xOlszr5GWVj6iMo+GZ1m76AK/GAO/lR+P+fQY13NXGGBaueV63c2l9
X+sk3kpzws562uTXf1Dv24Y+Fzi55GIem7KqGL6zdluseYsQgxV6Fv5qrjKZ
Njy0sf8yvyYoxyi2EC0IWwQC2kCrzb5gB0XOsmU1b33Xxh9HKqyQFDgSiJqZ
nxrm1wwJv3Zir5mdNA8jBBltoqJzyz02lmd4iVT8Q3Xq9ZhhKeNkn5U/xGeB
ZN3ak1pyPyB0Gb/ym9rTEEpIxlEQRrBOSkv8z2pz99c4ZmOXxj2cRxDUd9AW
k7xO0vYztHJc3nHAhc7M2bDMCMqmZ2g1Y2i4SRWH8NpJuSVQ8Zv+h17X6v3O
mWcM/6pDkN/lB9U8OeOCtr5Ec3T9hcsCzPrLpldpYZ9XGEZy1Lm0FC7kxa7Q
pAXYekxCZJWcahLuKIjvz0XUCnmZoaN2V/n5Da+LFPfO2PRHKquEJfR6ua+d
BtZB9qU3oI2DRcro5CUW9bud2RF2OSEhmJHu0O7pCdOiz61mInVjUSVwx7kH
J99IMJQRKvyHZ8N397YnMluN9U7/PWaPz11H4ybNUjFqN+CSDcBFftlHEryA
pvO/95PfsbGyp+/H6DDP8Ps0i//j1Bg1HV0pfrP/nD6VVlEic2OvbrkGYum3
O+f7azJ7LOPHcyWO+78qEW2gh7akPvO9xDMn8Nf9wF0unQdSDBmLcTpOlz6d
2T9JvageV+fwyBbcKXu53gFDEAgDSGd0D/E3DJrO1Dx7NvqUlGSwUMQWRZqw
AJuBBTuZN8t+4IGw/t5pD0jW+Z1L1SPFumeUXGkMOKlu0XUsUi+d1iyAif3K
O7dCQdrKoY8eGmbjqK3wWuyJ3Ij5Q8ugTWPzDhlrjMzoiiBNaH+MHcNG5PsW
jXwo4vUwRULa84DO6W3V3T+PGV/efrxWOU+tzUVMY5IxIGREw1XrzLR+ZEvI
pltbXlZsuaVlrffWXobnIF/N/QCtb2p1bbachT642s/k5aO+uJYWHX+NbSCj
rp/YVUlIQPMoDosYx99YHS+/KcDZJGyQgKAXIoaOqX3rlTJp+0zBKAZv8+Td
Pt8HuWavHwT5Kjw3MMaHN6WFGZ4c0PCfPG3ianWvQCDCJYs/JW7ggLYCJOe7
WvuoV6vHbSGKYPAtxFdYT4hc6m3/ZBX4jODqsfYJmhBcWgmUfgmu31xVqbOo
GT8ZfxwX/UazwiY2a2i99JzMRd9NWfNJBzNHKx7vfynCS8zGru/pr02cZDO6
YG+/7Zq9pbkCpEpl5Z5lj0qE+ZeXfuV2jwnlyJeldiz1tC1TflzeuwY6IOgr
MguW17xNWa1mLMMa8wlWKP5oM7QfxmS1ejhN47Fyu5dWceQnc3ZN1Svo2FLk
Q20h5AASi9Rf59ULmHeQb9+0WqW2SG4+u63Kv0Xe33BjrF3GCuVePY01m0+6
KDpXyPeCJ3u3NN9J31rvcSZhSSUgGNWWGjR8k2iYPkmGa0uoFD2yJcTsXH5K
/QX7JWunVe3LbCQUOiyVX3DJNh02SeI7tao9u8dXdkht4MX6hhbW0cEVob4b
bNCyPbDgxnlWq8RghfVOzjJJ+egVXzp4GLWzoFgCndDa8ryYRix6tbUZA7Tm
89+z6hn2gQmDkdEK196+vVJg9M72yzQvtR4TLelcQTDw3jW1KLzBLFNJ4Cw2
rBrHeTw0B0aFciGnN2NO8DHRWM5ZjAv2gwfQCP+lg/HW8TdqFjbrllq/uMfj
xqA5N/mz3IhEqSY/BfzSJ8QzjsJcgrFlWMXXKP74cfWaj3+Z7y26zHrk5iGk
x3+v/qwYvWLJ7F31GZ5BqVU9Mm0p0KENuy6BC+sKkV/GWQv/zMONy9Xve4DE
a0qliGAThhFYqEd5fABOoxcHOumvvwyvrBoeWCbfJpDg0wgUvK0MEgPky295
7Lf8tjwbh3CAtIFNebVubZnorTVtzyw8VaL688sHHVvR4jJeYRTV92bhSQvC
A9Hs7nOYEbSmpTfhTDZ2UtWUFTZ7nRFqacyYEQkzYANed9Qqfq9eXDXviTQ2
IuS2oUDgKfarX4mjhzPH4msPFN2PjTnJhoT3SW2oKlfrpY1S9YyrZE31Q+iY
/m56n8YM3wvQko34N6YAMtjLbCwtW3nWI3mChfyWS6SnbXIERYugjURDOXm3
Y/d2apQpAwahf0w2N6VmmYoKny2jldVyEKNQahQ06LNcL1vofl8DC5oR2lFZ
sKP6W64Dag53GaQiCGpSVc+YdowEcx+xfu5dqI3MvQsLqq4BCwushY+hnsuK
U3ysaVPrM+j77CsKpj0fQK9Y4qqVM32l3mV/0gcUrXcezEuq9vTlxfHdMQVx
A7WLVd+0/nAraWve71U0iOtzQ5vzMUWica4tKlr7boBAkDszcK8xPx0vO/T9
i0YmOnJu9Cba5bZEe47S9uzR/N4/xxhMp8YUPTfegzEqOnePXjdT7siTKOr+
nt5tJ9q+VWTvTlfGEv7AY8sCeyotvB9ZMMnNm/hFkMk27ss2zLa2WLtmDj67
rs2uSTuNsHYi+QUnemWZ2tpGperRNsiBY4y1bxKzWRHUH2dqvkVIMONozt0L
0qBQZYDDlUfaL1hmpFBhraJSFgP02K0h7ujoyGbFizVSEXNtCZ//GBsSdrSS
/ZQ9rAdqTNXFP1Z5kckROdORxKL7EZ61guHXUrXX5/ls5CO5GXNaSZ50+q/U
hjcur/usY35fy3HKydFME+btQMbuXoWeFVDWtlUt+hSJYapN0eB7qafkr6M5
/wFb4v22t8cLx3Nps7uXOLVs7V02Gj7DxrTAYyWts99pHl8bezE9ee3nvUX9
krqGb05av9dssrKSXJPOO0OuJfabgTJK81sdn04wwIyT+6LfhWL9xeLaYa6a
c6Qur7/Vb/f8idakqzLc2trjUJz2G96nNS3QHO/4Fo6Q8dU51TMbgMRbqoF9
Of6SxFQKLJonbF7jJeagDJubN9Z+abqtSEDikIH4LPXOM57CGswmXGgbi/aG
9rKYJjkdwQI8bvrsSfRCa1pkpg0rm3sA9Neu/LiQryvFbe7c25rauxaJnJ5H
rPHF657V36LzeuNXKg6yfKBaJb/Dyjq3TOWW15P+0PI57aNSteQR/SY1vlq3
zu+5mRa0I7hgeOasOovzoKXv2fQj1TaiFqdNsf/LLqh8xa30mmqMBQpvT1DY
QX13QfoKpvzqbJ7bb+fX7Qv7vEaeOSet/6zaGO+XHgrNPDN6Y6ekrTWvuVki
CKmvcy5urF95+pGxBeQRAwRIWZH6zv6kp1F4PT0L3qFc38lyTtIXvfqQQUU8
LoPGWIMDnsq0SMS+ZdzvMdq3/pzoyRd7PUItrTNPJ9X9Otr5hNFyPyK9CJNI
actNQ32I2c7Y9Hhbh56V1smbtNyzoZXRYj/2v+Vk3M1UTcgJdq963p7xgxbF
mrW2ukXt91eL6r4nsUvqW0/V/FtPpD/ri/NCc/xxI/aqpuzX48pLYO7facux
Lox5y7wuve4m19g2+TB64TUs5L7ralUEFrKEjNo+JKPm+IGNZJJs98XsiyrO
63bVq0KGdye49qm3ECHAEJWqRxHNlq5Gr5xe4QWWrg4szUjYVFadTftNb1kk
t47y3KR3PXkP9MByreBX8bf9UyNUyt1rfvA9Vehh8kHDSFLIcPfd9RjylMwl
5nWhGojtsQJ8AL3yZk8iv1bnb0I15bZLzOdN0d8ihazdzkT9fRZ7QvM7a0j/
Q4J0T6ST09aHxVUXXOPxJA1G24yD2J5ZlT4DX2Xn9zHiNeZE6/SdaL8669nb
MlLovj5d3HRQhfiKHEVLG8ty722KNrmnyIB5+OIFR9t9rWgJ0oAWZGyhLSA8
dIy5xDt2F1I9W4j1MybJ9cgIW1Gb4M8EZekm6j5HjUL7L879YxV6M9oG9n29
o0Tvj2+Njmr/0CmjF/T1oVlGKoHxS2v3l/LuToO0zm/2m+1gvZB+4nHqD6MY
jprBJB8drHXw64T/PJgd56PrEa3wNqFyUxSfG9oGPvPLX9+mrZKbQXhllupz
DeTXb6lhxCeQJuBV8IIFK9GYjWhk9S20u7YFfoP6fVWozOaJBnKtJXPtDN4e
ZHxA/ZLhbobhilUyOZdEpSXmD62tBWre28DOWIPI64R7E7G/i8otvUfXSVqg
bRGqqDYHLuYkfTuRPraHIHvRwKG6Lpod+qfKFmoNbW37PZQh0i9w71dcbb5R
VllNEu3v8WXB+IMXFm3DuvuFZ2oyBjZkBrKGT42wWyPb00lgmSK9p2L2DpHp
Aw0+sV3HjDZ2TZDQCvtWRULzdm9V3rbfJdfYq6FdtL/p2wVYXzS1tl+w3pBh
sfw2XWbNgkagNaLw1irUvZz354a++H23t6Lfruoc0t5QVdctSKKjBIuvgxga
S70AroG9W3HWtyoK75OTf6gBhcxFnuWMz90ckPjjI3Vkwn52ze+soiAyBUlw
ZJCEKbS7YvCvIsOHYwxaru4Z6PqYyxGu5Rxvi++kq0o2TReyKixfb5TqKNq5
jzawSXQ8ZG/tndCGP3dBJ89UI3Bu1fPhym/WM39MzvyxhjNjPtjeN2HJ9YzW
c6v3u3dRHD4h73w8ijaCvYpVKNSlSpVFcnxGvrlPIodFartrJnhX+rpqYt71
83KGT+i1y0hG/OWJ5OHdUSr9/5EzfCqRofFJdxHDd9Drf0m+/enIC73Wt4bp
t/aTb30mOTqtMY9UCQ+Qoz+bfNo0J4HP/Q05+nMqUXpUS8/5bTnq89Gn43Sa
E5+jXz79AuNPe99Fi7/p/wMqozeA\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->59224398]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows polygons in three dimensions to have any number of vertices in any \
configuration. Depending upon the locations of the vertices, the resulting \
polygons may be non-coplanar or non-convex. When rendering non-coplanar \
polygons, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will break the polygon into triangles, which are planar by definition, \
before rendering it."
}], "Text",
 CellID->230186377],

Cell[TextData[{
 "The non-coplanar polygon is broken up into triangles. The interior edge \
joining the triangles is not outlined like the outer edges of the ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " primitive. "
}], "MathCaption",
 CellID->155982798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[87]:=",
 CellID->660363505],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[{{0, 0, 0}, {0, 0, 1}, {1, 1, 0}, {1, 0, 1}}]]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[87]=",
 CellID->43321391,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Self-intersecting non-convex polygons are filled according to an \
even\[Hyphen]odd rule that alternates between filling and not at each \
crossing. \
\>", "MathCaption",
 CellID->509604418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", "\[Pi]", " ", 
         RowBox[{"k", "/", "5"}]}], "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", "\[Pi]", " ", 
         RowBox[{"k", "/", "5"}]}], "]"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "8", ",", "2"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[92]:=",
 CellID->343700748],

Cell[BoxData[
 Graphics3DBox[
  Polygon3DBox[
   NCache[{{1, 0, 0}, {
     Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
     Rational[1, 4] (-1 + 
       5^Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], 0}, {
     Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
     Rational[1, 4] (-1 - 5^
       Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2], 0}}, {{1, 0, 
     0}, {-0.8090169943749475, 0.5877852522924731, 0}, {
     0.30901699437494745`, -0.9510565162951535, 0}, {
     0.30901699437494745`, 0.9510565162951535, 
      0}, {-0.8090169943749475, -0.5877852522924731, 0}}]]]], "Output",
 ImageSize->{184, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[92]=",
 CellID->7007601,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Cuboid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cuboid"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], "}", "]"}], Cell[TextData[{
     "a unit cube with opposite corners having coordinates ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"], "}"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["x", "TI"], "+", "1", ",", 
       StyleBox["y", "TI"], "+", "1", ",", 
       StyleBox["z", "TI"], "+", "1", "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Cuboid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cuboid"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["min", "TI"]], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell["\<\
a cuboid (rectangular parallelepiped) with opposite corners having the \
specified coordinates\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cylinder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cylinder"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]}], "]"}], Cell[TextData[{
     "a cylinder of radius 1 with endpoints at ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["1", "TR"]]}], "}"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Cylinder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cylinder"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      StyleBox["r", "TI"]}], "]"}], Cell[TextData[{
     "a cylinder of radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Sphere",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sphere"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"]}], "}"}], "]"}], Cell[TextData[{
     "a unit sphere centered at ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Sphere",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sphere"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "}"}], ",", 
      StyleBox["r", "TI"]}], "]"}], Cell[TextData[{
     "a sphere of radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22642],

Cell["Cuboid graphics elements. ", "Caption",
 CellID->31620],

Cell["\<\
This draws a number of random unit cubes and spheres in \
three\[Hyphen]dimensional space. \
\>", "MathCaption",
 CellID->21486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cuboid", "[", 
       RowBox[{"10", " ", "rcoord"}], "]"}], ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{"10", " ", "rcoord"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[100]:=",
 CellID->6146],

Cell[BoxData[
 Graphics3DBox[{{
    CuboidBox[{1.6157823017877404`, 8.178076205202556, 6.686614231558865}], 
    SphereBox[{4.720885675368793, 5.073378775106119, 4.543377694259448}]}, {
    CuboidBox[{5.587771308998737, 6.196178008739855, 5.280865430903652}], 
    SphereBox[{9.232086278855185, 5.4690389071569845`, 
     2.8994523084102886`}]}, {
    CuboidBox[{3.43008602128849, 9.512254333890427, 4.0359659536124255`}], 
    SphereBox[{1.7174716672145718`, 1.757811151443911, 
     0.5783256124773795}]}, {
    CuboidBox[{9.438068252036265, 5.796842993665734, 5.447501979406246}], 
    SphereBox[{8.714080614803452, 6.650435892642889, 9.358783149499592}]}, {
    CuboidBox[{8.815573942761045, 7.891195217825135, 8.48614124434049}], 
    SphereBox[{1.056429133788792, 4.059501398514341, 7.295080568037218}]}, {
    CuboidBox[{2.052855642072673, 3.7513327317918255`, 5.802171940758094}], 
    SphereBox[{7.75936435319184, 3.1421014906491718`, 0.9999821681476995}]}, {
    CuboidBox[{8.436437337726177, 6.2189598857708095`, 2.1302417937143647`}], 
    SphereBox[{3.517890998559996, 3.918516716942493, 8.04385712531224}]}, {
    CuboidBox[{2.06373899315907, 0.13424977867549037`, 7.579299914202715}], 
    SphereBox[{6.123003158830924, 2.271623453056155, 6.999551637075994}]}, {
    CuboidBox[{7.111759339741058, 2.725376222667608, 2.2044376580476444`}], 
    SphereBox[{8.138211972851124, 1.0624938993860988`, 5.771653061795301}]}, {
    CuboidBox[{1.434945074235947, 6.473852358832303, 3.9409579392739635`}], 
    SphereBox[{6.005823827183909, 6.478222581828752, 
     3.526699004290299}]}}]], "Output",
 ImageSize->{184, 199},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[100]=",
 CellID->216637921,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Even though ",
 Cell[BoxData[
  ButtonBox["Cylinder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cylinder"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sphere",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sphere"]], "InlineFormula"],
 " produce high-quality renderings, their usage is scalable. A single image \
can contain thousands of these primitives. When rendering so many primitives, \
you can increase the efficiency of rendering by using special options to \
change the number of points used to render ",
 Cell[BoxData[
  ButtonBox["Cylinder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cylinder"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sphere",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sphere"]], "InlineFormula"],
 " ",
 "by default. The ",
 Cell[BoxData["\"\<CylinderPoints\>\""], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " is used to reduce the rendering quality of each individual cylinder. \
Sphere quality can be similar adjusted using ",
 Cell[BoxData["\"\<SpherePoints\>\""], "InlineFormula"],
 "."
}], "Text",
 CellID->110619261],

Cell["\<\
Because the cylinders are so small, the number of points used to render them \
can be reduced with almost no perceptible change.\
\>", "MathCaption",
 CellID->154341008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"rcoord", ",", "rcoord"}], "}"}], ",", ".01"}], "]"}], ",", 
     RowBox[{"{", "10000", "}"}]}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<CylinderPoints\>\"", "\[Rule]", "6"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[110]:=",
 CellID->29827963],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[110]=",
 CellID->55740293]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->300495568],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "RelatedTutorials",
 CellID->636842111],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->28810171]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Three-Dimensional Graphics Primitives - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DensityAndContourPlots"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 56.2495408}", "context" -> "", 
    "keywords" -> {
     "Boxel", "cube", "cuboid", "dodecahedron", "facet", 
      "graphics primitives", "hidden surface elimination", "lamina", "line", 
      "planar polygons", "point", "polygon", "polygons", "polyhedra", 
      "polytopes", "rectangular parallelepiped", "solids", "tetrahedron", 
      "text", "Threedimensional graphics", "volume element"}, "index" -> True,
     "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "One of the most powerful aspects of graphics in Mathematica is the \
availability of three-dimensional as well as two-dimensional graphics \
primitives. By combining three-dimensional graphics primitives, you can \
represent and render three-dimensional objects in Mathematica. \
Three-dimensional graphics elements. Every time you evaluate rcoord, it \
generates a random coordinate in three dimensions. ", "synonyms" -> {}, 
    "title" -> "Three-Dimensional Graphics Primitives", "type" -> "Tutorial", 
    "uri" -> "tutorial/ThreeDimensionalGraphicsPrimitives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.8"->{
  Cell[2980, 77, 117, 4, 70, "Title",
   CellTags->{"S2.10.8", "8.1"},
   CellID->32364]},
 "8.1"->{
  Cell[2980, 77, 117, 4, 70, "Title",
   CellTags->{"S2.10.8", "8.1"},
   CellID->32364]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.8", 160201, 3163},
 {"8.1", 160302, 3167}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2355, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2980, 77, 117, 4, 70, "Title",
 CellTags->{"S2.10.8", "8.1"},
 CellID->32364],
Cell[3100, 83, 441, 12, 70, "Text",
 CellID->568],
Cell[3544, 97, 4244, 139, 70, "DefinitionBox",
 CellID->5994],
Cell[7791, 238, 86, 3, 70, "Caption",
 CellID->579],
Cell[7880, 243, 182, 5, 70, "MathCaption",
 CellID->24023],
Cell[8065, 250, 182, 6, 70, "Input",
 CellID->25709],
Cell[8250, 258, 127, 4, 70, "MathCaption",
 CellID->31657],
Cell[8380, 264, 233, 8, 70, "Input",
 CellID->4141],
Cell[8616, 274, 69, 1, 70, "MathCaption",
 CellID->29285],
Cell[CellGroupData[{
Cell[8710, 279, 104, 3, 70, "Input",
 CellID->8477],
Cell[8817, 284, 4592, 77, 225, 1639, 24, "CachedBoxData", "BoxData", "Output",
 
 CellID->115810351]
}, Open  ]],
Cell[13424, 364, 128, 4, 70, "MathCaption",
 CellID->27272],
Cell[CellGroupData[{
Cell[13577, 372, 223, 7, 70, "Input",
 CellID->8828],
Cell[13803, 381, 4730, 82, 233, 729, 12, "CachedBoxData", "BoxData", "Output",
 
 CellID->22528878]
}, Open  ]],
Cell[18548, 466, 527, 12, 70, "Text",
 CellID->13549],
Cell[19078, 480, 195, 5, 70, "MathCaption",
 CellID->12517],
Cell[19276, 487, 217, 7, 70, "Input",
 CellID->9009],
Cell[19496, 496, 76, 1, 70, "MathCaption",
 CellID->27743],
Cell[CellGroupData[{
Cell[19597, 501, 108, 3, 70, "Input",
 CellID->30867],
Cell[19708, 506, 3440, 61, 237, 268, 5, "CachedBoxData", "BoxData", "Output",
 CellID->670477397]
}, Open  ]],
Cell[23163, 570, 141, 4, 70, "MathCaption",
 CellID->21590],
Cell[CellGroupData[{
Cell[23329, 578, 189, 6, 70, "Input",
 CellID->12891],
Cell[23521, 586, 5613, 98, 217, 1176, 21, "CachedBoxData", "BoxData", \
"Output",
 CellID->559139824]
}, Open  ]],
Cell[29149, 687, 445, 12, 70, "Text",
 CellID->1538],
Cell[29597, 701, 2540, 89, 70, "DefinitionBox",
 CellID->4706875],
Cell[32140, 792, 83, 1, 70, "Caption",
 CellID->82696337],
Cell[32226, 795, 408, 7, 70, "Text",
 CellID->491473416],
Cell[32637, 804, 160, 4, 70, "MathCaption",
 CellID->148366640],
Cell[32800, 810, 191, 6, 70, "Input",
 CellID->423261710],
Cell[32994, 818, 278, 8, 70, "MathCaption",
 CellID->200786782],
Cell[CellGroupData[{
Cell[33297, 830, 240, 7, 28, "Input",
 CellID->813583247],
Cell[33540, 839, 19395, 322, 216, "Output",
 Evaluatable->False,
 CellID->59224398]
}, Open  ]],
Cell[52950, 1164, 486, 12, 70, "Text",
 CellID->230186377],
Cell[53439, 1178, 332, 9, 70, "MathCaption",
 CellID->155982798],
Cell[CellGroupData[{
Cell[53796, 1191, 499, 16, 70, "Input",
 CellID->660363505],
Cell[54298, 1209, 3384, 60, 216, 103, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->43321391]
}, Open  ]],
Cell[57697, 1272, 200, 5, 70, "MathCaption",
 CellID->509604418],
Cell[CellGroupData[{
Cell[57922, 1281, 544, 17, 70, "Input",
 CellID->343700748],
Cell[58469, 1300, 4486, 81, 226, 832, 17, "CachedBoxData", "BoxData", \
"Output",
 CellID->7007601]
}, Open  ]],
Cell[62970, 1384, 5233, 178, 70, "DefinitionBox",
 CellID->22642],
Cell[68206, 1564, 61, 1, 70, "Caption",
 CellID->31620],
Cell[68270, 1567, 138, 4, 70, "MathCaption",
 CellID->21486],
Cell[CellGroupData[{
Cell[68433, 1575, 378, 12, 70, "Input",
 CellID->6146],
Cell[68814, 1589, 19560, 323, 220, 1604, 24, "CachedBoxData", "BoxData", \
"Output",
 CellID->216637921]
}, Open  ]],
Cell[88389, 1915, 1361, 42, 70, "Text",
 CellID->110619261],
Cell[89753, 1959, 179, 4, 70, "MathCaption",
 CellID->154341008],
Cell[CellGroupData[{
Cell[89957, 1967, 468, 15, 47, "Input",
 CellID->29827963],
Cell[90428, 1984, 66211, 1089, 216, "Output",
 Evaluatable->False,
 CellID->55740293]
}, Open  ]],
Cell[CellGroupData[{
Cell[156676, 3078, 72, 1, 70, "RelatedTutorialsSection",
 CellID->300495568],
Cell[156751, 3081, 204, 4, 70, "RelatedTutorials",
 CellID->636842111],
Cell[156958, 3087, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717],
Cell[157162, 3094, 165, 4, 70, "RelatedTutorials",
 CellID->28810171]
}, Open  ]]
}, Open  ]],
Cell[157354, 3102, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

