(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    293740,       9934]
NotebookOptionsPosition[    285866,       9685]
NotebookOutlinePosition[    288088,       9734]
CellTagsIndexPosition[    288045,       9731]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraditionalForm Reference Information", "Title",
 CellID->509267359],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " differs from ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", the default format for input and output. It is important to understand \
that ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " expressions cannot always be provided as unambiguous input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Therefore, while ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " is an input format and an output format, ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " is primarily intended as an output format. "
}], "Text",
 CellID->17215110],

Cell[TextData[{
 "In general, the ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " representation of a mathematical function differs from its ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " representation in two ways: function arguments are enclosed in \
parentheses",
 " ",
 "rather than square brackets, and one-character variable and function names \
are set in italics rather than plain text."
}], "Text",
 CellID->18700063],

Cell[TextData[{
 "In addition to these general differences, ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " transforms a large group of expressions into their conventionally used \
mathematical notation. A table listing these expressions and their",
 " ",
 "special ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " representations appears later in this tutorial. "
}], "Text",
 CellID->38053170],

Cell[TextData[{
 "This displays a mathematical function that does not have a special \
notation; the input is in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and the output is in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->26309000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MathieuC", "[", 
   RowBox[{"a", ",", "q", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5603324],

Cell[BoxData[
 FormBox[
  RowBox[{"MathieuC", "(", 
   RowBox[{"a", ",", "q", ",", "z"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->708768304]
}, Open  ]],

Cell[TextData[{
 "Here is an example of a function that has its own special ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " notation."
}], "MathCaption",
 CellID->479149574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5695427],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"(", GridBox[{
      {
       TagBox["n",
        Identity,
        Editable->True]},
      {
       TagBox["m",
        Identity,
        Editable->True]}
     }], ")"}],
   InterpretTemplate[Binomial[#, #2]& ],
   Editable->False], TraditionalForm]], "Output",
 ImageSize->{29, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->370167349]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " representation of matrices is shown here."
}], "MathCaption",
 CellID->8768708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"21", ",", "22", ",", "23"}], "}"}]}], "}"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27149348],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"11", "12", "13"},
     {"21", "22", "23"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{72, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TraditionalForm=",
 CellID->342224362]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " representations of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions and commands distinct from conventional mathematics use square \
brackets, as in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->225042333],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " representation of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->130723508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldForm", "[", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", ".99"}], "}"}]}], "]"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->243341238],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["sin", 
       RowBox[{"-", "1"}]], "(", "x", ")"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "0.99`"}], "}"}]}], "]"}],
   HoldForm], TraditionalForm]], "Output",
 ImageSize->{132, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//TraditionalForm=",
 CellID->823617867]
}, Open  ]],

Cell[TextData[{
 "The following tables list the expressions that have their own specific ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " representations. Entries marked with a star (\[Star]) contain hidden \
information (using ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " constructs or specially designed characters) and may not be suitable for",
 " ",
 "unambiguous input."
}], "Text",
 CellID->224179794],

Cell[CellGroupData[{

Cell["Mathematical Constants and Domains", "Section",
 CellID->395391501],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    ButtonBox["Algebraics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Algebraics"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalA]",
       Function[{}, Algebraics]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["Booleans",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Booleans"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalB]",
       Function[{}, Booleans]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    ButtonBox["Catalan",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Catalan"], Cell[BoxData[
     FormBox[
      TagBox["C",
       Function[{}, Catalan]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    ButtonBox["Complexes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complexes"], Cell[BoxData[
     FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["EulerGamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EulerGamma"], Cell[BoxData[
     FormBox["\[DoubledGamma]", TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    ButtonBox["Glaisher",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Glaisher"], Cell[BoxData[
     FormBox[
      TagBox["A",
       Function[{}, Glaisher]], TraditionalForm]], "InlineMath"], " "},
   {
    ButtonBox["GoldenRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GoldenRatio"], Cell[BoxData[
     FormBox[
      TagBox["\[Phi]",
       Function[{}, GoldenRatio]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalZ]",
       Function[{}, Integers]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    ButtonBox["Primes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Primes"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalP]",
       Function[{}, Primes]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    ButtonBox["Rationals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rationals"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalQ]",
       Function[{}, Rationals]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalR]",
       Function[{}, Reals]], TraditionalForm]], "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->795589712],

Cell["Mathematical Constants and Domains.", "Caption",
 CellID->162120449]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Functions", "Section",
 CellID->27810147],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Ceiling",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ceiling"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[LeftCeiling]", "z", "\[RightCeiling]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Floor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Floor"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[LeftFloor]", "z", "\[RightFloor]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["FractionalPart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FractionalPart"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"frac", "(", "x", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Sign",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sign"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sgn", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->608319635],

Cell["Numerical Functions", "Caption",
 CellID->61634746]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elementary Functions", "Section",
 CellID->612969727],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["ArcCos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCos"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cos", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCosh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCosh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cosh", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCot"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cot", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCoth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCoth"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["coth", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCsc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCsc"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["csc", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCsch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCsch"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["csch", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcSec",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSec"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sec", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcSech",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSech"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sech", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcSin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSin"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sin", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcSinh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSinh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sinh", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcTan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTan"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["tan", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcTanh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTanh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["tanh", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Cos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cos"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cos", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Cos",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cos"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cos", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Cosh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cosh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cosh", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Cosh",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cosh"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cosh", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Cot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cot"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cot", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Cot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cot"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cot", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Coth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Coth"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"coth", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Coth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Coth"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["coth", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Csc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Csc"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"csc", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Csc",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Csc"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["csc", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Csch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Csch"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"csch", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Csch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Csch"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["csch", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"log", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Log",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Log"], "[", 
      StyleBox["z", "TI"], "]"}], "^", 
     StyleBox["p", "TI"]}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["log", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     RowBox[{
      StyleBox["b", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["log", "b"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Log",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Log"], "[", 
      RowBox[{
       StyleBox["b", "TI"], ",", 
       StyleBox["z", "TI"]}], "]"}], "^", 
     StyleBox["p", "TI"]}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["log", "b", "p"], "(", "z", ")"}], TraditionalForm]],
      "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Sec",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sec"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sec", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Sec",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sec"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sec", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Sech",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sech"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sech", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Sech",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sech"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sech", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sin", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Sin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sin"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sin", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Sinh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sinh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sinh", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Sinh",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sinh"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sinh", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Tan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tan"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"tan", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Tan",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Tan"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["tan", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Tanh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tanh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"tanh", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Tanh",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Tanh"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["tanh", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->492944256],

Cell["Elementary Functions", "Caption",
 CellID->380058058]
}, Open  ]],

Cell[CellGroupData[{

Cell["Factorial Related Functions", "Section",
 CellID->264957115],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["Beta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Beta"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[CapitalBeta]",
        Beta,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Beta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Beta"], "[", 
     RowBox[{
      StyleBox["z", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["\[CapitalBeta]",
         Beta,
         Editable->False,
         Selectable->False], "z"], "(", 
       RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Beta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Beta"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[CapitalBeta]",
        Beta,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{
        SubscriptBox["z", "0"], ",", 
        SubscriptBox["z", "1"], ",", "a", ",", "b"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Binomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Binomial"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"(", GridBox[{
          {
           TagBox["n",
            Identity,
            Editable->True]},
          {
           TagBox["m",
            Identity,
            Editable->True]}
         }], ")"}],
       InterpretTemplate[Binomial[#, #2]& ],
       Editable->True], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalGamma]", "(", 
       RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalGamma]", "(", 
       RowBox[{"a", ",", 
        SubscriptBox["z", "1"], ",", 
        SubscriptBox["z", "2"]}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["GammaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GammaRegularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["Q",
        GammaRegularized,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["GammaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GammaRegularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["Q",
        GammaRegularized,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{"a", ",", 
        SubscriptBox["z", "0"], ",", 
        SubscriptBox["z", "1"]}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseBetaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseBetaRegularized"], "[", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        InterpretationBox["I",
         BetaRegularized,
         Editable->False,
         Selectable->False], "s", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseBetaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseBetaRegularized"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        InterpretationBox["I",
         BetaRegularized,
         Editable->False,
         Selectable->False], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["z", "0"], ",", "s"}], ")"}], 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["LogGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogGamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"log\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Multinomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Multinomial"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], "2"], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["k", "TI"]]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["n", "1"], "+", 
           SubscriptBox["n", "2"], "+", 
           SubscriptBox["n", "k"], "+", "\[Ellipsis]"}], ";", 
          SubscriptBox["n", "1"]}], ",", 
         SubscriptBox["n", "2"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["n", "k"]}], ")"}],
       Multinomial], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Pochhammer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pochhammer"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       SubscriptBox[
        RowBox[{"(", "a", ")"}], "n"],
       Pochhammer], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolyGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyGamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[Psi]",
        PolyGamma], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolyGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyGamma"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox[
        TagBox["\[Psi]",
         PolyGamma], 
        RowBox[{"(", "n", ")"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->577877001],

Cell["Factorial Related Functions", "Caption",
 CellID->527980380]
}, Open  ]],

Cell[CellGroupData[{

Cell["Combinatorial Functions", "Section",
 CellID->62975293],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["BernoulliB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BernoulliB"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["B",
        BernoulliB], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["BernoulliB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BernoulliB"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["B",
         BernoulliB], "n"], "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     "\[Star]"},
   {
    RowBox[{
     ButtonBox["ClebschGordan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ClebschGordan"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["3", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{
         RowBox[{
          SubscriptBox["j", "1"], 
          SubscriptBox["j", "2"], 
          SubscriptBox["m", "1"], 
          SubscriptBox["m", "2"]}], "\[VerticalSeparator]", 
         RowBox[{
          SubscriptBox["j", "1"], 
          SubscriptBox["j", "2"], 
          SubscriptBox["j", "3"], 
          SubscriptBox["m", "3"]}]}], "\[RightAngleBracket]"}],
       ClebschGordan,
       StripWrapperBoxes->True], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["EulerE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EulerE"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["E",
        EulerE], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EulerE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EulerE"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["E",
         EulerE], "n"], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Fibonacci",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fibonacci"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["F",
        Fibonacci], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Fibonacci",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fibonacci"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["F",
         Fibonacci], "n"], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["HarmonicNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HarmonicNumber"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       InterpretationBox["H",
        HarmonicNumber,
        Editable->False,
        Selectable->False], "n"], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["HarmonicNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HarmonicNumber"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["r", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      SubsuperscriptBox[
       InterpretationBox["H",
        HarmonicNumber,
        Editable->False,
        Selectable->False], "n", 
       RowBox[{"(", "r", ")"}]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["PartitionsP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PartitionsP"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["p",
        PartitionsP], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["PartitionsQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PartitionsQ"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["q",
        PartitionsQ], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Signature",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Signature"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["\[CurlyEpsilon]",
        Signature], 
       RowBox[{
        SubscriptBox["e", "1"], ",", 
        SubscriptBox["e", "2"], ",", "\[Ellipsis]"}]], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["SixJSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SixJSymbol"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["3", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["4", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["5", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["6", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["{",
        SixJSymbol], GridBox[{
         {
          SubscriptBox["j", "1"], 
          SubscriptBox["j", "2"], 
          SubscriptBox["j", "3"]},
         {
          SubscriptBox["j", "4"], 
          SubscriptBox["j", "5"], 
          SubscriptBox["j", "6"]}
        }], 
       TagBox["}",
        SixJSymbol]}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["StirlingS1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StirlingS1"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      SubsuperscriptBox[
       TagBox["S",
        StirlingS1], "n", 
       RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["StirlingS2",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StirlingS2"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      SubsuperscriptBox[
       TagBox["\[ScriptCapitalS]",
        StirlingS2], "n", 
       RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["ThreeJSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ThreeJSymbol"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["3", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["(",
        ThreeJSymbol], GridBox[{
         {
          SubscriptBox["j", "1"], 
          SubscriptBox["j", "2"], 
          SubscriptBox["j", "3"]},
         {
          SubscriptBox["m", "1"], 
          SubscriptBox["m", "2"], 
          SubscriptBox["m", "3"]}
        }], 
       TagBox[")",
        ThreeJSymbol]}], TraditionalForm]], "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->538471409],

Cell["Combinatorial Functions", "Caption",
 CellID->251720177]
}, Open  ]],

Cell[CellGroupData[{

Cell["Number Theory", "Section",
 CellID->15695834],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["ArithmeticGeometricMean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArithmeticGeometricMean"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["agm",
        ArithmeticGeometricMean,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["CarmichaelLambda",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CarmichaelLambda"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[Lambda]",
        CarmichaelLambda,
        Editable->False,
        Selectable->False], "(", "n", ")"}], TraditionalForm]], "InlineMath"],
     "\[Star]"},
   {
    RowBox[{
     ButtonBox["DivisorSigma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DivisorSigma"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["\[Sigma]",
         DivisorSigma], "k"], "(", "n", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EulerPhi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EulerPhi"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[Phi]",
        EulerPhi], "(", "n", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["GCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GCD"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"gcd", "(", 
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["JacobiSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiSymbol"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"(", 
        FractionBox["n", "m"], ")"}],
       JacobiSymbol,
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["LCM",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LCM"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"lcm", "(", 
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{"m", "mod", "n"}],
       Mod[FE`Conversion`Private`m, FE`Conversion`Private`n],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["MoebiusMu",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MoebiusMu"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[Mu]",
        MoebiusMu], "(", "n", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["MultiplicativeOrder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MultiplicativeOrder"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["ord", "n"], "(", "k", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["PowerMod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PowerMod"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{
        SuperscriptBox["a", "b"], "mod", "n"}],
       PowerMod[
       FE`Conversion`Private`a, FE`Conversion`Private`b, 
        FE`Conversion`Private`n],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Prime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prime"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["p",
        Prime], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["PrimePi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimePi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[Pi]",
        PrimePi], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["RamanujanTau",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RamanujanTau"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[Tau]",
        RamanujanTau], "(", "n", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{"SumOfSquaresR", "[", 
     RowBox[{
      StyleBox["d", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox[
        SubscriptBox["r", "d"],
        SumOfSquaresR], "(", "n", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->310587361],

Cell["Number Theory", "Caption",
 CellID->115397346],

Cell["", "Text",
 CellID->287445040]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zeta Related Functions", "Section",
 CellID->41657222],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["LerchPhi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LerchPhi"], "[", 
     RowBox[{
      StyleBox["z", "TI"], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["a", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[CapitalPhi]", "(", 
        RowBox[{
         TagBox["z",
          LerchPhi,
          Editable->True], ",", 
         TagBox["s",
          LerchPhi,
          Editable->True], ",", 
         TagBox["a",
          LerchPhi,
          Editable->True]}], ")"}],
       InterpretTemplate[
        Function[{ZetaDump`e1$, ZetaDump`e2$, ZetaDump`e3$}, 
         LerchPhi[ZetaDump`e1$, ZetaDump`e2$, ZetaDump`e3$]]]], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolyLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyLog"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["Li",
         PolyLog,
         Editable->False,
         Selectable->False], "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolyLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyLog"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["p", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["S",
         PolyLog,
         Editable->False,
         Selectable->False], 
        RowBox[{"n", ",", "p"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["RiemannSiegelTheta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RiemannSiegelTheta"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[CurlyTheta]",
        RiemannSiegelTheta], "(", "t", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["RiemannSiegelZ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RiemannSiegelZ"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["Z",
        RiemannSiegelZ], "(", "t", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["StieltjesGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StieltjesGamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["\[Gamma]",
        StieltjesGamma], "z"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Zeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Zeta"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Zeta]", "(", 
        TagBox["s",
         Zeta,
         Editable->True], ")"}],
       InterpretTemplate[
        Function[BoxForm`e$, 
         Zeta[BoxForm`e$]]]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Zeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Zeta"], "[", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      StyleBox["a", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Zeta]", "(", 
        RowBox[{"s", ",", 
         TagBox["a",
          Zeta,
          Editable->True]}], ")"}],
       InterpretTemplate[
        Function[{ZetaDump`e1$, ZetaDump`e2$}, 
         Zeta[ZetaDump`e1$, ZetaDump`e2$]]]], TraditionalForm]], 
     "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->239776720],

Cell["Zeta Related Functions", "Caption",
 CellID->5549651]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hypergeometric Related Functions", "Section",
 CellID->247025698],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["AiryAi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryAi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Ai", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["AiryAiPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryAiPrime"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["AiryBi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryBi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Bi", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["AiryBiPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryBiPrime"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["AppellF1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AppellF1"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["c", "TI"], ",", 
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox[
        SubscriptBox["F", "1"],
        AppellF1,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{
        RowBox[{"a", ";", 
         SubscriptBox["b", "1"]}], ",", 
        RowBox[{
         SubscriptBox["b", "2"], ";", "c", ";", "x"}], ",", "y"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["BesselI",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselI"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["I", "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["BesselJ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselJ"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["J", "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["BesselK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselK"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["K", "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["BesselY",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselY"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["Y", "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["CosIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CosIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Ci", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["CoshIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CoshIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Chi", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Erf",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erf"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"erf", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Erf",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erf"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"erf", "(", 
       RowBox[{
        SubscriptBox["z", "0"], ",", 
        SubscriptBox["z", "1"]}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Erfc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erfc"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"erfc", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Erfi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erfi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"erfi", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["ExpIntegralE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpIntegralE"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["E",
         ExpIntegralE], "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["ExpIntegralEi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpIntegralEi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Ei", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["FresnelC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FresnelC"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["C",
        FresnelC], "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["FresnelS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FresnelS"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["S",
        FresnelS], "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Hypergeometric0F1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric0F1"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "0"], 
          SubscriptBox["F", "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox["\[Null]",
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric0F1,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["a",
              Hypergeometric0F1,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric0F1,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric0F1,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
        Editable->False],
       Hypergeometric0F1], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric0F1Regularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric0F1Regularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "0"], 
          SubscriptBox[
           OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox["\[Null]",
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric0F1Regularized,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["a",
              Hypergeometric0F1Regularized,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric0F1Regularized,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric0F1Regularized,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
        Editable->False],
       Hypergeometric0F1Regularized], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric1F1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric1F1"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
          SubscriptBox["F", "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             TagBox["a",
              Hypergeometric1F1,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric1F1,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["b",
              Hypergeometric1F1,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric1F1,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric1F1,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
        Editable->False],
       Hypergeometric1F1], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric1F1Regularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric1F1Regularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
          SubscriptBox[
           OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             TagBox["a",
              Hypergeometric1F1Regularized,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric1F1Regularized,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["b",
              Hypergeometric1F1Regularized,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric1F1Regularized,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric1F1Regularized,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
        Editable->False],
       Hypergeometric1F1Regularized], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric2F1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric2F1"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["c", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
          SubscriptBox["F", "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             RowBox[{
              TagBox["a",
               Hypergeometric2F1,
               Editable->True], ",", 
              TagBox["b",
               Hypergeometric2F1,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["c",
              Hypergeometric2F1,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric2F1,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
        Editable->False],
       Hypergeometric2F1], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric2F1Regularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric2F1Regularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["c", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
          SubscriptBox[
           OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             RowBox[{
              TagBox["a",
               Hypergeometric2F1Regularized,
               Editable->True], ",", 
              TagBox["b",
               Hypergeometric2F1Regularized,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1Regularized,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["c",
              Hypergeometric2F1Regularized,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1Regularized,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric2F1Regularized,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
        Editable->False],
       Hypergeometric2F1Regularized], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["HypergeometricPFQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricPFQ"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["p", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["q", "TI"]]}], "}"}], ",", 
      StyleBox["z", "TI"]}], "]"}], "\[SpanFromLeft]", " "},
   {"", Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "p"], 
          SubscriptBox["F", "q"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             RowBox[{
              TagBox[
               SubscriptBox["a", "1"],
               HypergeometricPFQ,
               Editable->True], ",", 
              TagBox[
               SubscriptBox["a", "2"],
               HypergeometricPFQ,
               Editable->True], ",", 
              TagBox["\[Ellipsis]",
               HypergeometricPFQ,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            HypergeometricPFQ,
            Editable->False], ";", 
           TagBox[
            TagBox[
             RowBox[{
              TagBox[
               SubscriptBox["b", "1"],
               HypergeometricPFQ,
               Editable->True], ",", 
              TagBox[
               SubscriptBox["b", "2"],
               HypergeometricPFQ,
               Editable->True], ",", 
              TagBox["\[Ellipsis]",
               HypergeometricPFQ,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            HypergeometricPFQ,
            Editable->False], ";", 
           TagBox["z",
            HypergeometricPFQ,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
        Editable->False],
       HypergeometricPFQ], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["HypergeometricPFQRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricPFQRegularized"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["p", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["q", "TI"]]}], "}"}], ",", 
      StyleBox["z", "TI"]}], "]"}], "\[SpanFromLeft]", " "},
   {"", Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "p"], 
          SubscriptBox[
           OverscriptBox["F", "~"], "q"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             RowBox[{
              TagBox[
               SubscriptBox["a", "1"],
               HypergeometricPFQRegularized,
               Editable->True], ",", 
              TagBox[
               SubscriptBox["a", "2"],
               HypergeometricPFQRegularized,
               Editable->True], ",", 
              TagBox["\[Ellipsis]",
               HypergeometricPFQRegularized,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            HypergeometricPFQRegularized,
            Editable->False], ";", 
           TagBox[
            TagBox[
             RowBox[{
              TagBox[
               SubscriptBox["b", "1"],
               HypergeometricPFQRegularized,
               Editable->True], ",", 
              TagBox[
               SubscriptBox["b", "2"],
               HypergeometricPFQRegularized,
               Editable->True], ",", 
              TagBox["\[Ellipsis]",
               HypergeometricPFQRegularized,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            HypergeometricPFQRegularized,
            Editable->False], ";", 
           TagBox["z",
            HypergeometricPFQRegularized,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
        Editable->False],
       HypergeometricPFQRegularized], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["HypergeometricU",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricU"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["U",
        HypergeometricU], "(", 
       RowBox[{"a", ",", "b", ",", "z"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["LegendreQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreQ"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["Q",
         LegendreQ], "n"], "(", "x", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["LegendreQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreQ"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["Q",
         LegendreQ], "n", "m"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["LegendreQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreQ"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["Q",
         LegendreQ], "n", "m"], 
       RowBox[{"(", 
        TagBox["z",
         HoldComplete[LegendreQ, FE`Conversion`Private`a]], ")"}]}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["LogIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"li", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["MeijerG",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MeijerG"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["n", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["n", "TI"]], "+", "1"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["p", "TI"]]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["m", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["m", "TI"]], "+", "1"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["q", "TI"]]}], "}"}]}], "}"}], ",", 
      StyleBox["z", "TI"]}], "]"}], "\[SpanFromLeft]", " "},
   {"", Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["G",
         MeijerG], 
        RowBox[{"6", ",", "6"}], 
        RowBox[{"3", ",", "3"}]], "\[InvisibleApplication]", 
       RowBox[{"(", 
        RowBox[{
         TagBox["z",
          MeijerG,
          Editable->True], "\[VerticalSeparator]", GridBox[{
           {
            RowBox[{
             TagBox[
              SubscriptBox["a", "1"],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", "n"],
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", 
               RowBox[{"n", "+", "1"}]],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", "p"],
              MeijerG,
              Editable->True]}]},
           {
            RowBox[{
             TagBox[
              SubscriptBox["b", "1"],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", "m"],
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", 
               RowBox[{"m", "+", "1"}]],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", "q"],
              MeijerG,
              Editable->True]}]}
          }]}], ")"}]}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["MeijerG",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MeijerG"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["n", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["n", "TI"]], "+", "1"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["p", "TI"]]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["m", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["m", "TI"]], "+", "1"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["q", "TI"]]}], "}"}]}], "}"}], ",", 
      StyleBox["z", "TI"], ",", 
      StyleBox["r", "TI"]}], "]"}], "\[SpanFromLeft]", " "},
   {"", Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["G",
         MeijerG], 
        RowBox[{"6", ",", "6"}], 
        RowBox[{"3", ",", "3"}]], "\[InvisibleApplication]", 
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{
           TagBox["z",
            MeijerG,
            Editable->True], ",", 
           TagBox["r",
            MeijerG,
            Editable->True]}],
          MeijerG], "\[VerticalSeparator]", GridBox[{
           {
            RowBox[{
             TagBox[
              SubscriptBox["a", "1"],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", "n"],
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", 
               RowBox[{"n", "+", "1"}]],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", "p"],
              MeijerG,
              Editable->True]}]},
           {
            RowBox[{
             TagBox[
              SubscriptBox["b", "1"],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", "m"],
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", 
               RowBox[{"m", "+", "1"}]],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", "q"],
              MeijerG,
              Editable->True]}]}
          }]}], ")"}]}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["SinIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SinIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Si", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["SinhIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SinhIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Shi", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["StruveH",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StruveH"], "[", 
     RowBox[{
      StyleBox["\[Nu]", "TR"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["H",
         StruveH,
         Editable->False,
         Selectable->False], "\[Nu]"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["StruveL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StruveL"], "[", 
     RowBox[{
      StyleBox["\[Nu]", "TR"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["L",
         StruveL,
         Editable->False,
         Selectable->False], "\[Nu]"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->638742201],

Cell["Hypergeometric Related Functions", "Caption",
 CellID->495383214]
}, Open  ]],

Cell[CellGroupData[{

Cell["Orthogonal Polynomials", "Section",
 CellID->144833340],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["ChebyshevT",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChebyshevT"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["T", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ChebyshevU",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChebyshevU"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["U", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["GegenbauerC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GegenbauerC"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["C", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["GegenbauerC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GegenbauerC"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["C", "n", 
        RowBox[{"(", "m", ")"}]], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["HermiteH",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HermiteH"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["H", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["JacobiP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiP"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["P", "n", 
        RowBox[{"(", 
         RowBox[{"a", ",", "b"}], ")"}]], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LaguerreL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaguerreL"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["L", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LaguerreL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaguerreL"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["L", "n", "a"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["P",
         LegendreP], "n"], "(", "x", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["P",
         LegendreP], "n", "m"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["P",
         LegendreP], "n", "m"], "(", 
       TagBox["z",
        HoldComplete[LegendreP, FE`Conversion`Private`a]], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["SphericalHarmonicY",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalHarmonicY"], "[", 
     RowBox[{
      StyleBox["l", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["\[Theta]", "TR"], ",", 
      StyleBox["\[Phi]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["Y", "l", "m"], "(", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->12622022],

Cell["Orthogonal Polynomials", "Caption",
 CellID->33051293]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Functions", "Section",
 CellID->34148502],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["InverseErf",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseErf"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      StyleBox["s", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["erf", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{
        SubscriptBox["z", "0"], ",", "s"}], ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFunction"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       SuperscriptBox["f", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]],
       InverseFunction,
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["ProductLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ProductLog"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["W",
        ProductLog], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["ProductLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ProductLog"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["W",
         ProductLog], "k"], "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->16400739],

Cell["Inverse Functions", "Caption",
 CellID->315000117]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptic Integrals", "Section",
 CellID->431097278],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["EllipticE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticE"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"E", "(", "m", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["EllipticE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticE"], "[", 
     RowBox[{
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"E", "(", 
       RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticF"], "[", 
     RowBox[{
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"F", "(", 
       RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticK"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"K", "(", "m", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["EllipticNomeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticNomeQ"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["q",
        EllipticNomeQ,
        Editable->False,
        Selectable->False], 
       RowBox[{"(", "m", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticPi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticPi"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalPi]", 
       RowBox[{"(", 
        RowBox[{"n", "\[VerticalSeparator]", "m"}], ")"}]}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticPi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticPi"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalPi]", 
       RowBox[{"(", 
        RowBox[{"n", ";", 
         RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}]}], ")"}]}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiZeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiZeta"], "[", 
     RowBox[{
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalZeta]", "(", 
       RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->696356759],

Cell["Elliptic Integrals", "Caption",
 CellID->6173067]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptic Functions", "Section",
 CellID->14624774],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["DedekindEta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DedekindEta"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Eta]", "(", 
        TagBox["t",
         Identity,
         Editable->True], ")"}],
       InterpretTemplate[DedekindEta[#]& ]], TraditionalForm]], "InlineMath"],
     "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticTheta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticTheta"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["u", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[CurlyTheta]", "a"], "(", 
       RowBox[{"u", ",", "q"}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["EllipticThetaPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticThetaPrime"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["u", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["\[CurlyTheta]",
         EllipticThetaPrime], "a", "\[Prime]"], 
       RowBox[{"(", 
        RowBox[{"u", ",", "q"}], ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseEllipticNomeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseEllipticNomeQ"], "[", 
     StyleBox["q", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox[
        InterpretationBox["q",
         EllipticNomeQ,
         Editable->False,
         Selectable->False], 
        RowBox[{"-", "1"}]], 
       RowBox[{"(", "q", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiCD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cd", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiCN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiCN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cn", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiCS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiCS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cs", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiDC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiDC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["dc", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiDN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiDN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["dn", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiDS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiDS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["ds", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiNC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiNC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["nc", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiND",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiND"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["nd", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiNS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiNS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["ns", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiSC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiSC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["sc", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiSD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiSD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sd", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiSN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiSN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sn", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseWeierstrassP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseWeierstrassP"], "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["\[WeierstrassP]", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{
        RowBox[{"p", ";", 
         SubscriptBox["g", "2"]}], ",", 
        SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["JacobiAmplitude",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiAmplitude"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"am", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["JacobiCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiCD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cd", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiCN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiCN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cn", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiCS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiCS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cs", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiDC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiDC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"dc", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiDN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiDN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"dn", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiDS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiDS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"ds", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiNC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiNC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"nc", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiND",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiND"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"nd", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiNS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiNS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"ns", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiSC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiSC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sc", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiSD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiSD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sd", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiSN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiSN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sn", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["KleinInvariantJ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KleinInvariantJ"], "[", 
     StyleBox["\[Tau]", "TR"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"J", "(", 
        TagBox["\[Tau]",
         Identity,
         Editable->True], ")"}],
       InterpretTemplate[KleinInvariantJ[#]& ]], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["ModularLambda",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ModularLambda"], "[", 
     StyleBox["\[Tau]", "TR"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Lambda]", "(", 
        TagBox["\[Tau]",
         Identity,
         Editable->True], ")"}],
       InterpretTemplate[ModularLambda[#]& ]], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["NevilleThetaC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NevilleThetaC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[CurlyTheta]", "c"], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["NevilleThetaD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NevilleThetaD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[CurlyTheta]", "d"], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["NevilleThetaN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NevilleThetaN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[CurlyTheta]", "n"], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["NevilleThetaS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NevilleThetaS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[CurlyTheta]", "s"], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["WeierstrassP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassP"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[WeierstrassP]", "(", 
       RowBox[{
        RowBox[{"u", ";", 
         SubscriptBox["g", "2"]}], ",", 
        SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["WeierstrassPPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassPPrime"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox[
        TagBox["\[WeierstrassP]",
         WeierstrassPPrime], "\[Prime]"], "(", 
       RowBox[{
        RowBox[{"u", ";", 
         SubscriptBox["g", "2"]}], ",", 
        SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["WeierstrassSigma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassSigma"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Sigma]", "(", 
        RowBox[{
         RowBox[{
          TagBox["u",
           Identity,
           Editable->True], ";", 
          TagBox[
           SubscriptBox["g", "2"],
           Identity,
           Editable->True]}], ",", 
         TagBox[
          SubscriptBox["g", "3"],
          Identity,
          Editable->True]}], ")"}],
       InterpretTemplate[WeierstrassSigma[#, {#2, #3}]& ]], TraditionalForm]],
      "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["WeierstrassZeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassZeta"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Zeta]", "(", 
        RowBox[{
         RowBox[{
          TagBox["u",
           Identity,
           Editable->True], ";", 
          TagBox[
           SubscriptBox["g", "2"],
           Identity,
           Editable->True]}], ",", 
         TagBox[
          SubscriptBox["g", "3"],
          Identity,
          Editable->True]}], ")"}],
       InterpretTemplate[WeierstrassZeta[#, {#2, #3}]& ]], TraditionalForm]], 
     "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->149266478],

Cell["Elliptic Functions", "Caption",
 CellID->97324429]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathieu Functions", "Section",
 CellID->31528676],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["MathieuCharacteristicA",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuCharacteristicA"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["a",
         MathieuCharacteristicA,
         Editable->False,
         Selectable->False], "r"], "(", "q", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["MathieuCharacteristicB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuCharacteristicB"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["b",
         MathieuCharacteristicB,
         Editable->False,
         Selectable->False], "r"], "(", "q", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->194212853],

Cell["Mathieu Functions", "Caption",
 CellID->216417174]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generalized and Related Functions", "Section",
 CellID->320937540],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["DiracDelta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiracDelta"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[Delta]",
        DiracDelta,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", 
        SubscriptBox["x", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["DiscreteDelta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiscreteDelta"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[Delta]",
        DiscreteDelta,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["KroneckerDelta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KroneckerDelta"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       InterpretationBox["\[Delta]",
        KroneckerDelta,
        Editable->False,
        Selectable->False], 
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}]], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["UnitStep",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnitStep"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[Theta]",
        UnitStep,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", 
        SubscriptBox["x", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->78557113],

Cell["Generalized and Related Functions", "Caption",
 CellID->128888406]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matrix Operations", "Section",
 CellID->153379974],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["Det",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Det"], "[", 
     StyleBox["A", "TI"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[LeftBracketingBar]", 
        TagBox["A",
         Function[BoxForm`e$, 
          TableForm[BoxForm`e$, TableDepth -> 0]]], 
        "\[RightBracketingBar]"}],
       {Det}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Inverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inverse"], "[", 
     StyleBox["A", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SuperscriptBox["A", 
       TagBox[
        RowBox[{"-", "1"}],
        Inverse]], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["A", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SuperscriptBox["A", "T"], TraditionalForm]], "InlineMath"], " "}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->288211436],

Cell["Matrix Operations", "Caption",
 CellID->31894157]
}, Open  ]],

Cell[CellGroupData[{

Cell["Logical Operations", "Section",
 CellID->114100951],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["And",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/And"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[And]", 
       SubscriptBox["p", "2"], "\[And]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Implies",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Implies"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"a", "\[Implies]", "b"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Nand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nand"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[Nand]", 
       SubscriptBox["p", "2"], "\[Nand]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Nor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nor"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[Nor]", 
       SubscriptBox["p", "2"], "\[Nor]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Not",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Not"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[Not]", "p"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Or",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Or"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[Or]", 
       SubscriptBox["p", "2"], "\[Or]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Xor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Xor"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[Xor]", 
       SubscriptBox["p", "2"], "\[Xor]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->195585217],

Cell["Logical Operations", "Caption",
 CellID->302304917]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculus", "Section",
 CellID->181171459],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["C",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/C"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["c",
        C], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["x", "TI"], "]"}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"D", "[", 
       RowBox[{"f", "(", "x", ")"}], "]"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{"\[PartialD]", 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[PartialD]", "x"}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", "2"}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["\[PartialD]", "2"], 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[PartialD]", 
        SuperscriptBox["x", "2"]}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["\[PartialD]", "n"], 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[PartialD]", 
        SuperscriptBox["x", "n"]}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["x", "TI"], "]"}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[DifferentialD]",
        Dt], 
       RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{"\[DifferentialD]", 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[DifferentialD]", "x"}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", "2"}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["\[DifferentialD]", "2"], 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[DifferentialD]", 
        SuperscriptBox["x", "2"]}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["\[DifferentialD]", "n"], 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[DifferentialD]", 
        SuperscriptBox["x", "n"]}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Derivative",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}], "[", 
     StyleBox["f", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Derivative",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Derivative"], "[", "2", "]"}], "[", 
     StyleBox["f", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SuperscriptBox["f", "\[Prime]\[Prime]",
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Derivative",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Derivative"], "[", 
      RowBox[{
       SubscriptBox[
        StyleBox["d", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "]"}], "[", 
     StyleBox["f", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SuperscriptBox["f", 
       TagBox[
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["d", "1"], ",", "\[Ellipsis]"}], ")"}],
        Derivative],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["FourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["t", "TI"], ",", 
      StyleBox["s", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[ScriptCapitalF]", "t"], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", "s", ")"}]}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["FourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[ScriptCapitalF]", 
         RowBox[{
          SubscriptBox["t", "1"], ",", 
          SubscriptBox["t", "2"], ",", "\[Ellipsis]"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["s", "1"], ",", 
         SubscriptBox["s", "2"], ",", "\[Ellipsis]"}], ")"}]}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[Integral]", 
       RowBox[{
        StyleBox["expr",
         FontSlant->"Italic"], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[Integral]", 
       RowBox[{"\[Integral]", 
        RowBox[{"\[Integral]", 
         RowBox[{
          StyleBox["expr",
           FontSlant->"Italic"], 
          RowBox[{"\[DifferentialD]", "z"}], 
          RowBox[{"\[DifferentialD]", "y"}], 
          RowBox[{"\[DifferentialD]", 
           SubscriptBox["x", "1"]}]}]}]}]}], TraditionalForm]], "InlineMath"],
     " "},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", "a", "b"], 
       RowBox[{
        StyleBox["expr",
         FontSlant->"Italic"], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["z", "TI"], ",", 
        StyleBox["p", "TI"], ",", 
        StyleBox["q", "TI"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", "a", "b"], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", "m", "n"], 
        RowBox[{
         SubsuperscriptBox["\[Integral]", "p", "q"], 
         RowBox[{
          StyleBox["expr",
           FontSlant->"Italic"], 
          RowBox[{"\[DifferentialD]", "z"}], 
          RowBox[{"\[DifferentialD]", "y"}], 
          RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["t", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalF]", "s", 
         RowBox[{"-", "1"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", "t", ")"}]}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalF]", 
         RowBox[{
          SubscriptBox["s", "1"], ",", 
          SubscriptBox["s", "2"], ",", "\[Ellipsis]"}], 
         RowBox[{"-", "1"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["t", "1"], ",", 
         SubscriptBox["t", "2"], ",", "\[Ellipsis]"}], ")"}]}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseLaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseLaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["t", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalL]", "s", 
         RowBox[{"-", "1"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", "t", ")"}]}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseLaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseLaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalL]", 
         RowBox[{
          SubscriptBox["s", "1"], ",", 
          SubscriptBox["s", "2"], ",", "\[Ellipsis]"}], 
         RowBox[{"-", "1"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["t", "1"], ",", 
         SubscriptBox["t", "2"], ",", "\[Ellipsis]"}], ")"}]}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["t", "TI"], ",", 
      StyleBox["s", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[ScriptCapitalL]", "t"], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", "s", ")"}]}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[ScriptCapitalL]", 
         RowBox[{
          SubscriptBox["t", "1"], ",", 
          SubscriptBox["t", "2"], ",", "\[Ellipsis]"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["s", "1"], ",", 
         SubscriptBox["s", "2"], ",", "\[Ellipsis]"}], ")"}]}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{
       StyleBox["x", "TI"], "\[Rule]", 
       StyleBox["a", "TI"]}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       UnderscriptBox["lim", 
        RowBox[{"x", "\[Rule]", "a"}]], "\[ThinSpace]", 
       RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{
       StyleBox["x", "TI"], "\[Rule]", 
       StyleBox["a", "TI"]}], ",", 
      RowBox[{
       ButtonBox["Direction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Direction"], "\[Rule]", 
       RowBox[{"+", "1"}]}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       UnderscriptBox["lim", 
        RowBox[{"x", "\[Rule]", 
         SuperscriptBox["a", "-"]}]], "\[ThinSpace]", 
       RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{
       StyleBox["x", "TI"], "\[Rule]", 
       StyleBox["a", "TI"]}], ",", 
      RowBox[{
       ButtonBox["Direction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Direction"], "\[Rule]", 
       RowBox[{"-", "1"}]}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       UnderscriptBox["lim", 
        RowBox[{"x", "\[Rule]", 
         SuperscriptBox["a", "+"]}]], "\[ThinSpace]", 
       RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["O",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/O"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"O", "(", "x", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["O",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/O"], "[", 
      StyleBox["x", "TI"], "]"}], "^", 
     StyleBox["n", "TI"]}], Cell[BoxData[
     FormBox[
      SuperscriptBox[
       RowBox[{"O", "(", "x", ")"}], "n"], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["O",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/O"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["a", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"O", "(", 
       RowBox[{"x", "-", "a"}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["O",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/O"], "[", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["a", "TI"]}], "]"}], "^", 
     StyleBox["n", "TI"]}], Cell[BoxData[
     FormBox[
      SuperscriptBox[
       RowBox[{"O", "(", 
        RowBox[{"x", "-", "a"}], ")"}], "n"], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Piecewise",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Piecewise"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["2", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[Piecewise]", GridBox[{
         {
          SubscriptBox["v", "1"], 
          SubscriptBox["c", "1"]},
         {
          SubscriptBox["v", "2"], 
          SubscriptBox["c", "2"]},
         {"\[Ellipsis]", ""}
        }]}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Residue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Residue"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"res", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"], ",", "0"}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{
        RowBox[{"f", "(", "a", ")"}], "+", 
        InterpretationBox[
         RowBox[{"O", "(", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "a"}], ")"}], "1"], ")"}],
         SeriesData[x, a, {}, 0, 1, 1],
         Editable->False]}],
       SeriesData[x, a, {
         f[a]}, 0, 1, 1],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"], ",", "1"}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{
        RowBox[{"f", "(", "a", ")"}], "+", 
        RowBox[{
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "(", "a", ")"}], 
         RowBox[{"(", 
          RowBox[{"x", "-", "a"}], ")"}]}], "+", 
        InterpretationBox[
         RowBox[{"O", "(", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "a"}], ")"}], "2"], ")"}],
         SeriesData[x, a, {}, 0, 2, 1],
         Editable->False]}],
       SeriesData[x, a, {
         f[a], 
         Derivative[1][f][a]}, 0, 2, 1],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Tan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tan"], "[", 
       RowBox[{
        StyleBox["z", "TI"], "^", 
        RowBox[{"(", 
         RowBox[{"2", "/", "3"}], ")"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["z", "TI"], ",", "0", ",", "3"}], "}"}]}], "]"}], Cell[
    BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{
        SuperscriptBox["z", 
         RowBox[{"2", "/", "3"}]], "+", 
        FractionBox[
         SuperscriptBox["z", "2"], "3"], "+", 
        FractionBox[
         RowBox[{"2", 
          SuperscriptBox["z", 
           RowBox[{"10", "/", "3"}]]}], "15"], "+", 
        InterpretationBox[
         RowBox[{"O", "(", 
          SuperscriptBox["z", 
           RowBox[{"11", "/", "3"}]], ")"}],
         SeriesData[z, 0, {}, 2, 11, 3],
         Editable->False]}],
       SeriesData[z, 0, {1, 0, 0, 0, 
         Rational[1, 3], 0, 0, 0, 
         Rational[2, 15]}, 2, 11, 3],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->31464861],

Cell["Calculus", "Caption",
 CellID->152276491]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polynomial Functions", "Section",
 CellID->445326134],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["Cyclotomic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cyclotomic"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["C",
         Cyclotomic], "n"], "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolynomialMod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialMod"], "[", 
     RowBox[{
      StyleBox["poly", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{"poly", "mod", "m"}],
       PolynomialMod[FE`Conversion`Private`poly, FE`Conversion`Private`m],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->301871925],

Cell["Polynomial Functions", "Caption",
 CellID->453638472]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complete Alphabetical Listing", "Section",
 CellID->170305176],

Cell[BoxData[GridBox[{
   {"StandardForm", "TraditionalForm", ""},
   {
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["AiryAi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryAi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Ai", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["AiryAiPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryAiPrime"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["AiryBi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryBi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Bi", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["AiryBiPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AiryBiPrime"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["Bi", "\[Prime]"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    ButtonBox["Algebraics",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Algebraics"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalA]",
       Function[{}, Algebraics]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["And",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/And"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[And]", 
       SubscriptBox["p", "2"], "\[And]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["AppellF1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AppellF1"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["c", "TI"], ",", 
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox[
        SubscriptBox["F", "1"],
        AppellF1,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{
        RowBox[{"a", ";", 
         SubscriptBox["b", "1"]}], ",", 
        RowBox[{
         SubscriptBox["b", "2"], ";", "c", ";", "x"}], ",", "y"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["ArcCos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCos"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cos", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCosh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCosh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cosh", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCot"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cot", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCoth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCoth"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["coth", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCsc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCsc"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["csc", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcCsch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCsch"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["csch", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcSec",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSec"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sec", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcSech",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSech"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sech", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcSin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSin"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sin", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcSinh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSinh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sinh", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcTan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTan"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["tan", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArcTanh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTanh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["tanh", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ArithmeticGeometricMean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArithmeticGeometricMean"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["agm",
        ArithmeticGeometricMean,
        Editable->False,
        Selectable->False], 
       RowBox[{"(", 
        RowBox[{"a", ",", "b"}], ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["BernoulliB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BernoulliB"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["B",
        BernoulliB], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["BernoulliB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BernoulliB"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["B",
         BernoulliB], "n"], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["BesselI",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselI"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["I", "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["BesselJ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselJ"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["J", "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["BesselK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselK"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["K", "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["BesselY",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BesselY"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["Y", "n"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Beta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Beta"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[CapitalBeta]",
        Beta,
        Editable->False,
        Selectable->False], 
       RowBox[{"(", 
        RowBox[{"a", ",", "b"}], ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Beta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Beta"], "[", 
     RowBox[{
      StyleBox["z", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["\[CapitalBeta]",
         Beta,
         Editable->False,
         Selectable->False], "z"], "(", 
       RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Beta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Beta"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        InterpretationBox["\[CapitalBeta]",
         Beta,
         Editable->False,
         Selectable->False], "(", 
        RowBox[{
         SubscriptBox["z", "0"], ",", 
         SubscriptBox["z", "1"], ",", "a", ",", "b"}]}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["BetaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BetaRegularized"], "[", 
     RowBox[{
      StyleBox["z", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["I",
         BetaRegularized,
         Editable->False,
         Selectable->False], "z"], 
       RowBox[{"(", 
        RowBox[{"a", ",", "b"}], ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["BetaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BetaRegularized"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["I",
         BetaRegularized,
         Editable->False,
         Selectable->False], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["z", "0"], ",", 
          SubscriptBox["z", "1"]}], ")"}]], 
       RowBox[{"(", 
        RowBox[{"a", ",", "b"}], ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Binomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Binomial"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"(", GridBox[{
          {
           TagBox["n",
            Identity,
            Editable->True]},
          {
           TagBox["m",
            Identity,
            Editable->True]}
         }], ")"}],
       InterpretTemplate[Binomial[#, #2]& ],
       Editable->True], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    ButtonBox["Booleans",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Booleans"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalB]",
       Function[{}, Booleans]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["C",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/C"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["c",
        C], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["CarmichaelLambda",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CarmichaelLambda"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[Lambda]",
        CarmichaelLambda,
        Editable->False,
        Selectable->False], 
       RowBox[{"(", "n", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["Catalan",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Catalan"], Cell[BoxData[
     FormBox[
      TagBox["C",
       Function[{}, Catalan]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Ceiling",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ceiling"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[LeftCeiling]", "z", "\[RightCeiling]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ChebyshevT",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChebyshevT"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["T", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ChebyshevU",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChebyshevU"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["U", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ClebschGordan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ClebschGordan"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["3", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[LeftAngleBracket]", 
        RowBox[{
         RowBox[{
          SubscriptBox["j", "1"], "\[MediumSpace]", 
          SubscriptBox["j", "2"], "\[MediumSpace]", 
          SubscriptBox["m", "1"], "\[MediumSpace]", 
          SubscriptBox["m", "2"]}], "\[MediumSpace]", "\[VerticalSeparator]", 
         "\[MediumSpace]", 
         RowBox[{
          SubscriptBox["j", "1"], "\[MediumSpace]", 
          SubscriptBox["j", "2"], "\[MediumSpace]", 
          SubscriptBox["j", "3"], "\[MediumSpace]", 
          SubscriptBox["m", "3"]}]}], "\[RightAngleBracket]"}],
       ClebschGordan,
       StripWrapperBoxes->True], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["Complexes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complexes"], Cell[BoxData[
     FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Cos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cos"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cos", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Cos",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cos"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cos", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Cosh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cosh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cosh", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Cosh",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cosh"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cosh", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["CosIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CosIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Ci", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["CoshIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CoshIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Chi", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Cot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cot"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cot", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Cot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cot"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cot", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Coth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Coth"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"coth", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Coth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Coth"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["coth", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Csc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Csc"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"csc", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Csc",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Csc"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["csc", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Csch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Csch"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"csch", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Csch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Csch"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["csch", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Cyclotomic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cyclotomic"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["C",
         Cyclotomic], "n"], "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     "\[Star]"},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["x", "TI"], "]"}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"D", "[", 
       RowBox[{"f", "(", "x", ")"}], "]"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{"\[PartialD]", 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[PartialD]", "x"}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", "2"}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["\[PartialD]", "2"], 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[PartialD]", 
        SuperscriptBox["x", "2"]}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["\[PartialD]", "n"], 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[PartialD]", 
        SuperscriptBox["x", "n"]}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["x", "TI"], "]"}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        TagBox["\[DifferentialD]",
         Dt], "f"}], 
       RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{"\[DifferentialD]", 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[DifferentialD]", "x"}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", "2"}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["\[DifferentialD]", "2"], 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[DifferentialD]", 
        SuperscriptBox["x", "2"]}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Dt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dt"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["\[DifferentialD]", "n"], 
        RowBox[{"f", "(", "x", ")"}]}], 
       RowBox[{"\[DifferentialD]", 
        SuperscriptBox["x", "n"]}],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["DedekindEta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DedekindEta"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Eta]", "(", 
        TagBox["t",
         Identity,
         Editable->True], ")"}],
       InterpretTemplate[DedekindEta[#]& ]], TraditionalForm]], "InlineMath"],
     "\[Star]"},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Derivative",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}], "[", 
     StyleBox["f", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Derivative",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Derivative"], "[", "2", "]"}], "[", 
     StyleBox["f", "TI"], "]"}], Cell[BoxData[
     FormBox[Cell[BoxData[
       FormBox[
        SuperscriptBox["f", "\[Prime]\[Prime]",
         MultilineFunction->None], TraditionalForm]], "InlineMath"], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Derivative",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Derivative"], "[", 
      RowBox[{
       SubscriptBox[
        StyleBox["d", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "]"}], "[", 
     StyleBox["f", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SuperscriptBox["f", 
       TagBox[
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["d", "1"], ",", "\[Ellipsis]"}], ")"}],
        Derivative],
       MultilineFunction->None], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Det",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Det"], "[", 
     StyleBox["A", "TI"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[LeftBracketingBar]", 
        TagBox["A",
         Function[BoxForm`e$, 
          TableForm[BoxForm`e$, TableDepth -> 0]]], 
        "\[RightBracketingBar]"}],
       {Det}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["DiracDelta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiracDelta"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[Delta]",
        DiracDelta,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", 
        SubscriptBox["x", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["DiscreteDelta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiscreteDelta"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[Delta]",
        DiscreteDelta,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["DivisorSigma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DivisorSigma"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["\[Sigma]",
         DivisorSigma], "k"], 
       RowBox[{"(", "n", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticE"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"E", "(", "m", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["EllipticE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticE"], "[", 
     RowBox[{
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{Cell[BoxData[
        FormBox[
         RowBox[{"E", "(", 
          RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
         TraditionalForm]], "InlineMath"], " "}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticF"], "[", 
     RowBox[{
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{Cell[BoxData[
        FormBox[
         RowBox[{"F", "(", 
          RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
         TraditionalForm]], "InlineMath"], " "}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticK",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticK"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"K", "(", "m", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["EllipticNomeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticNomeQ"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["q",
        EllipticNomeQ,
        Editable->False,
        Selectable->False], 
       RowBox[{"(", "m", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticPi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticPi"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalPi]", "(", 
       RowBox[{"n", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticPi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticPi"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalPi]", "(", 
       RowBox[{"n", ";", 
        RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}]}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EllipticTheta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticTheta"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["u", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[CurlyTheta]", "a"], "(", 
       RowBox[{"u", ",", "q"}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["EllipticThetaPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EllipticThetaPrime"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["u", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["\[CurlyTheta]",
         EllipticThetaPrime], "a", "\[Prime]"], 
       RowBox[{"(", 
        RowBox[{"u", ",", "q"}], ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Erf",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erf"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"erf", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Erf",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erf"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"erf", "(", 
       RowBox[{
        SubscriptBox["z", "0"], ",", 
        SubscriptBox["z", "1"]}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Erfc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erfc"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"erfc", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Erfi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Erfi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"erfi", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["EulerE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EulerE"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["E",
        EulerE], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EulerE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EulerE"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["E",
         EulerE], "n"], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["EulerGamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EulerGamma"], Cell[BoxData[
     FormBox["\[DoubledGamma]", TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["EulerPhi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EulerPhi"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[Phi]",
        EulerPhi], "(", "n", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["ExpIntegralE",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpIntegralE"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["E",
         ExpIntegralE], "n"], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["ExpIntegralEi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpIntegralEi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Ei", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Fibonacci",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fibonacci"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["F",
        Fibonacci], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Fibonacci",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fibonacci"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["F",
         Fibonacci], "n"], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Floor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Floor"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[LeftFloor]", "z", "\[RightFloor]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["FourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["t", "TI"], ",", 
      StyleBox["s", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[ScriptCapitalF]", "t"], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", "s", ")"}]}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["FourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[ScriptCapitalF]", 
         RowBox[{
          SubscriptBox["t", "1"], ",", 
          SubscriptBox["t", "2"], ",", "\[Ellipsis]"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["s", "1"], ",", 
         SubscriptBox["s", "2"], ",", "\[Ellipsis]"}], ")"}]}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["FractionalPart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FractionalPart"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"frac", "(", "x", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["FresnelC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FresnelC"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["C",
        FresnelC], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["FresnelS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FresnelS"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["S",
        FresnelS], "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalGamma]", "(", 
       RowBox[{"a", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalGamma]", "(", 
       RowBox[{"a", ",", 
        SubscriptBox["z", "1"], ",", 
        SubscriptBox["z", "2"]}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["GammaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GammaRegularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["Q",
        GammaRegularized,
        Editable->False,
        Selectable->False], 
       RowBox[{"(", 
        RowBox[{"a", ",", "z"}], ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["GammaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GammaRegularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["1", "TR"]]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["Q",
        GammaRegularized,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{"a", ",", 
        SubscriptBox["z", "0"], ",", 
        SubscriptBox["z", "1"]}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["GCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GCD"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"gcd", "(", 
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["GegenbauerC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GegenbauerC"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["C", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["GegenbauerC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GegenbauerC"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["C", "n", 
        RowBox[{"(", "m", ")"}]], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    ButtonBox["Glaisher",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Glaisher"], Cell[BoxData[
     FormBox[
      TagBox["A",
       Function[{}, Glaisher]], TraditionalForm]], "InlineMath"], " "},
   {
    ButtonBox["GoldenRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GoldenRatio"], Cell[BoxData[
     FormBox[
      TagBox["\[Phi]",
       Function[{}, GoldenRatio]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["HarmonicNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HarmonicNumber"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       InterpretationBox["H",
        HarmonicNumber,
        Editable->False,
        Selectable->False], "n"], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["HarmonicNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HarmonicNumber"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["r", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      SubsuperscriptBox[
       InterpretationBox["H",
        HarmonicNumber,
        Editable->False,
        Selectable->False], "n", 
       RowBox[{"(", "r", ")"}]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["HermiteH",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HermiteH"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["H", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Hypergeometric0F1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric0F1"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "0"], 
          SubscriptBox["F", "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox["\[Null]",
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric0F1,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["a",
              Hypergeometric0F1,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric0F1,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric0F1,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
        Editable->False],
       Hypergeometric0F1], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric0F1Regularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric0F1Regularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "0"], 
          SubscriptBox[
           OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox["\[Null]",
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric0F1Regularized,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["a",
              Hypergeometric0F1Regularized,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric0F1Regularized,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric0F1Regularized,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
        Editable->False],
       Hypergeometric0F1Regularized], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric1F1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric1F1"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
          SubscriptBox["F", "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             TagBox["a",
              Hypergeometric1F1,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric1F1,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["b",
              Hypergeometric1F1,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric1F1,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric1F1,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
        Editable->False],
       Hypergeometric1F1], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric1F1Regularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric1F1Regularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
          SubscriptBox[
           OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             TagBox["a",
              Hypergeometric1F1Regularized,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric1F1Regularized,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["b",
              Hypergeometric1F1Regularized,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric1F1Regularized,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric1F1Regularized,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
        Editable->False],
       Hypergeometric1F1Regularized], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric2F1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric2F1"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["c", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
          SubscriptBox["F", "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             RowBox[{
              TagBox["a",
               Hypergeometric2F1,
               Editable->True], ",", 
              TagBox["b",
               Hypergeometric2F1,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["c",
              Hypergeometric2F1,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric2F1,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
        Editable->False],
       Hypergeometric2F1], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Hypergeometric2F1Regularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hypergeometric2F1Regularized"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["c", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
          SubscriptBox[
           OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             RowBox[{
              TagBox["a",
               Hypergeometric2F1Regularized,
               Editable->True], ",", 
              TagBox["b",
               Hypergeometric2F1Regularized,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1Regularized,
            Editable->False], ";", 
           TagBox[
            TagBox[
             TagBox["c",
              Hypergeometric2F1Regularized,
              Editable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1Regularized,
            Editable->False], ";", 
           TagBox["z",
            Hypergeometric2F1Regularized,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
        Editable->False],
       Hypergeometric2F1Regularized], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["HypergeometricPFQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricPFQ"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["p", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["q", "TI"]]}], "}"}], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", Cell[BoxData[
            FormBox["p", TraditionalForm]], "InlineMath"]], 
          SubscriptBox["F", Cell[BoxData[
            FormBox["q", TraditionalForm]], "InlineMath"]]}], 
         "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             RowBox[{
              TagBox[
               SubscriptBox["a", "1"],
               HypergeometricPFQ,
               Editable->True], ",", 
              TagBox[
               SubscriptBox["a", "2"],
               HypergeometricPFQ,
               Editable->True], ",", 
              TagBox["\[Ellipsis]",
               HypergeometricPFQ,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            HypergeometricPFQ,
            Editable->False], ";", 
           TagBox[
            TagBox[
             RowBox[{
              TagBox[
               SubscriptBox["b", "1"],
               HypergeometricPFQ,
               Editable->True], ",", 
              TagBox[
               SubscriptBox["b", "2"],
               HypergeometricPFQ,
               Editable->True], ",", 
              TagBox["\[Ellipsis]",
               HypergeometricPFQ,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            HypergeometricPFQ,
            Editable->False], ";", 
           TagBox["z",
            HypergeometricPFQ,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
        Editable->False],
       HypergeometricPFQ], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["HypergeometricPFQRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricPFQRegularized"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["p", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["q", "TI"]]}], "}"}], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", Cell[BoxData[
            FormBox["p", TraditionalForm]], "InlineMath"]], 
          SubscriptBox[
           OverscriptBox["F", "~"], Cell[BoxData[
            FormBox["q", TraditionalForm]], "InlineMath"]]}], 
         "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             RowBox[{
              TagBox[
               SubscriptBox["a", "1"],
               HypergeometricPFQRegularized,
               Editable->True], ",", 
              TagBox[
               SubscriptBox["a", "2"],
               HypergeometricPFQRegularized,
               Editable->True], ",", 
              TagBox["\[Ellipsis]",
               HypergeometricPFQRegularized,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            HypergeometricPFQRegularized,
            Editable->False], ";", 
           TagBox[
            TagBox[
             RowBox[{
              TagBox[
               SubscriptBox["b", "1"],
               HypergeometricPFQRegularized,
               Editable->True], ",", 
              TagBox[
               SubscriptBox["b", "2"],
               HypergeometricPFQRegularized,
               Editable->True], ",", 
              TagBox["\[Ellipsis]",
               HypergeometricPFQRegularized,
               Editable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            HypergeometricPFQRegularized,
            Editable->False], ";", 
           TagBox["z",
            HypergeometricPFQRegularized,
            Editable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
        Editable->False],
       HypergeometricPFQRegularized], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["HypergeometricU",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricU"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["U",
        HypergeometricU], 
       RowBox[{"(", 
        RowBox[{"a", ",", "b", ",", "z"}], ")"}]}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Implies",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Implies"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"a", "\[Implies]", "b"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalZ]",
       Function[{}, Integers]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[Integral]", 
       RowBox[{
        StyleBox["expr",
         FontSlant->"Italic"], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[Integral]", 
       RowBox[{"\[Integral]", 
        RowBox[{"\[Integral]", 
         RowBox[{
          StyleBox["expr",
           FontSlant->"Italic"], 
          RowBox[{"\[DifferentialD]", "z"}], 
          RowBox[{"\[DifferentialD]", "y"}], 
          RowBox[{"\[DifferentialD]", 
           SubscriptBox["x", "1"]}]}]}]}]}], TraditionalForm]], "InlineMath"],
     " "},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", "a", "b"], 
       RowBox[{
        StyleBox["expr",
         FontSlant->"Italic"], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["z", "TI"], ",", 
        StyleBox["p", "TI"], ",", 
        StyleBox["q", "TI"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["\[Integral]", "a", "b"], 
       RowBox[{
        SubsuperscriptBox["\[Integral]", "m", "n"], 
        RowBox[{
         SubsuperscriptBox["\[Integral]", "p", "q"], 
         RowBox[{
          StyleBox["expr",
           FontSlant->"Italic"], 
          RowBox[{"\[DifferentialD]", "z"}], 
          RowBox[{"\[DifferentialD]", "y"}], 
          RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Inverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inverse"], "[", 
     StyleBox["A", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SuperscriptBox["A", 
       TagBox[
        RowBox[{"-", "1"}],
        Inverse]], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseBetaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseBetaRegularized"], "[", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        InterpretationBox["I",
         BetaRegularized,
         Editable->False,
         Selectable->False], "s", 
        RowBox[{"-", "1"}]], 
       RowBox[{"(", 
        RowBox[{"a", ",", "b"}], ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseBetaRegularized",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseBetaRegularized"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        InterpretationBox["I",
         BetaRegularized,
         Editable->False,
         Selectable->False], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["z", "0"], ",", "s"}], ")"}], 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseEllipticNomeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseEllipticNomeQ"], "[", 
     StyleBox["q", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox[
        InterpretationBox["q",
         EllipticNomeQ,
         Editable->False,
         Selectable->False], 
        RowBox[{"-", "1"}]], 
       RowBox[{"(", "q", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseErf",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseErf"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]], ",", 
      StyleBox["s", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["erf", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{
        SubscriptBox["z", "0"], ",", "s"}], ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["t", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalF]", "s", 
         RowBox[{"-", "1"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", "t", ")"}]}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFourierTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalF]", 
         RowBox[{
          SubscriptBox["s", "1"], ",", 
          SubscriptBox["s", "2"], ",", "\[Ellipsis]"}], 
         RowBox[{"-", "1"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["t", "1"], ",", 
         SubscriptBox["t", "2"], ",", "\[Ellipsis]"}], ")"}]}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseFunction"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       SuperscriptBox["f", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]],
       InverseFunction,
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiCD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cd", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiCN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiCN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cn", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiCS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiCS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["cs", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiDC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiDC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["dc", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiDN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiDN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["dn", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiDS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiDS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["ds", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiNC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiNC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["nc", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiND",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiND"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["nd", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiNS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiNS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["ns", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiSC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiSC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{
        SuperscriptBox["sc", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}],
       InverseFunction], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiSD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiSD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sd", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseJacobiSN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseJacobiSN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sn", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["InverseLaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseLaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["t", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalL]", "s", 
         RowBox[{"-", "1"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", "t", ")"}]}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseLaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseLaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[ScriptCapitalL]", 
         RowBox[{
          SubscriptBox["s", "1"], ",", 
          SubscriptBox["s", "2"], ",", "\[Ellipsis]"}], 
         RowBox[{"-", "1"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["t", "1"], ",", 
         SubscriptBox["t", "2"], ",", "\[Ellipsis]"}], ")"}]}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["InverseWeierstrassP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseWeierstrassP"], "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["\[WeierstrassP]", 
        RowBox[{"-", "1"}]], "(", 
       RowBox[{
        RowBox[{"p", ";", 
         SubscriptBox["g", "2"]}], ",", 
        SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["JacobiAmplitude",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiAmplitude"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"am", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["JacobiCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiCD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cd", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiCN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiCN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cn", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiCS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiCS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"cs", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiDC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiDC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"dc", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiDN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiDN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"dn", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiDS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiDS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"ds", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiNC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiNC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"nc", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiND",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiND"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"nd", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiNS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiNS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"ns", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiSC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiSC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sc", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiSD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiSD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sd", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiSN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiSN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sn", "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiP"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["P", "n", 
        RowBox[{"(", 
         RowBox[{"a", ",", "b"}], ")"}]], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["JacobiSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiSymbol"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"(", 
        FractionBox["n", "m"], ")"}],
       JacobiSymbol,
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["JacobiZeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiZeta"], "[", 
     RowBox[{
      StyleBox["\[Phi]", "TR"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[CapitalZeta]", "(", 
       RowBox[{"\[Phi]", "\[VerticalSeparator]", "m"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["KleinInvariantJ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KleinInvariantJ"], "[", 
     StyleBox["\[Tau]", "TR"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"J", "(", 
        TagBox["\[Tau]",
         Identity,
         Editable->True], ")"}],
       InterpretTemplate[KleinInvariantJ[#]& ]], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["KroneckerDelta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KroneckerDelta"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       InterpretationBox["\[Delta]",
        KroneckerDelta,
        Editable->False,
        Selectable->False], 
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}]], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["LaguerreL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaguerreL"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["L", "n"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LaguerreL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaguerreL"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["L", "n", "a"], "(", "x", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["P",
         LegendreP], "n"], "(", "x", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["P",
         LegendreP], "n", "m"], 
       RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["LegendreP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreP"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["P",
         LegendreP], "n", "m"], "(", 
       TagBox["z",
        HoldComplete[LegendreP, FE`Conversion`Private`a]], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["LaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["t", "TI"], ",", 
      StyleBox["s", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[ScriptCapitalL]", "t"], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", "s", ")"}]}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LaplaceTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LaplaceTransform"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["t", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[ScriptCapitalL]", 
         RowBox[{
          SubscriptBox["t", "1"], ",", 
          SubscriptBox["t", "2"], ",", "\[Ellipsis]"}]], "[", 
        StyleBox["expr",
         FontSlant->"Italic"], "]"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["s", "1"], ",", 
         SubscriptBox["s", "2"], ",", "\[Ellipsis]"}], ")"}]}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LCM",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LCM"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"lcm", "(", 
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LegendreQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreQ"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["Q",
         LegendreQ], "n"], 
       RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["LegendreQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreQ"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["Q",
         LegendreQ], "n", "m"], 
       RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["LegendreQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LegendreQ"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["Q",
         LegendreQ], "n", "m"], 
       RowBox[{"(", 
        TagBox["z",
         HoldComplete[LegendreQ, FE`Conversion`Private`a]], ")"}]}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["LerchPhi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LerchPhi"], "[", 
     RowBox[{
      StyleBox["z", "TI"], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["a", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[CapitalPhi]", "(", 
        RowBox[{
         TagBox["z",
          LerchPhi,
          Editable->True], ",", 
         TagBox["s",
          LerchPhi,
          Editable->True], ",", 
         TagBox["a",
          LerchPhi,
          Editable->True]}], ")"}],
       InterpretTemplate[
        Function[{ZetaDump`e1$, ZetaDump`e2$, ZetaDump`e3$}, 
         LerchPhi[ZetaDump`e1$, ZetaDump`e2$, ZetaDump`e3$]]]], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{
       StyleBox["x", "TI"], "\[Rule]", 
       StyleBox["a", "TI"]}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       UnderscriptBox["lim", 
        RowBox[{"x", "\[Rule]", "a"}]], "\[ThinSpace]", 
       RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{
       StyleBox["x", "TI"], "\[Rule]", 
       StyleBox["a", "TI"]}], ",", 
      RowBox[{
       ButtonBox["Direction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Direction"], "\[Rule]", 
       RowBox[{"+", "1"}]}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       UnderscriptBox["lim", 
        RowBox[{"x", "\[Rule]", 
         SuperscriptBox["a", "-"]}]], "\[ThinSpace]", 
       RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Limit",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Limit"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{
       StyleBox["x", "TI"], "\[Rule]", 
       StyleBox["a", "TI"]}], ",", 
      RowBox[{
       ButtonBox["Direction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Direction"], "\[Rule]", 
       RowBox[{"-", "1"}]}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       UnderscriptBox["lim", 
        RowBox[{"x", "\[Rule]", 
         SuperscriptBox["a", "+"]}]], "\[ThinSpace]", 
       RowBox[{"f", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"log", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     RowBox[{
      StyleBox["b", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["log", "b"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Log",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Log"], "[", 
      StyleBox["z", "TI"], "]"}], "^", 
     StyleBox["p", "TI"]}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["log", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["Log",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Log"], "[", 
      RowBox[{
       StyleBox["b", "TI"], ",", 
       StyleBox["z", "TI"]}], "]"}], "^", 
     StyleBox["p", "TI"]}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["log", "b", "p"], "(", "z", ")"}], TraditionalForm]],
      "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LogGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogGamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"log\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["LogIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"li", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["MathieuCharacteristicA",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuCharacteristicA"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["a",
         MathieuCharacteristicA,
         Editable->False,
         Selectable->False], "r"], "(", "q", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["MathieuCharacteristicB",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathieuCharacteristicB"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["b",
         MathieuCharacteristicB,
         Editable->False,
         Selectable->False], "r"], 
       RowBox[{"(", "q", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["MeijerG",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MeijerG"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["n", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["n", "TI"]], "+", "1"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["p", "TI"]]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["m", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["m", "TI"]], "+", "1"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["q", "TI"]]}], "}"}]}], "}"}], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["G",
         MeijerG], 
        RowBox[{"6", ",", "6"}], 
        RowBox[{"3", ",", "3"}]], "\[InvisibleApplication]", 
       RowBox[{"(", 
        RowBox[{
         TagBox["z",
          MeijerG,
          Editable->True], "\[VerticalSeparator]", GridBox[{
           {
            RowBox[{
             TagBox[
              SubscriptBox["a", "1"],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", "n"],
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", 
               RowBox[{"n", "+", "1"}]],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", "p"],
              MeijerG,
              Editable->True]}]},
           {
            RowBox[{
             TagBox[
              SubscriptBox["b", "1"],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", "m"],
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", 
               RowBox[{"m", "+", "1"}]],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", "q"],
              MeijerG,
              Editable->True]}]}
          }]}], ")"}]}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["MeijerG",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MeijerG"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["n", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["n", "TI"]], "+", "1"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["p", "TI"]]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["m", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["m", "TI"]], "+", "1"}], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["q", "TI"]]}], "}"}]}], "}"}], ",", 
      StyleBox["z", "TI"], ",", 
      StyleBox["r", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        TagBox["G",
         MeijerG], 
        RowBox[{"6", ",", "6"}], 
        RowBox[{"3", ",", "3"}]], "\[InvisibleApplication]", 
       RowBox[{"(", 
        RowBox[{
         TagBox[
          RowBox[{
           TagBox["z",
            MeijerG,
            Editable->True], ",", 
           TagBox["r",
            MeijerG,
            Editable->True]}],
          MeijerG], "\[VerticalSeparator]", GridBox[{
           {
            RowBox[{
             TagBox[
              SubscriptBox["a", "1"],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", "n"],
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", 
               RowBox[{"n", "+", "1"}]],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["a", "p"],
              MeijerG,
              Editable->True]}]},
           {
            RowBox[{
             TagBox[
              SubscriptBox["b", "1"],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", "m"],
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", 
               RowBox[{"m", "+", "1"}]],
              MeijerG,
              Editable->True], ",", 
             TagBox["\[Ellipsis]",
              MeijerG,
              Editable->True], ",", 
             TagBox[
              SubscriptBox["b", "q"],
              MeijerG,
              Editable->True]}]}
          }]}], ")"}]}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{"m", "mod", "n"}],
       Mod[FE`Conversion`Private`m, FE`Conversion`Private`n],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["ModularLambda",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ModularLambda"], "[", 
     StyleBox["\[Tau]", "TR"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Lambda]", "(", 
        TagBox["\[Tau]",
         Identity,
         Editable->True], ")"}],
       InterpretTemplate[ModularLambda[#]& ]], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["MoebiusMu",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MoebiusMu"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[Mu]",
        MoebiusMu], 
       RowBox[{"(", "n", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Multinomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Multinomial"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["k", "TI"]]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["n", "1"], "+", 
           SubscriptBox["n", "2"], "+", 
           SubscriptBox["n", "k"], "+", "\[Ellipsis]"}], ";", 
          SubscriptBox["n", "1"]}], ",", 
         SubscriptBox["n", "2"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["n", "k"]}], ")"}],
       Multinomial], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["MultiplicativeOrder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MultiplicativeOrder"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["ord", "n"], "(", "k", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Nand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nand"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[Nand]", 
       SubscriptBox["p", "2"], "\[Nand]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["NevilleThetaC",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NevilleThetaC"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{Cell[BoxData[
        FormBox[
         RowBox[{
          SubscriptBox["\[CurlyTheta]", "c"], "(", 
          RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], 
         TraditionalForm]], "InlineMath"], " "}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["NevilleThetaD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NevilleThetaD"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[CurlyTheta]", "d"], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["NevilleThetaN",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NevilleThetaN"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["\[CurlyTheta]", "n"], "(", 
       RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["NevilleThetaS",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NevilleThetaS"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{Cell[BoxData[
        FormBox[
         RowBox[{
          SubscriptBox["\[CurlyTheta]", "s"], "(", 
          RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], 
         TraditionalForm]], "InlineMath"], " "}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Nor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nor"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[Nor]", 
       SubscriptBox["p", "2"], "\[Nor]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Not",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Not"], "[", 
     StyleBox["p", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[Not]", "p"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["O",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/O"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"O", "(", "x", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["O",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/O"], "[", 
      StyleBox["x", "TI"], "]"}], "^", 
     StyleBox["n", "TI"]}], Cell[BoxData[
     FormBox[
      SuperscriptBox[
       RowBox[{"O", "(", "x", ")"}], "n"], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["O",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/O"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["a", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"O", "(", 
       RowBox[{"x", "-", "a"}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     RowBox[{
      ButtonBox["O",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/O"], "[", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["a", "TI"]}], "]"}], "^", 
     StyleBox["n", "TI"]}], Cell[BoxData[
     FormBox[
      SuperscriptBox[
       RowBox[{"O", "(", 
        RowBox[{"x", "-", "a"}], ")"}], "n"], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Or",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Or"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[Or]", 
       SubscriptBox["p", "2"], "\[Or]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["PartitionsP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PartitionsP"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["p",
        PartitionsP], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["PartitionsQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PartitionsQ"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["q",
        PartitionsQ], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Piecewise",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Piecewise"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["2", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[Piecewise]", GridBox[{
         {
          SubscriptBox["v", "1"], 
          SubscriptBox["c", "1"]},
         {
          SubscriptBox["v", "2"], 
          SubscriptBox["c", "2"]},
         {"\[Ellipsis]", ""}
        }]}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Pochhammer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pochhammer"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       SubscriptBox[
        RowBox[{"(", "a", ")"}], "n"],
       Pochhammer], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolyGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyGamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[Psi]",
        PolyGamma], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolyGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyGamma"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox[
        TagBox["\[Psi]",
         PolyGamma], 
        RowBox[{"(", "n", ")"}]], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolyLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyLog"], "[", 
     RowBox[{
      StyleBox["\[Nu]", "TR"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["Li",
         PolyLog,
         Editable->False,
         Selectable->False], "\[Nu]"], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolyLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolyLog"], "[", 
     RowBox[{
      StyleBox["\[Nu]", "TR"], ",", 
      StyleBox["p", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["S",
         PolyLog,
         Editable->False,
         Selectable->False], 
        RowBox[{"\[Nu]", ",", "p"}]], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["PolynomialMod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialMod"], "[", 
     RowBox[{
      StyleBox["poly", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{"poly", "mod", "m"}],
       PolynomialMod[FE`Conversion`Private`poly, FE`Conversion`Private`m],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["PowerMod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PowerMod"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{
        SuperscriptBox["a", "b"], "mod", "n"}],
       PowerMod[
       FE`Conversion`Private`a, FE`Conversion`Private`b, 
        FE`Conversion`Private`n],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Prime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prime"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["p",
        Prime], "n"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["PrimePi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimePi"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[Pi]",
        PrimePi], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["Primes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Primes"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalP]",
       Function[{}, Primes]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["ProductLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ProductLog"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["W",
        ProductLog], "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["ProductLog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ProductLog"], "[", 
     RowBox[{
      StyleBox["k", "TI"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        TagBox["W",
         ProductLog], "k"], "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     "\[Star]"},
   {
    RowBox[{
     ButtonBox["RamanujanTau",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RamanujanTau"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[BoxData[
     FormBox[Cell[BoxData[
       FormBox[
        RowBox[{
         TagBox["\[Tau]",
          RamanujanTau], 
         RowBox[{"(", "n", ")"}]}], TraditionalForm]], "InlineMath"], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    ButtonBox["Rationals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rationals"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalQ]",
       Function[{}, Rationals]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"], Cell[BoxData[
     FormBox[
      TagBox["\[DoubleStruckCapitalR]",
       Function[{}, Reals]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Residue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Residue"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"res", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["RiemannSiegelTheta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RiemannSiegelTheta"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["\[CurlyTheta]",
        RiemannSiegelTheta], "(", "t", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["RiemannSiegelZ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RiemannSiegelZ"], "[", 
     StyleBox["t", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["Z",
        RiemannSiegelZ], 
       RowBox[{"(", "t", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Sec",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sec"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sec", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Sec",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sec"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sec", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Sech",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sech"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sech", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Sech",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sech"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sech", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"], ",", "0"}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{
        RowBox[{"f", "(", "a", ")"}], "+", 
        InterpretationBox[
         RowBox[{"O", "(", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "a"}], ")"}], "1"], ")"}],
         SeriesData[x, a, {}, 0, 1, 1],
         Editable->False]}],
       SeriesData[x, a, {
         f[a]}, 0, 1, 1],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"], ",", "1"}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{
        RowBox[{"f", "(", "a", ")"}], "+", 
        RowBox[{
         RowBox[{
          SuperscriptBox["f", "\[Prime]",
           MultilineFunction->None], "(", "a", ")"}], 
         RowBox[{"(", 
          RowBox[{"x", "-", "a"}], ")"}]}], "+", 
        InterpretationBox[
         RowBox[{"O", "(", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x", "-", "a"}], ")"}], "2"], ")"}],
         SeriesData[x, a, {}, 0, 2, 1],
         Editable->False]}],
       SeriesData[x, a, {
         f[a], 
         Derivative[1][f][a]}, 0, 2, 1],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Tan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tan"], "[", 
       RowBox[{
        StyleBox["z", "TI"], "^", 
        RowBox[{"(", 
         RowBox[{"2", "/", "3"}], ")"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["z", "TI"], ",", "0", ",", "3"}], "}"}]}], "]"}], Cell[
    BoxData[
     FormBox[
      InterpretationBox[
       RowBox[{
        SuperscriptBox["z", 
         RowBox[{"2", "/", "3"}]], "+", 
        FractionBox[
         SuperscriptBox["z", "2"], "3"], "+", 
        FractionBox[
         RowBox[{"2", 
          SuperscriptBox["z", 
           RowBox[{"10", "/", "3"}]]}], "15"], "+", 
        InterpretationBox[
         RowBox[{"O", "(", 
          SuperscriptBox["z", 
           RowBox[{"11", "/", "3"}]], ")"}],
         SeriesData[z, 0, {}, 2, 11, 3],
         Editable->False]}],
       SeriesData[z, 0, {1, 0, 0, 0, 
         Rational[1, 3], 0, 0, 0, 
         Rational[2, 15]}, 2, 11, 3],
       Editable->False], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Sign",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sign"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sgn", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Signature",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Signature"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["\[CurlyEpsilon]",
        Signature], 
       RowBox[{
        SubscriptBox["e", "1"], ",", 
        SubscriptBox["e", "2"], ",", "\[Ellipsis]"}]], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sin", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Sin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sin"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sin", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Sinh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sinh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"sinh", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Sinh",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sinh"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["sinh", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["SinIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SinIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Si", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["SinhIntegral",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SinhIntegral"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"Shi", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["SixJSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SixJSymbol"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["3", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["4", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["5", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["6", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["{",
        SixJSymbol], "\[MediumSpace]", GridBox[{
         {
          SubscriptBox["j", "1"], 
          SubscriptBox["j", "2"], 
          SubscriptBox["j", "3"]},
         {
          SubscriptBox["j", "4"], 
          SubscriptBox["j", "5"], 
          SubscriptBox["j", "6"]}
        }], "\[MediumSpace]", 
       TagBox["}",
        SixJSymbol]}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["SphericalHarmonicY",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalHarmonicY"], "[", 
     RowBox[{
      StyleBox["l", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["\[Theta]", "TR"], ",", 
      StyleBox["\[Phi]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubsuperscriptBox["Y", "l", "m"], "(", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["StieltjesGamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StieltjesGamma"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SubscriptBox[
       TagBox["\[Gamma]",
        StieltjesGamma], "z"], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["StirlingS1",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StirlingS1"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      SubsuperscriptBox[
       TagBox["S",
        StirlingS1], "n", 
       RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["StirlingS2",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StirlingS2"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      SubsuperscriptBox[
       TagBox["\[ScriptCapitalS]",
        StirlingS2], "n", 
       RowBox[{"(", "m", ")"}]], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["StruveH",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StruveH"], "[", 
     RowBox[{
      StyleBox["\[Nu]", "TR"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["H",
         StruveH,
         Editable->False,
         Selectable->False], "\[Nu]"], 
       RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["StruveL",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StruveL"], "[", 
     RowBox[{
      StyleBox["\[Nu]", "TR"], ",", 
      StyleBox["z", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox[
        InterpretationBox["L",
         StruveL,
         Editable->False,
         Selectable->False], "\[Nu]"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{"SumOfSquaresR", "[", 
     RowBox[{
      StyleBox["d", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox[
        SubscriptBox["r", "d"],
        SumOfSquaresR], 
       RowBox[{"(", "n", ")"}]}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["Tan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tan"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"tan", "(", "z", ")"}], TraditionalForm]], "InlineMath"], " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Tan",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Tan"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["tan", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Tanh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tanh"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"tanh", "(", "z", ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    SuperscriptBox[
     RowBox[{
      ButtonBox["Tanh",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Tanh"], "[", 
      StyleBox["z", "TI"], "]"}], 
     StyleBox["p", "TI"]], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox["tanh", "p"], "(", "z", ")"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["ThreeJSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ThreeJSymbol"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["3", "TR"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       TagBox["(",
        ThreeJSymbol], "\[MediumSpace]", GridBox[{
         {
          SubscriptBox["j", "1"], 
          SubscriptBox["j", "2"], 
          SubscriptBox["j", "3"]},
         {
          SubscriptBox["m", "1"], 
          SubscriptBox["m", "2"], 
          SubscriptBox["m", "3"]}
        }], "\[MediumSpace]", 
       TagBox[")",
        ThreeJSymbol]}], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["A", "TI"], "]"}], Cell[BoxData[
     FormBox[
      SuperscriptBox["A", "T"], TraditionalForm]], "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["UnitStep",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnitStep"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       InterpretationBox["\[Theta]",
        UnitStep,
        Editable->False,
        Selectable->False], "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", 
        SubscriptBox["x", "2"], ",", "\[Ellipsis]"}], ")"}], 
      TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["WeierstrassP",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassP"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{"\[WeierstrassP]", "(", 
       RowBox[{
        RowBox[{"u", ";", 
         SubscriptBox["g", "2"]}], ",", 
        SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"], 
    " "},
   {
    RowBox[{
     ButtonBox["WeierstrassPPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassPPrime"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SuperscriptBox[
        TagBox["\[WeierstrassP]",
         WeierstrassPPrime], "\[Prime]"], "(", 
       RowBox[{
        RowBox[{"u", ";", 
         SubscriptBox["g", "2"]}], ",", 
        SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"], 
    "\[Star]"},
   {
    RowBox[{
     ButtonBox["WeierstrassSigma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassSigma"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Sigma]", "(", 
        RowBox[{
         RowBox[{
          TagBox["u",
           Identity,
           Editable->True], ";", 
          TagBox[
           SubscriptBox["g", "2"],
           Identity,
           Editable->True]}], ",", 
         TagBox[
          SubscriptBox["g", "3"],
          Identity,
          Editable->True]}], ")"}],
       InterpretTemplate[WeierstrassSigma[#, {#2, #3}]& ]], TraditionalForm]],
      "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["WeierstrassZeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WeierstrassZeta"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Zeta]", "(", 
        RowBox[{
         RowBox[{
          TagBox["u",
           Identity,
           Editable->True], ";", 
          TagBox[
           SubscriptBox["g", "2"],
           Identity,
           Editable->True]}], ",", 
         TagBox[
          SubscriptBox["g", "3"],
          Identity,
          Editable->True]}], ")"}],
       InterpretTemplate[WeierstrassZeta[#, {#2, #3}]& ]], TraditionalForm]], 
     "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Xor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Xor"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[BoxData[
     FormBox[
      RowBox[{
       SubscriptBox["p", "1"], "\[Xor]", 
       SubscriptBox["p", "2"], "\[Xor]", "\[Ellipsis]"}], TraditionalForm]], 
     "InlineMath"], " "},
   {
    RowBox[{
     ButtonBox["Zeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Zeta"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Zeta]", "(", 
        TagBox["s",
         Zeta,
         Editable->True], ")"}],
       InterpretTemplate[
        Function[BoxForm`e$, 
         Zeta[BoxForm`e$]]]], TraditionalForm]], "InlineMath"], "\[Star]"},
   {
    RowBox[{
     ButtonBox["Zeta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Zeta"], "[", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      StyleBox["a", "TI"]}], "]"}], Cell[BoxData[
     FormBox[
      TagBox[
       RowBox[{"\[Zeta]", "(", 
        RowBox[{
         TagBox["s",
          Zeta,
          Editable->True], ",", 
         TagBox["a",
          Zeta,
          Editable->True]}], ")"}],
       InterpretTemplate[
        Function[{ZetaDump`e1$, ZetaDump`e2$}, 
         Zeta[ZetaDump`e1$, ZetaDump`e2$]]]], TraditionalForm]], 
     "InlineMath"], "\[Star]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.49], 
     Scaled[0.49], {
      Scaled[0.02]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->111233779],

Cell["Complete Alphabetical Listing", "Caption",
 CellID->693551364]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraditionalForm Reference Information - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 16.6719386}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "TraditionalForm differs from StandardForm, the default format for input \
and output. It is important to understand that TraditionalForm expressions \
cannot always be provided as unambiguous input to Mathematica. Therefore, \
while StandardForm is an input format and an output format, TraditionalForm \
is primarily intended as an output format. In general, the TraditionalForm \
representation of a mathematical function differs from its StandardForm \
representation in two ways: function arguments are enclosed in parentheses \
rather than square brackets, and one-character variable and function names \
are set in italics rather than plain text. In addition to these general \
differences, TraditionalForm transforms a large group of expressions into \
their conventionally used mathematical notation. A table listing these \
expressions and their special TraditionalForm representations appears later \
in this tutorial. ", "synonyms" -> {}, "title" -> 
    "TraditionalForm Reference Information", "type" -> "Tutorial", "uri" -> 
    "tutorial/TraditionalFormReferenceInformation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 74, 1, 70, "Title",
 CellID->509267359],
Cell[805, 32, 1039, 31, 70, "Text",
 CellID->17215110],
Cell[1847, 65, 603, 17, 70, "Text",
 CellID->18700063],
Cell[2453, 84, 576, 16, 70, "Text",
 CellID->38053170],
Cell[3032, 102, 445, 14, 70, "MathCaption",
 CellID->26309000],
Cell[CellGroupData[{
Cell[3502, 120, 177, 6, 28, "Input",
 CellID->5603324],
Cell[3682, 128, 272, 8, 50, "Output",
 CellID->708768304]
}, Open  ]],
Cell[3969, 139, 264, 8, 70, "MathCaption",
 CellID->479149574],
Cell[CellGroupData[{
Cell[4258, 151, 164, 5, 28, "Input",
 CellID->5695427],
Cell[4425, 158, 454, 19, 66, "Output",
 CellID->370167349]
}, Open  ]],
Cell[4894, 180, 240, 8, 70, "MathCaption",
 CellID->8768708],
Cell[CellGroupData[{
Cell[5159, 192, 284, 10, 70, "Input",
 CellID->27149348],
Cell[5446, 204, 733, 23, 66, "Output",
 CellID->342224362]
}, Open  ]],
Cell[6194, 230, 493, 17, 70, "Text",
 CellID->225042333],
Cell[6690, 249, 413, 16, 70, "MathCaption",
 CellID->130723508],
Cell[CellGroupData[{
Cell[7128, 269, 303, 10, 70, "Input",
 CellID->243341238],
Cell[7434, 281, 436, 15, 54, "Output",
 CellID->823617867]
}, Open  ]],
Cell[7885, 299, 719, 21, 70, "Text",
 CellID->224179794],
Cell[CellGroupData[{
Cell[8629, 324, 73, 1, 70, "Section",
 CellID->395391501],
Cell[8705, 327, 2949, 89, 70, "DefinitionBox3Col",
 CellID->795589712],
Cell[11657, 418, 74, 1, 70, "Caption",
 CellID->162120449]
}, Open  ]],
Cell[CellGroupData[{
Cell[11768, 424, 57, 1, 70, "Section",
 CellID->27810147],
Cell[11828, 427, 1798, 56, 70, "DefinitionBox3Col",
 CellID->608319635],
Cell[13629, 485, 57, 1, 70, "Caption",
 CellID->61634746]
}, Open  ]],
Cell[CellGroupData[{
Cell[13723, 491, 59, 1, 70, "Section",
 CellID->612969727],
Cell[13785, 494, 12545, 436, 70, "DefinitionBox3Col",
 CellID->492944256],
Cell[26333, 932, 59, 1, 70, "Caption",
 CellID->380058058]
}, Open  ]],
Cell[CellGroupData[{
Cell[26429, 938, 66, 1, 70, "Section",
 CellID->264957115],
Cell[26498, 941, 8497, 290, 70, "DefinitionBox3Col",
 CellID->577877001],
Cell[34998, 1233, 66, 1, 70, "Caption",
 CellID->527980380]
}, Open  ]],
Cell[CellGroupData[{
Cell[35101, 1239, 61, 1, 70, "Section",
 CellID->62975293],
Cell[35165, 1242, 9133, 319, 70, "DefinitionBox3Col",
 CellID->538471409],
Cell[44301, 1563, 62, 1, 70, "Caption",
 CellID->251720177]
}, Open  ]],
Cell[CellGroupData[{
Cell[44400, 1569, 51, 1, 70, "Section",
 CellID->15695834],
Cell[44454, 1572, 6337, 214, 70, "DefinitionBox3Col",
 CellID->310587361],
Cell[50794, 1788, 52, 1, 70, "Caption",
 CellID->115397346],
Cell[50849, 1791, 36, 1, 70, "Text",
 CellID->287445040]
}, Open  ]],
Cell[CellGroupData[{
Cell[50922, 1797, 60, 1, 70, "Section",
 CellID->41657222],
Cell[50985, 1800, 4067, 138, 70, "DefinitionBox3Col",
 CellID->239776720],
Cell[55055, 1940, 59, 1, 70, "Caption",
 CellID->5549651]
}, Open  ]],
Cell[CellGroupData[{
Cell[55151, 1946, 71, 1, 70, "Section",
 CellID->247025698],
Cell[55225, 1949, 30439, 995, 70, "DefinitionBox3Col",
 CellID->638742201],
Cell[85667, 2946, 71, 1, 70, "Caption",
 CellID->495383214]
}, Open  ]],
Cell[CellGroupData[{
Cell[85775, 2952, 61, 1, 70, "Section",
 CellID->144833340],
Cell[85839, 2955, 5237, 177, 70, "DefinitionBox3Col",
 CellID->12622022],
Cell[91079, 3134, 60, 1, 70, "Caption",
 CellID->33051293]
}, Open  ]],
Cell[CellGroupData[{
Cell[91176, 3140, 55, 1, 70, "Section",
 CellID->34148502],
Cell[91234, 3143, 1984, 67, 70, "DefinitionBox3Col",
 CellID->16400739],
Cell[93221, 3212, 56, 1, 70, "Caption",
 CellID->315000117]
}, Open  ]],
Cell[CellGroupData[{
Cell[93314, 3218, 57, 1, 70, "Section",
 CellID->431097278],
Cell[93374, 3221, 3355, 106, 70, "DefinitionBox3Col",
 CellID->696356759],
Cell[96732, 3329, 55, 1, 70, "Caption",
 CellID->6173067]
}, Open  ]],
Cell[CellGroupData[{
Cell[96824, 3335, 56, 1, 70, "Section",
 CellID->14624774],
Cell[96883, 3338, 18763, 619, 70, "DefinitionBox3Col",
 CellID->149266478],
Cell[115649, 3959, 56, 1, 70, "Caption",
 CellID->97324429]
}, Open  ]],
Cell[CellGroupData[{
Cell[115742, 3965, 55, 1, 70, "Section",
 CellID->31528676],
Cell[115800, 3968, 1402, 44, 70, "DefinitionBox3Col",
 CellID->194212853],
Cell[117205, 4014, 56, 1, 70, "Caption",
 CellID->216417174]
}, Open  ]],
Cell[CellGroupData[{
Cell[117298, 4020, 72, 1, 70, "Section",
 CellID->320937540],
Cell[117373, 4023, 3143, 104, 70, "DefinitionBox3Col",
 CellID->78557113],
Cell[120519, 4129, 72, 1, 70, "Caption",
 CellID->128888406]
}, Open  ]],
Cell[CellGroupData[{
Cell[120628, 4135, 56, 1, 70, "Section",
 CellID->153379974],
Cell[120687, 4138, 1410, 45, 70, "DefinitionBox3Col",
 CellID->288211436],
Cell[122100, 4185, 55, 1, 70, "Caption",
 CellID->31894157]
}, Open  ]],
Cell[CellGroupData[{
Cell[122192, 4191, 57, 1, 70, "Section",
 CellID->114100951],
Cell[122252, 4194, 3611, 121, 70, "DefinitionBox3Col",
 CellID->195585217],
Cell[125866, 4317, 57, 1, 70, "Caption",
 CellID->302304917]
}, Open  ]],
Cell[CellGroupData[{
Cell[125960, 4323, 47, 1, 70, "Section",
 CellID->181171459],
Cell[126010, 4326, 23540, 777, 70, "DefinitionBox3Col",
 CellID->31464861],
Cell[149553, 5105, 47, 1, 70, "Caption",
 CellID->152276491]
}, Open  ]],
Cell[CellGroupData[{
Cell[149637, 5111, 59, 1, 70, "Section",
 CellID->445326134],
Cell[149699, 5114, 1263, 39, 70, "DefinitionBox3Col",
 CellID->301871925],
Cell[150965, 5155, 59, 1, 70, "Caption",
 CellID->453638472]
}, Open  ]],
Cell[CellGroupData[{
Cell[151061, 5161, 68, 1, 70, "Section",
 CellID->170305176],
Cell[151132, 5164, 134609, 4512, 70, "DefinitionBox3Col",
 CellID->111233779],
Cell[285744, 9678, 68, 1, 70, "Caption",
 CellID->693551364]
}, Open  ]]
}, Open  ]],
Cell[285839, 9683, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

