(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12514,        450]
NotebookOptionsPosition[      8428,        324]
NotebookOutlinePosition[     10995,        391]
CellTagsIndexPosition[     10904,        385]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Functions and Programs" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/FunctionsAndProgramsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Functions and Programs\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Transformation Rules for Functions", "Title",
 CellTags->{"S1.7.4", "4.1"},
 CellID->10597],

Cell[TextData[{
 "\"",
 ButtonBox["Values for Symbols",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ValuesForSymbols"],
 "\" discussed how you can use transformation rules of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "->", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " to replace symbols by values. The notion of transformation rules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is, however, quite general. You can set up transformation rules not only \
for symbols, but for any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. "
}], "Text",
 CellID->14334],

Cell[TextData[{
 "Applying the transformation rule ",
 Cell[BoxData[
  RowBox[{"x", "->", "3"}]], "InlineFormula"],
 " replaces ",
 Cell[BoxData["x"], "InlineFormula"],
 " by ",
 Cell[BoxData["3"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", 
   RowBox[{"f", "[", "x", "]"}], "+", 
   RowBox[{"f", "[", "y", "]"}]}], "/.", 
  RowBox[{"x", "->", "3"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22426],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"f", "[", "3", "]"}], "+", 
  RowBox[{"f", "[", "y", "]"}]}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->20043]
}, Open  ]],

Cell[TextData[{
 "You can also use a transformation rule for ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 ". This rule does not affect ",
 Cell[BoxData[
  RowBox[{"f", "[", "y", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", 
   RowBox[{"f", "[", "x", "]"}], "+", 
   RowBox[{"f", "[", "y", "]"}]}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "->", "p"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->13592],

Cell[BoxData[
 RowBox[{"1", "+", "p", "+", 
  RowBox[{"f", "[", "y", "]"}]}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->28761]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"f", "[", "t_", "]"}]], "InlineFormula"],
 " is a ",
 StyleBox["pattern",
  FontSlant->"Italic"],
 " that stands for ",
 Cell[BoxData["f"], "InlineFormula"],
 " with any argument. "
}], "MathCaption",
 CellID->17269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", 
   RowBox[{"f", "[", "x", "]"}], "+", 
   RowBox[{"f", "[", "y", "]"}]}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], "->", 
   RowBox[{"t", "^", "2"}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->5175],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->31139]
}, Open  ]],

Cell[TextData[{
 "Probably the most powerful aspect of transformation rules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that they can involve not only literal expressions, but also ",
 StyleBox["patterns",
  FontSlant->"Italic"],
 ". A pattern is an expression such as ",
 Cell[BoxData[
  RowBox[{"f", "[", "t_", "]"}]], "InlineFormula"],
 " which contains a blank (underscore). The blank can stand for any \
expression. Thus, a transformation rule for ",
 Cell[BoxData[
  RowBox[{"f", "[", "t_", "]"}]], "InlineFormula"],
 " specifies how the function ",
 Cell[BoxData["f"], "InlineFormula"],
 " with ",
 StyleBox["any",
  FontSlant->"Italic"],
 " argument should be transformed. Notice that, in contrast, a transformation \
rule for ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 " without a blank, specifies only how the literal expression ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 " should be transformed, and does not, for example, say anything about the \
transformation of ",
 Cell[BoxData[
  RowBox[{"f", "[", "y", "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24696],

Cell[TextData[{
 "When you give a function definition such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{"t", "^", "2"}]}]], "InlineFormula"],
 ", all you are doing is telling ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to automatically apply the transformation rule ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], "->", 
   RowBox[{"t", "^", "2"}]}]], "InlineFormula"],
 " whenever possible. "
}], "Text",
 CellID->19481],

Cell["\<\
You can set up transformation rules for expressions of any form. \
\>", "MathCaption",
 CellID->14471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", " ", "b"}], "]"}], "+", 
   RowBox[{"f", "[", 
    RowBox[{"c", " ", "d"}], "]"}]}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", " ", "y_"}], "]"}], "->", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "+", 
    RowBox[{"f", "[", "y", "]"}]}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->30268],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a", "]"}], "+", 
  RowBox[{"f", "[", "b", "]"}], "+", 
  RowBox[{"f", "[", "c", "]"}], "+", 
  RowBox[{"f", "[", "d", "]"}]}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->16713]
}, Open  ]],

Cell[TextData[{
 "This uses a transformation rule for ",
 Cell[BoxData[
  RowBox[{"x", "^", "p_"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "+", 
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"x", "^", "4"}]}], "/.", 
  RowBox[{
   RowBox[{"x", "^", "p_"}], "->", 
   RowBox[{"f", "[", "p", "]"}]}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->16030],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"f", "[", "2", "]"}], "+", 
  RowBox[{"f", "[", "4", "]"}]}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->10806]
}, Open  ]],

Cell[TextData[{
 "\"",
 ButtonBox["Patterns",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PatternsOverview"],
 "\" and \"",
 ButtonBox["Transformation Rules and Definitions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TransformationRulesAndDefinitionsOverview"],
 "\" will explain in detail how to set up patterns and transformation rules \
for any kind of expression. Suffice it to say here that in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " all expressions have a definite symbolic structure; transformation rules \
allow you to transform parts of that structure. "
}], "Text",
 CellID->27109],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->335161677],

Cell[TextData[ButtonBox["Functions and Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionsAndProgramsOverview"]], "RelatedTutorials",
 CellID->1392681]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Transformation Rules for Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functions and Programs", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionsAndProgramsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RepetitiveOperations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 18.5469866}", "context" -> "", 
    "keywords" -> {
     "->", "-", "functions", "patterns", "transformation rules"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"Values for Symbols\" discussed how you can use transformation rules of \
the form x->value to replace symbols by values. The notion of transformation \
rules in Mathematica is, however, quite general. You can set up \
transformation rules not only for symbols, but for any Mathematica \
expression. Applying the transformation rule x->3 replaces x by 3. You can \
also use a transformation rule for f[x]. This rule does not affect f[y]. ", 
    "synonyms" -> {"1.7.4"}, "title" -> "Transformation Rules for Functions", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/TransformationRulesForFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.7.4"->{
  Cell[1265, 43, 97, 2, 70, "Title",
   CellTags->{"S1.7.4", "4.1"},
   CellID->10597]},
 "4.1"->{
  Cell[1265, 43, 97, 2, 70, "Title",
   CellTags->{"S1.7.4", "4.1"},
   CellID->10597]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.7.4", 10693, 374},
 {"4.1", 10792, 378}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 640, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1265, 43, 97, 2, 70, "Title",
 CellTags->{"S1.7.4", "4.1"},
 CellID->10597],
Cell[1365, 47, 623, 19, 70, "Text",
 CellID->14334],
Cell[1991, 68, 256, 10, 70, "MathCaption",
 CellID->16647],
Cell[CellGroupData[{
Cell[2272, 82, 205, 7, 28, "Input",
 CellID->22426],
Cell[2480, 91, 243, 8, 36, "Output",
 CellID->20043]
}, Open  ]],
Cell[2738, 102, 268, 9, 70, "MathCaption",
 CellID->3244],
Cell[CellGroupData[{
Cell[3031, 115, 234, 8, 28, "Input",
 CellID->13592],
Cell[3268, 125, 215, 7, 36, "Output",
 CellID->28761]
}, Open  ]],
Cell[3498, 135, 257, 10, 70, "MathCaption",
 CellID->17269],
Cell[CellGroupData[{
Cell[3780, 149, 258, 9, 28, "Input",
 CellID->5175],
Cell[4041, 160, 235, 8, 36, "Output",
 CellID->31139]
}, Open  ]],
Cell[4291, 171, 1150, 32, 70, "Text",
 CellID->24696],
Cell[5444, 205, 486, 16, 70, "Text",
 CellID->19481],
Cell[5933, 223, 112, 3, 70, "MathCaption",
 CellID->14471],
Cell[CellGroupData[{
Cell[6070, 230, 385, 14, 70, "Input",
 CellID->30268],
Cell[6458, 246, 310, 10, 36, "Output",
 CellID->16713]
}, Open  ]],
Cell[6783, 259, 159, 6, 70, "MathCaption",
 CellID->27666],
Cell[CellGroupData[{
Cell[6967, 269, 249, 9, 70, "Input",
 CellID->16030],
Cell[7219, 280, 243, 8, 36, "Output",
 CellID->10806]
}, Open  ]],
Cell[7477, 291, 624, 16, 70, "Text",
 CellID->27109],
Cell[CellGroupData[{
Cell[8126, 311, 72, 1, 70, "RelatedTutorialsSection",
 CellID->335161677],
Cell[8201, 314, 173, 4, 70, "RelatedTutorials",
 CellID->1392681]
}, Open  ]]
}, Open  ]],
Cell[8401, 322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

