(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13533,        484]
NotebookOptionsPosition[      8985,        346]
NotebookOutlinePosition[     11873,        419]
CellTagsIndexPosition[     11782,        413]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expand" :> Documentation`HelpLookup["paclet:ref/Expand"], 
          "Factor" :> Documentation`HelpLookup["paclet:ref/Factor"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Expand\"\>", 
       2->"\<\"Factor\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Transforming Algebraic Expressions", "Title",
 CellTags->{"S1.4.3", "3.1"},
 CellID->32759],

Cell[TextData[{
 "There are often many different ways to write the same algebraic expression. \
As one example, the expression ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"], TraditionalForm]], "InlineMath"],
 " can be written as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", "2", "x", "+", 
    SuperscriptBox["x", "2"]}], TraditionalForm]], "InlineMath"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a large collection of functions for converting between different \
forms of algebraic expressions."
}], "Text",
 CellID->31103],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Expand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["\<\
multiply out products and powers, writing the result as a sum of terms\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Factor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factor"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "write ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as a product of minimal factors"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->606],

Cell["\<\
Two common functions for transforming algebraic expressions. \
\>", "Caption",
 CellID->391],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " gives the \[OpenCurlyDoubleQuote]expanded form\[CloseCurlyDoubleQuote], \
with products and powers multiplied out. "
}], "MathCaption",
 CellID->2093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->13196],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->20583]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " recovers the original form."
}], "MathCaption",
 CellID->17950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->17557],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->7435]
}, Open  ]],

Cell[TextData[{
 "It is easy to generate complicated expressions with ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x", "+", 
     RowBox[{"3", " ", "y"}]}], ")"}], "^", "4"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6667],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"4", " ", "x"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  SuperscriptBox["x", "4"], "+", 
  RowBox[{"12", " ", "y"}], "+", 
  RowBox[{"36", " ", "x", " ", "y"}], "+", 
  RowBox[{"36", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "3"], " ", "y"}], "+", 
  RowBox[{"54", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"108", " ", "x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"54", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"108", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{"108", " ", "x", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{"81", " ", 
   SuperscriptBox["y", "4"]}]}]], "Output",
 ImageSize->{360, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->10869]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " often gives you simpler expressions. "
}], "MathCaption",
 CellID->10165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->1903],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    RowBox[{"3", " ", "y"}]}], ")"}], "4"]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->30973]
}, Open  ]],

Cell[TextData[{
 "There are some cases, though, where ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " can give you more complicated expressions. "
}], "MathCaption",
 CellID->27791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "10"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->2516],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"], "-", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}]}]], "Output",
 ImageSize->{334, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->6149]
}, Open  ]],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " gives the \[OpenCurlyDoubleQuote]simpler\[CloseCurlyDoubleQuote] form. "
}], "MathCaption",
 CellID->4515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30118],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->24243]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->77107],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Transforming Algebraic Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ValuesForSymbols"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SimplifyingAlgebraicExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 19.1563772}", "context" -> "", 
    "keywords" -> {
     "algebraic transformations", "Expand", "expansion", "Factor", 
      "factoring", "rewriting algebraic expressions", "transformation"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "There are often many different ways to write the same algebraic \
expression. As one example, the expression (1+x)^2 can be written as \
1+2x+x^2. Mathematica provides a large collection of functions for converting \
between different forms of algebraic expressions. Two common functions for \
transforming algebraic expressions. Expand gives the 'expanded form', with \
products and powers multiplied out. ", "synonyms" -> {"1.4.3"}, "title" -> 
    "Transforming Algebraic Expressions", "type" -> "Tutorial", "uri" -> 
    "tutorial/TransformingAlgebraicExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.3"->{
  Cell[1896, 59, 97, 2, 70, "Title",
   CellTags->{"S1.4.3", "3.1"},
   CellID->32759]},
 "3.1"->{
  Cell[1896, 59, 97, 2, 70, "Title",
   CellTags->{"S1.4.3", "3.1"},
   CellID->32759]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.3", 11571, 402},
 {"3.1", 11670, 406}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1271, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1896, 59, 97, 2, 70, "Title",
 CellTags->{"S1.4.3", "3.1"},
 CellID->32759],
Cell[1996, 63, 618, 19, 70, "Text",
 CellID->31103],
Cell[2617, 84, 897, 28, 70, "DefinitionBox",
 CellID->606],
Cell[3517, 114, 102, 3, 70, "Caption",
 CellID->391],
Cell[3622, 119, 284, 8, 70, "MathCaption",
 CellID->2093],
Cell[CellGroupData[{
Cell[3931, 131, 171, 6, 28, "Input",
 CellID->13196],
Cell[4105, 139, 234, 8, 36, "Output",
 CellID->20583]
}, Open  ]],
Cell[4354, 150, 197, 7, 70, "MathCaption",
 CellID->17950],
Cell[CellGroupData[{
Cell[4576, 161, 99, 3, 28, "Input",
 CellID->17557],
Cell[4678, 166, 224, 8, 36, "Output",
 CellID->7435]
}, Open  ]],
Cell[4917, 177, 225, 8, 70, "MathCaption",
 CellID->12],
Cell[CellGroupData[{
Cell[5167, 189, 206, 7, 70, "Input",
 CellID->6667],
Cell[5376, 198, 979, 31, 54, "Output",
 CellID->10869]
}, Open  ]],
Cell[6370, 232, 207, 7, 70, "MathCaption",
 CellID->10165],
Cell[CellGroupData[{
Cell[6602, 243, 98, 3, 70, "Input",
 CellID->1903],
Cell[6703, 248, 260, 9, 36, "Output",
 CellID->30973]
}, Open  ]],
Cell[6978, 260, 254, 8, 70, "MathCaption",
 CellID->27791],
Cell[CellGroupData[{
Cell[7257, 272, 146, 5, 70, "Input",
 CellID->2516],
Cell[7406, 279, 621, 21, 39, "Output",
 CellID->6149]
}, Open  ]],
Cell[8042, 303, 259, 8, 70, "MathCaption",
 CellID->4515],
Cell[CellGroupData[{
Cell[8326, 315, 99, 3, 70, "Input",
 CellID->30118],
Cell[8428, 320, 220, 8, 36, "Output",
 CellID->24243]
}, Open  ]],
Cell[CellGroupData[{
Cell[8685, 333, 68, 1, 70, "RelatedTutorialsSection",
 CellID->77107],
Cell[8756, 336, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[8958, 344, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

