(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13774,        422]
NotebookOptionsPosition[      7378,        229]
NotebookOutlinePosition[     12354,        368]
CellTagsIndexPosition[     12073,        354]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Troubleshooting on Mac OS X", "Title",
 CellTags->"i:2",
 CellID->395730225],

Cell[CellGroupData[{

Cell["Passwords", "Section",
 CellTags->{"i:17", "b:7.5", "net: 2"},
 CellID->453745388],

Cell[TextData[{
 "If the front end password dialog box appears when you launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", either ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " could not locate the mathpass file or there was no valid password in the \
mathpass file. To resolve this problem, first check that there is a mathpass \
file in one of these directories: /Library/Mathematica/Licensing, ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 "/Configuration/Licensing, or ~/Library/Mathematica/Licensing. To find the \
exact location of ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 " on your machine, evaluate the command ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 " in a notebook. If you did not find a mathpass file in these locations, \
follow the instructions in \"",
 ButtonBox["Entering a Single-Machine Password",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/EnteringASingleMachinePassword"],
 "\" to re-enter your password. "
}], "Text",
 CellTags->"b:7.5",
 CellID->650729410],

Cell[TextData[{
 "If there is a mathpass file in one of those directories, the password or \
passwords are invalid. Make sure that your MathID number matches the MathID \
number used to issue your password. If your MathID number changes, you will \
need to contact Customer Service to get a new password. Contact information \
is provided in",
 " \"",
 ButtonBox["Registration and Passwords",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RegistrationAndPasswords"],
 "\"."
}], "Text",
 CellTags->"b:7.5",
 CellID->695817]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front End Preferences", "Section",
 CellTags->{"i:18", "b:7.5", "net: 3"},
 CellID->143368624],

Cell[TextData[{
 "Front end preferences, such as the locations of recently opened and saved \
files, are stored in a front end initialization file called ",
 StyleBox["init.m", "InlineCode"],
 ". This file is located in the directory ~/Library/Mathematica/FrontEnd. If \
you need to reset the front end preferences to their default values, hold \
down ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Option", "KeyEvent"],
 " during startup. This will cause the initialization file to be rebuilt \
automatically. "
}], "Text",
 CellTags->"b:7.5",
 CellID->217739000]
}, Open  ]],

Cell[CellGroupData[{

Cell["Caches", "Section",
 CellTags->{"i:16", "b:7.5", "net: 4"},
 CellID->160900844],

Cell[TextData[{
 "Information about your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system layout, such as the locations of text resource files and Help \
Browser files, is stored in caches. These caches are located in the directory \
~/Library/Mathematica/FrontEnd/6.0\\ Caches. "
}], "Text",
 CellTags->{"b:7.5", "i:1"},
 CellID->89476322],

Cell[TextData[{
 "A corrupted cache may cause the front end to produce an error or quit \
immediately on startup. The most convenient way to restore the caches to \
their default values is to hold down ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Option", "KeyEvent"],
 " during startup. This will cause the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " caches and the initialization file to be rebuilt automatically. "
}], "Text",
 CellTags->"b:7.5",
 CellID->285974145],

Cell[TextData[{
 "If you want to rebuild your caches but retain your preferences, hold down \
",
 StyleBox["Shift", "KeyEvent"],
 " during startup. This will delete and rebuild the cache without rebuilding \
your front end initialization file."
}], "Text",
 CellTags->"b:7.5",
 CellID->96667539]
}, Open  ]],

Cell[CellGroupData[{

Cell["Technical Support", "Section",
 CellTags->{"b:7.5", "net: 5"},
 CellID->12306998],

Cell[TextData[{
 "For further assistance, check the Technical Support FAQs on the web at ",
 ButtonBox["support.wolfram.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com"], None}],
 ". If you do not find the information you need, please contact Technical \
Support by sending email to ",
 ButtonBox["support@wolfram.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["mailto:support@wolfram.com"], None}],
 " or by calling +1-217-398-6500. Include your license ID number in all \
correspondence. Your license ID number is printed on your license \
certificate. It is also available after installation by going to the ",
 StyleBox["Mathematica", "MenuName"],
 " menu and clicking ",
 StyleBox["About Mathematica", "MenuName"],
 ". You must be a registered customer in order to receive installation \
support. You must have a current ",
 StyleBox["Premier Service",
  FontSlant->"Italic"],
 " subscription to receive Technical Support."
}], "Text",
 CellTags->"b:7.5",
 CellID->150257451],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->3199642],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Troubleshooting on Mac OS X - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 23.9846258}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If the front end password dialog box appears when you launch \
Mathematica, either Mathematica could not locate the mathpass file or there \
was no valid password in the mathpass file. To resolve this problem, first \
check that there is a mathpass file in one of these directories: \
/Library/Mathematica/Licensing, \
$InstallationDirectory/Configuration/Licensing, or \
~/Library/Mathematica/Licensing. To find the exact location of \
$InstallationDirectory on your machine, evaluate the command \
$InstallationDirectory in a notebook. If you did not find a mathpass file in \
these locations, follow the instructions in \"Entering a Single-Machine \
Password\" to re-enter your password. If there is a mathpass file in one of \
those directories, the password or passwords are invalid. Make sure that your \
MathID number matches the MathID number used to issue your password. If your \
MathID number changes, you will need to contact Customer Service to get a new \
password. Contact information is provided in \"Registration and Passwords\". \
Front end preferences, such as the locations of recently opened and saved \
files, are stored in a front end initialization file called init.m. This file \
is located in the directory ~/Library/Mathematica/FrontEnd. If you need to \
reset the front end preferences to their default values, hold down \
Shift+Option during startup. This will cause the initialization file to be \
rebuilt automatically. ", "synonyms" -> {}, "title" -> 
    "Troubleshooting on Mac OS X", "type" -> "Tutorial", "uri" -> 
    "tutorial/TroubleshootingOnMacOSX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:2"->{
  Cell[1565, 48, 82, 2, 70, "Title",
   CellTags->"i:2",
   CellID->395730225]},
 "i:17"->{
  Cell[1672, 54, 88, 2, 70, "Section",
   CellTags->{"i:17", "b:7.5", "net: 2"},
   CellID->453745388]},
 "b:7.5"->{
  Cell[1672, 54, 88, 2, 70, "Section",
   CellTags->{"i:17", "b:7.5", "net: 2"},
   CellID->453745388],
  Cell[1763, 58, 1293, 30, 70, "Text",
   CellTags->"b:7.5",
   CellID->650729410],
  Cell[3059, 90, 528, 13, 70, "Text",
   CellTags->"b:7.5",
   CellID->695817],
  Cell[3624, 108, 100, 2, 70, "Section",
   CellTags->{"i:18", "b:7.5", "net: 3"},
   CellID->143368624],
  Cell[3727, 112, 600, 14, 70, "Text",
   CellTags->"b:7.5",
   CellID->217739000],
  Cell[4364, 131, 85, 2, 70, "Section",
   CellTags->{"i:16", "b:7.5", "net: 4"},
   CellID->160900844],
  Cell[4452, 135, 353, 9, 70, "Text",
   CellTags->{"b:7.5", "i:1"},
   CellID->89476322],
  Cell[4808, 146, 518, 13, 70, "Text",
   CellTags->"b:7.5",
   CellID->285974145],
  Cell[5329, 161, 295, 8, 70, "Text",
   CellTags->"b:7.5",
   CellID->96667539],
  Cell[5661, 174, 87, 2, 70, "Section",
   CellTags->{"b:7.5", "net: 5"},
   CellID->12306998],
  Cell[5751, 178, 1025, 25, 70, "Text",
   CellTags->"b:7.5",
   CellID->150257451]},
 "net: 2"->{
  Cell[1672, 54, 88, 2, 70, "Section",
   CellTags->{"i:17", "b:7.5", "net: 2"},
   CellID->453745388]},
 "i:18"->{
  Cell[3624, 108, 100, 2, 70, "Section",
   CellTags->{"i:18", "b:7.5", "net: 3"},
   CellID->143368624]},
 "net: 3"->{
  Cell[3624, 108, 100, 2, 70, "Section",
   CellTags->{"i:18", "b:7.5", "net: 3"},
   CellID->143368624]},
 "i:16"->{
  Cell[4364, 131, 85, 2, 70, "Section",
   CellTags->{"i:16", "b:7.5", "net: 4"},
   CellID->160900844]},
 "net: 4"->{
  Cell[4364, 131, 85, 2, 70, "Section",
   CellTags->{"i:16", "b:7.5", "net: 4"},
   CellID->160900844]},
 "i:1"->{
  Cell[4452, 135, 353, 9, 70, "Text",
   CellTags->{"b:7.5", "i:1"},
   CellID->89476322]},
 "net: 5"->{
  Cell[5661, 174, 87, 2, 70, "Section",
   CellTags->{"b:7.5", "net: 5"},
   CellID->12306998]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:2", 10035, 281},
 {"i:17", 10127, 285},
 {"b:7.5", 10244, 289},
 {"net: 2", 11259, 323},
 {"i:18", 11375, 327},
 {"net: 3", 11495, 331},
 {"i:16", 11613, 335},
 {"net: 4", 11732, 339},
 {"i:1", 11848, 343},
 {"net: 5", 11953, 347}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 82, 2, 70, "Title",
 CellTags->"i:2",
 CellID->395730225],
Cell[CellGroupData[{
Cell[1672, 54, 88, 2, 70, "Section",
 CellTags->{"i:17", "b:7.5", "net: 2"},
 CellID->453745388],
Cell[1763, 58, 1293, 30, 70, "Text",
 CellTags->"b:7.5",
 CellID->650729410],
Cell[3059, 90, 528, 13, 70, "Text",
 CellTags->"b:7.5",
 CellID->695817]
}, Open  ]],
Cell[CellGroupData[{
Cell[3624, 108, 100, 2, 70, "Section",
 CellTags->{"i:18", "b:7.5", "net: 3"},
 CellID->143368624],
Cell[3727, 112, 600, 14, 70, "Text",
 CellTags->"b:7.5",
 CellID->217739000]
}, Open  ]],
Cell[CellGroupData[{
Cell[4364, 131, 85, 2, 70, "Section",
 CellTags->{"i:16", "b:7.5", "net: 4"},
 CellID->160900844],
Cell[4452, 135, 353, 9, 70, "Text",
 CellTags->{"b:7.5", "i:1"},
 CellID->89476322],
Cell[4808, 146, 518, 13, 70, "Text",
 CellTags->"b:7.5",
 CellID->285974145],
Cell[5329, 161, 295, 8, 70, "Text",
 CellTags->"b:7.5",
 CellID->96667539]
}, Open  ]],
Cell[CellGroupData[{
Cell[5661, 174, 87, 2, 70, "Section",
 CellTags->{"b:7.5", "net: 5"},
 CellID->12306998],
Cell[5751, 178, 1025, 25, 70, "Text",
 CellTags->"b:7.5",
 CellID->150257451],
Cell[CellGroupData[{
Cell[6801, 207, 70, 1, 70, "RelatedTutorialsSection",
 CellID->3199642],
Cell[6874, 210, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[7091, 217, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7351, 227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

