(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19163,        635]
NotebookOptionsPosition[     10214,        339]
NotebookOutlinePosition[     16704,        543]
CellTagsIndexPosition[     16208,        520]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Troubleshooting on Unix and Linux", "Title",
 CellTags->"i:2",
 CellID->6194508],

Cell[TextData[{
 "If you have problems using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on Unix or Linux, check this list for solutions."
}], "Text",
 CellTags->"b:6.6",
 CellID->257087412],

Cell[CellGroupData[{

Cell["CD", "Section",
 CellTags->{"i:43", "b:6.6", "net: 2"},
 CellID->644882754],

Cell[TextData[{
 "Make sure the CD is properly mounted with the correct ",
 StyleBox["mount", "InlineCode"],
 " command (see \"",
 ButtonBox["Mounting a CD on Unix and Linux",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MountingACDOnUnixAndLinux"],
 "\"). If the filenames on the CD appear in the wrong case, it means the CD \
is mounted incorrectly."
}], "BulletedText",
 CellTags->"b:6.6",
 CellID->668445527],

Cell[TextData[{
 "On HP-UX, be sure to use the ",
 StyleBox["pfs_mount", "InlineCode"],
 " command and not the ",
 StyleBox["mount", "InlineCode"],
 " command. The ",
 StyleBox["pfs_mount", "InlineCode"],
 " command mounts the CD with Rock Ridge extensions. If you use the ",
 StyleBox["mount", "InlineCode"],
 " command, the filenames on the CD may appear in all uppercase letters and",
 " ",
 "some filenames may be truncated. Note that the ",
 StyleBox["pfs_mount", "InlineCode"],
 " command needs a daemon to be running in the background."
}], "BulletedText",
 CellTags->{"i:41", "b:6.6"},
 CellID->583128688]
}, Open  ]],

Cell[CellGroupData[{

Cell["Installation", "Section",
 CellTags->{"i:36", "b:6.6", "net: 3"},
 CellID->92956338],

Cell["\<\
Make sure to run the installer from the directory in which it is located. \
\>", "Text",
 CellTags->"b:6.6",
 CellID->197661444]
}, Open  ]],

Cell[CellGroupData[{

Cell["Passwords", "Section",
 CellTags->{"i:38", "b:6.6", "net: 4"},
 CellID->65197241],

Cell[TextData[{
 "If the front end password dialog box appears when you launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", either ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " could not locate the ",
 StyleBox["mathpass", "InlineCode"],
 " file or there was no valid password in the ",
 StyleBox["mathpass", "InlineCode"],
 " file. To resolve this problem, first check that there is a ",
 StyleBox["mathpass", "InlineCode"],
 " file in one of these directories: /usr/share/Mathematica/Licensing, ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 "/Configuration/Licensing",
 ", or ",
 "~/.Mathematica/Licensing",
 ". If you did not find a ",
 StyleBox["mathpass", "InlineCode"],
 " file in these locations, follow the instructions in \"",
 ButtonBox["Entering a Single-Machine Password",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/EnteringASingleMachinePassword"],
 "\" to re-enter your password. "
}], "Text",
 CellTags->"b:6.6",
 CellID->24605077],

Cell[TextData[{
 "If there is a ",
 StyleBox["mathpass", "InlineCode"],
 " file in one of those directories, the password or passwords are invalid. \
Make sure that your MathID number matches the MathID number used to issue \
your password. If your MathID number changes, you will need to contact \
Customer Service to get a new password. Contact information is provided in",
 " \"",
 ButtonBox["Registration and Passwords",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RegistrationAndPasswords"],
 "\"."
}], "Text",
 CellTags->"b:6.6",
 CellID->89278830]
}, Open  ]],

Cell[CellGroupData[{

Cell["Paths", "Section",
 CellTags->{"i:39", "b:6.6", "net: 5"},
 CellID->607785828],

Cell[TextData[{
 "By default, the front end runs the command ",
 StyleBox["math", "InlineCode"],
 " to start the kernel. If ",
 StyleBox["math", "InlineCode"],
 " is not on the path, then you must use the ",
 StyleBox["Kernel Configuration Options", "MenuName"],
 " command in the ",
 StyleBox["Kernel", "MenuName"],
 " menu to specify the full pathname of the ",
 StyleBox["math", "InlineCode"],
 " command."
}], "Text",
 CellTags->"b:6.6",
 CellID->99531263]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front End Preferences", "Section",
 CellTags->{"i:44", "b:6.6", "net: 6"},
 CellID->35293807],

Cell[TextData[{
 "Front end preferences, such as the names of recently opened and saved \
files, are stored in ",
 "~/.Mathematica/FrontEnd",
 ". The most convenient way to reset the front end preferences to their \
default values is to restart ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using the command ",
 StyleBox["mathematica -cleanStart", "InlineCode"],
 ". This will cause the initialization file to be rebuilt automatically."
}], "Text",
 CellTags->"b:6.6",
 CellID->83537740]
}, Open  ]],

Cell[CellGroupData[{

Cell["Caches", "Section",
 CellTags->{"i:33", "b:6.6", "net: 7"},
 CellID->885871868],

Cell[TextData[{
 "Information about your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " layout, such as the locations of text resource files, is stored in caches. \
These caches are located in the directory ",
 "~/.Mathematica/FrontEnd/6.0_Caches",
 ". A corrupted cache may cause the front end to produce an error or quit \
immediately on startup. The most convenient way to reset the caches to their \
default values is to use the option ",
 StyleBox["-cleanStart", "InlineCode"],
 " at startup. This will cause the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " caches and the initialization file to be rebuilt automatically. If you \
want to rebuild your caches but retain your preferences, hold down ",
 StyleBox["Shift", "KeyEvent"],
 " during startup. This will delete and rebuild the cache without rebuilding \
the front end initialization file."
}], "Text",
 CellTags->{"b:6.6", "i:1"},
 CellID->121235165]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fonts ", "Section",
 CellTags->{"i:34", "b:6.6", "net: 8"},
 CellID->48411114],

Cell["\<\
Make sure that the fonts are installed on the machine that displays the front \
end or on a font server.\
\>", "BulletedText",
 CellTags->"b:6.6",
 CellID->277543901],

Cell[TextData[{
 "If you see the error ",
 StyleBox["xset: bad font path element", "InlineCode"],
 ", either the fonts are not properly installed on your machine, or your font \
path is too long and exceeds the allowable limit. Make sure the fonts are \
properly installed, or copy the fonts to a directory that is already on",
 " ",
 "the font path. "
}], "BulletedText",
 CellTags->"b:6.6",
 CellID->25502846],

Cell[TextData[{
 "On HP-UX, you may get ",
 StyleBox["xset", "InlineCode"],
 " errors for a different reason. Visit",
 " ",
 ButtonBox["support.wolfram.com/mathematica/systems/unix/hpux/xset.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com/mathematica/systems/unix/hpux/xset.html"],
     None}],
 " for a description of the problem and how to fix it."
}], "BulletedText",
 CellTags->"b:6.6",
 CellID->377019733]
}, Open  ]],

Cell[CellGroupData[{

Cell["Technical Support", "Section",
 CellTags->{"b:6.6", "net: 9"},
 CellID->72359729],

Cell[TextData[{
 "For further assistance, check the Technical Support FAQs on the web at ",
 ButtonBox["support.wolfram.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com"], None}],
 ". If you do not find the information you need, please contact Technical \
Support by sending email to ",
 ButtonBox["support@wolfram.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["mailto:support@wolfram.com"], None}],
 " or by calling +1-217-398-6500. Include your license ID number in all \
correspondence. Your license ID number is printed on your license \
certificate. It is also available after installation by going to the ",
 StyleBox["Help", "MenuName"],
 " menu and clicking ",
 StyleBox["About Mathematica", "MenuName"],
 ". You must be a registered customer in order to receive installation \
support. You must have a current ",
 StyleBox["Premier Service",
  FontSlant->"Italic"],
 " subscription to receive Technical Support."
}], "Text",
 CellTags->"b:6.6",
 CellID->71766734],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->361026799],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Troubleshooting on Unix and Linux - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 25.8440484}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If you have problems using Mathematica on Unix or Linux, check this list \
for solutions. Make sure to run the installer from the directory in which it \
is located. If the front end password dialog box appears when you launch \
Mathematica, either Mathematica could not locate the mathpass file or there \
was no valid password in the mathpass file. To resolve this problem, first \
check that there is a mathpass file in one of these directories: \
/usr/share/Mathematica/Licensing, \
$InstallationDirectory/Configuration/Licensing, or ~/.Mathematica/Licensing. \
If you did not find a mathpass file in these locations, follow the \
instructions in \"Entering a Single-Machine Password\" to re-enter your \
password. ", "synonyms" -> {}, "title" -> "Troubleshooting on Unix and Linux",
     "type" -> "Tutorial", "uri" -> 
    "tutorial/TroubleshootingOnUnixAndLinux"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:2"->{
  Cell[1565, 48, 86, 2, 70, "Title",
   CellTags->"i:2",
   CellID->6194508]},
 "b:6.6"->{
  Cell[1654, 52, 201, 7, 70, "Text",
   CellTags->"b:6.6",
   CellID->257087412],
  Cell[1880, 63, 81, 2, 70, "Section",
   CellTags->{"i:43", "b:6.6", "net: 2"},
   CellID->644882754],
  Cell[1964, 67, 419, 11, 70, "BulletedText",
   CellTags->"b:6.6",
   CellID->668445527],
  Cell[2386, 80, 613, 16, 70, "BulletedText",
   CellTags->{"i:41", "b:6.6"},
   CellID->583128688],
  Cell[3036, 101, 90, 2, 70, "Section",
   CellTags->{"i:36", "b:6.6", "net: 3"},
   CellID->92956338],
  Cell[3129, 105, 138, 4, 70, "Text",
   CellTags->"b:6.6",
   CellID->197661444],
  Cell[3304, 114, 87, 2, 70, "Section",
   CellTags->{"i:38", "b:6.6", "net: 4"},
   CellID->65197241],
  Cell[3394, 118, 1067, 29, 70, "Text",
   CellTags->"b:6.6",
   CellID->24605077],
  Cell[4464, 149, 562, 14, 70, "Text",
   CellTags->"b:6.6",
   CellID->89278830],
  Cell[5063, 168, 84, 2, 70, "Section",
   CellTags->{"i:39", "b:6.6", "net: 5"},
   CellID->607785828],
  Cell[5150, 172, 460, 14, 70, "Text",
   CellTags->"b:6.6",
   CellID->99531263],
  Cell[5647, 191, 99, 2, 70, "Section",
   CellTags->{"i:44", "b:6.6", "net: 6"},
   CellID->35293807],
  Cell[5749, 195, 497, 13, 70, "Text",
   CellTags->"b:6.6",
   CellID->83537740],
  Cell[6283, 213, 85, 2, 70, "Section",
   CellTags->{"i:33", "b:6.6", "net: 7"},
   CellID->885871868],
  Cell[6371, 217, 931, 21, 70, "Text",
   CellTags->{"b:6.6", "i:1"},
   CellID->121235165],
  Cell[7339, 243, 84, 2, 70, "Section",
   CellTags->{"i:34", "b:6.6", "net: 8"},
   CellID->48411114],
  Cell[7426, 247, 176, 5, 70, "BulletedText",
   CellTags->"b:6.6",
   CellID->277543901],
  Cell[7605, 254, 411, 10, 70, "BulletedText",
   CellTags->"b:6.6",
   CellID->25502846],
  Cell[8019, 266, 447, 13, 70, "BulletedText",
   CellTags->"b:6.6",
   CellID->377019733],
  Cell[8503, 284, 87, 2, 70, "Section",
   CellTags->{"b:6.6", "net: 9"},
   CellID->72359729],
  Cell[8593, 288, 1017, 25, 70, "Text",
   CellTags->"b:6.6",
   CellID->71766734]},
 "i:43"->{
  Cell[1880, 63, 81, 2, 70, "Section",
   CellTags->{"i:43", "b:6.6", "net: 2"},
   CellID->644882754]},
 "net: 2"->{
  Cell[1880, 63, 81, 2, 70, "Section",
   CellTags->{"i:43", "b:6.6", "net: 2"},
   CellID->644882754]},
 "i:41"->{
  Cell[2386, 80, 613, 16, 70, "BulletedText",
   CellTags->{"i:41", "b:6.6"},
   CellID->583128688]},
 "i:36"->{
  Cell[3036, 101, 90, 2, 70, "Section",
   CellTags->{"i:36", "b:6.6", "net: 3"},
   CellID->92956338]},
 "net: 3"->{
  Cell[3036, 101, 90, 2, 70, "Section",
   CellTags->{"i:36", "b:6.6", "net: 3"},
   CellID->92956338]},
 "i:38"->{
  Cell[3304, 114, 87, 2, 70, "Section",
   CellTags->{"i:38", "b:6.6", "net: 4"},
   CellID->65197241]},
 "net: 4"->{
  Cell[3304, 114, 87, 2, 70, "Section",
   CellTags->{"i:38", "b:6.6", "net: 4"},
   CellID->65197241]},
 "i:39"->{
  Cell[5063, 168, 84, 2, 70, "Section",
   CellTags->{"i:39", "b:6.6", "net: 5"},
   CellID->607785828]},
 "net: 5"->{
  Cell[5063, 168, 84, 2, 70, "Section",
   CellTags->{"i:39", "b:6.6", "net: 5"},
   CellID->607785828]},
 "i:44"->{
  Cell[5647, 191, 99, 2, 70, "Section",
   CellTags->{"i:44", "b:6.6", "net: 6"},
   CellID->35293807]},
 "net: 6"->{
  Cell[5647, 191, 99, 2, 70, "Section",
   CellTags->{"i:44", "b:6.6", "net: 6"},
   CellID->35293807]},
 "i:33"->{
  Cell[6283, 213, 85, 2, 70, "Section",
   CellTags->{"i:33", "b:6.6", "net: 7"},
   CellID->885871868]},
 "net: 7"->{
  Cell[6283, 213, 85, 2, 70, "Section",
   CellTags->{"i:33", "b:6.6", "net: 7"},
   CellID->885871868]},
 "i:1"->{
  Cell[6371, 217, 931, 21, 70, "Text",
   CellTags->{"b:6.6", "i:1"},
   CellID->121235165]},
 "i:34"->{
  Cell[7339, 243, 84, 2, 70, "Section",
   CellTags->{"i:34", "b:6.6", "net: 8"},
   CellID->48411114]},
 "net: 8"->{
  Cell[7339, 243, 84, 2, 70, "Section",
   CellTags->{"i:34", "b:6.6", "net: 8"},
   CellID->48411114]},
 "net: 9"->{
  Cell[8503, 284, 87, 2, 70, "Section",
   CellTags->{"b:6.6", "net: 9"},
   CellID->72359729]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:2", 12157, 381},
 {"b:6.6", 12248, 385},
 {"i:43", 14227, 449},
 {"net: 2", 14345, 453},
 {"i:41", 14461, 457},
 {"i:36", 14574, 461},
 {"net: 3", 14692, 465},
 {"i:38", 14808, 469},
 {"net: 4", 14926, 473},
 {"i:39", 15042, 477},
 {"net: 5", 15161, 481},
 {"i:44", 15278, 485},
 {"net: 6", 15396, 489},
 {"i:33", 15512, 493},
 {"net: 7", 15631, 497},
 {"i:1", 15747, 501},
 {"i:34", 15852, 505},
 {"net: 8", 15970, 509},
 {"net: 9", 16088, 513}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 86, 2, 70, "Title",
 CellTags->"i:2",
 CellID->6194508],
Cell[1654, 52, 201, 7, 70, "Text",
 CellTags->"b:6.6",
 CellID->257087412],
Cell[CellGroupData[{
Cell[1880, 63, 81, 2, 70, "Section",
 CellTags->{"i:43", "b:6.6", "net: 2"},
 CellID->644882754],
Cell[1964, 67, 419, 11, 70, "BulletedText",
 CellTags->"b:6.6",
 CellID->668445527],
Cell[2386, 80, 613, 16, 70, "BulletedText",
 CellTags->{"i:41", "b:6.6"},
 CellID->583128688]
}, Open  ]],
Cell[CellGroupData[{
Cell[3036, 101, 90, 2, 70, "Section",
 CellTags->{"i:36", "b:6.6", "net: 3"},
 CellID->92956338],
Cell[3129, 105, 138, 4, 70, "Text",
 CellTags->"b:6.6",
 CellID->197661444]
}, Open  ]],
Cell[CellGroupData[{
Cell[3304, 114, 87, 2, 70, "Section",
 CellTags->{"i:38", "b:6.6", "net: 4"},
 CellID->65197241],
Cell[3394, 118, 1067, 29, 70, "Text",
 CellTags->"b:6.6",
 CellID->24605077],
Cell[4464, 149, 562, 14, 70, "Text",
 CellTags->"b:6.6",
 CellID->89278830]
}, Open  ]],
Cell[CellGroupData[{
Cell[5063, 168, 84, 2, 70, "Section",
 CellTags->{"i:39", "b:6.6", "net: 5"},
 CellID->607785828],
Cell[5150, 172, 460, 14, 70, "Text",
 CellTags->"b:6.6",
 CellID->99531263]
}, Open  ]],
Cell[CellGroupData[{
Cell[5647, 191, 99, 2, 70, "Section",
 CellTags->{"i:44", "b:6.6", "net: 6"},
 CellID->35293807],
Cell[5749, 195, 497, 13, 70, "Text",
 CellTags->"b:6.6",
 CellID->83537740]
}, Open  ]],
Cell[CellGroupData[{
Cell[6283, 213, 85, 2, 70, "Section",
 CellTags->{"i:33", "b:6.6", "net: 7"},
 CellID->885871868],
Cell[6371, 217, 931, 21, 70, "Text",
 CellTags->{"b:6.6", "i:1"},
 CellID->121235165]
}, Open  ]],
Cell[CellGroupData[{
Cell[7339, 243, 84, 2, 70, "Section",
 CellTags->{"i:34", "b:6.6", "net: 8"},
 CellID->48411114],
Cell[7426, 247, 176, 5, 70, "BulletedText",
 CellTags->"b:6.6",
 CellID->277543901],
Cell[7605, 254, 411, 10, 70, "BulletedText",
 CellTags->"b:6.6",
 CellID->25502846],
Cell[8019, 266, 447, 13, 70, "BulletedText",
 CellTags->"b:6.6",
 CellID->377019733]
}, Open  ]],
Cell[CellGroupData[{
Cell[8503, 284, 87, 2, 70, "Section",
 CellTags->{"b:6.6", "net: 9"},
 CellID->72359729],
Cell[8593, 288, 1017, 25, 70, "Text",
 CellTags->"b:6.6",
 CellID->71766734],
Cell[CellGroupData[{
Cell[9635, 317, 72, 1, 70, "RelatedTutorialsSection",
 CellID->361026799],
Cell[9710, 320, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[9927, 327, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[10187, 337, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

