(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25763,        945]
NotebookOptionsPosition[     18710,        721]
NotebookOutlinePosition[     21869,        800]
CellTagsIndexPosition[     21777,        794]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLEndPacket" :> 
          Documentation`HelpLookup["paclet:ref/c/MLEndPacket"], 
          "MLEvaluateString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLEvaluateString"], 
          "$CurrentLink" :> 
          Documentation`HelpLookup["paclet:ref/$CurrentLink"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLEndPacket\"\>", 
       2->"\<\"MLEvaluateString\"\>", 
       3->"\<\"$CurrentLink\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Two\[Hyphen]Way Communication with External Programs\
\>", "Title",
 CellTags->{"S2.13.9", "9.1"},
 CellID->13500],

Cell[TextData[{
 "When you install a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible external program using ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 ", the program is set up to behave somewhat like a simplified ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. Every time you call a function in the external program, a ",
 Cell[BoxData[
  ButtonBox["CallPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CallPacket"]], "InlineFormula"],
 " is sent to the program, and the program responds by sending back a result \
wrapped in a ",
 Cell[BoxData[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->6615],

Cell[TextData[{
 "This installs an external program, returning the ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 " used for the connection to that program. "
}], "MathCaption",
 CellID->12709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"Install", "[", "\"\<bitsprog\>\"", "]"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->24072],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"bitsprog", ",", "4", ",", "4"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->25061]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData["ExternalCall"], "InlineFormula"],
 " sends a ",
 Cell[BoxData[
  ButtonBox["CallPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CallPacket"]], "InlineFormula"],
 " to the external program. "
}], "MathCaption",
 CellID->19952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "bits"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->10970],

Cell[CellGroupData[{

Cell[BoxData["\<\"Global`bits\"\>"], "Print",
 CellID->22823],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"bits", "[", "i_Integer", "]"}], ":=", 
         RowBox[{"ExternalCall", "[", 
          RowBox[{
           RowBox[{"LinkObject", "[", 
            RowBox[{"\<\"bitsprog\"\>", ",", "4", ",", "4"}], "]"}], ",", 
           RowBox[{"CallPacket", "[", 
            RowBox[{"0", ",", 
             RowBox[{"{", "i", "}"}]}], "]"}]}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[bits],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->18064]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "You can send the ",
 Cell[BoxData[
  ButtonBox["CallPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CallPacket"]], "InlineFormula"],
 " explicitly using ",
 Cell[BoxData[
  ButtonBox["LinkWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkWrite"]], "InlineFormula"],
 ". The first argument of the ",
 Cell[BoxData[
  ButtonBox["CallPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CallPacket"]], "InlineFormula"],
 " specifies which function in the external program to call. "
}], "MathCaption",
 CellID->32537],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"CallPacket", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "67", "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->22050],

Cell[TextData[{
 "Here is the response to the ",
 Cell[BoxData[
  ButtonBox["CallPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CallPacket"]], "InlineFormula"],
 " from the external program. "
}], "MathCaption",
 CellID->1610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->28791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->12978]
}, Open  ]],

Cell[TextData[{
 "If you use ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " several times on a single external program, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will open several ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections to the program. Each connection will however always correspond \
to a unique ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->22443],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$CurrentLink",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$CurrentLink"], Cell[TextData[{
     "the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection to the external program currently being run"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7161],

Cell["\<\
Identifying different instances of a single external program. \
\>", "Caption",
 CellID->4821],

Cell["\<\
:Begin:
:Function:      addto\
\>", "Program",
 CellID->22298],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  ButtonBox["$CurrentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CurrentLink"]], "InlineFormula"],
 " as an argument to ",
 Cell[BoxData["addto"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->15183],

Cell[":Pattern:       addto[$CurrentLink, n_Integer]", "Program",
 CellID->16933],

Cell[TextData[{
 ":Arguments:     ",
 Cell[BoxData[
  FormBox[
   StyleBox["{", "TR"], TraditionalForm]], "InlineFormula"],
 "n",
 Cell[BoxData[
  FormBox[
   StyleBox["}", "TR"], TraditionalForm]], "InlineFormula"],
 "\n:ArgumentTypes: ",
 Cell[BoxData[
  FormBox[
   StyleBox["{", "TR"], TraditionalForm]], "InlineFormula"],
 "Integer",
 Cell[BoxData[
  FormBox[
   StyleBox["}", "TR"], TraditionalForm]], "InlineFormula"],
 "\n:ReturnType:    Integer\n:End:\n"
}], "Program",
 CellID->8695],

Cell[TextData[{
 "This zeros the global variable ",
 Cell[BoxData["counter"], "InlineFormula"],
 " every time the program is started."
}], "MathCaption",
 CellID->14709],

Cell["\<\
int counter = 0;
\
\>", "Program",
 CellID->21072],

Cell[TextData[{
 "int addto(int n) ",
 Cell[BoxData[
  FormBox[
   StyleBox["{", "TR"], TraditionalForm]], "InlineFormula"],
 "\n    counter += n;\n    return counter;\n",
 Cell[BoxData[
  FormBox[
   StyleBox["}", "TR"], TraditionalForm]], "InlineFormula"]
}], "Program",
 CellID->7468],

Cell[TextData[{
 "This installs one instance of the external program containing ",
 Cell[BoxData["addto"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ct1", "=", 
  RowBox[{"Install", "[", "\"\<addtoprog\>\"", "]"}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->30845],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"addtoprog", ",", "5", ",", "5"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->1849]
}, Open  ]],

Cell["This installs another instance. ", "MathCaption",
 CellID->9050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ct2", "=", 
  RowBox[{"Install", "[", "\"\<addtoprog\>\"", "]"}]}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->28646],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"addtoprog", ",", "6", ",", "6"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->31142]
}, Open  ]],

Cell["\<\
This adds 10 to the counter in the first instance of the external program. \
\>", "MathCaption",
 CellID->22444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"addto", "[", 
  RowBox[{"ct1", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->12155],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->26459]
}, Open  ]],

Cell["\<\
This adds 15 to the counter in the second instance of the external program. \
\>", "MathCaption",
 CellID->768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"addto", "[", 
  RowBox[{"ct2", ",", "15"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->8885],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->30301]
}, Open  ]],

Cell["This operates on the first instance of the program again. ", \
"MathCaption",
 CellID->9847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"addto", "[", 
  RowBox[{"ct1", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->32606],

Cell[BoxData["30"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->3187]
}, Open  ]],

Cell[TextData[{
 "If an external program maintains information about its state then you can \
use different instances of the program to represent different states. ",
 Cell[BoxData[
  ButtonBox["$CurrentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CurrentLink"]], "InlineFormula"],
 " then provides a way to refer to each instance of the program. "
}], "Text",
 CellID->14535],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  ButtonBox["$CurrentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CurrentLink"]], "InlineFormula"],
 " is temporarily set every time a particular instance of the program is \
called, as well as when each instance of the program is first installed. "
}], "Text",
 CellID->10309],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLEvaluateString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLEvaluateString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "send input to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " but return no results"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28364],

Cell[TextData[{
 "Sending a string for evaluation by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->17633],

Cell[TextData[{
 "The two\[Hyphen]way nature of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections allows you not only to have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " call an external program, but also to have that external program call back \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->19351],

Cell[TextData[{
 "In the simplest case, you can use the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  RowBox[{"MLEvaluateString", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to send a string to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will evaluate this string, producing whatever effects the string \
specifies, but it will not return any results from the evaluation back to the \
external program. "
}], "Text",
 CellID->19140],

Cell[TextData[{
 "To get results back you need explicitly to send an ",
 Cell[BoxData[
  ButtonBox["EvaluatePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFormula"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and then read the contents of the ",
 Cell[BoxData[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"]], "InlineFormula"],
 " that comes back. "
}], "Text",
 CellID->18625],

Cell[TextData[{
 "This starts an ",
 Cell[BoxData[
  ButtonBox["EvaluatePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3200],

Cell["MLPutFunction(stdlink, \"EvaluatePacket\", 1);", "Program",
 CellID->20838],

Cell[TextData[{
 "This constructs the expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Factorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factorial"], "[", "7", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"7", "!"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->26031],

Cell["\<\
  MLPutFunction(stdlink, \"Factorial\", 1);
    MLPutInteger32(stdlink, 7);\
\>", "Program",
 CellID->11221],

Cell["\<\
This specifies that the packet you are constructing is finished. \
\>", "MathCaption",
 CellID->3217],

Cell["\<\
MLEndPacket(stdlink);
\
\>", "Program",
 CellID->23624],

Cell[TextData[{
 "This checks the ",
 Cell[BoxData[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"]], "InlineFormula"],
 " that comes back. "
}], "MathCaption",
 CellID->13584],

Cell["MLCheckFunction(stdlink, \"ReturnPacket\", &n);", "Program",
 CellID->14815],

Cell[TextData[{
 "This extracts the integer result for ",
 Cell[BoxData[
  RowBox[{"7", "!"}]], "InlineFormula"],
 " from the packet. "
}], "MathCaption",
 CellID->2344],

Cell["MLGetInteger32(stdlink, &ans);", "Program",
 CellID->8352],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLEndPacket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLEndPacket"], 
     RowBox[{"(", "stdlink", ")"}]}], Cell[TextData[{
     "specify that a packet is finished and ready to be sent to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11367],

Cell[TextData[{
 "Sending a packet to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->8919],

Cell[TextData[{
 "When you can send ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " an ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "[", 
   StyleBox["input", "TI"], "]"}]], "InlineFormula"],
 ", it may in general produce many packets in response, but the final packet \
should be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "[", 
   StyleBox["output", "TI"], "]"}]], "InlineFormula"],
 ".\[NonBreakingSpace]\"",
 ButtonBox["Manipulating Expressions in External Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingExpressionsInExternalPrograms"],
 "\" will discuss how to handle sequences of packets and expressions whose \
structure you do not know in advance. "
}], "Text",
 CellID->32174],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->18560907],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Two-Way Communication with External Programs - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CallingSubsidiaryMathematicaProcesses"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/RunningProgramsOnRemoteComputers"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 27.1722074}", "context" -> "", 
    "keywords" -> {
     "CallPacket", "EvaluatePacket", "ExternalCall", "install", "LinkObject", 
      "MLEndPacket()", "MLEvaluateString()", "multiple invocations", 
      "Twoway communication", "CurrentLink"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "When you install a MathLink-compatible external program using Install, \
the program is set up to behave somewhat like a simplified Mathematica \
kernel. Every time you call a function in the external program, a CallPacket \
is sent to the program, and the program responds by sending back a result \
wrapped in a ReturnPacket. This installs an external program, returning the \
LinkObject used for the connection to that program. The function ExternalCall \
sends a CallPacket to the external program. ", "synonyms" -> {"2.13.9"}, 
    "title" -> "Two-Way Communication with External Programs", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/TwoWayCommunicationWithExternalPrograms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.9"->{
  Cell[2150, 65, 124, 4, 70, "Title",
   CellTags->{"S2.13.9", "9.1"},
   CellID->13500]},
 "9.1"->{
  Cell[2150, 65, 124, 4, 70, "Title",
   CellTags->{"S2.13.9", "9.1"},
   CellID->13500]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.9", 21562, 783},
 {"9.1", 21663, 787}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1525, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2150, 65, 124, 4, 70, "Title",
 CellTags->{"S2.13.9", "9.1"},
 CellID->13500],
Cell[2277, 71, 815, 25, 70, "Text",
 CellID->6615],
Cell[3095, 98, 273, 8, 70, "MathCaption",
 CellID->12709],
Cell[CellGroupData[{
Cell[3393, 110, 141, 4, 28, "Input",
 CellID->24072],
Cell[3537, 116, 232, 7, 36, "Output",
 CellID->25061]
}, Open  ]],
Cell[3784, 126, 284, 10, 70, "MathCaption",
 CellID->19952],
Cell[CellGroupData[{
Cell[4093, 140, 87, 3, 70, "Input",
 CellID->10970],
Cell[CellGroupData[{
Cell[4205, 147, 61, 1, 70, "Print",
 CellID->22823],
Cell[4269, 150, 1060, 30, 70, "Print",
 CellID->18064]
}, Open  ]]
}, Open  ]],
Cell[5356, 184, 558, 18, 70, "MathCaption",
 CellID->32537],
Cell[5917, 204, 218, 7, 70, "Input",
 CellID->22050],
Cell[6138, 213, 237, 8, 70, "MathCaption",
 CellID->1610],
Cell[CellGroupData[{
Cell[6400, 225, 104, 3, 70, "Input",
 CellID->28791],
Cell[6507, 230, 254, 8, 36, "Output",
 CellID->12978]
}, Open  ]],
Cell[6776, 241, 569, 20, 70, "Text",
 CellID->22443],
Cell[7348, 263, 612, 18, 70, "DefinitionBox",
 CellID->7161],
Cell[7963, 283, 104, 3, 70, "Caption",
 CellID->4821],
Cell[8070, 288, 72, 4, 70, "Program",
 CellID->22298],
Cell[8145, 294, 264, 10, 70, "MathCaption",
 CellID->15183],
Cell[8412, 306, 81, 1, 70, "Program",
 CellID->16933],
Cell[8496, 309, 493, 19, 70, "Program",
 CellID->8695],
Cell[8992, 330, 169, 5, 70, "MathCaption",
 CellID->14709],
Cell[9164, 337, 60, 4, 70, "Program",
 CellID->21072],
Cell[9227, 343, 287, 10, 70, "Program",
 CellID->7468],
Cell[9517, 355, 165, 5, 70, "MathCaption",
 CellID->12864],
Cell[CellGroupData[{
Cell[9707, 364, 142, 4, 70, "Input",
 CellID->30845],
Cell[9852, 370, 233, 7, 36, "Output",
 CellID->1849]
}, Open  ]],
Cell[10100, 380, 70, 1, 70, "MathCaption",
 CellID->9050],
Cell[CellGroupData[{
Cell[10195, 385, 142, 4, 70, "Input",
 CellID->28646],
Cell[10340, 391, 234, 7, 36, "Output",
 CellID->31142]
}, Open  ]],
Cell[10589, 401, 122, 3, 70, "MathCaption",
 CellID->22444],
Cell[CellGroupData[{
Cell[10736, 408, 125, 4, 70, "Input",
 CellID->12155],
Cell[10864, 414, 157, 5, 36, "Output",
 CellID->26459]
}, Open  ]],
Cell[11036, 422, 121, 3, 70, "MathCaption",
 CellID->768],
Cell[CellGroupData[{
Cell[11182, 429, 124, 4, 70, "Input",
 CellID->8885],
Cell[11309, 435, 157, 5, 36, "Output",
 CellID->30301]
}, Open  ]],
Cell[11481, 443, 98, 2, 70, "MathCaption",
 CellID->9847],
Cell[CellGroupData[{
Cell[11604, 449, 125, 4, 70, "Input",
 CellID->32606],
Cell[11732, 455, 156, 5, 36, "Output",
 CellID->3187]
}, Open  ]],
Cell[11903, 463, 388, 9, 70, "Text",
 CellID->14535],
Cell[12294, 474, 338, 9, 70, "Text",
 CellID->10309],
Cell[12635, 485, 880, 26, 70, "DefinitionBox",
 CellID->28364],
Cell[13518, 513, 141, 6, 70, "Caption",
 CellID->17633],
Cell[13662, 521, 360, 13, 70, "Text",
 CellID->19351],
Cell[14025, 536, 538, 18, 70, "Text",
 CellID->19140],
Cell[14566, 556, 478, 16, 70, "Text",
 CellID->18625],
Cell[15047, 574, 206, 8, 70, "MathCaption",
 CellID->3200],
Cell[15256, 584, 81, 1, 70, "Program",
 CellID->20838],
Cell[15340, 587, 308, 12, 70, "MathCaption",
 CellID->26031],
Cell[15651, 601, 118, 4, 70, "Program",
 CellID->11221],
Cell[15772, 607, 111, 3, 70, "MathCaption",
 CellID->3217],
Cell[15886, 612, 65, 4, 70, "Program",
 CellID->23624],
Cell[15954, 618, 220, 8, 70, "MathCaption",
 CellID->13584],
Cell[16177, 628, 82, 1, 70, "Program",
 CellID->14815],
Cell[16262, 631, 169, 6, 70, "MathCaption",
 CellID->2344],
Cell[16434, 639, 64, 1, 70, "Program",
 CellID->8352],
Cell[16501, 642, 661, 19, 70, "DefinitionBox",
 CellID->11367],
Cell[17165, 663, 125, 6, 70, "Caption",
 CellID->8919],
Cell[17293, 671, 886, 26, 70, "Text",
 CellID->32174],
Cell[CellGroupData[{
Cell[18204, 701, 71, 1, 70, "RelatedTutorialsSection",
 CellID->18560907],
Cell[18278, 704, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[18683, 719, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

