(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21939,        793]
NotebookOptionsPosition[     16392,        607]
NotebookOutlinePosition[     18794,        672]
CellTagsIndexPosition[     18703,        666]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/NumbersOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numbers\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex" :> Documentation`HelpLookup["paclet:ref/Complex"], 
          "EvenQ" :> Documentation`HelpLookup["paclet:ref/EvenQ"], "Head" :> 
          Documentation`HelpLookup["paclet:ref/Head"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"], "Integer" :> 
          Documentation`HelpLookup["paclet:ref/Integer"], "IntegerQ" :> 
          Documentation`HelpLookup["paclet:ref/IntegerQ"], "NumberQ" :> 
          Documentation`HelpLookup["paclet:ref/NumberQ"], "OddQ" :> 
          Documentation`HelpLookup["paclet:ref/OddQ"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"], "Rational" :> 
          Documentation`HelpLookup["paclet:ref/Rational"], "Real" :> 
          Documentation`HelpLookup["paclet:ref/Real"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Complex\"\>", 2->"\<\"EvenQ\"\>", 
       3->"\<\"Head\"\>", 4->"\<\"I\"\>", 5->"\<\"Integer\"\>", 
       6->"\<\"IntegerQ\"\>", 7->"\<\"NumberQ\"\>", 8->"\<\"OddQ\"\>", 
       9->"\<\"PrimeQ\"\>", 10->"\<\"Rational\"\>", 
       11->"\<\"Real\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Types of Numbers", "Title",
 CellTags->{"S3.1.1", "1.1"},
 CellID->31699],

Cell[TextData[{
 "Four underlying types of numbers are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->25162],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"], Cell[
    "arbitrary\[Hyphen]length exact integer", "TableText"]},
   {
    ButtonBox["Rational",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Rational"], Cell[TextData[{
     StyleBox["integer", "TI"],
     "/",
     StyleBox["integer", "TI"],
     " in lowest terms"
    }], "TableText"]},
   {
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], Cell[
    "approximate real number, with any specified precision", "TableText"]},
   {
    ButtonBox["Complex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complex"], Cell[TextData[{
     "complex number of the form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["number", "TI"], "+", 
       StyleBox["number", "TI"], " ", 
       ButtonBox["I",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/I"]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21685],

Cell[TextData[{
 "Intrinsic types of numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellID->16115],

Cell["\<\
Rational numbers always consist of a ratio of two integers, reduced to lowest \
terms. \
\>", "MathCaption",
 CellID->25321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"12344", "/", "2222"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->6502],

Cell[BoxData[
 FractionBox["6172", "1111"]], "Output",
 ImageSize->{37, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->28541]
}, Open  ]],

Cell["\<\
Approximate real numbers are distinguished by the presence of an explicit \
decimal point. \
\>", "MathCaption",
 CellID->7804],

Cell[CellGroupData[{

Cell[BoxData["5456."], "Input",
 CellLabel->"In[2]:= ",
 CellID->25573],

Cell[BoxData["5456.`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->10733]
}, Open  ]],

Cell["An approximate real number can have any number of digits. ", \
"MathCaption",
 CellID->11452],

Cell[CellGroupData[{

Cell[BoxData["4.54543523454543523453452345234543"], "Input",
 CellLabel->"In[3]:= ",
 CellID->7811],

Cell[BoxData["4.54543523454543523453452345234543`32.657575474117195"], \
"Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12229]
}, Open  ]],

Cell["Complex numbers can have integer or rational components. ", \
"MathCaption",
 CellID->2224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{
   RowBox[{"7", "/", "8"}], " ", "I"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->22159],

Cell[BoxData[
 RowBox[{"4", "+", 
  FractionBox[
   RowBox[{"7", " ", "\[ImaginaryI]"}], "8"]}]], "Output",
 ImageSize->{46, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->9983]
}, Open  ]],

Cell["They can also have approximate real number components. ", "MathCaption",
 CellID->31665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"5.6", " ", "I"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->3845],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"5.6`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->13950]
}, Open  ]],

Cell[BoxData[GridBox[{
   {"123", Cell["an exact integer", "TableText"]},
   {"123.", Cell["an approximate real number", "TableText"]},
   {"123.0000000000000", Cell[
    "an approximate real number with a certain precision", "TableText"]},
   {
    RowBox[{"123.", "+", "0.", 
     ButtonBox["I",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/I"]}], Cell[
    "a complex number with approximate real number components", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6826],

Cell["Several versions of the number 123. ", "Caption",
 CellID->8591],

Cell[TextData[{
 "You can distinguish different types of numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by looking at their heads. (Although numbers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " have heads like other expressions, they do not have explicit elements \
which you can extract.)"
}], "Text",
 CellID->26897],

Cell[TextData[{
 "The object ",
 Cell[BoxData["123"], "InlineFormula"],
 " is taken to be an exact integer, with head ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "123", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->22371],

Cell[BoxData["Integer"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->11986]
}, Open  ]],

Cell[TextData[{
 "The presence of an explicit decimal point makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treat ",
 Cell[BoxData["123."], "InlineFormula"],
 " as an approximate real number, with head ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "123.", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->15190],

Cell[BoxData["Real"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->5584]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NumberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberQ"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is any kind of number"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerQ"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is an integer"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EvenQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EvenQ"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is even"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OddQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OddQ"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is odd"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimeQ"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is a prime integer"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Head",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Head"], "[", 
     StyleBox["x", "TI"], "]", "===", 
     StyleBox["type", "TI"]}], Cell[
    "test the type of a number", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21906],

Cell["Tests for different types of numbers.", "Caption",
 CellID->5418],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " tests for any kind of number. "
}], "MathCaption",
 CellID->21622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "5.6", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->27719],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->29666]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["5."], "InlineFormula"],
 " is treated as a ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ", so ",
 Cell[BoxData[
  ButtonBox["IntegerQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerQ", "[", "5.", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->1991],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->30959]
}, Open  ]],

Cell[TextData[{
 "If you use complex numbers extensively, there is one subtlety you should be \
aware of. When you enter a number like ",
 Cell[BoxData["123."], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats it as an approximate real number, but assumes that its imaginary \
part is exactly zero. Sometimes you may want to enter approximate complex \
numbers with imaginary parts that are zero, but only to a certain precision."
}], "Text",
 CellID->9566],

Cell[TextData[{
 "When the imaginary part is the exact integer ",
 Cell[BoxData["0"], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " simplifies complex numbers to real ones. "
}], "MathCaption",
 CellID->17103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"123", "+", 
   RowBox[{"0", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->23279],

Cell[BoxData["Integer"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->30498]
}, Open  ]],

Cell[TextData[{
 "Here the imaginary part is only zero to a certain precision, so ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " retains the complex number form. "
}], "MathCaption",
 CellID->4867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"123.", "+", 
   RowBox[{"0.", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->21345],

Cell[BoxData["Complex"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->26103]
}, Open  ]],

Cell[TextData[{
 "The distinction between complex numbers whose imaginary parts are exactly \
zero, or are only zero to a certain precision, may seem like a pedantic one. \
However, when we discuss, for example, the interpretation of powers and roots \
of complex numbers in \"",
 ButtonBox["Functions That Do Not Have Unique Values",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FunctionsThatDoNotHaveUniqueValues"],
 "\", the distinction will become significant. "
}], "Text",
 CellID->17430],

Cell[TextData[{
 "One way to find out the type of a number in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is just to pick out its head using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Head",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Head"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ". For many purposes, however, it is better to use functions like ",
 Cell[BoxData[
  ButtonBox["IntegerQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerQ"]], "InlineFormula"],
 " which explicitly test for particular types. Functions like this are set up \
to return ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if their argument is manifestly of the required type, and to return ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " otherwise. As a result, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"], "[", "x", "]"}]], "InlineFormula"],
 " will give ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", unless ",
 Cell[BoxData["x"], "InlineFormula"],
 " has an explicit integer value."
}], "Text",
 CellID->30020],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->383108152],

Cell[TextData[ButtonBox["Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumbersOverview"]], "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Types of Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numbers", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/NumbersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericQuantities"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 27.7503472}", "context" -> "", 
    "keywords" -> {
     "approximate numbers", "complex", "complex numbers", "EvenQ", 
      "even numbers", "floating point numbers", "integer", "IntegerQ", 
      "NumberQ", "Numbers", "OddQ", "PrimeQ", "rational", "rational numbers", 
      "reals", "TrueQ"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Four underlying types of numbers are built into Mathematica. Intrinsic \
types of numbers in Mathematica. Rational numbers always consist of a ratio \
of two integers, reduced to lowest terms. ", "synonyms" -> {"3.1.1"}, "title" -> 
    "Types of Numbers", "type" -> "Tutorial", "uri" -> 
    "tutorial/TypesOfNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.1.1"->{
  Cell[2671, 70, 79, 2, 70, "Title",
   CellTags->{"S3.1.1", "1.1"},
   CellID->31699]},
 "1.1"->{
  Cell[2671, 70, 79, 2, 70, "Title",
   CellTags->{"S3.1.1", "1.1"},
   CellID->31699]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.1.1", 18492, 655},
 {"1.1", 18591, 659}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2046, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2671, 70, 79, 2, 70, "Title",
 CellTags->{"S3.1.1", "1.1"},
 CellID->31699],
Cell[2753, 74, 151, 6, 70, "Text",
 CellID->25162],
Cell[2907, 82, 1314, 41, 70, "DefinitionBox",
 CellID->21685],
Cell[4224, 125, 135, 6, 70, "Caption",
 CellID->16115],
Cell[4362, 133, 134, 4, 70, "MathCaption",
 CellID->25321],
Cell[CellGroupData[{
Cell[4521, 141, 95, 3, 28, "Input",
 CellID->6502],
Cell[4619, 146, 181, 6, 51, "Output",
 CellID->28541]
}, Open  ]],
Cell[4815, 155, 137, 4, 70, "MathCaption",
 CellID->7804],
Cell[CellGroupData[{
Cell[4977, 163, 71, 2, 28, "Input",
 CellID->25573],
Cell[5051, 167, 160, 5, 36, "Output",
 CellID->10733]
}, Open  ]],
Cell[5226, 175, 99, 2, 70, "MathCaption",
 CellID->11452],
Cell[CellGroupData[{
Cell[5350, 181, 99, 2, 70, "Input",
 CellID->7811],
Cell[5452, 185, 210, 6, 36, "Output",
 CellID->12229]
}, Open  ]],
Cell[5677, 194, 97, 2, 70, "MathCaption",
 CellID->2224],
Cell[CellGroupData[{
Cell[5799, 200, 136, 5, 70, "Input",
 CellID->22159],
Cell[5938, 207, 233, 8, 51, "Output",
 CellID->9983]
}, Open  ]],
Cell[6186, 218, 94, 1, 70, "MathCaption",
 CellID->31665],
Cell[CellGroupData[{
Cell[6305, 223, 113, 4, 70, "Input",
 CellID->3845],
Cell[6421, 229, 215, 7, 36, "Output",
 CellID->13950]
}, Open  ]],
Cell[6651, 239, 784, 19, 70, "DefinitionBox",
 CellID->6826],
Cell[7438, 260, 70, 1, 70, "Caption",
 CellID->8591],
Cell[7511, 263, 350, 10, 70, "Text",
 CellID->26897],
Cell[7864, 275, 278, 10, 70, "MathCaption",
 CellID->23213],
Cell[CellGroupData[{
Cell[8167, 289, 99, 3, 70, "Input",
 CellID->22371],
Cell[8269, 294, 161, 5, 36, "Output",
 CellID->11986]
}, Open  ]],
Cell[8445, 302, 369, 13, 70, "MathCaption",
 CellID->14662],
Cell[CellGroupData[{
Cell[8839, 319, 100, 3, 70, "Input",
 CellID->15190],
Cell[8942, 324, 157, 5, 36, "Output",
 CellID->5584]
}, Open  ]],
Cell[9114, 332, 2090, 73, 70, "DefinitionBox",
 CellID->21906],
Cell[11207, 407, 71, 1, 70, "Caption",
 CellID->5418],
Cell[11281, 410, 253, 9, 70, "MathCaption",
 CellID->21622],
Cell[CellGroupData[{
Cell[11559, 423, 102, 3, 70, "Input",
 CellID->27719],
Cell[11664, 428, 158, 5, 36, "Output",
 CellID->29666]
}, Open  ]],
Cell[11837, 436, 482, 19, 70, "MathCaption",
 CellID->16218],
Cell[CellGroupData[{
Cell[12344, 459, 101, 3, 70, "Input",
 CellID->1991],
Cell[12448, 464, 159, 5, 36, "Output",
 CellID->30959]
}, Open  ]],
Cell[12622, 472, 492, 11, 70, "Text",
 CellID->9566],
Cell[13117, 485, 240, 8, 70, "MathCaption",
 CellID->17103],
Cell[CellGroupData[{
Cell[13382, 497, 147, 5, 70, "Input",
 CellID->23279],
Cell[13532, 504, 162, 5, 36, "Output",
 CellID->30498]
}, Open  ]],
Cell[13709, 512, 205, 6, 70, "MathCaption",
 CellID->4867],
Cell[CellGroupData[{
Cell[13939, 522, 149, 5, 70, "Input",
 CellID->21345],
Cell[14091, 529, 162, 5, 36, "Output",
 CellID->26103]
}, Open  ]],
Cell[14268, 537, 501, 10, 70, "Text",
 CellID->17430],
Cell[14772, 549, 1323, 42, 70, "Text",
 CellID->30020],
Cell[CellGroupData[{
Cell[16120, 595, 72, 1, 70, "RelatedTutorialsSection",
 CellID->383108152],
Cell[16195, 598, 143, 3, 70, "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],
Cell[16365, 605, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

