(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16661,        687]
NotebookOptionsPosition[     10062,        477]
NotebookOutlinePosition[     13042,        561]
CellTagsIndexPosition[     12943,        555]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Radicals", "Title",
 CellID->33834132],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   RadicalBox["x", "n"], TraditionalForm]]]
}], "Section",
 CellID->804871384],

Cell[TextData[{
 "To get a radical, press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["2", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->473858435],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1269353969],

Cell[BoxData[
 SqrtBox[
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->929607685],

Cell["\<\
Type the radicand inside the placeholder (which is already selected).\
\>", "Text",
 CellTags->"fractions",
 CellID->972829870],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1558620479],

Cell[BoxData[
 SqrtBox[
  RowBox[{"x", "\[VerticalSeparator]"}]]], "Input",
 CellID->728864447],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["5", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellTags->"fractions",
 CellID->778038241],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["5", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->460789904],

Cell[BoxData[
 RadicalBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->669885446],

Cell["Type the index. ", "Text",
 CellID->1655413348],

Cell[TextData[{
 "Type ",
 Cell[BoxData["n"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1881492951],

Cell[BoxData[
 RadicalBox["x", 
  RowBox[{"n", "\[VerticalSeparator]"}]]], "Input",
 CellID->555325382],

Cell[TextData[{
 "Get out of the radical and down to the baseline by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->389765412],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->962156134],

Cell[BoxData[
 RowBox[{
  RadicalBox["x", "n"], "\[VerticalSeparator]"}]], "Input",
 CellID->406282228]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RadicalBox["x", "n"], 
    RadicalBox["y", "n"]}], TraditionalForm]]]
}], "Section",
 CellID->1534892183],

Cell[TextData[{
 "To get a radical, press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["2", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->1359351917],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1696632233],

Cell[BoxData[
 SqrtBox[
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->1010075165],

Cell["\<\
Type the radicand inside the placeholder (which is already selected).\
\>", "Text",
 CellTags->"fractions",
 CellID->475068620],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->134096794],

Cell[BoxData[
 SqrtBox[
  RowBox[{"x", "\[VerticalSeparator]"}]]], "Input",
 CellID->1054471055],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["5", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellTags->"fractions",
 CellID->1459966341],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["5", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->506142565],

Cell[BoxData[
 RadicalBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->555364188],

Cell["Type the index. ", "Text",
 CellID->1041977854],

Cell[TextData[{
 "Type ",
 Cell[BoxData["n"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1940134540],

Cell[BoxData[
 RadicalBox["x", 
  RowBox[{"n", "\[VerticalSeparator]"}]]], "Input",
 CellID->449517732],

Cell[TextData[{
 "Get out of the radical and down to the baseline by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->197051578],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->426087772],

Cell[BoxData[
 RowBox[{
  RadicalBox["x", "n"], "\[VerticalSeparator]"}]], "Input",
 CellID->1546704906],

Cell["Type the second radical in the same way as the first. ", "Text",
 CellID->179808207],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 ", type ",
 Cell[BoxData["y"], "InlineFormula"],
 ", press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 ", type ",
 Cell[BoxData["n"], "InlineFormula"],
 ", and press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->527043720],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RadicalBox["x", "n"], 
   RadicalBox["y", "n"]}], "\[VerticalSeparator]"}]], "Input",
 CellTags->"radicals",
 CellID->1801241812]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   RadicalBox[
    RowBox[{"x", " ", "y"}], "n"], TraditionalForm]]]
}], "Section",
 CellID->394162525],

Cell[TextData[{
 "To get a radical, press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["2", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->1849990327],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->1519184623],

Cell[BoxData[
 SqrtBox[
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->1502879578],

Cell["\<\
Type the expression in the placeholder (which is already selected).\
\>", "Text",
 CellTags->"fractions",
 CellID->194411432],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"x", " ", "y"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1150310537],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   RowBox[{"x", " ", "y"}], "\[VerticalSeparator]"}]]], "Input",
 CellID->1621405065],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["%", "KeyEvent"],
 " key at the same time to create an index."
}], "Text",
 CellID->1534930672],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->2006236540],

Cell[BoxData[
 RadicalBox[
  RowBox[{"x", " ", "y"}], 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"radicals",
 CellID->1176786233],

Cell["\<\
Type the index in the placeholder (which is already selected). \
\>", "Text",
 CellID->2069312808],

Cell[TextData[{
 "Type ",
 Cell[BoxData["n"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->442700891],

Cell[BoxData[
 RadicalBox[
  RowBox[{"x", " ", "y"}], 
  RowBox[{"n", "\[VerticalSeparator]"}]]], "Input",
 CellID->1590521829],

Cell[TextData[{
 "Get out of the radical and down to the baseline by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->23942147],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->816222640],

Cell[BoxData[
 RowBox[{
  RadicalBox[
   RowBox[{"x", " ", "y"}], "n"], "\[VerticalSeparator]"}]], "Input",
 CellTags->"radicals",
 CellID->128373444],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->223834124],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Radicals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingSquareRoots"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingVectors"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 33.0161070}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "To get a radical, press the Control key and the 2 key at the same time. \
Press Ctrl+2 or Ctrl+@. Type the radicand inside the placeholder (which is \
already selected).", "synonyms" -> {}, "title" -> "Typing Radicals", "type" -> 
    "Tutorial", "uri" -> "tutorial/TypingRadicals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "fractions"->{
  Cell[2100, 86, 137, 4, 70, "Text",
   CellTags->"fractions",
   CellID->972829870],
  Cell[2449, 104, 193, 8, 70, "Text",
   CellTags->"fractions",
   CellID->778038241],
  Cell[4613, 213, 137, 4, 70, "Text",
   CellTags->"fractions",
   CellID->475068620],
  Cell[4962, 231, 194, 8, 70, "Text",
   CellTags->"fractions",
   CellID->1459966341],
  Cell[7868, 371, 135, 4, 70, "Text",
   CellTags->"fractions",
   CellID->194411432]},
 "radicals"->{
  Cell[6922, 322, 167, 6, 70, "Input",
   CellTags->"radicals",
   CellID->1801241812],
  Cell[8624, 409, 162, 6, 70, "Input",
   CellTags->"radicals",
   CellID->1176786233],
  Cell[9542, 453, 150, 5, 70, "Input",
   CellTags->"radicals",
   CellID->128373444]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"fractions", 12205, 526},
 {"radicals", 12656, 542}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 51, 1, 70, "Title",
 CellID->33834132],
Cell[CellGroupData[{
Cell[1385, 49, 137, 7, 70, "Section",
 CellID->804871384],
Cell[1525, 58, 187, 7, 70, "Text",
 CellID->473858435],
Cell[1715, 67, 272, 11, 70, "MathCaption",
 CellID->1269353969],
Cell[1990, 80, 107, 4, 70, "Input",
 CellID->929607685],
Cell[2100, 86, 137, 4, 70, "Text",
 CellTags->"fractions",
 CellID->972829870],
Cell[2240, 92, 108, 5, 70, "MathCaption",
 CellID->1558620479],
Cell[2351, 99, 95, 3, 70, "Input",
 CellID->728864447],
Cell[2449, 104, 193, 8, 70, "Text",
 CellTags->"fractions",
 CellID->778038241],
Cell[2645, 114, 271, 11, 70, "MathCaption",
 CellID->460789904],
Cell[2919, 127, 115, 4, 70, "Input",
 CellID->669885446],
Cell[3037, 133, 53, 1, 70, "Text",
 CellID->1655413348],
Cell[3093, 136, 108, 5, 70, "MathCaption",
 CellID->1881492951],
Cell[3204, 143, 103, 3, 70, "Input",
 CellID->555325382],
Cell[3310, 148, 227, 7, 70, "Text",
 CellID->389765412],
Cell[3540, 157, 170, 7, 70, "MathCaption",
 CellID->962156134],
Cell[3713, 166, 103, 3, 70, "Input",
 CellID->406282228]
}, Open  ]],
Cell[CellGroupData[{
Cell[3853, 174, 180, 9, 70, "Section",
 CellID->1534892183],
Cell[4036, 185, 188, 7, 70, "Text",
 CellID->1359351917],
Cell[4227, 194, 272, 11, 70, "MathCaption",
 CellID->1696632233],
Cell[4502, 207, 108, 4, 70, "Input",
 CellID->1010075165],
Cell[4613, 213, 137, 4, 70, "Text",
 CellTags->"fractions",
 CellID->475068620],
Cell[4753, 219, 107, 5, 70, "MathCaption",
 CellID->134096794],
Cell[4863, 226, 96, 3, 70, "Input",
 CellID->1054471055],
Cell[4962, 231, 194, 8, 70, "Text",
 CellTags->"fractions",
 CellID->1459966341],
Cell[5159, 241, 271, 11, 70, "MathCaption",
 CellID->506142565],
Cell[5433, 254, 115, 4, 70, "Input",
 CellID->555364188],
Cell[5551, 260, 53, 1, 70, "Text",
 CellID->1041977854],
Cell[5607, 263, 108, 5, 70, "MathCaption",
 CellID->1940134540],
Cell[5718, 270, 103, 3, 70, "Input",
 CellID->449517732],
Cell[5824, 275, 227, 7, 70, "Text",
 CellID->197051578],
Cell[6054, 284, 170, 7, 70, "MathCaption",
 CellID->426087772],
Cell[6227, 293, 104, 3, 70, "Input",
 CellID->1546704906],
Cell[6334, 298, 90, 1, 70, "Text",
 CellID->179808207],
Cell[6427, 301, 492, 19, 70, "MathCaption",
 CellID->527043720],
Cell[6922, 322, 167, 6, 70, "Input",
 CellTags->"radicals",
 CellID->1801241812]
}, Open  ]],
Cell[CellGroupData[{
Cell[7126, 333, 162, 8, 70, "Section",
 CellID->394162525],
Cell[7291, 343, 188, 7, 70, "Text",
 CellID->1849990327],
Cell[7482, 352, 272, 11, 70, "MathCaption",
 CellID->1519184623],
Cell[7757, 365, 108, 4, 70, "Input",
 CellID->1502879578],
Cell[7868, 371, 135, 4, 70, "Text",
 CellTags->"fractions",
 CellID->194411432],
Cell[8006, 377, 131, 6, 70, "MathCaption",
 CellID->1150310537],
Cell[8140, 385, 120, 4, 70, "Input",
 CellID->1621405065],
Cell[8263, 391, 188, 7, 70, "Text",
 CellID->1534930672],
Cell[8454, 400, 167, 7, 70, "MathCaption",
 CellID->2006236540],
Cell[8624, 409, 162, 6, 70, "Input",
 CellTags->"radicals",
 CellID->1176786233],
Cell[8789, 417, 108, 3, 70, "Text",
 CellID->2069312808],
Cell[8900, 422, 107, 5, 70, "MathCaption",
 CellID->442700891],
Cell[9010, 429, 127, 4, 70, "Input",
 CellID->1590521829],
Cell[9140, 435, 226, 7, 70, "Text",
 CellID->23942147],
Cell[9369, 444, 170, 7, 70, "MathCaption",
 CellID->816222640],
Cell[9542, 453, 150, 5, 70, "Input",
 CellTags->"radicals",
 CellID->128373444],
Cell[CellGroupData[{
Cell[9717, 462, 72, 1, 70, "RelatedTutorialsSection",
 CellID->223834124],
Cell[9792, 465, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[10035, 475, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

